/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc.parallel;

import com.google.common.base.Preconditions;
import java.util.ArrayList;
import java.util.Deque;
import java.util.ListIterator;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.imr.IntensityMeasureRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sra.calc.parallel.MPJ_CondLossCalc;

public class ThreadedCondLossCalc {
    protected ERF[] erfs;
    protected ScalarIMR[] imrs;
    protected Site[] sites;
    protected Deque<MPJ_CondLossCalc.SiteResult> stack;
    private DiscretizedFunc magThreshFunc;

    public ThreadedCondLossCalc(ERF[] erfs, ScalarIMR[] imrs, DiscretizedFunc magThreshFunc) {
        Preconditions.checkNotNull((Object)erfs);
        Preconditions.checkNotNull((Object)imrs);
        Preconditions.checkArgument((imrs.length > 0 ? 1 : 0) != 0);
        for (ScalarIMR scalarIMR : imrs) {
            Preconditions.checkNotNull((Object)scalarIMR);
        }
        Preconditions.checkArgument((erfs.length > 0 ? 1 : 0) != 0);
        for (Comparable<IntensityMeasureRelationship> comparable : erfs) {
            Preconditions.checkNotNull(comparable);
        }
        if (erfs.length > 1) {
            Preconditions.checkState((erfs.length == imrs.length ? 1 : 0) != 0);
        }
        this.erfs = erfs;
        this.imrs = imrs;
        this.magThreshFunc = magThreshFunc;
        this.sites = new Site[imrs.length];
        for (int i = 0; i < imrs.length; ++i) {
            ScalarIMR imr = imrs[i];
            this.sites[i] = new Site(new Location(34.0, -118.0));
            ListIterator<Parameter<?>> it = imr.getSiteParamsIterator();
            while (it.hasNext()) {
                this.sites[i].addParameter((Parameter)((Parameter)it.next()).clone());
            }
        }
    }

    public synchronized MPJ_CondLossCalc.SiteResult popAsset() {
        try {
            return this.stack.pop();
        }
        catch (Exception e) {
            return null;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void calculateBatch(Deque<MPJ_CondLossCalc.SiteResult> stack) throws InterruptedException {
        this.stack = stack;
        int numThreads = this.imrs.length;
        ArrayList<CalcThread> threads = new ArrayList<CalcThread>();
        for (int i = 0; i < numThreads; ++i) {
            void var5_6;
            if (this.erfs.length > 1) {
                ERF eRF = this.erfs[i];
            } else {
                ERF eRF = this.erfs[0];
            }
            threads.add(new CalcThread((ERF)var5_6, this.imrs[i], this.sites[i]));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    public ERF[] getERFs() {
        return this.erfs;
    }

    public ScalarIMR[] getIMRs() {
        return this.imrs;
    }

    private class CalcThread
    extends Thread {
        private ScalarIMR imr;
        private Site site;
        private ERF erf;

        public CalcThread(ERF erf, ScalarIMR imr, Site site) {
            this.imr = imr;
            this.site = site;
            this.erf = erf;
        }

        @Override
        public void run() {
            MPJ_CondLossCalc.SiteResult result = ThreadedCondLossCalc.this.popAsset();
            while (result != null) {
                result.calculate(this.erf, this.imr, this.site, ThreadedCondLossCalc.this.magThreshFunc);
                result = ThreadedCondLossCalc.this.popAsset();
            }
        }
    }
}

