/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc.parallel.treeTrimming;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EpistemicListERF;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2_TimeDependentEpistemicList;

public class TreeTrimmingAssembler {
    public static double loadEAL(File file) throws IOException {
        BufferedReader br = new BufferedReader(new FileReader(file));
        String line = br.readLine();
        String[] split = line.split(" ");
        return Double.parseDouble(split[split.length - 1]);
    }

    private static CSVFile<String> prepareCSV(EpistemicListERF erfList) {
        ERF erf;
        int i;
        CSVFile<String> csv = new CSVFile<String>(true);
        System.out.println("preparing columns");
        HashMap<String, Integer> paramNamesMap = new HashMap<String, Integer>();
        ArrayList<String> paramNamesList = new ArrayList<String>();
        for (i = 0; i < erfList.getNumERFs(); ++i) {
            erf = erfList.getERF(i);
            System.out.println("ERF " + i);
            for (Parameter<?> param : erf.getAdjustableParameterList()) {
                if (paramNamesMap.containsKey(param.getName())) continue;
                paramNamesMap.put(param.getName(), paramNamesMap.size());
                paramNamesList.add(param.getName());
            }
        }
        System.out.println("assembling CSV");
        for (i = 0; i < erfList.getNumERFs(); ++i) {
            erf = erfList.getERF(i);
            if (i == 0) {
                ArrayList<String> header = new ArrayList<String>();
                header.add("ERF #");
                header.add("Portfolio EAL");
                for (String name : paramNamesList) {
                    header.add(name);
                }
                csv.addLine((List<String>)header);
            }
            ArrayList<Object> line = new ArrayList<Object>();
            line.add("" + i);
            line.add("");
            for (String name : paramNamesList) {
                line.add("");
            }
            for (Parameter param : erf.getAdjustableParameterList()) {
                int index = (Integer)paramNamesMap.get(param.getName()) + 2;
                line.set(index, param.getValue().toString());
            }
            csv.addLine((List<String>)line);
        }
        return csv;
    }

    public static void assemble(File dir, EpistemicListERF erfList, boolean includeBackSeis, CSVFile<String> csv) throws IOException {
        double[] eals = new double[erfList.getNumERFs()];
        double backSeis = 0.0;
        System.out.println("loading files from: " + dir.getAbsolutePath());
        for (File file : dir.listFiles()) {
            if (file.isDirectory() || !file.getName().endsWith(".txt")) continue;
            if (file.getName().contains("backseis")) {
                if (!includeBackSeis) continue;
                backSeis = TreeTrimmingAssembler.loadEAL(file);
                continue;
            }
            int i = Integer.parseInt(file.getName().split("_")[1].replaceAll(".txt", ""));
            eals[i] = TreeTrimmingAssembler.loadEAL(file);
        }
        if (includeBackSeis) {
            int i = 0;
            while (i < eals.length) {
                int n = i++;
                eals[n] = eals[n] + backSeis;
            }
        }
        Object fileName = dir.getName();
        if (includeBackSeis) {
            fileName = (String)fileName + "_incl_back_seis";
        }
        fileName = (String)fileName + ".csv";
        File output = new File(dir, (String)fileName);
        int backSeisIndex = csv.getLine(0).indexOf(UCERF2.BACK_SEIS_NAME);
        for (int i = 0; i < eals.length; ++i) {
            csv.set(i + 1, 1, "" + eals[i]);
            if (includeBackSeis) {
                csv.set(i + 1, backSeisIndex, UCERF2.BACK_SEIS_INCLUDE);
                continue;
            }
            csv.set(i + 1, backSeisIndex, UCERF2.BACK_SEIS_EXCLUDE);
        }
        System.out.println("Writing: " + output.getAbsolutePath());
        csv.writeToFile(output);
    }

    public static void main(String[] args) throws IOException {
        File mainDir = new File("/home/kevin/OpenSHA/portfolio_lec/parallel_eal/run4_compare");
        UCERF2_TimeDependentEpistemicList erfList = new UCERF2_TimeDependentEpistemicList();
        CSVFile<String> csv = CSVFile.readFile(new File(mainDir, "csv_inputs.csv"), true);
        TreeTrimmingAssembler.assemble(new File(mainDir, "AS2008"), erfList, false, csv);
        TreeTrimmingAssembler.assemble(new File(mainDir, "AS2008"), erfList, true, csv);
        TreeTrimmingAssembler.assemble(new File(mainDir, "Boore2008"), erfList, false, csv);
        TreeTrimmingAssembler.assemble(new File(mainDir, "Boore2008"), erfList, true, csv);
        TreeTrimmingAssembler.assemble(new File(mainDir, "CB2008"), erfList, false, csv);
        TreeTrimmingAssembler.assemble(new File(mainDir, "CB2008"), erfList, true, csv);
        TreeTrimmingAssembler.assemble(new File(mainDir, "CY2008"), erfList, false, csv);
        TreeTrimmingAssembler.assemble(new File(mainDir, "CY2008"), erfList, true, csv);
    }
}

