/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc.parallel.treeTrimming;

import java.io.File;
import java.io.IOException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.hpc.mpj.FastMPJShellScriptWriter;
import org.opensha.commons.hpc.pbs.USC_HPCC_ScriptWriter;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.earthquake.AbstractERF;
import org.opensha.sha.earthquake.AbstractEpistemicListERF;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.imr.attenRelImpl.NSHMP_2008_CA;
import org.opensha.sra.calc.parallel.MPJ_EAL_Calc;
import scratch.UCERF3.erf.FaultSystemSolutionERF;

public class UCERF3_EAL_ScriptWriter {
    public static void main(String[] args) throws IOException {
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF();
        int listIndex = 0;
        IncludeBackgroundOption backSeisInclude = IncludeBackgroundOption.ONLY;
        BackgroundRupType backSeisType = BackgroundRupType.POINT;
        NSHMP_2008_CA imr = new NSHMP_2008_CA(null);
        int mins = 800;
        int nodes = 20;
        String queue = "nbns";
        File portfolioFile = new File("/home/scec-02/kmilner/tree_trimming/Porter-28-Mar-2012-CEA-proxy-pof.txt");
        File vulnFile = new File("/home/scec-02/kmilner/tree_trimming/2011_11_07_VUL06.txt");
        File solFile = new File("/home/scec-02/kmilner/ucerf3/inversion_compound_plots/2013_05_10-ucerf3p3-production-10runs/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip");
        Object jobName = "ucerf3_single_branch_only_point";
        erf.setParameter("Background Seismicity", (Object)backSeisInclude);
        erf.setParameter("Treat Background Seismicity As", (Object)backSeisType);
        erf.setParameter("Solution Input File", solFile);
        jobName = new SimpleDateFormat("yyyy_MM_dd").format(new Date()) + "-" + (String)jobName;
        File localDir = new File("/tmp", (String)jobName);
        File remoteDir = new File("/home/scec-02/kmilner/tree_trimming", (String)jobName);
        localDir.mkdir();
        imr.setParamDefaults();
        ArrayList<File> classpath = new ArrayList<File>();
        classpath.add(new File(remoteDir.getParentFile(), "OpenSHA_complete.jar"));
        classpath.add(new File(remoteDir.getParentFile(), "commons-cli-1.2.jar"));
        FastMPJShellScriptWriter mpjWrite = new FastMPJShellScriptWriter(USC_HPCC_ScriptWriter.JAVA_BIN, 8000, classpath, USC_HPCC_ScriptWriter.FMPJ_HOME);
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        if (erf instanceof AbstractEpistemicListERF) {
            ((AbstractEpistemicListERF)((Object)erf)).toXMLMetadata(root, listIndex);
        } else if (erf instanceof AbstractERF) {
            ((AbstractERF)erf).toXMLMetadata(root);
        } else {
            throw new RuntimeException("uh oh.");
        }
        imr.toXMLMetadata(root);
        String xmlName = (String)jobName + ".xml";
        File localXML = new File(localDir, xmlName);
        File remoteXML = new File(remoteDir, xmlName);
        XMLUtils.writeDocumentToFile(localXML, doc);
        File outputFile = new File(remoteDir, (String)jobName + ".txt");
        String argz = "--vuln-file " + vulnFile.getAbsolutePath() + " " + portfolioFile.getAbsolutePath() + " " + remoteXML.getAbsolutePath() + " " + outputFile.getAbsolutePath();
        List<String> script = mpjWrite.buildScript(MPJ_EAL_Calc.class.getName(), argz);
        File pbsFile = new File(localDir, (String)jobName + ".pbs");
        USC_HPCC_ScriptWriter usc = new USC_HPCC_ScriptWriter();
        script = usc.buildScript(script, mins, nodes, 8, queue);
        usc.writeScript(pbsFile, script);
    }
}

