/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.calc.portfolioLEC;

import java.util.Random;
import org.apache.commons.math3.distribution.NormalDistribution;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.imr.param.IntensityMeasureParams.SA_Param;
import org.opensha.sra.asset.Asset;
import org.opensha.sra.asset.Portfolio;
import org.opensha.sra.calc.portfolioLEC.AbstractPortfolioLECCalculator;
import org.opensha.sra.vulnerability.Vulnerability;
import org.opensha.sra.vulnerability.models.SimpleVulnerability;

public class MonteCarloPortfolioLECCalculator
extends AbstractPortfolioLECCalculator {
    private int numSimulations;

    public MonteCarloPortfolioLECCalculator(int numSimulations) {
        this.numSimulations = numSimulations;
    }

    @Override
    protected DiscretizedFunc[][] calcRuptureLECs(ScalarIMR imr, ERF erf, Portfolio portfolio, DiscretizedFunc function) {
        Random r1 = new Random();
        Random r2 = new Random();
        Random r3 = new Random();
        Random r4 = new Random();
        Random r5 = new Random();
        NormalDistribution normDist = new NormalDistribution();
        double sqrt2 = Math.sqrt(2.0);
        double oneDivN = 1.0 / (double)this.numSimulations;
        double[] mValue = new double[portfolio.size()];
        double[] betaVJs = new double[portfolio.size()];
        double[] medValue = new double[portfolio.size()];
        double[] hValue = new double[portfolio.size()];
        double[] lValue = new double[portfolio.size()];
        this.populateValues(portfolio, mValue, betaVJs, medValue, hValue, lValue);
        DiscretizedFunc[][] funcs = new DiscretizedFunc[erf.getNumSources()][];
        for (int sourceID = 0; sourceID < erf.getNumSources(); ++sourceID) {
            ProbEqkSource src = erf.getSource(sourceID);
            funcs[sourceID] = new DiscretizedFunc[src.getNumRuptures()];
            for (int rupID = 0; rupID < src.getNumRuptures(); ++rupID) {
                int i;
                ProbEqkRupture rup = src.getRupture(rupID);
                imr.setEqkRupture(rup);
                ArbitrarilyDiscretizedFunc lecForRup = new ArbitrarilyDiscretizedFunc();
                for (i = 0; i < function.size(); ++i) {
                    lecForRup.set(function.getX(i), 0.0);
                }
                for (int n = 0; n < this.numSimulations; ++n) {
                    double LsubNQ = 0.0;
                    double u1 = r1.nextDouble();
                    double u2 = r2.nextDouble();
                    double u4 = r4.nextDouble();
                    for (int j = 0; j < portfolio.size(); ++j) {
                        Asset asset = (Asset)portfolio.get(j);
                        Vulnerability vuln = asset.getVulnerability();
                        double dist = src.getMinDistance(asset.getSite());
                        if (dist > this.getMaxSiteSourceDistance()) continue;
                        String imt = vuln.getIMT();
                        imr.setIntensityMeasure(imt);
                        if (imt.equals("SA")) {
                            SA_Param.setPeriodInSA_Param(imr.getIntensityMeasure(), vuln.getPeriod());
                        }
                        imr.setSite(asset.getSite());
                        AbstractPortfolioLECCalculator.ShakingResult imrResult = this.calcShaking(imr);
                        AbstractDiscretizedFunc covFunc = ((SimpleVulnerability)vuln).getCOVFunction();
                        double deltaJ = covFunc.getInterpolatedY(imrResult.medIML);
                        imr.setEqkRupture(src.getRupture(rupID));
                        double u3 = r3.nextDouble();
                        double u5 = r5.nextDouble();
                        double vSubJNQ = medValue[j] * Math.exp(betaVJs[j] * normDist.inverseCumulativeProbability(u1));
                        double sSubJNQ = imrResult.medIML * Math.exp(imrResult.interSTD * normDist.inverseCumulativeProbability(u2)) * Math.exp(imrResult.intraSTD * normDist.inverseCumulativeProbability(u3));
                        double mDamage = vuln.getMeanDamageFactor(imrResult.medIML);
                        double medDamage = mDamage / Math.sqrt(1.0 + deltaJ * deltaJ);
                        double betaVJsubS = Math.sqrt(Math.log(1.0 + deltaJ * deltaJ));
                        double ySubJNQ = medDamage * Math.exp(betaVJsubS / sqrt2 * normDist.inverseCumulativeProbability(u4)) * Math.exp(betaVJsubS / sqrt2 * normDist.inverseCumulativeProbability(u5));
                        LsubNQ += vSubJNQ * ySubJNQ;
                    }
                    for (int i2 = 0; i2 < lecForRup.size(); ++i2) {
                        double l = lecForRup.getX(i2);
                        double lSubNQMinusL = LsubNQ - l;
                        if (!(lSubNQMinusL > 0.0)) continue;
                        lecForRup.set(i2, lecForRup.getY(i2) + 1.0);
                    }
                }
                for (i = 0; i < lecForRup.size(); ++i) {
                    lecForRup.set(i, oneDivN * lecForRup.getY(i));
                }
                funcs[sourceID][rupID] = lecForRup;
            }
        }
        return funcs;
    }
}

