/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.SystemColor;
import java.awt.Toolkit;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.IOException;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JSplitPane;
import javax.swing.JTabbedPane;
import javax.swing.JToolBar;
import javax.swing.Timer;
import javax.swing.UIManager;
import javax.swing.border.Border;
import org.apache.commons.lang3.SystemUtils;
import org.jfree.data.Range;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.gui.DisclaimerDialog;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotElement;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.util.ApplicationVersion;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.commons.util.bugReports.BugReport;
import org.opensha.commons.util.bugReports.BugReportDialog;
import org.opensha.commons.util.bugReports.DefaultExceptionHandler;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.calc.HazardCurveCalculatorAPI;
import org.opensha.sha.calc.params.MaxDistanceParam;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.ERF_Ref;
import org.opensha.sha.gui.beans.ERF_GuiBean;
import org.opensha.sha.gui.beans.IMR_GuiBean;
import org.opensha.sha.gui.beans.IMR_GuiBeanAPI;
import org.opensha.sha.gui.beans.Site_GuiBean;
import org.opensha.sha.gui.controls.CurveDisplayAppAPI;
import org.opensha.sha.gui.controls.PEER_TestCaseSelectorControlPanel;
import org.opensha.sha.gui.controls.SetMinSourceSiteDistanceControlPanel;
import org.opensha.sha.gui.controls.SetSiteParamsFromWebServicesControlPanel;
import org.opensha.sha.gui.controls.SitesOfInterestControlPanel;
import org.opensha.sha.gui.controls.XY_ValuesControlPanel;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sra.calc.LossCurveCalculator;
import org.opensha.sra.gui.components.VulnerabilityBean;
import org.opensha.sra.vulnerability.AbstractVulnerability;
import org.opensha.sra.vulnerability.Vulnerability;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseImmediateOccupancy;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseRigidDiaphram;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseTypical;
import org.opensha.sra.vulnerability.models.curee.caltech.CCLargeHouseWaistWall;
import org.opensha.sra.vulnerability.models.curee.caltech.CCSmallHouseRetro;
import org.opensha.sra.vulnerability.models.curee.caltech.CCSmallHouseTypical;
import org.opensha.sra.vulnerability.models.curee.caltech.CCTownhouseLimitedDrift;
import org.opensha.sra.vulnerability.models.curee.caltech.CCTownhouseTypical;
import org.opensha.sra.vulnerability.models.servlet.VulnerabilityServletAccessor;

public class LossEstimationApplication
extends JFrame
implements Runnable,
ParameterChangeListener,
CurveDisplayAppAPI,
IMR_GuiBeanAPI {
    public static final String APP_NAME = "Loss Estimation Application";
    public static final String APP_SHORT_NAME = "LossEstimationApp";
    private static final String C = "LossEstimationApplication";
    protected static final boolean D = false;
    protected ERF_GuiBean erfGuiBean;
    protected IMR_GuiBean imrGuiBean;
    protected Site_GuiBean siteGuiBean;
    protected VulnerabilityBean vulnBean;
    GraphWidget graphWidget;
    protected static final String CONTROL_PANELS = "Control Panels";
    protected static final String DISTANCE_CONTROL = "Max Source-Site Distance";
    protected static final String SITES_OF_INTEREST_CONTROL = "Sites of Interest";
    protected static final String CVM_CONTROL = "Set Site Params from Web Services";
    protected static final String XY_Values_Control = "Set external XY dataset";
    protected PEER_TestCaseSelectorControlPanel peerTestsControlPanel;
    protected SetMinSourceSiteDistanceControlPanel distanceControlPanel;
    protected SitesOfInterestControlPanel sitesOfInterest;
    protected SetSiteParamsFromWebServicesControlPanel cvmControlPanel;
    protected XY_ValuesControlPanel xyPlotControl;
    protected Insets defaultInsets = new Insets(4, 4, 4, 4);
    protected static final int W = 1100;
    protected static final int H = 820;
    protected List<PlotElement> functionList = Lists.newArrayList();
    protected String TITLE = new String("Loss Curves");
    private JPanel jPanel1 = new JPanel();
    private Border border2;
    private static final Dimension COMBO_DIM = new Dimension(180, 30);
    private static final Dimension BUTTON_DIM = new Dimension(80, 20);
    private Border border3;
    private Border border4;
    private Border border5;
    private Border border6;
    private Border border7;
    private Border border8;
    private JLabel openshaImgLabel = new JLabel(new ImageIcon(FileUtils.loadImage("logos/PoweredByOpenSHA_Agua.jpg")));
    private JLabel usgsImgLabel = new JLabel(new ImageIcon(FileUtils.loadImage("logos/usgs_resrisk.gif")));
    private JLabel riskAgoraImgLabel = new JLabel(new ImageIcon(FileUtils.loadImage("logos/AgoraOpenRisk.jpg")));
    private static final String OPENSHA_WEBSITE = "http://www.OpenSHA.org";
    JSplitPane topSplitPane = new JSplitPane();
    JButton clearButton = new JButton();
    JPanel buttonPanel = new JPanel();
    JCheckBox progressCheckBox = new JCheckBox();
    JButton addButton = new JButton();
    JComboBox controlComboBox = new JComboBox();
    JSplitPane chartSplit = new JSplitPane();
    JPanel panel = new JPanel();
    GridBagLayout gridBagLayout9 = new GridBagLayout();
    GridBagLayout gridBagLayout8 = new GridBagLayout();
    JSplitPane imrSplitPane = new JSplitPane();
    GridBagLayout gridBagLayout5 = new GridBagLayout();
    JPanel sitePanel = new JPanel();
    JPanel vulPanel = new JPanel();
    JSplitPane controlsSplit = new JSplitPane();
    JTabbedPane paramsTabbedPane = new JTabbedPane();
    JPanel erfPanel = new JPanel();
    GridBagLayout gridBagLayout15 = new GridBagLayout();
    GridBagLayout gridBagLayout13 = new GridBagLayout();
    GridBagLayout gridBagLayout12 = new GridBagLayout();
    JPanel imrPanel = new JPanel();
    GridBagLayout gridBagLayout10 = new GridBagLayout();
    BorderLayout borderLayout1 = new BorderLayout();
    HazardCurveCalculatorAPI calc;
    CalcProgressBar progressClass;
    protected CalcProgressBar startAppProgressClass;
    Timer timer;
    Thread calcThread;
    boolean isHazardCalcDone = false;
    private JButton peelOffButton = new JButton();
    JMenuBar menuBar = new JMenuBar();
    JMenu fileMenu = new JMenu();
    JMenuItem fileExitMenu = new JMenuItem();
    JMenuItem fileSaveMenu = new JMenuItem();
    JMenuItem filePrintMenu = new JCheckBoxMenuItem();
    JToolBar jToolBar = new JToolBar();
    JButton closeButton = new JButton();
    ImageIcon closeFileImage = new ImageIcon(FileUtils.loadImage("icons/closeFile.png"));
    JButton printButton = new JButton();
    ImageIcon printFileImage = new ImageIcon(FileUtils.loadImage("icons/printFile.jpg"));
    JButton saveButton = new JButton();
    ImageIcon saveFileImage = new ImageIcon(FileUtils.loadImage("icons/saveFile.jpg"));
    boolean addData = true;
    protected JButton cancelCalcButton = new JButton();
    private FlowLayout flowLayout1 = new FlowLayout();
    protected static ApplicationVersion version;
    protected static final String versionURL = "http://www.opensha.org/applications/hazCurvApp/HazardCurveApp_Version.txt";
    protected static final String appURL = "http://www.opensha.org/applications/hazCurvApp/HazardCurveServerModeApp.jar";
    protected static final String versionUpdateInfoURL = "http://www.opensha.org/applications/hazCurvApp/versionUpdate.html";

    public static ApplicationVersion getAppVersion() {
        if (version == null) {
            try {
                version = ApplicationVersion.loadBuildVersion();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        return version;
    }

    public static List<AbstractVulnerability> fetchVulns() throws IOException {
        VulnerabilityServletAccessor access = new VulnerabilityServletAccessor();
        ArrayList<AbstractVulnerability> vms = new ArrayList<AbstractVulnerability>();
        for (Vulnerability vuln : access.getVulnMap().values()) {
            if (!(vuln instanceof AbstractVulnerability)) continue;
            vms.add((AbstractVulnerability)vuln);
        }
        vms.add(new CCSmallHouseTypical());
        vms.add(new CCSmallHouseRetro());
        vms.add(new CCLargeHouseTypical());
        vms.add(new CCLargeHouseWaistWall());
        vms.add(new CCLargeHouseImmediateOccupancy());
        vms.add(new CCLargeHouseRigidDiaphram());
        vms.add(new CCTownhouseTypical());
        vms.add(new CCTownhouseLimitedDrift());
        return vms;
    }

    public void init() {
        try {
            this.initControlList();
            this.startAppProgressClass = new CalcProgressBar("Starting Application", "Initializing Application .. Please Wait");
            this.jbInit();
            this.initVulnerabilityGuiBean(LossEstimationApplication.fetchVulns());
            this.initIMR_GuiBean();
            this.initSiteGuiBean();
            try {
                this.initERF_GuiBean();
            }
            catch (RuntimeException e) {
                JOptionPane.showMessageDialog(this, "Connection to ERF's failed", "Internet Connection Problem", 0);
                e.printStackTrace();
                this.startAppProgressClass.dispose();
                System.exit(0);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            BugReport bug = new BugReport(e, "Exception occured while creating the GUI.\nNo Parameters have been set", APP_SHORT_NAME, LossEstimationApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
        this.startAppProgressClass.dispose();
        ((JPanel)this.getContentPane()).updateUI();
    }

    protected void jbInit() throws Exception {
        this.border2 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border3 = BorderFactory.createEmptyBorder();
        this.border4 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border5 = BorderFactory.createLineBorder(SystemColor.controlText, 1);
        this.border6 = BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(98, 98, 112), new Color(140, 140, 161));
        this.border7 = BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(98, 98, 112), new Color(140, 140, 161));
        this.border8 = BorderFactory.createBevelBorder(0, Color.white, Color.white, new Color(98, 98, 112), new Color(140, 140, 161));
        this.getContentPane().setLayout(this.borderLayout1);
        this.fileMenu.setText("File");
        this.fileExitMenu.setText("Exit");
        this.fileSaveMenu.setText("Save");
        this.filePrintMenu.setText("Print");
        this.fileExitMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LossEstimationApplication.this.fileExitMenu_actionPerformed(e);
            }
        });
        this.fileSaveMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LossEstimationApplication.this.fileSaveMenu_actionPerformed(e);
            }
        });
        this.filePrintMenu.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LossEstimationApplication.this.filePrintMenu_actionPerformed(e);
            }
        });
        this.closeButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LossEstimationApplication.this.closeButton_actionPerformed(actionEvent);
            }
        });
        this.printButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LossEstimationApplication.this.printButton_actionPerformed(actionEvent);
            }
        });
        this.saveButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent actionEvent) {
                LossEstimationApplication.this.saveButton_actionPerformed(actionEvent);
            }
        });
        this.menuBar.add(this.fileMenu);
        this.fileMenu.add(this.fileSaveMenu);
        this.fileMenu.add(this.filePrintMenu);
        this.fileMenu.add(this.fileExitMenu);
        this.setJMenuBar(this.menuBar);
        this.closeButton.setIcon(this.closeFileImage);
        this.closeButton.setToolTipText("Exit Application");
        Dimension d = this.closeButton.getSize();
        this.jToolBar.add(this.closeButton);
        this.printButton.setIcon(this.printFileImage);
        this.printButton.setToolTipText("Print Graph");
        this.printButton.setSize(d);
        this.jToolBar.add(this.printButton);
        this.saveButton.setIcon(this.saveFileImage);
        this.saveButton.setToolTipText("Save Graph as image");
        this.saveButton.setSize(d);
        this.jToolBar.add(this.saveButton);
        this.jToolBar.setFloatable(false);
        this.getContentPane().add((Component)this.jToolBar, "North");
        this.jPanel1.setLayout(this.gridBagLayout10);
        this.graphWidget = new GraphWidget();
        this.jPanel1.setBackground(Color.white);
        this.jPanel1.setBorder(this.border4);
        this.jPanel1.setMinimumSize(new Dimension(959, 600));
        this.jPanel1.setPreferredSize(new Dimension(959, 600));
        this.topSplitPane.setOrientation(0);
        this.clearButton.setText("Clear Plot");
        this.clearButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LossEstimationApplication.this.clearButton_actionPerformed(e);
            }
        });
        this.buttonPanel.setMinimumSize(new Dimension(568, 20));
        this.buttonPanel.setLayout(this.flowLayout1);
        this.progressCheckBox.setFont(new Font("Dialog", 1, 12));
        this.progressCheckBox.setSelected(true);
        this.progressCheckBox.setText("Show Progress Bar");
        this.addButton.setText("Compute");
        this.addButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LossEstimationApplication.this.addButton_actionPerformed(e);
            }
        });
        this.controlComboBox.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LossEstimationApplication.this.controlComboBox_actionPerformed(e);
            }
        });
        this.panel.setLayout(this.gridBagLayout9);
        this.panel.setBackground(Color.white);
        this.panel.setBorder(this.border5);
        this.panel.setMinimumSize(new Dimension(0, 0));
        this.imrSplitPane.setOrientation(0);
        this.imrSplitPane.setBottomComponent(this.imrPanel);
        this.imrSplitPane.setTopComponent(this.vulPanel);
        this.sitePanel.setLayout(this.gridBagLayout13);
        this.sitePanel.setBackground(Color.white);
        this.vulPanel.setLayout(this.gridBagLayout8);
        this.vulPanel.setBackground(Color.white);
        this.controlsSplit.setDividerSize(5);
        this.erfPanel.setLayout(this.gridBagLayout5);
        this.erfPanel.setBackground(Color.white);
        this.erfPanel.setBorder(this.border2);
        this.erfPanel.setMaximumSize(new Dimension(Integer.MAX_VALUE, 10000));
        this.erfPanel.setMinimumSize(new Dimension(2, 300));
        this.erfPanel.setPreferredSize(new Dimension(2, 300));
        this.imrPanel.setLayout(this.gridBagLayout15);
        this.imrPanel.setBackground(Color.white);
        this.chartSplit.setLeftComponent(this.panel);
        this.chartSplit.setRightComponent(this.paramsTabbedPane);
        this.peelOffButton.setText("Peel Off");
        this.peelOffButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LossEstimationApplication.this.peelOffButton_actionPerformed(e);
            }
        });
        this.cancelCalcButton.setText("Cancel");
        this.cancelCalcButton.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                LossEstimationApplication.this.cancelCalcButton_actionPerformed(e);
            }
        });
        this.getContentPane().add((Component)this.jPanel1, "Center");
        this.jPanel1.add((Component)this.topSplitPane, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(11, 4, 5, 6), 243, 231));
        this.buttonPanel.add((Component)this.controlComboBox, 0);
        this.buttonPanel.add((Component)this.addButton, 1);
        this.buttonPanel.add((Component)this.cancelCalcButton, 2);
        this.buttonPanel.add((Component)this.clearButton, 3);
        this.buttonPanel.add((Component)this.peelOffButton, 4);
        this.buttonPanel.add((Component)this.progressCheckBox, 5);
        this.buttonPanel.add((Component)this.usgsImgLabel, 6);
        this.buttonPanel.add((Component)this.openshaImgLabel, 7);
        this.buttonPanel.add((Component)this.riskAgoraImgLabel, 8);
        this.cancelCalcButton.setVisible(false);
        this.topSplitPane.add((Component)this.chartSplit, "top");
        this.chartSplit.add((Component)this.panel, "left");
        this.chartSplit.add((Component)this.paramsTabbedPane, "right");
        this.imrSplitPane.add((Component)this.vulPanel, "top");
        this.imrSplitPane.add((Component)this.imrPanel, "bottom");
        this.controlsSplit.add((Component)this.imrSplitPane, "left");
        this.paramsTabbedPane.add((Component)this.controlsSplit, "Vulnerabilty,IMR & Site");
        this.controlsSplit.add((Component)this.sitePanel, "right");
        this.paramsTabbedPane.add((Component)this.erfPanel, "ERF & Time Span");
        this.topSplitPane.add((Component)this.buttonPanel, "bottom");
        this.topSplitPane.setDividerLocation(590);
        this.imrSplitPane.setDividerLocation(100);
        this.controlsSplit.setDividerLocation(230);
        this.erfPanel.setLayout(this.gridBagLayout5);
        this.erfPanel.validate();
        this.erfPanel.repaint();
        this.chartSplit.setDividerLocation(590);
        this.setSize(1100, 820);
        Dimension dim = Toolkit.getDefaultToolkit().getScreenSize();
        this.setLocation((dim.width - this.getSize().width) / 2, 0);
        this.setDefaultCloseOperation(3);
        this.setTitle("Loss Estimation Curve Application ");
        this.panel.removeAll();
        this.panel.add((Component)this.graphWidget, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, new Insets(0, 0, 0, 0), 0, 0));
        this.panel.validate();
        this.panel.repaint();
    }

    public static void main(String[] args) {
        new DisclaimerDialog(APP_NAME, APP_SHORT_NAME, LossEstimationApplication.getAppVersion());
        DefaultExceptionHandler exp = new DefaultExceptionHandler(APP_SHORT_NAME, LossEstimationApplication.getAppVersion(), null, null);
        Thread.setDefaultUncaughtExceptionHandler(exp);
        LossEstimationApplication applet = new LossEstimationApplication();
        exp.setApp(applet);
        exp.setParent(applet);
        applet.init();
        applet.setVisible(true);
    }

    private void addGraphPanel() {
        String S = "LossEstimationApplication: addGraphPanel(): ";
        PlotSpec spec = this.graphWidget.getPlotSpec();
        spec.setPlotElems(this.functionList);
        spec.setTitle(this.TITLE);
        this.graphWidget.drawGraph();
    }

    void addButton_actionPerformed(ActionEvent e) {
        this.addButton();
    }

    @Override
    public void run() {
        try {
            this.computeHazardCurve();
            this.cancelCalcButton.setVisible(false);
            this.calcThread = null;
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setButtonsEnable(true);
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), APP_SHORT_NAME, LossEstimationApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
        }
    }

    protected void createCalcInstance() {
        try {
            this.calc = new HazardCurveCalculator();
            this.calc.setTrackProgress(true);
        }
        catch (Exception ex) {
            ex.printStackTrace();
            BugReport bug = new BugReport(ex, this.getParametersInfoAsString(), APP_SHORT_NAME, LossEstimationApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, true);
            bugDialog.setVisible(true);
        }
    }

    protected void addButton() {
        this.setButtonsEnable(false);
        this.imrGuiBean.showWarningMessages(false);
        try {
            this.createCalcInstance();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.setButtonsEnable(true);
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), APP_SHORT_NAME, LossEstimationApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
        }
        if (this.progressCheckBox.isSelected()) {
            this.calcThread = new Thread(this);
            this.calcThread.start();
            this.timer = new Timer(200, new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent evt) {
                    try {
                        int totRupture = LossEstimationApplication.this.calc.getTotRuptures();
                        int currRupture = LossEstimationApplication.this.calc.getCurrRuptures();
                        boolean totCurCalculated = true;
                        if (currRupture == -1) {
                            LossEstimationApplication.this.progressClass.setProgressMessage("Please wait, calculating total rutures ....");
                            totCurCalculated = false;
                        }
                        if (!LossEstimationApplication.this.isHazardCalcDone && totCurCalculated) {
                            LossEstimationApplication.this.progressClass.updateProgress(currRupture, totRupture);
                        }
                        if (LossEstimationApplication.this.isHazardCalcDone) {
                            LossEstimationApplication.this.timer.stop();
                            LossEstimationApplication.this.progressClass.dispose();
                            LossEstimationApplication.this.drawGraph();
                        }
                    }
                    catch (Exception e) {
                        LossEstimationApplication.this.timer.stop();
                        e.printStackTrace();
                        LossEstimationApplication.this.setButtonsEnable(true);
                        BugReport bug = new BugReport(e, LossEstimationApplication.this.getParametersInfoAsString(), LossEstimationApplication.APP_SHORT_NAME, LossEstimationApplication.getAppVersion(), LossEstimationApplication.this.getApplicationComponent());
                        BugReportDialog bugDialog = new BugReportDialog(LossEstimationApplication.this.getApplicationComponent(), bug, false);
                        bugDialog.setVisible(true);
                    }
                }
            });
        } else {
            this.computeHazardCurve();
            this.drawGraph();
        }
    }

    protected Component getApplicationComponent() {
        return this;
    }

    protected void drawGraph() {
        this.imrGuiBean.showWarningMessages(true);
        this.addGraphPanel();
    }

    public void plotGraphUsingPlotPreferences() {
        this.drawGraph();
    }

    void clearButton_actionPerformed(ActionEvent e) {
        this.clearPlot(true);
    }

    private void clearPlot(boolean clearFunctions) {
        int loc;
        int newLoc = loc = this.chartSplit.getDividerLocation();
        if (clearFunctions) {
            this.graphWidget.removeChartAndMetadata();
            this.panel.removeAll();
            this.functionList.clear();
        }
        this.graphWidget.setAutoRange();
        this.chartSplit.setDividerLocation(newLoc);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String S = "LossEstimationApplication: parameterChange(): ";
        String name1 = event.getParameterName();
        if (name1.equalsIgnoreCase("IMR")) {
            ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
            this.siteGuiBean.replaceSiteParams(imr.getSiteParamsIterator());
            this.siteGuiBean.validate();
            this.siteGuiBean.repaint();
        }
        if (name1.equalsIgnoreCase(this.vulnBean.getParameter().getName())) {
            AbstractVulnerability currentModel = this.vulnBean.getCurrentModel();
            String currentIMT = currentModel.getIMT();
            double currentPeriod = 0.0;
            if (currentIMT.equals("SA")) {
                currentPeriod = currentModel.getPeriod();
            }
            this.imrGuiBean.setIMRParamListAndEditor(currentIMT, currentIMT, currentPeriod, currentPeriod);
            ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
            this.siteGuiBean.replaceSiteParams(imr.getSiteParamsIterator());
            this.siteGuiBean.validate();
            this.siteGuiBean.repaint();
        }
    }

    protected void setButtonsEnable(boolean b) {
        this.addButton.setEnabled(b);
        this.clearButton.setEnabled(b);
        this.peelOffButton.setEnabled(b);
        this.graphWidget.getButtonControlPanel().setEnabled(b);
        this.progressCheckBox.setEnabled(b);
    }

    protected void computeHazardCurve() {
        this.isHazardCalcDone = false;
        BaseERF forecast = null;
        try {
            this.erfGuiBean.showProgressBar(this.progressCheckBox.isSelected());
            forecast = this.erfGuiBean.getSelectedERF();
        }
        catch (Exception e) {
            e.printStackTrace();
            JOptionPane.showMessageDialog(this, e.getMessage(), "Incorrect Values", 0);
            this.setButtonsEnable(true);
            return;
        }
        if (this.progressCheckBox.isSelected()) {
            this.progressClass = new CalcProgressBar("Hazard-Curve Calc Status", "Beginning Calculation ");
            this.progressClass.displayProgressBar();
            this.timer.start();
        }
        AbstractVulnerability currentModel = this.vulnBean.getCurrentModel();
        String currentIMT = currentModel.getIMT();
        double currentPeriod = 0.0;
        if (currentIMT.equals("SA")) {
            currentPeriod = currentModel.getPeriod();
        }
        double[] currentIMLs = currentModel.getIMLValues();
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
        Site site = this.siteGuiBean.getSite();
        try {
            if (this.distanceControlPanel != null) {
                this.calc.setMaxSourceDistance(this.distanceControlPanel.getDistance());
            }
        }
        catch (Exception e) {
            this.setButtonsEnable(true);
            e.printStackTrace();
            BugReport bug = new BugReport(e, this.getParametersInfoAsString(), APP_SHORT_NAME, LossEstimationApplication.getAppVersion(), this);
            BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
            bugDialog.setVisible(true);
        }
        ArbitrarilyDiscretizedFunc currentHazardCurve = this.calcHazardCurve(currentIMT, currentPeriod, currentIMLs, site, forecast, imr);
        AbstractVulnerability vuln = this.vulnBean.getCurrentModel();
        Preconditions.checkNotNull((Object)vuln, (Object)"Vulnerability model is null");
        System.out.println("Vuln model: " + vuln.getName() + " (" + String.valueOf(vuln.getClass()) + ")");
        LossCurveCalculator lCalc = new LossCurveCalculator();
        ArbitrarilyDiscretizedFunc lossFunc = lCalc.getLossCurve(currentHazardCurve, vuln);
        lossFunc.setInfo(this.getParametersInfoAsString());
        lossFunc.setName(vuln.getName());
        String imt = currentIMT;
        this.graphWidget.setXAxisLabel("Fractional Loss");
        this.graphWidget.setYAxisLabel("Prob. of Exceed.");
        this.functionList.add(lossFunc);
        this.isHazardCalcDone = true;
        this.setButtonsEnable(true);
    }

    private void getAnnualizedPE(ArbitrarilyDiscretizedFunc function) {
        int num = function.size();
        for (int i = 0; i < num; ++i) {
            double rate = function.getY(i);
            double pe = 1.0 - Math.exp(-1.0 * rate);
            function.set(i, pe);
        }
    }

    private ArbitrarilyDiscretizedFunc calcHazardCurve(String imt, double period, double[] imls, Site site, BaseERF forecast, ScalarIMR imr) {
        ArbitrarilyDiscretizedFunc hazFunction = new ArbitrarilyDiscretizedFunc();
        this.initX_Values(hazFunction, imls, imt);
        imr.setIntensityMeasure(imt);
        imr.getParameter("SA Period").setValue(period);
        try {
            try {
                hazFunction = (ArbitrarilyDiscretizedFunc)this.calc.getHazardCurve((DiscretizedFunc)hazFunction, site, imr, (ERF)forecast);
            }
            catch (Exception e) {
                e.printStackTrace();
                this.setButtonsEnable(true);
            }
            hazFunction = this.toggleHazFuncLogValues(hazFunction, imls);
            hazFunction.setInfo(this.getParametersInfoAsString());
        }
        catch (RuntimeException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Parameters Invalid", 1);
            e.printStackTrace();
            this.setButtonsEnable(true);
            return null;
        }
        return hazFunction;
    }

    private void initX_Values(DiscretizedFunc arb, double[] imls, String imt) {
        IMT_Info imtInfo = new IMT_Info();
        if (IMT_Info.isIMT_LogNormalDist(imt)) {
            for (int i = 0; i < imls.length; ++i) {
                arb.set(Math.log(imls[i]), 1.0);
            }
        } else {
            throw new RuntimeException("Unsupported IMT");
        }
    }

    private ArbitrarilyDiscretizedFunc toggleHazFuncLogValues(ArbitrarilyDiscretizedFunc hazFunc, double[] imls) {
        int numPoints = hazFunc.size();
        ArbitrarilyDiscretizedFunc tempFunc = hazFunc.deepClone();
        hazFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < tempFunc.size(); ++i) {
            hazFunc.set(imls[i], tempFunc.getY(i));
        }
        return hazFunc;
    }

    protected void initIMR_GuiBean() {
        AbstractVulnerability currentModel = this.vulnBean.getCurrentModel();
        String currentIMT = currentModel.getIMT();
        double currentPeriod = 0.0;
        if (currentIMT.equals("SA")) {
            currentPeriod = currentModel.getPeriod();
        }
        this.imrPanel.removeAll();
        this.imrGuiBean = new IMR_GuiBean(this, currentIMT, currentIMT, currentPeriod, currentPeriod);
        this.imrGuiBean.getParameterEditor("IMR").getParameter().addParameterChangeListener(this);
        this.imrPanel.add((Component)this.imrGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.imrPanel.updateUI();
    }

    private void initVulnerabilityGuiBean(List<AbstractVulnerability> vulns) {
        this.vulnBean = new VulnerabilityBean(vulns);
        this.vulnBean.getParameter().addParameterChangeListener(this);
        this.vulPanel.setLayout(this.gridBagLayout8);
        this.vulPanel.add((Component)this.vulnBean.getVisualization(0), new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.vulPanel.updateUI();
    }

    protected void initSiteGuiBean() {
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
        this.siteGuiBean = new Site_GuiBean();
        this.siteGuiBean.addSiteParams(imr.getSiteParamsIterator());
        this.sitePanel.add((Component)this.siteGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.sitePanel.updateUI();
    }

    protected void initERF_GuiBean() {
        if (this.erfGuiBean == null) {
            try {
                this.erfGuiBean = new ERF_GuiBean(ERF_Ref.get(false, ServerPrefUtils.SERVER_PREFS));
                this.erfGuiBean.getParameter("Eqk Rup Forecast").addParameterChangeListener(this);
            }
            catch (InvocationTargetException e) {
                e.printStackTrace();
            }
        }
        this.erfPanel.add((Component)this.erfGuiBean, new GridBagConstraints(0, 0, 1, 1, 1.0, 1.0, 10, 1, this.defaultInsets, 0, 0));
        this.erfPanel.updateUI();
    }

    protected void initControlList() {
        this.controlComboBox.addItem(CONTROL_PANELS);
        this.controlComboBox.addItem(DISTANCE_CONTROL);
        this.controlComboBox.addItem(SITES_OF_INTEREST_CONTROL);
        this.controlComboBox.addItem(CVM_CONTROL);
        this.controlComboBox.addItem(XY_Values_Control);
    }

    void controlComboBox_actionPerformed(ActionEvent e) {
        if (this.controlComboBox.getItemCount() <= 0) {
            return;
        }
        String selectedControl = this.controlComboBox.getSelectedItem().toString();
        if (selectedControl.equalsIgnoreCase(DISTANCE_CONTROL)) {
            this.initDistanceControl();
        } else if (selectedControl.equalsIgnoreCase(SITES_OF_INTEREST_CONTROL)) {
            this.initSitesOfInterestControl();
        } else if (selectedControl.equalsIgnoreCase(CVM_CONTROL)) {
            this.initCVMControl();
        } else if (selectedControl.equalsIgnoreCase(XY_Values_Control)) {
            this.initXYPlotSelectionControl();
        }
        this.controlComboBox.setSelectedItem(CONTROL_PANELS);
    }

    private void initXYPlotSelectionControl() {
        if (this.xyPlotControl == null) {
            this.xyPlotControl = new XY_ValuesControlPanel(this, this);
        }
        this.xyPlotControl.getComponent().setVisible(true);
    }

    @Override
    public void updateIM() {
    }

    private void initDistanceControl() {
        if (this.distanceControlPanel == null) {
            this.distanceControlPanel = new SetMinSourceSiteDistanceControlPanel((Component)this);
        }
        this.distanceControlPanel.pack();
        this.distanceControlPanel.setVisible(true);
    }

    private void initSitesOfInterestControl() {
        if (this.sitesOfInterest == null) {
            this.sitesOfInterest = new SitesOfInterestControlPanel(this, this.siteGuiBean);
        }
        this.sitesOfInterest.getComponent().pack();
        this.sitesOfInterest.getComponent().setVisible(true);
    }

    private void initCVMControl() {
        if (this.cvmControlPanel == null) {
            this.cvmControlPanel = new SetSiteParamsFromWebServicesControlPanel(this, this.imrGuiBean, this.siteGuiBean);
        }
        this.cvmControlPanel.pack();
        this.cvmControlPanel.setVisible(true);
    }

    public Range getX_AxisRange() {
        return this.graphWidget.getX_AxisRange();
    }

    public Range getY_AxisRange() {
        return this.graphWidget.getY_AxisRange();
    }

    @Override
    public void addCurve(ArbitrarilyDiscretizedFunc function) {
        this.functionList.add(function);
        List<PlotCurveCharacterstics> plotFeaturesList = this.graphWidget.getPlottingFeatures();
        plotFeaturesList.add(new PlotCurveCharacterstics(null, 1.0f, PlotSymbol.CROSS, 4.0f, Color.BLACK));
        this.addGraphPanel();
    }

    public String getParametersInfoAsString() {
        return this.getMapParametersInfoAsHTML().replaceAll("<br>", SystemUtils.LINE_SEPARATOR);
    }

    public String getMapParametersInfoAsHTML() {
        String imrMetadata = this.imrGuiBean.getVisibleParametersCloned().getParameterListMetadataString();
        double maxSourceSiteDistance = this.distanceControlPanel != null ? this.distanceControlPanel.getDistance() : MaxDistanceParam.DEFAULT.doubleValue();
        return "<br>IMR Param List:<br>---------------<br>" + imrMetadata + "<br><br>Site Param List: <br>----------------<br>" + this.siteGuiBean.getParameterListEditor().getVisibleParametersCloned().getParameterListMetadataString() + "<br><br>Forecast Param List: <br>--------------------<br>" + this.erfGuiBean.getERFParameterList().getParameterListMetadataString() + "<br><br>TimeSpan Param List: <br>--------------------<br>" + this.erfGuiBean.getSelectedERFTimespanGuiBean().getParameterListMetadataString() + "<br><br>Max. Source-Site Distance = " + maxSourceSiteDistance;
    }

    public List<PlotElement> getCurveFunctionList() {
        return this.functionList;
    }

    protected void peelOffCurves() {
        GraphWindow graphWindow = new GraphWindow(this.graphWidget);
        this.graphWidget.getPlotSpec().setPlotElems(Lists.newArrayList(this.graphWidget.getPlotSpec().getPlotElems()));
        this.graphWidget = new GraphWidget();
        this.clearPlot(true);
        graphWindow.setVisible(true);
    }

    void peelOffButton_actionPerformed(ActionEvent e) {
        this.peelOffCurves();
    }

    private void fileExitMenu_actionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    private void close() {
        int option = JOptionPane.showConfirmDialog(this, "Do you really want to exit the application?\nYou will loose all unsaved data.", "Exit App", 2);
        if (option == 0) {
            System.exit(0);
        }
    }

    private void fileSaveMenu_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    private void filePrintMenu_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    public void save() throws IOException {
        this.graphWidget.save();
    }

    public void print() {
        this.graphWidget.print();
    }

    public void closeButton_actionPerformed(ActionEvent actionEvent) {
        this.close();
    }

    public void printButton_actionPerformed(ActionEvent actionEvent) {
        this.print();
    }

    public void saveButton_actionPerformed(ActionEvent actionEvent) {
        try {
            this.save();
        }
        catch (IOException e) {
            JOptionPane.showMessageDialog(this, e.getMessage(), "Save File Error", 0);
            return;
        }
    }

    void cancelCalcButton_actionPerformed(ActionEvent e) {
        this.calcThread.stop();
        this.calcThread = null;
        this.erfGuiBean.closeProgressBar();
        if (this.timer != null && this.progressClass != null) {
            this.timer.stop();
            this.timer = null;
            this.progressClass.dispose();
        }
        if (this.calc != null) {
            try {
                this.calc.stopCalc();
                this.calc = null;
            }
            catch (RuntimeException ee) {
                this.setButtonsEnable(true);
                BugReport bug = new BugReport(ee, this.getParametersInfoAsString(), APP_SHORT_NAME, LossEstimationApplication.getAppVersion(), this);
                BugReportDialog bugDialog = new BugReportDialog((Component)this, bug, false);
                bugDialog.setVisible(true);
            }
        }
        this.isHazardCalcDone = false;
        this.setButtonsEnable(true);
        this.cancelCalcButton.setVisible(false);
    }

    public ERF_GuiBean getEqkRupForecastGuiBeanInstance() {
        return this.erfGuiBean;
    }

    public Site_GuiBean getSiteGuiBeanInstance() {
        return this.siteGuiBean;
    }

    @Override
    public void updateSiteParams() {
        ScalarIMR imr = this.imrGuiBean.getSelectedIMR_Instance();
        this.siteGuiBean.replaceSiteParams(imr.getSiteParamsIterator());
        this.siteGuiBean.validate();
        this.siteGuiBean.repaint();
    }

    @Override
    public String getSelectedIMT() {
        return null;
    }

    @Override
    public void setCurveXValues(ArbitrarilyDiscretizedFunc func) {
        throw new RuntimeException("Not applicable for application");
    }

    @Override
    public void setCurveXValues() {
        throw new RuntimeException("Not applicable for application");
    }

    static {
        String osName = System.getProperty("os.name");
        try {
            UIManager.setLookAndFeel(UIManager.getSystemLookAndFeelClassName());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }
}

