/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui.components;

import java.util.ArrayList;
import java.util.EventListener;
import java.util.List;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.constraint.impl.StringConstraint;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeFailEvent;
import org.opensha.commons.param.event.ParameterChangeFailListener;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.sra.gui.components.GuiBeanAPI;
import org.opensha.sra.vulnerability.AbstractVulnerability;

public class VulnerabilityBean
implements GuiBeanAPI {
    private StringParameter vulnFilterParam;
    private static final String VULN_FILTER_PARAM_NAME = "Vuln. Model Filter";
    private StringParameter vulnParam = null;
    private static final String VULN_PARAM_NAME = "Vulnerability Model";
    List<AbstractVulnerability> vms;
    ArrayList<AbstractVulnerability> visibleVMs;
    private AbstractVulnerability vulnerability = null;
    private EventListener listener = null;
    private ParameterList paramList;
    private ParameterListEditor listEdit;

    public VulnerabilityBean(List<AbstractVulnerability> vms) {
        ArrayList<String> strings = new ArrayList<String>();
        this.vms = vms;
        this.visibleVMs = new ArrayList();
        for (int i = 0; i < vms.size(); ++i) {
            strings.add(vms.get(i).getName());
            this.visibleVMs.add(vms.get(i));
        }
        this.vulnerability = vms.get(0);
        this.listener = new VulnerabilityParameterListener();
        this.vulnFilterParam = new StringParameter(VULN_FILTER_PARAM_NAME);
        this.vulnFilterParam.setValue("");
        this.vulnFilterParam.addParameterChangeListener((ParameterChangeListener)this.listener);
        this.vulnParam = new StringParameter(VULN_PARAM_NAME, strings, (String)strings.get(0));
        this.vulnParam.setInfo("The facility or facility class representing the building conditions");
        this.vulnParam.addParameterChangeListener((ParameterChangeListener)this.listener);
        this.vulnParam.addParameterChangeFailListener((ParameterChangeFailListener)this.listener);
        this.paramList = new ParameterList();
        this.paramList.addParameter(this.vulnFilterParam);
        this.paramList.addParameter(this.vulnParam);
        this.listEdit = new ParameterListEditor(this.paramList);
    }

    public AbstractVulnerability getCurrentModel() {
        return this.vulnerability;
    }

    public StringParameter getParameter() {
        return this.vulnParam;
    }

    public ParameterList getDisplayParameters() {
        return this.paramList;
    }

    @Override
    public Object getVisualization(int type) {
        if (!this.isVisualizationSupported(type)) {
            throw new IllegalArgumentException("Only the Application type is supported at this time.");
        }
        if (type == 0) {
            return this.getApplicationVisualization();
        }
        return null;
    }

    @Override
    public String getVisualizationClassName(int type) {
        String cname = null;
        if (type == 0) {
            cname = "javax.swing.JPanel";
        }
        return cname;
    }

    @Override
    public boolean isVisualizationSupported(int type) {
        return type == 0;
    }

    private JPanel getApplicationVisualization() {
        return this.listEdit;
    }

    private void updateFilter(String filter) {
        ArrayList<String> strings = new ArrayList<String>();
        this.visibleVMs.clear();
        filter = filter.toLowerCase();
        for (AbstractVulnerability vm : this.vms) {
            String name = vm.getName();
            if (filter != null && !name.toLowerCase().contains(filter)) continue;
            this.visibleVMs.add(vm);
            strings.add(name);
        }
        ((StringConstraint)this.vulnParam.getConstraint()).setStrings(strings);
        this.vulnParam.setValue((String)strings.get(0));
        this.vulnParam.getEditor().refreshParamEditor();
    }

    private void handleVulnerabilityChange(ParameterChangeEvent event) {
        String newVuln = (String)event.getNewValue();
        for (int i = 0; i < this.visibleVMs.size(); ++i) {
            if (!newVuln.equals(this.visibleVMs.get(i).getName())) continue;
            this.vulnerability = this.visibleVMs.get(i);
            break;
        }
    }

    private class VulnerabilityParameterListener
    implements ParameterChangeListener,
    ParameterChangeFailListener {
        private VulnerabilityParameterListener() {
        }

        @Override
        public void parameterChange(ParameterChangeEvent event) {
            if (VulnerabilityBean.VULN_PARAM_NAME.equals(event.getParameterName())) {
                VulnerabilityBean.this.handleVulnerabilityChange(event);
            } else if (VulnerabilityBean.VULN_FILTER_PARAM_NAME.equals(event.getParameterName())) {
                VulnerabilityBean.this.updateFilter((String)VulnerabilityBean.this.vulnFilterParam.getValue());
            }
        }

        @Override
        public void parameterChangeFailed(ParameterChangeFailEvent event) {
            JOptionPane.showMessageDialog(null, "The input value of " + String.valueOf(event.getBadValue()) + " is out of range.", "Failed to Change Value", 0);
        }
    }
}

