/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.gui.portfolioeal;

import java.io.File;
import java.io.FileNotFoundException;
import java.util.ArrayList;
import java.util.List;
import java.util.Scanner;
import java.util.StringTokenizer;
import org.opensha.sra.gui.portfolioeal.Asset;

public class PortfolioParser {
    public ArrayList<Asset> scanFile(File portfolioFile) throws NumberFormatException {
        Scanner fileScanner = null;
        try {
            fileScanner = new Scanner(portfolioFile);
        }
        catch (FileNotFoundException exception) {
            exception.printStackTrace();
            System.err.println(exception.getMessage());
        }
        boolean firstLine = true;
        ArrayList<Asset> assetList = new ArrayList<Asset>();
        Asset baseAsset = null;
        while (fileScanner.hasNextLine()) {
            String assetLine = fileScanner.nextLine();
            Asset asset = null;
            if (!firstLine) {
                try {
                    asset = baseAsset.clone();
                }
                catch (CloneNotSupportedException e) {
                    e.printStackTrace();
                }
                try {
                    List<String> assetArrayList = PortfolioParser.parseLine(assetLine);
                    String[] assetValueList = new String[assetArrayList.size()];
                    if ((assetValueList = assetArrayList.toArray(assetValueList)).length <= 0) continue;
                    asset.setAssetParameters(assetValueList);
                    assetList.add(asset);
                    continue;
                }
                catch (RuntimeException e) {
                    System.out.println("Bad line: " + assetLine);
                    System.out.flush();
                    throw e;
                }
            }
            baseAsset = new Asset(assetLine);
            firstLine = false;
        }
        return assetList;
    }

    public static List<String> parseLine(String assetLine) {
        StringTokenizer tokenizer = new StringTokenizer(assetLine);
        ArrayList<String> assetArrayList = new ArrayList<String>();
        while (tokenizer.hasMoreTokens()) {
            Object token = tokenizer.nextToken(",");
            if (((String)token).startsWith("\"") && !((String)token).endsWith("\"")) {
                while (!((String)token).endsWith("\"")) {
                    token = (String)token + tokenizer.nextToken();
                }
                ((String)token).substring(1, ((String)token).length() - 1);
            }
            assetArrayList.add((String)token);
        }
        return assetArrayList;
    }
}

