/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.vulnerability.models;

import java.io.Serializable;
import java.util.ArrayList;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.util.StatUtil;
import org.opensha.sra.vulnerability.AbstractVulnerability;

public class SimpleVulnerability
extends AbstractVulnerability
implements Serializable {
    private static final long serialVersionUID = 1L;
    private ArrayList<Double> mdfVals;
    private ArrayList<Double> covVals;
    private ArrayList<Double> im_levels;
    private AbstractDiscretizedFunc vulnFunc;
    private AbstractDiscretizedFunc covFunc;

    private static double[] toPrimDoubleArray(ArrayList<Double> vals) {
        double[] dvals = new double[vals.size()];
        for (int i = 0; i < vals.size(); ++i) {
            dvals[i] = vals.get(i);
        }
        return dvals;
    }

    public SimpleVulnerability(String name, String shortName, String im_type, ArrayList<Double> im_levels, ArrayList<Double> mdfVals, ArrayList<Double> covVals) {
        super(name, shortName, im_type, SimpleVulnerability.toPrimDoubleArray(im_levels));
        if (im_levels.size() != mdfVals.size()) {
            throw new IllegalArgumentException("im_levels must be the same size as mdfVals");
        }
        if (im_levels.size() != covVals.size()) {
            throw new IllegalArgumentException("im_levels must be the same size as covVals");
        }
        this.im_levels = im_levels;
        this.mdfVals = mdfVals;
        this.covVals = covVals;
        this.vulnFunc = new ArbitrarilyDiscretizedFunc();
        this.covFunc = new ArbitrarilyDiscretizedFunc();
        for (int i = 0; i < im_levels.size(); ++i) {
            this.vulnFunc.set(im_levels.get(i), (double)mdfVals.get(i));
            this.covFunc.set(im_levels.get(i), (double)covVals.get(i));
        }
        Object funcName = name;
        if (shortName != null && !shortName.equals(name)) {
            funcName = (String)funcName + " (" + shortName + ")";
        }
        this.vulnFunc.setName((String)funcName);
    }

    @Override
    public double[] getDEMDFVals() {
        return null;
    }

    @Override
    public double[][] getDEMMatrix() {
        return null;
    }

    @Override
    public double getDF(double IML) {
        return 0.0;
    }

    @Override
    public ArrayList<double[]> getDFTable() {
        return null;
    }

    @Override
    public AbstractDiscretizedFunc getVulnerabilityFunc() {
        return this.vulnFunc;
    }

    public String toString() {
        String str = "Simple Vulnurabilty Function: " + this.getName() + " (" + this.getShortName() + ")\n";
        str = str + "IM Type: " + this.getIMT() + "\n";
        str = str + "IML\tMDF\tCOV\n";
        for (int i = 0; i < this.im_levels.size(); ++i) {
            str = str + String.valueOf(this.im_levels.get(i)) + "\t" + String.valueOf(this.mdfVals.get(i)) + "\t" + String.valueOf(this.covVals.get(i)) + "\n";
        }
        str = str + "total vals: " + this.im_levels.size();
        return str;
    }

    @Override
    public double getMeanDamageAtExceedProb(double iml, double prob) {
        double invCumStdNormDist = StatUtil.getInvCDF(1.0 - prob, true);
        double d = this.covFunc.getInterpolatedY(iml);
        double y = this.getMeanDamageFactor(iml);
        double beta = Math.sqrt(Math.log(1.0 + d * d));
        double yhat = y / Math.sqrt(1.0 + d * d);
        double yp = yhat * Math.exp(beta * invCumStdNormDist);
        return yp;
    }

    public AbstractDiscretizedFunc getCOVFunction() {
        return this.covFunc;
    }

    @Override
    public double getMeanDamageFactor(double iml) {
        return this.vulnFunc.getInterpolatedY(iml);
    }
}

