/*
 * Decompiled with CFR 0.152.
 */
package org.opensha.sra.vulnerability.models.servlet;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.opensha.commons.util.ServerPrefUtils;
import org.opensha.sra.vulnerability.Vulnerability;
import org.opensha.sra.vulnerability.models.SimpleVulnerability;
import org.opensha.sra.vulnerability.models.VulnFileReader;

public class VulnerabilityServlet
extends HttpServlet {
    public static final String SERVLET_URL = ServerPrefUtils.SERVER_PREFS.getServletBaseURL() + "VulnerabilityServlet";
    protected static final String VULN_LIST_NAME = "GET_VULN_LIST";
    private static String debugName = "VulnServlet";
    private static final String vulnFileName = ServerPrefUtils.SERVER_PREFS.getDataDir().getAbsolutePath() + File.separator + "riskData" + File.separator + "vuln" + File.separator + "current";
    private HashMap<String, Vulnerability> vulnMap = new HashMap();

    public VulnerabilityServlet() throws IOException {
        ArrayList<SimpleVulnerability> vulns = VulnFileReader.readVUL06File(new FileInputStream(vulnFileName));
        for (SimpleVulnerability vuln : vulns) {
            this.vulnMap.put(vuln.getShortName(), vuln);
        }
    }

    public void doPost(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        this.doGet(request, response);
    }

    public void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        ObjectInputStream in = new ObjectInputStream((InputStream)request.getInputStream());
        ObjectOutputStream out = new ObjectOutputStream((OutputStream)response.getOutputStream());
        try {
            String name = (String)in.readObject();
            if (name == null) {
                this.debug("Sending entire vuln map");
                out.writeObject(this.vulnMap);
            } else if (name.equals(VULN_LIST_NAME)) {
                out.writeObject(this.vulnMap.keySet());
            } else {
                this.debug("Sending vuln: " + name);
                Vulnerability vuln = this.vulnMap.get(name);
                out.writeObject(vuln);
            }
            out.flush();
            out.close();
        }
        catch (Exception e) {
            e.printStackTrace();
            this.fail(out, "Servlet Exception: " + e.getMessage());
        }
    }

    protected void debug(String message) {
        ServerPrefUtils.debug(debugName, message);
    }

    protected void fail(ObjectOutputStream out, String message) throws IOException {
        ServerPrefUtils.fail(out, debugName, message);
    }
}

