/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.DocumentException;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileNameComparator;
import org.opensha.commons.util.threads.Task;
import org.opensha.commons.util.threads.ThreadedTaskComputer;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.inversion.CommandLineInversionRunner;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.inversion.UCERF3InversionConfiguration;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.paleoRateConstraints.PaleoFitPlotter;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoRateConstraintFetcher;

public class U3AverageFaultSystemSolution
extends InversionFaultSystemSolution
implements Iterable<InversionFaultSystemSolution> {
    private int numSols;
    private double[][] ratesByRup;
    private double[][] ratesBySol;
    private HashMap<Integer, InversionFaultSystemSolution> solsMap = new HashMap();

    private static double[][] toArrays(List<double[]> ratesList) {
        int numRups = ratesList.get(0).length;
        int numSols = ratesList.size();
        double[][] rates = new double[numRups][numSols];
        for (int s = 0; s < numSols; ++s) {
            double[] sol = ratesList.get(s);
            for (int r = 0; r < numRups; ++r) {
                rates[r][s] = sol[r];
            }
        }
        return rates;
    }

    @Override
    public void clearCache() {
        for (InversionFaultSystemSolution sol : this.solsMap.values()) {
            sol.clearCache();
        }
        super.clearCache();
    }

    private static double[] getMeanRates(double[][] rates) {
        double[] mean = new double[rates.length];
        for (int r = 0; r < rates.length; ++r) {
            mean[r] = StatUtils.mean((double[])rates[r]);
        }
        return mean;
    }

    public U3AverageFaultSystemSolution(InversionFaultSystemRupSet rupSet, List<double[]> ratesList) {
        this(rupSet, ratesList, null, null);
    }

    public U3AverageFaultSystemSolution(InversionFaultSystemRupSet rupSet, List<double[]> ratesList, UCERF3InversionConfiguration config, Map<String, Double> energies) {
        this(rupSet, U3AverageFaultSystemSolution.toArrays(ratesList), config, energies);
    }

    public U3AverageFaultSystemSolution(InversionFaultSystemRupSet rupSet, double[][] rates, UCERF3InversionConfiguration config, Map<String, Double> energies) {
        super(rupSet, U3AverageFaultSystemSolution.getMeanRates(rates), config, energies);
        this.ratesByRup = rates;
        Object info = rupSet.getInfoString();
        this.numSols = this.ratesByRup[0].length;
        int numRups = rupSet.getNumRuptures();
        this.ratesBySol = new double[this.numSols][numRups];
        Object newInfo = "";
        newInfo = (String)newInfo + "************** Average Fault System Solution *****************\n";
        newInfo = (String)newInfo + "Number of solutions averaged: " + this.numSols;
        newInfo = (String)newInfo + "**************************************************************\n";
        info = (String)newInfo + "\n\n" + (String)info;
        this.setInfoString((String)info);
        for (int s = 0; s < this.numSols; ++s) {
            for (int r = 0; r < numRups; ++r) {
                this.ratesBySol[s][r] = this.ratesByRup[r][s];
            }
        }
    }

    public double getRateStdDev(int rupIndex) {
        return Math.sqrt(StatUtils.variance((double[])this.ratesByRup[rupIndex], (double)this.getRateForRup(rupIndex)));
    }

    public double getRateMin(int rupIndex) {
        return StatUtils.min((double[])this.ratesByRup[rupIndex]);
    }

    public double getRateMax(int rupIndex) {
        return StatUtils.max((double[])this.ratesByRup[rupIndex]);
    }

    public int getNumSolutions() {
        return this.numSols;
    }

    public double[] getRates(int solIndex) {
        return this.ratesBySol[solIndex];
    }

    public List<double[]> getRatesForAllSols() {
        ArrayList list = Lists.newArrayList();
        for (int i = 0; i < this.getNumSolutions(); ++i) {
            list.add(this.getRates(i));
        }
        return list;
    }

    public double[] getRatesForAllSols(int rupIndex) {
        return this.ratesByRup[rupIndex];
    }

    public synchronized InversionFaultSystemSolution getSolution(int solIndex) {
        Preconditions.checkArgument((solIndex >= 0 && solIndex < this.numSols ? 1 : 0) != 0, (Object)"");
        InversionFaultSystemSolution sol = this.solsMap.get(solIndex);
        if (sol == null) {
            while (this.solsMap.keySet().size() > 3) {
                this.solsMap.remove(this.solsMap.keySet().iterator().next());
            }
            sol = new InversionFaultSystemSolution(this.getRupSet(), this.ratesBySol[solIndex]);
            sol.getRupSet().copyCacheFrom(this.getRupSet());
            this.solsMap.put(solIndex, sol);
        }
        return sol;
    }

    public void clearSolCache() {
        this.solsMap.clear();
    }

    public double[][] calcParticRates(double magLow, double magHigh) throws InterruptedException {
        double[][] particRates = new double[this.getRupSet().getNumSections()][this.getNumSolutions()];
        U3AverageFaultSystemSolution.calcThreaded(this.ratesByRup, particRates, true, magLow, magHigh, this.getRupSet());
        return particRates;
    }

    public double[][] calcSlipRates() throws InterruptedException {
        double[][] particRates = new double[this.getRupSet().getNumSections()][this.getNumSolutions()];
        U3AverageFaultSystemSolution.calcThreaded(this.ratesByRup, particRates, false, 0.0, 10.0, this.getRupSet());
        return particRates;
    }

    public static void calcThreaded(double[][] rates, double[][] output, boolean partic, double magLow, double magHigh, InversionFaultSystemRupSet rupSet) throws InterruptedException {
        ArrayList<ParticipationComputeTask> tasks = new ArrayList<ParticipationComputeTask>();
        for (int i = 0; i < output[0].length; ++i) {
            tasks.add(new ParticipationComputeTask(rates, output, i, partic, magLow, magHigh, rupSet));
        }
        ThreadedTaskComputer comp = new ThreadedTaskComputer(tasks);
        comp.computeThreaded();
    }

    public IncrementalMagFreqDist[] calcSectionNucleationMFDs(int sectionID) {
        return this.calcMFDs(false, true, sectionID);
    }

    public IncrementalMagFreqDist[] calcParentSectionNucleationMFDs(int parentSectionID) {
        return this.calcMFDs(true, true, parentSectionID);
    }

    public IncrementalMagFreqDist[] calcSectionParticipationMFDs(int sectionID) {
        return this.calcMFDs(false, false, sectionID);
    }

    public IncrementalMagFreqDist[] calcParentSectionParticipationMFDs(int parentSectionID) {
        return this.calcMFDs(true, false, parentSectionID);
    }

    private IncrementalMagFreqDist[] calcMFDs(final boolean parent, final boolean nucleation, final int id) {
        final InversionFaultSystemRupSet rupSet = this.getRupSet();
        final double minMag = this.getRupSet().getMinMag();
        final double maxMag = this.getRupSet().getMaxMag();
        final int numMag = (int)((maxMag - minMag) / 0.1) + 1;
        ArrayList tasks = Lists.newArrayList();
        final IncrementalMagFreqDist[] mfds = new IncrementalMagFreqDist[this.getNumSolutions()];
        int i = 0;
        while (i < this.getNumSolutions()) {
            final int solIndex = i++;
            tasks.add(new Task(){
                final /* synthetic */ U3AverageFaultSystemSolution this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void compute() {
                    InversionFaultSystemSolution mySol = this.this$0.getSolution(solIndex);
                    ((U3FaultSystemSolution)mySol).getRupSet().copyCacheFrom(rupSet);
                    IncrementalMagFreqDist mfd = nucleation ? (parent ? mySol.calcNucleationMFD_forParentSect(id, minMag, maxMag, numMag) : mySol.calcNucleationMFD_forSect(id, minMag, maxMag, numMag)) : (parent ? mySol.calcParticipationMFD_forParentSect(id, minMag, maxMag, numMag) : mySol.calcParticipationMFD_forSect(id, minMag, maxMag, numMag));
                    mySol.clearSolutionCacheOnly();
                    mfds[solIndex] = mfd;
                }
            });
        }
        try {
            new ThreadedTaskComputer(tasks).computeThreaded();
        }
        catch (InterruptedException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        for (i = 0; i < this.getNumSolutions(); ++i) {
            Preconditions.checkNotNull((Object)mfds[i], (Object)("MFD is null at solution index " + i));
        }
        return mfds;
    }

    public static PlotSpec getMFDConvergencePlotSpec(IncrementalMagFreqDist[] mfds, boolean nucleation, String sectName) {
        return U3AverageFaultSystemSolution.getMFDConvergencePlotSpec(mfds, nucleation, sectName, mfds.length);
    }

    public static PlotSpec getMFDConvergencePlotSpec(IncrementalMagFreqDist[] mfds, boolean nucleation, String sectName, int n) {
        double minX = mfds[0].getMinX();
        double maxX = mfds[0].getMaxX();
        int num = mfds[0].size();
        EvenlyDiscretizedFunc meanFunc = new EvenlyDiscretizedFunc(minX, maxX, num);
        meanFunc.setName("Mean");
        EvenlyDiscretizedFunc minFunc = new EvenlyDiscretizedFunc(minX, maxX, num);
        minFunc.setName("Minimum");
        EvenlyDiscretizedFunc maxFunc = new EvenlyDiscretizedFunc(minX, maxX, num);
        maxFunc.setName("Maximum");
        EvenlyDiscretizedFunc meanPlusStdDevFunc = new EvenlyDiscretizedFunc(minX, maxX, num);
        meanPlusStdDevFunc.setName("Mean + Std Dev");
        EvenlyDiscretizedFunc meanMinusStdDevFunc = new EvenlyDiscretizedFunc(minX, maxX, num);
        meanMinusStdDevFunc.setName("Mean - Std Dev");
        EvenlyDiscretizedFunc meanPlusStdDevOfMeanFunc = new EvenlyDiscretizedFunc(minX, maxX, num);
        meanPlusStdDevOfMeanFunc.setName("Mean + Std Dev of Mean (n=" + n + ")");
        EvenlyDiscretizedFunc meanMinusStdDevOfMeanFunc = new EvenlyDiscretizedFunc(minX, maxX, num);
        meanMinusStdDevOfMeanFunc.setName("Mean - Std Dev of Mean (n=" + n + ")");
        for (int i = 0; i < num; ++i) {
            double[] vals = new double[mfds.length];
            for (int j = 0; j < mfds.length; ++j) {
                vals[j] = mfds[j].getY(i);
            }
            double mean = StatUtils.mean((double[])vals);
            double min = StatUtils.min((double[])vals);
            double max = StatUtils.max((double[])vals);
            double stdDev = Math.sqrt(StatUtils.variance((double[])vals, (double)mean));
            double sdom = stdDev / Math.sqrt(n);
            meanFunc.set(i, mean);
            minFunc.set(i, min);
            maxFunc.set(i, max);
            meanPlusStdDevFunc.set(i, mean + stdDev);
            meanMinusStdDevFunc.set(i, mean - stdDev);
            meanPlusStdDevOfMeanFunc.set(i, mean + sdom);
            meanMinusStdDevOfMeanFunc.set(i, mean - sdom);
        }
        ArrayList funcs = Lists.newArrayList((Object[])new EvenlyDiscretizedFunc[]{meanFunc, minFunc, maxFunc, meanPlusStdDevFunc, meanMinusStdDevFunc, meanPlusStdDevOfMeanFunc, meanMinusStdDevOfMeanFunc});
        ArrayList chars = Lists.newArrayList();
        float meanWidth = 4.0f;
        float normalWidth = 2.0f;
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, meanWidth, Color.BLACK));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, normalWidth, Color.RED));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, normalWidth, Color.RED));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, normalWidth, Color.GREEN));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, normalWidth, Color.GREEN));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, normalWidth, Color.BLUE));
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, normalWidth, Color.BLUE));
        Object title = nucleation ? "Nucleation" : "Participation";
        title = (String)title + " MFD Convergence: " + sectName + ", " + mfds.length + " Solutions";
        if (n != mfds.length) {
            title = (String)title + " (N=" + n + ", for SDOM)";
        }
        String xAxisLabel = "Magnitude";
        String yAxisLabel = "Rate";
        return new PlotSpec(funcs, chars, (String)title, xAxisLabel, yAxisLabel);
    }

    public void writePaleoPlots(File dir) throws IOException {
        String prefix = this.getRupSet().getLogicTreeBranch().buildFileName();
        int digits = ("" + (this.getNumSolutions() - 1)).length();
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = UCERF3_PaleoRateConstraintFetcher.getConstraints(this.getRupSet().getFaultSectionDataList());
        for (int i = 0; i < this.getNumSolutions(); ++i) {
            InversionFaultSystemSolution sol = this.getSolution(i);
            String runStr = "" + i;
            while (runStr.length() < digits) {
                runStr = "0" + runStr;
            }
            String myPrefix = prefix + "_run" + runStr;
            if (CommandLineInversionRunner.doPaleoPlotsExist(dir, myPrefix)) continue;
            CommandLineInversionRunner.writePaleoPlots(paleoRateConstraints, null, sol, dir, myPrefix);
        }
    }

    public void writePaleoBoundsPlot(File dir) throws IOException {
        U3AverageFaultSystemSolution.writePaleoBoundsPlot(dir, this);
    }

    public static void writePaleoBoundsPlot(File dir, U3AverageFaultSystemSolution avgSol) throws IOException {
        String prefix = avgSol.getRupSet().getLogicTreeBranch().buildFileName();
        U3AverageFaultSystemSolution.writePaleoBoundsPlot(dir, prefix, avgSol);
    }

    public static void writePaleoBoundsPlot(File dir, String prefix, Iterable<? extends InversionFaultSystemSolution> sols) throws IOException {
        ArrayList<U3PaleoRateConstraint> paleoRateConstraints = null;
        ArrayList otherFuncs = Lists.newArrayList();
        ArrayList otherChars = Lists.newArrayList();
        ArrayList minFuncs = Lists.newArrayList();
        ArrayList maxFuncs = Lists.newArrayList();
        ArrayList meanFuncs = Lists.newArrayList();
        ArrayList solFuncIndexes = Lists.newArrayList();
        int numSols = 0;
        for (InversionFaultSystemSolution inversionFaultSystemSolution : sols) {
            DiscretizedFunc func;
            int j;
            ++numSols;
            if (paleoRateConstraints == null) {
                paleoRateConstraints = UCERF3_PaleoRateConstraintFetcher.getConstraints(inversionFaultSystemSolution.getRupSet().getFaultSectionDataList());
            }
            PlotSpec spec = PaleoFitPlotter.getSegRateComparisonSpec(paleoRateConstraints, null, inversionFaultSystemSolution);
            List<DiscretizedFunc> funcs = spec.getPlotFunctionsOnly();
            if (otherFuncs.isEmpty()) {
                for (j = 0; j < funcs.size(); ++j) {
                    func = funcs.get(j);
                    if (func.getInfo().contains("Solution")) {
                        solFuncIndexes.add(j);
                        continue;
                    }
                    otherFuncs.add(func);
                    otherChars.add(spec.getChars().get(j));
                }
                for (j = 0; j < solFuncIndexes.size(); ++j) {
                    func = funcs.get((Integer)solFuncIndexes.get(j));
                    double min = func.getMinX();
                    double max = func.getMaxX();
                    int num = func.size();
                    minFuncs.add(new EvenlyDiscretizedFunc(min, max, num));
                    maxFuncs.add(new EvenlyDiscretizedFunc(min, max, num));
                    meanFuncs.add(new EvenlyDiscretizedFunc(min, max, num));
                }
            }
            for (j = 0; j < solFuncIndexes.size(); ++j) {
                func = funcs.get((Integer)solFuncIndexes.get(j));
                EvenlyDiscretizedFunc minFunc = (EvenlyDiscretizedFunc)minFuncs.get(j);
                EvenlyDiscretizedFunc maxFunc = (EvenlyDiscretizedFunc)maxFuncs.get(j);
                EvenlyDiscretizedFunc meanFunc = (EvenlyDiscretizedFunc)meanFuncs.get(j);
                for (int k = 0; k < func.size(); ++k) {
                    double val = func.getY(k);
                    double minVal = minFunc.getY(k);
                    if (minVal == 0.0 || val < minVal) {
                        minFunc.set(k, val);
                    }
                    if (val > maxFunc.getY(k)) {
                        maxFunc.set(k, val);
                    }
                    meanFunc.set(k, meanFunc.getY(k) + val);
                }
            }
        }
        for (int i = 0; i < meanFuncs.size(); ++i) {
            EvenlyDiscretizedFunc evenlyDiscretizedFunc = (EvenlyDiscretizedFunc)meanFuncs.get(i);
            for (int index = 0; index < evenlyDiscretizedFunc.size(); ++index) {
                evenlyDiscretizedFunc.set(index, evenlyDiscretizedFunc.getY(index) / (double)numSols);
            }
        }
        ArrayList funcs = Lists.newArrayList();
        ArrayList arrayList = Lists.newArrayList();
        funcs.addAll(otherFuncs);
        arrayList.addAll(otherChars);
        PlotCurveCharacterstics meanChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED);
        PlotCurveCharacterstics minChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
        PlotCurveCharacterstics maxChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
        for (int i = 0; i < meanFuncs.size(); ++i) {
            funcs.add((DiscretizedFunc)minFuncs.get(i));
            funcs.add((DiscretizedFunc)maxFuncs.get(i));
            funcs.add((DiscretizedFunc)meanFuncs.get(i));
            arrayList.add(minChar);
            arrayList.add(maxChar);
            arrayList.add(meanChar);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        CommandLineInversionRunner.setFontSizes(gp);
        gp.setYLog(true);
        gp.drawGraphPanel("", "Event Rate Per Year", funcs, arrayList, "Paleosiesmic Constraint Fit");
        File file = new File(dir, prefix + "_paleo_bounds");
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
    }

    public static U3AverageFaultSystemSolution fromDirectory(InversionFaultSystemRupSet rupSet, File dir, String prefix) throws IOException {
        ArrayList<File> files = new ArrayList<File>();
        System.out.println("Loading average solution from: " + dir.getAbsolutePath());
        System.out.println("Prefix: " + prefix);
        for (File file : dir.listFiles()) {
            String name;
            if (file.isDirectory() && !(file = new File(file, file.getName() + ".bin")).exists() || !(name = file.getName()).endsWith(".bin") || !name.startsWith(prefix) || !name.contains("_run") || name.contains("_noMinRates")) continue;
            files.add(file);
        }
        Collections.sort(files, new FileNameComparator());
        int numSols = files.size();
        Preconditions.checkState((numSols > 1 ? 1 : 0) != 0, (Object)("must have at least 2 solutions! (found=" + numSols + ")"));
        System.out.println("Loading " + numSols + " solutions!");
        int numRups = rupSet.getNumRuptures();
        ArrayList rates = Lists.newArrayList();
        for (int i = 0; i < numSols; ++i) {
            double[] runRates = MatrixIO.doubleArrayFromFile((File)files.get(i));
            Preconditions.checkState((runRates.length == numRups ? 1 : 0) != 0, (Object)("Rate file is wrong size: " + runRates.length + " != " + numRups + " (" + ((File)files.get(i)).getName() + ")"));
            rates.add(runRates);
        }
        return new U3AverageFaultSystemSolution(rupSet, rates, null, null);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File file = new File("/tmp/asdf/file.zip");
        U3AverageFaultSystemSolution avg = U3FaultSystemIO.loadAvgInvSol(file);
        System.out.println(avg.getRupSet().getDeformationModel());
        System.exit(0);
        IncrementalMagFreqDist[] mfds = avg.calcParentSectionNucleationMFDs(301);
        PlotSpec spec = U3AverageFaultSystemSolution.getMFDConvergencePlotSpec(mfds, true, "SAF Mojave", 10);
        GraphWindow gw = new GraphWindow(spec.getPlotElems(), spec.getTitle(), spec.getChars(), false);
        gw.setX_AxisLabel(spec.getXAxisLabel());
        gw.setY_AxisLabel(spec.getYAxisLabel());
        gw.setDefaultCloseOperation(3);
        gw.setVisible(true);
    }

    @Override
    public Iterator<InversionFaultSystemSolution> iterator() {
        return new Iterator<InversionFaultSystemSolution>(){
            private int index = 0;

            @Override
            public boolean hasNext() {
                return this.index < U3AverageFaultSystemSolution.this.getNumSolutions();
            }

            @Override
            public InversionFaultSystemSolution next() {
                return U3AverageFaultSystemSolution.this.getSolution(this.index++);
            }

            @Override
            public void remove() {
                throw new UnsupportedOperationException("Not supported by this iterator");
            }
        };
    }

    private static class ParticipationComputeTask
    implements Task {
        private double[][] rates;
        private double[][] output;
        private int i;
        private boolean partic;
        private InversionFaultSystemRupSet rupSet;
        private double magLow;
        private double magHigh;

        public ParticipationComputeTask(double[][] rates, double[][] output, int i, boolean partic, double magLow, double magHigh, InversionFaultSystemRupSet rupSet) {
            this.rates = rates;
            this.output = output;
            this.i = i;
            this.partic = partic;
            this.rupSet = rupSet;
            this.magLow = magLow;
            this.magHigh = magHigh;
        }

        @Override
        public void compute() {
            double[] myRates = new double[this.rupSet.getNumRuptures()];
            for (int r = 0; r < this.rupSet.getNumRuptures(); ++r) {
                myRates[r] = this.rates[r][this.i];
            }
            InversionFaultSystemSolution mySol = new InversionFaultSystemSolution(this.rupSet, myRates);
            mySol.getRupSet().copyCacheFrom(this.rupSet);
            double[] myAnswer = this.partic ? mySol.calcParticRateForAllSects(this.magLow, this.magHigh) : mySol.calcSlipRateForAllSects();
            mySol.clearSolutionCacheOnly();
            for (int s = 0; s < this.rupSet.getNumSections(); ++s) {
                this.output[s][this.i] = myAnswer[s];
            }
        }
    }

    private static class SolRatesEntryComparator
    implements Comparator<ZipEntry> {
        private Collator c = Collator.getInstance();

        private SolRatesEntryComparator() {
        }

        @Override
        public int compare(ZipEntry o1, ZipEntry o2) {
            String n1 = o1.getName();
            String n2 = o2.getName();
            return this.c.compare(n1, n2);
        }
    }
}

