/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.NamedComparator;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.imr.attenRelImpl.BA_2008_AttenRel;
import org.opensha.sha.imr.param.OtherParams.Component;
import org.opensha.sha.imr.param.PropagationEffectParams.DistanceJBParameter;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.analysis.GMT_CA_Maps;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.DeformationModelFileParser;
import scratch.UCERF3.utils.DeformationModelOffFaultMoRateData;
import scratch.UCERF3.utils.FaultSectionDataWriter;
import scratch.UCERF3.utils.FindEquivUCERF2_Ruptures.FindEquivUCERF2_FM3_Ruptures;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.SmoothSeismicitySpatialPDF_Fetcher;
import scratch.UCERF3.utils.UCERF2_A_FaultMapper;
import scratch.UCERF3.utils.UCERF2_Section_MFDs.UCERF2_Section_MFDsCalc;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class DeformationModelsCalc {
    /*
     * WARNING - void declaration
     */
    public static void plotDDW_AndLowerSeisDepthDistributions(List<FaultSection> subsectData, String plotTitle) {
        void var16_15;
        HistogramFunction origDepthsHist = new HistogramFunction(0.5, 70, 1.0);
        HistogramFunction reducedDDW_Hist = new HistogramFunction(0.5, 70, 1.0);
        ArrayList<CallSite> largeValuesInfoLSD = new ArrayList<CallSite>();
        ArrayList<CallSite> largeValuesInfoDDW = new ArrayList<CallSite>();
        double meanLSD = 0.0;
        double meanDDW = 0.0;
        double meanLowerMinusUpperSeisDepth = 0.0;
        int num = 0;
        double totWt = 0.0;
        for (FaultSection faultSection : subsectData) {
            String info;
            String string;
            if (faultSection.getAveLowerDepth() > 25.0 && !largeValuesInfoLSD.contains(string = faultSection.getParentSectionName() + "\tLowSeisDep = " + Math.round(faultSection.getAveLowerDepth()))) {
                largeValuesInfoLSD.add((CallSite)((Object)string));
            }
            ++num;
            meanLSD += faultSection.getAveLowerDepth();
            origDepthsHist.add(faultSection.getAveLowerDepth(), 1.0);
            meanDDW += faultSection.getReducedDownDipWidth();
            double d = faultSection.getReducedAveSlipRate();
            if (Double.isNaN(d)) {
                System.out.println("NaN slip rate: " + faultSection.getName());
                d = 0.0;
            } else {
                totWt += d;
            }
            meanLowerMinusUpperSeisDepth += d * (1.0 - faultSection.getAseismicSlipFactor()) * (faultSection.getAveLowerDepth() - faultSection.getOrigAveUpperDepth());
            reducedDDW_Hist.add(faultSection.getReducedDownDipWidth(), 1.0);
            if (!(faultSection.getReducedDownDipWidth() > 25.0) || largeValuesInfoDDW.contains(info = faultSection.getParentSectionName() + "\tDownDipWidth = " + Math.round(faultSection.getReducedDownDipWidth()))) continue;
            largeValuesInfoDDW.add((CallSite)((Object)info));
        }
        meanDDW /= (double)num;
        System.out.println("meanLowerMinusUpperSeisDepth=" + (meanLowerMinusUpperSeisDepth /= totWt));
        origDepthsHist.normalizeBySumOfY_Vals();
        origDepthsHist.setName("Distribution of Lower Seis. Depths; mean = " + Math.round(meanLSD /= (double)num));
        Object infoLSW = "(among all fault subsections, and not influcenced by aseismicity)\n\nValues greater than 25km:\n\n";
        for (String string : largeValuesInfoLSD) {
            infoLSW = (String)infoLSW + "\t" + string + "\n";
        }
        origDepthsHist.setInfo((String)infoLSW);
        reducedDDW_Hist.normalizeBySumOfY_Vals();
        reducedDDW_Hist.setName("Distribution of Down-Dip Widths; mean = " + Math.round(meanDDW));
        String string = "(among all fault subsections, and reduced by aseismicity)\n\nValues greater than 25km:\n\n";
        for (String string2 : largeValuesInfoDDW) {
            String string3 = (String)var16_15 + "\t" + string2 + "\n";
        }
        reducedDDW_Hist.setInfo((String)var16_15);
        ArrayList<HistogramFunction> arrayList = new ArrayList<HistogramFunction>();
        arrayList.add(origDepthsHist);
        arrayList.add(reducedDDW_Hist);
        GraphWindow graphWindow = new GraphWindow(arrayList, plotTitle);
        graphWindow.setX_AxisLabel("Depth or Width (km)");
        graphWindow.setY_AxisLabel("Normalized Number");
    }

    public static double calculateTotalMomentRate(List<? extends FaultSection> sectData, boolean creepReduced) {
        double totMoRate = 0.0;
        for (FaultSection faultSection : sectData) {
            double moRate = faultSection.calcMomentRate(creepReduced);
            if (Double.isNaN(moRate)) continue;
            totMoRate += moRate;
        }
        return totMoRate;
    }

    public static void testFaultZonePolygons(FaultModels faultModel) {
        double sectLen = 7.0;
        List<FaultSection> faultData = faultModel.getFaultSections();
        ArrayList sectData = Lists.newArrayList();
        for (FaultSection fault : faultData) {
            sectData.addAll(fault.getSubSectionsList(sectLen));
        }
        FaultPolyMgr polyMgr = FaultPolyMgr.create(faultModel, null, sectLen);
        ArrayList<String> nullNames = new ArrayList<String>();
        ArrayList<CallSite> outsideZoneNames = new ArrayList<CallSite>();
        ArrayList<String> goodZoneNames = new ArrayList<String>();
        for (FaultSection faultSection : sectData) {
            Region zone = polyMgr.getPoly(faultSection.getSectionId());
            if (zone == null) {
                if (nullNames.contains(faultSection.getSectionName())) continue;
                nullNames.add(faultSection.getSectionName());
                continue;
            }
            LocationList surfLocs = faultSection.getFaultSurface(1.0, false, false).getEvenlyDiscritizedListOfLocsOnSurface();
            boolean good = true;
            for (Location loc : surfLocs) {
                double dist;
                if (zone.contains(loc) || !((dist = zone.distanceToLocation(loc)) > 0.5)) continue;
                if (!outsideZoneNames.contains(faultSection.getSectionName())) {
                    outsideZoneNames.add((CallSite)((Object)(faultSection.getSectionName() + "\t\tLoc that's outside:" + (float)loc.getLatitude() + "\t" + (float)loc.getLongitude())));
                }
                good = false;
                break;
            }
            if (!good || goodZoneNames.contains(faultSection.getSectionName())) continue;
            goodZoneNames.add(faultSection.getSectionName());
        }
        System.out.println("\nThese sections have null fault zone polygons\n");
        for (String string : nullNames) {
            System.out.println("\t" + string);
        }
        System.out.println("\nThese sections have surface points outside the fault zone polygon\n");
        for (String string : outsideZoneNames) {
            System.out.println("\t" + string);
        }
        System.out.println("\nThese sections are good (have all surface points inside the fault zone polygon)\n");
        for (String string : goodZoneNames) {
            System.out.println("\t" + string);
        }
    }

    public static double calcFaultMoRateForDefModel(FaultModels fm, DeformationModels dm, boolean creepReduced) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        return DeformationModelsCalc.calculateTotalMomentRate(defFetch.getSubSectionList(), true);
    }

    public static double calcTotalMoRateForDefModel(FaultModels fm, DeformationModels dm, boolean creepReduced) {
        return DeformationModelsCalc.calcFaultMoRateForDefModel(fm, dm, creepReduced) + DeformationModelsCalc.calcMoRateOffFaultsForDefModel(fm, dm);
    }

    public static double calcMoRateOffFaultsForDefModel(FaultModels fm, DeformationModels dm) {
        DeformationModelOffFaultMoRateData offFaultData = DeformationModelOffFaultMoRateData.getInstance();
        return offFaultData.getTotalOffFaultMomentRate(fm, dm);
    }

    private static String getTableLineForMoRateAndMmaxDataForDefModels(FaultModels fm, DeformationModels dm, double rateM5) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        double moRate = DeformationModelsCalc.calculateTotalMomentRate(defFetch.getSubSectionList(), true);
        System.out.println(fm.getName() + ", " + dm.getName() + " (reduced):\t" + (float)moRate);
        System.out.println(fm.getName() + ", " + dm.getName() + " (not reduced):\t" + (float)DeformationModelsCalc.calculateTotalMomentRate(defFetch.getSubSectionList(), false));
        double moRateOffFaults = DeformationModelsCalc.calcMoRateOffFaultsForDefModel(fm, dm);
        double totMoRate = moRate + moRateOffFaults;
        double fractOff = moRateOffFaults / totMoRate;
        GutenbergRichterMagFreqDist targetMFD = new GutenbergRichterMagFreqDist(5.0E-4, 9.9995, 10000);
        targetMFD.setAllButMagUpper(5.0E-4, totMoRate, rateM5 * 100000.0, 1.0, true);
        ArrayList<String> getEquivUCERF2_SectionNames = FindEquivUCERF2_FM3_Ruptures.getAllSectionNames(fm);
        ArrayList<FaultSection> newSectionData = new ArrayList<FaultSection>();
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (getEquivUCERF2_SectionNames.contains(faultSection.getParentSectionName())) continue;
            newSectionData.add(faultSection);
        }
        double newFaultMoRate = DeformationModelsCalc.calculateTotalMomentRate(newSectionData, true);
        System.out.println("totMoRate=" + (float)totMoRate + "\tgetTotalMomentRate()=" + (float)targetMFD.getTotalMomentRate() + "\tMgt4rate=" + (float)targetMFD.getCumRate(4.0005) + "\tupperMag=" + targetMFD.getMagUpper() + "\tMgt8rate=" + (float)targetMFD.getCumRate(8.0005));
        return String.valueOf(fm) + "\t" + String.valueOf(dm) + "\t" + (float)(moRate / 1.0E19) + "\t" + (float)fractOff + "\t" + (float)(moRateOffFaults / 1.0E19) + "\t" + (float)(totMoRate / 1.0E19) + "\t" + (float)targetMFD.getMagUpper() + "\t" + (float)targetMFD.getCumRate(8.0005) + "\t" + (float)(1.0 / targetMFD.getCumRate(8.0005)) + "\t" + (float)(newFaultMoRate / 1.0E19);
    }

    public static void writeAveMoRateOfParentSectionsInsideRegion(Region region) {
        int i;
        double newMoRate;
        int index;
        double moRate;
        double frcInside;
        RuptureSurface surf;
        ArrayList<Double> u3_MoRateInside = new ArrayList<Double>();
        ArrayList<String> u3_SectNameInside = new ArrayList<String>();
        FaultModels[] fm_array = FaultModels.values();
        DeformationModels[] dm_array = DeformationModels.values();
        for (FaultModels fm : fm_array) {
            for (DeformationModels dm : dm_array) {
                if (!(fm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) > 0.0) || !(dm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) > 0.0)) continue;
                DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
                System.out.println(String.valueOf(fm) + "\t" + fm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) + "\t" + String.valueOf(dm) + "\t" + dm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED));
                for (FaultSection faultSection : defFetch.getSubSectionList()) {
                    surf = faultSection.getFaultSurface(1.0);
                    frcInside = surf.getFractionOfSurfaceInRegion(region);
                    if (!(frcInside > 1.0E-4)) continue;
                    moRate = frcInside * faultSection.calcMomentRate(true) * fm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) * dm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED);
                    String u3_name = faultSection.getParentSectionName();
                    if (!u3_SectNameInside.contains(u3_name)) {
                        u3_SectNameInside.add(u3_name);
                        u3_MoRateInside.add(moRate);
                        continue;
                    }
                    index = u3_SectNameInside.indexOf(u3_name);
                    newMoRate = (Double)u3_MoRateInside.get(index) + moRate;
                    u3_MoRateInside.set(index, newMoRate);
                }
            }
        }
        double total = 0.0;
        System.out.println("\nUCERF3 section moment rates inside " + region.getName() + ":");
        for (int i2 = 0; i2 < u3_MoRateInside.size(); ++i2) {
            System.out.println((float)((Double)u3_MoRateInside.get(i2)).doubleValue() + "\t" + (String)u3_SectNameInside.get(i2));
            total += ((Double)u3_MoRateInside.get(i2)).doubleValue();
        }
        System.out.println("UCERF3 total = " + (float)total);
        int[] u2_dm_array = new int[]{82, 83, 84, 85, 86, 87};
        double[] u2_dm_wts_array = new double[]{0.25, 0.1, 0.15, 0.25, 0.1, 0.15};
        ArrayList<Double> u2_MoRateInside = new ArrayList<Double>();
        ArrayList<String> u2_SectNameInside = new ArrayList<String>();
        for (i = 0; i < u2_dm_array.length; ++i) {
            int dmID = u2_dm_array[i];
            for (FaultSection faultSection : DeformationModelFetcher.getAll_UCERF2Sections(false, dmID)) {
                surf = faultSection.getFaultSurface(1.0);
                frcInside = surf.getFractionOfSurfaceInRegion(region);
                if (!(frcInside > 1.0E-4)) continue;
                moRate = frcInside * faultSection.calcMomentRate(true) * u2_dm_wts_array[i];
                String u2_name = faultSection.getSectionName();
                if (!u2_SectNameInside.contains(u2_name)) {
                    u2_SectNameInside.add(u2_name);
                    u2_MoRateInside.add(moRate);
                    continue;
                }
                index = u2_SectNameInside.indexOf(u2_name);
                newMoRate = (Double)u2_MoRateInside.get(index) + moRate;
                u2_MoRateInside.set(index, newMoRate);
            }
        }
        total = 0.0;
        System.out.println("\nUCERF2 section moment rates inside " + region.getName() + ":");
        for (i = 0; i < u2_MoRateInside.size(); ++i) {
            System.out.println((float)((Double)u2_MoRateInside.get(i)).doubleValue() + "\t" + (String)u2_SectNameInside.get(i));
            total += ((Double)u2_MoRateInside.get(i)).doubleValue();
        }
        System.out.println("UCERF2 total = " + (float)total);
    }

    public static void writeParentSectionsNearSite(Location loc, int maxNumSectionsToList) {
        int i;
        BA_2008_AttenRel ba2008 = new BA_2008_AttenRel(null);
        ba2008.setIntensityMeasure("SA");
        ba2008.getParameter("SA Period").setValue(1.0);
        double vs30 = 400.0;
        double mag = 7.0;
        String faultType = "Unknown";
        Component component = Component.GMRotI50;
        ba2008.getParameter("Vs30").setValue(vs30);
        ba2008.getParameter("Magnitude").setValue(mag);
        ba2008.getParameter("Fault Type").setValue(faultType);
        ba2008.getParameter("Component").setValue(component);
        EvenlyDiscretizedFunc imlVsDistFunc = new EvenlyDiscretizedFunc(0.0, 201.0, 202);
        for (int i2 = 0; i2 < imlVsDistFunc.size(); ++i2) {
            Double dist = imlVsDistFunc.getX(i2);
            DistanceJBParameter distParm = (DistanceJBParameter)ba2008.getParameter("DistanceJB");
            distParm.setValueIgnoreWarning(dist);
            imlVsDistFunc.set(i2, Math.exp(ba2008.getMean()));
        }
        ArrayList<Double> u3_ParSectMoRate = new ArrayList<Double>();
        ArrayList<Double> u3_ParSectMinDist = new ArrayList<Double>();
        ArrayList<Double> u3_ParSectHazProxy = new ArrayList<Double>();
        ArrayList<String> u3_SectName = new ArrayList<String>();
        FaultModels[] fm_array = FaultModels.values();
        DeformationModels[] dm_array = DeformationModels.values();
        for (FaultModels fm : fm_array) {
            for (DeformationModels dm : dm_array) {
                if (!(fm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) > 0.0) || !(dm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) > 0.0)) continue;
                DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
                for (FaultSection faultSection : defFetch.getSubSectionList()) {
                    RuptureSurface ruptureSurface = faultSection.getFaultSurface(1.0);
                    double distJB = ruptureSurface.getDistanceJB(loc);
                    if (!(distJB <= 200.0)) continue;
                    double moRate = faultSection.calcMomentRate(true) * fm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) * dm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED);
                    String u3_name = faultSection.getParentSectionName();
                    if (!u3_SectName.contains(u3_name)) {
                        u3_SectName.add(u3_name);
                        u3_ParSectMoRate.add(moRate);
                        u3_ParSectMinDist.add(distJB);
                        continue;
                    }
                    int index = u3_SectName.indexOf(u3_name);
                    double newMoRate = (Double)u3_ParSectMoRate.get(index) + moRate;
                    u3_ParSectMoRate.set(index, newMoRate);
                    if (!(distJB < (Double)u3_ParSectMinDist.get(index))) continue;
                    u3_ParSectMinDist.set(index, distJB);
                }
            }
        }
        for (int i3 = 0; i3 < u3_ParSectMinDist.size(); ++i3) {
            u3_ParSectHazProxy.add((Double)u3_ParSectMoRate.get(i3) * imlVsDistFunc.getInterpolatedY((Double)u3_ParSectMinDist.get(i3)));
        }
        List<Integer> sortedIndices = DataUtils.sortedIndices(u3_ParSectHazProxy, false);
        System.out.println("UCERF3:");
        System.out.println("minDistJB\tMoRate\thazProxy\tSectName");
        for (int i4 = 0; i4 < maxNumSectionsToList; ++i4) {
            int index = sortedIndices.get(i4);
            System.out.println(String.valueOf(u3_ParSectMinDist.get(index)) + "\t" + String.valueOf(u3_ParSectMoRate.get(index)) + "\t" + String.valueOf(u3_ParSectHazProxy.get(index)) + "\t" + (String)u3_SectName.get(index));
        }
        int[] u2_dm_array = new int[]{82, 83, 84, 85, 86, 87};
        double[] u2_dm_wts_array = new double[]{0.25, 0.1, 0.15, 0.25, 0.1, 0.15};
        ArrayList<Double> u2_ParSectMoRate = new ArrayList<Double>();
        ArrayList<Double> u2_ParSectMinDist = new ArrayList<Double>();
        ArrayList<Double> u2_ParSectHazProxy = new ArrayList<Double>();
        ArrayList<String> u2_SectName = new ArrayList<String>();
        for (i = 0; i < u2_dm_array.length; ++i) {
            int dmID = u2_dm_array[i];
            for (FaultSection faultSection : DeformationModelFetcher.getAll_UCERF2Sections(false, dmID)) {
                RuptureSurface surf = faultSection.getFaultSurface(1.0);
                double distJB = surf.getDistanceJB(loc);
                if (!(distJB <= 200.0)) continue;
                double moRate = faultSection.calcMomentRate(true) * u2_dm_wts_array[i];
                String u2_name = faultSection.getSectionName();
                if (!u2_SectName.contains(u2_name)) {
                    u2_SectName.add(u2_name);
                    u2_ParSectMoRate.add(moRate);
                    u2_ParSectMinDist.add(distJB);
                    continue;
                }
                int index = u2_SectName.indexOf(u2_name);
                double newMoRate = (Double)u2_ParSectMoRate.get(index) + moRate;
                u2_ParSectMoRate.set(index, newMoRate);
                if (!(distJB < (Double)u2_ParSectMinDist.get(index))) continue;
                u2_ParSectMinDist.set(index, distJB);
            }
        }
        for (i = 0; i < u2_ParSectMinDist.size(); ++i) {
            u2_ParSectHazProxy.add((Double)u2_ParSectMoRate.get(i) * imlVsDistFunc.getInterpolatedY((Double)u2_ParSectMinDist.get(i)));
        }
        List<Integer> sortedIndices2 = DataUtils.sortedIndices(u2_ParSectHazProxy, false);
        System.out.println("UCERF2:");
        System.out.println("minDistJB\tMoRate\thazProxy\tSectName");
        for (int i5 = 0; i5 < maxNumSectionsToList; ++i5) {
            int n = sortedIndices2.get(i5);
            System.out.println(String.valueOf(u2_ParSectMinDist.get(n)) + "\t" + String.valueOf(u2_ParSectMoRate.get(n)) + "\t" + String.valueOf(u2_ParSectHazProxy.get(n)) + "\t" + (String)u2_SectName.get(n));
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void writeMoRateOfParentSectionsForAllDefAndFaultModels() {
        ArrayList<String> fm3_sectionNamesList = new ArrayList<String>();
        ArrayList<Integer> fm3_sectionIDsList = new ArrayList<Integer>();
        DeformationModelFetcher defFetch = new DeformationModelFetcher(FaultModels.FM3_1, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (fm3_sectionNamesList.contains(faultSection.getParentSectionName())) continue;
            fm3_sectionNamesList.add(faultSection.getParentSectionName());
            fm3_sectionIDsList.add(faultSection.getParentSectionId());
        }
        defFetch = new DeformationModelFetcher(FaultModels.FM3_2, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (fm3_sectionNamesList.contains(faultSection.getParentSectionName())) continue;
            fm3_sectionNamesList.add(faultSection.getParentSectionName());
            fm3_sectionIDsList.add(faultSection.getParentSectionId());
        }
        boolean creepReduced = true;
        Hashtable<Integer, Double> hashtable = DeformationModelsCalc.getParentSectMoRateHashtable(FaultModels.FM3_1, DeformationModels.ZENGBB, creepReduced);
        Hashtable<Integer, Double> moRateForFM3pt1_NeoKinema = DeformationModelsCalc.getParentSectMoRateHashtable(FaultModels.FM3_1, DeformationModels.NEOKINEMA, creepReduced);
        Hashtable<Integer, Double> moRateForFM3pt1_Geologic = DeformationModelsCalc.getParentSectMoRateHashtable(FaultModels.FM3_1, DeformationModels.GEOLOGIC, creepReduced);
        Hashtable<Integer, Double> moRateForFM3pt1_ABM = DeformationModelsCalc.getParentSectMoRateHashtable(FaultModels.FM3_1, DeformationModels.ABM, creepReduced);
        Hashtable<Integer, Double> moRateForFM3pt2_Zeng = DeformationModelsCalc.getParentSectMoRateHashtable(FaultModels.FM3_2, DeformationModels.ZENGBB, creepReduced);
        Hashtable<Integer, Double> moRateForFM3pt2_NeoKinema = DeformationModelsCalc.getParentSectMoRateHashtable(FaultModels.FM3_2, DeformationModels.NEOKINEMA, creepReduced);
        Hashtable<Integer, Double> moRateForFM3pt2_Geologic = DeformationModelsCalc.getParentSectMoRateHashtable(FaultModels.FM3_2, DeformationModels.GEOLOGIC, creepReduced);
        Hashtable<Integer, Double> moRateForFM3pt2_ABM = DeformationModelsCalc.getParentSectMoRateHashtable(FaultModels.FM3_2, DeformationModels.ABM, creepReduced);
        HashMap<String, String> u2nameFromU3NameMapFM3pt1 = null;
        HashMap<String, String> u2nameFromU3NameMapFM3pt2 = null;
        try {
            u2nameFromU3NameMapFM3pt1 = UCERF2_Section_MFDsCalc.loadUCERF3toUCER2NameMappingFile(FaultModels.FM3_1);
            u2nameFromU3NameMapFM3pt2 = UCERF2_Section_MFDsCalc.loadUCERF3toUCER2NameMappingFile(FaultModels.FM3_2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> newFaultSectionsList = DeformationModelsCalc.getListOfNewFaultSectionNames();
        HashMap<String, Double> moRateForDM2pt1 = DeformationModelsCalc.getMoRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 82), creepReduced);
        HashMap<String, Double> moRateForDM2pt2 = DeformationModelsCalc.getMoRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 83), creepReduced);
        HashMap<String, Double> moRateForDM2pt3 = DeformationModelsCalc.getMoRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 84), creepReduced);
        HashMap<String, Double> moRateForDM2pt4 = DeformationModelsCalc.getMoRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 85), creepReduced);
        HashMap<String, Double> moRateForDM2pt5 = DeformationModelsCalc.getMoRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 86), creepReduced);
        HashMap<String, Double> moRateForDM2pt6 = DeformationModelsCalc.getMoRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 87), creepReduced);
        ArrayList<Object> lines = new ArrayList<Object>();
        Object line = "sectName\tsectID\tFM3pt1_Zeng\tFM3pt1_NeoKinema\tFM3pt1_Geologic\tFM3pt1_ABM\tFM3pt2_Zeng\tFM3pt2_NeoKinema\tFM3pt2_Geologic\tFM3pt2_ABM";
        line = (String)line + "\tu2_name\tDM2pt1\tDM2pt2\tDM2pt3\tDM2pt4\tDM2pt5\tDM2pt6";
        lines.add(line);
        for (int s = 0; s < fm3_sectionNamesList.size(); ++s) {
            void var26_34;
            void var26_39;
            void var26_37;
            int id = (Integer)fm3_sectionIDsList.get(s);
            String u3_name = (String)fm3_sectionNamesList.get(s);
            line = u3_name;
            line = (String)line + "\t" + id;
            line = (String)line + "\t" + String.valueOf(hashtable.get(id));
            line = (String)line + "\t" + String.valueOf(moRateForFM3pt1_NeoKinema.get(id));
            line = (String)line + "\t" + String.valueOf(moRateForFM3pt1_Geologic.get(id));
            line = (String)line + "\t" + String.valueOf(moRateForFM3pt1_ABM.get(id));
            line = (String)line + "\t" + String.valueOf(moRateForFM3pt2_Zeng.get(id));
            line = (String)line + "\t" + String.valueOf(moRateForFM3pt2_NeoKinema.get(id));
            line = (String)line + "\t" + String.valueOf(moRateForFM3pt2_Geologic.get(id));
            line = (String)line + "\t" + String.valueOf(moRateForFM3pt2_ABM.get(id));
            String string = u2nameFromU3NameMapFM3pt1.get(u3_name);
            if (string == null) {
                String string2 = u2nameFromU3NameMapFM3pt2.get(u3_name);
            }
            if (var26_37 == null) {
                String string3 = u3_name;
            }
            if (newFaultSectionsList.contains(var26_39)) {
                Object var26_40 = null;
            } else if (var26_39.equals("Green Valley 2011 CFM")) {
                Object var26_41 = null;
            }
            line = (String)line + "\t" + (String)var26_34;
            line = (String)line + "\t" + String.valueOf(moRateForDM2pt1.get(var26_34));
            line = (String)line + "\t" + String.valueOf(moRateForDM2pt2.get(var26_34));
            line = (String)line + "\t" + String.valueOf(moRateForDM2pt3.get(var26_34));
            line = (String)line + "\t" + String.valueOf(moRateForDM2pt4.get(var26_34));
            line = (String)line + "\t" + String.valueOf(moRateForDM2pt5.get(var26_34));
            line = (String)line + "\t" + String.valueOf(moRateForDM2pt6.get(var26_34));
            lines.add(line);
        }
        File dataFile = new File("dev/scratch/UCERF3/data/scratch/FaultSectionMomentRates.txt");
        try {
            FileWriter fw = new FileWriter(dataFile);
            for (String string : lines) {
                fw.write(string + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
    }

    public static void writeAveSlipRateEtcOfParentSectionsForAllDefAndFaultModels() {
        int parSectID;
        int s;
        ArrayList<String> fm3_sectionNamesList = new ArrayList<String>();
        ArrayList<Integer> fm3_sectionIDsList = new ArrayList<Integer>();
        DeformationModelFetcher defFetch = new DeformationModelFetcher(FaultModels.FM3_1, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (fm3_sectionNamesList.contains(faultSection.getParentSectionName())) continue;
            fm3_sectionNamesList.add(faultSection.getParentSectionName());
            fm3_sectionIDsList.add(faultSection.getParentSectionId());
        }
        defFetch = new DeformationModelFetcher(FaultModels.FM3_2, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (fm3_sectionNamesList.contains(faultSection.getParentSectionName())) continue;
            fm3_sectionNamesList.add(faultSection.getParentSectionName());
            fm3_sectionIDsList.add(faultSection.getParentSectionId());
        }
        double[] fm3_sectionLengthList = new double[fm3_sectionNamesList.size()];
        double[] dArray = new double[fm3_sectionNamesList.size()];
        boolean[] sectionDone = new boolean[fm3_sectionNamesList.size()];
        defFetch = new DeformationModelFetcher(FaultModels.FM3_1, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (s = 0; s < fm3_sectionIDsList.size(); ++s) {
            sectionDone[s] = false;
            parSectID = (Integer)fm3_sectionIDsList.get(s);
            for (FaultSection faultSection : defFetch.getSubSectionList()) {
                if (faultSection.getParentSectionId() != parSectID) continue;
                int n = s;
                fm3_sectionLengthList[n] = fm3_sectionLengthList[n] + faultSection.getTraceLength();
                int n2 = s;
                dArray[n2] = dArray[n2] + faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
                sectionDone[s] = true;
            }
        }
        defFetch = new DeformationModelFetcher(FaultModels.FM3_2, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (s = 0; s < fm3_sectionIDsList.size(); ++s) {
            if (sectionDone[s]) continue;
            parSectID = (Integer)fm3_sectionIDsList.get(s);
            for (FaultSection faultSection : defFetch.getSubSectionList()) {
                if (faultSection.getParentSectionId() != parSectID) continue;
                int n = s;
                fm3_sectionLengthList[n] = fm3_sectionLengthList[n] + faultSection.getTraceLength();
                int n3 = s;
                dArray[n3] = dArray[n3] + faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
            }
        }
        boolean creepReduced = false;
        Hashtable<Integer, Double> slipRateForFM3pt1_Zeng = DeformationModelsCalc.getParentSectAveSlipRateHashtable(FaultModels.FM3_1, DeformationModels.ZENGBB, creepReduced);
        Hashtable<Integer, Double> slipRateForFM3pt1_NeoKinema = DeformationModelsCalc.getParentSectAveSlipRateHashtable(FaultModels.FM3_1, DeformationModels.NEOKINEMA, creepReduced);
        Hashtable<Integer, Double> hashtable = DeformationModelsCalc.getParentSectAveSlipRateHashtable(FaultModels.FM3_1, DeformationModels.GEOLOGIC, creepReduced);
        Hashtable<Integer, Double> slipRateForFM3pt1_ABM = DeformationModelsCalc.getParentSectAveSlipRateHashtable(FaultModels.FM3_1, DeformationModels.ABM, creepReduced);
        Hashtable<Integer, Double> slipRateForFM3pt2_Zeng = DeformationModelsCalc.getParentSectAveSlipRateHashtable(FaultModels.FM3_2, DeformationModels.ZENGBB, creepReduced);
        Hashtable<Integer, Double> slipRateForFM3pt2_NeoKinema = DeformationModelsCalc.getParentSectAveSlipRateHashtable(FaultModels.FM3_2, DeformationModels.NEOKINEMA, creepReduced);
        Hashtable<Integer, Double> slipRateForFM3pt2_Geologic = DeformationModelsCalc.getParentSectAveSlipRateHashtable(FaultModels.FM3_2, DeformationModels.GEOLOGIC, creepReduced);
        Hashtable<Integer, Double> slipRateForFM3pt2_ABM = DeformationModelsCalc.getParentSectAveSlipRateHashtable(FaultModels.FM3_2, DeformationModels.ABM, creepReduced);
        Hashtable<Integer, Double> aseisForFM3pt1_Zeng = DeformationModelsCalc.getParentSectAveAseisHashtable(FaultModels.FM3_1, DeformationModels.ZENGBB);
        Hashtable<Integer, Double> aseisForFM3pt1_NeoKinema = DeformationModelsCalc.getParentSectAveAseisHashtable(FaultModels.FM3_1, DeformationModels.NEOKINEMA);
        Hashtable<Integer, Double> aseisForFM3pt1_Geologic = DeformationModelsCalc.getParentSectAveAseisHashtable(FaultModels.FM3_1, DeformationModels.GEOLOGIC);
        Hashtable<Integer, Double> aseisForFM3pt1_ABM = DeformationModelsCalc.getParentSectAveAseisHashtable(FaultModels.FM3_1, DeformationModels.ABM);
        Hashtable<Integer, Double> aseisForFM3pt2_Zeng = DeformationModelsCalc.getParentSectAveAseisHashtable(FaultModels.FM3_2, DeformationModels.ZENGBB);
        Hashtable<Integer, Double> aseisForFM3pt2_NeoKinema = DeformationModelsCalc.getParentSectAveAseisHashtable(FaultModels.FM3_2, DeformationModels.NEOKINEMA);
        Hashtable<Integer, Double> aseisForFM3pt2_Geologic = DeformationModelsCalc.getParentSectAveAseisHashtable(FaultModels.FM3_2, DeformationModels.GEOLOGIC);
        Hashtable<Integer, Double> aseisForFM3pt2_ABM = DeformationModelsCalc.getParentSectAveAseisHashtable(FaultModels.FM3_2, DeformationModels.ABM);
        Hashtable<Integer, Double> ccForFM3pt1_Zeng = DeformationModelsCalc.getParentSectAveCouplingCoeffHashtable(FaultModels.FM3_1, DeformationModels.ZENGBB);
        Hashtable<Integer, Double> ccForFM3pt1_NeoKinema = DeformationModelsCalc.getParentSectAveCouplingCoeffHashtable(FaultModels.FM3_1, DeformationModels.NEOKINEMA);
        Hashtable<Integer, Double> ccForFM3pt1_Geologic = DeformationModelsCalc.getParentSectAveCouplingCoeffHashtable(FaultModels.FM3_1, DeformationModels.GEOLOGIC);
        Hashtable<Integer, Double> ccForFM3pt1_ABM = DeformationModelsCalc.getParentSectAveCouplingCoeffHashtable(FaultModels.FM3_1, DeformationModels.ABM);
        Hashtable<Integer, Double> ccForFM3pt2_Zeng = DeformationModelsCalc.getParentSectAveCouplingCoeffHashtable(FaultModels.FM3_2, DeformationModels.ZENGBB);
        Hashtable<Integer, Double> ccForFM3pt2_NeoKinema = DeformationModelsCalc.getParentSectAveCouplingCoeffHashtable(FaultModels.FM3_2, DeformationModels.NEOKINEMA);
        Hashtable<Integer, Double> ccForFM3pt2_Geologic = DeformationModelsCalc.getParentSectAveCouplingCoeffHashtable(FaultModels.FM3_2, DeformationModels.GEOLOGIC);
        Hashtable<Integer, Double> ccForFM3pt2_ABM = DeformationModelsCalc.getParentSectAveCouplingCoeffHashtable(FaultModels.FM3_2, DeformationModels.ABM);
        HashMap<String, String> u2nameFromU3NameMapFM3pt1 = null;
        HashMap<String, String> u2nameFromU3NameMapFM3pt2 = null;
        try {
            u2nameFromU3NameMapFM3pt1 = UCERF2_Section_MFDsCalc.loadUCERF3toUCER2NameMappingFile(FaultModels.FM3_1);
            u2nameFromU3NameMapFM3pt2 = UCERF2_Section_MFDsCalc.loadUCERF3toUCER2NameMappingFile(FaultModels.FM3_2);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<String> newFaultSectionsList = DeformationModelsCalc.getListOfNewFaultSectionNames();
        HashMap<String, Double> slipRateForDM2pt1 = DeformationModelsCalc.getOrigSlipRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 82));
        HashMap<String, Double> slipRateForDM2pt2 = DeformationModelsCalc.getOrigSlipRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 83));
        HashMap<String, Double> slipRateForDM2pt3 = DeformationModelsCalc.getOrigSlipRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 84));
        HashMap<String, Double> slipRateForDM2pt4 = DeformationModelsCalc.getOrigSlipRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 85));
        HashMap<String, Double> slipRateForDM2pt5 = DeformationModelsCalc.getOrigSlipRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 86));
        HashMap<String, Double> slipRateForDM2pt6 = DeformationModelsCalc.getOrigSlipRateHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 87));
        HashMap<String, Double> lengthForDM2pt1 = DeformationModelsCalc.getLengthHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 82));
        HashMap<String, Double> lengthForDM2pt4 = DeformationModelsCalc.getLengthHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 85));
        HashMap<String, Double> origAreaForDM2pt1 = DeformationModelsCalc.getOrigAreaHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 82));
        HashMap<String, Double> origAreaForDM2pt4 = DeformationModelsCalc.getOrigAreaHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 85));
        HashMap<String, Double> aseisForDM2pt1 = DeformationModelsCalc.getAseisHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 82));
        HashMap<String, Double> aseisForDM2pt4 = DeformationModelsCalc.getAseisHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 85));
        HashMap<String, Double> ccForDM2pt1 = DeformationModelsCalc.getCouplingCoeffHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 82));
        HashMap<String, Double> ccForDM2pt4 = DeformationModelsCalc.getCouplingCoeffHashtable(DeformationModelFetcher.getAll_UCERF2Sections(false, 85));
        ArrayList<Object> lines = new ArrayList<Object>();
        Object line = "sectName\tsectID\tLength\torigArea";
        line = (String)line + "\tFM3pt1_Zeng\tFM3pt1_NeoKinema\tFM3pt1_Geologic\tFM3pt1_ABM\tFM3pt2_Zeng\tFM3pt2_NeoKinema\tFM3pt2_Geologic\tFM3pt2_ABM";
        line = (String)line + "\tFM3pt1_Zeng_aseis\tFM3pt1_NeoKinema_aseis\tFM3pt1_Geologic_aseis\tFM3pt1_ABM_aseis\tFM3pt2_Zeng_aseis\tFM3pt2_NeoKinema_aseis\tFM3pt2_Geologic_aseis\tFM3pt2_ABM_aseis";
        line = (String)line + "\tFM3pt1_Zeng_cc\tFM3pt1_NeoKinema_cc\tFM3pt1_Geologic_cc\tFM3pt1_ABM_cc\tFM3pt2_Zeng_cc\tFM3pt2_NeoKinema_cc\tFM3pt2_Geologic_cc\tFM3pt2_ABM_cc";
        line = (String)line + "\tu2_name\tlength\torigArea\tDM2pt1\tDM2pt2\tDM2pt3\tDM2pt4\tDM2pt5\tDM2pt6\tAseis\tcoupCoeff";
        lines.add(line);
        for (int s2 = 0; s2 < fm3_sectionNamesList.size(); ++s2) {
            int id = (Integer)fm3_sectionIDsList.get(s2);
            double areaTimesShearMod = dArray[s2] * 1000000.0 * 3.0E10;
            String u3_name = (String)fm3_sectionNamesList.get(s2);
            line = u3_name;
            line = (String)line + "\t" + id;
            line = (String)line + "\t" + fm3_sectionLengthList[s2];
            line = (String)line + "\t" + dArray[s2];
            line = (String)line + "\t" + String.valueOf(slipRateForFM3pt1_Zeng.get(id));
            line = (String)line + "\t" + String.valueOf(slipRateForFM3pt1_NeoKinema.get(id));
            line = (String)line + "\t" + String.valueOf(hashtable.get(id));
            line = (String)line + "\t" + String.valueOf(slipRateForFM3pt1_ABM.get(id));
            line = (String)line + "\t" + String.valueOf(slipRateForFM3pt2_Zeng.get(id));
            line = (String)line + "\t" + String.valueOf(slipRateForFM3pt2_NeoKinema.get(id));
            line = (String)line + "\t" + String.valueOf(slipRateForFM3pt2_Geologic.get(id));
            line = (String)line + "\t" + String.valueOf(slipRateForFM3pt2_ABM.get(id));
            line = (String)line + "\t" + String.valueOf(aseisForFM3pt1_Zeng.get(id));
            line = (String)line + "\t" + String.valueOf(aseisForFM3pt1_NeoKinema.get(id));
            line = (String)line + "\t" + String.valueOf(aseisForFM3pt1_Geologic.get(id));
            line = (String)line + "\t" + String.valueOf(aseisForFM3pt1_ABM.get(id));
            line = (String)line + "\t" + String.valueOf(aseisForFM3pt2_Zeng.get(id));
            line = (String)line + "\t" + String.valueOf(aseisForFM3pt2_NeoKinema.get(id));
            line = (String)line + "\t" + String.valueOf(aseisForFM3pt2_Geologic.get(id));
            line = (String)line + "\t" + String.valueOf(aseisForFM3pt2_ABM.get(id));
            line = (String)line + "\t" + String.valueOf(ccForFM3pt1_Zeng.get(id));
            line = (String)line + "\t" + String.valueOf(ccForFM3pt1_NeoKinema.get(id));
            line = (String)line + "\t" + String.valueOf(ccForFM3pt1_Geologic.get(id));
            line = (String)line + "\t" + String.valueOf(ccForFM3pt1_ABM.get(id));
            line = (String)line + "\t" + String.valueOf(ccForFM3pt2_Zeng.get(id));
            line = (String)line + "\t" + String.valueOf(ccForFM3pt2_NeoKinema.get(id));
            line = (String)line + "\t" + String.valueOf(ccForFM3pt2_Geologic.get(id));
            line = (String)line + "\t" + String.valueOf(ccForFM3pt2_ABM.get(id));
            String u2_name = u2nameFromU3NameMapFM3pt1.get(u3_name);
            if (u2_name == null) {
                u2_name = u2nameFromU3NameMapFM3pt2.get(u3_name);
            }
            if (u2_name == null) {
                u2_name = u3_name;
            }
            if (newFaultSectionsList.contains(u2_name)) {
                u2_name = null;
            } else if (u2_name.equals("Green Valley 2011 CFM")) {
                u2_name = null;
            }
            line = (String)line + "\t" + u2_name;
            Double u2_length = lengthForDM2pt1.get(u2_name);
            if (u2_length == null) {
                u2_length = lengthForDM2pt4.get(u2_name);
            }
            line = (String)line + "\t" + u2_length;
            Double u2_area = origAreaForDM2pt1.get(u2_name);
            if (u2_area == null) {
                u2_area = origAreaForDM2pt4.get(u2_name);
            }
            line = (String)line + "\t" + u2_area;
            line = (String)line + "\t" + String.valueOf(slipRateForDM2pt1.get(u2_name));
            line = (String)line + "\t" + String.valueOf(slipRateForDM2pt2.get(u2_name));
            line = (String)line + "\t" + String.valueOf(slipRateForDM2pt3.get(u2_name));
            line = (String)line + "\t" + String.valueOf(slipRateForDM2pt4.get(u2_name));
            line = (String)line + "\t" + String.valueOf(slipRateForDM2pt5.get(u2_name));
            line = (String)line + "\t" + String.valueOf(slipRateForDM2pt6.get(u2_name));
            Double u2_aseis = aseisForDM2pt1.get(u2_name);
            if (u2_aseis == null) {
                u2_aseis = aseisForDM2pt4.get(u2_name);
            }
            line = (String)line + "\t" + u2_aseis;
            Double u2_cc = ccForDM2pt1.get(u2_name);
            if (u2_cc == null) {
                u2_cc = ccForDM2pt4.get(u2_name);
            }
            line = (String)line + "\t" + u2_cc;
            lines.add(line);
        }
        File dataFile = new File("dev/scratch/UCERF3/data/scratch/ParentFaultSectionSlipRatesEtc.txt");
        try {
            FileWriter fw = new FileWriter(dataFile);
            for (String string : lines) {
                fw.write(string + "\n");
            }
            fw.close();
        }
        catch (IOException e) {
            System.out.println("IO exception = " + String.valueOf(e));
        }
    }

    private static HashMap<String, Double> getMoRateHashtable(ArrayList<? extends FaultSection> faultSectDataList, boolean creepReduced) {
        HashMap<String, Double> hashtable = new HashMap<String, Double>();
        for (FaultSection faultSection : faultSectDataList) {
            hashtable.put(faultSection.getName(), faultSection.calcMomentRate(creepReduced));
        }
        return hashtable;
    }

    private static HashMap<String, Double> getOrigSlipRateHashtable(ArrayList<? extends FaultSection> faultSectDataList) {
        HashMap<String, Double> hashtable = new HashMap<String, Double>();
        for (FaultSection faultSection : faultSectDataList) {
            hashtable.put(faultSection.getName(), faultSection.getOrigAveSlipRate());
        }
        return hashtable;
    }

    private static HashMap<String, Double> getAseisHashtable(ArrayList<? extends FaultSection> faultSectDataList) {
        HashMap<String, Double> hashtable = new HashMap<String, Double>();
        for (FaultSection faultSection : faultSectDataList) {
            hashtable.put(faultSection.getName(), faultSection.getAseismicSlipFactor());
        }
        return hashtable;
    }

    private static HashMap<String, Double> getCouplingCoeffHashtable(ArrayList<? extends FaultSection> faultSectDataList) {
        HashMap<String, Double> hashtable = new HashMap<String, Double>();
        for (FaultSection faultSection : faultSectDataList) {
            hashtable.put(faultSection.getName(), faultSection.getCouplingCoeff());
        }
        return hashtable;
    }

    private static HashMap<String, Double> getOrigAreaHashtable(ArrayList<? extends FaultSection> faultSectDataList) {
        HashMap<String, Double> hashtable = new HashMap<String, Double>();
        for (FaultSection faultSection : faultSectDataList) {
            hashtable.put(faultSection.getName(), faultSection.getOrigDownDipWidth() * faultSection.getTraceLength());
        }
        return hashtable;
    }

    private static HashMap<String, Double> getLengthHashtable(ArrayList<? extends FaultSection> faultSectDataList) {
        HashMap<String, Double> hashtable = new HashMap<String, Double>();
        for (FaultSection faultSection : faultSectDataList) {
            hashtable.put(faultSection.getName(), faultSection.getTraceLength());
        }
        return hashtable;
    }

    private static Hashtable<Integer, Double> getParentSectMoRateHashtable(FaultModels fm, DeformationModels dm, boolean creepReduced) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
        String lastName = "";
        Integer lastID = -100;
        double moRate = 0.0;
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (faultSection.getParentSectionName().equals(lastName)) {
                moRate += faultSection.calcMomentRate(creepReduced);
                continue;
            }
            if (!lastName.equals("")) {
                hashtable.put(lastID, moRate);
            }
            moRate = faultSection.calcMomentRate(creepReduced);
            lastName = faultSection.getParentSectionName();
            lastID = faultSection.getParentSectionId();
        }
        hashtable.put(lastID, moRate);
        return hashtable;
    }

    private static Hashtable<Integer, Double> getParentSectAveAseisHashtable(FaultModels fm, DeformationModels dm) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
        String lastName = "";
        Integer lastID = -100;
        double totOrigArea = 0.0;
        double totReducedArea = 0.0;
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (faultSection.getParentSectionName().equals(lastName)) {
                totOrigArea += faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
                totReducedArea += faultSection.getReducedDownDipWidth() * faultSection.getTraceLength();
                continue;
            }
            if (!lastName.equals("")) {
                hashtable.put(lastID, 1.0 - totReducedArea / totOrigArea);
            }
            totOrigArea = faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
            totReducedArea = faultSection.getReducedDownDipWidth() * faultSection.getTraceLength();
            lastName = faultSection.getParentSectionName();
            lastID = faultSection.getParentSectionId();
        }
        hashtable.put(lastID, 1.0 - totReducedArea / totOrigArea);
        return hashtable;
    }

    private static Hashtable<Integer, Double> getParentSectAveCouplingCoeffHashtable(FaultModels fm, DeformationModels dm) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
        String lastName = "";
        Integer lastID = -100;
        double totOrigArea = 0.0;
        double aveCC = 0.0;
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            double area;
            if (faultSection.getParentSectionName().equals(lastName)) {
                area = faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
                totOrigArea += area;
                aveCC += faultSection.getCouplingCoeff() * area;
                continue;
            }
            if (!lastName.equals("")) {
                hashtable.put(lastID, aveCC / totOrigArea);
            }
            totOrigArea = area = faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
            aveCC = faultSection.getCouplingCoeff() * area;
            lastName = faultSection.getParentSectionName();
            lastID = faultSection.getParentSectionId();
        }
        hashtable.put(lastID, aveCC / totOrigArea);
        return hashtable;
    }

    private static Hashtable<Integer, Double> getParentSectAveCouplingCoeffHashtableAlt(FaultModels fm, DeformationModels dm) {
        Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
        Hashtable<Integer, Double> hashtableOrigSlipRate = DeformationModelsCalc.getParentSectAveSlipRateHashtable(fm, dm, false);
        Hashtable<Integer, Double> hashtableReducedSlipRate = DeformationModelsCalc.getParentSectAveSlipRateHashtable(fm, dm, true);
        for (int key : hashtableOrigSlipRate.keySet()) {
            hashtable.put(key, hashtableReducedSlipRate.get(key) / hashtableOrigSlipRate.get(key));
        }
        return hashtable;
    }

    private static Hashtable<Integer, Double> getParentSectAveSlipRateHashtable(FaultModels fm, DeformationModels dm, boolean creepReduced) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        Hashtable<Integer, Double> hashtable = new Hashtable<Integer, Double>();
        String lastName = "";
        Integer lastID = -100;
        double sumOrig = 0.0;
        double sumReduced = 0.0;
        double origAreaSum = 0.0;
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            double reducedArea;
            double origArea;
            if (faultSection.getParentSectionName().equals(lastName)) {
                origArea = faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
                reducedArea = faultSection.getReducedDownDipWidth() * faultSection.getTraceLength();
                origAreaSum += origArea;
                sumOrig += faultSection.getOrigAveSlipRate() * origArea;
                sumReduced += faultSection.getReducedAveSlipRate() * reducedArea;
                continue;
            }
            if (!lastName.equals("")) {
                if (creepReduced) {
                    hashtable.put(lastID, sumReduced / origAreaSum);
                } else {
                    hashtable.put(lastID, sumOrig / origAreaSum);
                }
            }
            origArea = faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
            reducedArea = faultSection.getReducedDownDipWidth() * faultSection.getTraceLength();
            origAreaSum = origArea;
            sumOrig = faultSection.getOrigAveSlipRate() * origArea;
            sumReduced = faultSection.getReducedAveSlipRate() * reducedArea;
            lastName = faultSection.getParentSectionName();
            lastID = faultSection.getParentSectionId();
        }
        if (creepReduced) {
            hashtable.put(lastID, sumReduced / origAreaSum);
        } else {
            hashtable.put(lastID, sumOrig / origAreaSum);
        }
        return hashtable;
    }

    private static void testGetParentSectAveSlipRateHashtable(FaultModels fm, DeformationModels dm) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        Hashtable hashtable = new Hashtable();
        String lastName = "";
        Integer lastID = -100;
        double sumOrig = 0.0;
        double sumReduced = 0.0;
        double origAreaSum = 0.0;
        double reducedAreaSum = 0.0;
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            double reducedArea;
            double origArea;
            if (faultSection.getParentSectionId() != 651) continue;
            if (faultSection.getParentSectionName().equals(lastName)) {
                origArea = faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
                reducedArea = faultSection.getReducedDownDipWidth() * faultSection.getTraceLength();
                origAreaSum += origArea;
                reducedAreaSum += reducedArea;
                System.out.println(origArea + "\t" + reducedArea + "\t" + faultSection.getOrigAveSlipRate() + "\t" + faultSection.getReducedAveSlipRate() + "\t" + (sumOrig += faultSection.getOrigAveSlipRate() * origArea) + "\t" + (sumReduced += faultSection.getReducedAveSlipRate() * reducedArea) + "\t" + lastName);
                continue;
            }
            origArea = faultSection.getOrigDownDipWidth() * faultSection.getTraceLength();
            reducedArea = faultSection.getReducedDownDipWidth() * faultSection.getTraceLength();
            origAreaSum = origArea;
            reducedAreaSum = reducedArea;
            sumOrig = faultSection.getOrigAveSlipRate() * origArea;
            sumReduced = faultSection.getReducedAveSlipRate() * reducedArea;
            lastName = faultSection.getParentSectionName();
            lastID = faultSection.getParentSectionId();
            System.out.println(origArea + "\t" + reducedArea + "\t" + faultSection.getOrigAveSlipRate() + "\t" + faultSection.getReducedAveSlipRate() + "\t" + origAreaSum + "\t" + reducedAreaSum + "\t" + sumOrig + "\t" + sumReduced + "\t" + lastName);
        }
        System.out.println(sumReduced / reducedAreaSum);
        System.out.println(sumOrig / origAreaSum);
    }

    public static void writeMoRateOfParentSections(FaultModels fm, DeformationModels dm) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        ArrayList<String> getEquivUCERF2_SectionNames = FindEquivUCERF2_FM3_Ruptures.getAllSectionNames(fm);
        String lastName = "";
        double moRateReduced = 0.0;
        double moRateNotReduced = 0.0;
        System.out.println("Sect Name\tmoRateReduced\tmoRateNotReduced\tIn UCERF2?");
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (faultSection.getParentSectionName().equals(lastName)) {
                moRateReduced += faultSection.calcMomentRate(true);
                moRateNotReduced += faultSection.calcMomentRate(false);
                continue;
            }
            if (!lastName.equals("")) {
                System.out.println(lastName + "\t" + (float)moRateReduced + "\t" + (float)moRateNotReduced + "\t" + getEquivUCERF2_SectionNames.contains(lastName));
            }
            moRateReduced = faultSection.calcMomentRate(true);
            moRateNotReduced = faultSection.calcMomentRate(false);
            lastName = faultSection.getParentSectionName();
        }
        System.out.println(lastName + "\t" + (float)moRateReduced + "\t" + (float)moRateNotReduced + "\t" + getEquivUCERF2_SectionNames.contains(lastName));
    }

    public static void writeAveReducedSlipRateEtcOfParentSections(FaultModels fm, DeformationModels dm) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        String lastName = "";
        double slipRate = 0.0;
        double aseisFact = 0.0;
        double reducedDDW = 0.0;
        int numSubSect = 0;
        System.out.println("Sect Name\tSlipRate\tAsiesFactor");
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (faultSection.getParentSectionName().equals(lastName)) {
                slipRate += faultSection.getReducedAveSlipRate();
                aseisFact += faultSection.getAseismicSlipFactor();
                reducedDDW += faultSection.getReducedDownDipWidth();
                ++numSubSect;
                continue;
            }
            if (!lastName.equals("")) {
                System.out.println(lastName + "\t" + (float)(slipRate / (double)numSubSect) + "\t" + (float)(aseisFact / (double)numSubSect) + "\t" + (float)(reducedDDW / (double)numSubSect));
            }
            slipRate = faultSection.getReducedAveSlipRate();
            lastName = faultSection.getParentSectionName();
            aseisFact = faultSection.getAseismicSlipFactor();
            reducedDDW = faultSection.getReducedDownDipWidth();
            numSubSect = 1;
        }
    }

    public static void writeSubSectDataForParent(String parentSectionName, FaultModels fm, DeformationModels dm) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        System.out.println("Sect Name\tSlipRate\tAveDip\tAsiesFactor\tOrigUpperDepth+\tLowerDepth\tOrigDDW\tReducedDDW\tCouplingCoeff");
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (!faultSection.getParentSectionName().equals(parentSectionName)) continue;
            System.out.println(faultSection.getName() + "\t" + (float)faultSection.getReducedAveSlipRate() + "\t" + (float)faultSection.getAveDip() + "\t" + (float)faultSection.getAseismicSlipFactor() + "\t" + (float)faultSection.getOrigAveUpperDepth() + "\t" + (float)faultSection.getAveLowerDepth() + "\t" + (float)faultSection.getOrigDownDipWidth() + "\t" + (float)faultSection.getReducedDownDipWidth() + "\t" + faultSection.getCouplingCoeff());
        }
    }

    public static void writeParentSectionsInsideRegion(FaultModels fm, DeformationModels dm, Region region) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        String lastName = "";
        System.out.println(region.getName() + "\nSect Name\tFractionInside\tMoRateInside");
        double numInside = 0.0;
        double totNum = 0.0;
        double moRateInside = 0.0;
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            double frac;
            int numPts;
            double frcInside;
            RuptureSurface surf;
            if (faultSection.getParentSectionName().equals(lastName)) {
                surf = faultSection.getFaultSurface(1.0);
                frcInside = surf.getFractionOfSurfaceInRegion(region);
                numPts = surf.getEvenlyDiscretizedNumLocs();
                numInside += frcInside * (double)numPts;
                totNum += (double)numPts;
                moRateInside += frcInside * faultSection.calcMomentRate(true);
                continue;
            }
            if (!lastName.equals("") && totNum > 0.0 && (frac = numInside / totNum) > 0.3) {
                System.out.println(lastName + "\t" + (float)frac + "\t" + (float)moRateInside);
            }
            surf = faultSection.getFaultSurface(1.0);
            frcInside = surf.getFractionOfSurfaceInRegion(region);
            numPts = surf.getEvenlyDiscretizedNumLocs();
            numInside = frcInside * (double)numPts;
            totNum = numPts;
            moRateInside = frcInside * faultSection.calcMomentRate(true);
            lastName = faultSection.getParentSectionName();
        }
    }

    public static void calcMoRateAndMmaxDataForDefModels() {
        double rateM5 = TotalMag5Rate.RATE_7p9.getRateMag5();
        ArrayList<String> tableData = new ArrayList<String>();
        FaultModels fm = FaultModels.FM3_1;
        tableData.add(DeformationModelsCalc.getTableLineForMoRateAndMmaxDataForDefModels(fm, DeformationModels.ABM, rateM5));
        tableData.add(DeformationModelsCalc.getTableLineForMoRateAndMmaxDataForDefModels(fm, DeformationModels.GEOLOGIC, rateM5));
        tableData.add(DeformationModelsCalc.getTableLineForMoRateAndMmaxDataForDefModels(fm, DeformationModels.NEOKINEMA, rateM5));
        tableData.add(DeformationModelsCalc.getTableLineForMoRateAndMmaxDataForDefModels(fm, DeformationModels.ZENGBB, rateM5));
        fm = FaultModels.FM3_2;
        tableData.add(DeformationModelsCalc.getTableLineForMoRateAndMmaxDataForDefModels(fm, DeformationModels.ABM, rateM5));
        tableData.add(DeformationModelsCalc.getTableLineForMoRateAndMmaxDataForDefModels(fm, DeformationModels.GEOLOGIC, rateM5));
        tableData.add(DeformationModelsCalc.getTableLineForMoRateAndMmaxDataForDefModels(fm, DeformationModels.NEOKINEMA, rateM5));
        tableData.add(DeformationModelsCalc.getTableLineForMoRateAndMmaxDataForDefModels(fm, DeformationModels.ZENGBB, rateM5));
        System.out.println("\nfltMod\tdefMod\tfltMoRate\tfractOff\tmoRateOff\ttotMoRate\tMmax\tRate_gtM8\tMRIgtM8\tnewFltMoRate");
        for (String tableLine : tableData) {
            System.out.println(tableLine);
        }
    }

    public static ArrayList<String> getListOfNewFaultSectionNames() {
        ArrayList<String> fm3_sectionNamesList = new ArrayList<String>();
        DeformationModelFetcher defFetch = new DeformationModelFetcher(FaultModels.FM3_1, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (fm3_sectionNamesList.contains(faultSection.getParentSectionName())) continue;
            fm3_sectionNamesList.add(faultSection.getParentSectionName());
        }
        defFetch = new DeformationModelFetcher(FaultModels.FM3_2, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (fm3_sectionNamesList.contains(faultSection.getParentSectionName())) continue;
            fm3_sectionNamesList.add(faultSection.getParentSectionName());
        }
        ArrayList<String> equivUCERF2_SectionNames = FindEquivUCERF2_FM3_Ruptures.getAllSectionNames(FaultModels.FM3_1);
        ArrayList<String> arrayList = FindEquivUCERF2_FM3_Ruptures.getAllSectionNames(FaultModels.FM3_2);
        for (String name : arrayList) {
            if (equivUCERF2_SectionNames.contains(name)) continue;
            equivUCERF2_SectionNames.add(name);
        }
        ArrayList<String> newSectionName = new ArrayList<String>();
        for (String name : fm3_sectionNamesList) {
            if (equivUCERF2_SectionNames.contains(name)) continue;
            newSectionName.add(name);
        }
        for (String name : newSectionName) {
            System.out.println(name);
        }
        System.out.println("There are " + newSectionName.size() + " new sections listed above");
        return newSectionName;
    }

    public static void plotNewFaultSectionsInGMT() {
        ArrayList<String> newParSectionNames = DeformationModelsCalc.getListOfNewFaultSectionNames();
        ArrayList faults = Lists.newArrayList();
        ArrayList valsList = Lists.newArrayList();
        DeformationModelFetcher defFetch = new DeformationModelFetcher(FaultModels.FM3_1, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (!newParSectionNames.contains(faultSection.getParentSectionName())) continue;
            faults.add(faultSection.getFaultTrace());
            valsList.add(faultSection.getReducedAveSlipRate());
        }
        defFetch = new DeformationModelFetcher(FaultModels.FM3_2, DeformationModels.GEOLOGIC, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            if (!newParSectionNames.contains(faultSection.getParentSectionName())) continue;
            faults.add(faultSection.getFaultTrace());
            valsList.add(faultSection.getReducedAveSlipRate());
        }
        double[] values = Doubles.toArray((Collection)valsList);
        CaliforniaRegions.RELM_TESTING rELM_TESTING = new CaliforniaRegions.RELM_TESTING();
        File saveDir = GMT_CA_Maps.GMT_DIR;
        boolean display = true;
        try {
            FaultBasedMapGen.makeFaultPlot(FaultBasedMapGen.getSlipRateCPT(), faults, values, rELM_TESTING, saveDir, "NewFaultsOnly", display, false, "Slip Rate (mm/yr)");
        }
        catch (GMT_MapException e) {
            e.printStackTrace();
        }
        catch (RuntimeException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void plotMoRateReductionHist(FaultModels fm, DeformationModels dm) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        HistogramFunction moRateReductionHist = new HistogramFunction(0.0, 51, 0.02);
        double totNoReduction = 0.0;
        double totWithReductionNotRedeced = 0.0;
        double totWithReductionRedeced = 0.0;
        double straightAve = 0.0;
        ArrayList<String> parantNamesOfReduced = new ArrayList<String>();
        int numReduced = 0;
        int numNotReduced = 0;
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            double ratio = faultSection.calcMomentRate(true) / faultSection.calcMomentRate(false);
            if (Double.isNaN(ratio)) continue;
            moRateReductionHist.add(ratio, 1.0);
            if (moRateReductionHist.getClosestXIndex(ratio) == moRateReductionHist.size() - 1) {
                totNoReduction += faultSection.calcMomentRate(false);
                ++numNotReduced;
                continue;
            }
            if (faultSection.getParentSectionName().equals("San Andreas (Creeping Section) 2011 CFM")) continue;
            totWithReductionNotRedeced += faultSection.calcMomentRate(false);
            totWithReductionRedeced += faultSection.calcMomentRate(true);
            straightAve += faultSection.calcMomentRate(true) / faultSection.calcMomentRate(false);
            ++numReduced;
            if (parantNamesOfReduced.contains(faultSection.getParentSectionName())) continue;
            parantNamesOfReduced.add(faultSection.getParentSectionName());
        }
        straightAve /= (double)numReduced;
        double percReduced = 100.0 * (double)numReduced / (double)(numNotReduced + numReduced);
        double aveRatio = totWithReductionRedeced / totWithReductionNotRedeced;
        System.out.println(numReduced + " out of " + (numReduced + numNotReduced) + " subsections were reduced; (" + (float)percReduced + ")");
        System.out.println("totNoReduction=" + (float)totNoReduction);
        System.out.println("totWithReductionNotRedeced=" + (float)totWithReductionNotRedeced);
        System.out.println("aveRatio=" + (float)aveRatio);
        System.out.println("straightAve=" + (float)straightAve);
        System.out.println("potential further reduction ((1.0-aveRatio)*totNoReduction)" + (float)((1.0 - aveRatio) * totNoReduction));
        GraphWindow graph = new GraphWindow(moRateReductionHist, "Moment Rate Reduction Histogram");
        graph.setX_AxisLabel("Fractional Reduction (due to creep)");
        graph.setY_AxisLabel("Number of Fault Sub-Sections");
        System.out.println("Parent Names of those reduced");
        for (String name : parantNamesOfReduced) {
            System.out.println("\t" + name);
        }
    }

    private static void makeSpatialMoRateMaps(FaultModels fm, DeformationModels dm, GriddedGeoDataSet refForRatioData) {
        DeformationModelOffFaultMoRateData spatPDFgen = DeformationModelOffFaultMoRateData.getInstance();
        GriddedGeoDataSet offFaultData = spatPDFgen.getDefModSpatialOffFaultMoRates(fm, dm);
        GriddedGeoDataSet onFaultData = DeformationModelsCalc.getDefModFaultMoRatesInRELM_Region(fm, dm);
        GriddedGeoDataSet totalMoRateData = RELM_RegionUtils.getRELM_RegionGeoDataSetInstance();
        for (int i = 0; i < totalMoRateData.size(); ++i) {
            totalMoRateData.set(i, offFaultData.get(i) + onFaultData.get(i));
        }
        System.out.println(String.valueOf(dm) + "\tmaxMoRate=" + totalMoRateData.getMaxZ());
        System.out.println(String.valueOf(dm) + "\tminMoRate=" + offFaultData.getMinZ());
        try {
            GMT_CA_Maps.plotSpatialMoRate_Map(offFaultData, String.valueOf(dm) + " MoRate-Nm/yr", " ", dm.getShortName() + "_OffFaultMoRateMap");
            GMT_CA_Maps.plotSpatialMoRate_Map(onFaultData, String.valueOf(dm) + " MoRate-Nm/yr", " ", dm.getShortName() + "_OnFaultMoRateMap");
            GMT_CA_Maps.plotSpatialMoRate_Map(totalMoRateData.copy(), String.valueOf(dm) + " MoRate-Nm/yr", " ", dm.getShortName() + "_TotalMoRateMap");
            GMT_CA_Maps.plotRatioOfRateMaps(totalMoRateData, refForRatioData, String.valueOf(dm) + " Ratio", " ", dm.getShortName() + "_RatioMap");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static GriddedGeoDataSet getAveDefModSpatialOnFaultMomentRateData(FaultModels fm, boolean includeGeologic) {
        ArrayList<DeformationModels> dmListForAve = new ArrayList<DeformationModels>();
        if (includeGeologic) {
            dmListForAve.add(DeformationModels.GEOLOGIC);
        }
        dmListForAve.add(DeformationModels.ABM);
        dmListForAve.add(DeformationModels.NEOKINEMA);
        dmListForAve.add(DeformationModels.ZENGBB);
        GriddedGeoDataSet aveDefModOnFault = RELM_RegionUtils.getRELM_RegionGeoDataSetInstance();
        for (int i = 0; i < aveDefModOnFault.size(); ++i) {
            aveDefModOnFault.set(i, 0.0);
        }
        for (DeformationModels dm : dmListForAve) {
            GriddedGeoDataSet onFaultData = DeformationModelsCalc.getDefModFaultMoRatesInRELM_Region(fm, dm);
            dm.getRelativeWeight(null);
            for (int i = 0; i < onFaultData.size(); ++i) {
                if (Double.isNaN(onFaultData.get(i))) continue;
                aveDefModOnFault.set(i, aveDefModOnFault.get(i) + onFaultData.get(i) / (double)dmListForAve.size());
            }
        }
        return aveDefModOnFault;
    }

    public static GriddedGeoDataSet getWtAveDefModSpatialOnFaultMomentRateData() {
        ArrayList<DeformationModels> dmListForAve = new ArrayList<DeformationModels>();
        dmListForAve.add(DeformationModels.GEOLOGIC);
        dmListForAve.add(DeformationModels.ABM);
        dmListForAve.add(DeformationModels.NEOKINEMA);
        dmListForAve.add(DeformationModels.ZENGBB);
        for (DeformationModels dm : dmListForAve) {
            System.out.println(String.valueOf(dm) + " wt=" + dm.getRelativeWeight(null));
        }
        GriddedGeoDataSet aveDefModOnFault = RELM_RegionUtils.getRELM_RegionGeoDataSetInstance();
        for (int i = 0; i < aveDefModOnFault.size(); ++i) {
            aveDefModOnFault.set(i, 0.0);
        }
        for (DeformationModels dm : dmListForAve) {
            GriddedGeoDataSet onFaultData = DeformationModelsCalc.getDefModFaultMoRatesInRELM_Region(FaultModels.FM3_1, dm);
            for (int i = 0; i < onFaultData.size(); ++i) {
                if (Double.isNaN(onFaultData.get(i))) continue;
                aveDefModOnFault.set(i, aveDefModOnFault.get(i) + onFaultData.get(i) * dm.getRelativeWeight(null) * 0.5);
            }
            GriddedGeoDataSet onFaultData2 = DeformationModelsCalc.getDefModFaultMoRatesInRELM_Region(FaultModels.FM3_2, dm);
            for (int i = 0; i < onFaultData2.size(); ++i) {
                if (Double.isNaN(onFaultData2.get(i))) continue;
                aveDefModOnFault.set(i, aveDefModOnFault.get(i) + onFaultData2.get(i) * dm.getRelativeWeight(null) * 0.5);
            }
        }
        return aveDefModOnFault;
    }

    public static GriddedGeoDataSet getAveDefModSpatialMomentRateData(FaultModels fm, boolean includeGeolInOnFltAve, boolean includeGeolInOffFltAve) {
        GriddedGeoDataSet aveDefModOnFault = DeformationModelsCalc.getAveDefModSpatialOnFaultMomentRateData(fm, includeGeolInOnFltAve);
        GriddedGeoDataSet aveDefModOffFault = DeformationModelOffFaultMoRateData.getInstance().getAveDefModelSpatialOffFaultMoRates(fm, includeGeolInOffFltAve);
        GriddedGeoDataSet aveDefModData = RELM_RegionUtils.getRELM_RegionGeoDataSetInstance();
        for (int i = 0; i < aveDefModData.size(); ++i) {
            aveDefModData.set(i, aveDefModOnFault.get(i) + aveDefModOffFault.get(i));
        }
        return aveDefModData;
    }

    public static GriddedGeoDataSet getAveDefModSpatialPDF_WithFaults() {
        int i;
        GriddedGeoDataSet data1 = DeformationModelsCalc.getAveDefModSpatialMomentRateData(FaultModels.FM3_1, true, false);
        GriddedGeoDataSet data2 = DeformationModelsCalc.getAveDefModSpatialMomentRateData(FaultModels.FM3_2, true, false);
        GriddedGeoDataSet pdf = RELM_RegionUtils.getRELM_RegionGeoDataSetInstance();
        double sum = 0.0;
        for (i = 0; i < pdf.size(); ++i) {
            pdf.set(i, data1.get(i) + data2.get(i));
            sum += pdf.get(i);
        }
        for (i = 0; i < pdf.size(); ++i) {
            pdf.set(i, pdf.get(i) / sum);
        }
        return pdf;
    }

    public static void plotWtAveOnFaultMoRateRatioToUCERF2_Map() {
        GriddedGeoDataSet aveDefModOnFault = DeformationModelsCalc.getWtAveDefModSpatialOnFaultMomentRateData();
        ModMeanUCERF2 erf = new ModMeanUCERF2();
        erf.setParameter("Probability Model", "Poisson");
        erf.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        erf.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        erf.updateForecast();
        GriddedGeoDataSet ucerf2_Faults = ERF_Calculator.getMomentRatesInRegion(erf, RELM_RegionUtils.getGriddedRegionInstance());
        try {
            GMT_CA_Maps.plotRatioOfRateMaps(aveDefModOnFault, ucerf2_Faults, "WtedAveDefModOnFault_RatioToUCERF2_MoRateMap", " ", "WtedAveDefModOnFault_RatioToUCERF2_MoRateMap");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void plotAllSpatialMoRateMaps() {
        FaultModels fm = FaultModels.FM3_1;
        ModMeanUCERF2 erf = new ModMeanUCERF2();
        erf.setParameter("Probability Model", "Poisson");
        erf.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        erf.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_ONLY);
        erf.updateForecast();
        GriddedGeoDataSet ucerf2_OffFault = ERF_Calculator.getMomentRatesInRegion(erf, RELM_RegionUtils.getGriddedRegionInstance());
        erf.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_EXCLUDE);
        erf.updateForecast();
        GriddedGeoDataSet ucerf2_Faults = ERF_Calculator.getMomentRatesInRegion(erf, RELM_RegionUtils.getGriddedRegionInstance());
        GriddedGeoDataSet ucerf2_All = new GriddedGeoDataSet(RELM_RegionUtils.getGriddedRegionInstance(), true);
        double fltTest = 0.0;
        double offTest = 0.0;
        double allTest = 0.0;
        for (int i = 0; i < ucerf2_All.size(); ++i) {
            offTest += ucerf2_OffFault.get(i);
            fltTest += ucerf2_Faults.get(i);
            ucerf2_All.set(i, ucerf2_OffFault.get(i) + ucerf2_Faults.get(i));
            allTest += ucerf2_All.get(i);
        }
        try {
            GMT_CA_Maps.plotSpatialMoRate_Map(ucerf2_Faults.copy(), "UCERF2 On-Fault MoRate-Nm/yr", " ", "UCERF2_OnFaultMoRateMap");
            GMT_CA_Maps.plotSpatialMoRate_Map(ucerf2_OffFault.copy(), "UCERF2 Off-Fault MoRate-Nm/yr", " ", "UCERF2_OffFaultMoRateMap");
            GMT_CA_Maps.plotSpatialMoRate_Map(ucerf2_All.copy(), "UCERF2 Total MoRate-Nm/yr", " ", "UCERF2_TotalMoRateMap");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        DeformationModelOffFaultMoRateData spatPDFgen = DeformationModelOffFaultMoRateData.getInstance();
        GriddedGeoDataSet aveDefModOnFault = DeformationModelsCalc.getAveDefModSpatialOnFaultMomentRateData(fm, true);
        GriddedGeoDataSet aveDefModOffFault = spatPDFgen.getAveDefModelSpatialOffFaultMoRates(fm, false);
        GriddedGeoDataSet aveDefModTotal = DeformationModelsCalc.getAveDefModSpatialMomentRateData(fm, true, false);
        try {
            GMT_CA_Maps.plotSpatialMoRate_Map(aveDefModOnFault.copy(), "AveDefModOnFaultMoRate-Nm/yr", " ", "AveDefModOnFaultMoRateMap");
            GMT_CA_Maps.plotSpatialMoRate_Map(aveDefModOffFault.copy(), "AveDefModOffFaultMoRate-Nm/yr", " ", "AveDefModOffFaultMoRateMap");
            GMT_CA_Maps.plotSpatialMoRate_Map(aveDefModTotal.copy(), "AveDefModTotalMoRate-Nm/yr", " ", "AveDefModTotalMoRate");
            GMT_CA_Maps.plotRatioOfRateMaps(aveDefModOnFault, ucerf2_Faults, "AveDefModOnFault_RatioToUCERF2_MoRateMap", " ", "AveDefModOnFault_RatioToUCERF2_MoRateMap");
            GMT_CA_Maps.plotRatioOfRateMaps(aveDefModOffFault, ucerf2_OffFault, "AveDefModOffFault_RatioToUCERF2_MoRateMap", " ", "AveDefModOffFault_RatioToUCERF2_MoRateMap");
            GMT_CA_Maps.plotRatioOfRateMaps(aveDefModTotal, ucerf2_All, "AveDefModTotal_RatioToUCERF2_MoRateMap", " ", "AveDefModTotal_RatioToUCERF2_MoRateMap");
            GMT_CA_Maps.plotRatioOfRateMaps(ucerf2_Faults, aveDefModOnFault, "UCERF2OnFault_RatioToAveDefMod_MoRateMap", " ", "UCERF2OnFault_RatioToAveDefMod_MoRateMap");
            GMT_CA_Maps.plotRatioOfRateMaps(ucerf2_OffFault, aveDefModOffFault, "UCERF2OffFault_RatioToAveDefMod_MoRateMap", " ", "UCERF2OffFault_RatioToAveDefMod_MoRateMap");
            GMT_CA_Maps.plotRatioOfRateMaps(ucerf2_All, aveDefModTotal, "UCERF2_Total_RatioToAveDefMod_MoRateMap", " ", "UCERF2_Total_RatioToAveDefMod_MoRateMap");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<DeformationModels> dmList = new ArrayList<DeformationModels>();
        dmList.add(DeformationModels.GEOLOGIC);
        dmList.add(DeformationModels.ABM);
        dmList.add(DeformationModels.NEOKINEMA);
        dmList.add(DeformationModels.ZENGBB);
        for (DeformationModels dm : dmList) {
            GriddedGeoDataSet offFaultData = spatPDFgen.getDefModSpatialOffFaultMoRates(fm, dm);
            GriddedGeoDataSet onFaultData = DeformationModelsCalc.getDefModFaultMoRatesInRELM_Region(fm, dm);
            GriddedGeoDataSet totalMoRateData = RELM_RegionUtils.getRELM_RegionGeoDataSetInstance();
            for (int i = 0; i < totalMoRateData.size(); ++i) {
                if (Double.isNaN(onFaultData.get(i))) {
                    System.out.println("NaN onFault:\t" + i + "\t" + dm.getShortName());
                    totalMoRateData.set(i, offFaultData.get(i));
                    continue;
                }
                totalMoRateData.set(i, offFaultData.get(i) + onFaultData.get(i));
            }
            try {
                GMT_CA_Maps.plotSpatialMoRate_Map(onFaultData.copy(), String.valueOf(dm) + " MoRate-Nm/yr", " ", dm.getShortName() + "_OnFaultMoRateMap");
                GMT_CA_Maps.plotSpatialMoRate_Map(offFaultData.copy(), String.valueOf(dm) + " MoRate-Nm/yr", " ", dm.getShortName() + "_OffFaultMoRateMap");
                GMT_CA_Maps.plotSpatialMoRate_Map(totalMoRateData.copy(), String.valueOf(dm) + " MoRate-Nm/yr", " ", dm.getShortName() + "_TotalMoRateMap");
                GMT_CA_Maps.plotRatioOfRateMaps(onFaultData, ucerf2_Faults, String.valueOf(dm) + " OnFaulRatioToUCERF2", " ", dm.getShortName() + "_OnFaulRatioToUCERF2Map");
                GMT_CA_Maps.plotRatioOfRateMaps(offFaultData, ucerf2_OffFault, String.valueOf(dm) + " OffFaulRatioToUCERF2", " ", dm.getShortName() + "_OffFaulRatioToUCERF2Map");
                GMT_CA_Maps.plotRatioOfRateMaps(totalMoRateData, ucerf2_All, String.valueOf(dm) + " TotalRatioToUCERF2", " ", dm.getShortName() + "_TotalRatioToUCERF2Map");
                GMT_CA_Maps.plotRatioOfRateMaps(onFaultData, aveDefModOnFault, String.valueOf(dm) + " OnFaulRatioToAveDefMod", " ", dm.getShortName() + "_OnFaulRatioToAveDefModMap");
                GMT_CA_Maps.plotRatioOfRateMaps(offFaultData, aveDefModOffFault, String.valueOf(dm) + " OffFaulRatioToAveDefMod", " ", dm.getShortName() + "_OffFaulRatioToAveDefModMap");
                GMT_CA_Maps.plotRatioOfRateMaps(totalMoRateData, aveDefModTotal, String.valueOf(dm) + " TotalRatioToAveDefMod", " ", dm.getShortName() + "_TotalRatioToAveDefModMap");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        double totAveMomentRate = 0.0;
        for (int i = 0; i < aveDefModTotal.size(); ++i) {
            totAveMomentRate += aveDefModTotal.get(i);
        }
        GriddedGeoDataSet ucerf2_SmSeisDist = SmoothSeismicitySpatialPDF_Fetcher.getUCERF2pdfAsGeoData();
        for (int i = 0; i < ucerf2_SmSeisDist.size(); ++i) {
            ucerf2_SmSeisDist.set(i, totAveMomentRate * ucerf2_SmSeisDist.get(i));
        }
        GriddedGeoDataSet ucerf3_SmSeisDist = SmoothSeismicitySpatialPDF_Fetcher.getUCERF3pdfAsGeoData();
        for (int i = 0; i < ucerf3_SmSeisDist.size(); ++i) {
            ucerf3_SmSeisDist.set(i, totAveMomentRate * ucerf3_SmSeisDist.get(i));
        }
        System.out.println("totAveMomentRate=" + totAveMomentRate);
        try {
            GMT_CA_Maps.plotSpatialMoRate_Map(ucerf2_SmSeisDist.copy(), "UCERF2_SmoothSeis MoRate-Nm/yr", " ", "UCERF2_SmSeisMoRateMap");
            GMT_CA_Maps.plotRatioOfRateMaps(ucerf2_SmSeisDist, aveDefModTotal, "UCERF2_SmSeisToTotAveDefModRatio", " ", "UCERF2_SmSeisToTotAveDefModRatioMap");
            GMT_CA_Maps.plotSpatialMoRate_Map(ucerf3_SmSeisDist.copy(), "UCERF3_SmoothSeis MoRate-Nm/yr", " ", "UCERF3_SmSeisMoRateMap");
            GMT_CA_Maps.plotRatioOfRateMaps(ucerf3_SmSeisDist, aveDefModTotal, "UCERF3_SmSeisToTotAveDefModRatio", " ", "UCERF3_SmSeisToTotAveDefModRatioMap");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double totObsRate = TotalMag5Rate.RATE_7p9.getRateMag5();
        GriddedGeoDataSet mMaxData = RELM_RegionUtils.getRELM_RegionGeoDataSetInstance();
        ucerf3_SmSeisDist = SmoothSeismicitySpatialPDF_Fetcher.getUCERF3pdfAsGeoData();
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(0.0, 3000, 0.01);
        for (int i = 0; i < ucerf3_SmSeisDist.size(); ++i) {
            double rate = totObsRate * ucerf3_SmSeisDist.get(i) * 100000.0;
            double moRate = aveDefModTotal.get(i);
            gr.setAllButMagUpper(0.0, moRate, rate, 1.0, false);
            mMaxData.set(i, gr.getMagUpper());
        }
        try {
            GMT_CA_Maps.plotMagnitudeMap(mMaxData, "Implied Mmax", " ", "AveDefMod_UCERF3_smSeis_ImpliedMmaxMap");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static GriddedGeoDataSet getDefModFaultMoRatesInRELM_Region(FaultModels fm, DeformationModels dm) {
        GriddedGeoDataSet moRates = RELM_RegionUtils.getRELM_RegionGeoDataSetInstance();
        CaliforniaRegions.RELM_TESTING_GRIDDED relmGrid = RELM_RegionUtils.getGriddedRegionInstance();
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            double mr = faultSection.calcMomentRate(true);
            LocationList locList = faultSection.getFaultSurface(1.0).getEvenlyDiscritizedListOfLocsOnSurface();
            mr /= (double)locList.size();
            for (Location loc : locList) {
                int index = relmGrid.indexForLocation(loc);
                if (index < 0) continue;
                double oldVal = moRates.get(index);
                moRates.set(index, oldVal + mr);
            }
        }
        return moRates;
    }

    public static void writeFractionRegionNodesInsideFaultPolygons() {
        double totRateMgt5 = TotalMag5Rate.RATE_7p9.getRateMag5();
        double[] nodeFracs = FaultPolyMgr.getNodeFractions(FaultModels.FM3_1, null, null);
        GriddedGeoDataSet ucerf2_SmSeisDist = SmoothSeismicitySpatialPDF_Fetcher.getUCERF2pdfAsGeoData();
        GriddedGeoDataSet ucerf3_SmSeisDist = SmoothSeismicitySpatialPDF_Fetcher.getUCERF3pdfAsGeoData();
        double sum = 0.0;
        double totRateInsideU2 = 0.0;
        double totRateInsideU3 = 0.0;
        for (int i = 0; i < nodeFracs.length; ++i) {
            sum += nodeFracs[i];
            totRateInsideU2 += nodeFracs[i] * ucerf2_SmSeisDist.get(i) * totRateMgt5;
            totRateInsideU3 += nodeFracs[i] * ucerf3_SmSeisDist.get(i) * totRateMgt5;
        }
        float fracInside = (float)(sum / (double)nodeFracs.length);
        System.out.println("totFracNodesInFaultPolygons=" + fracInside + "\t(" + Math.round(100.0f * fracInside) + "%)");
        double totRateOutsideU2 = totRateMgt5 - totRateInsideU2;
        double totRateOutsideU3 = totRateMgt5 - totRateInsideU3;
        System.out.println("UCERF\trateInside\t(%rateIn)\trateOut\t(%rateOut)\totRate");
        System.out.println("UCERF2\t" + (float)totRateInsideU2 + "\t(" + Math.round(100.0 * totRateInsideU2 / totRateMgt5) + "%)\t" + (float)totRateOutsideU2 + "\t(" + Math.round(100.0 * totRateOutsideU2 / totRateMgt5) + "%)\t" + totRateMgt5);
        System.out.println("UCERF3\t" + (float)totRateInsideU3 + "\t(" + Math.round(100.0 * totRateInsideU3 / totRateMgt5) + "%)\t" + (float)totRateOutsideU3 + "\t(" + Math.round(100.0 * totRateOutsideU3 / totRateMgt5) + "%)\t" + totRateMgt5);
    }

    public static void writeFractionOffFaultMoRateInsideFaultPolygons() {
        FaultModels fm = FaultModels.FM3_1;
        DeformationModelOffFaultMoRateData spatPDFgen = DeformationModelOffFaultMoRateData.getInstance();
        double[] nodeFracs = FaultPolyMgr.getNodeFractions(fm, null, null);
        ArrayList<DeformationModels> dmList = new ArrayList<DeformationModels>();
        dmList.add(DeformationModels.GEOLOGIC);
        dmList.add(DeformationModels.ABM);
        dmList.add(DeformationModels.NEOKINEMA);
        dmList.add(DeformationModels.GEOBOUND);
        dmList.add(DeformationModels.ZENG);
        System.out.println("DefMod\t%Inside\tMoRateInside\ttotMoRate (all off fault for" + String.valueOf(fm) + ")");
        for (DeformationModels dm : dmList) {
            GriddedGeoDataSet offFaultData = spatPDFgen.getDefModSpatialOffFaultMoRates(fm, dm);
            double totOffFaultMoRate = 0.0;
            double totOffFaultMoRateInside = 0.0;
            for (int i = 0; i < offFaultData.size(); ++i) {
                totOffFaultMoRate += offFaultData.get(i);
                totOffFaultMoRateInside += offFaultData.get(i) * nodeFracs[i];
            }
            int perc = (int)(100.0 * totOffFaultMoRateInside / totOffFaultMoRate);
            System.out.println(dm.getShortName() + "\t" + perc + "\t" + (float)totOffFaultMoRateInside + "\t" + (float)totOffFaultMoRate);
        }
    }

    public static void plotMmaxVersusFractSeisOffFault(double moRateOnFault, double moRateOffFault, double totMge5_rate, String label, String fileName) {
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(0.0, 1100, 0.01);
        EvenlyDiscretizedFunc offMmaxFunc = new EvenlyDiscretizedFunc(0.1, 9, 0.1);
        EvenlyDiscretizedFunc onMmaxFunc = new EvenlyDiscretizedFunc(0.1, 9, 0.1);
        for (int i = 0; i < offMmaxFunc.size(); ++i) {
            double fracOff = offMmaxFunc.getX(i);
            gr.setAllButMagUpper(0.0, moRateOffFault, fracOff * totMge5_rate * 100000.0, 1.0, false);
            offMmaxFunc.set(i, gr.getMagUpper());
            gr.setAllButMagUpper(0.0, moRateOnFault, (1.0 - fracOff) * totMge5_rate * 100000.0, 1.0, false);
            onMmaxFunc.set(i, gr.getMagUpper());
        }
        offMmaxFunc.setName("offMmaxFunc");
        onMmaxFunc.setName("onMmaxFunc");
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(offMmaxFunc);
        funcs.add(onMmaxFunc);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 5.0f, null, 0.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 5.0f, null, 0.0f, Color.BLUE));
        GraphWindow graph = new GraphWindow(funcs, label);
        graph.setX_AxisRange(0.0, 1.0);
        graph.setY_AxisRange(6.5, 10.0);
        graph.setX_AxisLabel("Fraction of Total Seismicity That is Off Fault");
        graph.setY_AxisLabel("Maximum Magnitude");
        graph.setTickLabelFontSize(14);
        graph.setAxisLabelFontSize(16);
        graph.setPlotLabelFontSize(18);
        if (fileName != null) {
            try {
                graph.saveAsPNG(fileName);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    public static void plotAllMmaxVersusFractSeisOffFault() {
        double rateMge5 = TotalMag5Rate.RATE_7p9.getRateMag5();
        DeformationModelsCalc.plotMmaxVersusFractSeisOffFault(1.73E19, 5.4E18, rateMge5, "UCERF2 Def Mod 2.1", "mMaxVsOffFltSeis_UCERF2.png");
        ArrayList<DeformationModels> defModList = new ArrayList<DeformationModels>();
        FaultModels fm = FaultModels.FM3_1;
        defModList.add(DeformationModels.ABM);
        defModList.add(DeformationModels.GEOLOGIC);
        defModList.add(DeformationModels.GEOLOGIC_PLUS_ABM);
        defModList.add(DeformationModels.NEOKINEMA);
        defModList.add(DeformationModels.ZENG);
        defModList.add(DeformationModels.GEOBOUND);
        for (DeformationModels dm : defModList) {
            String label = String.valueOf(dm) + " Def Mod";
            String fileName = "mMaxVsOffFltSeis_" + String.valueOf(dm) + ".png";
            DeformationModelsCalc.plotMmaxVersusFractSeisOffFault(DeformationModelsCalc.calcFaultMoRateForDefModel(fm, dm, true), DeformationModelsCalc.calcMoRateOffFaultsForDefModel(fm, dm), rateMge5, label, fileName);
        }
    }

    /*
     * WARNING - void declaration
     */
    public static List<FaultSection> getIsolatedEndpoints(List<? extends FaultSection> subSects, Map<IDPairing, Double> distances, int maxAwayFromEnd) {
        void var6_8;
        ArrayList isolated = Lists.newArrayList();
        HashMap subSectsMap = Maps.newHashMap();
        for (FaultSection faultSection : subSects) {
            subSectsMap.put(faultSection.getSectionId(), faultSection);
        }
        HashMap parentSects = Maps.newHashMap();
        boolean bl = false;
        while (var6_8 < subSects.size()) {
            FaultSection sect = subSects.get((int)var6_8);
            int parentID = sect.getParentSectionId();
            List parentSectsList = (List)parentSects.get(parentID);
            if (parentSectsList == null) {
                parentSectsList = Lists.newArrayList();
                parentSects.put(parentID, parentSectsList);
            }
            parentSectsList.add(sect);
            ++var6_8;
        }
        HashMap hashMap = Maps.newHashMap();
        for (IDPairing pairing : distances.keySet()) {
            Integer id = pairing.getID1();
            List pairings = (List)hashMap.get(id);
            if (pairings == null) {
                pairings = Lists.newArrayList();
                hashMap.put(id, pairings);
            }
            if (pairings.contains(pairing.getID2())) continue;
            pairings.add((FaultSection)subSectsMap.get(pairing.getID2()));
        }
        Iterator<IDPairing> iterator = parentSects.keySet().iterator();
        while (iterator.hasNext()) {
            int lastIndex;
            int myMaxAwayFromEnd = maxAwayFromEnd;
            int parentID = (Integer)((Object)iterator.next());
            List sects = (List)parentSects.get(parentID);
            if (myMaxAwayFromEnd >= sects.size()) {
                myMaxAwayFromEnd = sects.size() - 1;
            }
            if (!DeformationModelsCalc.isConnected(sects.subList(0, myMaxAwayFromEnd + 1), hashMap)) {
                isolated.add((FaultSection)sects.get(0));
            }
            if (DeformationModelsCalc.isConnected(sects.subList((lastIndex = sects.size() - 1) - myMaxAwayFromEnd, lastIndex + 1), hashMap)) continue;
            isolated.add((FaultSection)sects.get(lastIndex));
        }
        return isolated;
    }

    private static boolean isConnected(List<FaultSection> sects, Map<Integer, List<FaultSection>> sectPairings) {
        for (FaultSection sect : sects) {
            List<FaultSection> pairings = sectPairings.get(sect.getSectionId());
            for (FaultSection pairing : pairings) {
                if (pairing.getParentSectionId() == sect.getParentSectionId()) continue;
                return true;
            }
        }
        return false;
    }

    public static void writeFaultsThatWereTypeA_InUCERF2(FaultModels fm, DeformationModels dm) {
        DeformationModelFetcher defFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
        ArrayList<String> parNameList = new ArrayList<String>();
        for (FaultSection faultSection : defFetch.getSubSectionList()) {
            String parName;
            if (!UCERF2_A_FaultMapper.wasUCERF2_TypeAFault(faultSection.getParentSectionId()) || parNameList.contains(parName = faultSection.getParentSectionName())) continue;
            parNameList.add(parName);
        }
        System.out.println("Fault sections that were on type-A faults in UCERF2 for Def Mod " + String.valueOf(dm) + ":");
        for (String string : parNameList) {
            System.out.println(string);
        }
    }

    public static void writeDefModelFaultModelFilesForWebsite(File dir) throws IOException {
        Object metaData;
        if (!dir.exists()) {
            Preconditions.checkState((boolean)dir.mkdir(), (Object)("Directory doesn't exist and couldn't be created: " + dir.getAbsolutePath()));
        }
        SimpleDateFormat df = new SimpleDateFormat("yyyy_MM_dd");
        String dateStr = df.format(new Date());
        ArrayList fileNamesForZip = Lists.newArrayList();
        ArrayList zipFileNames = Lists.newArrayList();
        ArrayList readmes = Lists.newArrayList();
        String methodName = DeformationModelsCalc.class.getName() + ".writeDefModelFaultModelFilesForWebsite(...)";
        ArrayList dmFileNames = Lists.newArrayList();
        for (FaultModels fm : FaultModels.values()) {
            if (fm.getRelativeWeight(null) == 0.0) continue;
            for (DeformationModels dm : DeformationModels.values()) {
                if (dm.getRelativeWeight(null) == 0.0) continue;
                Map<Integer, DeformationModelFileParser.DeformationSection> dmSects = DeformationModelFileParser.load(dm.getDataFileURL(fm));
                File dmFile = new File(dir, dateStr + "-" + fm.getShortName() + "-" + dm.getShortName() + "-mini-sects.csv");
                DeformationModelFileParser.write(dmSects, dmFile);
                dmFileNames.add(dmFile.getName());
            }
        }
        fileNamesForZip.add(dmFileNames);
        for (FaultModels fm : FaultModels.values()) {
            if (fm.getRelativeWeight(null) == 0.0) continue;
            File faultNamesFile = new File(dir, fm.encodeChoiceString() + "_fault_names.txt");
            FileWriter namesFW = new FileWriter(faultNamesFile);
            namesFW.write("# Fault ID\tFault Name\n");
            List<FaultSection> parentSects = fm.getFaultSections();
            Collections.sort(parentSects, new NamedComparator());
            for (FaultSection sect : parentSects) {
                namesFW.write(sect.getSectionId() + "\t" + sect.getSectionName() + "\n");
            }
            namesFW.close();
            dmFileNames.add(faultNamesFile.getName());
        }
        zipFileNames.add(dateStr + "-deformation-models-mini-sects.zip");
        ArrayList dmReadme = Lists.newArrayList();
        dmReadme.add("FILE: " + (String)zipFileNames.get(zipFileNames.size() - 1));
        dmReadme.add("Generated by OpenSHA method: " + methodName);
        dmReadme.add("This zip file contains deformation model minisection files as provided by the individual modelers. Slip rates are not yet reduced for creep.");
        dmReadme.add("");
        dmReadme.add("Each CSV file contains the following columns: <minisection>,<start lon>,<start lat>,<end lon>,<end lat>,<slip rate (mm/yr)>,<rake>");
        dmReadme.add("");
        dmReadme.add("Minisection refers to each span between points on the fault trace. A perfectly straight fault with only start and end points would only have a single minisection, while a fault with N kinks/bends will have N+1 minisections. Deformation modelers assign slip rates and rakes to each of these minisections, denoted by <fault section ID>.<mini section index>. For example, the first minisection on the Carrizo section of the San Andreas Fault (with ID 300), would be denoted as '300.01'. A list of fault section IDs and names for each fault model are also given in the files 'FM3_*_fault_names.txt'");
        readmes.add(dmReadme);
        ArrayList dmSubSectFileNames = Lists.newArrayList();
        for (FaultModels fm : FaultModels.values()) {
            if (fm.getRelativeWeight(null) == 0.0) continue;
            for (DeformationModels dm : DeformationModels.values()) {
                if (dm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) == 0.0) continue;
                DeformationModelFetcher fetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
                File dmFile = new File(dir, dateStr + "-" + fm.getShortName() + "-" + dm.getShortName() + "-sub-sects.txt");
                metaData = Lists.newArrayList();
                metaData.add("Fault Sub Sections file generated on " + dateStr + " by " + methodName);
                metaData.add("Fault Model: " + fm.getName());
                metaData.add("Deformation Model: " + dm.getName());
                metaData.add("Note that upper seismogenic depths reflect aseismic reductions, and that slip rates reported have a coupling coefficient applied and as such may be lower than the original deformation model rate.");
                FaultSectionDataWriter.writeSectionsToFile(fetch.getSubSectionList(), (List<String>)metaData, dmFile, true);
                dmSubSectFileNames.add(dmFile.getName());
            }
        }
        fileNamesForZip.add(dmSubSectFileNames);
        zipFileNames.add(dateStr + "-deformation-models-sub-sects.zip");
        ArrayList dmSubReadme = Lists.newArrayList();
        dmSubReadme.add("FILE: " + (String)zipFileNames.get(zipFileNames.size() - 1));
        dmSubReadme.add("Generated by OpenSHA method: " + methodName);
        dmSubReadme.add("This zip file contains deformation model sub section files generated by mapping the minisection data on to our sub sections. These files also reflect creep reductions in both the upper seismogenic depth and slip rate.");
        readmes.add(dmSubReadme);
        ArrayList dmSubSectNoRedFileNames = Lists.newArrayList();
        for (FaultModels fm : FaultModels.values()) {
            if (fm.getRelativeWeight(null) == 0.0) continue;
            for (DeformationModels dm : DeformationModels.values()) {
                if (dm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) == 0.0) continue;
                DeformationModelFetcher fetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
                File dmFile = new File(dir, dateStr + "-" + fm.getShortName() + "-" + dm.getShortName() + "-sub-sects-no-reduce.txt");
                ArrayList metaData2 = Lists.newArrayList();
                metaData2.add("Fault Sub Sections file generated on " + dateStr + " by " + methodName);
                metaData2.add("Fault Model: " + fm.getName());
                metaData2.add("Deformation Model: " + dm.getName());
                metaData2.add("Note that upper seismogenic depths DO NOT reflect aseismic reductions, and that slip rates reported DO NOT have a coupling coefficient applied");
                FaultSectionDataWriter.writeSectionsToFile(fetch.getSubSectionList(), metaData2, dmFile, false);
                dmSubSectNoRedFileNames.add(dmFile.getName());
            }
        }
        fileNamesForZip.add(dmSubSectNoRedFileNames);
        zipFileNames.add(dateStr + "-deformation-models-sub-sects-no-reduce.zip");
        ArrayList dmSubNoRedReadme = Lists.newArrayList();
        dmSubNoRedReadme.add("FILE: " + (String)zipFileNames.get(zipFileNames.size() - 1));
        dmSubNoRedReadme.add("Generated by OpenSHA method: " + methodName);
        dmSubNoRedReadme.add("This zip file contains deformation model sub section files generated by mapping the minisection data on to our sub sections. These files also reflect creep reductions in both the upper seismogenic depth and slip rate.");
        readmes.add(dmSubNoRedReadme);
        ArrayList fmFileNames = Lists.newArrayList();
        for (FaultModels fm : FaultModels.values()) {
            if (fm.getRelativeWeight(null) == 0.0) continue;
            List<FaultSection> sects = fm.getFaultSections();
            File fmFile = new File(dir, dateStr + "-" + fm.getShortName() + "-sections.txt");
            metaData = Lists.newArrayList();
            metaData.add("Fault Sections file generated on " + dateStr + " by " + methodName);
            metaData.add("Fault Model: " + fm.getName());
            metaData.add("Note that upper seismogenic depths DO NOT reflect aseismic reductions as these are deformation model specific, and that slip rates reported are geologic slip rates and should not be used.");
            FaultSectionDataWriter.writeSectionsToFile(sects, (List<String>)metaData, fmFile, false);
            fmFileNames.add(fmFile.getName());
        }
        fileNamesForZip.add(fmFileNames);
        zipFileNames.add(dateStr + "-fault-models.zip");
        ArrayList fmReadme = Lists.newArrayList();
        fmReadme.add("FILE: " + (String)zipFileNames.get(zipFileNames.size() - 1));
        fmReadme.add("Generated by OpenSHA method: " + methodName);
        fmReadme.add("This zip file contains fault model parent fault sections (prior to sub sectioning) and do not reflectcreep reductions.");
        readmes.add(fmReadme);
        File plotSubDir = new File(dir, "def_model_plots");
        if (!plotSubDir.exists()) {
            Preconditions.checkState((boolean)plotSubDir.mkdir(), (Object)("Directory doesn't exist and couldn't be created: " + plotSubDir.getAbsolutePath()));
        }
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        try {
            FaultBasedMapGen.plotDeformationModelSlips(region, plotSubDir, false);
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        ArrayList dmPlotReadme = Lists.newArrayList();
        dmPlotReadme.add("DIRECTORY: " + plotSubDir.getName());
        dmPlotReadme.add("Generated by OpenSHA method: " + methodName);
        dmPlotReadme.add("This direcotry contains map based plots of each deformation model, as well as geologic slip rate sites. Rates plotted in these files are not creep reduced.");
        File plotReadmeFile = new File(plotSubDir, "README");
        FileWriter fw = new FileWriter(plotReadmeFile);
        for (String line : dmPlotReadme) {
            fw.write(line + "\n");
        }
        fw.close();
        for (int i = 0; i < fileNamesForZip.size(); ++i) {
            List fileNames = (List)fileNamesForZip.get(i);
            String zipFileName = (String)zipFileNames.get(i);
            List readme = (List)readmes.get(i);
            File readmeFile = new File(dir, "README.txt");
            fw = new FileWriter(readmeFile);
            for (String line : readme) {
                fw.write(line + "\n");
            }
            fw.close();
            fileNames.add(readmeFile.getName());
            System.out.println("Writing zip file: " + zipFileName);
            FileUtils.createZipFile(new File(dir, zipFileName).getAbsolutePath(), dir.getAbsolutePath(), fileNames);
            for (String fileName : fileNames) {
                File file = new File(dir, fileName);
                if (file.delete()) continue;
                System.err.println("WARNING: couldn't remove: " + file.getAbsolutePath());
            }
        }
    }

    public static void plotSectSlipRateHistForAllDeformationModels() {
        HistogramFunction histogram = new HistogramFunction(-4.9, 36, 0.2);
        FaultModels[] fm_list = new FaultModels[]{FaultModels.FM3_1, FaultModels.FM3_2};
        DeformationModels[] dm_list = new DeformationModels[]{DeformationModels.GEOLOGIC, DeformationModels.ABM, DeformationModels.NEOKINEMA, DeformationModels.ZENGBB};
        for (FaultModels fm : fm_list) {
            for (DeformationModels dm : dm_list) {
                if (fm == FaultModels.FM2_1) {
                    DeformationModelFetcher dmFetch = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
                    for (FaultSection faultSection : dmFetch.getSubSectionList()) {
                        histogram.add(Math.log10(faultSection.getOrigAveSlipRate()), 1.0);
                    }
                    continue;
                }
                try {
                    Map<Integer, DeformationModelFileParser.DeformationSection> sects = DeformationModelFileParser.load(dm.getDataFileURL(fm));
                    for (DeformationModelFileParser.DeformationSection deformationSection : sects.values()) {
                        for (int i = 0; i < deformationSection.getLocs1().size(); ++i) {
                            double log10_SlipRate = Math.log10(deformationSection.getSlips().get(i));
                            int index = histogram.getXIndex(log10_SlipRate);
                            if (index == -1) continue;
                            histogram.add(index, 1.0);
                        }
                    }
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        GraphWindow graph = new GraphWindow(histogram.getCumulativeDistFunction(), "Histogram of mini-section slip rates");
        graph.setX_AxisLabel("Number");
        graph.setY_AxisLabel("Log10 Slip Rate");
    }

    public static void main(String[] args) throws IOException {
        DeformationModelsCalc.writeDefModelFaultModelFilesForWebsite(new File("/tmp/dm_files"));
    }
}

