/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.awt.BorderLayout;
import java.awt.CardLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Paint;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.EnumSet;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartPanel;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.axis.CategoryAxis;
import org.jfree.chart.axis.CategoryLabelPositions;
import org.jfree.chart.axis.NumberAxis;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.BarRenderer;
import org.jfree.data.category.CategoryDataset;
import org.jfree.data.category.DefaultCategoryDataset;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.gui.plot.GraphWidget;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.GriddedParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.DoubleParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.IntegerParameter;
import org.opensha.commons.param.impl.StringParameter;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.sha.earthquake.faultSysSolution.inversion.sa.SimulatedAnnealing;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.logicTree.VariableLogicTreeBranch;

public class InversionConvergenceGUI
extends JFrame
implements ParameterChangeListener {
    private static final String BROWSE_PARAM_NAME = "CSV Dir/Zip File";
    private FileParameter browseParam;
    private static final String ANY_CHOICE = "(any)";
    private ParameterList enumParams;
    private static final String VARIATION_PARAM_NAME = "Variation";
    private static final String REFRESH_PARAM_NAME = "Plot";
    private static final String REFRESH_BUTTON_TEXT = "Reload Results";
    private ButtonParameter refreshButton;
    private static final String CARD_GRAPH = "Graph";
    private static final String CARD_BAR = "Bar";
    private static final String CARD_NONE = "None";
    private static final String CARD_CONVERG_PLAYGROUND = "Convergence Playground";
    private static final String PLOT_TYPE_PARAM_NAME = "Plot Type";
    private EnumParameter<PlotType> plotTypeParam;
    private GriddedParameterListEditor griddedEditor;
    private JPanel contentPane;
    private CardLayout cl;
    private JPanel chartPanel;
    private GraphWidget graphWidget;
    private JPanel barChartPanel;
    private JPanel convergPlayPanel;
    private BooleanParameter timeBasedParam = new BooleanParameter("Time Based", true);
    private static final int LOOK_BACK_DEFAULT_TIME = 60;
    private static final int LOOK_BACK_DEFAULT_ITERATIONS = 2000000;
    private IntegerParameter lookBackParam = new IntegerParameter("Look Back", 60);
    private DoubleParameter energyPercentChangeThresholdParam = new DoubleParameter("Energy Change % Threshold", (Double)0.0, (Double)100.0, "%", (Double)1.5);
    private DoubleParameter energyChangeThresholdParam = new DoubleParameter("Energy Change Threshold", (Double)0.0, (Double)1000.0, (Double)2.0);
    private GraphWidget convergeGP;
    private Map<VariableLogicTreeBranch, CSVFile<String>> resultFilesMap;
    private ArrayList<String> curNames;
    private ArrayList<U3LogicTreeBranch> curBranches;
    private ArrayList<ArbitrarilyDiscretizedFunc> curEnergyVsTimes;
    private ArrayList<ArbitrarilyDiscretizedFunc> curEnergyVsIters;
    private ArrayList<double[]> curFinalEnergies;
    private ArrayList<String> curEnergyNames;
    private ArrayList<ArbitrarilyDiscretizedFunc> curPerturbsPerItersVsTimes;
    private ArrayList<ArbitrarilyDiscretizedFunc> curPerturbsVsIters;
    private CSVFile<String> lastCSV;
    private static ArrayList<String> energyComponentNames = Lists.newArrayList((Object[])new String[]{"Total", "Equality", "Entropy", "Inequality"});

    public InversionConvergenceGUI() {
        super("Inversion Convergence GUI");
        this.browseParam = new FileParameter(BROWSE_PARAM_NAME);
        this.browseParam.addParameterChangeListener(this);
        this.enumParams = new ParameterList();
        this.enumParams.addParameter(this.buildEnumParam(FaultModels.class, FaultModels.FM3_1));
        this.enumParams.addParameter(this.buildEnumParam(DeformationModels.class, null));
        this.enumParams.addParameter(this.buildEnumParam(ScalingRelationships.class, ScalingRelationships.SHAW_2009_MOD));
        this.enumParams.addParameter(this.buildEnumParam(SlipAlongRuptureModels.class, SlipAlongRuptureModels.TAPERED));
        this.enumParams.addParameter(this.buildEnumParam(InversionModels.class, InversionModels.CHAR_CONSTRAINED));
        this.enumParams.addParameter(this.buildEnumParam(TotalMag5Rate.class, TotalMag5Rate.RATE_7p9));
        this.enumParams.addParameter(this.buildEnumParam(MaxMagOffFault.class, MaxMagOffFault.MAG_7p6));
        this.enumParams.addParameter(this.buildEnumParam(MomentRateFixes.class, MomentRateFixes.NONE));
        this.enumParams.addParameter(this.buildEnumParam(SpatialSeisPDF.class, SpatialSeisPDF.UCERF3));
        this.refreshButton = new ButtonParameter(REFRESH_PARAM_NAME, REFRESH_BUTTON_TEXT);
        this.refreshButton.addParameterChangeListener(this);
        this.plotTypeParam = new EnumParameter<PlotType>(PLOT_TYPE_PARAM_NAME, EnumSet.allOf(PlotType.class), PlotType.ENERGY_VS_TIME, null);
        this.plotTypeParam.addParameterChangeListener(this);
        this.contentPane = new JPanel(new BorderLayout());
        this.griddedEditor = new GriddedParameterListEditor(this.buildTopParamList(null), 1, 0);
        this.contentPane.add((Component)this.griddedEditor, "North");
        this.cl = new CardLayout();
        this.chartPanel = new JPanel(this.cl);
        JPanel nonePanel = new JPanel();
        nonePanel.add(new JLabel("No results found/loaded"));
        this.chartPanel.add((Component)nonePanel, CARD_NONE);
        this.graphWidget = new GraphWidget();
        this.chartPanel.add((Component)this.graphWidget, CARD_GRAPH);
        this.barChartPanel = new JPanel(new BorderLayout());
        this.chartPanel.add((Component)this.barChartPanel, CARD_BAR);
        this.convergPlayPanel = new JPanel(new BorderLayout());
        this.convergeGP = new GraphWidget();
        this.convergPlayPanel.add((Component)this.convergeGP, "Center");
        ParameterList convergeList = new ParameterList();
        convergeList.addParameter(this.timeBasedParam);
        convergeList.addParameter(this.lookBackParam);
        convergeList.addParameter(this.energyPercentChangeThresholdParam);
        convergeList.addParameter(this.energyChangeThresholdParam);
        for (Parameter<?> p : convergeList) {
            p.addParameterChangeListener(this);
        }
        GriddedParameterListEditor convergeParamEdit = new GriddedParameterListEditor(convergeList, 1, 3);
        this.convergPlayPanel.add((Component)convergeParamEdit, "South");
        this.chartPanel.add((Component)this.convergPlayPanel, CARD_CONVERG_PLAYGROUND);
        this.contentPane.add((Component)this.chartPanel, "Center");
        this.setContentPane(this.contentPane);
        this.setSize(1400, 1000);
        this.setVisible(true);
        this.setDefaultCloseOperation(3);
    }

    private ParameterList buildTopParamList(ArrayList<ArrayList<String>> variations) {
        ParameterList params = new ParameterList();
        params.addParameter(this.browseParam);
        params.addParameterList(this.enumParams);
        for (int i = 0; variations != null && i < variations.size(); ++i) {
            ArrayList<String> vars = variations.get(i);
            Collections.sort(vars);
            vars.add(0, ANY_CHOICE);
            StringParameter variationParam = new StringParameter("Variation (" + i + ")", vars);
            variationParam.setValue(ANY_CHOICE);
            variationParam.addParameterChangeListener(this);
            params.addParameter(variationParam);
        }
        params.addParameter(this.plotTypeParam);
        params.addParameter(this.refreshButton);
        return params;
    }

    private <E extends Enum<E>> EnumParameter<?> buildEnumParam(Class<E> e, E defaultValue) {
        String name = ClassUtils.getClassNameWithoutPackage(e);
        EnumParameter<E> param = new EnumParameter<E>(name, EnumSet.allOf(e), defaultValue, ANY_CHOICE);
        param.addParameterChangeListener(this);
        return param;
    }

    private static HashMap<VariableLogicTreeBranch, CSVFile<String>> loadZipFile(File zipFile, VariableLogicTreeBranch branch) throws IOException {
        HashMap map = Maps.newHashMap();
        ZipFile zip = new ZipFile(zipFile);
        Enumeration<? extends ZipEntry> e = zip.entries();
        while (e.hasMoreElements()) {
            VariableLogicTreeBranch candidate;
            ZipEntry entry = e.nextElement();
            String name = entry.getName();
            if (!name.endsWith(".csv") || !branch.matchesNonNulls(candidate = VariableLogicTreeBranch.fromFileName(name))) continue;
            System.out.println("Loading: " + name);
            map.put(candidate, CSVFile.readStream(zip.getInputStream(entry), true));
        }
        return map;
    }

    private static HashMap<VariableLogicTreeBranch, CSVFile<String>> loadDir(File dir, VariableLogicTreeBranch branch) throws IOException {
        HashMap map = Maps.newHashMap();
        for (File file : dir.listFiles()) {
            VariableLogicTreeBranch candidate;
            String name;
            if (file.isDirectory() || !(name = file.getName()).endsWith(".csv") || !branch.matchesNonNulls(candidate = VariableLogicTreeBranch.fromFileName(name))) continue;
            map.put(candidate, CSVFile.readFile(file, true));
        }
        return map;
    }

    private void loadResultFiles(VariableLogicTreeBranch branch) throws IOException {
        File file = (File)this.browseParam.getValue();
        this.resultFilesMap = null;
        System.gc();
        this.resultFilesMap = file == null ? null : (file.getName().toLowerCase().endsWith(".zip") ? InversionConvergenceGUI.loadZipFile(file, branch) : InversionConvergenceGUI.loadDir(file, branch));
        if (this.resultFilesMap != null) {
            ArrayList variations = Lists.newArrayList();
            for (VariableLogicTreeBranch b : this.resultFilesMap.keySet()) {
                if (b.getVariations() == null) continue;
                for (int i = 0; i < b.getVariations().size(); ++i) {
                    if (i >= variations.size()) {
                        variations.add(new ArrayList());
                    }
                    List vars = (List)variations.get(i);
                    String var = b.getVariations().get(i);
                    if (var == null || vars.contains(var)) continue;
                    vars.add(var);
                }
            }
            this.griddedEditor.setParameterList(this.buildTopParamList(variations));
            this.griddedEditor.validate();
        }
    }

    private VariableLogicTreeBranch getCurrentBranch() {
        ArrayList nodes = Lists.newArrayList();
        for (Parameter<?> param : this.enumParams) {
            if (param.getValue() == null) continue;
            EnumParameter enumParam = (EnumParameter)param;
            U3LogicTreeBranchNode node = (U3LogicTreeBranchNode)enumParam.getValue();
            nodes.add(node);
        }
        ArrayList<String> variations = new ArrayList<String>();
        for (Parameter<?> param : this.griddedEditor.getParameterList()) {
            if (!param.getName().startsWith(VARIATION_PARAM_NAME)) continue;
            StringParameter variationParam = (StringParameter)param;
            String variation = !((String)variationParam.getValue()).equals(ANY_CHOICE) ? (String)variationParam.getValue() : null;
            variations.add(variation);
        }
        return new VariableLogicTreeBranch(U3LogicTreeBranch.fromValues(false, nodes.toArray(new U3LogicTreeBranchNode[0])), variations);
    }

    private void buildFunctions(VariableLogicTreeBranch branch) {
        this.curNames = new ArrayList();
        this.curBranches = new ArrayList();
        this.curEnergyVsTimes = new ArrayList();
        this.curEnergyVsIters = new ArrayList();
        this.curPerturbsPerItersVsTimes = new ArrayList();
        this.curPerturbsVsIters = new ArrayList();
        this.curFinalEnergies = new ArrayList();
        this.curEnergyNames = null;
        if (this.resultFilesMap == null) {
            return;
        }
        for (VariableLogicTreeBranch candidate : this.resultFilesMap.keySet()) {
            int i;
            if (!branch.matchesVariation(candidate)) continue;
            ArrayList<Object> diffNames = new ArrayList<Object>();
            for (i = 0; i < branch.size(); ++i) {
                U3LogicTreeBranchNode node = (U3LogicTreeBranchNode)branch.getValue(i);
                if (node != null) continue;
                if (candidate.getValue(i) == null) {
                    System.out.println("WFT? Class: " + String.valueOf(U3LogicTreeBranch.getLogicTreeNodeClasses().get(i)));
                }
                diffNames.add(((U3LogicTreeBranchNode)candidate.getValue(i)).getShortName());
            }
            if (branch.getVariations() != null && candidate.getVariations() != null) {
                for (i = 0; i < candidate.getVariations().size(); ++i) {
                    String var = candidate.getVariations().get(i);
                    if (i < branch.getVariations().size() && branch.getVariations().get(i) != null) continue;
                    diffNames.add("Var: " + var);
                }
            }
            String name = Joiner.on((String)", ").join(diffNames);
            CSVFile<String> csv = this.resultFilesMap.get(candidate);
            ArbitrarilyDiscretizedFunc energyVsTime = new ArbitrarilyDiscretizedFunc(name);
            energyVsTime.setInfo("Total energy");
            ArbitrarilyDiscretizedFunc energyVsIter = new ArbitrarilyDiscretizedFunc(name);
            energyVsIter.setInfo("Total energy");
            ArbitrarilyDiscretizedFunc perturbsPerItersVsTimes = new ArbitrarilyDiscretizedFunc();
            perturbsPerItersVsTimes.setName(name);
            ArbitrarilyDiscretizedFunc perturbsVsIters = new ArbitrarilyDiscretizedFunc();
            perturbsVsIters.setName(name);
            int numEnergies = csv.getNumCols() - 3;
            if (this.curEnergyNames == null) {
                this.curEnergyNames = new ArrayList();
                this.curEnergyNames.addAll(energyComponentNames);
                for (int i2 = this.curEnergyNames.size(); i2 < numEnergies; ++i2) {
                    this.curEnergyNames.add(csv.get(0, 2 + i2));
                }
            }
            double[] finalEnergies = null;
            for (int row = 1; row < csv.getNumRows(); ++row) {
                double iter = Double.parseDouble(csv.get(row, 0));
                double mins = Double.parseDouble(csv.get(row, 1)) / 1000.0 / 60.0;
                double[] energies = new double[numEnergies];
                for (int i3 = 0; i3 < energies.length; ++i3) {
                    energies[i3] = Double.parseDouble(csv.get(row, i3 + 2));
                }
                double perturbs = Double.parseDouble(csv.get(row, csv.getNumCols() - 1));
                if (row == csv.getNumRows() - 1) {
                    finalEnergies = energies;
                }
                energyVsTime.set(mins, energies[0]);
                energyVsIter.set(iter, energies[0]);
                perturbsPerItersVsTimes.set(mins, perturbs / iter);
                perturbsVsIters.set(iter, perturbs);
            }
            int ind = -1;
            for (int i4 = this.curNames.size() - 1; i4 >= 0; --i4) {
                int cmp = name.compareTo(this.curNames.get(i4));
                if (cmp > 0) continue;
                ind = i4;
            }
            if (ind < 0) {
                ind = this.curNames.size();
            }
            this.curNames.add(ind, name);
            this.curBranches.add(ind, candidate);
            this.curEnergyVsTimes.add(ind, energyVsTime);
            this.curEnergyVsIters.add(ind, energyVsIter);
            this.curPerturbsPerItersVsTimes.add(ind, perturbsPerItersVsTimes);
            this.curPerturbsVsIters.add(ind, perturbsVsIters);
            this.curFinalEnergies.add(ind, finalEnergies);
            this.lastCSV = csv;
        }
        System.out.println("Loaded: " + Joiner.on((String)", ").join(this.curNames));
    }

    private ArrayList<ArbitrarilyDiscretizedFunc> loadIndividualEnergies(boolean timeBased) {
        ArrayList<ArbitrarilyDiscretizedFunc> funcs = null;
        CSVFile<String> csv = this.lastCSV;
        int numEnergies = csv.getNumCols() - 3;
        for (int row = 1; row < csv.getNumRows(); ++row) {
            int i;
            int i2;
            double iter = Double.parseDouble(csv.get(row, 0));
            double mins = Double.parseDouble(csv.get(row, 1)) / 1000.0 / 60.0;
            double[] energies = new double[numEnergies];
            for (i2 = 0; i2 < energies.length; ++i2) {
                energies[i2] = Double.parseDouble(csv.get(row, i2 + 2));
            }
            if (funcs == null) {
                funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
                for (i2 = 0; i2 < energies.length; ++i2) {
                    String name = csv.get(0, 2 + i2);
                    ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc(name);
                    funcs.add(func);
                }
            }
            double x = timeBased ? mins : iter;
            for (i = 0; i < energies.length; ++i) {
                ((ArbitrarilyDiscretizedFunc)funcs.get(i)).set(x, energies[i]);
            }
            if (row != csv.getNumRows() - 1) continue;
            for (i = 0; i < energies.length; ++i) {
                ((ArbitrarilyDiscretizedFunc)funcs.get(i)).setInfo("Final energy: " + energies[i]);
            }
        }
        return funcs;
    }

    private void updatePlot() {
        if (this.curBranches == null || this.curBranches.isEmpty()) {
            this.cl.show(this.chartPanel, CARD_NONE);
            return;
        }
        PlotType plot = (PlotType)((Object)this.plotTypeParam.getValue());
        if (plot.card.equals(CARD_GRAPH)) {
            Object title;
            String yAxisName;
            String xAxisName;
            System.out.println("Updating a regular graph!");
            ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList();
            switch (plot.ordinal()) {
                case 1: {
                    xAxisName = "Iterations";
                    yAxisName = "Energy";
                    title = "Energy vs Iterations";
                    if (this.curEnergyVsIters.size() == 1) {
                        funcs.addAll(this.loadIndividualEnergies(false));
                        title = (String)title + " (Single Run Components!)";
                        chars = SimulatedAnnealing.getEnergyBreakdownChars();
                        break;
                    }
                    funcs.addAll(this.curEnergyVsIters);
                    break;
                }
                case 0: {
                    xAxisName = "Time (minutes)";
                    yAxisName = "Energy";
                    title = "Energy vs Time";
                    if (this.curEnergyVsTimes.size() == 1) {
                        funcs.addAll(this.loadIndividualEnergies(true));
                        title = (String)title + " (Single Run Components!)";
                        chars = SimulatedAnnealing.getEnergyBreakdownChars();
                        break;
                    }
                    funcs.addAll(this.curEnergyVsTimes);
                    break;
                }
                case 4: {
                    xAxisName = "Iterations";
                    yAxisName = "Perturbations";
                    title = "Perturbations Vs Iterations";
                    funcs.addAll(this.curPerturbsVsIters);
                    break;
                }
                case 5: {
                    xAxisName = "Time (minutes)";
                    yAxisName = "Perturbations/Iterations";
                    title = "Perturbations/Iterations Vs Time";
                    funcs.addAll(this.curPerturbsPerItersVsTimes);
                    break;
                }
                default: {
                    throw new RuntimeException("shouldn't get here...");
                }
            }
            PlotSpec spec = this.graphWidget.getPlotSpec();
            spec.setXAxisLabel(xAxisName);
            spec.setYAxisLabel(yAxisName);
            spec.setPlotElems(funcs);
            spec.setChars(chars);
            spec.setTitle((String)title);
            this.graphWidget.setX_Log(false);
            this.graphWidget.setY_Log(false);
            this.graphWidget.drawGraph();
            this.graphWidget.validate();
            this.graphWidget.repaint();
        } else if (plot.card.equals(CARD_BAR)) {
            String rangeLabel;
            ArrayList series;
            System.out.println("Updating a bar graph!");
            boolean perturb = plot == PlotType.FINAL_NORMALIZED_PERTURBATION_BREAKDOWN;
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            if (perturb) {
                series = Lists.newArrayList((Object[])new String[]{"% Perturbs Kept"});
                rangeLabel = "Perturbations Kept (%)";
            } else {
                series = new ArrayList();
                series.addAll(this.curEnergyNames);
                rangeLabel = "Energy";
            }
            for (int i = 0; i < this.curBranches.size(); ++i) {
                double[] energies = this.curFinalEnergies.get(i);
                ArbitrarilyDiscretizedFunc perturbs = this.curPerturbsPerItersVsTimes.get(i);
                String category = this.curNames.get(i);
                int lastInd = perturbs.size() - 1;
                if (perturb) {
                    double norm = perturbs.get(lastInd).getY() * 100.0;
                    dataset.addValue(norm, (Comparable)series.get(0), (Comparable)((Object)category));
                    continue;
                }
                for (int j = 0; j < energies.length; ++j) {
                    double e = energies[j];
                    String s = (String)series.get(j);
                    dataset.addValue(e, (Comparable)((Object)s), (Comparable)((Object)category));
                }
            }
            JFreeChart chart = ChartFactory.createBarChart((String)plot.toString(), (String)"Branch", (String)rangeLabel, (CategoryDataset)dataset, (PlotOrientation)PlotOrientation.VERTICAL, (boolean)true, (boolean)true, (boolean)false);
            chart.setBackgroundPaint((Paint)Color.white);
            CategoryPlot plt = chart.getCategoryPlot();
            plt.setBackgroundPaint((Paint)Color.lightGray);
            plt.setDomainGridlinePaint((Paint)Color.white);
            plt.setRangeGridlinePaint((Paint)Color.white);
            if (!perturb) {
                NumberAxis rangeAxis = (NumberAxis)plt.getRangeAxis();
                rangeAxis.setStandardTickUnits(NumberAxis.createIntegerTickUnits());
            }
            BarRenderer renderer = (BarRenderer)plt.getRenderer();
            renderer.setDrawBarOutline(false);
            CategoryAxis domainAxis = plt.getDomainAxis();
            domainAxis.setCategoryLabelPositions(CategoryLabelPositions.createUpRotationLabelPositions((double)0.5235987755982988));
            ChartPanel cp = new ChartPanel(chart);
            this.barChartPanel.removeAll();
            this.barChartPanel.add((Component)cp, "Center");
            this.barChartPanel.validate();
            this.barChartPanel.repaint();
        } else {
            System.out.println("Updating a convergence plot!");
            this.updateConvergePlot(plot);
        }
        System.out.println("Displaying card: " + plot.card);
        this.cl.show(this.chartPanel, plot.card);
        this.chartPanel.validate();
    }

    private void updateConvergePlot(PlotType plot) {
        String title;
        Object yAxisName;
        String xUnit;
        String xAxisName;
        ArrayList<ArbitrarilyDiscretizedFunc> refFuncs = new ArrayList<ArbitrarilyDiscretizedFunc>();
        double lookBack = ((Integer)this.lookBackParam.getValue()).doubleValue();
        double percentThreshold = (Double)this.energyPercentChangeThresholdParam.getValue();
        double changeThreshold = (Double)this.energyChangeThresholdParam.getValue();
        if (((Boolean)this.timeBasedParam.getValue()).booleanValue()) {
            refFuncs.addAll(this.curEnergyVsTimes);
            xAxisName = "Time (minutes)";
            xUnit = "minutes";
            yAxisName = "% Improvement (last " + lookBack + " minutes)";
        } else {
            refFuncs.addAll(this.curEnergyVsIters);
            xAxisName = "Iterations";
            xUnit = "iterations";
            yAxisName = "% Improvement (last " + (int)(lookBack + 0.5) + " iterations)";
        }
        switch (plot.ordinal()) {
            case 7: {
                title = "Improvement (last " + (int)(lookBack + 0.5) + " " + xUnit + ")";
                yAxisName = "Energy Improvement";
                break;
            }
            case 6: {
                title = "% Improvement (last " + (int)(lookBack + 0.5) + " " + xUnit + ")";
                yAxisName = "Energy % Improvement";
                break;
            }
            case 8: {
                title = "Energy vs " + xAxisName;
                yAxisName = "Energy";
                break;
            }
            default: {
                throw new IllegalStateException("Not a convergence plot type: " + String.valueOf((Object)plot));
            }
        }
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        ArrayList<AbstractXY_DataSet> funcs = new ArrayList<AbstractXY_DataSet>();
        List<Color> colors = GraphWindow.generateDefaultColors();
        int colorCnt = 0;
        int setMod = refFuncs.size() / 2;
        if (setMod > 1) {
            System.out.println("Func Set modulus: " + setMod);
        }
        double xSaved = 0.0;
        double xTot = 0.0;
        for (ArbitrarilyDiscretizedFunc func : refFuncs) {
            ArbitrarilyDiscretizedFunc unconvergedFunc = new ArbitrarilyDiscretizedFunc();
            AbstractXY_DataSet convergedFunc = null;
            AbstractXY_DataSet curFunc = unconvergedFunc;
            double transitionEnergy = 0.0;
            double transitionDelta = 0.0;
            double transitionPercent = 0.0;
            block11: for (int i = 0; i < func.size(); ++i) {
                double x = func.getX(i);
                if (x - lookBack - 0.001 < func.getMinX()) continue;
                double curVal = func.getY(i);
                double prevVal = func.getInterpolatedY(x - lookBack);
                double pDiff = DataUtils.getPercentDiff(curVal, prevVal);
                double diff = prevVal - curVal;
                if (convergedFunc == null && pDiff < percentThreshold && diff < changeThreshold) {
                    convergedFunc = new ArbitrarilyDiscretizedFunc();
                    curFunc = convergedFunc;
                    transitionEnergy = curVal;
                    transitionDelta = diff;
                    transitionPercent = pDiff;
                    xSaved += func.getMaxX() - x;
                    xTot += func.getMaxX();
                }
                if (setMod > 1 && i % setMod != 0) continue;
                switch (plot.ordinal()) {
                    case 7: {
                        curFunc.set(x, diff);
                        continue block11;
                    }
                    case 6: {
                        curFunc.set(x, pDiff);
                        continue block11;
                    }
                    case 8: {
                        curFunc.set(x, curVal);
                    }
                }
            }
            if (colorCnt == colors.size()) {
                colorCnt = 0;
            }
            Color color = colors.get(colorCnt++);
            unconvergedFunc.setName(func.getName() + " (unconverged)");
            funcs.add(unconvergedFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, color));
            if (convergedFunc == null) continue;
            convergedFunc.setName(func.getName() + " (converged)");
            double finalEnergy = func.getY(func.size() - 1);
            double postConvergeImp = DataUtils.getPercentDiff(finalEnergy, transitionEnergy);
            convergedFunc.setInfo("Post converge: " + transitionEnergy + " => " + finalEnergy + " (" + (transitionEnergy - finalEnergy) + " = " + (float)postConvergeImp + " %)\nImprovement at Transition Point: " + (transitionDelta + transitionEnergy) + " => " + transitionEnergy + " (" + transitionDelta + " = " + (float)transitionPercent + " %)");
            funcs.add(convergedFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, color));
        }
        System.out.println(xUnit + " saved: " + xSaved + "/" + xTot + " (" + (float)(xSaved / xTot * 100.0) + " %)");
        PlotSpec spec = this.convergeGP.getPlotSpec();
        spec.setXAxisLabel(xAxisName);
        spec.setYAxisLabel((String)yAxisName);
        spec.setPlotElems(funcs);
        spec.setChars(chars);
        spec.setTitle(title);
        this.convergeGP.setX_Log(false);
        this.convergeGP.setY_Log(false);
        this.convergeGP.drawGraph();
        this.convergeGP.validate();
        this.convergeGP.repaint();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        Parameter param = event.getParameter();
        if (param == this.plotTypeParam) {
            this.updatePlot();
        } else if (param == this.refreshButton) {
            try {
                VariableLogicTreeBranch branch = this.getCurrentBranch();
                this.loadResultFiles(branch);
                this.buildFunctions(branch);
                this.updatePlot();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        } else if (param.getName().startsWith(VARIATION_PARAM_NAME)) {
            VariableLogicTreeBranch branch = this.getCurrentBranch();
            this.buildFunctions(branch);
            this.updatePlot();
        } else if (param == this.timeBasedParam) {
            this.lookBackParam.removeParameterChangeListener(this);
            if (((Boolean)this.timeBasedParam.getValue()).booleanValue()) {
                this.lookBackParam.setValue(60);
            } else {
                this.lookBackParam.setValue(2000000);
            }
            this.lookBackParam.getEditor().refreshParamEditor();
            this.lookBackParam.addParameterChangeListener(this);
            this.updatePlot();
        } else if (param == this.lookBackParam || param == this.energyChangeThresholdParam || param == this.energyPercentChangeThresholdParam) {
            this.updatePlot();
        }
    }

    public static void main(String[] args) {
        InversionConvergenceGUI ic = new InversionConvergenceGUI();
        File file = new File("/tmp/2012_03_05-epicenter-test.zip");
        if (file.exists()) {
            ic.browseParam.setValue(file);
        }
    }

    private static enum PlotType {
        ENERGY_VS_TIME("Energy vs Time", "Graph"),
        ENERGY_VS_ITERATIONS("Energy vs Iterations", "Graph"),
        FINAL_ENERGY_BREAKDOWN("Final Energy Breakdown", "Bar"),
        FINAL_NORMALIZED_PERTURBATION_BREAKDOWN("Final Norm. Perturb Breakdown", "Bar"),
        PERTURBATIONS_VS_ITERATIONS("Perturbations Vs Iterations", "Graph"),
        PERTURBATIONS_FRACTION("Perturbs/Iters Vs Time", "Graph"),
        CONVERGENCE_PERCENT_CHANGE("Convergence % Change", "Convergence Playground"),
        CONVERGENCE_CHANGE("Convergence Change", "Convergence Playground"),
        CONVERGENCE_ENERGY("Convergence Energy", "Convergence Playground");

        private String name;
        private String card;

        private PlotType(String name, String card) {
            this.name = name;
            this.card = card;
        }

        public String toString() {
            return this.name;
        }
    }
}

