/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.analysis;

import com.google.common.collect.Lists;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.opensha.commons.hpc.JavaShellScriptWriter;
import org.opensha.commons.hpc.mpj.FastMPJShellScriptWriter;
import org.opensha.commons.hpc.mpj.MPJExpressShellScriptWriter;
import org.opensha.commons.hpc.pbs.BatchScriptWriter;
import org.opensha.commons.hpc.pbs.USC_HPCC_ScriptWriter;
import org.opensha.sha.earthquake.param.BPTAveragingTypeOptions;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityOptions;
import scratch.UCERF3.analysis.MPJ_ERF_ProbGainCalc;
import scratch.UCERF3.simulatedAnnealing.hpc.LogicTreePBSWriter;

public class MPJ_ERF_ProbGainCalcScriptWriter {
    public static void main(String[] args) throws IOException {
        Object runName = "ucerf3-prob-gains-open1875-main-30yr";
        if (args.length > 1) {
            runName = args[1];
        }
        boolean mainFaults = true;
        double duration = 30.0;
        int histBasis = 1875;
        String compoundFileName = "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL.zip";
        LogicTreePBSWriter.RunSites site = LogicTreePBSWriter.RunSites.STAMPEDE;
        int nodes = 60;
        int jobMins = 120;
        int threads = 3;
        File localMainDir = new File("/home/kevin/OpenSHA/UCERF3/probGains");
        if (!localMainDir.exists()) {
            localMainDir.mkdir();
        }
        File remoteMainDir = new File(site.getRUN_DIR().getParentFile(), "prob_gains");
        runName = LogicTreePBSWriter.df.format(new Date()) + "-" + (String)runName;
        File remoteDir = new File(remoteMainDir, (String)runName);
        File writeDir = new File(localMainDir, (String)runName);
        if (!writeDir.exists()) {
            writeDir.mkdir();
        }
        File remoteCompoundfile = new File(remoteMainDir, compoundFileName);
        ArrayList<File> classpath = LogicTreePBSWriter.getClasspath(remoteMainDir, remoteDir);
        JavaShellScriptWriter mpjWrite = site.isFastMPJ() ? new FastMPJShellScriptWriter(site.getJAVA_BIN(), site.getMaxHeapSizeMB(null), classpath, site.getMPJ_HOME()) : new MPJExpressShellScriptWriter(site.getJAVA_BIN(), site.getMaxHeapSizeMB(null), classpath, site.getMPJ_HOME());
        mpjWrite.setInitialHeapSizeMB(site.getInitialHeapSizeMB(null));
        mpjWrite.setHeadless(true);
        BatchScriptWriter batchWrite = site.forBranch(null);
        if (site == LogicTreePBSWriter.RunSites.HPCC) {
            ((USC_HPCC_ScriptWriter)batchWrite).setNodesAddition(null);
        }
        ArrayList calcOpsList = Lists.newArrayList((Object[])BPTAveragingTypeOptions.values());
        MagDependentAperiodicityOptions[] covs = new MagDependentAperiodicityOptions[]{MagDependentAperiodicityOptions.LOW_VALUES, MagDependentAperiodicityOptions.MID_VALUES, MagDependentAperiodicityOptions.HIGH_VALUES};
        String className = MPJ_ERF_ProbGainCalc.class.getName();
        for (BPTAveragingTypeOptions calcOps : calcOpsList) {
            String opsStr = MPJ_ERF_ProbGainCalcScriptWriter.getAveDirName(calcOps);
            for (MagDependentAperiodicityOptions cov : covs) {
                String pbsName = opsStr + "_" + cov.name() + ".pbs";
                File remoteOutput = new File(new File(remoteDir, opsStr), cov.name());
                String classArgs = "--compound-sol " + remoteCompoundfile.getAbsolutePath() + " --output-dir " + remoteOutput.getAbsolutePath() + " --threads " + threads + " --duration " + duration + " --aperiodicity " + cov.name() + " --ave " + calcOps.name();
                if (mainFaults) {
                    classArgs = classArgs + " --main-faults";
                }
                if (histBasis > 0) {
                    classArgs = classArgs + " --hist-open-interval-basis " + histBasis;
                }
                List<String> script = mpjWrite.buildScript(className, classArgs);
                batchWrite.writeScript(new File(writeDir, pbsName), script, jobMins, nodes, site.getPPN(null), null);
            }
        }
    }

    public static String getAveDirName(BPTAveragingTypeOptions aveType) {
        Object opsStr = aveType.isAveRI() ? "aveRI" : "aveRate";
        opsStr = aveType.isAveNTS() ? (String)opsStr + "_aveNTS" : (String)opsStr + "_aveTS";
        return opsStr;
    }
}

