/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.elasticRebound.simulatorAnalysis;

import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.sha.simulators.eqsim_v04.OldGeneral_EQSIM_Tools;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoRateConstraintFetcher;

public class simulatorAnalysisUtils {
    public static void test() {
        File geomFileDir = new File("/Users/field/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/simulatorDataFiles");
        File geomFile = new File(geomFileDir, "ALLCAL2_1-7-11_Geometry.dat");
        File simEventFileDir = new File("/Users/field/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/simulatorDataFiles");
        File eventFile = new File(simEventFileDir, "eqs.ALLCAL2_RSQSim_sigma0.5-5_b=0.015.barall");
        String dirNameForSavingFiles = "tempSimTest_alt2";
        try {
            System.out.println("Loading geometry...");
            OldGeneral_EQSIM_Tools tools = new OldGeneral_EQSIM_Tools(geomFile);
            System.out.println("Loading events...");
            tools.read_EQSIMv04_EventsFile(eventFile);
            tools.setDirNameForSavingFiles(dirNameForSavingFiles);
            tools.testTimePredictability(Double.NaN, true, null, false);
            System.out.println("Done");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void runAll() {
        double[] seismoMagThreshArray;
        File geomFileDir = new File("/Users/field/Field_Other/CEA_WGCEP/UCERF3/ProbModels/ElasticRebound/Files/allcal2_1-7-11");
        File geomFile = new File(geomFileDir, "ALLCAL2_1-7-11_Geometry.dat");
        File simEventFileDir = new File("/Users/field/Field_Other/CEA_WGCEP/UCERF3/ProbModels/ElasticRebound/Files/simulatorDataFiles");
        String[] eventFileArray = new String[]{"eqs.ALLCAL2_RSQSim_sigma0.5-5_b=0.015.barall"};
        String[] dirNamesPrefixArray = new String[]{"RSQSim"};
        for (double magThresh : seismoMagThreshArray = new double[]{Double.NaN}) {
            int dirIndex = -1;
            for (String fileName : eventFileArray) {
                File eventFile = new File(simEventFileDir, fileName);
                String dirNameForSavingFiles = dirNamesPrefixArray[++dirIndex] + "_" + Double.valueOf(magThresh).toString().replaceAll("\\.", "pt");
                try {
                    System.out.println("Loading geometry...");
                    OldGeneral_EQSIM_Tools tools = new OldGeneral_EQSIM_Tools(geomFile);
                    System.out.println("Loading events...");
                    tools.read_EQSIMv04_EventsFile(eventFile);
                    tools.setDirNameForSavingFiles(dirNameForSavingFiles);
                    ArrayList<Object> infoStrings = new ArrayList<Object>();
                    infoStrings.add("UCERF3.elasticRebound.simulatorAnalysis.simulatorAnalysisUtils.runAll()\n");
                    infoStrings.add(dirNameForSavingFiles + "\tusing file " + fileName + "\n");
                    infoStrings.add("Simulation Duration is " + (float)tools.getSimulationDurationYears() + " years\n");
                    System.out.println("Simulation Duration is " + (float)tools.getSimulationDurationYears() + " years\n");
                    System.out.println("Working on plotNormRI_AtHypocenters(*)");
                    tools.plotNormRI_AtHypocenters(magThresh, true);
                    try {
                        FileWriter infoFileWriter = new FileWriter(dirNameForSavingFiles + "/INFO.txt");
                        for (String string : infoStrings) {
                            infoFileWriter.write(string + "\n");
                        }
                        infoFileWriter.close();
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    System.out.println("Done");
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
    }

    public static void plotRI_DistsAtObsPaleoRateSites(OldGeneral_EQSIM_Tools tools, boolean savePlot) {
        try {
            ArrayList<U3PaleoRateConstraint> paleoConstrList = UCERF3_PaleoRateConstraintFetcher.getConstraints();
            for (U3PaleoRateConstraint constr : paleoConstrList) {
                double meanRI = Math.round(1.0 / constr.getMeanRate());
                double low95 = Math.round(1.0 / constr.getUpper95ConfOfRate());
                double up95 = Math.round(1.0 / constr.getLower95ConfOfRate());
                String infoString = "PaleoRates site " + constr.getPaleoSiteName() + " (Biasi Mean RI=" + meanRI + "  & 95% Conf: " + low95 + " to " + up95 + ")\n";
                String name = constr.getPaleoSiteName().replaceAll("\\W+", "_");
                tools.plotRecurIntervalsForNearestLoc(constr.getPaleoSiteLoction(), Double.NaN, savePlot, name, infoString);
            }
            System.out.println("Done");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        simulatorAnalysisUtils.runAll();
    }
}

