/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.enumTreeBranches;

import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum InversionModels implements U3LogicTreeBranchNode<InversionModels>
{
    CHAR_CONSTRAINED("Characteristic (Constrained)", "CharConst", 1.0),
    GR_CONSTRAINED("Gutenberg-Richter (Constrained)", "GRConst", 0.0),
    CHAR_UNCONSTRAINED("Unconstrained (Unconstrained)", "CharUnconst", 0.0),
    GR_UNCONSTRAINED("Unconstrained (Unconstrained)", "GRUnconst", 0.0);

    private String name;
    private String shortName;
    private double weight;

    private InversionModels(String name, String shortName, double weight) {
        this.name = name;
        this.shortName = shortName;
        this.weight = weight;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    public String toString() {
        return this.name;
    }

    public static InversionModels getTypeForName(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        for (InversionModels inv : InversionModels.values()) {
            if (!inv.name.equals(name) && !inv.name().equals(name) && !inv.shortName.equals(name)) continue;
            return inv;
        }
        throw new IllegalArgumentException("InversionModels name does not exist");
    }

    @Override
    public double getRelativeWeight(InversionModels im) {
        return this.weight;
    }

    @Override
    public String encodeChoiceString() {
        return this.getShortName();
    }

    public boolean isCharacteristic() {
        return this == CHAR_CONSTRAINED || this == CHAR_UNCONSTRAINED;
    }

    public boolean isGR() {
        return !this.isCharacteristic();
    }

    public boolean isConstrained() {
        return this == CHAR_CONSTRAINED || this == GR_CONSTRAINED;
    }

    @Override
    public String getBranchLevelName() {
        return "Inversion Model";
    }

    @Override
    public String getShortBranchLevelName() {
        return "IM";
    }
}

