/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.enumTreeBranches;

import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum MomentRateFixes implements U3LogicTreeBranchNode<MomentRateFixes>
{
    APPLY_IMPLIED_CC("Apply Implied Coupling Coefficient", "ApplyCC", 0.0, 0.5),
    RELAX_MFD("Relaxed (weak) MFD Constraint Weights", "RelaxMFD", 0.0, 0.0),
    APPLY_CC_AND_RELAX_MFD("Apply Implied CC and Relax MFD", "ApplyCCRelaxMFD", 0.0, 0.0),
    NONE("No Moment Rate Fixes", "NoFix", 1.0, 0.5);

    private String name;
    private String shortName;
    private double charWeight;
    private double grWeight;

    private MomentRateFixes(String name, String shortName, double charWeight, double grWeight) {
        this.name = name;
        this.shortName = shortName;
        this.charWeight = charWeight;
        this.grWeight = grWeight;
    }

    public boolean isRelaxMFD() {
        return this == RELAX_MFD || this == APPLY_CC_AND_RELAX_MFD;
    }

    public boolean isApplyCC() {
        return this == APPLY_IMPLIED_CC || this == APPLY_CC_AND_RELAX_MFD;
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getRelativeWeight(InversionModels im) {
        if (im == null || im.isCharacteristic()) {
            return this.charWeight;
        }
        return this.grWeight;
    }

    @Override
    public String encodeChoiceString() {
        return this.getShortName();
    }

    @Override
    public String getBranchLevelName() {
        return "Moment Rate Fixes";
    }

    @Override
    public String getShortBranchLevelName() {
        return "MomRateFix";
    }
}

