/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.enumTreeBranches;

import com.google.common.collect.Lists;
import com.google.common.primitives.Doubles;
import java.util.ArrayList;
import java.util.Collection;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.logicTree.Affects;
import org.opensha.commons.logicTree.DoesNotAffect;
import scratch.UCERF3.analysis.DeformationModelsCalc;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.DeformationModelOffFaultMoRateData;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.SmoothSeismicitySpatialPDF_Fetcher;

@DoesNotAffect.NotAffected(value={@DoesNotAffect(value="fault_sections.geojson"), @DoesNotAffect(value="indices.csv"), @DoesNotAffect(value="properties.csv")})
@Affects(value="rates.csv")
public enum SpatialSeisPDF implements U3LogicTreeBranchNode<SpatialSeisPDF>
{
    UCERF2("UCERF2", "U2", 0.5, 0.25){

        @Override
        public double[] getPDF() {
            return SmoothSeismicitySpatialPDF_Fetcher.getUCERF2();
        }
    }
    ,
    UCERF3("UCERF3", "U3", 0.5, 0.25){

        @Override
        public double[] getPDF() {
            return SmoothSeismicitySpatialPDF_Fetcher.getUCERF3();
        }
    }
    ,
    AVG_DEF_MODEL_OFF("Average Deformation Model Off Fault", "AveDM_off", 0.0, 0.5){

        @Override
        public double[] getPDF() {
            CaliforniaRegions.RELM_TESTING_GRIDDED region = RELM_RegionUtils.getGriddedRegionInstance();
            GriddedGeoDataSet xyz = DeformationModelOffFaultMoRateData.getInstance().getAveDefModelPDF(false);
            ArrayList vals = Lists.newArrayList();
            for (Location loc : region) {
                vals.add(xyz.get(loc));
            }
            return Doubles.toArray((Collection)vals);
        }
    }
    ,
    AVG_DEF_MODEL_ALL("Average Deformation Model Including Faults", "AveDM_all", 0.0, 0.0){

        @Override
        public double[] getPDF() {
            CaliforniaRegions.RELM_TESTING_GRIDDED region = RELM_RegionUtils.getGriddedRegionInstance();
            GriddedGeoDataSet xyz = DeformationModelsCalc.getAveDefModSpatialPDF_WithFaults();
            ArrayList vals = Lists.newArrayList();
            for (Location loc : region) {
                vals.add(xyz.get(loc));
            }
            return Doubles.toArray((Collection)vals);
        }
    }
    ,
    UNSMOOTHED_GRIDDED("Unsmoothed", "Unsmoothed", 0.0, 0.0){

        @Override
        public double[] getPDF() {
            return SmoothSeismicitySpatialPDF_Fetcher.getUnsmoothed();
        }
    };

    private String name;
    private String shortName;
    private double charWeight;
    private double grWeight;

    private SpatialSeisPDF(String name, String shortName, double charWeight, double grWeight) {
        this.name = name;
        this.shortName = shortName;
        this.charWeight = charWeight;
        this.grWeight = grWeight;
    }

    public abstract double[] getPDF();

    public double getFractionInRegion(GriddedRegion region) {
        double[] vals = this.getPDF();
        double sum = 0.0;
        CaliforniaRegions.RELM_TESTING_GRIDDED relmRegion = RELM_RegionUtils.getGriddedRegionInstance();
        for (int i = 0; i < region.getNumLocations(); ++i) {
            int iLoc = relmRegion.indexForLocation(region.getLocation(i));
            if (iLoc == -1) continue;
            sum += vals[iLoc];
        }
        return sum;
    }

    public static void testSums() {
        ArrayList<SpatialSeisPDF> testPDF_List = new ArrayList<SpatialSeisPDF>();
        testPDF_List.add(UCERF3);
        testPDF_List.add(UCERF2);
        testPDF_List.add(AVG_DEF_MODEL_OFF);
        for (SpatialSeisPDF testPDF : testPDF_List) {
            double[] vals = testPDF.getPDF();
            double sum = 0.0;
            for (int i = 0; i < vals.length; ++i) {
                sum += vals[i];
            }
            System.out.println(String.valueOf(testPDF) + " sum = " + (float)sum);
        }
    }

    @Override
    public String getShortName() {
        return this.shortName;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public double getRelativeWeight(InversionModels im) {
        if (im == null || im.isCharacteristic()) {
            return this.charWeight;
        }
        return this.grWeight;
    }

    @Override
    public String encodeChoiceString() {
        return "SpatSeis" + this.getShortName();
    }

    @Override
    public String getBranchLevelName() {
        return "Spatial Seismicity PDF";
    }

    @Override
    public String getShortBranchLevelName() {
        return "SpatSeis";
    }

    public static void main(String[] args) {
        SpatialSeisPDF.testSums();
        CaliforniaRegions.RELM_NOCAL_GRIDDED noCalGrid = RELM_RegionUtils.getNoCalGriddedRegionInstance();
        CaliforniaRegions.RELM_SOCAL_GRIDDED soCalGrid = RELM_RegionUtils.getSoCalGriddedRegionInstance();
        ArrayList<SpatialSeisPDF> testPDF_List = new ArrayList<SpatialSeisPDF>();
        testPDF_List.add(UCERF3);
        testPDF_List.add(UCERF2);
        testPDF_List.add(AVG_DEF_MODEL_OFF);
        for (SpatialSeisPDF testPDF : testPDF_List) {
            double noFrac = testPDF.getFractionInRegion(noCalGrid);
            double soFrac = testPDF.getFractionInRegion(soCalGrid);
            System.out.println(String.valueOf(testPDF) + "\tnoFrac=" + (float)noFrac + "\tsoFrac=" + (float)soFrac + "\tsum=" + (float)(noFrac + soFrac));
        }
    }
}

