/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import org.opensha.commons.geo.Location;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;

public class ETAS_EqkRupture
extends ObsEqkRupture {
    private int id = -1;
    private int nthERF_Index = -1;
    private int generation = 0;
    private int fssIndex = -1;
    private int gridNodeIndex = -1;
    private int cubeIndex = -1;
    private double distToParent = Double.NaN;
    private ETAS_EqkRupture parentRup = null;
    private int parentID = -1;
    private Location parentTriggerLoc = null;
    private double k = Double.NaN;
    private double c = Double.NaN;
    private double p = Double.NaN;

    public ETAS_EqkRupture() {
    }

    public ETAS_EqkRupture(ProbEqkRupture probRup) {
        this.setMag(probRup.getMag());
        this.setRuptureSurface(probRup.getRuptureSurface());
        this.setAveRake(probRup.getAveRake());
    }

    public ETAS_EqkRupture(ObsEqkRupture probRup) {
        this.setMag(probRup.getMag());
        this.setRuptureSurface(probRup.getRuptureSurface());
        this.setAveRake(probRup.getAveRake());
        this.setOriginTime(probRup.getOriginTime());
        this.setEventId(probRup.getEventId());
        this.setHypocenterLocation(probRup.getHypocenterLocation());
    }

    public ETAS_EqkRupture(ETAS_EqkRupture parentRup, int id, long originTimeInMillis) {
        this.parentRup = parentRup;
        this.parentID = parentRup.getID();
        this.id = id;
        this.originTimeInMillis = originTimeInMillis;
    }

    public int getParentID() {
        return this.parentID;
    }

    public void setParentID(int parID) {
        if (this.parentRup != null && this.parentRup.getID() != parID) {
            throw new RuntimeException("Parent ID conflict");
        }
        this.parentID = parID;
    }

    public ETAS_EqkRupture getParentRup() {
        return this.parentRup;
    }

    public double getDistanceToParent() {
        return this.distToParent;
    }

    public void setDistanceToParent(double distToParent) {
        this.distToParent = distToParent;
    }

    public int getID() {
        return this.id;
    }

    public void setID(int id) {
        this.id = id;
    }

    public int getGeneration() {
        return this.generation;
    }

    public void setGeneration(int generation) {
        this.generation = generation;
    }

    public void setNthERF_Index(int nthERF_Index) {
        this.nthERF_Index = nthERF_Index;
    }

    public int getNthERF_Index() {
        return this.nthERF_Index;
    }

    public int getFSSIndex() {
        return this.fssIndex;
    }

    public void setFSSIndex(int fssIndex) {
        this.fssIndex = fssIndex;
    }

    public int getGridNodeIndex() {
        return this.gridNodeIndex;
    }

    public void setGridNodeIndex(int gridNodeIndex) {
        this.gridNodeIndex = gridNodeIndex;
    }

    public int getCubeIndex() {
        return this.cubeIndex;
    }

    public void setCubeIndex(int cubeIndex) {
        this.cubeIndex = cubeIndex;
    }

    public void setParentTriggerLoc(Location loc) {
        this.parentTriggerLoc = loc;
    }

    public Location getParentTriggerLoc() {
        return this.parentTriggerLoc;
    }

    public ETAS_EqkRupture getOldestAncestor() {
        int gen = this.getGeneration();
        ETAS_EqkRupture oldestAncestor = this.getParentRup();
        if (gen == 0 || oldestAncestor == null) {
            return null;
        }
        while (gen > 1) {
            if (oldestAncestor.getGeneration() != gen - 1) {
                throw new RuntimeException("Problem with generation");
            }
            gen = oldestAncestor.getGeneration();
            oldestAncestor = oldestAncestor.getParentRup();
        }
        if (oldestAncestor.getGeneration() != 0) {
            throw new RuntimeException("Problem with generation");
        }
        return oldestAncestor;
    }

    public void setCustomETAS_Params(Double k, Double p, Double c) {
        this.k = k == null ? Double.NaN : k;
        this.p = p == null ? Double.NaN : p;
        this.c = c == null ? Double.NaN : c;
    }

    public double getETAS_k() {
        return this.k;
    }

    public double getETAS_c() {
        return this.c;
    }

    public double getETAS_p() {
        return this.p;
    }

    public void setETAS_k(double k) {
        this.k = k;
    }

    public void setETAS_c(double c) {
        this.c = c;
    }

    public void setETAS_p(double p) {
        this.p = p;
    }

    @Override
    public Object clone() {
        ObsEqkRupture parentClone = (ObsEqkRupture)super.clone();
        ETAS_EqkRupture clone = new ETAS_EqkRupture(parentClone);
        clone.id = this.id;
        clone.nthERF_Index = this.nthERF_Index;
        clone.generation = this.generation;
        clone.fssIndex = this.fssIndex;
        clone.gridNodeIndex = this.gridNodeIndex;
        clone.cubeIndex = this.cubeIndex;
        clone.distToParent = this.distToParent;
        clone.parentRup = this.parentRup;
        clone.parentID = this.parentID;
        clone.parentTriggerLoc = this.parentTriggerLoc;
        clone.k = this.k;
        clone.p = this.p;
        clone.c = this.c;
        return clone;
    }
}

