/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.collect.HashBasedTable;
import com.google.common.collect.ImmutableList;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import com.google.common.io.Files;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.Font;
import java.awt.Paint;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.net.MalformedURLException;
import java.nio.charset.Charset;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipException;
import org.apache.commons.math3.stat.StatUtils;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.jfree.chart.annotations.XYTextAnnotation;
import org.jfree.chart.ui.TextAnchor;
import org.jfree.data.Range;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.data.xyz.GeoDataSet;
import org.opensha.commons.data.xyz.GeoDataSetMath;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.exceptions.GMT_MapException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.ComparablePairing;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.XMLUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.commons.util.cpt.CPTVal;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.ArbIncrementalMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.analysis.FaultBasedMapGen;
import scratch.UCERF3.analysis.FaultSysSolutionERF_Calc;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.FSSRupsInRegionCache;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class ETAS_MultiSimAnalysisTools {
    static double mfdMinMag = 2.55;
    static double mfdDelta = 0.1;
    static int mfdNumMag = 66;
    public static double mfdMinY = 1.0E-4;
    public static double mfdMaxY = 10000.0;
    private static final double MILLIS_PER_YEAR = 3.15576E10;
    private static final String plotDirName = "plots";
    private static final String catsDirName = "selected_catalogs";
    private static final int html_w_px = 800;

    public static int calcNumWithMagAbove(List<List<ETAS_EqkRupture>> catalogs, double targetMinMag) {
        long ot = Math.round(1.3885344E12);
        return ETAS_MultiSimAnalysisTools.calcNumWithMagAbove(catalogs, ot, targetMinMag, -1, -1);
    }

    public static int calcNumWithMagAbove(List<List<ETAS_EqkRupture>> catalogs, long ot, double targetMinMag, int triggerParentID, int maxDaysAfter) {
        HashSet<Integer> triggerParentIDs = null;
        if (triggerParentID >= 0) {
            triggerParentIDs = new HashSet<Integer>();
            triggerParentIDs.add(triggerParentID);
        }
        int num = 0;
        long maxEventTime = maxDaysAfter > 0 ? ot + (long)maxDaysAfter * 86400000L : -1L;
        block0: for (List<ETAS_EqkRupture> catalog : catalogs) {
            for (ETAS_EqkRupture rup : catalog) {
                if (maxEventTime > 0L && rup.getOriginTime() > maxEventTime) continue block0;
                boolean child = true;
                if (triggerParentID >= 0) {
                    if (triggerParentIDs.contains(rup.getParentID())) {
                        triggerParentIDs.add(rup.getID());
                    } else {
                        child = false;
                    }
                }
                if (!(rup.getMag() > targetMinMag) || !child) continue;
                ++num;
                continue block0;
            }
        }
        String childAdd = triggerParentID >= 0 ? " child" : "";
        Object dateAdd = maxDaysAfter > 0 ? " within " + maxDaysAfter + " days of start of catalog" : "";
        double percent = 100.0 * ((double)num / (double)catalogs.size());
        System.out.println(num + "/" + catalogs.size() + " (" + (float)percent + " %) of catalogs had" + childAdd + " rup with M>" + (float)targetMinMag + (String)dateAdd);
        return num;
    }

    public static List<Double> calcTotalMoments(List<List<ETAS_EqkRupture>> catalogs) {
        ArrayList ret = Lists.newArrayList();
        for (List<ETAS_EqkRupture> catalog : catalogs) {
            ret.add(ETAS_MultiSimAnalysisTools.calcTotalMoment(catalog));
        }
        return ret;
    }

    public static double calcTotalMoment(List<ETAS_EqkRupture> catalog) {
        double moment = 0.0;
        for (ETAS_EqkRupture rup : catalog) {
            moment += MagUtils.magToMoment(rup.getMag());
        }
        return moment;
    }

    static FractileCurveCalculator getFractileCalc(EvenlyDiscretizedFunc[] mfds) {
        XY_DataSetList funcsList = new XY_DataSetList();
        ArrayList relativeWeights = Lists.newArrayList();
        for (int i = 0; i < mfds.length; ++i) {
            Preconditions.checkNotNull((Object)mfds[i]);
            funcsList.add(mfds[i]);
            relativeWeights.add(1.0);
        }
        return new FractileCurveCalculator(funcsList, relativeWeights);
    }

    static int calcNumMagToTrim(List<? extends List<ETAS_EqkRupture>> catalogs) {
        double minMag = mfdMinMag;
        HistogramFunction hist = new HistogramFunction(mfdMinMag, mfdNumMag, mfdDelta);
        for (List<ETAS_EqkRupture> list : catalogs) {
            for (ETAS_EqkRupture rup : list) {
                hist.add(hist.getClosestXIndex(rup.getMag()), 1.0);
            }
        }
        double catModalMag = hist.getX(hist.getXindexForMaxY()) - 0.49 * mfdDelta;
        if (Double.isInfinite(catModalMag)) {
            throw new IllegalStateException("Empty catalogs!");
        }
        int numToTrim = 0;
        while (catModalMag > minMag + 0.5 * mfdDelta) {
            minMag += mfdDelta;
            ++numToTrim;
        }
        return numToTrim;
    }

    private static void plotExpectedSupraComparisonMFD(List<List<ETAS_EqkRupture>> catalogs, File outputDir, String name, String prefix) throws IOException {
        double minMag = mfdMinMag;
        int numMag = mfdNumMag;
        int numToTrim = ETAS_MultiSimAnalysisTools.calcNumMagToTrim(catalogs);
        for (int i = 0; i < numToTrim; ++i) {
            minMag += mfdDelta;
            --numMag;
        }
        ArbIncrementalMagFreqDist mfd = new ArbIncrementalMagFreqDist(minMag, numMag, mfdDelta);
        double rate = 1.0 / (double)catalogs.size();
        for (int i = 0; i < catalogs.size(); ++i) {
            List<ETAS_EqkRupture> catalog = catalogs.get(i);
            ArbIncrementalMagFreqDist subMFD = new ArbIncrementalMagFreqDist(minMag, numMag, mfdDelta);
            for (ETAS_EqkRupture rup : catalog) {
                if (rup.getFSSIndex() < 0) continue;
                subMFD.addResampledMagRate(rup.getMag(), rate, true);
            }
            for (int n = 0; n < subMFD.size(); ++n) {
                if (subMFD.getY(n) != 0.0) continue;
                mfd.add(n, rate);
            }
        }
        for (int n = 0; n < mfd.size(); ++n) {
            mfd.set(n, 1.0 - mfd.getY(n));
        }
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        mfd.setName("Mean");
        funcs.add(mfd);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(funcs, chars, name + " Supra MFD Compare To Expected", "Magnitude", "Incremental Rate (1/yr)");
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setUserBounds(mfdMinMag, mfd.getMaxX(), Math.pow(10.0, Math.log10(mfdMinY) - 2.0), Math.pow(10.0, Math.log10(mfdMaxY) - 2.0));
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, true);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    public static void setFontSizes(HeadlessGraphPanel gp) {
        ETAS_MultiSimAnalysisTools.setFontSizes(gp, 0);
    }

    public static void setFontSizes(HeadlessGraphPanel gp, int addition) {
        gp.setBackgroundColor(Color.WHITE);
        gp.setTickLabelFontSize(22 + addition);
        gp.setAxisLabelFontSize(24 + addition);
        gp.setPlotLabelFontSize(24 + addition);
    }

    private static ArbIncrementalMagFreqDist[] plotMFD(List<List<ETAS_EqkRupture>> catalogs, double duration, FaultSystemSolutionERF erfForComparison, File outputDir, String name, String prefix) throws IOException {
        boolean[] cumulatives;
        int i;
        double minMag = mfdMinMag;
        int numMag = mfdNumMag;
        int numToTrim = ETAS_MultiSimAnalysisTools.calcNumMagToTrim(catalogs);
        if (numToTrim > 0) {
            System.out.println("Trimming " + numToTrim + " MFD bins");
        }
        for (int i2 = 0; i2 < numToTrim; ++i2) {
            minMag += mfdDelta;
            --numMag;
        }
        ArbIncrementalMagFreqDist[] subMFDs = new ArbIncrementalMagFreqDist[catalogs.size()];
        EvenlyDiscretizedFunc[] cmlSubMFDs = new EvenlyDiscretizedFunc[catalogs.size()];
        for (i = 0; i < catalogs.size(); ++i) {
            subMFDs[i] = new ArbIncrementalMagFreqDist(minMag, numMag, mfdDelta);
        }
        for (i = 0; i < catalogs.size(); ++i) {
            List<ETAS_EqkRupture> catalog = catalogs.get(i);
            double myDuration = duration < 0.0 ? ETAS_MultiSimAnalysisTools.calcDurationYears(catalog) : duration;
            if (myDuration > 0.0) {
                double rateEach = 1.0 / myDuration;
                for (ETAS_EqkRupture rup : catalog) {
                    subMFDs[i].addResampledMagRate(rup.getMag(), rateEach, true);
                }
            }
            cmlSubMFDs[i] = subMFDs[i].getCumRateDistWithOffset();
        }
        if (outputDir == null) {
            return subMFDs;
        }
        SummedMagFreqDist comparisonMFD = null;
        if (erfForComparison != null) {
            comparisonMFD = ERF_Calculator.getTotalMFD_ForERF(erfForComparison, subMFDs[0].getMinX(), subMFDs[0].getMaxX(), subMFDs[0].size(), true);
        }
        for (boolean cumulative : cumulatives = new boolean[]{false, true}) {
            String yAxisLabel;
            EvenlyDiscretizedFunc[] mySubMFDs;
            Object myPrefix = prefix;
            myPrefix = myPrefix == null || ((String)myPrefix).isEmpty() ? "" : (String)myPrefix + "_";
            myPrefix = (String)myPrefix + "mfd_";
            if (cumulative) {
                mySubMFDs = cmlSubMFDs;
                yAxisLabel = "Cumulative Rate (1/yr)";
                myPrefix = (String)myPrefix + "cumulative";
            } else {
                mySubMFDs = subMFDs;
                yAxisLabel = "Incremental Rate (1/yr)";
                myPrefix = (String)myPrefix + "incremental";
            }
            ArrayList funcs = Lists.newArrayList();
            ArrayList chars = Lists.newArrayList();
            File csvFile = new File(outputDir, (String)myPrefix + ".csv");
            double[] fractiles = new double[]{0.025, 0.25, 0.75, 0.975};
            if (comparisonMFD != null) {
                EvenlyDiscretizedFunc comp = cumulative ? comparisonMFD.getCumRateDistWithOffset() : comparisonMFD;
                comp.setName("Long Term ERF");
                funcs.add(comp);
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GRAY));
            }
            ETAS_MultiSimAnalysisTools.getFractilePlotFuncs(mySubMFDs, fractiles, true, funcs, chars, csvFile);
            PlotSpec spec = new PlotSpec(funcs, chars, name + " MFD", "Magnitude", yAxisLabel);
            spec.setLegendVisible(true);
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setUserBounds(mfdMinMag, subMFDs[0].getMaxX(), mfdMinY, mfdMaxY);
            ETAS_MultiSimAnalysisTools.setFontSizes(gp);
            gp.drawGraphPanel(spec, false, true);
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPNG(new File(outputDir, (String)myPrefix + ".png").getAbsolutePath());
            gp.saveAsPDF(new File(outputDir, (String)myPrefix + ".pdf").getAbsolutePath());
            gp.saveAsTXT(new File(outputDir, (String)myPrefix + ".txt").getAbsolutePath());
        }
        return subMFDs;
    }

    private static EvenlyDiscretizedFunc[] calcFractAboveZero(ArbIncrementalMagFreqDist[] subMFDs) {
        EvenlyDiscretizedFunc atFunc = new EvenlyDiscretizedFunc(subMFDs[0].getMinX(), subMFDs[0].getMaxX(), subMFDs[0].size());
        EvenlyDiscretizedFunc atOrAboveFunc = new EvenlyDiscretizedFunc(atFunc.getMinX() - atFunc.getDelta() * 0.5, atFunc.size(), atFunc.getDelta());
        double fractEach = 1.0 / (double)subMFDs.length;
        for (int i = 0; i < subMFDs.length; ++i) {
            int m;
            ArbIncrementalMagFreqDist subMFD = subMFDs[i];
            int maxMagIndex = -1;
            for (m = 0; m < subMFD.size(); ++m) {
                if (!(subMFD.getY(m) > 0.0)) continue;
                atFunc.add(m, fractEach);
                maxMagIndex = m;
            }
            for (m = 0; m <= maxMagIndex; ++m) {
                atOrAboveFunc.add(m, fractEach);
            }
        }
        atFunc.setName("Fract With Mag");
        atOrAboveFunc.setName("Fract With \u2265 Mag");
        return new EvenlyDiscretizedFunc[]{atFunc, atOrAboveFunc};
    }

    private static void plotFractWithMagAbove(List<List<ETAS_EqkRupture>> catalogs, ArbIncrementalMagFreqDist[] subMFDs, ETAS_Simulator.TestScenario scenario, File outputDir, String name, String prefix) throws IOException {
        if (subMFDs == null) {
            subMFDs = ETAS_MultiSimAnalysisTools.plotMFD(catalogs, -1.0, null, null, null, null);
        }
        Preconditions.checkArgument((subMFDs.length > 0 ? 1 : 0) != 0);
        Preconditions.checkArgument((subMFDs.length == catalogs.size() ? 1 : 0) != 0);
        double delta = subMFDs[0].getDelta();
        EvenlyDiscretizedFunc[] myFuncs = ETAS_MultiSimAnalysisTools.calcFractAboveZero(subMFDs);
        EvenlyDiscretizedFunc atFunc = myFuncs[0];
        EvenlyDiscretizedFunc atOrAboveFunc = myFuncs[1];
        double fractEach = 1.0 / (double)subMFDs.length;
        double minY = Math.min(fractEach, 1.0E-4);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(atFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLUE));
        funcs.add(atOrAboveFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        ArrayList anns = null;
        if (scenario != null) {
            DefaultXY_DataSet xy = new DefaultXY_DataSet();
            double mag = scenario.getMagnitude();
            xy.setName("Scenario M=" + (float)mag);
            xy.set(mag, 0.0);
            xy.set(mag, minY);
            xy.set(mag, fractEach);
            xy.set(mag, 1.0);
            funcs.add(xy);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, new Color(0, 180, 0)));
            double fractAboveMag = (double)ETAS_MultiSimAnalysisTools.calcNumWithMagAbove(catalogs, mag) / (double)catalogs.size();
            DecimalFormat df = new DecimalFormat("0.#");
            XYTextAnnotation ann = new XYTextAnnotation(" " + df.format(fractAboveMag * 100.0) + "% > M" + df.format(mag), mag, fractAboveMag);
            ann.setFont(new Font("SansSerif", 1, 24));
            ann.setTextAnchor(TextAnchor.BOTTOM_LEFT);
            Color red = new Color(180, 0, 0);
            ann.setPaint((Paint)red);
            anns = Lists.newArrayList((Object[])new XYTextAnnotation[]{ann});
            xy = new DefaultXY_DataSet();
            xy.setName(null);
            xy.set(mag, fractAboveMag);
            funcs.add(xy);
            chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 5.0f, red));
        }
        PlotSpec spec = new PlotSpec(funcs, chars, name + " Fract With Mag", "Magnitude", "Fraction Of Simulations");
        spec.setLegendVisible(true);
        spec.setPlotAnnotations(anns);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setUserBounds(atFunc.getMinX() - 0.5 * delta, atFunc.getMaxX(), minY, 1.0);
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, true);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    private static EvenlyDiscretizedFunc getCatalogMode(EvenlyDiscretizedFunc[] allFuncs, FractileCurveCalculator fractCalc) {
        EvenlyDiscretizedFunc ret = new EvenlyDiscretizedFunc(allFuncs[0].getMinX(), allFuncs[0].size(), allFuncs[0].getDelta());
        for (int i = 0; i < ret.size(); ++i) {
            ArbDiscrEmpiricalDistFunc dist = fractCalc.getEmpiricalDist(i);
            double mode = dist.size() == 1 ? dist.getX(0) : dist.getMostCentralMode();
            ret.set(i, mode);
        }
        return ret;
    }

    public static void plotMagNum(List<? extends List<ETAS_EqkRupture>> catalogs, File outputDir, String name, String prefix, ETAS_Simulator.TestScenario scenario, double expNumForM2p5, FaultSystemSolution fss) throws IOException {
        ETAS_MultiSimAnalysisTools.plotMagNum(catalogs, outputDir, name, prefix, scenario, expNumForM2p5, fss, Long.MAX_VALUE);
    }

    public static void plotMagNum(List<? extends List<ETAS_EqkRupture>> catalogs, File outputDir, String name, String prefix, ETAS_Simulator.TestScenario scenario, double expNumForM2p5, FaultSystemSolution fss, long maxOT) throws IOException {
        double minMag = mfdMinMag;
        int numMag = mfdNumMag;
        int numToTrim = ETAS_MultiSimAnalysisTools.calcNumMagToTrim(catalogs);
        if (numToTrim > 0) {
            System.out.println("Trimming " + numToTrim + " MFD bins");
        }
        for (int i = 0; i < numToTrim; ++i) {
            minMag += mfdDelta;
            --numMag;
        }
        ArbIncrementalMagFreqDist[] subMagNums = new ArbIncrementalMagFreqDist[catalogs.size()];
        EvenlyDiscretizedFunc[] cmlSubMagNums = new EvenlyDiscretizedFunc[catalogs.size()];
        for (int i = 0; i < catalogs.size(); ++i) {
            subMagNums[i] = new ArbIncrementalMagFreqDist(minMag, numMag, mfdDelta);
        }
        ArbIncrementalMagFreqDist primaryMFD = new ArbIncrementalMagFreqDist(minMag, numMag, mfdDelta);
        double primaryNumEach = 1.0 / (double)catalogs.size();
        for (int i = 0; i < catalogs.size(); ++i) {
            List<ETAS_EqkRupture> catalog = catalogs.get(i);
            for (ETAS_EqkRupture rup : catalog) {
                if (rup.getOriginTime() > maxOT) break;
                subMagNums[i].addResampledMagRate(rup.getMag(), 1.0, true);
                int gen = rup.getGeneration();
                Preconditions.checkState((gen != 0 ? 1 : 0) != 0, (Object)"This catalog has spontaneous events!");
                if (gen != 1) continue;
                primaryMFD.addResampledMagRate(rup.getMag(), primaryNumEach, true);
            }
            cmlSubMagNums[i] = subMagNums[i].getCumRateDistWithOffset();
        }
        boolean[] cumulatives = new boolean[]{false, true};
        EvenlyDiscretizedFunc[] myFuncs = ETAS_MultiSimAnalysisTools.calcFractAboveZero(subMagNums);
        EvenlyDiscretizedFunc atFunc = myFuncs[0];
        EvenlyDiscretizedFunc atOrAboveFunc = myFuncs[1];
        IncrementalMagFreqDist regionalGR = null;
        if (expNumForM2p5 > 0.0) {
            regionalGR = ETAS_SimAnalysisTools.getTotalAftershockMFD_ForU3_RegionalGR(scenario.getMagnitude(), expNumForM2p5, fss);
        }
        for (boolean cumulative : cumulatives) {
            EvenlyDiscretizedFunc myAtFunc;
            String yAxisLabel;
            EvenlyDiscretizedFunc[] mySubMagNums;
            EvenlyDiscretizedFunc myPrimaryFunc;
            Object myPrefix = prefix;
            myPrefix = myPrefix == null || ((String)myPrefix).isEmpty() ? "" : (String)myPrefix + "_";
            myPrefix = (String)myPrefix + "mag_num_";
            EvenlyDiscretizedFunc myRegionalGR = null;
            if (cumulative) {
                myPrimaryFunc = primaryMFD.getCumRateDistWithOffset();
                myPrimaryFunc.setName("Primary");
                mySubMagNums = cmlSubMagNums;
                yAxisLabel = "Cumulative Number";
                myPrefix = (String)myPrefix + "cumulative";
                myAtFunc = atOrAboveFunc;
                if (regionalGR != null) {
                    myRegionalGR = regionalGR.getCumRateDistWithOffset();
                }
            } else {
                myPrimaryFunc = primaryMFD;
                myPrimaryFunc.setName("Primary");
                mySubMagNums = subMagNums;
                yAxisLabel = "Incremental Number";
                myPrefix = (String)myPrefix + "incremental";
                myAtFunc = atFunc;
                if (regionalGR != null) {
                    myRegionalGR = regionalGR;
                }
            }
            if (myRegionalGR != null) {
                ((AbstractXY_DataSet)myRegionalGR).setName("GR");
            }
            ArrayList funcs = Lists.newArrayList();
            ArrayList chars = Lists.newArrayList();
            File csvFile = new File(outputDir, (String)myPrefix + ".csv");
            double[] fractiles = new double[]{0.025, 0.975};
            funcs.add(myPrimaryFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GREEN.darker()));
            XY_DataSet meanFunc = ETAS_MultiSimAnalysisTools.getFractilePlotFuncs(mySubMagNums, fractiles, funcs, chars, csvFile, Color.BLACK, Color.BLUE, Color.CYAN, null, myAtFunc, myPrimaryFunc);
            if (myRegionalGR != null) {
                funcs.add(myRegionalGR);
                chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, Color.BLACK));
            }
            funcs.add(myAtFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
            for (PlotCurveCharacterstics theChar : chars) {
                theChar.setLineWidth(theChar.getLineWidth() * 2.0f);
            }
            PlotSpec spec = new PlotSpec(funcs, chars, name, "Magnitude", yAxisLabel);
            spec.setLegendVisible(true);
            HeadlessGraphPanel gp = new HeadlessGraphPanel();
            gp.setUserBounds(myPrimaryFunc.getMinX(), subMagNums[0].getMaxX(), mfdMinY, mfdMaxY);
            gp.setLegendFontSize(20);
            ETAS_MultiSimAnalysisTools.setFontSizes(gp, 10);
            gp.drawGraphPanel(spec, false, true);
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPNG(new File(outputDir, (String)myPrefix + ".png").getAbsolutePath());
            gp.saveAsPDF(new File(outputDir, (String)myPrefix + ".pdf").getAbsolutePath());
            gp.saveAsTXT(new File(outputDir, (String)myPrefix + ".txt").getAbsolutePath());
            if (!cumulative) continue;
            funcs = Lists.newArrayList();
            chars = Lists.newArrayList();
            ArbitrarilyDiscretizedFunc upperFunc = new ArbitrarilyDiscretizedFunc();
            upperFunc.setName("Upper 95%");
            ArbitrarilyDiscretizedFunc lowerFunc = new ArbitrarilyDiscretizedFunc();
            lowerFunc.setName("Lower 95%");
            for (int i = 0; i < meanFunc.size(); ++i) {
                double x = meanFunc.getX(i);
                double y = meanFunc.getY(i);
                if (y >= 1.0) {
                    upperFunc.set(x, y);
                    lowerFunc.set(x, y);
                    continue;
                }
                double[] conf = ETAS_Utils.getBinomialProportion95confidenceInterval(y, catalogs.size());
                lowerFunc.set(x, conf[0]);
                upperFunc.set(x, conf[1]);
            }
            funcs.add(lowerFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.BLACK));
            funcs.add(upperFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.BLACK));
            funcs.add(meanFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            spec = new PlotSpec(funcs, chars, name, "Magnitude", yAxisLabel);
            spec.setLegendVisible(true);
            gp = new HeadlessGraphPanel();
            gp.setUserBounds(myPrimaryFunc.getMinX(), subMagNums[0].getMaxX(), mfdMinY, mfdMaxY);
            gp.setLegendFontSize(20);
            ETAS_MultiSimAnalysisTools.setFontSizes(gp, 10);
            gp.drawGraphPanel(spec, false, true);
            gp.getChartPanel().setSize(1000, 800);
            gp.saveAsPNG(new File(outputDir, (String)myPrefix + "_mean_with_conf.png").getAbsolutePath());
            gp.saveAsPDF(new File(outputDir, (String)myPrefix + "_mean_with_conf.pdf").getAbsolutePath());
            gp.saveAsTXT(new File(outputDir, (String)myPrefix + "_mean_with_conf.txt").getAbsolutePath());
        }
    }

    private static void getFractilePlotFuncs(EvenlyDiscretizedFunc[] allFuncs, double[] fractiles, boolean mode, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, File csvFile) throws IOException {
        Color fractileColor = Color.GREEN.darker();
        Color medianColor = Color.BLUE;
        Color modeColor = mode ? Color.CYAN : null;
        Color sdomColor = Color.RED.darker();
        ETAS_MultiSimAnalysisTools.getFractilePlotFuncs(allFuncs, fractiles, funcs, chars, csvFile, fractileColor, medianColor, modeColor, sdomColor, new EvenlyDiscretizedFunc[0]);
    }

    /*
     * WARNING - void declaration
     */
    private static XY_DataSet getFractilePlotFuncs(EvenlyDiscretizedFunc[] allFuncs, double[] fractiles, List<XY_DataSet> funcs, List<PlotCurveCharacterstics> chars, File csvFile, Color fractileColor, Color medianColor, Color modeColor, Color sdomColor, EvenlyDiscretizedFunc ... otherCSVFuncs) throws IOException {
        int i;
        FractileCurveCalculator fractCalc = ETAS_MultiSimAnalysisTools.getFractileCalc(allFuncs);
        ArrayList fractileFuncs = Lists.newArrayList();
        ArrayList fractileNames = Lists.newArrayList();
        for (i = 0; i < fractiles.length; ++i) {
            fractileNames.add((float)(fractiles[i] * 100.0) + "%");
        }
        for (i = 0; i < fractiles.length; ++i) {
            double fractile = fractiles[i];
            AbstractXY_DataSet fractFunc = fractCalc.getFractile(fractile);
            fractileFuncs.add(fractFunc);
            if (fractFunc instanceof IncrementalMagFreqDist) {
                IncrementalMagFreqDist mfd = (IncrementalMagFreqDist)fractFunc;
                EvenlyDiscretizedFunc newFractFunc = new EvenlyDiscretizedFunc(mfd.getMinX(), mfd.getMaxX(), mfd.size());
                for (int j = 0; j < mfd.size(); ++j) {
                    newFractFunc.set(j, mfd.getY(j));
                }
                fractFunc = newFractFunc;
            }
            if (i == 0) {
                fractFunc.setName(Joiner.on((String)",").join((Iterable)fractileNames) + " Fractiles");
            } else {
                fractFunc.setName(null);
            }
            funcs.add(fractFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, fractileColor));
        }
        AbstractXY_DataSet median = fractCalc.getFractile(0.5);
        median.setName("Median");
        if (medianColor != null) {
            funcs.add(median);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, medianColor));
        }
        int numX = allFuncs[0].size();
        AbstractXY_DataSet meanFunc = fractCalc.getMeanCurve();
        EvenlyDiscretizedFunc modeFunc = null;
        if (modeColor != null) {
            modeFunc = ETAS_MultiSimAnalysisTools.getCatalogMode(allFuncs, fractCalc);
            modeFunc.setName("Mode");
            funcs.add(modeFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, modeColor));
        }
        double[] stdDevs = new double[numX];
        double[] sdoms = new double[numX];
        EvenlyDiscretizedFunc lower95_mean = new EvenlyDiscretizedFunc(allFuncs[0].getMinX(), numX, allFuncs[0].getDelta());
        lower95_mean.setName("Lower/Upper 95% of Mean");
        EvenlyDiscretizedFunc upper95_mean = new EvenlyDiscretizedFunc(allFuncs[0].getMinX(), numX, allFuncs[0].getDelta());
        upper95_mean.setName(null);
        for (int n = 0; n < numX; ++n) {
            void var23_29;
            double[] vals = new double[allFuncs.length];
            boolean bl = false;
            while (var23_29 < allFuncs.length) {
                vals[var23_29] = allFuncs[var23_29].getY(n);
                ++var23_29;
            }
            stdDevs[n] = Math.sqrt(StatUtils.variance((double[])vals));
            sdoms[n] = stdDevs[n] / Math.sqrt(allFuncs.length);
            double d = meanFunc.getY(n);
            lower95_mean.set(n, d - 1.98 * sdoms[n]);
            upper95_mean.set(n, d + 1.98 * sdoms[n]);
        }
        if (sdomColor != null) {
            funcs.add(lower95_mean);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, sdomColor));
            funcs.add(upper95_mean);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, sdomColor));
        }
        meanFunc.setName("Mean");
        funcs.add(meanFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        if (csvFile != null) {
            void var23_33;
            CSVFile csv = new CSVFile(true);
            ArrayList header = Lists.newArrayList((Object[])new String[]{"Mag", "Mean", "Std Dev", "SDOM"});
            for (double fract : fractiles) {
                header.add("p" + (float)(fract * 100.0) + "%");
            }
            header.add("Median");
            if (modeFunc != null) {
                header.add("Mode");
            }
            header.add("Lower 95% of Mean");
            header.add("Upper 95% of Mean");
            for (EvenlyDiscretizedFunc otherFunc : otherCSVFuncs) {
                Preconditions.checkState((otherFunc.size() == meanFunc.size() ? 1 : 0) != 0, (Object)"Other func name mismatch");
                Preconditions.checkNotNull((Object)otherFunc.getName(), (Object)"Other func must be named for CSV header");
                header.add(otherFunc.getName());
            }
            csv.addLine(header);
            boolean bl = false;
            while (var23_33 < meanFunc.size()) {
                ArrayList line = Lists.newArrayList((Object[])new String[]{"" + meanFunc.getX((int)var23_33), "" + meanFunc.getY((int)var23_33), "" + stdDevs[var23_33], "" + sdoms[var23_33]});
                for (AbstractXY_DataSet fractFunc : fractileFuncs) {
                    line.add("" + fractFunc.getY((int)var23_33));
                }
                line.add("" + median.getY((int)var23_33));
                if (modeFunc != null) {
                    line.add("" + modeFunc.getY((int)var23_33));
                }
                line.add("" + lower95_mean.getY((int)var23_33));
                line.add("" + upper95_mean.getY((int)var23_33));
                for (EvenlyDiscretizedFunc otherFunc : otherCSVFuncs) {
                    line.add("" + otherFunc.getY((int)var23_33));
                }
                csv.addLine(line);
                ++var23_33;
            }
            csv.writeToFile(csvFile);
        }
        return meanFunc;
    }

    public static void plotAftershockRateVsLogTimeHistForRup(List<List<ETAS_EqkRupture>> catalogs, ETAS_Simulator.TestScenario scenario, ETAS_ParameterList params, long rupOT_millis, File outputDir, String name, String prefix) throws IOException {
        EvenlyDiscretizedFunc[] funcsArray = new EvenlyDiscretizedFunc[catalogs.size()];
        double firstLogDay = -5.0;
        double lastLogDay = 5.0;
        double deltaLogDay = 0.2;
        for (int i = 0; i < catalogs.size(); ++i) {
            List<ETAS_EqkRupture> catalog = catalogs.get(i);
            funcsArray[i] = ETAS_SimAnalysisTools.getAftershockRateVsLogTimeHistForRup(catalog, 0, rupOT_millis, firstLogDay, lastLogDay, deltaLogDay);
        }
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        double[] fractiles = new double[]{0.025, 0.25, 0.75, 0.975};
        ETAS_MultiSimAnalysisTools.getFractilePlotFuncs(funcsArray, fractiles, false, funcs, chars, null);
        if (params != null && scenario != null) {
            HistogramFunction targetFunc = ETAS_Utils.getRateWithLogTimeFunc(params.get_k(), params.get_p(), scenario.getMagnitude(), 2.5, params.get_c(), firstLogDay, lastLogDay, deltaLogDay);
            targetFunc.setName("Expected");
            funcs.add(targetFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        }
        double maxY = 0.0;
        for (XY_DataSet xy : funcs) {
            maxY = Math.max(maxY, xy.getMaxY());
        }
        PlotSpec spec = new PlotSpec(funcs, chars, name + " Temporal Decay", "Log10 Time (Days)", "Rate (per day)");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setUserBounds(-4.0, 3.0, 0.001, maxY * 1.2);
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, true);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    public static void plotDistDecay(List<List<ETAS_EqkRupture>> catalogs, ETAS_ParameterList params, RuptureSurface surf, File outputDir, String name, String prefix) throws IOException {
        EvenlyDiscretizedFunc[] funcsArray = new EvenlyDiscretizedFunc[catalogs.size()];
        double histLogMin = -1.5;
        double histLogMax = 4.0;
        double histLogDelta = 0.2;
        for (int i = 0; i < catalogs.size(); ++i) {
            List<ETAS_EqkRupture> catalog = catalogs.get(i);
            funcsArray[i] = surf == null ? ETAS_SimAnalysisTools.getLogTriggerDistDecayDensityHist(catalog, histLogMin, histLogMax, histLogDelta) : ETAS_SimAnalysisTools.getLogDistDecayDensityFromRupSurfaceHist(catalog, surf, histLogMin, histLogMax, histLogDelta);
        }
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        double[] fractiles = new double[]{0.025, 0.25, 0.75, 0.975};
        ETAS_MultiSimAnalysisTools.getFractilePlotFuncs(funcsArray, fractiles, false, funcs, chars, null);
        if (params != null) {
            double distDecay = params.get_q();
            double minDist = params.get_d();
            EvenlyDiscretizedFunc expectedLogDistDecay = ETAS_Utils.getTargetDistDecayDensityFunc(funcsArray[0].getMinX(), funcsArray[0].getMaxX(), funcsArray[0].size(), distDecay, minDist);
            expectedLogDistDecay.setName("Expected");
            expectedLogDistDecay.setInfo("(distDecay=" + distDecay + " and minDist=" + minDist + ")");
            funcs.add(expectedLogDistDecay);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        }
        double maxY = 0.0;
        double minY = Double.POSITIVE_INFINITY;
        for (XY_DataSet xy : funcs) {
            maxY = Math.max(maxY, xy.getMaxY());
            double minNonZero = Double.POSITIVE_INFINITY;
            for (Point2D pt : xy) {
                if (!(pt.getY() > 0.0) || !(pt.getY() < minNonZero)) continue;
                minNonZero = pt.getY();
            }
            if (Double.isInfinite(minNonZero)) continue;
            minY = Math.min(minY, minNonZero);
        }
        String title = surf == null ? name + " Trigger Loc Dist Decay" : name + " Rupture Surface Dist Decay";
        PlotSpec spec = new PlotSpec(funcs, chars, title, "Log10 Distance (km)", "Aftershock Density (per km)");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        gp.setUserBounds(histLogMin + 0.5 * histLogDelta, 3.0, minY, maxY * 1.2);
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, true);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    private static void plotNumEventsHistogram(List<List<ETAS_EqkRupture>> catalogs, File outputDir, String prefix) throws IOException {
        DataUtils.MinMaxAveTracker track = new DataUtils.MinMaxAveTracker();
        for (List<ETAS_EqkRupture> list : catalogs) {
            track.addValue(list.size());
        }
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(track.getMin(), track.getMax(), 5000.0);
        for (List<ETAS_EqkRupture> list : catalogs) {
            hist.add((double)list.size(), 1.0);
        }
        ArrayList arrayList = Lists.newArrayList();
        ArrayList arrayList2 = Lists.newArrayList();
        arrayList.add(hist);
        arrayList2.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(arrayList, arrayList2, "# Events Distribution", "# Events", "# Catalogs");
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, false);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    private static void plotTotalMomentHistogram(List<List<ETAS_EqkRupture>> catalogs, File outputDir, String prefix) throws IOException {
        double[] moments = new double[catalogs.size()];
        for (int i = 0; i < catalogs.size(); ++i) {
            for (ETAS_EqkRupture eTAS_EqkRupture : catalogs.get(i)) {
                int n = i;
                moments[n] = moments[n] + MagUtils.magToMoment(eTAS_EqkRupture.getMag());
            }
        }
        double[] log10Moments = new double[moments.length];
        for (int i = 0; i < moments.length; ++i) {
            log10Moments[i] = Math.log10(moments[i]);
        }
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(StatUtils.min((double[])log10Moments), StatUtils.max((double[])log10Moments), 0.05);
        for (double val : log10Moments) {
            hist.add(val, 1.0);
        }
        ArrayList arrayList = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        arrayList.add(hist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(arrayList, chars, "Moment Distribution", "Log10(Total Moment) (N-m)", "# Catalogs");
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, false);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    public static void plotSectRates(List<List<ETAS_EqkRupture>> catalogs, double duration, FaultSystemRupSet rupSet, double[] minMags, File outputDir, String titleAdd, String prefix) throws IOException, GMT_MapException, RuntimeException {
        ETAS_MultiSimAnalysisTools.plotSectRates(catalogs, duration, rupSet, minMags, outputDir, titleAdd, prefix, Long.MIN_VALUE, null, false, null, null);
    }

    /*
     * WARNING - void declaration
     */
    public static void plotSectRates(List<? extends List<ETAS_EqkRupture>> catalogs, double duration, FaultSystemRupSet rupSet, double[] minMags, File outputDir, String titleAdd, String prefix, long maxOT, FaultSystemSolution refSol, boolean addRefForRatio, CPT cpt, CPT logGainCPT) throws IOException, GMT_MapException, RuntimeException {
        ArrayList particRatesList = Lists.newArrayList();
        for (int i = 0; i < minMags.length; ++i) {
            particRatesList.add(new double[rupSet.getNumSections()]);
        }
        ArrayList triggerRatesList = Lists.newArrayList();
        for (int i = 0; i < minMags.length; ++i) {
            triggerRatesList.add(new double[rupSet.getNumSections()]);
        }
        ArrayList parentParticRatesList = Lists.newArrayList();
        List<? extends FaultSection> sects = rupSet.getFaultSectionDataList();
        for (int i = 0; i < minMags.length; ++i) {
            HashMap<Integer, Double> parentMap = new HashMap<Integer, Double>();
            for (FaultSection faultSection : sects) {
                if (parentMap.containsKey(faultSection.getParentSectionId())) continue;
                parentMap.put(faultSection.getParentSectionId(), 0.0);
            }
            parentParticRatesList.add(parentMap);
        }
        HashMap locsForSectsMap = Maps.newHashMap();
        HashSet debugSections = null;
        double maxDuration = 0.0;
        FaultPolyMgr faultPolyMgr = FaultPolyMgr.create(rupSet.getFaultSectionDataList(), 12.0);
        block4: for (List<ETAS_EqkRupture> list : catalogs) {
            double fractionalRate;
            if (maxOT > 0L) {
                fractionalRate = 1.0 / (double)catalogs.size();
            } else {
                double myDuration = duration < 0.0 ? ETAS_MultiSimAnalysisTools.calcDurationYears(list) : duration;
                if (myDuration == 0.0) continue;
                maxDuration = Math.max(maxDuration, myDuration);
                fractionalRate = 1.0 / ((double)catalogs.size() * myDuration);
            }
            for (ETAS_EqkRupture eTAS_EqkRupture : list) {
                int i;
                int rupIndex = eTAS_EqkRupture.getFSSIndex();
                if (rupIndex < 0) continue;
                if (maxOT > 0L && eTAS_EqkRupture.getOriginTime() > maxOT) continue block4;
                int closestSectIndex = -1;
                boolean notYetFound = true;
                Location hypocenter = eTAS_EqkRupture.getHypocenterLocation();
                Preconditions.checkNotNull((Object)hypocenter);
                HashSet<Integer> hashSet = new HashSet<Integer>();
                for (int sectIndex : rupSet.getSectionsIndicesForRup(rupIndex)) {
                    for (i = 0; i < minMags.length; ++i) {
                        if (!(eTAS_EqkRupture.getMag() >= minMags[i])) continue;
                        double[] dArray = (double[])particRatesList.get(i);
                        int n = sectIndex;
                        dArray[n] = dArray[n] + fractionalRate;
                        hashSet.add(sects.get(sectIndex).getParentSectionId());
                    }
                    if (!notYetFound || !faultPolyMgr.getPoly(sectIndex).contains(hypocenter)) continue;
                    closestSectIndex = sectIndex;
                    notYetFound = false;
                }
                for (Integer parentID : hashSet) {
                    for (i = 0; i < minMags.length; ++i) {
                        if (!(eTAS_EqkRupture.getMag() >= minMags[i])) continue;
                        Map parentParticRates = (Map)parentParticRatesList.get(i);
                        Double parentRate = (Double)parentParticRates.get(parentID);
                        parentRate = parentRate + fractionalRate;
                        parentParticRates.put(parentID, parentRate);
                    }
                }
                if (closestSectIndex < 0) {
                    double closestDist = Double.POSITIVE_INFINITY;
                    for (int sectIndex : rupSet.getSectionsIndicesForRup(rupIndex)) {
                        List surfLocs = (List)locsForSectsMap.get(sectIndex);
                        if (surfLocs == null) {
                            FaultSection sect = rupSet.getFaultSectionData(sectIndex);
                            surfLocs = sect.getFaultSurface(1.0, false, true).getEvenlyDiscritizedPerimeter();
                            locsForSectsMap.put(sectIndex, surfLocs);
                        }
                        for (Location loc : surfLocs) {
                            double dist = LocationUtils.linearDistanceFast(hypocenter, loc);
                            if (!(dist < closestDist)) continue;
                            closestDist = dist;
                            closestSectIndex = sectIndex;
                        }
                    }
                    Preconditions.checkState((closestDist < 0.1 ? 1 : 0) != 0, (String)"reverted to distance due to polygon issue but too far from perimeter: %s km", (Object)closestDist);
                }
                Preconditions.checkState((closestSectIndex >= 0 ? 1 : 0) != 0, (String)"fssIndex=%s, hypo=%s", (int)eTAS_EqkRupture.getFSSIndex(), (Object)hypocenter);
                for (int i2 = 0; i2 < minMags.length; ++i2) {
                    if (!(eTAS_EqkRupture.getMag() >= minMags[i2])) continue;
                    double[] dArray = (double[])triggerRatesList.get(i2);
                    int n = closestSectIndex;
                    dArray[n] = dArray[n] + fractionalRate;
                }
                if (debugSections == null || !debugSections.contains(closestSectIndex)) continue;
                System.out.println("Ruptured " + closestSectIndex + ":\t" + ETAS_CatalogIO.getEventFileLine(eTAS_EqkRupture));
            }
        }
        ArrayList<double[]> refParticRatesList = null;
        Object var24_27 = null;
        if (refSol != null) {
            Preconditions.checkState((refSol.getRupSet().getNumSections() == rupSet.getNumSections() ? 1 : 0) != 0);
            refParticRatesList = new ArrayList<double[]>();
            ArrayList arrayList = Lists.newArrayList();
            for (int i = 0; i < minMags.length; ++i) {
                refParticRatesList.add(new double[rupSet.getNumSections()]);
                HashMap<Integer, Double> parentMap = new HashMap<Integer, Double>();
                for (FaultSection faultSection : sects) {
                    if (parentMap.containsKey(faultSection.getParentSectionId())) continue;
                    parentMap.put(faultSection.getParentSectionId(), 0.0);
                }
                arrayList.add(parentMap);
            }
            if (maxOT > 0L) {
                Preconditions.checkState((duration >= 0.0 ? 1 : 0) != 0);
            }
            FaultSystemRupSet refRupSet = refSol.getRupSet();
            for (int r = 0; r < refRupSet.getNumRuptures(); ++r) {
                double rate = refSol.getRateForRup(r);
                if (maxOT > 0L) {
                    rate *= duration;
                }
                double mag = refRupSet.getMagForRup(r);
                List<Integer> parentIDs = refRupSet.getParentSectionsForRup(r);
                for (int i = 0; i < minMags.length; ++i) {
                    if (!(mag >= minMags[i])) continue;
                    for (FaultSection sect : refRupSet.getFaultSectionDataForRupture(r)) {
                        int sectIndex = sect.getSectionId();
                        double[] dArray = (double[])refParticRatesList.get(i);
                        int n = sectIndex;
                        dArray[n] = dArray[n] + rate;
                    }
                    for (Integer parentID : parentIDs) {
                        Map refParentParticRates = (Map)arrayList.get(i);
                        Double parentRate = (Double)refParentParticRates.get(parentID);
                        parentRate = parentRate + rate;
                        refParentParticRates.put(parentID, parentRate);
                    }
                }
            }
        }
        if (cpt == null) {
            double cptMax;
            double fractionalRate;
            cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            double maxRate = 0.0;
            for (double[] dArray : particRatesList) {
                maxRate = Math.max(maxRate, StatUtils.max((double[])dArray));
            }
            if (maxOT > 0L) {
                fractionalRate = 1.0 / (double)catalogs.size();
            } else {
                if (maxDuration == 0.0) {
                    return;
                }
                fractionalRate = 1.0 / Math.max(1.0, (double)Math.round((double)catalogs.size() * maxDuration));
            }
            double cptMin = Math.log10(fractionalRate);
            if (!Doubles.isFinite((double)cptMin) || !Doubles.isFinite((double)cptMax)) {
                return;
            }
            for (cptMax = Math.ceil(Math.log10(maxRate)); cptMax <= cptMin; cptMax += 1.0) {
            }
            cpt = cpt.rescale(cptMin, cptMax);
            cpt.setBelowMinColor(Color.LIGHT_GRAY);
        }
        if (refSol != null && logGainCPT == null) {
            logGainCPT = GMT_CPT_Files.UCERF3_ETAS_GAIN.instance().rescale(0.0, 1.0);
            int i = logGainCPT.size();
            while (--i >= 0) {
                if (!(((CPTVal)logGainCPT.get((int)i)).start <= 0.5)) continue;
                logGainCPT.remove(i);
            }
            logGainCPT = logGainCPT.rescale(0.0, 4.0);
            logGainCPT.setBelowMinColor(logGainCPT.getMinColor());
            logGainCPT.setNanColor(Color.LIGHT_GRAY);
        }
        ArrayList faults = Lists.newArrayList();
        for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
            faults.add(rupSet.getFaultSectionData(sectIndex).getFaultTrace());
        }
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        CSVFile<CallSite> particCSV = new CSVFile<CallSite>(true);
        CSVFile<CallSite> cSVFile = new CSVFile<CallSite>(true);
        ArrayList particHeader = Lists.newArrayList((Object[])new String[]{"Section Name", "Section ID"});
        ArrayList triggerHeader = Lists.newArrayList((Object[])new String[]{"Section Name", "Section ID"});
        for (int i = 0; i < minMags.length; ++i) {
            Object header = minMags[i] > 1.0 ? "M\u2265" + (float)minMags[i] : "Total";
            particHeader.add(header);
            triggerHeader.add(header);
            if (refSol == null) continue;
            particHeader.add("Gain");
        }
        particCSV.addLine(particHeader);
        cSVFile.addLine(triggerHeader);
        HashMap<String, Integer> parentNamesToIDs = new HashMap<String, Integer>();
        for (FaultSection faultSection : sects) {
            parentNamesToIDs.put(faultSection.getParentSectionName(), faultSection.getParentSectionId());
        }
        ArrayList parentNames = new ArrayList();
        parentNames.addAll(parentNamesToIDs.keySet());
        Collections.sort(parentNames);
        ArrayList arrayList = Lists.newArrayList((Object[])new String[]{"Parent Section Name"});
        for (int i = 0; i < minMags.length; ++i) {
            if (minMags[i] > 1.0) {
                arrayList.add("M\u2265" + (float)minMags[i]);
            } else {
                arrayList.add("Total");
            }
            if (refSol == null) continue;
            arrayList.add("Gain");
        }
        CSVFile<CallSite> parentCSV = new CSVFile<CallSite>(true);
        parentCSV.addLine(arrayList);
        if (titleAdd == null) {
            titleAdd = "";
        }
        if (!((String)titleAdd).isEmpty() && !((String)titleAdd).startsWith(" ")) {
            titleAdd = " " + (String)titleAdd;
        }
        for (int i = 0; i < minMags.length; ++i) {
            String triggerTitle;
            String particTitle;
            Object prefixAdd;
            Object magStr;
            double[] particRates = (double[])particRatesList.get(i);
            double[] triggerRates = (double[])triggerRatesList.get(i);
            if (minMags[i] > 1.0) {
                magStr = " M>=" + (float)minMags[i];
                prefixAdd = "_m" + (float)minMags[i];
            } else {
                magStr = "";
                prefixAdd = "";
            }
            if (maxOT > 0L) {
                particTitle = "Log10" + (String)magStr + " Participation Exp. Num" + (String)titleAdd;
                triggerTitle = "Log10" + (String)magStr + " Trigger Exp. Num" + (String)titleAdd;
            } else {
                particTitle = "Log10" + (String)magStr + " Participation Rate" + (String)titleAdd;
                triggerTitle = "Log10" + (String)magStr + " Trigger Rate" + (String)titleAdd;
            }
            FaultBasedMapGen.makeFaultPlot(cpt, faults, FaultBasedMapGen.log10(particRates), region, outputDir, prefix + "_partic" + (String)prefixAdd, false, false, particTitle);
            FaultBasedMapGen.makeFaultPlot(cpt, faults, FaultBasedMapGen.log10(triggerRates), region, outputDir, prefix + "_trigger" + (String)prefixAdd, false, false, triggerTitle);
            if (refSol != null) {
                double[] ratios = new double[particRates.length];
                double[] refParticRates = (double[])refParticRatesList.get(i);
                for (int j = 0; j < ratios.length; ++j) {
                    ratios[j] = addRefForRatio ? (particRates[j] + refParticRates[j]) / refParticRates[j] : particRates[j] / refParticRates[j];
                    if (ratios[j] != 0.0 && Double.isFinite(ratios[j])) continue;
                    ratios[j] = Double.NaN;
                }
                FaultBasedMapGen.makeFaultPlot(logGainCPT, faults, FaultBasedMapGen.log10(ratios), region, outputDir, prefix + "_partic_gain" + (String)prefixAdd, false, false, particTitle + " Gain");
            }
            for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
                int row = sectIndex + 1;
                if (i == 0) {
                    ArrayList particLine = Lists.newArrayList((Object[])new String[]{rupSet.getFaultSectionData(sectIndex).getSectionName(), "" + sectIndex});
                    ArrayList triggerLine = Lists.newArrayList((Iterable)particLine);
                    for (int m = 0; m < minMags.length; ++m) {
                        particLine.add("");
                        triggerLine.add("");
                        if (refSol == null) continue;
                        particLine.add("");
                    }
                    particCSV.addLine(particLine);
                    cSVFile.addLine(Lists.newArrayList((Iterable)triggerLine));
                }
                int triggerCol = i + 2;
                int particCol = refSol != null ? i * 2 + 2 : triggerCol;
                particCSV.set(row, particCol, (CallSite)((Object)("" + particRates[sectIndex])));
                if (refSol != null) {
                    double refVal = ((double[])refParticRatesList.get(i))[sectIndex];
                    double gain = addRefForRatio ? (particRates[sectIndex] + refVal) / refVal : particRates[sectIndex] / refVal;
                    particCSV.set(row, particCol + 1, (CallSite)((Object)("" + gain)));
                }
                cSVFile.set(row, triggerCol, (CallSite)((Object)("" + triggerRates[sectIndex])));
            }
            for (int j = 0; j < parentNames.size(); ++j) {
                void var24_29;
                String parentName = (String)parentNames.get(j);
                Integer parentID = (Integer)parentNamesToIDs.get(parentName);
                int row = j + 1;
                if (i == 0) {
                    ArrayList line = Lists.newArrayList((Object[])new String[]{parentName});
                    for (int m = 0; m < minMags.length; ++m) {
                        line.add("");
                        if (refSol == null) continue;
                        line.add("");
                    }
                    parentCSV.addLine(line);
                }
                int col = refSol == null ? i + 1 : i * 2 + 1;
                double parentVal = (Double)((Map)parentParticRatesList.get(i)).get(parentID);
                parentCSV.set(row, col, (CallSite)((Object)("" + parentVal)));
                if (refSol == null) continue;
                double refVal = (Double)((Map)var24_29.get(i)).get(parentID);
                double gain = addRefForRatio ? (parentVal + refVal) / refVal : parentVal / refVal;
                parentCSV.set(row, col + 1, (CallSite)((Object)("" + gain)));
            }
        }
        particCSV.writeToFile(new File(outputDir, prefix + "_partic.csv"));
        parentCSV.writeToFile(new File(outputDir, prefix + "_parent_partic.csv"));
        cSVFile.writeToFile(new File(outputDir, prefix + "_trigger.csv"));
    }

    private static void plotMaxTriggeredMagHist(List<List<ETAS_EqkRupture>> catalogs, List<List<ETAS_EqkRupture>> primaryCatalogs, ETAS_Simulator.TestScenario scenario, File outputDir, String name, String prefix) throws IOException {
        HistogramFunction fullHist = HistogramFunction.getEncompassingHistogram(2.5, 9.0, 0.1);
        HistogramFunction primaryHist = null;
        if (primaryCatalogs != null) {
            primaryHist = new HistogramFunction(fullHist.getMinX(), fullHist.size(), fullHist.getDelta());
        }
        int numEmpty = 0;
        ArrayList maxMags = Lists.newArrayList();
        for (int i = 0; i < catalogs.size(); ++i) {
            if (catalogs.get(i).isEmpty()) {
                ++numEmpty;
                continue;
            }
            maxMags.add(ETAS_SimAnalysisTools.getMaxMag(catalogs.get(i)));
        }
        ETAS_MultiSimAnalysisTools.populateHistWithInfo(fullHist, Doubles.toArray((Collection)maxMags));
        int numPrimaryEmpty = 0;
        if (primaryCatalogs != null) {
            maxMags = Lists.newArrayList();
            for (int i = 0; i < primaryCatalogs.size(); ++i) {
                if (primaryCatalogs.get(i).isEmpty()) {
                    ++numPrimaryEmpty;
                    continue;
                }
                maxMags.add(ETAS_SimAnalysisTools.getMaxMag(primaryCatalogs.get(i)));
            }
            ETAS_MultiSimAnalysisTools.populateHistWithInfo(primaryHist, Doubles.toArray((Collection)maxMags));
        }
        double maxY = fullHist.getMaxY() * 1.1;
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(fullHist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        fullHist.setName("All Children");
        if (primaryHist != null) {
            funcs.add(primaryHist);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.CYAN));
            primaryHist.setName("Primary Aftershocks");
        }
        if (scenario != null) {
            DefaultXY_DataSet scenarioMag = new DefaultXY_DataSet();
            scenarioMag.set(scenario.getMagnitude(), 0.0);
            scenarioMag.set(scenario.getMagnitude(), fullHist.getMaxY());
            scenarioMag.set(scenario.getMagnitude(), maxY);
            scenarioMag.setName("Scenario M=" + (float)scenario.getMagnitude());
            funcs.add(scenarioMag);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.GRAY));
        }
        PlotSpec spec = new PlotSpec(funcs, chars, name + " Max Mag Hist", "Magnitude", "Num Simulations");
        spec.setLegendVisible(true);
        double histDelta = fullHist.getDelta();
        double minX = fullHist.getMinX() - 0.5 * histDelta;
        double maxX = fullHist.getMaxX() - 0.5 * histDelta;
        if (numEmpty > 0 || numPrimaryEmpty > 0) {
            Object primaryStr = "";
            if (numPrimaryEmpty > 0) {
                primaryStr = numPrimaryEmpty + "/" + primaryCatalogs.size() + " primary";
                if (numEmpty > 0) {
                    primaryStr = " (" + (String)primaryStr + ")";
                }
            }
            Object text = numEmpty > 0 ? numEmpty + "/" + catalogs.size() + (String)primaryStr : primaryStr;
            text = (String)text + " catalogs empty and excluded";
            XYTextAnnotation ann = new XYTextAnnotation((String)text, minX + (maxX - minX) * 0.05, maxY * 0.95);
            ann.setFont(new Font("SansSerif", 1, 18));
            ann.setTextAnchor(TextAnchor.TOP_LEFT);
            ArrayList anns = Lists.newArrayList((Object[])new XYTextAnnotation[]{ann});
            spec.setPlotAnnotations(anns);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, false);
        gp.drawGraphPanel(spec, false, false, new Range(minX, maxX), new Range(0.0, maxY));
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    private static void plotNumEventsPerGeneration(List<List<ETAS_EqkRupture>> catalogs, File outputDir, String name, String prefix) throws IOException {
        int maxGeneration = 20;
        EvenlyDiscretizedFunc[] allFuncs = new EvenlyDiscretizedFunc[catalogs.size()];
        boolean hasZero = false;
        for (int i = 0; i < catalogs.size(); ++i) {
            List<ETAS_EqkRupture> catalog = catalogs.get(i);
            int[] counts = ETAS_SimAnalysisTools.getNumAftershocksForEachGeneration(catalog, maxGeneration);
            allFuncs[i] = new EvenlyDiscretizedFunc(0.0, (double)maxGeneration, counts.length);
            for (int j = 0; j < counts.length; ++j) {
                allFuncs[i].set(j, (double)counts[j]);
            }
            hasZero = hasZero || counts[0] > 0;
        }
        double[] fractiles = new double[]{0.025, 0.975};
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        ETAS_MultiSimAnalysisTools.getFractilePlotFuncs(allFuncs, fractiles, true, funcs, chars, null);
        double maxY = 0.0;
        for (XY_DataSet func : funcs) {
            maxY = Math.max(maxY, func.getMaxY());
        }
        PlotSpec spec = new PlotSpec(funcs, chars, name + " Generations", "Generation", "Count");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        double minX = hasZero ? 0.0 : 1.0;
        gp.setUserBounds(minX, maxGeneration, 0.0, maxY * 1.1);
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, false);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    private static void populateHistWithInfo(HistogramFunction hist, double[] data) {
        if (data.length == 0) {
            return;
        }
        for (double val : data) {
            hist.add(val, 1.0);
        }
        double mean = StatUtils.mean((double[])data);
        double median = DataUtils.median(data);
        double mode = hist.getX(hist.getXindexForMaxY());
        String infoStr = "Mean: " + (float)mean + "\nMedian: " + (float)median + "\nMode: " + (float)mode;
        hist.setInfo(infoStr);
    }

    public static void plotCubeNucleationRates(List<? extends List<ETAS_EqkRupture>> catalogs, double duration, File outputDir, String name, String prefix, double[] mags) throws IOException, GMT_MapException {
        ETAS_MultiSimAnalysisTools.plotCubeNucleationRates(catalogs, catalogs.size(), duration, Long.MAX_VALUE, outputDir, name, prefix, mags, false);
    }

    public static void plotCubeNucleationRates(Iterable<? extends List<ETAS_EqkRupture>> catalogs, int numCatalogs, double duration, long maxOT, File outputDir, String name, String prefix, double[] mags, boolean downloadZip) throws IOException, GMT_MapException {
        double discr = 0.02;
        GriddedRegion reg = new GriddedRegion(new CaliforniaRegions.RELM_TESTING(), discr, GriddedRegion.ANCHOR_0_0);
        GriddedGeoDataSet[] xyzs = new GriddedGeoDataSet[mags.length];
        for (int i = 0; i < xyzs.length; ++i) {
            xyzs[i] = new GriddedGeoDataSet(reg, false);
        }
        int count = 0;
        int numSkipped = 0;
        double maxDuration = 0.0;
        block1: for (List<ETAS_EqkRupture> list : catalogs) {
            if (numCatalogs > 20000 && count % 5000 == 0) {
                System.out.println("Gridded nucl, processing catalog " + count + "/" + numCatalogs);
            }
            ++count;
            double myDuration = duration < 0.0 ? ETAS_MultiSimAnalysisTools.calcDurationYears(list) : duration;
            if (myDuration == 0.0) continue;
            maxDuration = Math.max(myDuration, maxDuration);
            double rateEach = 1.0 / ((double)numCatalogs * myDuration);
            for (ETAS_EqkRupture rup : list) {
                if (maxOT > 0L && rup.getOriginTime() > maxOT) continue block1;
                double mag = rup.getMag();
                Location loc = rup.getHypocenterLocation();
                int index = reg.indexForLocation(loc);
                if (index < 0) {
                    ++numSkipped;
                    continue;
                }
                for (int i = 0; i < mags.length; ++i) {
                    if (!(mag >= mags[i])) continue;
                    xyzs[i].set(index, xyzs[i].get(index) + rateEach);
                }
            }
        }
        Preconditions.checkState((count == numCatalogs ? 1 : 0) != 0);
        System.out.println("Skipped " + numSkipped + " events outside of region");
        double scalar = 1.0 / ((double)numCatalogs * Math.max(1.0, (double)Math.round(maxDuration)));
        for (GriddedGeoDataSet xyz : xyzs) {
            xyz.log10();
        }
        CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
        Region plotReg = new Region(new Location(reg.getMinGridLat(), reg.getMinGridLon()), new Location(reg.getMaxGridLat(), reg.getMaxGridLon()));
        for (int i = 0; i < mags.length; ++i) {
            GriddedGeoDataSet xyz;
            xyz = xyzs[i];
            double minZ = Math.floor(Math.log10(scalar));
            double maxZ = Math.ceil(xyz.getMaxZ());
            if (xyz.getMaxZ() == Double.NEGATIVE_INFINITY) {
                maxZ = minZ + 4.0;
            }
            if (maxZ == minZ) {
                maxZ += 1.0;
            }
            Preconditions.checkState((minZ < maxZ ? 1 : 0) != 0, (String)"minZ=%s >= maxZ=%s", (Object)minZ, (Object)maxZ);
            double mag = mags[i];
            String label = "Log10 M>=" + (float)mag;
            label = duration == 1.0 ? label + " Expected Num" : label + " Nucleation Rate";
            String myPrefix = prefix + "_m" + (float)mag;
            String baseURL = FaultBasedMapGen.plotMap(outputDir, myPrefix, false, FaultBasedMapGen.buildMap(cpt.rescale(minZ, maxZ), null, null, xyzs[i], discr, plotReg, false, label));
            if (!downloadZip) continue;
            FileUtils.downloadURL(baseURL + "/allFiles.zip", new File(outputDir, myPrefix + ".zip"));
        }
    }

    private static List<List<ETAS_EqkRupture>> getOnlyAftershocksFromHistorical(List<List<ETAS_EqkRupture>> catalogs) {
        ArrayList ret = Lists.newArrayList();
        long countHist = 0L;
        long countAll = 0L;
        for (List<ETAS_EqkRupture> catalog : catalogs) {
            int minIndex = Integer.MAX_VALUE;
            for (ETAS_EqkRupture rup : catalog) {
                if (rup.getID() >= minIndex) continue;
                minIndex = rup.getID();
            }
            ArrayList hist = Lists.newArrayList();
            for (ETAS_EqkRupture rup : catalog) {
                if (rup.getParentID() < 0 || rup.getParentID() >= minIndex) continue;
                hist.add(rup);
            }
            ret.add(hist);
            countHist += (long)hist.size();
            countAll += (long)catalog.size();
        }
        double percent = 100.0 * ((double)countHist / (double)countAll);
        System.out.println(countHist + "/" + countAll + " (" + (float)percent + " %) are historical aftershocks");
        return ret;
    }

    private static List<List<ETAS_EqkRupture>> getAllDescendentsFromHistorical(List<List<ETAS_EqkRupture>> catalogs) {
        ArrayList ret = Lists.newArrayList();
        long countHist = 0L;
        long countAll = 0L;
        for (List<ETAS_EqkRupture> catalog : catalogs) {
            HashMap<Integer, ETAS_EqkRupture> map = new HashMap<Integer, ETAS_EqkRupture>();
            int minIndex = Integer.MAX_VALUE;
            for (ETAS_EqkRupture rup : catalog) {
                map.put(rup.getID(), rup);
                if (rup.getID() >= minIndex) continue;
                minIndex = rup.getID();
            }
            ArrayList hist = Lists.newArrayList();
            for (ETAS_EqkRupture rup : catalog) {
                int parID = rup.getParentID();
                int currentID = rup.getID();
                while (parID != -1 && (currentID = parID) >= minIndex) {
                    parID = ((ETAS_EqkRupture)map.get(currentID)).getParentID();
                }
                if (currentID >= minIndex) continue;
                hist.add(rup);
            }
            ret.add(hist);
            countHist += (long)hist.size();
            countAll += (long)catalog.size();
        }
        double percent = 100.0 * ((double)countHist / (double)countAll);
        System.out.println(countHist + "/" + countAll + " (" + (float)percent + " %) are historical aftershocks");
        return ret;
    }

    private static void writeTimeFromPrevSupraHist(List<? extends List<ETAS_EqkRupture>> catalogs, File outputDir) throws IOException {
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(0.0, 20.0, 1.0);
        ArrayList allVals = Lists.newArrayList();
        for (List<ETAS_EqkRupture> list : catalogs) {
            if (list.size() < 2) continue;
            long startTime = list.get(0).getOriginTime();
            long endTime = list.get(list.size() - 1).getOriginTime();
            long durationMillis = endTime - startTime;
            Preconditions.checkState((durationMillis > 0L ? 1 : 0) != 0);
            int num = 10000;
            long delta = durationMillis / (long)num;
            Preconditions.checkState((delta > 0L ? 1 : 0) != 0);
            int catIndexBeforeTime = 0;
            long prevSupra = Long.MIN_VALUE;
            for (long time = startTime; time < endTime; time += delta) {
                ETAS_EqkRupture e;
                for (int i = catIndexBeforeTime; i < list.size() && (e = list.get(i)).getOriginTime() <= time; ++i) {
                    catIndexBeforeTime = i;
                    if (e.getFSSIndex() < 0) continue;
                    prevSupra = e.getOriginTime();
                }
                if (prevSupra <= Long.MIN_VALUE) continue;
                long curDelta = time - prevSupra;
                Preconditions.checkState((curDelta >= 0L ? 1 : 0) != 0);
                double curDeltaYears = (double)curDelta / 3.15576E10;
                if (curDeltaYears > hist.getMaxX()) {
                    hist.add(hist.size() - 1, 1.0);
                } else {
                    hist.add(curDeltaYears, 1.0);
                }
                allVals.add(curDeltaYears);
            }
        }
        hist.normalizeBySumOfY_Vals();
        HistogramFunction cmlHist = new HistogramFunction(hist.getMinX() - hist.getDelta() * 0.5, hist.size(), hist.getDelta());
        double d = 0.0;
        int i = hist.size();
        while (--i >= 0) {
            double val = hist.getY(i);
            cmlHist.set(i, d += val);
        }
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(hist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        hist.setName("Histogram");
        funcs.add(cmlHist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.GRAY));
        cmlHist.setName("Cumulative (\u2265) Histogram");
        double[] allValsArray = Doubles.toArray((Collection)allVals);
        double mean = StatUtils.mean((double[])allValsArray);
        double median = DataUtils.median(allValsArray);
        DefaultXY_DataSet meanLine = new DefaultXY_DataSet();
        meanLine.set(mean, 0.0);
        meanLine.set(mean, 1.0);
        meanLine.setName("Mean=" + (float)mean);
        funcs.add(meanLine);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.BLUE));
        DefaultXY_DataSet medianLine = new DefaultXY_DataSet();
        medianLine.set(median, 0.0);
        medianLine.set(median, 1.0);
        medianLine.setName("Median=" + (float)median);
        funcs.add(medianLine);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 3.0f, Color.GREEN.darker()));
        PlotSpec spec = new PlotSpec(funcs, chars, "Time Since Last Supra-Seosmogenic Hist", "Time (years)", "Density");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, false, new Range(0.0, hist.getMaxX() + 0.5 * hist.getDelta()), new Range(0.0, 1.0));
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, "time_since_last_supra.png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, "time_since_last_supra.pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, "time_since_last_supra.txt").getAbsolutePath());
    }

    private static void writeCatalogsForViz(List<List<ETAS_EqkRupture>> catalogs, ETAS_Simulator.TestScenario scenario, File outputDir, int numEach) throws IOException {
        Object infoStr;
        Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
        double[] fractiles = new double[]{0.0, 0.5, 1.0};
        Preconditions.checkState((catalogs.size() > numEach ? 1 : 0) != 0);
        ArrayList sortables = Lists.newArrayList();
        for (List<ETAS_EqkRupture> catalog : catalogs) {
            double num = 0.0;
            for (ETAS_EqkRupture rup : catalog) {
                if (!(rup.getMag() > 6.5)) continue;
                num += 1.0;
            }
            sortables.add(num);
        }
        if (scenario != null) {
            if (scenario.getFSS_Index() >= 0) {
                infoStr = "FSS simulation. M=" + scenario.getMagnitude() + ", fss ID=" + scenario.getFSS_Index();
            } else {
                Location loc = scenario.getLocation();
                infoStr = "Pt Source. M=" + scenario.getMagnitude() + ", " + loc.getLatitude() + ", " + loc.getLongitude() + ", " + loc.getDepth();
            }
        } else {
            infoStr = "Spontaneous events";
        }
        List pairings = ComparablePairing.build(sortables, catalogs);
        Collections.sort(pairings);
        for (double fractile : fractiles) {
            int index = (int)((double)(catalogs.size() - 1) * fractile);
            while (index + numEach >= catalogs.size()) {
                --index;
            }
            for (int i = 0; i < numEach; ++i) {
                int myIndex = index + i;
                ComparablePairing pairing = pairings.get(myIndex);
                File subDir = new File(outputDir, "fract_" + (float)fractile + "_cat" + i);
                Preconditions.checkState((subDir.exists() || subDir.mkdir() ? 1 : 0) != 0);
                List<ETAS_EqkRupture> catalog = pairing.getData();
                File infoFile = new File(subDir, "infoString.txt");
                FileWriter fw = new FileWriter(infoFile);
                fw.write((String)infoStr + "\n");
                fw.write("\n");
                fw.write("Total num ruptures: " + catalog.size() + "\n");
                fw.write("Total moment: " + String.valueOf(pairing.getComparable()) + "\n");
                fw.write("Max triggered mag: " + ETAS_SimAnalysisTools.getMaxMag(catalog) + "\n");
                fw.close();
                File catalogFile = new File(subDir, "simulatedEvents.txt");
                ETAS_CatalogIO.writeEventDataToFile(catalogFile, catalog);
            }
        }
    }

    public static void plotSectParticScatter(Iterable<? extends List<ETAS_EqkRupture>> catalogs, double duration, FaultSystemSolutionERF erf, File outputDir) throws IOException, GMT_MapException, RuntimeException {
        double[] minMags = new double[]{0.0};
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        CPT logRatioCPT = FaultBasedMapGen.getLogRatioCPT().rescale(-1.0, 1.0);
        CPT diffCPT = FaultBasedMapGen.getLogRatioCPT();
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        boolean regionFilter = false;
        ArrayList sectsToInclude = Lists.newArrayList();
        block0: for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
            for (Location loc : faultSection.getFaultTrace()) {
                if (regionFilter && !region.contains(loc)) continue;
                sectsToInclude.add(faultSection.getSectionId());
                continue block0;
            }
        }
        ArrayList faults = Lists.newArrayList();
        Iterator iterator = sectsToInclude.iterator();
        while (iterator.hasNext()) {
            int sectIndex = (Integer)iterator.next();
            faults.add(rupSet.getFaultSectionData(sectIndex).getFaultTrace());
        }
        boolean bl = true;
        for (double minMag : minMags) {
            boolean bl2;
            double[] subSectVals = FaultSysSolutionERF_Calc.calcParticipationRateForAllSects(erf, minMag);
            double[] catalogVals = new double[rupSet.getNumSections()];
            int[] totalNumForSection = new int[rupSet.getNumSections()];
            double[] fractTriggeredForSection = new double[rupSet.getNumSections()];
            double[] fractTriggeredBySupraForSection = new double[rupSet.getNumSections()];
            double[] fractTriggeredBySubForSection = new double[rupSet.getNumSections()];
            double[] fractTriggeredByHistForSection = new double[rupSet.getNumSections()];
            int catalogCount = 0;
            for (List<ETAS_EqkRupture> list : catalogs) {
                if (duration < 0.0) {
                    duration = ETAS_MultiSimAnalysisTools.calcDurationYears(list);
                }
                double rateEach = 1.0 / duration;
                ++catalogCount;
                HashMap<Integer, ETAS_EqkRupture> idToRupMap = new HashMap<Integer, ETAS_EqkRupture>();
                int minIndex = Integer.MAX_VALUE;
                if (bl2) {
                    for (ETAS_EqkRupture rup : list) {
                        idToRupMap.put(rup.getID(), rup);
                        if (rup.getID() >= minIndex) continue;
                        minIndex = rup.getID();
                    }
                }
                for (ETAS_EqkRupture rup : list) {
                    int rupIndex = rup.getFSSIndex();
                    if (rupIndex < 0 || rup.getMag() < minMag) continue;
                    Iterator<Integer> iterator2 = rupSet.getSectionsIndicesForRup(rupIndex).iterator();
                    while (iterator2.hasNext()) {
                        int sectIndex;
                        int n = sectIndex = iterator2.next().intValue();
                        catalogVals[n] = catalogVals[n] + rateEach;
                        int n2 = sectIndex;
                        totalNumForSection[n2] = totalNumForSection[n2] + 1;
                        if (rup.getGeneration() <= 0) continue;
                        int n3 = sectIndex;
                        fractTriggeredForSection[n3] = fractTriggeredForSection[n3] + 1.0;
                        if (!bl2) continue;
                        boolean supra = false;
                        boolean hist = false;
                        ETAS_EqkRupture myRup = rup;
                        while (myRup.getParentID() >= 0) {
                            if (myRup.getParentID() < minIndex) {
                                hist = true;
                                break;
                            }
                            if ((myRup = (ETAS_EqkRupture)idToRupMap.get(myRup.getParentID())) == null) {
                                bl2 = false;
                                break;
                            }
                            if (myRup.getFSSIndex() < 0) continue;
                            supra = true;
                            break;
                        }
                        if (supra) {
                            int n4 = sectIndex;
                            fractTriggeredBySupraForSection[n4] = fractTriggeredBySupraForSection[n4] + 1.0;
                            continue;
                        }
                        if (hist) {
                            int n5 = sectIndex;
                            fractTriggeredByHistForSection[n5] = fractTriggeredByHistForSection[n5] + 1.0;
                            continue;
                        }
                        int n6 = sectIndex;
                        fractTriggeredBySubForSection[n6] = fractTriggeredBySubForSection[n6] + 1.0;
                    }
                }
            }
            int i = 0;
            while (i < catalogVals.length) {
                int n = i++;
                catalogVals[n] = catalogVals[n] / (double)catalogCount;
            }
            if (!bl2) {
                System.out.println("Cannot compute fract triggered by supra as catalog has been magnitude filtered");
            }
            for (int sectIndex = 0; sectIndex < rupSet.getNumSections(); ++sectIndex) {
                int n = sectIndex;
                fractTriggeredForSection[n] = fractTriggeredForSection[n] / (double)totalNumForSection[sectIndex];
                if (!bl2) continue;
                int n7 = sectIndex;
                fractTriggeredBySupraForSection[n7] = fractTriggeredBySupraForSection[n7] / (double)totalNumForSection[sectIndex];
                int n8 = sectIndex;
                fractTriggeredBySubForSection[n8] = fractTriggeredBySubForSection[n8] / (double)totalNumForSection[sectIndex];
                int n9 = sectIndex;
                fractTriggeredByHistForSection[n9] = fractTriggeredByHistForSection[n9] / (double)totalNumForSection[sectIndex];
            }
            double[] filteredCatalogVals = new double[sectsToInclude.size()];
            double[] dArray = new double[sectsToInclude.size()];
            double[] filteredFractTriggeredForSection = new double[sectsToInclude.size()];
            double[] filteredFractTriggeredBySupraForSection = new double[sectsToInclude.size()];
            double[] filteredFractTriggeredBySubForSection = new double[sectsToInclude.size()];
            double[] filteredFractTriggeredByHistForSection = new double[sectsToInclude.size()];
            for (int i2 = 0; i2 < filteredCatalogVals.length; ++i2) {
                int s = (Integer)sectsToInclude.get(i2);
                filteredCatalogVals[i2] = catalogVals[s];
                dArray[i2] = subSectVals[s];
                filteredFractTriggeredForSection[i2] = fractTriggeredForSection[s];
                if (!bl2) continue;
                filteredFractTriggeredBySupraForSection[i2] = fractTriggeredBySupraForSection[s];
                filteredFractTriggeredBySubForSection[i2] = fractTriggeredBySubForSection[s];
                filteredFractTriggeredByHistForSection[i2] = fractTriggeredByHistForSection[s];
            }
            if (minMag == minMags[0]) {
                System.out.println("Filtered out " + (catalogVals.length - filteredCatalogVals.length) + " sects outside of region");
            }
            catalogVals = filteredCatalogVals;
            subSectVals = dArray;
            fractTriggeredForSection = filteredFractTriggeredForSection;
            fractTriggeredBySupraForSection = filteredFractTriggeredBySupraForSection;
            fractTriggeredBySubForSection = filteredFractTriggeredBySubForSection;
            fractTriggeredByHistForSection = filteredFractTriggeredByHistForSection;
            Object title = "Sub Section Participation";
            Object prefix = "all_eqs_sect_partic";
            if (minMag > 0.0) {
                title = (String)title + ", M\u2265" + (float)minMag;
                prefix = (String)prefix + "_m" + (float)minMag;
            }
            CSVFile csv = new CSVFile(true);
            ArrayList header = Lists.newArrayList((Object[])new String[]{"Sect Index", "Sect Name", "Simulation Rate", "Long Term Rate", "Ratio", "Difference", "Fraction Triggered"});
            if (bl2) {
                header.add("Fraction Triggered By Supra-Seismo");
                header.add("Fraction Triggered By Sub-Seismo");
                header.add("Fraction Triggered By Historical");
            }
            csv.addLine(header);
            double[] ratio = ETAS_MultiSimAnalysisTools.ratio(catalogVals, subSectVals);
            double[] diff = ETAS_MultiSimAnalysisTools.diff(catalogVals, subSectVals);
            for (int i3 = 0; i3 < catalogVals.length; ++i3) {
                FaultSection sect3 = rupSet.getFaultSectionData((Integer)sectsToInclude.get(i3));
                String sectName = sect3.getSectionName().replace(",", "_");
                ArrayList line = Lists.newArrayList((Object[])new String[]{"" + i3, sectName, "" + catalogVals[i3], "" + subSectVals[i3], "" + ratio[i3], "" + diff[i3], "" + fractTriggeredForSection[i3]});
                if (bl2) {
                    line.add("" + fractTriggeredBySupraForSection[i3]);
                    line.add("" + fractTriggeredBySubForSection[i3]);
                    line.add("" + fractTriggeredByHistForSection[i3]);
                }
                csv.addLine(line);
            }
            csv.writeToFile(new File(outputDir, (String)prefix + ".csv"));
            ETAS_MultiSimAnalysisTools.plotScatter(catalogVals, subSectVals, (String)title + " Scatter", "Participation Rate", (String)prefix + "_scatter", outputDir);
            title = ((String)title).replaceAll("\u2265", ">=");
            FaultBasedMapGen.makeFaultPlot(logRatioCPT, faults, FaultBasedMapGen.log10(ratio), region, outputDir, (String)prefix + "_ratio", false, false, (String)title + " Ratio");
            double maxDiff = Math.max(Math.abs(StatUtils.min((double[])diff)), Math.abs(StatUtils.max((double[])diff)));
            FaultBasedMapGen.makeFaultPlot(diffCPT.rescale(-maxDiff, maxDiff), faults, diff, region, outputDir, (String)prefix + "_diff", false, false, (String)title + " Diff");
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void plotAndWriteSectProbOneOrMoreData(Iterable<? extends List<ETAS_EqkRupture>> catalogs, double durationForProb, FaultSystemSolutionERF erf, File outputDir) throws IOException, GMT_MapException, RuntimeException {
        double[] minMags = new double[]{0.0};
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        CPT logRatioCPT = FaultBasedMapGen.getLogRatioCPT().rescale(-1.0, 1.0);
        CPT diffCPT = FaultBasedMapGen.getLogRatioCPT();
        CaliforniaRegions.RELM_TESTING region = new CaliforniaRegions.RELM_TESTING();
        boolean regionFilter = false;
        ArrayList sectsToInclude = Lists.newArrayList();
        block0: for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
            for (Location loc : faultSection.getFaultTrace()) {
                if (regionFilter && !region.contains(loc)) continue;
                sectsToInclude.add(faultSection.getSectionId());
                continue block0;
            }
        }
        ArrayList faults = Lists.newArrayList();
        Iterator iterator = sectsToInclude.iterator();
        while (iterator.hasNext()) {
            int sectIndex = (Integer)iterator.next();
            faults.add(rupSet.getFaultSectionData(sectIndex).getFaultTrace());
        }
        boolean bl = true;
        erf.getTimeSpan().setDuration(durationForProb);
        erf.updateForecast();
        for (double minMag : minMags) {
            int i;
            void var29_42;
            void var29_40;
            boolean bl2;
            double[] subSectEquivRateVals = FaultSysSolutionERF_Calc.calcParticipationRateForAllSects(erf, minMag);
            double[] subSectExpVals = new double[rupSet.getNumSections()];
            for (int s = 0; s < subSectExpVals.length; ++s) {
                subSectExpVals[s] = 1.0 - Math.exp(-subSectEquivRateVals[s] * durationForProb);
            }
            double[] catalogVals = new double[rupSet.getNumSections()];
            int[] totalNumForSection = new int[rupSet.getNumSections()];
            double[] fractTriggeredForSection = new double[rupSet.getNumSections()];
            double[] fractTriggeredBySupraForSection = new double[rupSet.getNumSections()];
            double[] fractTriggeredBySubForSection = new double[rupSet.getNumSections()];
            double[] fractTriggeredByHistForSection = new double[rupSet.getNumSections()];
            int catalogCount = 0;
            for (List<ETAS_EqkRupture> list : catalogs) {
                double[] timeOfLastEventOnSect = new double[rupSet.getNumSections()];
                for (int i2 = 0; i2 < timeOfLastEventOnSect.length; ++i2) {
                    timeOfLastEventOnSect[i2] = -1.0;
                }
                ++catalogCount;
                HashMap<Integer, ETAS_EqkRupture> idToRupMap = new HashMap<Integer, ETAS_EqkRupture>();
                int minIndex = Integer.MAX_VALUE;
                if (bl2) {
                    for (ETAS_EqkRupture rup : list) {
                        idToRupMap.put(rup.getID(), rup);
                        if (rup.getID() >= minIndex) continue;
                        minIndex = rup.getID();
                    }
                }
                for (ETAS_EqkRupture rup : list) {
                    int rupIndex = rup.getFSSIndex();
                    if (rupIndex < 0 || rup.getMag() < minMag) continue;
                    double eventTime = ETAS_MultiSimAnalysisTools.calcEventTimeYears(list, rup);
                    for (int sectIndex : rupSet.getSectionsIndicesForRup(rupIndex)) {
                        if (timeOfLastEventOnSect[sectIndex] == -1.0 && eventTime < durationForProb) {
                            int n = sectIndex;
                            catalogVals[n] = catalogVals[n] + 1.0;
                            int n2 = sectIndex;
                            totalNumForSection[n2] = totalNumForSection[n2] + 1;
                            if (rup.getGeneration() > 0) {
                                int n3 = sectIndex;
                                fractTriggeredForSection[n3] = fractTriggeredForSection[n3] + 1.0;
                                if (bl2) {
                                    boolean supra = false;
                                    boolean hist = false;
                                    ETAS_EqkRupture myRup = rup;
                                    while (myRup.getParentID() >= 0) {
                                        if (myRup.getParentID() < minIndex) {
                                            hist = true;
                                            break;
                                        }
                                        if ((myRup = (ETAS_EqkRupture)idToRupMap.get(myRup.getParentID())) == null) {
                                            bl2 = false;
                                            break;
                                        }
                                        if (myRup.getFSSIndex() < 0) continue;
                                        supra = true;
                                        break;
                                    }
                                    if (supra) {
                                        int n4 = sectIndex;
                                        fractTriggeredBySupraForSection[n4] = fractTriggeredBySupraForSection[n4] + 1.0;
                                    } else if (hist) {
                                        int n5 = sectIndex;
                                        fractTriggeredByHistForSection[n5] = fractTriggeredByHistForSection[n5] + 1.0;
                                    } else {
                                        int n6 = sectIndex;
                                        fractTriggeredBySubForSection[n6] = fractTriggeredBySubForSection[n6] + 1.0;
                                    }
                                }
                            }
                        }
                        timeOfLastEventOnSect[sectIndex] = eventTime;
                    }
                }
            }
            int i3 = 0;
            while (i3 < catalogVals.length) {
                int n = i3++;
                catalogVals[n] = catalogVals[n] / (double)catalogCount;
            }
            double[] catalogValsStdom = new double[rupSet.getNumSections()];
            for (List<ETAS_EqkRupture> catalog3 : catalogs) {
                double[] gotOneOnSectForCat = new double[rupSet.getNumSections()];
                for (ETAS_EqkRupture rup : catalog3) {
                    int rupIndex = rup.getFSSIndex();
                    if (rupIndex < 0 || rup.getMag() < minMag) continue;
                    double eventTime = ETAS_MultiSimAnalysisTools.calcEventTimeYears(catalog3, rup);
                    for (int sectIndex : rupSet.getSectionsIndicesForRup(rupIndex)) {
                        if (!(eventTime < durationForProb)) continue;
                        gotOneOnSectForCat[sectIndex] = 1.0;
                    }
                }
                for (int s = 0; s < gotOneOnSectForCat.length; ++s) {
                    int n = s;
                    catalogValsStdom[n] = catalogValsStdom[n] + Math.pow(gotOneOnSectForCat[s] - catalogVals[s], 2.0);
                }
            }
            boolean bl3 = false;
            while (var29_40 < catalogValsStdom.length) {
                void v8 = var29_40++;
                catalogValsStdom[v8] = catalogValsStdom[v8] / (double)catalogCount;
            }
            if (!bl2) {
                System.out.println("Cannot compute fract triggered by supra as catalog has been magnitude filtered");
            }
            boolean bl4 = false;
            while (var29_42 < rupSet.getNumSections()) {
                void v9 = var29_42;
                fractTriggeredForSection[v9] = fractTriggeredForSection[v9] / (double)totalNumForSection[var29_42];
                if (bl2) {
                    void v10 = var29_42;
                    fractTriggeredBySupraForSection[v10] = fractTriggeredBySupraForSection[v10] / (double)totalNumForSection[var29_42];
                    void v11 = var29_42;
                    fractTriggeredBySubForSection[v11] = fractTriggeredBySubForSection[v11] / (double)totalNumForSection[var29_42];
                    void v12 = var29_42;
                    fractTriggeredByHistForSection[v12] = fractTriggeredByHistForSection[v12] / (double)totalNumForSection[var29_42];
                }
                ++var29_42;
            }
            double[] dArray = new double[sectsToInclude.size()];
            double[] filteredSubSectVals = new double[sectsToInclude.size()];
            double[] filteredFractTriggeredForSection = new double[sectsToInclude.size()];
            double[] filteredFractTriggeredBySupraForSection = new double[sectsToInclude.size()];
            double[] filteredFractTriggeredBySubForSection = new double[sectsToInclude.size()];
            double[] filteredFractTriggeredByHistForSection = new double[sectsToInclude.size()];
            for (int i4 = 0; i4 < dArray.length; ++i4) {
                int s2 = (Integer)sectsToInclude.get(i4);
                dArray[i4] = catalogVals[s2];
                filteredSubSectVals[i4] = subSectExpVals[s2];
                filteredFractTriggeredForSection[i4] = fractTriggeredForSection[s2];
                if (!bl2) continue;
                filteredFractTriggeredBySupraForSection[i4] = fractTriggeredBySupraForSection[s2];
                filteredFractTriggeredBySubForSection[i4] = fractTriggeredBySubForSection[s2];
                filteredFractTriggeredByHistForSection[i4] = fractTriggeredByHistForSection[s2];
            }
            if (minMag == minMags[0]) {
                System.out.println("Filtered out " + (catalogVals.length - dArray.length) + " sects outside of region");
            }
            catalogVals = dArray;
            subSectExpVals = filteredSubSectVals;
            fractTriggeredForSection = filteredFractTriggeredForSection;
            fractTriggeredBySupraForSection = filteredFractTriggeredBySupraForSection;
            fractTriggeredBySubForSection = filteredFractTriggeredBySubForSection;
            fractTriggeredByHistForSection = filteredFractTriggeredByHistForSection;
            Object title = "Sub Section Prob One Or More";
            Object prefix = "all_eqs_sect_prob1orMore";
            if (minMag > 0.0) {
                title = (String)title + ", M\u2265" + (float)minMag;
                prefix = (String)prefix + "_m" + (float)minMag;
            }
            CSVFile csv = new CSVFile(true);
            ArrayList header = Lists.newArrayList((Object[])new String[]{"SectIndex", "SectName", "Simulation Prob1orMore", "ExpectedProb1orMore", "Ratio", "Difference", "FractTriggered", "SimProb1orMoreStdom", "StdomNormDiff"});
            if (bl2) {
                header.add("FractTrigBySupraSeis");
                header.add("FractTrigBySubSeism");
                header.add("FractTrigByHistQk");
            }
            csv.addLine(header);
            double[] ratio = ETAS_MultiSimAnalysisTools.ratio(catalogVals, subSectExpVals);
            double[] diff = ETAS_MultiSimAnalysisTools.diff(catalogVals, subSectExpVals);
            double[] stdomNormDiff = new double[ratio.length];
            double meanRatio = 0.0;
            for (i = 0; i < ratio.length; ++i) {
                meanRatio += ratio[i] / (double)ratio.length;
            }
            System.out.println("meanRatio=" + meanRatio);
            for (i = 0; i < ratio.length; ++i) {
                stdomNormDiff[i] = catalogVals[i] - meanRatio * subSectExpVals[i];
            }
            for (i = 0; i < catalogVals.length; ++i) {
                FaultSection sect3 = rupSet.getFaultSectionData((Integer)sectsToInclude.get(i));
                String sectName = sect3.getSectionName().replace(",", "_");
                ArrayList line = Lists.newArrayList((Object[])new String[]{"" + i, sectName, "" + catalogVals[i], "" + subSectExpVals[i], "" + ratio[i], "" + diff[i], "" + fractTriggeredForSection[i], "" + catalogValsStdom[i], "" + stdomNormDiff[i]});
                if (bl2) {
                    line.add("" + fractTriggeredBySupraForSection[i]);
                    line.add("" + fractTriggeredBySubForSection[i]);
                    line.add("" + fractTriggeredByHistForSection[i]);
                }
                csv.addLine(line);
            }
            csv.writeToFile(new File(outputDir, (String)prefix + ".csv"));
            ETAS_MultiSimAnalysisTools.plotScatter(catalogVals, subSectExpVals, (String)title + " Scatter", "Prob One Or More", (String)prefix + "_scatter", outputDir);
            title = ((String)title).replaceAll("\u2265", ">=");
            FaultBasedMapGen.makeFaultPlot(logRatioCPT, faults, FaultBasedMapGen.log10(ratio), region, outputDir, (String)prefix + "_ratio", false, false, (String)title + " Ratio");
            double maxDiff = Math.max(Math.abs(StatUtils.min((double[])diff)), Math.abs(StatUtils.max((double[])diff)));
            FaultBasedMapGen.makeFaultPlot(diffCPT.rescale(-maxDiff, maxDiff), faults, diff, region, outputDir, (String)prefix + "_diff", false, false, (String)title + " Diff");
            FaultBasedMapGen.makeFaultPlot(diffCPT.rescale(-maxDiff / 2.0, maxDiff / 2.0), faults, stdomNormDiff, region, outputDir, (String)prefix + "_meanCorrectedDiff", false, false, (String)title + " MeanCorrectedDiff");
            for (int i5 = 0; i5 < ratio.length; ++i5) {
                if (!(subSectExpVals[i5] < 0.003)) continue;
                ratio[i5] = 1.0;
            }
            FaultBasedMapGen.makeFaultPlot(logRatioCPT, faults, FaultBasedMapGen.log10(ratio), region, outputDir, (String)prefix + "_ratioFilteredProbGt0pt003", false, false, (String)title + " Ratio");
        }
    }

    public static void plotBinnedSectParticRateVsExpRate(List<List<ETAS_EqkRupture>> catalogs, double duration, FaultSystemSolutionERF erf, File outputDir, String prefix) throws IOException, GMT_MapException, RuntimeException {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        ImmutableList<IncrementalMagFreqDist> longTermSubSeisMFD_OnSectList = erf.getSolution().requireModule(SubSeismoOnFaultMFDs.class).getAll();
        HistogramFunction aveValsFunc = new HistogramFunction(-4.9, 19, 0.2);
        HistogramFunction numValsFunc = new HistogramFunction(-4.9, 19, 0.2);
        double[] subSectExpVals = FaultSysSolutionERF_Calc.calcParticipationRateForAllSects(erf, 0.0);
        int[] totalNumForSection = new int[rupSet.getNumSections()];
        int catalogCount = 0;
        double[] catalogVals = new double[rupSet.getNumSections()];
        for (List<ETAS_EqkRupture> catalog : catalogs) {
            if (duration < 0.0) {
                duration = ETAS_MultiSimAnalysisTools.calcDurationYears(catalog);
            }
            double rateEach = 1.0 / duration;
            ++catalogCount;
            for (ETAS_EqkRupture rup : catalog) {
                int rupIndex = rup.getFSSIndex();
                if (rupIndex < 0) continue;
                Iterator<Integer> iterator = rupSet.getSectionsIndicesForRup(rupIndex).iterator();
                while (iterator.hasNext()) {
                    int sectIndex;
                    int n = sectIndex = iterator.next().intValue();
                    catalogVals[n] = catalogVals[n] + rateEach;
                    int n2 = sectIndex;
                    totalNumForSection[n2] = totalNumForSection[n2] + 1;
                }
            }
        }
        for (int s = 0; s < subSectExpVals.length; ++s) {
            if (((IncrementalMagFreqDist)longTermSubSeisMFD_OnSectList.get(s)).getTotalIncrRate() == 0.0) {
                System.out.println(erf.getSolution().getRupSet().getFaultSectionData(s).getName());
            }
            if (!(catalogVals[s] > 0.0) || !(((IncrementalMagFreqDist)longTermSubSeisMFD_OnSectList.get(s)).getTotalIncrRate() > 0.0)) continue;
            int n = s;
            catalogVals[n] = catalogVals[n] / (double)catalogCount;
            double logExpVal = Math.log10(subSectExpVals[s]);
            double logSimVal = Math.log10(catalogVals[s]);
            if (!(logExpVal > aveValsFunc.getMinX() - aveValsFunc.getDelta() / 2.0)) continue;
            aveValsFunc.add(logExpVal, logSimVal);
            numValsFunc.add(logExpVal, 1.0);
        }
        DefaultXY_DataSet resultsFunc = new DefaultXY_DataSet();
        for (int i = 0; i < numValsFunc.size(); ++i) {
            double num = numValsFunc.getY(i);
            if (!(num > 0.0)) continue;
            resultsFunc.set(Math.pow(10.0, aveValsFunc.getX(i)), Math.pow(10.0, aveValsFunc.getY(i) / num));
        }
        String title = "Binned Sub Section Participation";
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.set(1.0E-6, 1.0E-6);
        line.set(0.1, 0.1);
        funcs.add(line);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        funcs.add(resultsFunc);
        resultsFunc.setName("Binned observed sections rates vs expected rates");
        resultsFunc.setInfo(resultsFunc.toString());
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 3.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(funcs, chars, title, "Long Term Rate", "Binned Simulation Rate");
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        Range range = new Range(1.0E-6, 0.1);
        gp.drawGraphPanel(spec, true, true, range, range);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    public static void calcSupraAncestorStats(Iterable<? extends List<ETAS_EqkRupture>> catalogs, File outputDir) throws IOException {
        long numSupra = 0L;
        long numSupraSpontaneous = 0L;
        long numSupraTriggeredSupra = 0L;
        long numSupraTriggeredHist = 0L;
        long numSupraTriggeredOther = 0L;
        long numSupraTriggeredSupraDirect = 0L;
        for (List<ETAS_EqkRupture> list : catalogs) {
            HashMap<Integer, ETAS_EqkRupture> idToRupMap = new HashMap<Integer, ETAS_EqkRupture>();
            int minIndex = Integer.MAX_VALUE;
            for (ETAS_EqkRupture rup : list) {
                idToRupMap.put(rup.getID(), rup);
                if (rup.getID() >= minIndex) continue;
                minIndex = rup.getID();
            }
            for (ETAS_EqkRupture rup : list) {
                if (rup.getFSSIndex() < 0) continue;
                ++numSupra;
                if (rup.getParentID() < 0) {
                    ++numSupraSpontaneous;
                    continue;
                }
                boolean supra = false;
                boolean hist = false;
                ETAS_EqkRupture myRup = rup;
                while (myRup.getParentID() >= 0) {
                    if (myRup.getParentID() < minIndex) {
                        hist = true;
                        break;
                    }
                    Preconditions.checkState(((myRup = (ETAS_EqkRupture)idToRupMap.get(myRup.getParentID())) != null ? 1 : 0) != 0, (Object)"This isn't a complete catalog (was filtered), cannot track ancestors");
                    if (myRup.getFSSIndex() < 0) continue;
                    supra = true;
                    if (rup.getParentID() != myRup.getID()) break;
                    ++numSupraTriggeredSupraDirect;
                    break;
                }
                if (supra) {
                    ++numSupraTriggeredSupra;
                    continue;
                }
                if (hist) {
                    ++numSupraTriggeredHist;
                    continue;
                }
                ++numSupraTriggeredOther;
            }
        }
        Preconditions.checkState((numSupraTriggeredOther == numSupra - numSupraSpontaneous - numSupraTriggeredSupra - numSupraTriggeredHist ? 1 : 0) != 0);
        Object text = "Supra-seismogenic rupture ancestors:\n";
        text = (String)text + "\tTotal num supra: " + numSupra + "\n";
        text = (String)text + "\tNum spontaneous supra: " + numSupraSpontaneous + "\n";
        text = (String)text + "\tNum with supra ancestor: " + numSupraTriggeredSupra + " (" + numSupraTriggeredSupraDirect + " of which were direct supra triggers)\n";
        text = (String)text + "\tNum with hist (and no supra) ancestor: " + numSupraTriggeredHist + "\n";
        text = (String)text + "\tNum triggered other: " + numSupraTriggeredOther + "\n";
        text = (String)text + "\n";
        double d = (double)numSupraSpontaneous / (double)numSupra;
        double fractSupraTriggeredSupra = (double)numSupraTriggeredSupra / (double)numSupra;
        double fractSupraTriggeredSupraDirect = (double)numSupraTriggeredSupraDirect / (double)numSupraTriggeredSupra;
        double fractSupraTriggeredHist = (double)numSupraTriggeredHist / (double)numSupra;
        double fractSupraTriggeredOther = (double)numSupraTriggeredOther / (double)numSupra;
        text = (String)text + "\tFractions: " + numSupra + "\n";
        text = (String)text + "\tFract spontaneous supra: " + d + "\n";
        text = (String)text + "\tFract with supra ancestor: " + fractSupraTriggeredSupra + " (" + fractSupraTriggeredSupraDirect + " of which were direct supra triggers)\n";
        text = (String)text + "\tFract with hist (and no supra) ancestor: " + fractSupraTriggeredHist + "\n";
        text = (String)text + "\tFract triggered other: " + fractSupraTriggeredOther + "\n";
        System.out.println((String)text);
        if (outputDir != null) {
            File outputFile = new File(outputDir, "supra_ancestor_stats.txt");
            FileWriter fw = new FileWriter(outputFile);
            fw.write((String)text);
            fw.close();
        }
    }

    private static double[] diff(double[] data1, double[] data2) {
        double[] diff = new double[data1.length];
        for (int i = 0; i < data1.length; ++i) {
            diff[i] = data1[i] - data2[i];
        }
        return diff;
    }

    private static double[] ratio(double[] data1, double[] data2) {
        double[] ratio = new double[data1.length];
        for (int i = 0; i < data1.length; ++i) {
            ratio[i] = data1[i] / data2[i];
        }
        return ratio;
    }

    /*
     * WARNING - void declaration
     */
    private static void plotGriddedNucleationScatter(List<? extends List<ETAS_EqkRupture>> catalogs, double duration, FaultSystemSolutionERF erf, File outputDir) throws IOException, GMT_MapException {
        double[] minMags = new double[]{5.0};
        CaliforniaRegions.RELM_TESTING_GRIDDED reg = RELM_RegionUtils.getGriddedRegionInstance();
        CPT logRatioCPT = FaultBasedMapGen.getLogRatioCPT().rescale(-2.0, 2.0);
        CPT diffCPT = FaultBasedMapGen.getLogRatioCPT();
        for (double minMag : minMags) {
            void var19_20;
            GriddedGeoDataSet longTermRates = ERF_Calculator.getNucleationRatesInRegion(erf, reg, minMag, 10.0);
            GriddedGeoDataSet catalogRates = new GriddedGeoDataSet(reg, longTermRates.isLatitudeX());
            double[] longTermVals = new double[reg.getNodeCount()];
            double[] catalogVals = new double[reg.getNodeCount()];
            for (int i = 0; i < reg.getNodeCount(); ++i) {
                longTermVals[i] = longTermRates.get(i);
            }
            for (List<ETAS_EqkRupture> list : catalogs) {
                if (duration < 0.0) {
                    duration = ETAS_MultiSimAnalysisTools.calcDurationYears(list);
                }
                double rateEach = 1.0 / ((double)catalogs.size() * duration);
                for (ETAS_EqkRupture rup : list) {
                    Location hypo;
                    int index;
                    if (rup.getMag() < minMag || (index = reg.indexForLocation(hypo = rup.getHypocenterLocation())) < 0) continue;
                    int n = index;
                    catalogVals[n] = catalogVals[n] + rateEach;
                }
            }
            for (int i = 0; i < catalogVals.length; ++i) {
                catalogRates.set(i, catalogVals[i]);
            }
            Object title = "Gridded Nucleation";
            String string = "all_eqs_gridded_nucl";
            if (minMag > 0.0) {
                title = (String)title + ", M\u2265" + (float)minMag;
                String string2 = string + "_m" + (float)minMag;
            }
            CSVFile<String> csv = new CSVFile<String>(true);
            csv.addLine("Node Index", "Latitude", "Longitude", "Simulation Rate", "Long Term Rate", "Ratio", "Difference");
            double[] ratio = ETAS_MultiSimAnalysisTools.ratio(catalogVals, longTermVals);
            double[] diff = ETAS_MultiSimAnalysisTools.diff(catalogVals, longTermVals);
            LocationList nodeList = reg.getNodeList();
            for (int i = 0; i < reg.getNodeCount(); ++i) {
                Location loc = (Location)nodeList.get(i);
                csv.addLine("" + i, "" + loc.getLatitude(), "" + loc.getLongitude(), "" + catalogVals[i], "" + longTermVals[i], "" + ratio[i], "" + diff[i]);
            }
            csv.writeToFile(new File(outputDir, (String)var19_20 + ".csv"));
            ETAS_MultiSimAnalysisTools.plotScatter(catalogVals, longTermVals, (String)title + " Scatter", "Nucleation Rate", (String)var19_20 + "_scatter", outputDir);
            GeoDataSet ratioData = GeoDataSetMath.divide(catalogRates, longTermRates);
            ratioData.log10();
            GeoDataSet diffData = GeoDataSetMath.subtract(catalogRates, longTermRates);
            title = ((String)title).replaceAll("\u2265", ">=");
            FaultBasedMapGen.plotMap(outputDir, (String)var19_20 + "_ratio", false, FaultBasedMapGen.buildMap(logRatioCPT, null, null, ratioData, reg.getLatSpacing(), reg, false, (String)title + " Ratio"));
            double maxDiff = Math.max(Math.abs(StatUtils.min((double[])diff)), Math.abs(StatUtils.max((double[])diff)));
            FaultBasedMapGen.plotMap(outputDir, (String)var19_20 + "_diff", false, FaultBasedMapGen.buildMap(diffCPT.rescale(-maxDiff, maxDiff), null, null, diffData, reg.getLatSpacing(), reg, false, (String)title + " Diff"));
        }
    }

    private static void plotScatter(double[] simulationData, double[] longTermData, String title, String quantity, String prefix, File outputDir) throws IOException {
        Preconditions.checkArgument((simulationData.length == longTermData.length ? 1 : 0) != 0);
        DefaultXY_DataSet scatter = new DefaultXY_DataSet();
        DefaultXY_DataSet simZeroScatter = new DefaultXY_DataSet();
        int bothZeroCount = 0;
        for (int i = 0; i < simulationData.length; ++i) {
            if (simulationData[i] > 0.0) {
                scatter.set(longTermData[i], simulationData[i]);
                continue;
            }
            if (longTermData[i] > 0.0) {
                simZeroScatter.set(longTermData[i], simulationData[i]);
                continue;
            }
            ++bothZeroCount;
        }
        System.out.println("Raw scatter range: " + scatter.getMinX() + ", " + scatter.getMaxX() + ", " + scatter.getMinY() + ", " + scatter.getMaxY());
        System.out.println("Raw scatter range: " + simZeroScatter.getMinX() + ", " + simZeroScatter.getMaxX() + ", " + simZeroScatter.getMinY() + ", " + simZeroScatter.getMaxY());
        double minRate = Math.min(scatter.getMinX(), scatter.getMinY());
        double maxRate = Math.max(scatter.getMaxX(), scatter.getMaxY());
        if (simZeroScatter.size() > 0) {
            minRate = Math.min(minRate, simZeroScatter.getMinX());
            maxRate = Math.max(maxRate, simZeroScatter.getMaxX());
        }
        if (maxRate == minRate) {
            maxRate *= 10.0;
        }
        System.out.println("minRate=" + minRate + ", maxRate=" + maxRate);
        Range range = new Range(Math.pow(10.0, Math.floor(Math.log10(minRate))), Math.pow(10.0, Math.ceil(Math.log10(maxRate))));
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        DefaultXY_DataSet line = new DefaultXY_DataSet();
        line.set(range.getLowerBound(), range.getLowerBound());
        line.set(range.getUpperBound(), range.getUpperBound());
        funcs.add(line);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        funcs.add(scatter);
        scatter.setName(scatter.size() + "/" + simulationData.length + " Both Nonzero");
        chars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 3.0f, Color.BLACK));
        if (simZeroScatter.size() > 0) {
            DefaultXY_DataSet modZeroScatter = new DefaultXY_DataSet();
            for (int i = 0; i < simZeroScatter.size(); ++i) {
                modZeroScatter.set(simZeroScatter.getX(i), range.getLowerBound());
            }
            funcs.add(modZeroScatter);
            modZeroScatter.setName(modZeroScatter.size() + "/" + simulationData.length + " Zero In Simulations");
            chars.add(new PlotCurveCharacterstics(PlotSymbol.X, 3.0f, Color.RED));
            System.out.println(simZeroScatter.size() + "/" + simulationData.length + " values are zero in simulations and nonzero long term");
        }
        if (bothZeroCount > 0) {
            System.out.println(bothZeroCount + "/" + simulationData.length + " values are zero in both simulations and long term");
        }
        PlotSpec spec = new PlotSpec(funcs, chars, title, "Long Term " + quantity, "Simulation " + quantity);
        if (simZeroScatter.size() > 0) {
            spec.setLegendVisible(true);
        }
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, true, true, range, range);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    private static void plotStationarity(List<? extends List<ETAS_EqkRupture>> catalogs, double duration, File outputDir) throws IOException {
        if (duration < 0.0) {
            for (List<ETAS_EqkRupture> list : catalogs) {
                duration = Math.max(duration, ETAS_MultiSimAnalysisTools.calcDurationYears(list));
            }
        }
        double delta = duration <= 200.0 ? 10.0 : (duration > 5000.0 ? 200.0 : (duration > 1000.0 ? 100.0 : 50.0));
        double histDuration = duration > 5000.0 ? duration * 0.995 : duration * 0.98;
        HistogramFunction xVals = HistogramFunction.getEncompassingHistogram(0.0, histDuration, delta);
        Preconditions.checkState((xVals.size() > 1 ? 1 : 0) != 0);
        double annualRateEachBin = 1.0 / delta;
        double[][] momRatesEach = new double[xVals.size()][catalogs.size()];
        double[][] m5RatesEach = new double[xVals.size()][catalogs.size()];
        for (int i = 0; i < catalogs.size(); ++i) {
            List<ETAS_EqkRupture> catalog = catalogs.get(i);
            for (ETAS_EqkRupture rup : catalog) {
                double rupTimeYears = ETAS_MultiSimAnalysisTools.calcEventTimeYears(catalog, rup);
                int xIndex = xVals.getXIndex(rupTimeYears);
                if (xIndex < 0) {
                    System.out.println("What? bad x index: " + xIndex);
                    System.out.println("Rup time: " + rupTimeYears);
                    System.out.println("Catalog Start Time: " + ETAS_MultiSimAnalysisTools.calcEventTimeYears(catalog, catalog.get(0)));
                    System.out.println("Hist first bin: " + xVals.getMinX() + " (delta=" + delta + ")");
                }
                Preconditions.checkState((xIndex >= 0 ? 1 : 0) != 0);
                if (rup.getMag() >= 5.0) {
                    double[] dArray = m5RatesEach[xIndex];
                    int n = i;
                    dArray[n] = dArray[n] + annualRateEachBin;
                }
                double moment = MagUtils.magToMoment(rup.getMag());
                double[] dArray = momRatesEach[xIndex];
                int n = i;
                dArray[n] = dArray[n] + moment * annualRateEachBin;
            }
        }
        EvenlyDiscretizedFunc momRateMean = new EvenlyDiscretizedFunc(xVals.getMinX(), xVals.getMaxX(), xVals.size());
        EvenlyDiscretizedFunc momRateLower = new EvenlyDiscretizedFunc(xVals.getMinX(), xVals.getMaxX(), xVals.size());
        EvenlyDiscretizedFunc momRateUpper = new EvenlyDiscretizedFunc(xVals.getMinX(), xVals.getMaxX(), xVals.size());
        for (int i = 0; i < xVals.size(); ++i) {
            double mean = StatUtils.mean((double[])momRatesEach[i]);
            double lower = StatUtils.percentile((double[])momRatesEach[i], (double)2.5);
            double upper = StatUtils.percentile((double[])momRatesEach[i], (double)97.5);
            momRateMean.set(i, mean);
            momRateLower.set(i, lower);
            momRateUpper.set(i, upper);
        }
        UncertainArbDiscFunc momRateDataset = new UncertainArbDiscFunc(momRateMean, momRateLower, momRateUpper);
        EvenlyDiscretizedFunc m5RateMean = new EvenlyDiscretizedFunc(xVals.getMinX(), xVals.getMaxX(), xVals.size());
        EvenlyDiscretizedFunc m5RateLower = new EvenlyDiscretizedFunc(xVals.getMinX(), xVals.getMaxX(), xVals.size());
        EvenlyDiscretizedFunc m5RateUpper = new EvenlyDiscretizedFunc(xVals.getMinX(), xVals.getMaxX(), xVals.size());
        for (int i = 0; i < xVals.size(); ++i) {
            double mean = StatUtils.mean((double[])m5RatesEach[i]);
            double lower = StatUtils.percentile((double[])m5RatesEach[i], (double)2.5);
            double upper = StatUtils.percentile((double[])m5RatesEach[i], (double)97.5);
            m5RateMean.set(i, mean);
            m5RateLower.set(i, lower);
            m5RateUpper.set(i, upper);
        }
        UncertainArbDiscFunc m5RateDataset = new UncertainArbDiscFunc(m5RateMean, m5RateLower, m5RateUpper);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(momRateDataset);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN_TRANS, 1.0f, Color.BLUE));
        funcs.add(momRateDataset);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, PlotSymbol.FILLED_CIRCLE, 4.0f, Color.BLACK));
        String prefix = "stationariy_mom_rate";
        PlotSpec spec = new PlotSpec(funcs, chars, "Moment Rate Over Time (" + (int)delta + "yr bins)", "Years", "Annual Moment Rate (N-m)");
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, true, null, new Range(momRateDataset.getLowerMinY(), momRateDataset.getUpperMaxY()));
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
        funcs = Lists.newArrayList();
        funcs.add(m5RateDataset);
        funcs.add(m5RateDataset);
        prefix = "stationariy_m5_rate";
        spec = new PlotSpec(funcs, chars, "M\u22655 Rate Over Time (" + (int)delta + "yr bins)", "Years", "Annual M\u22655 Rate");
        gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, false, null, new Range(m5RateDataset.getLowerMinY(), m5RateDataset.getUpperMaxY()));
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    public static void plotSubSectRecurrenceHist(List<? extends List<ETAS_EqkRupture>> catalogs, FaultSystemRupSet rupSet, int sectIndex, File outputDir, double targetRI) throws IOException {
        HashSet<Integer> ruptures = new HashSet<Integer>(rupSet.getRupturesForSection(sectIndex));
        double numYrsForProb = 10.0;
        double aveNumInNumYrs = 0.0;
        int numFirst = 0;
        int numFirstSpont = 0;
        ArrayList intervals = Lists.newArrayList();
        double maxValue = 0.0;
        double sum = 0.0;
        double meanFirstHalf = 0.0;
        double meanSecondHalf = 0.0;
        double meanFirstInterval = 0.0;
        double meanSecondInterval = 0.0;
        int numFirstHalf = 0;
        int numSecondHalf = 0;
        int numFirstInterval = 0;
        int numSecondInterval = 0;
        double probOccurInNumyrs = 0.0;
        int numSpontaneous = 0;
        int totNumEvents = 0;
        List<ETAS_EqkRupture> firstCatalog = catalogs.get(0);
        double simulationDuration = ETAS_MultiSimAnalysisTools.calcEventTimeYears(firstCatalog, firstCatalog.get(firstCatalog.size() - 1));
        for (List<ETAS_EqkRupture> list : catalogs) {
            double prevTime = -1.0;
            boolean firstInterval = true;
            boolean secondInterval = false;
            for (ETAS_EqkRupture rup : list) {
                if (rup.getFSSIndex() < 0 || !ruptures.contains(rup.getFSSIndex())) continue;
                totNumEvents = (int)((double)totNumEvents + 1.0);
                double myTime = ETAS_MultiSimAnalysisTools.calcEventTimeYears(list, rup);
                if (rup.getGeneration() == 0) {
                    ++numSpontaneous;
                }
                if (prevTime == -1.0) {
                    if (myTime <= numYrsForProb) {
                        probOccurInNumyrs += 1.0;
                        aveNumInNumYrs += 1.0;
                    }
                    ++numFirst;
                    if (rup.getGeneration() == 0) {
                        ++numFirstSpont;
                    }
                }
                if (prevTime >= 0.0) {
                    if (myTime <= numYrsForProb) {
                        aveNumInNumYrs += 1.0;
                    }
                    double interval = myTime - prevTime;
                    intervals.add(interval);
                    maxValue = Math.max(maxValue, interval);
                    sum += interval;
                    if (secondInterval) {
                        meanSecondInterval += interval;
                        ++numSecondInterval;
                        secondInterval = false;
                    }
                    if (firstInterval) {
                        meanFirstInterval += interval;
                        ++numFirstInterval;
                        firstInterval = false;
                        secondInterval = true;
                    }
                    if (myTime <= simulationDuration / 2.0) {
                        meanFirstHalf += interval;
                        ++numFirstHalf;
                    } else {
                        meanSecondHalf += interval;
                        ++numSecondHalf;
                    }
                }
                prevTime = myTime;
            }
        }
        double mean = sum / (double)intervals.size();
        meanFirstHalf /= (double)numFirstHalf;
        meanSecondHalf /= (double)numSecondHalf;
        meanFirstInterval /= (double)numFirstInterval;
        meanSecondInterval /= (double)numSecondInterval;
        String info = "Num Catalogs = " + catalogs.size() + "\n";
        if (!Double.isNaN(targetRI)) {
            info = info + "targetRI = " + (float)targetRI + "\n";
        }
        info = info + "meanRI = " + (float)mean + "\n";
        info = info + "intervals.size() = " + intervals.size() + "\n";
        double fracSpontaneous = (double)numSpontaneous / (double)totNumEvents;
        info = info + "numSpontaneous = " + numSpontaneous + "\t(" + (float)fracSpontaneous + ")\n";
        double testPartRate = (double)totNumEvents / ((double)catalogs.size() * simulationDuration);
        info = info + "testPartRate = " + (float)testPartRate + "\t1/0/testPartRate=" + (float)(1.0 / testPartRate) + "\n";
        double meanFiltered = 0.0;
        int numFiltered = 0;
        Iterator interval = intervals.iterator();
        while (interval.hasNext()) {
            double ri = (Double)interval.next();
            if (!(ri / mean > 0.1)) continue;
            meanFiltered += ri;
            ++numFiltered;
        }
        info = info + "meanFiltered = " + (float)(meanFiltered /= (double)numFiltered) + "\t(RIs within first 10% of ave RI excluded)\n";
        info = info + "numFiltered = " + numFiltered + "\n";
        info = info + "meanFirstHalf = " + (float)meanFirstHalf + "\t(" + numFirstHalf + ")\n";
        info = info + "meanSecondHalf = " + (float)meanSecondHalf + "\t(" + numSecondHalf + ")\n";
        info = info + "meanFirstInterval = " + (float)meanFirstInterval + "\t(" + numFirstInterval + ")\n";
        info = info + "meanSecondInterval = " + (float)meanSecondInterval + "\t(" + numSecondInterval + ")\n";
        info = info + "numFirstSpontaneous=" + numFirstSpont + "\n";
        info = info + "fractFirstSpontaneous=" + (float)numFirstSpont / (float)numFirst + "\n";
        info = info + "Prob one or more in " + numYrsForProb + " years =" + (float)(probOccurInNumyrs /= (double)catalogs.size()) + "\n";
        info = info + "Ave num in " + numYrsForProb + " years =" + (float)(aveNumInNumYrs /= (double)catalogs.size()) + "\n";
        System.out.println(info);
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(0.0, maxValue, 0.1 * mean);
        hist.setName("Histogram");
        hist.setInfo(info);
        Iterator ri = intervals.iterator();
        while (ri.hasNext()) {
            double interval2 = (Double)ri.next();
            hist.add(interval2, 1.0);
        }
        hist.normalizeBySumOfY_Vals();
        hist.scale(1.0 / hist.getDelta());
        Range yRange = new Range(0.0, 0.016);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        DecimalFormat df = new DecimalFormat("0.0");
        funcs.add(hist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        String prefix = "sub_sect_recurrence_" + sectIndex;
        DefaultXY_DataSet meanLine = new DefaultXY_DataSet();
        meanLine.set(mean, yRange.getLowerBound());
        meanLine.set(mean, yRange.getUpperBound());
        meanLine.setName("Mean=" + df.format(mean));
        funcs.add(meanLine);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.CYAN));
        double median = DataUtils.median(Doubles.toArray((Collection)intervals));
        DefaultXY_DataSet medianLine = new DefaultXY_DataSet();
        medianLine.set(median, yRange.getLowerBound());
        medianLine.set(median, yRange.getUpperBound());
        medianLine.setName("Median=" + df.format(median));
        funcs.add(medianLine);
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        double mode = hist.getX(hist.getXindexForMaxY());
        DefaultXY_DataSet modeLine = new DefaultXY_DataSet();
        modeLine.set(mode, hist.getMaxY());
        modeLine.setName("Mode=" + df.format(mode));
        funcs.add(modeLine);
        chars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_CIRCLE, 2.0f, Color.RED));
        if (!Double.isNaN(targetRI)) {
            DefaultXY_DataSet targetLine = new DefaultXY_DataSet();
            targetLine.set(targetRI, yRange.getLowerBound());
            targetLine.set(targetRI, yRange.getUpperBound());
            targetLine.setName("Target=" + df.format(targetRI));
            funcs.add(targetLine);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GREEN));
        }
        PlotSpec spec = new PlotSpec(funcs, chars, rupSet.getFaultSectionData(sectIndex).getName() + " Recurrence Intervals", "Years", "Density");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, false, null, yRange);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    public static void plotSubSectRecurrenceIntervalVsTime(List<? extends List<ETAS_EqkRupture>> catalogs, FaultSystemRupSet rupSet, int sectIndex, File outputDir, double targetRI) throws IOException {
        HashSet<Integer> ruptures = new HashSet<Integer>(rupSet.getRupturesForSection(sectIndex));
        DefaultXY_DataSet riVsTimeScatterFunc = new DefaultXY_DataSet();
        double maxValue = 0.0;
        double sum = 0.0;
        int totNumEvents = 0;
        List<ETAS_EqkRupture> firstCatalog = catalogs.get(0);
        double simulationDuration = ETAS_MultiSimAnalysisTools.calcEventTimeYears(firstCatalog, firstCatalog.get(firstCatalog.size() - 1));
        for (List<ETAS_EqkRupture> list : catalogs) {
            double prevTime = -1.0;
            boolean firstInterval = true;
            boolean secondInterval = false;
            for (ETAS_EqkRupture rup : list) {
                if (rup.getFSSIndex() < 0 || !ruptures.contains(rup.getFSSIndex())) continue;
                totNumEvents = (int)((double)totNumEvents + 1.0);
                double myTime = ETAS_MultiSimAnalysisTools.calcEventTimeYears(list, rup);
                if (prevTime >= 0.0) {
                    double interval = myTime - prevTime;
                    riVsTimeScatterFunc.set(myTime, interval);
                    maxValue = Math.max(maxValue, interval);
                    sum += interval;
                }
                prevTime = myTime;
            }
        }
        double mean = sum / (double)riVsTimeScatterFunc.size();
        String info = "Num Catalogs = " + catalogs.size() + "\n";
        if (!Double.isNaN(targetRI)) {
            info = info + "targetRI = " + (float)targetRI + "\n";
        }
        info = info + "meanRI = " + (float)mean + "\n";
        info = info + "num intervals = " + riVsTimeScatterFunc.size() + "\n";
        riVsTimeScatterFunc.setName("RI vs Time");
        riVsTimeScatterFunc.setInfo(info);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        DecimalFormat df = new DecimalFormat("0.0");
        funcs.add(riVsTimeScatterFunc);
        chars.add(new PlotCurveCharacterstics(PlotSymbol.X, 2.0f, Color.BLACK));
        String prefix = "sub_sect_RIvsTime_" + sectIndex;
        DefaultXY_DataSet meanLine = new DefaultXY_DataSet();
        meanLine.set(0.0, mean);
        meanLine.set(simulationDuration, mean);
        meanLine.setName("Mean=" + df.format(mean));
        funcs.add(meanLine);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        if (!Double.isNaN(targetRI)) {
            DefaultXY_DataSet targetLine = new DefaultXY_DataSet();
            targetLine.set(0.0, targetRI);
            targetLine.set(simulationDuration, targetRI);
            targetLine.setName("Target=" + df.format(targetRI));
            funcs.add(targetLine);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN));
        }
        PlotSpec spec = new PlotSpec(funcs, chars, rupSet.getFaultSectionData(sectIndex).getName() + " Recurrence Intervals vs Time", "Years", "RI (years)");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        Range yRange = new Range(0.0, riVsTimeScatterFunc.getMaxY());
        gp.drawGraphPanel(spec, false, false, null, yRange);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    public static void plotNormRecurrenceIntForAllSubSectHist(List<? extends List<ETAS_EqkRupture>> catalogs, FaultSystemSolutionERF_ETAS erf, File outputDir) throws IOException {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        double[] longTermRateOfFltSysRup = erf.getLongTermRateOfFltSysRupInERF();
        double[] longTermPartRateForSectArray = new double[rupSet.getNumSections()];
        for (int r = 0; r < rupSet.getNumRuptures(); ++r) {
            List<Integer> sectIndices = rupSet.getSectionsIndicesForRup(r);
            for (int s = 0; s < sectIndices.size(); ++s) {
                int sectID;
                int n = sectID = sectIndices.get(s).intValue();
                longTermPartRateForSectArray[n] = longTermPartRateForSectArray[n] + longTermRateOfFltSysRup[r];
            }
        }
        ArrayList intervals = Lists.newArrayList();
        double maxValue = 0.0;
        double sum = 0.0;
        for (List<ETAS_EqkRupture> list : catalogs) {
            double[] prevTime = new double[rupSet.getNumSections()];
            for (int i = 0; i < rupSet.getNumSections(); ++i) {
                prevTime[i] = -1.0;
            }
            for (ETAS_EqkRupture rup : list) {
                if (rup.getFSSIndex() < 0) continue;
                double myTime = ETAS_MultiSimAnalysisTools.calcEventTimeYears(list, rup);
                for (int sectID : rupSet.getSectionsIndicesForRup(rup.getFSSIndex())) {
                    if (prevTime[sectID] >= 0.0) {
                        double interval = (myTime - prevTime[sectID]) * longTermPartRateForSectArray[sectID];
                        intervals.add(interval);
                        maxValue = Math.max(maxValue, interval);
                        sum += interval;
                    }
                    prevTime[sectID] = myTime;
                }
            }
        }
        double mean = sum / (double)intervals.size();
        String info = "Num Catalogs = " + catalogs.size() + "\n";
        info = info + "meanNormRI = " + (float)mean + "\n";
        info = info + "intervals.size() = " + intervals.size() + "\n";
        double meanFiltered = 0.0;
        int numFiltered = 0;
        Iterator iterator = intervals.iterator();
        while (iterator.hasNext()) {
            double ri = (Double)iterator.next();
            if (!(ri > 0.1)) continue;
            meanFiltered += ri;
            ++numFiltered;
        }
        info = info + "meanFiltered = " + (float)(meanFiltered /= (double)numFiltered) + "\t(RIs within first 10% of ave RI excluded)\n";
        info = info + "numFiltered = " + numFiltered + "\n";
        System.out.println(info);
        HistogramFunction hist = HistogramFunction.getEncompassingHistogram(0.0, maxValue, 0.1);
        hist.setName("Histogram");
        hist.setInfo(info);
        Iterator ri = intervals.iterator();
        while (ri.hasNext()) {
            double interval = (Double)ri.next();
            hist.add(interval, 1.0);
        }
        hist.normalizeBySumOfY_Vals();
        hist.scale(1.0 / hist.getDelta());
        Range yRange = new Range(0.0, 2.6);
        Range xRange = new Range(0.0, 5.0);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(hist);
        chars.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        String prefix = "all_sub_sect__norm_recurrence_int_hist";
        PlotSpec spec = new PlotSpec(funcs, chars, "Norm Recurrence Intervals for All Sections", "Normalized RI", "Density");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, false, xRange, yRange);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
    }

    public static void plotSubSectNuclMagFreqDist(List<? extends List<ETAS_EqkRupture>> catalogs, FaultSystemSolutionERF_ETAS erf, int sectIndex, File outputDir) throws IOException {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        HashSet<Integer> ruptures = new HashSet<Integer>(rupSet.getRupturesForSection(sectIndex));
        FaultPolyMgr faultPolyMgr = FaultPolyMgr.create(rupSet.getFaultSectionDataList(), 12.0);
        Region subSectPoly = faultPolyMgr.getPoly(sectIndex);
        SummedMagFreqDist mfdSupra = new SummedMagFreqDist(2.55, 8.45, 60);
        SummedMagFreqDist mfdSupra2 = new SummedMagFreqDist(2.55, 8.45, 60);
        SummedMagFreqDist mfdSub = new SummedMagFreqDist(2.55, 8.45, 60);
        List<ETAS_EqkRupture> firstCatalog = catalogs.get(0);
        double catalogDuration = ETAS_MultiSimAnalysisTools.calcEventTimeYears(firstCatalog, firstCatalog.get(firstCatalog.size() - 1));
        double normFactor = catalogDuration * (double)catalogs.size();
        for (List<ETAS_EqkRupture> list : catalogs) {
            for (ETAS_EqkRupture rup : list) {
                if (subSectPoly.contains(rup.getHypocenterLocation())) {
                    if (rup.getFSSIndex() < 0) {
                        int index = mfdSupra.getClosestXIndex(rup.getMag());
                        mfdSub.add(index, 1.0 / normFactor);
                    } else {
                        int index = mfdSupra.getClosestXIndex(rup.getMag());
                        mfdSupra.add(index, 1.0 / normFactor);
                    }
                }
                if (rup.getFSSIndex() < 0 || !ruptures.contains(rup.getFSSIndex())) continue;
                List<Integer> sectionList = rupSet.getSectionsIndicesForRup(rup.getFSSIndex());
                FaultSection sectData = rupSet.getFaultSectionData(sectIndex);
                double sectArea = sectData.getTraceLength() * sectData.getReducedDownDipWidth();
                double rupArea = 0.0;
                for (int sectID : sectionList) {
                    sectData = rupSet.getFaultSectionData(sectID);
                    rupArea += sectData.getTraceLength() * sectData.getReducedDownDipWidth();
                }
                int index = mfdSupra.getClosestXIndex(rup.getMag());
                mfdSupra2.add(index, sectArea / (normFactor * rupArea));
            }
        }
        mfdSupra.setName("Simulated Supra MFD for " + rupSet.getFaultSectionData(sectIndex).getName());
        mfdSupra.setInfo("actually nucleated in section");
        mfdSupra2.setName("Simulated Supra Alt MFD for " + rupSet.getFaultSectionData(sectIndex).getName());
        mfdSupra2.setInfo("nucleation probability from section  and rupture area");
        mfdSub.setName("Simulated SubSeis MFD for " + rupSet.getFaultSectionData(sectIndex).getName());
        ArrayList funcs = Lists.newArrayList();
        ArrayList arrayList = Lists.newArrayList();
        funcs.add(mfdSupra);
        funcs.add(mfdSupra2);
        funcs.add(mfdSub);
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        String prefix = "sub_sect_nucl_mfd_" + sectIndex;
        GraphWindow plotGraph = new GraphWindow(funcs, rupSet.getFaultSectionData(sectIndex).getName() + " Nucl. MFDs", arrayList);
        plotGraph.setX_AxisLabel("Magnitude (M)");
        plotGraph.setY_AxisLabel("Rate (per yr)");
        plotGraph.setY_AxisRange(1.0E-7, 0.1);
        plotGraph.setYLog(true);
        plotGraph.setPlotLabelFontSize(18);
        plotGraph.setAxisLabelFontSize(22);
        plotGraph.setTickLabelFontSize(20);
        try {
            plotGraph.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
            plotGraph.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void plotSubSectPartMagFreqDist(List<? extends List<ETAS_EqkRupture>> catalogs, FaultSystemSolutionERF_ETAS erf, int sectIndex, File outputDir) throws IOException {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        HashSet<Integer> ruptures = new HashSet<Integer>(rupSet.getRupturesForSection(sectIndex));
        SummedMagFreqDist mfd = new SummedMagFreqDist(5.05, 8.45, 35);
        for (List<ETAS_EqkRupture> list : catalogs) {
            for (ETAS_EqkRupture rup : list) {
                if (rup.getFSSIndex() < 0 || !ruptures.contains(rup.getFSSIndex())) continue;
                mfd.addResampledMagRate(rup.getMag(), 1.0, true);
            }
        }
        List<ETAS_EqkRupture> firstCatalog = catalogs.get(0);
        double d = ETAS_MultiSimAnalysisTools.calcEventTimeYears(firstCatalog, firstCatalog.get(firstCatalog.size() - 1));
        mfd.scale(1.0 / (d * (double)catalogs.size()));
        mfd.setName("Simulated MFD for " + rupSet.getFaultSectionData(sectIndex).getName());
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(mfd);
        funcs.add(mfd.getCumRateDistWithOffset());
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLUE));
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        SummedMagFreqDist targetMFD = FaultSysSolutionERF_Calc.calcParticipationMFDForAllSects(erf, 5.05, 8.45, 35)[sectIndex];
        targetMFD.setName("Target MFD for " + rupSet.getFaultSectionData(sectIndex).getName());
        funcs.add(targetMFD);
        funcs.add(targetMFD.getCumRateDistWithOffset());
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
        String prefix = "sub_sect_part_mfd_" + sectIndex;
        GraphWindow plotGraph = new GraphWindow(funcs, rupSet.getFaultSectionData(sectIndex).getName() + " Part. MFDs", chars);
        plotGraph.setX_AxisLabel("Magnitude (M)");
        plotGraph.setY_AxisLabel("Rate (per yr)");
        plotGraph.setY_AxisRange(1.0E-7, 0.1);
        plotGraph.setYLog(true);
        plotGraph.setPlotLabelFontSize(18);
        plotGraph.setAxisLabelFontSize(22);
        plotGraph.setTickLabelFontSize(20);
        try {
            plotGraph.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
            plotGraph.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void plotCumNumWithTimeForSection(List<? extends List<ETAS_EqkRupture>> catalogs, FaultSystemSolutionERF_ETAS erf, int sectIndex, File outputDir) throws IOException {
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        HashSet<Integer> ruptures = new HashSet<Integer>(rupSet.getRupturesForSection(sectIndex));
        ArbitrarilyDiscretizedFunc cumNumWithTimeFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc comparisonLineFunc = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc tempFunc = new ArbitrarilyDiscretizedFunc();
        for (List<ETAS_EqkRupture> list : catalogs) {
            for (ETAS_EqkRupture rup : list) {
                if (rup.getFSSIndex() < 0 || !ruptures.contains(rup.getFSSIndex())) continue;
                tempFunc.set(ETAS_MultiSimAnalysisTools.calcEventTimeYears(list, rup), 1.0);
            }
        }
        double cumVal = 0.0;
        double numSimulations = catalogs.size();
        for (int i = 0; i < tempFunc.size(); ++i) {
            cumNumWithTimeFunc.set(tempFunc.getX(i), cumVal += 1.0 / numSimulations);
        }
        cumNumWithTimeFunc.setName("cumNumWithTimeFunc");
        comparisonLineFunc.set(cumNumWithTimeFunc.get(0));
        comparisonLineFunc.set(cumNumWithTimeFunc.get(cumNumWithTimeFunc.size() - 1));
        comparisonLineFunc.setName("comparisonLineFunc");
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(cumNumWithTimeFunc);
        funcs.add(comparisonLineFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.BLACK));
        String prefix = "sub_sect_cumNumWithTime_" + sectIndex;
        GraphWindow plotGraph = new GraphWindow(funcs, rupSet.getFaultSectionData(sectIndex).getName(), chars);
        plotGraph.setX_AxisLabel("Time (years)");
        plotGraph.setY_AxisLabel("Cum Num");
        plotGraph.setPlotLabelFontSize(18);
        plotGraph.setAxisLabelFontSize(22);
        plotGraph.setTickLabelFontSize(20);
        try {
            plotGraph.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
            plotGraph.saveAsTXT(new File(outputDir, prefix + ".txt").getAbsolutePath());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void plotConditionalHypocenterDist(List<? extends List<ETAS_EqkRupture>> catalogs, File outputDir, FaultSystemRupSet rupSet) throws IOException {
        HistogramFunction hist = new HistogramFunction(0.025, 0.475, 10);
        for (List<ETAS_EqkRupture> list : catalogs) {
            for (ETAS_EqkRupture rup : list) {
                if (rup.getFSSIndex() < 0) continue;
                RuptureSurface surf = rupSet.getSurfaceForRupture(rup.getFSSIndex(), 1.0);
                Location hypo = rup.getHypocenterLocation();
                FaultTrace upperEdge = surf.getEvenlyDiscritizedUpperEdge();
                int closest = -1;
                double closestDist = Double.POSITIVE_INFINITY;
                for (int i = 0; i < upperEdge.size(); ++i) {
                    double dist = LocationUtils.horzDistanceFast(hypo, (Location)upperEdge.get(i));
                    if (!(dist < closestDist)) continue;
                    closest = i;
                    closestDist = dist;
                }
                double das = 0.0;
                double totLen = 0.0;
                for (int i = 1; i < upperEdge.size(); ++i) {
                    double d = LocationUtils.horzDistanceFast((Location)upperEdge.get(i - 1), (Location)upperEdge.get(i));
                    if (i <= closest) {
                        das += d;
                    }
                    totLen += d;
                }
                if ((das /= totLen) > 0.5) {
                    das = 1.0 - das;
                }
                hist.add(das, 1.0);
            }
        }
        hist.normalizeBySumOfY_Vals();
        ArrayList funcs = Lists.newArrayList();
        ArrayList arrayList = Lists.newArrayList();
        funcs.add(hist);
        arrayList.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 1.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(funcs, arrayList, "Conditional Hypocenter Distribution", "Normalized Distance Along Strike", "Density");
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, false, null, null);
        gp.setYLog(true);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(new File(outputDir, "cond_hypo_dist.png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, "cond_hypo_dist.pdf").getAbsolutePath());
        gp.saveAsTXT(new File(outputDir, "cond_hypo_dist.txt").getAbsolutePath());
    }

    public static void plotScalesOfHazardChange(List<? extends List<ETAS_EqkRupture>> childrenCatalogs, List<? extends List<ETAS_EqkRupture>> catalogs, ETAS_Simulator.TestScenario scenario, long ot, FaultSystemSolutionERF erf, File outputDir, String name, double inputDuration, boolean rates, boolean subSects) throws IOException {
        double[] mags = new double[]{0.0, 6.7};
        ETAS_MultiSimAnalysisTools.plotScalesOfHazardChange(childrenCatalogs, catalogs, null, scenario, ot, erf, outputDir, name, inputDuration, rates, subSects, null, mags);
    }

    /*
     * WARNING - void declaration
     */
    public static void plotScalesOfHazardChange(List<? extends List<ETAS_EqkRupture>> childrenCatalogs, List<? extends List<ETAS_EqkRupture>> catalogs, List<? extends List<ETAS_EqkRupture>> childrenCatalogs2, ETAS_Simulator.TestScenario scenario, long ot, FaultSystemSolutionERF erf, File outputDir, String name, double inputDuration, boolean rates, boolean subSects, HashSet<Integer> sects, double[] mags) throws IOException {
        Iterator<? extends FaultSection> scenarioLocs;
        boolean containsSpontaneous = false;
        if (catalogs != null && childrenCatalogs2 == null) {
            block0: for (List<ETAS_EqkRupture> list : catalogs) {
                if (containsSpontaneous) break;
                for (ETAS_EqkRupture eTAS_EqkRupture : list) {
                    if (eTAS_EqkRupture.getGeneration() != 0) continue;
                    containsSpontaneous = true;
                    continue block0;
                }
            }
        }
        ArrayList spontOnlyCatalogs = null;
        if (containsSpontaneous) {
            void var17_17;
            spontOnlyCatalogs = Lists.newArrayList();
            boolean bl = false;
            while (var17_17 < catalogs.size()) {
                HashSet<Integer> children = new HashSet<Integer>();
                for (ETAS_EqkRupture eTAS_EqkRupture : childrenCatalogs.get((int)var17_17)) {
                    children.add(eTAS_EqkRupture.getID());
                }
                ArrayList arrayList = Lists.newArrayList();
                for (ETAS_EqkRupture rup3 : catalogs.get((int)var17_17)) {
                    if (children.contains(rup3.getID())) continue;
                    arrayList.add(rup3);
                }
                spontOnlyCatalogs.add(arrayList);
                ++var17_17;
            }
        }
        boolean bl = false;
        int etasNumX = 80;
        int n = 20;
        double[] dArray = new double[]{1.1407711613050422E-4, 0.0027378507871321013, 0.019164955509924708, 0.08213552361396304, 1.0, 10.0, 30.0, 100.0};
        EvenlyDiscretizedFunc evenlyDiscrTimes = new EvenlyDiscretizedFunc(Math.log(dArray[0]), Math.log(dArray[dArray.length - 1]), etasNumX);
        ArbitrarilyDiscretizedFunc etasTimesFunc = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : evenlyDiscrTimes) {
            etasTimesFunc.set(Math.exp(pt.getX()), 0.0);
        }
        for (int i = 1; i < dArray.length - 1; ++i) {
            double x = dArray[i];
            etasTimesFunc.set(x, 0.0);
        }
        evenlyDiscrTimes = new EvenlyDiscretizedFunc(Math.log(dArray[0]), Math.log(dArray[dArray.length - 1]), n);
        ArbitrarilyDiscretizedFunc u3TimesFunc = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : evenlyDiscrTimes) {
            u3TimesFunc.set(Math.exp(pt.getX()), 0.0);
        }
        for (Object x : (Object)dArray) {
            u3TimesFunc.set((double)x, 0.0);
        }
        double minDist = 30.0;
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        HashMap sectNamesMap = Maps.newHashMap();
        if (sects == null) {
            sects = new HashSet();
            scenarioLocs = Lists.newArrayList();
            if (scenario.getFSS_Index() >= 0) {
                scenarioLocs.addAll(rupSet.getSurfaceForRupture(scenario.getFSS_Index(), 1.0).getUpperEdge());
            } else {
                scenarioLocs.add((FaultSection)((Object)scenario.getLocation()));
            }
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                block10: for (Location loc : faultSection.getFaultTrace()) {
                    Iterator iterator = scenarioLocs.iterator();
                    while (iterator.hasNext()) {
                        Location scenarioLoc = (Location)iterator.next();
                        if (!(LocationUtils.horzDistanceFast(scenarioLoc, loc) < minDist)) continue;
                        if (subSects) {
                            Integer id = faultSection.getSectionId();
                            sects.add(id);
                            sectNamesMap.put(id, faultSection.getName());
                            continue block10;
                        }
                        Integer parentID = faultSection.getParentSectionId();
                        sects.add(parentID);
                        sectNamesMap.put(parentID, faultSection.getParentSectionName());
                        continue block10;
                    }
                }
            }
        } else if (subSects) {
            scenarioLocs = sects.iterator();
            while (scenarioLocs.hasNext()) {
                int n2 = (Integer)((Object)scenarioLocs.next());
                sectNamesMap.put(n2, rupSet.getFaultSectionData(n2).getName());
            }
        } else {
            for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
                if (!sects.contains(faultSection.getParentSectionId())) continue;
                sectNamesMap.put(faultSection.getParentSectionId(), faultSection.getParentSectionName());
            }
        }
        int startYear = ETAS_MultiSimAnalysisTools.calcYearForOT(ot);
        System.out.println("Detected start year: " + startYear);
        for (double mag : mags) {
            int t;
            System.out.println("Calculating scales of change for M>=" + mag);
            HashMap rupsForSect = Maps.newHashMap();
            HashMap funcsTI = Maps.newHashMap();
            HashMap funcsTD = Maps.newHashMap();
            HashMap funcsETAS = Maps.newHashMap();
            HashMap funcsETAS2 = null;
            if (childrenCatalogs2 != null) {
                funcsETAS2 = Maps.newHashMap();
            }
            HashMap funcsETASWithSpont = null;
            HashMap funcsETASSpontOnly = null;
            if (containsSpontaneous) {
                funcsETASWithSpont = Maps.newHashMap();
                funcsETASSpontOnly = Maps.newHashMap();
            }
            HashMap funcsETASOnly = Maps.newHashMap();
            HashMap funcsETASOnlyAfter = Maps.newHashMap();
            for (int sectID : sects) {
                HashSet<Integer> rups = new HashSet<Integer>();
                List<Integer> allRups = subSects ? rupSet.getRupturesForSection(sectID) : rupSet.getRupturesForParentSection(sectID);
                for (int rup : allRups) {
                    if (!(rupSet.getMagForRup(rup) >= mag)) continue;
                    rups.add(rup);
                }
                rupsForSect.put(sectID, rups);
                ArbitrarilyDiscretizedFunc func = new ArbitrarilyDiscretizedFunc();
                func.setName("UCERF3-TI");
                funcsTI.put(sectID, func);
                func = new ArbitrarilyDiscretizedFunc();
                func.setName("UCERF3-TD");
                funcsTD.put(sectID, func);
                func = new ArbitrarilyDiscretizedFunc();
                func.setName("UCERF3-ETAS");
                funcsETAS.put(sectID, func);
                if (funcsETAS2 != null) {
                    func = new ArbitrarilyDiscretizedFunc();
                    func.setName("UCERF3-ETAS2");
                    funcsETAS2.put(sectID, func);
                }
                func = new ArbitrarilyDiscretizedFunc();
                func.setName("UCERF3-ETAS Only");
                funcsETASOnly.put(sectID, func);
                func = new ArbitrarilyDiscretizedFunc();
                func.setName("UCERF3-ETAS Prob After");
                funcsETASOnlyAfter.put(sectID, func);
                if (!containsSpontaneous) continue;
                func = new ArbitrarilyDiscretizedFunc();
                func.setName("UCERF3-ETAS Total");
                funcsETASWithSpont.put(sectID, func);
                func = new ArbitrarilyDiscretizedFunc();
                func.setName("UCERF3-ETAS Non-Scenario");
                funcsETASSpontOnly.put(sectID, func);
            }
            System.out.println("Calculating UCERF3-TI for all durations");
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
            erf.getTimeSpan().setDuration(1.0);
            erf.updateForecast();
            Preconditions.checkState((erf.getTimeSpan().getDuration() == 1.0 ? 1 : 0) != 0);
            for (Integer sectID : sects) {
                double annualRate = ETAS_MultiSimAnalysisTools.calcParticipationRate(erf, (HashSet)rupsForSect.get(sectID), 1.0);
                for (int t2 = 0; t2 < etasTimesFunc.size(); ++t2) {
                    double duration = etasTimesFunc.getX(t2);
                    double rateForDuration = annualRate * duration;
                    double val = rates ? rateForDuration : 1.0 - Math.exp(-rateForDuration);
                    ((ArbitrarilyDiscretizedFunc)funcsTI.get(sectID)).set(duration, val);
                }
            }
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
            erf.setParameter("Historic Open Interval", startYear - 1875);
            erf.getTimeSpan().setStartTime(startYear);
            if (scenario.getFSS_Index() >= 0) {
                long myOT = erf.getTimeSpan().getStartTimeCalendar().getTime().getTime();
                System.out.println("Setting date of occurance for rup " + scenario.getFSS_Index() + " to " + myOT);
                erf.setFltSystemSourceOccurranceTimeForFSSIndex(scenario.getFSS_Index(), myOT);
            }
            System.out.println("Calculating UCERF3-TD (" + u3TimesFunc.size() + " points)");
            for (t = 0; t < u3TimesFunc.size(); ++t) {
                double duration = u3TimesFunc.getX(t);
                System.out.println("Calculating duration: " + duration + " yrs");
                erf.getTimeSpan().setDuration(duration);
                erf.getTimeSpan().setStartTime(startYear);
                erf.updateForecast();
                Preconditions.checkState((erf.getTimeSpan().getDuration() == duration ? 1 : 0) != 0);
                for (Integer parentID : sects) {
                    double val = rates ? ETAS_MultiSimAnalysisTools.calcParticipationRate(erf, (HashSet)rupsForSect.get(parentID), duration) : ETAS_MultiSimAnalysisTools.calcParticipationProb(erf, (HashSet)rupsForSect.get(parentID));
                    ((ArbitrarilyDiscretizedFunc)funcsTD.get(parentID)).set(duration, val);
                }
            }
            System.out.println("Calculating UCERF3-ETAS (" + etasTimesFunc.size() + " points)");
            for (t = 0; t < etasTimesFunc.size(); ++t) {
                double duration = etasTimesFunc.getX(t);
                long maxOT = ot + (long)(duration * 3.15576E10);
                for (Integer parentID : sects) {
                    HashSet rups = (HashSet)rupsForSect.get(parentID);
                    double etasProb = ETAS_MultiSimAnalysisTools.calcETASPartic(childrenCatalogs, ot, maxOT, rups, rates);
                    double tdProb = ((ArbitrarilyDiscretizedFunc)funcsTD.get(parentID)).getInterpolatedY_inLogXLogYDomain(duration);
                    double sum = rates ? etasProb + tdProb : FaultSysSolutionERF_Calc.calcSummedProbs(Lists.newArrayList((Object[])new Double[]{etasProb, tdProb}));
                    ((ArbitrarilyDiscretizedFunc)funcsETAS.get(parentID)).set(duration, sum);
                    if (funcsETAS2 != null) {
                        double etasProb2 = ETAS_MultiSimAnalysisTools.calcETASPartic(childrenCatalogs2, ot, maxOT, rups, rates);
                        double sum2 = rates ? etasProb2 + tdProb : FaultSysSolutionERF_Calc.calcSummedProbs(Lists.newArrayList((Object[])new Double[]{etasProb2, tdProb}));
                        ((ArbitrarilyDiscretizedFunc)funcsETAS2.get(parentID)).set(duration, sum2);
                        etasProb = 0.5 * (etasProb + etasProb2);
                    }
                    if (!((float)duration <= (float)inputDuration)) continue;
                    ((ArbitrarilyDiscretizedFunc)funcsETASOnly.get(parentID)).set(duration, etasProb);
                    if (!containsSpontaneous) continue;
                    double etasProbWithSpont = ETAS_MultiSimAnalysisTools.calcETASPartic(catalogs, ot, maxOT, rups, rates);
                    ((ArbitrarilyDiscretizedFunc)funcsETASWithSpont.get(parentID)).set(duration, etasProbWithSpont);
                    double etasProbSpontOnly = ETAS_MultiSimAnalysisTools.calcETASPartic(spontOnlyCatalogs, ot, maxOT, rups, rates);
                    ((ArbitrarilyDiscretizedFunc)funcsETASSpontOnly.get(parentID)).set(duration, etasProbSpontOnly);
                }
            }
            for (Integer parentID : sects) {
                ArbitrarilyDiscretizedFunc etasOnly = (ArbitrarilyDiscretizedFunc)funcsETASOnly.get(parentID);
                ArbitrarilyDiscretizedFunc etasOnlyAfter = (ArbitrarilyDiscretizedFunc)funcsETASOnlyAfter.get(parentID);
                double maxProb = etasOnly.getMaxY();
                for (int t3 = 0; t3 < etasOnly.size(); ++t3) {
                    double time = etasOnly.getX(t3);
                    double etasProb = etasOnly.getY(t3);
                    double probAfter = maxProb - etasProb;
                    if (!(probAfter > 0.0)) continue;
                    etasOnlyAfter.set(time, probAfter);
                }
            }
            for (Integer sectID : sects) {
                String yAxisLabel;
                if (((HashSet)rupsForSect.get(sectID)).isEmpty() || ((ArbitrarilyDiscretizedFunc)funcsETASOnly.get(sectID)).size() == 0) continue;
                String sectName = (String)sectNamesMap.get(sectID);
                Object prefix = sectName.replaceAll("\\W+", "_");
                String yVal = rates ? "Rate" : "Prob";
                if (mag == 0.0) {
                    prefix = (String)prefix + "_supra_seis";
                    yAxisLabel = "Supra Seis Participation " + yVal;
                } else {
                    prefix = (String)prefix + "_m" + (float)mag;
                    yAxisLabel = "M\u2265" + (float)mag + " Participation " + yVal;
                }
                if (rates) {
                    prefix = (String)prefix + "_rates";
                }
                File file = new File(outputDir, (String)prefix);
                ArrayList funcs = Lists.newArrayList();
                ArrayList chars = Lists.newArrayList();
                funcs.add((XY_DataSet)funcsTI.get(sectID));
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
                funcs.add((XY_DataSet)funcsTD.get(sectID));
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
                if (containsSpontaneous) {
                    funcs.add((XY_DataSet)funcsETASWithSpont.get(sectID));
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GREEN.darker()));
                    funcs.add((XY_DataSet)funcsETASSpontOnly.get(sectID));
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GREEN.darker()));
                }
                if (funcsETAS2 != null) {
                    ArbitrarilyDiscretizedFunc etas1 = (ArbitrarilyDiscretizedFunc)funcsETAS.get(sectID);
                    ArbitrarilyDiscretizedFunc etas2 = (ArbitrarilyDiscretizedFunc)funcsETAS2.get(sectID);
                    ArbitrarilyDiscretizedFunc etasMean = new ArbitrarilyDiscretizedFunc();
                    ArbitrarilyDiscretizedFunc etasLower = new ArbitrarilyDiscretizedFunc();
                    ArbitrarilyDiscretizedFunc etasUpper = new ArbitrarilyDiscretizedFunc();
                    ArbitrarilyDiscretizedFunc etasMeanLower = new ArbitrarilyDiscretizedFunc();
                    ArbitrarilyDiscretizedFunc etasMeanUpper = new ArbitrarilyDiscretizedFunc();
                    for (int i = 0; i < etas1.size(); ++i) {
                        double x = etas1.getX(i);
                        Preconditions.checkState((etas2.getX(i) == x ? 1 : 0) != 0);
                        double val1 = etas1.getY(i);
                        double val2 = etas2.getY(i);
                        double mean = 0.5 * (val1 + val2);
                        Preconditions.checkState((!Double.isNaN(mean) ? 1 : 0) != 0);
                        etasMean.set(x, mean);
                        double[] conf1 = val1 > 1.0 ? new double[]{val1, val1} : ETAS_Utils.getBinomialProportion95confidenceInterval(val1, childrenCatalogs.size());
                        double[] conf2 = val2 > 1.0 ? new double[]{val2, val2} : ETAS_Utils.getBinomialProportion95confidenceInterval(val2, childrenCatalogs2.size());
                        etasMeanLower.set(x, Math.min(val1, val2));
                        etasMeanUpper.set(x, Math.max(val1, val2));
                        etasLower.set(x, Math.min(Math.min(conf1[0], conf2[0]), mean));
                        etasUpper.set(x, Math.max(conf1[1], conf2[1]));
                    }
                    UncertainArbDiscFunc confBounds = new UncertainArbDiscFunc(etasMean, etasLower, etasUpper);
                    UncertainArbDiscFunc meanRange = new UncertainArbDiscFunc(etasMean, etasMeanLower, etasMeanUpper);
                    Color confColor = new Color(255, 120, 120);
                    funcs.add(0, confBounds);
                    chars.add(0, new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN_TRANS, 1.0f, confColor));
                    funcs.add(1, meanRange);
                    chars.add(1, new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, confColor));
                    funcs.add(etasMean);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
                } else {
                    funcs.add((XY_DataSet)funcsETAS.get(sectID));
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
                }
                double minProb = 1.0;
                for (XY_DataSet func : funcs) {
                    for (Point2D pt : func) {
                        if (!(pt.getY() > 0.0)) continue;
                        minProb = Math.min(minProb, pt.getY());
                    }
                }
                minProb *= 0.5;
                funcs.add((XY_DataSet)funcsETASOnly.get(sectID));
                chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.RED));
                if (((ArbitrarilyDiscretizedFunc)funcsETASOnlyAfter.get(sectID)).size() > 0) {
                    funcs.add((XY_DataSet)funcsETASOnlyAfter.get(sectID));
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.MAGENTA));
                }
                ArrayList annotations = Lists.newArrayList();
                for (int i = 0; i < dArray.length; ++i) {
                    Object label;
                    double time = dArray[i];
                    if (time < 1.0) {
                        int days = (int)(time * 365.25 + 0.5);
                        if (days == 30) {
                            label = "1 mo";
                        } else if (days == 7) {
                            label = "1 wk";
                        } else if (time < 0.0027378507871321013) {
                            int hours = (int)(time * 365.25 * 24.0 + 0.5);
                            label = hours + " hr";
                        } else {
                            label = days + " d";
                        }
                    } else {
                        label = (int)time + " yr";
                    }
                    DefaultXY_DataSet xy = new DefaultXY_DataSet();
                    xy.set(time, minProb);
                    xy.set(time, 1.0);
                    funcs.add(xy);
                    chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GRAY));
                    XYTextAnnotation ann = new XYTextAnnotation((String)label, time, 0.9);
                    if (i == 0 && bl || i == dArray.length - 1 && !bl) {
                        ann.setTextAnchor(TextAnchor.TOP_RIGHT);
                        if (!bl) {
                            ann.setY(0.4);
                        }
                    } else {
                        ann.setTextAnchor(TextAnchor.TOP_LEFT);
                    }
                    ann.setFont(new Font("SansSerif", 1, 20));
                    annotations.add(ann);
                }
                for (XY_DataSet func : funcs) {
                    Preconditions.checkState((func.size() > 0 ? 1 : 0) != 0, (String)"Empty func with name: %s", (Object)func.getName());
                }
                PlotSpec spec = new PlotSpec(funcs, chars, sectName, "Forecast Timespan (years)", yAxisLabel);
                spec.setPlotAnnotations(annotations);
                spec.setLegendVisible(true);
                HeadlessGraphPanel gp = new HeadlessGraphPanel();
                gp.setxAxisInverted(bl);
                gp.setUserBounds(dArray[0], dArray[dArray.length - 1], minProb, 1.0);
                ETAS_MultiSimAnalysisTools.setFontSizes(gp);
                gp.drawGraphPanel(spec, true, true);
                gp.getChartPanel().setSize(1000, 800);
                gp.saveAsPNG(file.getAbsolutePath() + ".png");
                gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
                gp.saveAsTXT(file.getAbsolutePath() + ".txt");
            }
        }
    }

    private static double calcETASPartic(List<? extends List<ETAS_EqkRupture>> catalogs, long ot, long maxOT, HashSet<Integer> rups, boolean rates) {
        return ETAS_MultiSimAnalysisTools.calcETASPartic(catalogs, ot, maxOT, rups, rates, null, 0.0);
    }

    private static double calcETASPartic(List<? extends List<ETAS_EqkRupture>> catalogs, long ot, long maxOT, HashSet<Integer> rups, boolean rates, Region region, double minMag) {
        if (rates) {
            return ETAS_MultiSimAnalysisTools.calcETASParticRate(catalogs, ot, maxOT, rups, region, minMag);
        }
        return ETAS_MultiSimAnalysisTools.calcETASParticProb(catalogs, ot, maxOT, rups, region, minMag);
    }

    public static double calcETASParticProb(Iterable<? extends List<ETAS_EqkRupture>> catalogs, long ot, long maxOT, HashSet<Integer> rups, Region region, double minMag) {
        int numWith = 0;
        int total = 0;
        for (List<ETAS_EqkRupture> list : catalogs) {
            boolean found = false;
            for (ETAS_EqkRupture rup : list) {
                Preconditions.checkState((rup.getOriginTime() >= ot ? 1 : 0) != 0, (String)"Bad event time! ot=%s, rupTime=%s", (long)ot, (long)rup.getOriginTime());
                if (rup.getMag() < minMag) continue;
                if (rup.getOriginTime() > maxOT) break;
                if (rup.getFSSIndex() >= 0) {
                    if (!rups.contains(rup.getFSSIndex())) continue;
                    found = true;
                    break;
                }
                if (region == null || !region.contains(rup.getHypocenterLocation())) continue;
                found = true;
                break;
            }
            if (found) {
                ++numWith;
            }
            ++total;
        }
        double etasProb = (double)numWith / (double)total;
        return etasProb;
    }

    public static double calcETASParticRate(List<? extends List<ETAS_EqkRupture>> catalogs, long ot, long maxOT, HashSet<Integer> rups, Region region, double minMag) {
        double rate = 0.0;
        double rateEach = 1.0 / (double)catalogs.size();
        block0: for (List<ETAS_EqkRupture> list : catalogs) {
            for (ETAS_EqkRupture rup : list) {
                Preconditions.checkState((rup.getOriginTime() >= ot ? 1 : 0) != 0, (String)"Bad event time! ot=%s, rupTime=%s", (long)ot, (long)rup.getOriginTime());
                if (rup.getMag() < minMag) continue;
                if (rup.getOriginTime() > maxOT) continue block0;
                if (rup.getFSSIndex() >= 0) {
                    if (!rups.contains(rup.getFSSIndex())) continue;
                    rate += rateEach;
                    continue;
                }
                if (region == null || !region.contains(rup.getHypocenterLocation())) continue;
                rate += rateEach;
            }
        }
        return rate;
    }

    private static double calcParticipationProb(FaultSystemSolutionERF erf, HashSet<Integer> rups) {
        ArrayList probs = Lists.newArrayList();
        for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
            if (!rups.contains(erf.getFltSysRupIndexForSource(sourceID))) continue;
            probs.add(erf.getSource(sourceID).computeTotalProb());
        }
        Preconditions.checkState((rups.size() == probs.size() ? 1 : 0) != 0);
        return FaultSysSolutionERF_Calc.calcSummedProbs(probs);
    }

    private static double calcParticipationRate(FaultSystemSolutionERF erf, HashSet<Integer> rups, double duration) {
        double rate = 0.0;
        for (int sourceID = 0; sourceID < erf.getNumFaultSystemSources(); ++sourceID) {
            if (!rups.contains(erf.getFltSysRupIndexForSource(sourceID))) continue;
            rate += erf.getSource(sourceID).computeTotalEquivMeanAnnualRate(duration) * duration;
        }
        return rate;
    }

    public static int calcYearForOT(long ot) {
        int closest = 0;
        long diff = Long.MAX_VALUE;
        for (int year = 2000; year < 2100; ++year) {
            long myOT = Math.round(((double)year - 1970.0) * 3.15576E10);
            long myDiff = myOT - ot;
            if (myDiff < 0L) {
                myDiff = -myDiff;
            }
            if (myDiff >= diff) continue;
            diff = myDiff;
            closest = year;
        }
        return closest;
    }

    static void plotRegionalMPDs(List<? extends List<ETAS_EqkRupture>> catalogs, ETAS_Simulator.TestScenario scenario, long ot, FaultSystemSolutionERF erf, File outputDir, String name, boolean rates) throws IOException {
        CaliforniaRegions.CA_Region region = scenario == ETAS_Simulator.TestScenario.HAYWIRED_M7 ? new CaliforniaRegions.SF_BOX() : new CaliforniaRegions.LA_BOX();
        String regName = region.getName();
        regName = regName.replaceAll("Region", "");
        regName = regName.replaceAll("_", " ");
        regName = regName.trim();
        String prefix = "one_week_mfd_" + regName.replaceAll("\\W+", "_");
        if (rates) {
            prefix = prefix + "_rates";
        }
        ETAS_MultiSimAnalysisTools.plotRegionalMPDs(catalogs, null, scenario, region, ot, erf, outputDir, name, prefix, rates);
    }

    static void plotRegionalMPDs(List<? extends List<ETAS_EqkRupture>> catalogs1, List<? extends List<ETAS_EqkRupture>> catalogs2, ETAS_Simulator.TestScenario scenario, Region region, long ot, FaultSystemSolutionERF erf, File outputDir, String name, String prefix, boolean rates) throws IOException {
        EvenlyDiscretizedFunc tdMFD;
        EvenlyDiscretizedFunc tiMFD;
        double fssMaxMag = erf.getSolution().getRupSet().getMaxMag();
        double duration = 0.019164955509924708;
        double minMag = 5.0;
        int numMag = 36;
        double deltaMag = 0.1;
        String regName = region.getName();
        regName = regName.replaceAll("Region", "");
        regName = regName.replaceAll("_", " ");
        regName = regName.trim();
        String yVal = rates ? "Expected Num" : "Prob";
        String yAxisLabel = regName + " Cum. One Week Participation " + yVal;
        long maxOT = ot + (long)(duration * 3.15576E10);
        int startYear = ETAS_MultiSimAnalysisTools.calcYearForOT(ot);
        erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.INCLUDE);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.getTimeSpan().setDuration(duration);
        erf.updateForecast();
        FSSRupsInRegionCache cache = new FSSRupsInRegionCache();
        if (rates) {
            SummedMagFreqDist incrMFD = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, minMag + 0.5 * deltaMag, numMag, deltaMag, true, cache);
            tiMFD = incrMFD.getCumRateDistWithOffset();
            tiMFD.scale(duration);
        } else {
            tiMFD = FaultSysSolutionERF_Calc.calcMagProbDist(erf, region, minMag, numMag, deltaMag, true, cache);
        }
        tiMFD.setName("UCERF3-TI");
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
        erf.setParameter("Historic Open Interval", startYear - 1875);
        erf.getTimeSpan().setStartTime(startYear);
        if (scenario.getFSS_Index() >= 0) {
            long myOT = erf.getTimeSpan().getStartTimeCalendar().getTime().getTime();
            System.out.println("Setting date of occurance for rup " + scenario.getFSS_Index() + " to " + myOT);
            erf.setFltSystemSourceOccurranceTimeForFSSIndex(scenario.getFSS_Index(), myOT);
        }
        erf.getTimeSpan().setDuration(duration);
        erf.getTimeSpan().setStartTime(startYear);
        erf.updateForecast();
        if (rates) {
            SummedMagFreqDist incrMFD = ERF_Calculator.getParticipationMagFreqDistInRegion(erf, region, minMag + 0.5 * deltaMag, numMag, deltaMag, true, cache);
            tdMFD = incrMFD.getCumRateDistWithOffset();
            tdMFD.scale(duration);
        } else {
            tdMFD = FaultSysSolutionERF_Calc.calcMagProbDist(erf, region, minMag, numMag, deltaMag, true, cache);
        }
        tdMFD.setName("UCERF3-TD");
        HashSet<Integer> rupsToInclude = new HashSet<Integer>();
        FaultSystemSolution sol = erf.getSolution();
        for (int fssIndex = 0; fssIndex < sol.getRupSet().getNumRuptures(); ++fssIndex) {
            if (!cache.isRupInRegion(sol, fssIndex, region, 1.0)) continue;
            rupsToInclude.add(fssIndex);
        }
        File file = new File(outputDir, prefix);
        ArrayList funcs = Lists.newArrayList();
        ArrayList chars = Lists.newArrayList();
        funcs.add(tiMFD);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        funcs.add(tdMFD);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        EvenlyDiscretizedFunc etasMFD = new EvenlyDiscretizedFunc(tiMFD.getMinX(), tiMFD.getMaxX(), tiMFD.size());
        for (int i = 0; i < etasMFD.size(); ++i) {
            double mag = etasMFD.getX(i);
            etasMFD.set(i, ETAS_MultiSimAnalysisTools.calcETASPartic(catalogs1, ot, maxOT, rupsToInclude, rates, region, mag));
        }
        if (catalogs2 == null) {
            etasMFD.setName("UCERF3-ETAS");
            funcs.add(etasMFD);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        } else {
            EvenlyDiscretizedFunc etasMFD2 = new EvenlyDiscretizedFunc(tiMFD.getMinX(), tiMFD.getMaxX(), tiMFD.size());
            for (int i = 0; i < etasMFD2.size(); ++i) {
                double mag = etasMFD2.getX(i);
                etasMFD2.set(i, ETAS_MultiSimAnalysisTools.calcETASPartic(catalogs2, ot, maxOT, rupsToInclude, rates, region, mag));
            }
            EvenlyDiscretizedFunc etasMean = new EvenlyDiscretizedFunc(tiMFD.getMinX(), tiMFD.getMaxX(), tiMFD.size());
            EvenlyDiscretizedFunc etasLower = new EvenlyDiscretizedFunc(tiMFD.getMinX(), tiMFD.getMaxX(), tiMFD.size());
            EvenlyDiscretizedFunc etasUpper = new EvenlyDiscretizedFunc(tiMFD.getMinX(), tiMFD.getMaxX(), tiMFD.size());
            EvenlyDiscretizedFunc etasMeanLower = new EvenlyDiscretizedFunc(tiMFD.getMinX(), tiMFD.getMaxX(), tiMFD.size());
            EvenlyDiscretizedFunc etasMeanUpper = new EvenlyDiscretizedFunc(tiMFD.getMinX(), tiMFD.getMaxX(), tiMFD.size());
            for (int i = 0; i < etasMean.size(); ++i) {
                boolean aboveMax;
                double val2;
                double val1 = etasMFD.getY(i);
                double mean = 0.5 * (val1 + (val2 = etasMFD2.getY(i)));
                Preconditions.checkState((!Double.isNaN(mean) ? 1 : 0) != 0);
                etasMean.set(i, mean);
                double x = etasMean.getX(i);
                boolean bl = aboveMax = x - 0.5 * deltaMag > fssMaxMag;
                if (aboveMax) {
                    Preconditions.checkState((val1 == 0.0 ? 1 : 0) != 0);
                    Preconditions.checkState((val2 == 0.0 ? 1 : 0) != 0);
                }
                double[] conf1 = val1 > 1.0 || aboveMax ? new double[]{val1, val1} : ETAS_Utils.getBinomialProportion95confidenceInterval(val1, catalogs1.size());
                double[] conf2 = val2 > 1.0 || aboveMax ? new double[]{val2, val2} : ETAS_Utils.getBinomialProportion95confidenceInterval(val2, catalogs2.size());
                etasMeanLower.set(i, Math.min(val1, val2));
                etasMeanUpper.set(i, Math.max(val1, val2));
                etasLower.set(i, Math.min(Math.min(conf1[0], conf2[0]), mean));
                etasUpper.set(i, Math.max(conf1[1], conf2[1]));
            }
            UncertainArbDiscFunc confBounds = new UncertainArbDiscFunc(etasMean, etasLower, etasUpper);
            UncertainArbDiscFunc meanRange = new UncertainArbDiscFunc(etasMean, etasMeanLower, etasMeanUpper);
            Color confColor = new Color(255, 120, 120);
            funcs.add(0, confBounds);
            chars.add(0, new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN_TRANS, 1.0f, confColor));
            funcs.add(1, meanRange);
            chars.add(1, new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, confColor));
            funcs.add(etasMean);
            chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        }
        double minY = 1.0;
        double maxY = 0.0;
        for (XY_DataSet func : funcs) {
            for (Point2D pt : func) {
                if (!(pt.getY() > 0.0)) continue;
                minY = Math.min(minY, pt.getY());
                maxY = Math.max(maxY, pt.getY());
            }
        }
        minY *= 0.5;
        for (XY_DataSet func : funcs) {
            Preconditions.checkState((func.size() > 0 ? 1 : 0) != 0, (String)"Empty func with name: %s", (Object)func.getName());
        }
        PlotSpec spec = new PlotSpec(funcs, chars, name, "Magnitude", yAxisLabel);
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = new HeadlessGraphPanel();
        minY = 1.0E-6;
        maxY = !rates ? 1.0 : 10.0;
        gp.setUserBounds(minMag, tiMFD.getMaxX(), minY, maxY);
        ETAS_MultiSimAnalysisTools.setFontSizes(gp);
        gp.drawGraphPanel(spec, false, true);
        gp.getChartPanel().setSize(1000, 800);
        gp.saveAsPNG(file.getAbsolutePath() + ".png");
        gp.saveAsPDF(file.getAbsolutePath() + ".pdf");
        gp.saveAsTXT(file.getAbsolutePath() + ".txt");
    }

    private static ETAS_ParameterList loadEtasParamsFromMetadata(Element root) throws DocumentException, MalformedURLException {
        Element paramsEl = root.element("ETAS_ParameterList");
        return ETAS_ParameterList.fromXMLMetadata(paramsEl);
    }

    public static void nedsAnalysis2() {
        System.out.println("Making ERF");
        double duration = 10.0;
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(2012.0, duration, false);
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        String dir = "/Users/field/Field_Other/CEA_WGCEP/UCERF3/UCERF3-ETAS/ResultsAndAnalysis/ScenarioSimulations";
        System.out.println("Reading catalogs");
        List<ETAS_CatalogIO.ETAS_Catalog> catalogs = null;
        try {
            catalogs = ETAS_CatalogIO.loadCatalogsBinary(new File(dir + "/results_m4.bin"));
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int triggerParentID = 9893;
        ArrayList primaryCatalogs = Lists.newArrayList();
        if (triggerParentID >= 0) {
            for (List list : catalogs) {
                primaryCatalogs.add(ETAS_SimAnalysisTools.getPrimaryAftershocks(list, triggerParentID));
            }
        } else {
            for (List list : catalogs) {
                primaryCatalogs.add(ETAS_SimAnalysisTools.getByGeneration(list, 0));
            }
        }
        System.out.println("catalogs.size()=" + catalogs.size());
        File outputDir = new File(dir);
        if (!outputDir.exists()) {
            outputDir.mkdir();
        }
        double[] dArray = new double[]{0.0};
        try {
            ETAS_MultiSimAnalysisTools.plotSectRates(primaryCatalogs, -1.0, rupSet, dArray, outputDir, null, "M7");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public static void nedsAnalysis() {
        System.out.println("Making ERF");
        double duration = 10.0;
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(2012.0, duration, false);
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        try {
            String dir = "/Users/field/Field_Other/CEA_WGCEP/UCERF3/UCERF3-ETAS/ResultsAndAnalysis/NoScenarioSimulations/";
            String simName = "2016_02_18-spontaneous-30yr-scaleMFD1p14-full_td-subSeisSupraNucl-gridSeisCorr";
            System.out.println("Reading catalogs");
            List<ETAS_CatalogIO.ETAS_Catalog> catalogs = ETAS_CatalogIO.loadCatalogsBinary(new File(dir + simName + "/results_m4.bin"));
            System.out.println("catalogs.size()=" + catalogs.size());
            File outputDir = new File(dir + simName);
            if (!outputDir.exists()) {
                outputDir.mkdir();
            }
            try {
                ETAS_MultiSimAnalysisTools.plotAndWriteSectProbOneOrMoreData(catalogs, 10.0, erf, outputDir);
            }
            catch (GMT_MapException e1) {
                e1.printStackTrace();
            }
            catch (RuntimeException e1) {
                e1.printStackTrace();
            }
            System.exit(-1);
            ETAS_MultiSimAnalysisTools.plotNormRecurrenceIntForAllSubSectHist(catalogs, erf, outputDir);
            erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
            erf.updateForecast();
            try {
                ETAS_MultiSimAnalysisTools.plotSectParticScatter(catalogs, -1.0, erf, outputDir);
            }
            catch (Exception e) {
                e.printStackTrace();
            }
            System.exit(-1);
            outputDir = new File(dir + simName + "/subSectPlots");
            if (!outputDir.exists()) {
                outputDir.mkdir();
            }
            int[] sectIndexArray = new int[]{1906, 1850, 1922, 1946};
            double[] sectPartRate = FaultSysSolutionERF_Calc.calcParticipationRateForAllSects(erf, 5.0);
            for (int sectIndex : sectIndexArray) {
                ETAS_MultiSimAnalysisTools.plotSubSectRecurrenceHist(catalogs, rupSet, sectIndex, outputDir, 1.0 / sectPartRate[sectIndex]);
                ETAS_MultiSimAnalysisTools.plotSubSectRecurrenceIntervalVsTime(catalogs, rupSet, sectIndex, outputDir, 1.0 / sectPartRate[sectIndex]);
                ETAS_MultiSimAnalysisTools.plotSubSectNuclMagFreqDist(catalogs, erf, sectIndex, outputDir);
                ETAS_MultiSimAnalysisTools.plotSubSectPartMagFreqDist(catalogs, erf, sectIndex, outputDir);
                ETAS_MultiSimAnalysisTools.plotCumNumWithTimeForSection(catalogs, erf, sectIndex, outputDir);
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static ETAS_Simulator.TestScenario detectScenario(File directory) {
        String dirName = directory.getName().toLowerCase();
        if (dirName.contains("spontaneous")) {
            System.out.println("Detected spontaneous");
        } else {
            for (ETAS_Simulator.TestScenario test : ETAS_Simulator.TestScenario.values()) {
                if (!dirName.contains(test.name().toLowerCase())) continue;
                return test;
            }
            if (dirName.contains("swarm")) {
                System.out.println("Detected swarm, treating as spontaneous");
            } else {
                throw new IllegalStateException("Couldn't detect scenario from dir name: " + dirName);
            }
        }
        return null;
    }

    private static void makeImagesForSciencePaperFig1(int model) {
        System.out.println("Loading file");
        File resultsFile = null;
        if (model == 0) {
            resultsFile = new File("/Users/field/Field_Other/CEA_WGCEP/UCERF3/UCERF3-ETAS/ResultsAndAnalysis/ScenarioSimulations/KevinsMultiSimRuns/2016_02_19-mojave_m7-10yr-full_td-subSeisSupraNucl-gridSeisCorr-scale1.14-combined100k/results_descendents_m5_preserve.bin");
        } else if (model == 1) {
            resultsFile = new File("/Users/field/Field_Other/CEA_WGCEP/UCERF3/UCERF3-ETAS/ResultsAndAnalysis/ScenarioSimulations/KevinsMultiSimRuns/2016_02_22-mojave_m7-10yr-no_ert-subSeisSupraNucl-gridSeisCorr-combined100k/results_descendents_m5_preserve.bin");
        } else if (model == 2) {
            resultsFile = new File("/Users/field/Field_Other/CEA_WGCEP/UCERF3/UCERF3-ETAS/ResultsAndAnalysis/ScenarioSimulations/KevinsMultiSimRuns/2016_02_22-mojave_m7-10yr-BothModels/results_descendents_m5_preserve_merged_with_100k_full_td.bin");
        }
        List<ETAS_CatalogIO.ETAS_Catalog> catalogs = null;
        try {
            catalogs = ETAS_CatalogIO.loadCatalogs(resultsFile, 6.7, true);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double duration = 30.0;
        Long ot = Math.round(1.3254192E12);
        long maxOT = ot + (long)(duration * 3.15576E10);
        int fssIndex = 193821;
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(2012.0, duration, false);
        int srcID = erf.getSrcIndexForFltSysRup(fssIndex);
        erf.setFltSystemSourceOccurranceTime(srcID, ot);
        erf.updateForecast();
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED(0.1);
        FaultPolyMgr polyManager = FaultPolyMgr.create(rupSet.getFaultSectionDataList(), 12.0);
        double[] zCount = new double[griddedRegion.getNodeCount()];
        System.out.println("Looping over catalog");
        for (List list : catalogs) {
            ETAS_EqkRupture rup;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (rup = (ETAS_EqkRupture)iterator.next()).getOriginTime() <= maxOT) {
                if (rup.getFSSIndex() >= 0) {
                    for (int s : rupSet.getSectionsIndicesForRup(rup.getFSSIndex())) {
                        Map<Integer, Double> nodeFracts = polyManager.getNodeFractions(s);
                        Iterator<Integer> iterator2 = nodeFracts.keySet().iterator();
                        while (iterator2.hasNext()) {
                            int n;
                            int n2 = n = iterator2.next().intValue();
                            zCount[n2] = zCount[n2] + nodeFracts.get(n);
                        }
                    }
                    continue;
                }
                int n = griddedRegion.indexForLocation(rup.getHypocenterLocation());
                zCount[n] = zCount[n] + 1.0;
            }
        }
        GriddedGeoDataSet triggerData = new GriddedGeoDataSet(griddedRegion, true);
        GriddedGeoDataSet griddedGeoDataSet = new GriddedGeoDataSet(griddedRegion, true);
        System.out.println("Making Long Term Data");
        GriddedGeoDataSet longTermTD_data = FaultSysSolutionERF_Calc.calcParticipationProbInGriddedRegionFltMapped(erf, griddedRegion, 6.7, 10.0);
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        System.out.println("Making Time Ind. Data");
        GriddedGeoDataSet timeInd_data = FaultSysSolutionERF_Calc.calcParticipationProbInGriddedRegionFltMapped(erf, griddedRegion, 6.7, 10.0);
        for (int n = 0; n < zCount.length; ++n) {
            triggerData.set(n, Math.log10(zCount[n] / 100000.0));
            double value = Math.log10(zCount[n] / 100000.0 / longTermTD_data.get(n) + 1.0);
            if (Double.isNaN(value)) {
                value = 0.0;
            }
            griddedGeoDataSet.set(n, value);
            longTermTD_data.set(n, Math.log10(longTermTD_data.get(n)));
            timeInd_data.set(n, Math.log10(timeInd_data.get(n)));
        }
        boolean includeTopo = false;
        System.out.println("Making Plots");
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            double minValue = -8.0;
            double maxValue = -2.0;
            File dir = null;
            dir = model == 0 ? new File("SciFig1_FULL_TD_BackgroundImages") : (model == 1 ? new File("SciFig1_NO_ERT_BackgroundImages") : new File("SciFig1_BOTH_BackgroundImages"));
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(triggerData, griddedRegion, dir, "triggerData", true, cpt, minValue, maxValue, includeTopo);
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(longTermTD_data, griddedRegion, dir, "longTermTD_data", true, cpt, minValue, maxValue, includeTopo);
            maxValue = -3.0;
            minValue = -5.0;
            maxValue = 0.0;
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(timeInd_data, griddedRegion, dir, "timeInd_data", true, cpt, minValue, maxValue, includeTopo);
            CPT cpt_ratio = GMT_CPT_Files.UCERF3_ETAS_GAIN.instance();
            minValue = -3.0;
            maxValue = 3.0;
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(griddedGeoDataSet, griddedRegion, dir, "ratioData", true, cpt_ratio, minValue, maxValue, includeTopo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void makeImagesForEqkSpectraPaperFig1() {
        System.out.println("running makeImagesForEqkSpectraPaperFig1");
        System.out.println("Loading file");
        File resultsFile = new File("/Users/field/Field_Other/CEA_WGCEP/UCERF3/UCERF3-ETAS/ResultsAndAnalysis/ScenarioSimulations/KevinsMultiSimRuns/2016_06_15-haywired_m7-10yr-BothModels/2016_06_15-haywired_m7-10yr-full_td-no_ert-combined-results_descendents_m5.bin");
        List<ETAS_CatalogIO.ETAS_Catalog> catalogs = null;
        try {
            catalogs = ETAS_CatalogIO.loadCatalogs(resultsFile, 6.7, true);
        }
        catch (ZipException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        double duration = 1.0;
        Long ot = Math.round(1.3254192E12);
        long maxOT = ot + (long)(duration * 3.15576E10);
        int fssIndex = 101499;
        FaultSystemSolutionERF_ETAS erf = ETAS_Simulator.getU3_ETAS_ERF(2012.0, duration, false);
        int srcID = erf.getSrcIndexForFltSysRup(fssIndex);
        erf.updateForecast();
        FaultSystemRupSet rupSet = erf.getSolution().getRupSet();
        CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED(0.1);
        FaultPolyMgr polyManager = FaultPolyMgr.create(rupSet.getFaultSectionDataList(), 12.0);
        double[] zCount = new double[griddedRegion.getNodeCount()];
        System.out.println("Looping over catalog");
        for (List list : catalogs) {
            ETAS_EqkRupture rup;
            Iterator iterator = list.iterator();
            while (iterator.hasNext() && (rup = (ETAS_EqkRupture)iterator.next()).getOriginTime() <= maxOT) {
                if (rup.getFSSIndex() >= 0) {
                    for (int s : rupSet.getSectionsIndicesForRup(rup.getFSSIndex())) {
                        Map<Integer, Double> nodeFracts = polyManager.getNodeFractions(s);
                        Iterator<Integer> iterator2 = nodeFracts.keySet().iterator();
                        while (iterator2.hasNext()) {
                            int n;
                            int n2 = n = iterator2.next().intValue();
                            zCount[n2] = zCount[n2] + nodeFracts.get(n);
                        }
                    }
                    continue;
                }
                int n = griddedRegion.indexForLocation(rup.getHypocenterLocation());
                zCount[n] = zCount[n] + 1.0;
            }
        }
        GriddedGeoDataSet triggerOnlyData = new GriddedGeoDataSet(griddedRegion, true);
        GriddedGeoDataSet griddedGeoDataSet = new GriddedGeoDataSet(griddedRegion, true);
        GriddedGeoDataSet ratioData = new GriddedGeoDataSet(griddedRegion, true);
        System.out.println("Making Long Term Data");
        GriddedGeoDataSet longTermTD_data = FaultSysSolutionERF_Calc.calcParticipationProbInGriddedRegionFltMapped(erf, griddedRegion, 6.7, 10.0);
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        System.out.println("Making Time Ind. Data");
        GriddedGeoDataSet timeInd_data = FaultSysSolutionERF_Calc.calcParticipationProbInGriddedRegionFltMapped(erf, griddedRegion, 6.7, 10.0);
        double numSimulations = 200000.0;
        for (int n = 0; n < zCount.length; ++n) {
            double numTrig = zCount[n] / numSimulations;
            triggerOnlyData.set(n, Math.log10(numTrig));
            griddedGeoDataSet.set(n, Math.log10(numTrig + longTermTD_data.get(n)));
            double value = Math.log10(numTrig / longTermTD_data.get(n) + 1.0);
            if (Double.isNaN(value)) {
                value = 0.0;
            }
            ratioData.set(n, value);
            longTermTD_data.set(n, Math.log10(longTermTD_data.get(n)));
            timeInd_data.set(n, Math.log10(timeInd_data.get(n)));
        }
        String fileName = "/Users/field/Field_Other/CEA_WGCEP/UCERF3/U3_OperationalLossModelingPaper/Figures/Figure1and7_U3maps/hawired-full_td-no_ert-combined-gridded_nucl_m2.5/map_data.txt";
        double discr = 0.02;
        GriddedRegion reg = new GriddedRegion(new CaliforniaRegions.RELM_TESTING(), discr, GriddedRegion.ANCHOR_0_0);
        GriddedGeoDataSet triggerData = new GriddedGeoDataSet(reg, true);
        try {
            for (Object line : Files.readLines((File)new File(fileName), (Charset)Charset.defaultCharset())) {
                line = ((String)line).trim();
                String[] split = ((String)line).split("\t");
                double lat = Double.parseDouble(split[0]);
                double lon = Double.parseDouble(split[1]);
                double val = Double.parseDouble(split[2]);
                int index = reg.indexForLocation(new Location(lat, lon));
                triggerData.set(index, val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fileName = "/Users/field/Field_Other/CEA_WGCEP/UCERF3/U3_OperationalLossModelingPaper/Figures/Figure1and7_U3maps/haywired-gridded-only_m2.5/map_data.txt";
        GriddedGeoDataSet triggerDataNoFaults = new GriddedGeoDataSet(reg, true);
        try {
            for (String line : Files.readLines((File)new File(fileName), (Charset)Charset.defaultCharset())) {
                line = line.trim();
                String[] split = line.split("\t");
                double lat = Double.parseDouble(split[0]);
                double lon = Double.parseDouble(split[1]);
                double val = Double.parseDouble(split[2]);
                int index = reg.indexForLocation(new Location(lat, lon));
                triggerDataNoFaults.set(index, val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean includeTopo = false;
        System.out.println("Making Plots");
        try {
            CPT cpt = GMT_CPT_Files.MAX_SPECTRUM.instance();
            double minValue = -6.0;
            double maxValue = -1.0;
            File dir = new File("EqkSpectraFig1_BackgroundImages");
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(triggerOnlyData, griddedRegion, dir, "triggerOnlyData", true, cpt, minValue, maxValue, includeTopo);
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(griddedGeoDataSet, griddedRegion, dir, "triggerPlusTD_Data", true, cpt, minValue, maxValue, includeTopo);
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(longTermTD_data, griddedRegion, dir, "longTermTD_data", true, cpt, minValue, maxValue, includeTopo);
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(timeInd_data, griddedRegion, dir, "timeInd_data", true, cpt, minValue, maxValue, includeTopo);
            CPT cpt_ratio = GMT_CPT_Files.UCERF3_ETAS_GAIN.instance();
            minValue = -1.2;
            maxValue = 1.2;
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(ratioData, griddedRegion, dir, "triggerRatioData", true, cpt_ratio, minValue, maxValue, includeTopo);
            for (int i = 0; i < ratioData.size(); ++i) {
                ratioData.set(i, 0.0);
            }
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(ratioData, griddedRegion, dir, "grayBackgroundData", true, cpt_ratio, minValue, maxValue, includeTopo);
            cpt = GMT_CPT_Files.UCERF3_ETAS_TRIGGER.instance();
            minValue = -5.0;
            maxValue = 1.0;
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(triggerData, reg, dir, "triggerOnlyMag2p5", true, cpt, minValue, maxValue, includeTopo);
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(triggerDataNoFaults, reg, dir, "triggerOnlyNoFaultsMag2p5", true, cpt, minValue, maxValue, includeTopo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private static void makeSRL_CoverImage() {
        System.out.println("running makeSRL_CoverImage");
        String fileName = "/Users/field/Field_Other/CEA_WGCEP/UCERF3/SRL_U3_ShortPaper/Figures/Figure2/parkfield-full_td-no_ert-combined-1wk_m2.5/map_data.txt";
        double discr = 0.02;
        GriddedRegion reg = new GriddedRegion(new CaliforniaRegions.RELM_TESTING(), discr, GriddedRegion.ANCHOR_0_0);
        GriddedGeoDataSet triggerData = new GriddedGeoDataSet(reg, true);
        try {
            for (Object line : Files.readLines((File)new File(fileName), (Charset)Charset.defaultCharset())) {
                line = ((String)line).trim();
                String[] split = ((String)line).split("\t");
                double lat = Double.parseDouble(split[0]);
                double lon = Double.parseDouble(split[1]);
                double val = Double.parseDouble(split[2]);
                int index = reg.indexForLocation(new Location(lat, lon));
                triggerData.set(index, val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        fileName = "/Users/field/Field_Other/CEA_WGCEP/UCERF3/SRL_U3_ShortPaper/Figures/Figure2/parkfield-gridded-only-1wk_m2.5/map_data.txt";
        GriddedGeoDataSet triggerDataNoFaults = new GriddedGeoDataSet(reg, true);
        try {
            for (String line : Files.readLines((File)new File(fileName), (Charset)Charset.defaultCharset())) {
                line = line.trim();
                String[] split = line.split("\t");
                double lat = Double.parseDouble(split[0]);
                double lon = Double.parseDouble(split[1]);
                double val = Double.parseDouble(split[2]);
                int index = reg.indexForLocation(new Location(lat, lon));
                triggerDataNoFaults.set(index, val);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        boolean includeTopo = false;
        System.out.println("Making Plots");
        try {
            CPT cpt = GMT_CPT_Files.UCERF3_ETAS_TRIGGER.instance();
            double minValue = -6.0;
            double maxValue = 0.0;
            File dir = new File("SRL_CoverImage");
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(triggerData, reg, dir, "triggerOnlyMag2p5", true, cpt, minValue, maxValue, includeTopo);
            FaultSysSolutionERF_Calc.makeBackgroundImageForSCEC_VDO(triggerDataNoFaults, reg, dir, "triggerOnlyNoFaultsMag2p5", true, cpt, minValue, maxValue, includeTopo);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws IOException, GMT_MapException, RuntimeException, DocumentException {
        if (args.length == 0 && new File("/Users/field/").exists()) {
            ETAS_MultiSimAnalysisTools.makeSRL_CoverImage();
            System.exit(-1);
        }
        File mainDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations");
        double minLoadMag = -1.0;
        boolean isCLI = args.length > 0;
        boolean forcePlot = isCLI && !Boolean.parseBoolean(System.getProperty("hardcoded", "false"));
        System.out.println("Force plot: " + forcePlot);
        boolean plotMFDs = true;
        boolean plotExpectedComparison = forcePlot;
        boolean plotSectRates = true;
        boolean plotSectRatesOneWeek = true;
        boolean plotTemporalDecay = forcePlot;
        boolean plotDistanceDecay = forcePlot;
        boolean plotMaxMagHist = forcePlot;
        boolean plotGenerations = forcePlot;
        boolean plotGriddedNucleation = forcePlot;
        boolean writeTimeFromPrevSupra = forcePlot;
        boolean plotSectScatter = forcePlot;
        boolean plotGridScatter = forcePlot;
        boolean plotStationarity = forcePlot;
        boolean plotSubSectRecurrence = forcePlot;
        boolean plotCondDist = forcePlot;
        boolean writeCatsForViz = forcePlot;
        boolean plotScalesHazard = false;
        boolean plotRegionOneWeek = false;
        boolean plotMFDOneWeek = !forcePlot;
        boolean useDefaultETASParamsIfMissing = true;
        boolean useActualDurations = true;
        int id_for_scenario = 0;
        File fssFile = new File("dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip");
        U3FaultSystemSolution fss = U3FaultSystemIO.loadSol(fssFile);
        boolean skipEmpty = true;
        double minDurationForInclusion = 0.0;
        ArrayList resultsZipFiles = Lists.newArrayList();
        if (args.length == 0) {
            resultsZipFiles.add(new File(mainDir, "2016_08_30-san_jacinto_0_m4p8-10yr-full_td-subSeisSupraNucl-gridSeisCorr-scale1.14-combined/results_descendents.bin"));
            resultsZipFiles.add(new File(mainDir, "2016_08_31-bombay_beach_m4pt8-10yr-full_td-subSeisSupraNucl-gridSeisCorr-scale1.14-combined-plus100kNoSpont/results_descendents_m4_preserve.bin"));
        } else {
            for (String arg : args) {
                File resultFile = new File(arg);
                Preconditions.checkState((resultFile.exists() && (resultFile.getName().endsWith(".bin") || resultFile.getName().endsWith(".zip")) ? 1 : 0) != 0);
                if (resultFile.getParentFile().getName().startsWith("2016_02_19-mojave")) {
                    System.out.println("Changing scenario ID");
                    id_for_scenario = 9893;
                }
                resultsZipFiles.add(resultFile);
            }
        }
        for (int n = 0; n < resultsZipFiles.size(); ++n) {
            void var66_84;
            void var64_71;
            boolean gridSeisCorr;
            String subsetName;
            String fullName;
            ETAS_ParameterList params;
            boolean swarm;
            File resultsFile = (File)resultsZipFiles.get(n);
            File directory = resultsFile.getParentFile();
            System.out.println("Processing " + directory.getAbsolutePath());
            ETAS_Simulator.TestScenario scenario = ETAS_MultiSimAnalysisTools.detectScenario(directory);
            if (scenario != null) {
                System.out.println("Detected scenario " + scenario.name());
            }
            if (scenario != null && scenario.getFSS_Index() >= 0) {
                scenario.updateMag(((FaultSystemSolution)fss).getRupSet().getMagForRup(scenario.getFSS_Index()));
            }
            int triggerParentID = (swarm = resultsFile.getParentFile().getName().contains("swarm")) && resultsFile.getName().contains("descend") ? Integer.MAX_VALUE : (scenario == null ? -1 : id_for_scenario);
            System.gc();
            RuptureSurface surf = scenario == null ? null : (scenario.getLocation() != null ? new PointSurface(scenario.getLocation()) : ((FaultSystemSolution)fss).getRupSet().getSurfaceForRupture(scenario.getFSS_Index(), 1.0));
            File parentDir = resultsFile.getParentFile();
            File outputDir = new File(resultsFile.getParentFile(), plotDirName);
            File metadataFile = new File(resultsFile.getParentFile(), "metadata.xml");
            System.out.println("Metadatafile: " + metadataFile.getAbsolutePath());
            Element metadataRootEl = null;
            if (metadataFile.exists()) {
                System.out.println("Loading ETAS params from metadata file: " + metadataFile.getAbsolutePath());
                Document doc = XMLUtils.loadDocument(metadataFile);
                metadataRootEl = doc.getRootElement();
                params = ETAS_MultiSimAnalysisTools.loadEtasParamsFromMetadata(metadataRootEl);
            } else if (useDefaultETASParamsIfMissing) {
                System.out.println("Using default ETAS params");
                params = new ETAS_ParameterList();
            } else {
                params = null;
            }
            if (metadataRootEl == null) {
                throw new IllegalStateException("No metadata found and don't want to assume the ot/duration");
            }
            Element paramsEl = metadataRootEl.element("MiscParams");
            Long ot = Long.parseLong(paramsEl.attributeValue("ot"));
            double inputDuration = Double.parseDouble(paramsEl.attributeValue("duration"));
            double duration = inputDuration;
            if (useActualDurations && scenario == null && !swarm) {
                duration = -1.0;
            }
            Object name = scenario == null ? "" : String.valueOf((Object)scenario) + " ";
            name = (String)name + (int)inputDuration + "yr";
            if (params != null) {
                boolean both;
                String parentName = resultsFile.getParentFile().getName().toLowerCase();
                boolean bl = both = parentName.contains("full_td") && parentName.contains("no_ert");
                if (!both) {
                    name = (String)name + " " + String.valueOf((Object)params.getU3ETAS_ProbModel());
                }
            }
            if (scenario != null) {
                System.out.println("Scenario: " + String.valueOf((Object)scenario));
                System.out.println("\tMag: " + scenario.getMagnitude());
                System.out.println("\tFSS Index: " + scenario.getFSS_Index());
                System.out.println("\tHypo: " + String.valueOf(scenario.getLocation()));
            }
            if (!outputDir.exists()) {
                File oldDir = new File(parentDir, "output_stats");
                if (oldDir.exists()) {
                    Preconditions.checkState((boolean)oldDir.renameTo(outputDir));
                } else {
                    oldDir = new File(parentDir, "outputs_stats");
                    if (oldDir.exists()) {
                        Preconditions.checkState((boolean)oldDir.renameTo(outputDir));
                    }
                }
            }
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
            System.out.println("Loading " + (String)name + " from " + resultsFile.getAbsolutePath());
            Stopwatch timer = Stopwatch.createStarted();
            List<ETAS_CatalogIO.ETAS_Catalog> catalogs = ETAS_CatalogIO.loadCatalogs(resultsFile, minLoadMag, true);
            timer.stop();
            long secs = timer.elapsed(TimeUnit.SECONDS);
            if (secs > 60L) {
                System.out.println("Catalog loading took " + (float)((double)secs / 60.0) + " minutes");
            } else {
                System.out.println("Catalog loading took " + secs + " seconds");
            }
            if (skipEmpty && scenario == null) {
                int skipped = 0;
                int i = catalogs.size();
                while (--i >= 0) {
                    if (!((List)catalogs.get(i)).isEmpty()) continue;
                    catalogs.remove(i);
                    ++skipped;
                }
                if (skipped > 0) {
                    System.out.println("Removed " + skipped + " empty catalogs.");
                }
            }
            DataUtils.MinMaxAveTracker durationTrack = new DataUtils.MinMaxAveTracker();
            int skippedDuration = 0;
            int i = catalogs.size();
            while (--i >= 0) {
                List catalog = catalogs.get(i);
                double myDuration = 0.0;
                if (!catalog.isEmpty()) {
                    myDuration = ETAS_MultiSimAnalysisTools.calcDurationYears(catalog);
                }
                if (myDuration < minDurationForInclusion && scenario == null) {
                    catalogs.remove(i);
                    ++skippedDuration;
                    continue;
                }
                durationTrack.addValue(myDuration);
            }
            if (skippedDuration > 0) {
                System.out.println("Removed " + skippedDuration + " catalgos that were too short");
            }
            System.out.println("Actual duration: " + String.valueOf(durationTrack));
            double meanDuration = durationTrack.getAverage();
            if (duration > 0.0 && DataUtils.getPercentDiff(duration, durationTrack.getMin()) > 2.0) {
                System.out.println("WARNING: at least 1 simulation doesn't match expected duration");
            }
            ArrayList childrenCatalogs = Lists.newArrayList();
            if (triggerParentID >= 0 && triggerParentID < Integer.MAX_VALUE) {
                long numOrig = 0L;
                long numChildren = 0L;
                for (List list : catalogs) {
                    ETAS_CatalogIO.ETAS_Catalog children = ETAS_SimAnalysisTools.getChildrenFromCatalog(list, triggerParentID);
                    numOrig += (long)list.size();
                    numChildren += (long)children.size();
                    childrenCatalogs.add(children);
                }
                long removed = numOrig - numChildren;
                System.out.println("Removed " + removed + " spontaneous events (" + numOrig + " orig, " + numChildren + " children)");
            } else {
                childrenCatalogs.addAll(catalogs);
            }
            DataUtils.MinMaxAveTracker childrenTrack = new DataUtils.MinMaxAveTracker();
            for (List catalog : childrenCatalogs) {
                childrenTrack.addValue(catalog.size());
            }
            System.out.println("Children counts: " + String.valueOf(childrenTrack));
            ArrayList primaryCatalogs = Lists.newArrayList();
            if (triggerParentID == Integer.MAX_VALUE) {
                for (List list : catalogs) {
                    primaryCatalogs.add(ETAS_SimAnalysisTools.getByGeneration(list, 1));
                }
            } else if (triggerParentID >= 0) {
                for (List list : catalogs) {
                    primaryCatalogs.add(ETAS_SimAnalysisTools.getPrimaryAftershocks(list, triggerParentID));
                }
            } else {
                for (List list : catalogs) {
                    primaryCatalogs.add(ETAS_SimAnalysisTools.getByGeneration(list, 0));
                }
            }
            if (triggerParentID >= 0) {
                fullName = "Children";
                String string = "full_children";
                subsetName = "Primary";
                String string2 = "primary";
            } else {
                fullName = "All EQs";
                String string = "all_eqs";
                subsetName = "Spontaneous";
                String string3 = "spontaneous";
            }
            FaultSystemSolutionERF erf = null;
            if (triggerParentID < 0 && (meanDuration >= 100.0 || catalogs.size() >= 1000)) {
                System.out.println("Creating ERF for comparisons");
                erf = new FaultSystemSolutionERF(fss);
                erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
                erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.INCLUDE);
                erf.getTimeSpan().setDuration(1.0);
                erf.updateForecast();
            }
            boolean bl = gridSeisCorr = resultsFile.getParentFile().getName().contains("gridSeisCorr") || params != null && params.getApplyGridSeisCorr();
            if (gridSeisCorr) {
                double[] gridSeisCorrValsArray;
                System.out.println("applying gridded seis comparison");
                try {
                    gridSeisCorrValsArray = MatrixIO.doubleArrayFromFile(new File("src/main/resources/scratchData/ucerf3/InversionSolutions/griddedSeisCorrectionCache"));
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                ETAS_Simulator.D = false;
                ETAS_Simulator.correctGriddedSeismicityRatesInERF(fss, false, gridSeisCorrValsArray);
            }
            if (plotMFDs) {
                System.out.println("Plotting MFDs");
                ArbIncrementalMagFreqDist[] subMFDs = ETAS_MultiSimAnalysisTools.plotMFD(childrenCatalogs, duration, erf, outputDir, (String)name, (String)var64_71);
                if (triggerParentID >= 0) {
                    ETAS_MultiSimAnalysisTools.plotMFD(primaryCatalogs, duration, null, outputDir, subsetName + " " + (String)name, (String)var66_84 + "_aftershocks");
                } else {
                    ETAS_MultiSimAnalysisTools.plotMFD(primaryCatalogs, duration, erf, outputDir, subsetName + " " + (String)name, (String)var66_84 + "_events");
                }
                ETAS_MultiSimAnalysisTools.plotFractWithMagAbove(childrenCatalogs, subMFDs, scenario, outputDir, (String)name, (String)var64_71 + "_fract_above_mag");
                if (scenario != null) {
                    double expNumForM2p5 = 0.0;
                    if (inputDuration == 10.0) {
                        expNumForM2p5 = 0.1653;
                    }
                    ETAS_MultiSimAnalysisTools.plotMagNum(childrenCatalogs, outputDir, (String)name, "consolidated_aftershocks", scenario, expNumForM2p5, fss);
                } else if (swarm && triggerParentID == Integer.MAX_VALUE) {
                    ETAS_MultiSimAnalysisTools.plotMagNum(childrenCatalogs, outputDir, (String)name, "consolidated_aftershocks", scenario, -1.0, fss);
                }
            }
            if (plotExpectedComparison && triggerParentID >= 0) {
                System.out.println("Plotting Expected Comparison MFDs");
                ETAS_MultiSimAnalysisTools.plotExpectedSupraComparisonMFD(primaryCatalogs, outputDir, subsetName + " " + (String)name, (String)var66_84 + "_supra_compare_to_expected");
                int numCatalogs = primaryCatalogs.size();
                List<List<ETAS_EqkRupture>> firstHalfPrimary = primaryCatalogs.subList(0, numCatalogs / 2);
                List<List<ETAS_EqkRupture>> secondHalfPrimary = primaryCatalogs.subList(firstHalfPrimary.size(), primaryCatalogs.size());
                ETAS_MultiSimAnalysisTools.plotExpectedSupraComparisonMFD(firstHalfPrimary, outputDir, subsetName + " " + (String)name, (String)var66_84 + "_supra_compare_to_expected_first" + firstHalfPrimary.size());
                ETAS_MultiSimAnalysisTools.plotExpectedSupraComparisonMFD(secondHalfPrimary, outputDir, subsetName + " " + (String)name, (String)var66_84 + "_supra_compare_to_expected_last" + secondHalfPrimary.size());
            }
            if (plotSectRates) {
                System.out.println("Plotting Sub Sect Rates");
                double[] minMags = new double[]{0.0, 6.7, 7.8};
                ETAS_MultiSimAnalysisTools.plotSectRates(childrenCatalogs, duration, ((FaultSystemSolution)fss).getRupSet(), minMags, outputDir, "for All Aftershocks", (String)var64_71 + "_sect");
                ETAS_MultiSimAnalysisTools.plotSectRates(primaryCatalogs, duration, ((FaultSystemSolution)fss).getRupSet(), minMags, outputDir, "for Primary Aftershocks", (String)var66_84 + "_sect");
            }
            if (plotSectRatesOneWeek) {
                long maxOT = ot + 604800000L;
                System.out.println("Plotting Sub Sect Rates 1 Week");
                double[] minMags = new double[]{0.0, 6.7, 7.8};
                ETAS_MultiSimAnalysisTools.plotSectRates(childrenCatalogs, 0.0, ((FaultSystemSolution)fss).getRupSet(), minMags, outputDir, "for All 1 Week", "one_week_" + (String)var64_71, maxOT, null, false, null, null);
                ETAS_MultiSimAnalysisTools.plotSectRates(primaryCatalogs, 0.0, ((FaultSystemSolution)fss).getRupSet(), minMags, outputDir, "for Primary 1 Wekk", "one_week_" + (String)var66_84, maxOT, null, false, null, null);
            }
            if (plotTemporalDecay && triggerParentID >= 0) {
                System.out.println("Plotting Temporal Decay");
                ETAS_MultiSimAnalysisTools.plotAftershockRateVsLogTimeHistForRup(primaryCatalogs, scenario, params, ot, outputDir, (String)name + " " + subsetName, (String)var66_84 + "_temporal_decay");
                ETAS_MultiSimAnalysisTools.plotAftershockRateVsLogTimeHistForRup(childrenCatalogs, scenario, params, ot, outputDir, (String)name, (String)var64_71 + "_temporal_decay");
            }
            if (plotDistanceDecay && triggerParentID >= 0) {
                System.out.println("Plotting Trigger Loc Dist Decay");
                ETAS_MultiSimAnalysisTools.plotDistDecay(primaryCatalogs, params, null, outputDir, (String)name + " Primary", (String)var66_84 + "_dist_decay_trigger");
                ETAS_MultiSimAnalysisTools.plotDistDecay(childrenCatalogs, params, null, outputDir, (String)name, (String)var64_71 + "_dist_decay_trigger");
                if (scenario != null && scenario.getFSS_Index() >= 0) {
                    System.out.println("Plotting Surface Dist Decay");
                    Stopwatch watch = Stopwatch.createStarted();
                    ETAS_MultiSimAnalysisTools.plotDistDecay(primaryCatalogs, params, surf, outputDir, (String)name + " Primary", (String)var66_84 + "_dist_decay_surf");
                    double mins = (double)watch.elapsed(TimeUnit.SECONDS) / 60.0;
                    System.out.println("Primary surf dist decay took " + (float)mins + " mins");
                    watch.reset();
                    watch.start();
                    ETAS_MultiSimAnalysisTools.plotDistDecay(childrenCatalogs, params, surf, outputDir, (String)name, (String)var64_71 + "_dist_decay_surf");
                    watch.stop();
                    mins = (double)watch.elapsed(TimeUnit.SECONDS) / 60.0;
                    System.out.println("Full surf dist decay took " + (float)mins + " mins");
                }
            }
            if (plotMaxMagHist) {
                System.out.println("Plotting max mag hist");
                ETAS_MultiSimAnalysisTools.plotMaxTriggeredMagHist(childrenCatalogs, primaryCatalogs, scenario, outputDir, (String)name, "max_mag_hist");
            }
            if (plotGenerations) {
                System.out.println("Plotting generations");
                ETAS_MultiSimAnalysisTools.plotNumEventsPerGeneration(childrenCatalogs, outputDir, (String)name, (String)var64_71 + "_generations");
            }
            if (plotGriddedNucleation) {
                System.out.println("Plotting gridded nucleation");
                double[] mags = new double[]{2.5, 6.7, 7.8};
                ETAS_MultiSimAnalysisTools.plotCubeNucleationRates(childrenCatalogs, duration, outputDir, (String)name, (String)var64_71 + "_gridded_nucl", mags);
                ETAS_MultiSimAnalysisTools.plotCubeNucleationRates(primaryCatalogs, duration, outputDir, (String)name, (String)var66_84 + "_gridded_nucl", mags);
                if (scenario == null && (duration > 1.0 || duration < 0.0)) {
                    List<List<ETAS_EqkRupture>> histCats = ETAS_MultiSimAnalysisTools.getOnlyAftershocksFromHistorical(childrenCatalogs);
                    ETAS_MultiSimAnalysisTools.plotCubeNucleationRates(histCats, duration, outputDir, (String)name, (String)var64_71 + "_gridded_nucl_historical", mags);
                }
            }
            if (plotSectScatter && erf != null) {
                System.out.println("Plotting section participation scatter");
                File fullResultsFile = new File(resultsFile.getParentFile(), "results.bin");
                if (fullResultsFile.exists() && resultsFile.getName().endsWith(".bin") && resultsFile.getName().startsWith("results_m")) {
                    System.out.println("Iterating over full results from " + fullResultsFile.getAbsolutePath());
                    ETAS_MultiSimAnalysisTools.plotSectParticScatter(ETAS_CatalogIO.getBinaryCatalogsIterable(fullResultsFile, 0.0), duration, erf, outputDir);
                } else {
                    ETAS_MultiSimAnalysisTools.plotSectParticScatter(catalogs, duration, erf, outputDir);
                }
            }
            if (plotGridScatter && erf != null) {
                System.out.println("Plotting gridded nucleation scatter");
                ETAS_MultiSimAnalysisTools.plotGriddedNucleationScatter(catalogs, duration, erf, outputDir);
            }
            if (plotStationarity && (duration > 1.0 || duration < 0.0) && triggerParentID < 0 && catalogs.size() >= 500 && !swarm) {
                System.out.println("Plotting stationarity");
                ETAS_MultiSimAnalysisTools.plotStationarity(catalogs, duration, outputDir);
            }
            if (plotSubSectRecurrence && (duration > 1.0 || duration < 0.0) && triggerParentID < 0 && !swarm) {
                int[] sectIndexes;
                System.out.println("Plotting sub section recurrence");
                for (int sectIndex : sectIndexes = new int[]{1922, 1850}) {
                    ETAS_MultiSimAnalysisTools.plotSubSectRecurrenceHist(catalogs, ((FaultSystemSolution)fss).getRupSet(), sectIndex, outputDir, Double.NaN);
                }
            }
            if (plotCondDist && (duration > 1.0 || duration < 0.0) && triggerParentID < 0 && !swarm) {
                System.out.println("Plotting conditional hypocenter distribution");
                ETAS_MultiSimAnalysisTools.plotConditionalHypocenterDist(catalogs, outputDir, ((FaultSystemSolution)fss).getRupSet());
            }
            if (writeCatsForViz) {
                System.out.println("Writing catalogs for vizualisation in SCEC-VDO");
                ETAS_MultiSimAnalysisTools.writeCatalogsForViz(childrenCatalogs, scenario, new File(parentDir, catsDirName), 5);
            }
            if (scenario == null && writeTimeFromPrevSupra && !swarm) {
                System.out.println("Plotting time since last supra");
                ETAS_MultiSimAnalysisTools.writeTimeFromPrevSupraHist(catalogs, outputDir);
            }
            if (scenario != null && plotScalesHazard || plotRegionOneWeek) {
                erf = new FaultSystemSolutionERF(fss);
                erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.U3_PREF_BLEND);
                erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
                erf.getTimeSpan().setDuration(1.0);
                erf.updateForecast();
                boolean rates = false;
                boolean subSects = false;
                if (plotScalesHazard) {
                    File scalesDir = new File(outputDir, "scales_of_hazard_change");
                    Preconditions.checkState((scalesDir.exists() || scalesDir.mkdir() ? 1 : 0) != 0);
                    if (subSects) {
                        Preconditions.checkState(((scalesDir = new File(scalesDir, "sub_sects")).exists() || scalesDir.mkdir() ? 1 : 0) != 0);
                    }
                    ETAS_MultiSimAnalysisTools.plotScalesOfHazardChange(childrenCatalogs, catalogs, scenario, ot, erf, scalesDir, (String)name, inputDuration, rates, subSects);
                }
                if (scenario == ETAS_Simulator.TestScenario.HAYWIRED_M7 || scenario == ETAS_Simulator.TestScenario.MOJAVE_M7 && plotRegionOneWeek) {
                    ETAS_MultiSimAnalysisTools.plotRegionalMPDs(catalogs, scenario, ot, erf, outputDir, (String)name, true);
                    ETAS_MultiSimAnalysisTools.plotRegionalMPDs(catalogs, scenario, ot, erf, outputDir, (String)name, false);
                }
            }
            if (plotMFDOneWeek) {
                long maxOT = ot + 604800000L;
                if (scenario != null) {
                    if (scenario.getMagnitude() < 6.0) {
                        mfdMinY = 1.0E-6;
                        mfdMaxY = 100.0;
                    }
                    ETAS_MultiSimAnalysisTools.plotMagNum(childrenCatalogs, outputDir, "1 Week", "one_week_consolidated_aftershocks", scenario, 0.058, fss, maxOT);
                } else if (swarm && triggerParentID == Integer.MAX_VALUE) {
                    mfdMinY = 1.0E-6;
                    mfdMaxY = 100.0;
                    ETAS_MultiSimAnalysisTools.plotMagNum(childrenCatalogs, outputDir, "1 Week", "one_week_consolidated_aftershocks", null, -1.0, fss, maxOT);
                }
            }
            ETAS_MultiSimAnalysisTools.writeHTML(parentDir, scenario, (String)name, params, catalogs, inputDuration, durationTrack);
        }
    }

    public static double calcDurationYears(List<ETAS_EqkRupture> catalog) {
        if (catalog.isEmpty()) {
            return 0.0;
        }
        return ETAS_MultiSimAnalysisTools.calcEventTimeYears(catalog, catalog.get(catalog.size() - 1));
    }

    private static double calcEventTimeYears(List<ETAS_EqkRupture> catalog, ETAS_EqkRupture rup) {
        long durationMillis = rup.getOriginTime() - catalog.get(0).getOriginTime();
        double myDuration = (double)durationMillis / 3.15576E10;
        return myDuration;
    }

    private static void writeHTML(File outputDir, ETAS_Simulator.TestScenario scenario, String scenName, ETAS_ParameterList params, List<? extends List<ETAS_EqkRupture>> catalogs, double inputDuration, DataUtils.MinMaxAveTracker durationTrack) throws IOException {
        System.out.println("Writing HTML");
        FileWriter fw = new FileWriter(new File(outputDir, "HEADER.html"));
        fw.write("<h1 style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal;\">" + scenName + "</h1>\n");
        fw.write("<br>\n");
        ETAS_MultiSimAnalysisTools.writeMetadataHTML(fw, scenario, params, catalogs, inputDuration, durationTrack);
        File plotDir = new File(outputDir, plotDirName);
        if (plotDir.exists()) {
            fw.write("<b>Various plots can be found in the plots directory below</b><br>\n");
            double minMag = Double.POSITIVE_INFINITY;
            for (List<ETAS_EqkRupture> list : catalogs) {
                for (ETAS_EqkRupture rup : list) {
                    minMag = Math.min(minMag, rup.getMag());
                }
            }
            minMag = 0.1 * (double)Math.round((minMag - 0.01) * 10.0);
            ETAS_MultiSimAnalysisTools.writePlotHTML(plotDir, scenName, minMag);
        }
        fw.write("</p>\n");
        fw.close();
    }

    private static void writePlotHTML(File plotDir, String scenarioName, double minMag) throws IOException {
        FileWriter fw = new FileWriter(new File(plotDir, "HEADER.html"));
        fw.write("<h1 style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal;\">" + scenarioName + " Plots</h1>\n");
        fw.write("<br>\n");
        fw.write("<p style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal; width:800;\">\n");
        fw.write("<b>Plots are divided into 3 categories:</b><br>\n");
        fw.write("<b>full_children_*:</b> Plots that include all generations of child events<br>\n");
        fw.write("<b>primary_*:</b> Plots that only consider primary aftershocks<br>\n");
        fw.write("<b>(other):</b> Plots where both are included or separation is not applicable<br>\n");
        fw.write("<br>\n");
        fw.write("<b>MFD Plots:</b><br>\n");
        fw.write("<b>*_mfd_cumulative.*:</b> Cumulative magnitude frequency distributious across all catalogs<br>\n");
        fw.write("<b>*_mfd_incremental.*:</b> Incremental magnitude frequency distributious across all catalogs<br>\n");
        fw.write("<br>\n");
        fw.write("<b>Decay Plots:</b><br>\n");
        fw.write("<b>*_dist_decay_trigger.*:</b> Distance decay of each child rupture from the trigger location on the parent rupture<br>\n");
        fw.write("<b>*_temporal_decay.*:</b> Temporal decay of each child rupture relative to its parent<br>\n");
        fw.write("<br>\n");
        fw.write("<b>Map Based Plots:</b><br>\n");
        fw.write("<b>*_sect_partic.*:</b> Map view of supra-seismogenic fault section participation rates<br>\n");
        fw.write("<b>*_sect_trigger.*:</b> Map view of supra-seismogenic fault section trigger rates<br>\n");
        fw.write("<b>*_gridded_nucl_m*.*:</b> Map view of gridded nucleation rates<br>\n");
        fw.write("<br>\n");
        fw.write("<b>Other Misc Plots:</b><br>\n");
        fw.write("<b>max_mag_hist.*:</b> Histogram of maximum magnitude triggered rupture across all catalogs<br>\n");
        fw.write("<b>full_children_generations.*:</b> Number of aftershocks of each generation<br>\n");
        if (minMag >= 3.0) {
            fw.write("<br>\n");
            fw.write("<b>NOTE: due to the number or aftershocks, only M&ge;" + (float)minMag + " ruptures are considered in these plots</b><br>\n");
        }
        fw.write("</p>\n");
        fw.close();
    }

    private static void writeMetadataHTML(FileWriter fw, ETAS_Simulator.TestScenario scenario, ETAS_ParameterList params, List<? extends List<ETAS_EqkRupture>> catalogs, double inputDuration, DataUtils.MinMaxAveTracker durationTrack) throws IOException {
        fw.write("<p style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal; width:800;\">\n");
        if (scenario != null) {
            fw.write("<h2>Scenario Information</h2>\n");
            fw.write("<b>Name:</b> " + scenario.name() + "<br>\n");
            fw.write("<b>Magnitude:</b> " + scenario.getMagnitude() + "<br>\n");
            fw.write("<b>Supra-seismogenic? </b> " + (scenario.getFSS_Index() >= 0) + "<br>\n");
            fw.write("<br>\n");
        }
        fw.write("<h2>Simulation Information</h2>\n");
        fw.write("<b>Num Catalogs:</b> " + catalogs.size() + "<br>\n");
        fw.write("<b>Simulation Input Duration:</b> " + (float)inputDuration + " years<br>\n");
        fw.write("<b>Actual Duration:</b> min=" + (float)durationTrack.getMin() + ", max=" + (float)durationTrack.getMax() + ", avg=" + (float)durationTrack.getAverage() + " years<br>\n");
        fw.write("<br>\n");
        if (params != null) {
            fw.write("<h3>ETAS Parameters</h3>\n");
            for (Parameter<?> param : params) {
                fw.write("<b>" + param.getName() + ":</b> " + String.valueOf(param.getValue()) + "<br>\n");
            }
            fw.write("<br>\n");
        }
        fw.write("</p>\n");
    }

    public static void writePaperHTML(File scenariosFile, File inputDir, File outputDir) throws IOException, DocumentException {
        String resultFileName = "results_descendents.bin";
        String urlBase = "http://opensha.usc.edu/ftp/UCERF3-ETAS/scenarios";
        HashBasedTable dirNameMap = HashBasedTable.create();
        for (String dirName : Files.readLines((File)scenariosFile, (Charset)Charset.defaultCharset())) {
            double inputDuration;
            Long ot;
            if ((dirName = dirName.trim()).startsWith("#") || dirName.isEmpty()) continue;
            System.out.println("Processing " + dirName);
            File dir = new File(inputDir, dirName);
            Preconditions.checkState((boolean)dir.exists(), (Object)("Directory not found: " + dir.getAbsolutePath()));
            File resultsFile = new File(dir, resultFileName);
            Preconditions.checkState((boolean)resultsFile.exists(), (Object)("Results file not found: " + resultsFile.getAbsolutePath()));
            File origPlotDir = new File(dir, plotDirName);
            Preconditions.checkArgument((boolean)origPlotDir.exists(), (Object)("Plot dir not found: " + origPlotDir.getAbsolutePath()));
            File myOutput = new File(outputDir, dirName);
            Preconditions.checkArgument((myOutput.exists() || myOutput.mkdir() ? 1 : 0) != 0);
            ETAS_Simulator.TestScenario scenario = ETAS_MultiSimAnalysisTools.detectScenario(dir);
            File metadataFile = new File(resultsFile.getParentFile(), "metadata.xml");
            System.out.println("Metadatafile: " + metadataFile.getAbsolutePath());
            Element metadataRootEl = null;
            if (!metadataFile.exists()) {
                throw new IllegalStateException("couldn't load params");
            }
            System.out.println("Loading ETAS params from metadata file: " + metadataFile.getAbsolutePath());
            Document doc = XMLUtils.loadDocument(metadataFile);
            metadataRootEl = doc.getRootElement();
            ETAS_ParameterList params = ETAS_MultiSimAnalysisTools.loadEtasParamsFromMetadata(metadataRootEl);
            dirNameMap.put((Object)scenario, (Object)params.getU3ETAS_ProbModel(), (Object)dirName);
            if (metadataRootEl != null) {
                Element paramsEl = metadataRootEl.element("MiscParams");
                ot = Long.parseLong(paramsEl.attributeValue("ot"));
                inputDuration = Double.parseDouble(paramsEl.attributeValue("duration"));
            } else {
                System.out.println("WARNING: Assuming 1 year 2014");
                ot = Math.round(1.3885344E12);
                inputDuration = 1.0;
            }
            List<ETAS_CatalogIO.ETAS_Catalog> catalogs = ETAS_CatalogIO.loadCatalogsBinary(resultsFile, 4.0);
            DataUtils.MinMaxAveTracker durationTrack = new DataUtils.MinMaxAveTracker();
            for (List list : catalogs) {
                if (list.isEmpty()) {
                    durationTrack.addValue(0.0);
                    continue;
                }
                durationTrack.addValue(ETAS_MultiSimAnalysisTools.calcDurationYears(list));
            }
            Object name = scenario == null ? "" : String.valueOf((Object)scenario) + " ";
            name = (String)name + (int)inputDuration + "yr";
            if (params != null) {
                name = (String)name + " " + String.valueOf((Object)params.getU3ETAS_ProbModel());
            }
            ETAS_MultiSimAnalysisTools.writePaperHTML(origPlotDir, myOutput, scenario, (String)name, params, catalogs, inputDuration, durationTrack);
        }
        ArrayList scenarios = Lists.newArrayList((Iterable)dirNameMap.rowKeySet());
        Collections.sort(scenarios, new Comparator<ETAS_Simulator.TestScenario>(){

            @Override
            public int compare(ETAS_Simulator.TestScenario o1, ETAS_Simulator.TestScenario o2) {
                return o1.toString().compareTo(o2.toString());
            }
        });
        FileWriter fw = new FileWriter(new File(outputDir, "index.html"));
        for (ETAS_Simulator.TestScenario scenario : scenarios) {
            String link;
            String line = scenario.toString() + ":";
            if (dirNameMap.contains((Object)scenario, (Object)U3ETAS_ProbabilityModelOptions.FULL_TD)) {
                link = urlBase + "/" + (String)dirNameMap.get((Object)scenario, (Object)U3ETAS_ProbabilityModelOptions.FULL_TD);
                line = line + " <a href=\"" + link + "\">Full TD</a>";
            }
            if (dirNameMap.contains((Object)scenario, (Object)U3ETAS_ProbabilityModelOptions.NO_ERT)) {
                link = urlBase + "/" + (String)dirNameMap.get((Object)scenario, (Object)U3ETAS_ProbabilityModelOptions.NO_ERT);
                line = line + " <a href=\"" + link + "\">No ERT</a>";
            }
            fw.write(line + "<br>\n");
        }
        fw.close();
    }

    private static void copyFiles(File fromDir, File toDir, String pattern) throws IOException {
        for (File file : fromDir.listFiles()) {
            if (!file.getName().contains(pattern)) continue;
            Files.copy((File)file, (File)new File(toDir, file.getName()));
        }
    }

    private static void writePaperHTML(File origPlotDir, File outputDir, ETAS_Simulator.TestScenario scenario, String scenName, ETAS_ParameterList params, List<? extends List<ETAS_EqkRupture>> catalogs, double inputDuration, DataUtils.MinMaxAveTracker durationTrack) throws IOException {
        System.out.println("Writing HTML");
        FileWriter headerFW = new FileWriter(new File(outputDir, "HEADER.html"));
        FileWriter footerFW = new FileWriter(new File(outputDir, "README.html"));
        headerFW.write("<h1 style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal;\">" + scenName + "</h1>\n");
        headerFW.write("<br>\n");
        ETAS_MultiSimAnalysisTools.writeMetadataHTML(footerFW, scenario, params, catalogs, inputDuration, durationTrack);
        footerFW.close();
        headerFW.write("<p style=\"font-family:'HelveticaNeue-Light', sans-serif; font-weight:normal; width:800;\">\n");
        headerFW.write("<b>Plots are divided into 3 categories:</b><br>\n");
        headerFW.write("<b>full_children_*:</b> Plots that include all generations of child events<br>\n");
        headerFW.write("<b>primary_*:</b> Plots that only consider primary aftershocks<br>\n");
        headerFW.write("<b>(other):</b> Plots where both are included or separation is not applicable<br>\n");
        headerFW.write("<br>\n");
        headerFW.write("<b>MFD Plots:</b><br>\n");
        ETAS_MultiSimAnalysisTools.copyFiles(origPlotDir, outputDir, "consolidated_aftershocks_mag_num_cumulative");
        headerFW.write("<b>consolidated_aftershocks_mag_num_cumulative.*:</b> Cumulative magnitude frequency distributious across all catalogs<br>\n");
        headerFW.write("<b>consolidated_aftershocks_mag_num_incremental.*:</b> Incremental magnitude frequency distributious across all catalogs<br>\n");
        headerFW.write("<br>\n");
        headerFW.write("<b>Decay Plots:</b><br>\n");
        ETAS_MultiSimAnalysisTools.copyFiles(origPlotDir, outputDir, "_dist_decay_trigger");
        headerFW.write("<b>*_dist_decay_trigger.*:</b> Distance decay of each child rupture from the trigger location on the parent rupture<br>\n");
        ETAS_MultiSimAnalysisTools.copyFiles(origPlotDir, outputDir, "_temporal_decay");
        headerFW.write("<b>*_temporal_decay.*:</b> Temporal decay of each child rupture relative to its parent<br>\n");
        headerFW.write("<br>\n");
        headerFW.write("<b>Map Based Plots:</b><br>\n");
        ETAS_MultiSimAnalysisTools.copyFiles(origPlotDir, outputDir, "_sect_partic");
        headerFW.write("<b>*_sect_partic.*:</b> Map view of supra-seismogenic fault section participation rates<br>\n");
        ETAS_MultiSimAnalysisTools.copyFiles(origPlotDir, outputDir, "_sect_trigger");
        headerFW.write("<b>*_sect_trigger.*:</b> Map view of supra-seismogenic fault section trigger rates<br>\n");
        ETAS_MultiSimAnalysisTools.copyFiles(origPlotDir, outputDir, "_gridded_nucl_");
        headerFW.write("<b>*_gridded_nucl_m*.*:</b> Map view of gridded nucleation rates<br>\n");
        headerFW.write("</p>\n");
        headerFW.close();
    }
}

