/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.EnumSet;
import java.util.List;
import java.util.Map;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import org.dom4j.DocumentException;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.gui.ConsoleWindow;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.editor.impl.ParameterListEditor;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.BooleanParameter;
import org.opensha.commons.param.impl.ButtonParameter;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.param.impl.FileParameter;
import org.opensha.commons.param.impl.LongParameter;
import org.opensha.commons.param.impl.ParameterListParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class ETAS_SimulationGUI
extends JFrame
implements ParameterChangeListener {
    private ParameterList paramList;
    private ETAS_ParameterList etasParams;
    private FileParameter outputDirectoryParam;
    private FileParameter cacheDirectoryParam;
    private FileParameter fssFileParam;
    private FileParameter inputCatalogParam;
    private EnumParameter<ETAS_Simulator.TestScenario> scenarioParam;
    private BooleanParameter includeSpontEventsParam;
    private BooleanParameter includeIndirectTriggeringParam;
    private static final String fract_sect_in_cube_file_name = "fractSectInCubeCache.bin";
    private static final String sect_in_cube_file_name = "sectInCubeCache.bin";
    private static final String cube_inside_poly_file_name = "cubeInsidePolyCache.bin";
    private static final String cache_url = "http://opensha.usc.edu/ftp/kmilner/ucerf3/etas_cache/fm3_1_mean_fss/";
    private static final String fss_file_name = "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip";
    private ButtonParameter calcButton;
    private LongParameter randSeedParam;
    private BooleanParameter debugParam;
    private BooleanParameter pauseParam;
    private ConsoleWindow console;
    private FaultSystemSolution sol;
    private List<float[]> fractionSectInCubeCache;
    private List<int[]> sectInCubeCache;
    private int[] cubeInsidePolyCache;
    private Map<Integer, List<LastEventData>> lastEventData;
    private ParameterListEditor editor;
    private CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = RELM_RegionUtils.getGriddedRegionInstance();

    public ETAS_SimulationGUI() {
        this.setDefaultCloseOperation(3);
        this.console = new ConsoleWindow();
        this.etasParams = new ETAS_ParameterList();
        this.paramList = new ParameterList();
        this.outputDirectoryParam = new FileParameter("Output Directory (REQUIRED)");
        this.outputDirectoryParam.setDirectorySelect(true);
        this.paramList.addParameter(this.outputDirectoryParam);
        this.cacheDirectoryParam = new FileParameter("Cache Directory (optional)");
        this.cacheDirectoryParam.setDirectorySelect(true);
        this.cacheDirectoryParam.setInfo("Directory where input files are cached. Should contain fractSectInCubeCache.bin, sectInCubeCache.bin, and cubeInsidePolyCache.bin, or they will be downloaded on demand from http://opensha.usc.edu/ftp/kmilner/ucerf3/etas_cache/fm3_1_mean_fss/\nDefault: ~/.opensha/etas_cache");
        File defaultCacheDir = new File(new File(System.getProperty("user.home")), ".opensha" + File.separator + "etas_cache");
        if (!defaultCacheDir.exists()) {
            defaultCacheDir.mkdirs();
        }
        if (defaultCacheDir.exists()) {
            this.cacheDirectoryParam.setValue(defaultCacheDir);
        }
        this.paramList.addParameter(this.cacheDirectoryParam);
        this.fssFileParam = new FileParameter("Fault System Solution File (optional)");
        this.fssFileParam.addParameterChangeListener(this);
        this.paramList.addParameter(this.fssFileParam);
        ParameterListParameter etasParamsParam = new ParameterListParameter("ETAS Parameters", this.etasParams);
        this.paramList.addParameter(etasParamsParam);
        this.includeSpontEventsParam = new BooleanParameter("Include Spontaneous Events", true);
        this.paramList.addParameter(this.includeSpontEventsParam);
        this.includeIndirectTriggeringParam = new BooleanParameter("Include Indirect Triggering", true);
        this.paramList.addParameter(this.includeIndirectTriggeringParam);
        this.scenarioParam = new EnumParameter<Object>("Scenario", EnumSet.allOf(ETAS_Simulator.TestScenario.class), null, "(none)");
        this.paramList.addParameter(this.scenarioParam);
        this.inputCatalogParam = new FileParameter("Input Historical Catalog (optional)");
        this.paramList.addParameter(this.inputCatalogParam);
        this.randSeedParam = new LongParameter("Random Seed");
        this.paramList.addParameter(this.randSeedParam);
        this.debugParam = new BooleanParameter("Show Debug Messages/Plots", true);
        this.paramList.addParameter(this.debugParam);
        this.pauseParam = new BooleanParameter("Pause Before Event Generation", false);
        this.paramList.addParameter(this.pauseParam);
        this.calcButton = new ButtonParameter("ETAS Simulation", "Start Simulation");
        this.calcButton.addParameterChangeListener(this);
        this.paramList.addParameter(this.calcButton);
        this.editor = new ParameterListEditor(this.paramList);
        this.setContentPane(this.editor);
        this.setSize(400, 800);
        this.setTitle("ETAS Simulation GUI");
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (event.getParameter() == this.calcButton) {
            final ETAS_SimulationGUI gui = this;
            new Thread(this){
                final /* synthetic */ ETAS_SimulationGUI this$0;
                {
                    this.this$0 = this$0;
                }

                @Override
                public void run() {
                    this.this$0.editor.setEnabled(false);
                    try {
                        this.this$0.calculate();
                    }
                    catch (Throwable e) {
                        e.printStackTrace();
                        if (e instanceof OutOfMemoryError) {
                            JOptionPane.showMessageDialog(gui, "Run again allocating more memory\nex for 6 GB: java -Xmx6G <jar-file-name>", "Out of Memory!", 0);
                        }
                        JOptionPane.showMessageDialog(gui, e.getMessage(), "Error", 0);
                    }
                    this.this$0.editor.setEnabled(true);
                }
            }.start();
        } else if (event.getParameter() == this.fssFileParam) {
            this.sol = null;
        }
    }

    private void calculate() throws IOException, DocumentException {
        this.console.setVisible(true);
        System.out.println("Calculating");
        ETAS_Simulator.D = (Boolean)this.debugParam.getValue();
        ETAS_Simulator.pause_for_events = (Boolean)this.pauseParam.getValue();
        Long ot = Math.round(1.3885344E12);
        File outputDir = (File)this.outputDirectoryParam.getValue();
        Preconditions.checkNotNull((Object)outputDir, (Object)"Must Slect Output Directory");
        Preconditions.checkState((outputDir.exists() && outputDir.isDirectory() ? 1 : 0) != 0, (Object)"Output directory doesn't exist or isn't a directory");
        File cacheDir = (File)this.cacheDirectoryParam.getValue();
        Preconditions.checkNotNull((Object)cacheDir, (Object)"Must Slect Cache Directory - for some reason this couldn't be set by default, please select a directory where we can save files");
        Preconditions.checkState((cacheDir.exists() && cacheDir.isDirectory() ? 1 : 0) != 0, (Object)"Cache directory doesn't exist or isn't a directory");
        System.out.println("Checking cahces");
        try {
            if (this.fractionSectInCubeCache == null) {
                File fractionSectInCubeFile = new File(cacheDir, fract_sect_in_cube_file_name);
                if (!fractionSectInCubeFile.exists()) {
                    System.out.println("Fraction sect in cube cache file doesn't exist, downloading");
                    FileUtils.downloadURL("http://opensha.usc.edu/ftp/kmilner/ucerf3/etas_cache/fm3_1_mean_fss/fractSectInCubeCache.bin", fractionSectInCubeFile);
                }
                System.out.println("Loading fraction sect in cube cache file");
                this.fractionSectInCubeCache = MatrixIO.floatArraysListFromFile(fractionSectInCubeFile);
                System.out.println("Done loading fraction sect in cube cache file");
            }
            if (this.sectInCubeCache == null) {
                File sectInCubeFile = new File(cacheDir, sect_in_cube_file_name);
                if (!sectInCubeFile.exists()) {
                    System.out.println("Sect in cube cache file doesn't exist, downloading");
                    FileUtils.downloadURL("http://opensha.usc.edu/ftp/kmilner/ucerf3/etas_cache/fm3_1_mean_fss/sectInCubeCache.bin", sectInCubeFile);
                }
                System.out.println("Loading sect in cube cache file");
                this.sectInCubeCache = MatrixIO.intArraysListFromFile(sectInCubeFile);
                System.out.println("Done loading sect in cube cache file");
            }
            if (this.cubeInsidePolyCache == null) {
                File srcAtPointListFile = new File(cacheDir, cube_inside_poly_file_name);
                if (!srcAtPointListFile.exists()) {
                    System.out.println("Cube inside poly cache file doesn't exist, downloading");
                    FileUtils.downloadURL("http://opensha.usc.edu/ftp/kmilner/ucerf3/etas_cache/fm3_1_mean_fss/cubeInsidePolyCache.bin", srcAtPointListFile);
                }
                System.out.println("Loading cube inside polygon cache file");
                this.cubeInsidePolyCache = MatrixIO.intArrayFromFile(srcAtPointListFile);
                System.out.println("Done loading cube inside polygon cache file");
            }
        }
        catch (IllegalStateException e) {
            JOptionPane.showMessageDialog(null, "Try deleting the contents of " + cacheDir.getAbsolutePath() + " and run again. Be patient as the cached files are downloaded next time you run.", "Bad cached input file", 0);
            throw e;
        }
        System.out.println("Done loading caches");
        System.out.println("Will save results to: " + outputDir.getAbsolutePath());
        Long randomSeed = (Long)this.randSeedParam.getValue();
        if (randomSeed == null) {
            randomSeed = System.currentTimeMillis();
        }
        System.out.println("Random seed: " + randomSeed);
        if (this.sol == null) {
            File fssFile = (File)this.fssFileParam.getValue();
            if (fssFile == null && !(fssFile = new File(cacheDir, fss_file_name)).exists()) {
                System.out.println("Downloading Default Fault System Solution");
                FileUtils.downloadURL("http://opensha.usc.edu/ftp/kmilner/ucerf3/etas_cache/fm3_1_mean_fss/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip", fssFile);
            }
            this.sol = U3FaultSystemIO.loadSol(fssFile);
        }
        if (this.lastEventData == null) {
            this.lastEventData = LastEventData.load();
        }
        LastEventData.populateSubSects(this.sol.getRupSet().getFaultSectionDataList(), this.lastEventData);
        FaultSystemSolutionERF_ETAS erf = ETAS_Launcher.buildERF(this.sol, false, 1.0, 2014);
        erf.updateForecast();
        ObsEqkRupList histQkList = this.inputCatalogParam.getValue() != null ? UCERF3_CatalogParser.loadCatalog((File)this.inputCatalogParam.getValue()) : new ObsEqkRupList();
        ETAS_Simulator.TestScenario scenario = (ETAS_Simulator.TestScenario)((Object)this.scenarioParam.getValue());
        ETAS_EqkRupture scenarioRup = ETAS_Simulator.buildScenarioRup(scenario, erf, ETAS_Simulator.getTimeInMillisFromYear(2014.0));
        ETAS_Simulator.runETAS_Simulation(outputDir, (AbstractNthRupERF)erf, (GriddedRegion)this.griddedRegion, scenarioRup, (List<? extends ObsEqkRupture>)histQkList, (boolean)((Boolean)this.includeSpontEventsParam.getValue()), (boolean)((Boolean)this.includeIndirectTriggeringParam.getValue()), this.griddedRegion.getLatSpacing(), null, randomSeed, this.fractionSectInCubeCache, this.sectInCubeCache, this.cubeInsidePolyCache, this.etasParams, null, null);
        System.out.println("Done calculating");
    }

    public static void main(String[] args) {
        new ETAS_SimulationGUI();
    }
}

