/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.NoFaultsModel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Maps;
import java.awt.Color;
import java.io.BufferedInputStream;
import java.io.DataInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.LocationVector;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.mapping.gmt.GMT_MapGenerator;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.mapping.gmt.gui.GMT_MapGuiBean;
import org.opensha.commons.mapping.gmt.gui.ImageViewerWindow;
import org.opensha.commons.param.impl.CPTParameter;
import org.opensha.commons.util.FileUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.PointSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.analysis.GMT_CA_Maps;
import scratch.UCERF3.erf.ETAS.ETAS_CubeDiscretizationParams;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_LocationWeightCalculator;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.ETAS_Simulator_NoFaults;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.UCERF3_GriddedSeisOnlyERF_ETAS;
import scratch.UCERF3.utils.RELM_RegionUtils;

public class ETAS_PrimaryEventSampler_noFaults {
    boolean APPLY_ERT_GRIDDED = true;
    static final boolean D = ETAS_Simulator.D;
    int numCubeDepths;
    int numCubesPerDepth;
    int numCubes;
    int numParDepths;
    int numParLocsPerDepth;
    int numParLocs;
    double maxDepth;
    double depthDiscr;
    GriddedRegion origGriddedRegion;
    GriddedRegion gridRegForCubes;
    GriddedRegion gridRegForParentLocs;
    double cubeLatLonSpacing;
    AbstractNthRupERF erf;
    int totNumSrc;
    int numPtSrcSubPts;
    double pointSrcDiscr;
    double[] latForCubeCenter;
    double[] lonForCubeCenter;
    double[] depthForCubeCenter;
    double[] sourceRates;
    SummedMagFreqDist longTermTotalERF_MFD;
    double totRate;
    int[] origGridSeisTrulyOffVsSubSeisStatus;
    IntegerPDF_FunctionSampler cubeSamplerGriddedRatesOnly;
    Map<Integer, ArrayList<ETAS_EqkRupture>> eventListForParLocIndexMap;
    double etasDistDecay;
    double etasMinDist;
    boolean includeERF_Rates = false;
    U3ETAS_ProbabilityModelOptions probModel;
    boolean includeSpatialDecay;
    ETAS_LocationWeightCalculator locWeightCalc;
    SummedMagFreqDist[] mfdForSrcArray;
    ETAS_Utils etas_utils;
    ETAS_ParameterList etasParams;
    private boolean warnedNegDepth = false;
    private boolean warnedBelow = false;

    public ETAS_PrimaryEventSampler_noFaults(ETAS_CubeDiscretizationParams cubeParams, AbstractNthRupERF erf, double[] sourceRates, String outputFileNameWithPath, ETAS_ParameterList etasParams, ETAS_Utils etas_utils) {
        this.etasParams = etasParams;
        this.etasDistDecay = etasParams.get_q();
        this.etasMinDist = etasParams.get_d();
        this.probModel = etasParams.getU3ETAS_ProbModel();
        this.APPLY_ERT_GRIDDED = this.probModel == U3ETAS_ProbabilityModelOptions.FULL_TD;
        this.includeSpatialDecay = true;
        this.origGriddedRegion = cubeParams.getGriddedRegion();
        this.cubeLatLonSpacing = this.pointSrcDiscr / (double)this.numPtSrcSubPts;
        if (D) {
            System.out.println("Gridded Region has " + this.origGriddedRegion.getNumLocations() + " cells");
        }
        this.numPtSrcSubPts = cubeParams.getNumPtSrcSubPts();
        this.erf = erf;
        this.maxDepth = cubeParams.getMaxDepth();
        this.depthDiscr = cubeParams.getDepthDiscr();
        this.pointSrcDiscr = cubeParams.getPointSrcDiscr();
        this.numCubeDepths = (int)Math.round(this.maxDepth / this.depthDiscr);
        this.etas_utils = etas_utils;
        this.gridRegForCubes = cubeParams.getGridRegForCubes();
        this.gridRegForParentLocs = cubeParams.getGridRegForParentLocs();
        this.numCubesPerDepth = this.gridRegForCubes.getNumLocations();
        this.numCubes = this.numCubesPerDepth * this.numCubeDepths;
        this.numParDepths = this.numCubeDepths + 1;
        this.numParLocsPerDepth = this.gridRegForParentLocs.getNumLocations();
        this.numParLocs = this.numParLocsPerDepth * this.numParDepths;
        if (D) {
            System.out.println("numParLocsPerDepth=" + this.numParLocsPerDepth);
            System.out.println("numCubesPerDepth=" + this.numCubesPerDepth);
        }
        this.eventListForParLocIndexMap = Maps.newHashMap();
        this.totNumSrc = erf.getNumSources();
        if (this.totNumSrc != sourceRates.length) {
            throw new RuntimeException("Problem with number of sources");
        }
        if (D) {
            System.out.println("totNumSrc=" + this.totNumSrc + "\tnumPointsForRates=" + this.numCubes);
        }
        this.sourceRates = sourceRates;
        if (D) {
            System.gc();
        }
        if (D) {
            ETAS_SimAnalysisTools.writeMemoryUse("Memory before making data");
        }
        this.latForCubeCenter = new double[this.numCubes];
        this.lonForCubeCenter = new double[this.numCubes];
        this.depthForCubeCenter = new double[this.numCubes];
        for (int i = 0; i < this.numCubes; ++i) {
            int[] regAndDepIndex = this.getCubeRegAndDepIndicesForIndex(i);
            Location loc = this.gridRegForCubes.getLocation(regAndDepIndex[0]);
            this.latForCubeCenter[i] = loc.getLatitude();
            this.lonForCubeCenter[i] = loc.getLongitude();
            this.depthForCubeCenter[i] = this.getCubeDepth(regAndDepIndex[1]);
        }
        this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        long startTime = System.currentTimeMillis();
        if (D) {
            System.out.println("Starting getCubeSamplerWithERF_RatesOnly()");
        }
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        double runtime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        if (D) {
            System.out.println("getCubeSamplerWithERF_RatesOnly() took (sec): " + runtime);
        }
        this.locWeightCalc = cubeParams.getLocationWeightCalc(etasParams);
    }

    public void addRuptureToProcess(ETAS_EqkRupture rup) {
        int parLocIndex = this.getParLocIndexForLocation(rup.getParentTriggerLoc());
        if (parLocIndex != -1) {
            if (this.eventListForParLocIndexMap.keySet().contains(parLocIndex)) {
                this.eventListForParLocIndexMap.get(parLocIndex).add(rup);
            } else {
                ArrayList<ETAS_EqkRupture> list = new ArrayList<ETAS_EqkRupture>();
                list.add(rup);
                this.eventListForParLocIndexMap.put(parLocIndex, list);
            }
        }
    }

    public IntegerPDF_FunctionSampler old_getAveSamplerForRupture(EqkRupture mainshock) {
        long st = System.currentTimeMillis();
        IntegerPDF_FunctionSampler aveSampler = new IntegerPDF_FunctionSampler(this.numCubes);
        LocationList locList = mainshock.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
        for (Location loc : locList) {
            int parLocIndex = this.getParLocIndexForLocation(loc);
            IntegerPDF_FunctionSampler sampler = this.getCubeSampler(parLocIndex);
            for (int i = 0; i < this.numCubes; ++i) {
                aveSampler.add(i, sampler.getY(i));
            }
        }
        if (D) {
            double sec = (double)(System.currentTimeMillis() - st) / 1000.0;
            System.out.println("getAveSamplerForRupture() took (sec): " + (float)sec);
        }
        return aveSampler;
    }

    public LocationList getParentTriggerCubeLocationsForLargePointSource(Location hypoLoc, double mag) {
        LocationList locList = new LocationList();
        if (mag <= 4.0) {
            locList.add(hypoLoc);
        } else {
            double radius = ETAS_Utils.getRuptureRadiusFromMag(mag);
            for (int c = 0; c < this.numParLocs; ++c) {
                Location parLoc = this.getParLocationForIndex(c);
                if (!(LocationUtils.linearDistanceFast(hypoLoc, parLoc) <= radius)) continue;
                locList.add(parLoc);
            }
        }
        return locList;
    }

    public IntegerPDF_FunctionSampler getAveSamplerForRupture(ETAS_EqkRupture mainshock) {
        LocationList locList;
        long st = System.currentTimeMillis();
        IntegerPDF_FunctionSampler aveSampler = new IntegerPDF_FunctionSampler(this.numCubes);
        LocationList locList2 = null;
        if (mainshock.getRuptureSurface().isPointSurface()) {
            locList = this.getParentTriggerCubeLocationsForLargePointSource(mainshock.getHypocenterLocation(), mainshock.getMag());
            if (locList.size() == 1) {
                return this.getCubeSampler(this.getParLocIndexForLocation((Location)locList.get(0)));
            }
            locList2 = locList;
        } else {
            if (mainshock.getFSSIndex() != -1) {
                RuptureSurface surf = mainshock.getRuptureSurface();
                locList = surf.getEvenlyDiscritizedListOfLocsOnSurface();
            } else {
                locList = mainshock.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
            }
            locList2 = new ArrayList();
            for (Object loc : locList) {
                locList2.add(new Location(((Location)loc).getLatitude() + 0.005, ((Location)loc).getLongitude() + 0.005, ((Location)loc).getDepth()));
                locList2.add(new Location(((Location)loc).getLatitude() + 0.005, ((Location)loc).getLongitude() - 0.005, ((Location)loc).getDepth()));
                locList2.add(new Location(((Location)loc).getLatitude() - 0.005, ((Location)loc).getLongitude() + 0.005, ((Location)loc).getDepth()));
                locList2.add(new Location(((Location)loc).getLatitude() - 0.005, ((Location)loc).getLongitude() - 0.005, ((Location)loc).getDepth()));
            }
        }
        HashMap<Integer, Double> parLocMap = new HashMap<Integer, Double>();
        for (Location loc : locList2) {
            int parLocIndex = this.getParLocIndexForLocation(loc);
            if (parLocMap.containsKey(parLocIndex)) {
                double newVal = 1.0 + (Double)parLocMap.get(parLocIndex);
                parLocMap.put(parLocIndex, newVal);
                continue;
            }
            parLocMap.put(parLocIndex, 1.0);
        }
        CalcProgressBar progressBar = null;
        if (D) {
            progressBar = new CalcProgressBar("getAveSamplerForRupture(*)", "junk");
            progressBar.showProgress(true);
        }
        int progress = 0;
        Iterator parLocIndex = parLocMap.keySet().iterator();
        while (parLocIndex.hasNext()) {
            int parLocIndex2 = (Integer)parLocIndex.next();
            if (D) {
                progressBar.updateProgress(progress, parLocMap.keySet().size());
                ++progress;
            }
            if (parLocIndex2 == -1) continue;
            IntegerPDF_FunctionSampler sampler = this.getCubeSampler(parLocIndex2);
            for (int i = 0; i < this.numCubes; ++i) {
                aveSampler.add(i, sampler.getY(i) * (Double)parLocMap.get(parLocIndex2));
            }
        }
        if (D) {
            progressBar.showProgress(false);
            double sec = (double)(System.currentTimeMillis() - st) / 1000.0;
            System.out.println("getAveSamplerForRupture() took (sec): " + (float)sec);
        }
        return aveSampler;
    }

    public Hashtable<Integer, Double> getRelativeTriggerProbOfSourcesInCube(int cubeIndex, double fracSupra) {
        Hashtable<Integer, Double> probForSrcHashtable = this.getNucleationRatesOfSourcesInCube(cubeIndex, fracSupra);
        if (probForSrcHashtable == null) {
            return null;
        }
        double sum = 0.0;
        for (int srcIndex : probForSrcHashtable.keySet()) {
            sum += probForSrcHashtable.get(srcIndex).doubleValue();
        }
        for (int srcIndex : probForSrcHashtable.keySet()) {
            double normVal = probForSrcHashtable.get(srcIndex) / sum;
            probForSrcHashtable.put(srcIndex, normVal);
        }
        if (D) {
            double testVal = 0.0;
            for (int srcIndex : probForSrcHashtable.keySet()) {
                testVal += probForSrcHashtable.get(srcIndex).doubleValue();
            }
            if (testVal < 0.9999 || testVal > 1.0001) {
                throw new RuntimeException("PROBLEM");
            }
        }
        return probForSrcHashtable;
    }

    public Hashtable<Integer, Double> getNucleationRatesOfSourcesInCube(int cubeIndex, double fracSupra) {
        Hashtable<Integer, Double> rateForSrcHashtable = new Hashtable<Integer, Double>();
        int gridSrcIndex = -1;
        double gridSrcRate = 0.0;
        int griddeSeisRegionIndex = this.origGriddedRegion.indexForLocation(this.getCubeLocationForIndex(cubeIndex));
        if (griddeSeisRegionIndex != -1) {
            gridSrcIndex = griddeSeisRegionIndex;
            gridSrcRate = this.cubeSamplerGriddedRatesOnly.getY(cubeIndex);
            rateForSrcHashtable.put(gridSrcIndex, gridSrcRate);
            return rateForSrcHashtable;
        }
        return null;
    }

    public double[] getRelativeTriggerProbOfEachSource(IntegerPDF_FunctionSampler sampler, double frac, ETAS_EqkRupture rupture) {
        long st = System.currentTimeMillis();
        double[] trigProb = new double[this.erf.getNumSources()];
        sampler.scale(1.0 / sampler.getSumOfY_vals());
        CalcProgressBar progressBar = null;
        if (D) {
            progressBar = new CalcProgressBar("getRelativeTriggerProbOfEachSource", "junk");
            progressBar.showProgress(true);
        }
        List<Integer> list = sampler.getOrderedIndicesOfHighestXFract(frac);
        double fracSupra = 1.0;
        int numDone = 0;
        for (int i : list) {
            Hashtable<Integer, Double> relSrcProbForCube;
            if (D) {
                progressBar.updateProgress(numDone, list.size());
            }
            if (this.APPLY_ERT_GRIDDED) {
                fracSupra = this.getERT_MinFracSupra(rupture, this.getCubeLocationForIndex(i));
            }
            if ((relSrcProbForCube = this.getRelativeTriggerProbOfSourcesInCube(i, fracSupra)) != null) {
                Iterator<Integer> iterator = relSrcProbForCube.keySet().iterator();
                while (iterator.hasNext()) {
                    int srcKey;
                    int n = srcKey = iterator.next().intValue();
                    trigProb[n] = trigProb[n] + sampler.getY(i) * relSrcProbForCube.get(srcKey);
                }
            }
            ++numDone;
        }
        if (D) {
            progressBar.showProgress(false);
        }
        double testSum = 0.0;
        for (int s = 0; s < trigProb.length; ++s) {
            testSum += trigProb[s];
        }
        if (testSum < 0.9999 || testSum > 1.0001) {
            System.out.println("testSum=" + testSum);
        }
        if (D) {
            st = System.currentTimeMillis() - st;
            System.out.println("getRelativeTriggerProbOfEachSource took:" + (float)st / 1000.0f + " sec");
        }
        return trigProb;
    }

    public SummedMagFreqDist getExpectedPrimaryMFD_PDF(double[] relSrcProbs) {
        long st = System.currentTimeMillis();
        SummedMagFreqDist magDist = new SummedMagFreqDist(2.05, 8.95, 70);
        double testTotProb = 0.0;
        for (int s = 0; s < relSrcProbs.length; ++s) {
            IncrementalMagFreqDist srcMFD = this.mfdForSrcArray == null ? ERF_Calculator.getTotalMFD_ForSource(this.erf.getSource(s), 1.0, 2.05, 8.95, 70, true) : this.mfdForSrcArray[s].deepClone();
            srcMFD.normalizeByTotalRate();
            srcMFD.scale(relSrcProbs[s]);
            double totMFD_Prob = srcMFD.getTotalIncrRate();
            if (Double.isNaN(totMFD_Prob)) continue;
            testTotProb += totMFD_Prob;
            magDist.addIncrementalMagFreqDist(srcMFD);
        }
        if (D) {
            System.out.println("\ttestTotProb=" + testTotProb);
            st = System.currentTimeMillis() - st;
            System.out.println("getExpectedPrimaryMFD_PDF took:" + (float)st / 1000.0f + " sec");
        }
        return magDist;
    }

    private double getERT_MinFracSupra(ETAS_EqkRupture parentRup, Location cubeLoc) {
        double minFrac = this.getERT_FracSupra(parentRup, cubeLoc);
        ETAS_EqkRupture previousParent = parentRup;
        while (previousParent.getParentRup() != null) {
            ETAS_EqkRupture nextParent = previousParent.getParentRup();
            double newFrac = this.getERT_FracSupra(nextParent, cubeLoc);
            if (newFrac < minFrac) {
                minFrac = newFrac;
            }
            previousParent = nextParent;
        }
        return minFrac;
    }

    private double getERT_FracSupra(ETAS_EqkRupture parentRup, Location cubeLoc) {
        if (parentRup.getFSSIndex() >= 0 || !this.APPLY_ERT_GRIDDED) {
            return 1.0;
        }
        double halfCubeWidth = 1.24;
        boolean pointSurface = parentRup.getRuptureSurface() instanceof PointSurface;
        if (!pointSurface) {
            if (D) {
                System.out.println("*****\nWarning: finite rupture not a FSS rupture, so no ERT applied; need to fix this at some point\n*******");
            }
            return 1.0;
        }
        double parMag = parentRup.getMag();
        if (parMag < 4.0) {
            return 1.0;
        }
        double srcRadius = ETAS_Utils.getRuptureRadiusFromMag(parMag);
        Location parLoc = ((PointSurface)parentRup.getRuptureSurface()).getLocation();
        double dist = LocationUtils.linearDistanceFast(parLoc, cubeLoc);
        double frac = dist <= srcRadius - halfCubeWidth ? 0.0 : (dist > srcRadius + halfCubeWidth ? 1.0 : (dist - srcRadius + halfCubeWidth) / (2.0 * halfCubeWidth));
        return frac;
    }

    public boolean setRandomPrimaryEvent(ETAS_EqkRupture rupToFillIn, double maxPointSourceMag) {
        Location tempLoc;
        int randSrcIndex;
        ETAS_EqkRupture parRup = rupToFillIn.getParentRup();
        Location actualParentLoc = rupToFillIn.getParentTriggerLoc();
        int parRegIndex = this.gridRegForParentLocs.indexForLocation(actualParentLoc);
        if (parRegIndex < 0) {
            if (D) {
                System.out.print("Warning: parent location outside of region; parRegIndex=" + parRegIndex + "; parentLoc=" + actualParentLoc.toString() + "; Num pts on main shock surface: " + parRup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface().size());
                if (parRup instanceof ETAS_EqkRupture) {
                    System.out.println("; Problem event generation: " + parRup.getGeneration());
                } else {
                    System.out.println(" ");
                }
            }
            return false;
        }
        int parLocIndex = this.getParLocIndexForLocation(actualParentLoc);
        Location translatedParLoc = this.getParLocationForIndex(parLocIndex);
        int aftShCubeIndex = -1;
        if (this.includeERF_Rates) {
            aftShCubeIndex = rupToFillIn.getCubeIndex();
            if (aftShCubeIndex == -1) {
                IntegerPDF_FunctionSampler sampler = this.getCubeSampler(parLocIndex);
                for (ETAS_EqkRupture tempRup : this.eventListForParLocIndexMap.get(parLocIndex)) {
                    tempRup.setCubeIndex(sampler.getRandomInt(this.etas_utils.getRandomDouble()));
                }
                this.eventListForParLocIndexMap.remove(parLocIndex);
                aftShCubeIndex = rupToFillIn.getCubeIndex();
                if (aftShCubeIndex == -1) {
                    throw new RuntimeException("Problem Here");
                }
            }
        } else {
            Location cubeLoc;
            Location relativeLoc = this.locWeightCalc.getRandomLoc(translatedParLoc.getDepth(), this.etas_utils);
            double latSign = 1.0;
            double lonSign = 1.0;
            if (this.etas_utils.getRandomDouble() < 0.5) {
                latSign = -1.0;
            }
            if (this.etas_utils.getRandomDouble() < 0.5) {
                lonSign = -1.0;
            }
            if ((aftShCubeIndex = this.getCubeIndexForLocation(cubeLoc = new Location(relativeLoc.getLatitude() * latSign + translatedParLoc.getLatitude(), relativeLoc.getLongitude() * lonSign + translatedParLoc.getLongitude(), relativeLoc.getDepth()))) == -1) {
                return false;
            }
            int griddeSeisRegionIndex = this.origGriddedRegion.indexForLocation(this.getCubeLocationForIndex(aftShCubeIndex));
            if (griddeSeisRegionIndex == -1) {
                return false;
            }
        }
        double fractionSupra = 0.0;
        int gridRegionIndex = randSrcIndex = this.getRandomSourceIndexInCube(aftShCubeIndex, fractionSupra);
        ProbEqkSource src = this.erf.getSource(randSrcIndex);
        int r = 0;
        if (src.getNumRuptures() > 1) {
            r = src.drawSingleRandomEqkRuptureIndexFromRelativeRates(this.etas_utils.getRandomDouble());
        }
        int nthRup = this.erf.getIndexN_ForSrcAndRupIndices(randSrcIndex, r);
        ProbEqkRupture erf_rup = src.getRupture(r);
        double relLat = this.latForCubeCenter[aftShCubeIndex] - translatedParLoc.getLatitude();
        double relLon = this.lonForCubeCenter[aftShCubeIndex] - translatedParLoc.getLongitude();
        double relDep = this.depthForCubeCenter[aftShCubeIndex] - translatedParLoc.getDepth();
        rupToFillIn.setGridNodeIndex(randSrcIndex);
        Location deltaLoc = this.locWeightCalc.getRandomDeltaLoc(Math.abs(relLat), Math.abs(relLon), this.depthForCubeCenter[aftShCubeIndex], translatedParLoc.getDepth(), this.etas_utils);
        double newLat = relLat < 0.0 ? this.latForCubeCenter[aftShCubeIndex] - deltaLoc.getLatitude() : this.latForCubeCenter[aftShCubeIndex] + deltaLoc.getLatitude();
        double newLon = relLon < 0.0 ? this.lonForCubeCenter[aftShCubeIndex] - deltaLoc.getLongitude() : this.lonForCubeCenter[aftShCubeIndex] + deltaLoc.getLongitude();
        double newDep = this.depthForCubeCenter[aftShCubeIndex] + deltaLoc.getDepth();
        Location randLoc = new Location(newLat, newLon, newDep);
        LocationVector corrVector = LocationUtils.vector(translatedParLoc, actualParentLoc);
        Location hypLoc = LocationUtils.location(randLoc, corrVector);
        if (hypLoc.getDepth() <= 0.0) {
            hypLoc = tempLoc = new Location(hypLoc.getLatitude(), hypLoc.getLongitude(), 1.0E-4);
        }
        if (hypLoc.getDepth() > this.maxDepth) {
            hypLoc = tempLoc = new Location(hypLoc.getLatitude(), hypLoc.getLongitude(), this.maxDepth - 1.0E-4);
        }
        if (erf_rup.getMag() < maxPointSourceMag) {
            rupToFillIn.setPointSurface(hypLoc);
        } else {
            double aveDip = erf_rup.getRuptureSurface().getAveDip();
            rupToFillIn.setRuptureSurface(this.etas_utils.getRandomFiniteRupSurface(erf_rup.getMag(), hypLoc, aveDip));
        }
        rupToFillIn.setHypocenterLocation(hypLoc);
        rupToFillIn.setAveRake(erf_rup.getAveRake());
        rupToFillIn.setMag(erf_rup.getMag());
        rupToFillIn.setNthERF_Index(nthRup);
        double distToParent = LocationUtils.linearDistanceFast(actualParentLoc, rupToFillIn.getHypocenterLocation());
        rupToFillIn.setDistanceToParent(distToParent);
        return true;
    }

    public Location getRandomFuzzyLocation(Location loc) {
        double sign1 = 1.0;
        double sign2 = 1.0;
        if (this.etas_utils.getRandomDouble() < 0.5) {
            sign1 = -1.0;
        }
        if (this.etas_utils.getRandomDouble() < 0.5) {
            sign2 = -1.0;
        }
        return new Location(loc.getLatitude() + sign1 * 0.005, loc.getLongitude() + sign2 * 0.005, loc.getDepth());
    }

    private IntegerPDF_FunctionSampler getCubeSampler(int locIndexForPar) {
        if (this.includeERF_Rates && this.includeSpatialDecay) {
            return this.getCubeSamplerWithDistDecay(locIndexForPar);
        }
        if (this.includeERF_Rates && !this.includeSpatialDecay) {
            return this.getCubeSamplerWithERF_GriddedRatesOnly();
        }
        if (!this.includeERF_Rates && this.includeSpatialDecay) {
            return this.getCubeSamplerWithOnlyDistDecay(locIndexForPar);
        }
        throw new IllegalStateException("include ERF rates and include spatial decay both false?");
    }

    private synchronized IntegerPDF_FunctionSampler getCubeSamplerWithERF_GriddedRatesOnly() {
        if (this.cubeSamplerGriddedRatesOnly == null) {
            this.cubeSamplerGriddedRatesOnly = new IntegerPDF_FunctionSampler(this.numCubes);
            for (int i = 0; i < this.numCubes; ++i) {
                double gridSrcRate = this.getGridSourcRateInCube(i, false);
                this.cubeSamplerGriddedRatesOnly.set(i, gridSrcRate);
            }
        }
        return this.cubeSamplerGriddedRatesOnly;
    }

    private IntegerPDF_FunctionSampler getCubeSamplerWithDistDecay(int parLocIndex) {
        Location parLoc = this.getParLocationForIndex(parLocIndex);
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        IntegerPDF_FunctionSampler sampler = new IntegerPDF_FunctionSampler(this.numCubeDepths * this.numCubesPerDepth);
        for (int index = 0; index < this.numCubes; ++index) {
            double relLat = Math.abs(parLoc.getLatitude() - this.latForCubeCenter[index]);
            double relLon = Math.abs(parLoc.getLongitude() - this.lonForCubeCenter[index]);
            sampler.set(index, this.locWeightCalc.getProbAtPoint(relLat, relLon, this.depthForCubeCenter[index], parLoc.getDepth()) * this.cubeSamplerGriddedRatesOnly.getY(index));
        }
        return sampler;
    }

    private IntegerPDF_FunctionSampler getCubeSamplerWithOnlyDistDecay(int parLocIndex) {
        Location parLoc = this.getParLocationForIndex(parLocIndex);
        IntegerPDF_FunctionSampler sampler = new IntegerPDF_FunctionSampler(this.numCubes);
        for (int index = 0; index < this.numCubes; ++index) {
            double relLat = Math.abs(parLoc.getLatitude() - this.latForCubeCenter[index]);
            double relLon = Math.abs(parLoc.getLongitude() - this.lonForCubeCenter[index]);
            sampler.set(index, this.locWeightCalc.getProbAtPoint(relLat, relLon, this.depthForCubeCenter[index], parLoc.getDepth()));
        }
        return sampler;
    }

    public double getGridSourcRateInCube(int cubeIndex, boolean debug) {
        int griddeSeisRegionIndex = this.origGriddedRegion.indexForLocation(this.getCubeLocationForIndex(cubeIndex));
        if (griddeSeisRegionIndex != -1) {
            int cubeRegIndex = this.getCubeRegAndDepIndicesForIndex(cubeIndex)[0];
            double origGridCellRate = this.mfdForSrcArray[griddeSeisRegionIndex].getTotalIncrRate();
            double rate = origGridCellRate / (double)(this.numPtSrcSubPts * this.numPtSrcSubPts * this.numCubeDepths);
            return rate;
        }
        return 0.0;
    }

    public int getRandomSourceIndexInCube(int cubeIndex, double fractionSupra) {
        int griddeSeisRegionIndex = this.origGriddedRegion.indexForLocation(this.getCubeLocationForIndex(cubeIndex));
        if (griddeSeisRegionIndex == -1) {
            throw new RuntimeException("No gridded source index for cube at: " + this.getCubeLocationForIndex(cubeIndex).toString());
        }
        return griddeSeisRegionIndex;
    }

    private int[] getCubeRegAndDepIndicesForIndex(int cubeIndex) {
        int[] indices = new int[2];
        indices[1] = (int)Math.floor((double)cubeIndex / (double)this.numCubesPerDepth);
        if (indices[1] >= this.numCubeDepths) {
            System.out.println("PROBLEM: " + cubeIndex + "\t" + this.numCubesPerDepth + "\t" + indices[1] + "\t" + this.numCubeDepths);
        }
        indices[0] = cubeIndex - indices[1] * this.numCubesPerDepth;
        return indices;
    }

    public Location getCubeLocationForIndex(int cubeIndex) {
        int[] regAndDepIndex = this.getCubeRegAndDepIndicesForIndex(cubeIndex);
        Location regLoc = this.gridRegForCubes.getLocation(regAndDepIndex[0]);
        return new Location(regLoc.getLatitude(), regLoc.getLongitude(), this.getCubeDepth(regAndDepIndex[1]));
    }

    public int getCubeIndexForLocation(Location loc) {
        int iReg = this.gridRegForCubes.indexForLocation(loc);
        if (iReg == -1) {
            return -1;
        }
        int iDep = this.getCubeDepthIndex(loc.getDepth());
        return this.getCubeIndexForRegAndDepIndices(iReg, iDep);
    }

    private int getCubeIndexForRegAndDepIndices(int iReg, int iDep) {
        int index = iDep * this.numCubesPerDepth + iReg;
        if (index < this.numCubes && index >= 0) {
            return index;
        }
        return -1;
    }

    private int getCubeDepthIndex(double depth) {
        int index = (int)Math.round((depth - this.depthDiscr / 2.0) / this.depthDiscr);
        return index;
    }

    private double getCubeDepth(int depthIndex) {
        return (double)depthIndex * this.depthDiscr + this.depthDiscr / 2.0;
    }

    private int[] getParRegAndDepIndicesForIndex(int parLocIndex) {
        int[] indices = new int[2];
        indices[1] = (int)Math.floor((double)parLocIndex / (double)this.numParLocsPerDepth);
        indices[0] = parLocIndex - indices[1] * this.numParLocsPerDepth;
        return indices;
    }

    public Location getParLocationForIndex(int parLocIndex) {
        int[] regAndDepIndex = this.getParRegAndDepIndicesForIndex(parLocIndex);
        Location regLoc = this.gridRegForParentLocs.getLocation(regAndDepIndex[0]);
        return new Location(regLoc.getLatitude(), regLoc.getLongitude(), this.getParDepth(regAndDepIndex[1]));
    }

    public int getParLocIndexForLocation(Location loc) {
        int iReg = this.gridRegForParentLocs.indexForLocation(loc);
        if (iReg == -1) {
            return -1;
        }
        int iDep = this.getParDepthIndex(loc.getDepth());
        if (iDep == -1) {
            return -1;
        }
        return this.getParLocIndexForRegAndDepIndices(iReg, iDep);
    }

    private int getParLocIndexForRegAndDepIndices(int iReg, int iDep) {
        return iDep * this.numParLocsPerDepth + iReg;
    }

    private int getParDepthIndex(double depth) {
        int depthIndex = (int)Math.round(depth / this.depthDiscr);
        if (depthIndex < 0) {
            if (!this.warnedNegDepth) {
                System.err.println("WARNING: negative depth (" + depth + "), moving to surface. Further warnings surpressed.");
            }
            this.warnedNegDepth = true;
            return 0;
        }
        if (depthIndex >= this.numParDepths) {
            if (!this.warnedBelow) {
                System.err.println("WARNING: depth (" + depth + ") below model max, moving to maxDepth=" + this.maxDepth + ". Further warnings surpressed");
            }
            this.warnedBelow = true;
            return this.numParDepths - 1;
        }
        return depthIndex;
    }

    private double getParDepth(int parDepthIndex) {
        return (double)parDepthIndex * this.depthDiscr;
    }

    public void testRates() {
        double totGriddedRate;
        if (D) {
            System.out.println("Running testRates()");
        }
        long startTime = System.currentTimeMillis();
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        double totRateTest1 = totGriddedRate = this.cubeSamplerGriddedRatesOnly.calcSumOfY_Vals();
        double totRateTest2 = 0.0;
        double duration = this.erf.getTimeSpan().getDuration();
        for (int s = 0; s < this.erf.getNumSources(); ++s) {
            ProbEqkSource src = this.erf.getSource(s);
            int numRups = src.getNumRuptures();
            for (int r = 0; r < numRups; ++r) {
                totRateTest2 += src.getRupture(r).getMeanAnnualRate(duration);
            }
        }
        double runTime = (double)(System.currentTimeMillis() - startTime) / 1000.0;
        if (D) {
            System.out.println("\tSum over cubes etc tot rate = " + (float)totRateTest1 + " should equal tot rate from ERF = " + (float)totRateTest2 + ";\tratio=" + (float)(totRateTest1 / totRateTest2) + ";\t totGriddedRate=" + (float)totGriddedRate);
            System.out.println("testRates() took (sec): " + (float)runTime);
        }
    }

    private void computeMFD_ForSrcArrays(double minMag, double maxMag, int numMag) {
        this.mfdForSrcArray = new SummedMagFreqDist[this.erf.getNumSources()];
        double duration = this.erf.getTimeSpan().getDuration();
        for (int s = 0; s < this.erf.getNumSources(); ++s) {
            this.mfdForSrcArray[s] = ERF_Calculator.getTotalMFD_ForSource(this.erf.getSource(s), duration, minMag, maxMag, numMag, true);
        }
    }

    private SummedMagFreqDist getCubeMFD(int cubeIndex) {
        if (this.mfdForSrcArray == null) {
            throw new RuntimeException("must run computeMFD_ForSrcArrays(*) first");
        }
        Hashtable<Integer, Double> rateForSrcInCubeHashtable = this.getNucleationRatesOfSourcesInCube(cubeIndex, 1.0);
        if (rateForSrcInCubeHashtable == null) {
            return null;
        }
        SummedMagFreqDist magDist = new SummedMagFreqDist(this.mfdForSrcArray[0].getMinX(), this.mfdForSrcArray[0].getMaxX(), this.mfdForSrcArray[0].size());
        for (int srcIndex : rateForSrcInCubeHashtable.keySet()) {
            SummedMagFreqDist mfd = null;
            double srcNuclRate = rateForSrcInCubeHashtable.get(srcIndex);
            int gridIndex = srcIndex;
            int cubeRegIndex = this.getCubeRegAndDepIndicesForIndex(cubeIndex)[0];
            mfd = this.mfdForSrcArray[srcIndex];
            double totRate = mfd.getTotalIncrRate();
            if (!(totRate > 0.0)) continue;
            for (int m = 0; m < mfd.size(); ++m) {
                magDist.add(m, mfd.getY(m) * srcNuclRate / totRate);
            }
        }
        return magDist;
    }

    public void testMagFreqDist() {
        if (D) {
            System.out.println("Running testMagFreqDist()");
        }
        SummedMagFreqDist magDist = new SummedMagFreqDist(2.05, 8.95, 70);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        for (int i = 0; i < this.numCubes; ++i) {
            progressBar.updateProgress(i, this.numCubes);
            SummedMagFreqDist mfd = this.getCubeMFD(i);
            if (mfd == null) continue;
            magDist.addIncrementalMagFreqDist(this.getCubeMFD(i));
        }
        progressBar.showProgress(false);
        magDist.setName("MFD from EqksAtPoint list");
        ArrayList<EvenlyDiscretizedFunc> magDistList = new ArrayList<EvenlyDiscretizedFunc>();
        magDistList.add(magDist);
        magDistList.add(magDist.getCumRateDistWithOffset());
        SummedMagFreqDist erfMFD = ERF_Calculator.getTotalMFD_ForERF(this.erf, 2.05, 8.95, 70, true);
        erfMFD.setName("MFD from ERF");
        magDistList.add(erfMFD);
        magDistList.add(erfMFD.getCumRateDistWithOffset());
        GraphWindow magDistsGraph = new GraphWindow(magDistList, "Mag-Freq Distributions");
        magDistsGraph.setX_AxisLabel("Mag");
        magDistsGraph.setY_AxisLabel("Rate");
        magDistsGraph.setY_AxisRange(1.0E-6, magDistsGraph.getY_AxisRange().getUpperBound());
        magDistsGraph.setYLog(true);
    }

    public void testGriddedSeisRatesInCubes() {
        int i;
        if (D) {
            System.out.println("testGriddedSeisRatesInCubes()");
        }
        CaliforniaRegions.RELM_TESTING_GRIDDED mapGriddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(mapGriddedRegion, true);
        for (int i2 = 0; i2 < xyzDataSet.size(); ++i2) {
            xyzDataSet.set(i2, 0.0);
        }
        double duration = this.erf.getTimeSpan().getDuration();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over sources", "junk");
        progressBar.showProgress(true);
        int iSrc = -1;
        int numSrc = this.erf.getNumSources();
        for (ProbEqkSource src : this.erf) {
            progressBar.updateProgress(++iSrc, numSrc);
            for (ProbEqkRupture rup : src) {
                LocationList locList = rup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
                double ptRate = rup.getMeanAnnualRate(duration) / (double)locList.size();
                for (Location loc : locList) {
                    int locIndex = mapGriddedRegion.indexForLocation(loc);
                    if (locIndex < 0) continue;
                    double oldRate = xyzDataSet.get(locIndex);
                    xyzDataSet.set(locIndex, ptRate + oldRate);
                }
            }
        }
        progressBar.showProgress(false);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        GriddedGeoDataSet xyzDataSet2 = new GriddedGeoDataSet(mapGriddedRegion, true);
        for (i = 0; i < xyzDataSet2.size(); ++i) {
            xyzDataSet2.set(i, 0.0);
        }
        progressBar = new CalcProgressBar("Looping over cubes", "junk");
        progressBar.showProgress(true);
        for (i = 0; i < this.numCubes; ++i) {
            progressBar.updateProgress(i, this.numCubes);
            double rate = this.cubeSamplerGriddedRatesOnly.getY(i);
            int locIndex = mapGriddedRegion.indexForLocation(this.getCubeLocationForIndex(i));
            if (locIndex < 0) continue;
            double oldRate = xyzDataSet2.get(locIndex);
            xyzDataSet2.set(locIndex, rate + oldRate);
        }
        progressBar.showProgress(false);
        double sum1 = 0.0;
        double sum2 = 0.0;
        for (int i3 = 0; i3 < xyzDataSet2.size(); ++i3) {
            sum1 += xyzDataSet.get(i3);
            sum2 += xyzDataSet2.get(i3);
            double diff = xyzDataSet2.get(i3) - xyzDataSet.get(i3);
            double absFractDiff = Math.abs(diff / xyzDataSet.get(i3));
            Location loc = xyzDataSet2.getLocation(i3);
            if (!(absFractDiff > 0.001)) continue;
            System.out.println(diff + "\t" + loc.getLongitude() + "\t" + loc.getLatitude());
        }
        System.out.println("sum over ERF = " + sum1);
        System.out.println("sum over cubes = " + sum2);
    }

    public SummedMagFreqDist getLongTermTotalERF_MFD() {
        if (this.longTermTotalERF_MFD == null) {
            this.longTermTotalERF_MFD = ERF_Calculator.getTotalMFD_ForERF(this.erf, 2.55, 8.45, 60, true);
        }
        return this.longTermTotalERF_MFD;
    }

    public static void main(String[] args) {
        ETAS_ParameterList etasParams = new ETAS_ParameterList();
        etasParams.setU3ETAS_ProbModel(U3ETAS_ProbabilityModelOptions.POISSON);
        CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        long startTimeMillis = ETAS_Simulator.getTimeInMillisFromYear(2014.0);
        UCERF3_GriddedSeisOnlyERF_ETAS erf = ETAS_Simulator_NoFaults.getU3_ETAS_ERF__GriddedSeisOnly(startTimeMillis, 1.0);
        erf.setParameter("Probability Model", (Object)ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        double gridSeisDiscr = 0.1;
        if (D) {
            System.out.println("Making ETAS_PrimaryEventSampler");
        }
        double[] sourceRates = new double[erf.getNumSources()];
        double duration = erf.getTimeSpan().getDuration();
        for (int s = 0; s < erf.getNumSources(); ++s) {
            sourceRates[s] = erf.getSource(s).computeTotalEquivMeanAnnualRate(duration);
        }
        ETAS_CubeDiscretizationParams cubeParams = new ETAS_CubeDiscretizationParams(griddedRegion);
        ETAS_PrimaryEventSampler_noFaults etas_PrimEventSampler = new ETAS_PrimaryEventSampler_noFaults(cubeParams, erf, sourceRates, null, etasParams, new ETAS_Utils());
    }

    public ArrayList<ArrayList<Integer>> intArraysListFromFile(File file) throws IOException {
        Preconditions.checkNotNull((Object)file, (Object)"File cannot be null!");
        Preconditions.checkArgument((boolean)file.exists(), (Object)"File doesn't exist!");
        long len = file.length();
        Preconditions.checkState((len > 0L ? 1 : 0) != 0, (Object)"file is empty!");
        Preconditions.checkState((len % 4L == 0L ? 1 : 0) != 0, (Object)"file size isn't evenly divisible by 4, thus not a sequence of double & integer values.");
        return this.intArraysListFromInputStream(new FileInputStream(file));
    }

    public ArrayList<ArrayList<Integer>> intArraysListFromInputStream(InputStream is) throws IOException {
        int i;
        DataInputStream in;
        int size;
        Preconditions.checkNotNull((Object)is, (Object)"InputStream cannot be null!");
        if (!(is instanceof BufferedInputStream)) {
            is = new BufferedInputStream(is);
        }
        Preconditions.checkState(((size = (in = new DataInputStream(is)).readInt()) > 0 ? 1 : 0) != 0, (Object)"Size must be > 0!");
        ArrayList<ArrayList<Integer>> list = new ArrayList<ArrayList<Integer>>();
        ArrayList<Integer> idList = new ArrayList<Integer>();
        for (i = 0; i < this.totNumSrc; ++i) {
            idList.add(i);
        }
        for (i = 0; i < size; ++i) {
            int listSize = in.readInt();
            ArrayList<Integer> intList = new ArrayList<Integer>();
            for (int j = 0; j < listSize; ++j) {
                intList.add((Integer)idList.get(in.readInt()));
            }
            list.add(intList);
        }
        in.close();
        return list;
    }

    public List<EvenlyDiscretizedFunc> generateRuptureDiagnostics(ETAS_EqkRupture rupture, double expNum, String rupInfo, File resultsDir, Writer info_fileWriter) throws IOException {
        File subDirName;
        if (D) {
            System.out.println("Starting generateRuptureDiagnostics");
        }
        if (!(subDirName = new File(resultsDir, "Diagnostics_" + rupInfo)).exists()) {
            subDirName.mkdir();
        }
        IntegerPDF_FunctionSampler aveCubeSamplerForRup = this.getAveSamplerForRupture(rupture);
        double[] relSrcProbs = this.getRelativeTriggerProbOfEachSource(aveCubeSamplerForRup, 0.99, rupture);
        long st = System.currentTimeMillis();
        SummedMagFreqDist expMFD = this.getExpectedPrimaryMFD_PDF(relSrcProbs);
        expMFD.scale(expNum);
        expMFD.setName("Expected MFD for primary aftershocks of " + rupInfo);
        EvenlyDiscretizedFunc expCumMFD = expMFD.getCumRateDistWithOffset();
        expCumMFD.setInfo("Data:\n" + expCumMFD.getMetadataString());
        double minMag = expMFD.getMinMagWithNonZeroRate();
        double maxMagWithNonZeroRate = expMFD.getMaxMagWithNonZeroRate();
        int numMag = (int)Math.round((maxMagWithNonZeroRate - minMag) / expMFD.getDelta()) + 1;
        GutenbergRichterMagFreqDist gr = new GutenbergRichterMagFreqDist(1.0, 1.0, minMag, maxMagWithNonZeroRate, numMag);
        gr.scaleToIncrRate(3.05, expMFD.getY(3.05));
        gr.setName("Perfect GR");
        gr.setInfo("Data:\n" + gr.getMetadataString());
        EvenlyDiscretizedFunc grCum = gr.getCumRateDistWithOffset();
        grCum.setInfo("Data:\n" + grCum.getMetadataString());
        ArrayList<IncrementalMagFreqDist> incrMFD_List = new ArrayList<IncrementalMagFreqDist>();
        incrMFD_List.add(gr);
        incrMFD_List.add(expMFD);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 2.0f, Color.GRAY));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        GraphWindow magProbDistsGraph = new GraphWindow(incrMFD_List, "Expected Primary Aftershock MFD", plotChars);
        magProbDistsGraph.setX_AxisLabel("Mag");
        magProbDistsGraph.setY_AxisLabel("Expected Num");
        magProbDistsGraph.setYLog(true);
        magProbDistsGraph.setPlotLabelFontSize(22);
        magProbDistsGraph.setAxisLabelFontSize(20);
        magProbDistsGraph.setTickLabelFontSize(18);
        ArrayList<EvenlyDiscretizedFunc> cumMFD_List = new ArrayList<EvenlyDiscretizedFunc>();
        cumMFD_List.add(grCum);
        cumMFD_List.add(expCumMFD);
        GraphWindow cumDistsGraph = new GraphWindow(cumMFD_List, "Expected Cumulative Primary Aftershock MFD", plotChars);
        cumDistsGraph.setX_AxisLabel("Mag");
        cumDistsGraph.setY_AxisLabel("Expected Number");
        cumDistsGraph.setY_AxisRange(1.0E-7, 100000.0);
        cumDistsGraph.setX_AxisRange(2.0, 9.0);
        cumDistsGraph.setYLog(true);
        cumDistsGraph.setPlotLabelFontSize(22);
        cumDistsGraph.setAxisLabelFontSize(20);
        cumDistsGraph.setTickLabelFontSize(18);
        ArrayList<EvenlyDiscretizedFunc> expectedPrimaryMFDsForScenarioList = new ArrayList<EvenlyDiscretizedFunc>();
        expectedPrimaryMFDsForScenarioList.add(expMFD);
        expectedPrimaryMFDsForScenarioList.add(expCumMFD);
        String fileNamePrefix = new File(subDirName, rupInfo + "_ExpPrimMFD").getAbsolutePath();
        try {
            magProbDistsGraph.saveAsPDF(fileNamePrefix + "_Incr.pdf");
            magProbDistsGraph.saveAsTXT(fileNamePrefix + "_Incr.txt");
            if (!Double.isNaN(expNum)) {
                cumDistsGraph.saveAsPDF(fileNamePrefix + "_Cum.pdf");
                cumDistsGraph.saveAsTXT(fileNamePrefix + "_Cum.txt");
            }
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        if (D) {
            System.out.println("expectedPrimaryMFDsForScenarioList took (msec) " + (System.currentTimeMillis() - st));
        }
        st = System.currentTimeMillis();
        this.plotSamplerMap(aveCubeSamplerForRup, "Primary Sampler for " + rupInfo, "PrimarySamplerMap_" + rupInfo, subDirName);
        if (D) {
            System.out.println("plotSamplerMap took (msec) " + (System.currentTimeMillis() - st));
        }
        return expectedPrimaryMFDsForScenarioList;
    }

    public String plotSamplerMap(IntegerPDF_FunctionSampler cubeSampler, String label, String dirName, File path) {
        int i;
        int i2;
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "From Data");
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(this.gridRegForCubes, true);
        for (i2 = 0; i2 < xyzDataSet.size(); ++i2) {
            xyzDataSet.set(i2, 0.0);
        }
        for (i2 = 0; i2 < this.numCubes; ++i2) {
            Location loc = this.getCubeLocationForIndex(i2);
            int mapLocIndex = this.gridRegForCubes.indexForLocation(loc);
            if (mapLocIndex < 0) continue;
            double oldRate = xyzDataSet.get(mapLocIndex);
            xyzDataSet.set(mapLocIndex, cubeSampler.getY(i2) + oldRate);
        }
        double sum = 0.0;
        for (i = 0; i < xyzDataSet.size(); ++i) {
            sum += xyzDataSet.get(i);
        }
        for (i = 0; i < xyzDataSet.size(); ++i) {
            xyzDataSet.set(i, xyzDataSet.get(i) / sum);
        }
        if (xyzDataSet.getMinZ() == 0.0) {
            int i3;
            double minNonZero = Double.MAX_VALUE;
            for (i3 = 0; i3 < xyzDataSet.size(); ++i3) {
                if (!(xyzDataSet.get(i3) > 0.0) || !(xyzDataSet.get(i3) < minNonZero)) continue;
                minNonZero = xyzDataSet.get(i3);
            }
            for (i3 = 0; i3 < xyzDataSet.size(); ++i3) {
                if (xyzDataSet.get(i3) != 0.0) continue;
                xyzDataSet.set(i3, minNonZero);
            }
        }
        Object metadata = "Map from calling plotSamplerMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(xyzDataSet, label, (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = null;
            downloadDir = path != null ? new File(path, dirName) : new File(dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For Block Prob Map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public String plotMaxMagAtDepthMap(double depth, String dirName) {
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        mapGen.setParameter("Plot Log", false);
        mapGen.setParameter("Color Scale Limits", "Manually");
        mapGen.setParameter("Color-Scale Min", 6.0);
        mapGen.setParameter("Color-Scale Max", 8.5);
        GriddedGeoDataSet maxMagData = new GriddedGeoDataSet(this.gridRegForCubes, true);
        int depthIndex = this.getCubeDepthIndex(depth);
        int numCubesAtDepth = maxMagData.size();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        for (int i = 0; i < numCubesAtDepth; ++i) {
            progressBar.updateProgress(i, numCubesAtDepth);
            int samplerIndex = this.getCubeIndexForRegAndDepIndices(i, depthIndex);
            SummedMagFreqDist mfd = this.getCubeMFD(samplerIndex);
            if (mfd == null) continue;
            maxMagData.set(i, mfd.getMaxMagWithNonZeroRate());
        }
        progressBar.showProgress(false);
        Object metadata = "Map from calling plotMaxMagAtDepthMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(maxMagData, "Max Mag at " + depth + " km depth", (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For Max Mag at depth Map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public String plotRateAtDepthMap(double depth, double mag, String dirName) {
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        ((CPT)cptParam.getValue()).setBelowMinColor(Color.WHITE);
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(this.gridRegForCubes, true);
        int depthIndex = this.getCubeDepthIndex(depth);
        int numCubesAtDepth = xyzDataSet.size();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        if (this.mfdForSrcArray == null) {
            this.computeMFD_ForSrcArrays(2.05, 8.95, 70);
        }
        int magIndex = this.mfdForSrcArray[0].getClosestXIndex(mag);
        for (int i = 0; i < numCubesAtDepth; ++i) {
            progressBar.updateProgress(i, numCubesAtDepth);
            int samplerIndex = this.getCubeIndexForRegAndDepIndices(i, depthIndex);
            SummedMagFreqDist mfd = this.getCubeMFD(samplerIndex);
            double rate = 0.0;
            if (mfd != null) {
                rate = this.getCubeMFD(samplerIndex).getCumRate(magIndex);
            }
            if (rate == 0.0) {
                rate = 1.0E-16;
            }
            xyzDataSet.set(i, rate);
        }
        progressBar.showProgress(false);
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "Manually");
        if (mag < 5.0) {
            mapGen.setParameter("Color-Scale Min", -5.0);
            mapGen.setParameter("Color-Scale Max", -1.0);
        } else {
            mapGen.setParameter("Color-Scale Min", -9.0);
            mapGen.setParameter("Color-Scale Max", -4.0);
        }
        Object metadata = "Map from calling plotRateAtDepthMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(xyzDataSet, "M\u2265" + mag + " Rates at " + depth + " km depth", (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For rates at depth above mag map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public String plotRatesOnlySamplerAtDepthMap(double depth, String dirName) {
        GMT_MapGenerator mapGen = GMT_CA_Maps.getDefaultGMT_MapGenerator();
        CPTParameter cptParam = (CPTParameter)mapGen.getAdjustableParamsList().getParameter("Color Scheme");
        cptParam.setValue(GMT_CPT_Files.MAX_SPECTRUM.getFileName());
        ((CPT)cptParam.getValue()).setBelowMinColor(Color.WHITE);
        mapGen.setParameter("Min Latitude", this.gridRegForCubes.getMinGridLat());
        mapGen.setParameter("Max Latitude", this.gridRegForCubes.getMaxGridLat());
        mapGen.setParameter("Min Longitude", this.gridRegForCubes.getMinGridLon());
        mapGen.setParameter("Max Longitude", this.gridRegForCubes.getMaxGridLon());
        mapGen.setParameter("Grid Spacing", this.gridRegForCubes.getLatSpacing());
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(this.gridRegForCubes, true);
        int depthIndex = this.getCubeDepthIndex(depth);
        int numCubesAtDepth = xyzDataSet.size();
        CalcProgressBar progressBar = new CalcProgressBar("Looping over all points", "junk");
        progressBar.showProgress(true);
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        for (int i = 0; i < numCubesAtDepth; ++i) {
            progressBar.updateProgress(i, numCubesAtDepth);
            int samplerIndex = this.getCubeIndexForRegAndDepIndices(i, depthIndex);
            double rate = this.cubeSamplerGriddedRatesOnly.getY(samplerIndex);
            if (rate <= 1.0E-16) {
                rate = 1.0E-16;
            }
            xyzDataSet.set(i, rate);
        }
        progressBar.showProgress(false);
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "Manually");
        mapGen.setParameter("Color-Scale Min", -7.0);
        mapGen.setParameter("Color-Scale Max", -1.0);
        Object metadata = "Map from calling plotSamplerAtDepthMap(*) method";
        try {
            String url = mapGen.makeMapUsingServlet(xyzDataSet, "Rates at depth=" + depth, (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For rates at depth above mag map: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }

    public String plotRandomSampleRatesMap(String dirName, int numYrs) {
        GMT_MapGenerator mapGen = new GMT_MapGenerator();
        mapGen.setParameter("Apply GMT Smoothing?", false);
        mapGen.setParameter("Topo Resolution", "No Topo");
        mapGen.setParameter("Min Latitude", 31.5);
        mapGen.setParameter("Max Latitude", 43.0);
        mapGen.setParameter("Min Longitude", -125.4);
        mapGen.setParameter("Max Longitude", -113.0);
        mapGen.setParameter("Plot Log", true);
        mapGen.setParameter("Color Scale Limits", "Manually");
        mapGen.setParameter("Color-Scale Min", -2.0);
        mapGen.setParameter("Color-Scale Max", 1.0);
        CaliforniaRegions.RELM_TESTING_GRIDDED mapGriddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        GriddedGeoDataSet xyzDataSet = new GriddedGeoDataSet(mapGriddedRegion, true);
        for (int i = 0; i < xyzDataSet.size(); ++i) {
            xyzDataSet.set(i, 0.0);
        }
        this.getCubeSamplerWithERF_GriddedRatesOnly();
        this.totRate = this.cubeSamplerGriddedRatesOnly.calcSumOfY_Vals();
        long numSamples = (long)numYrs * (long)this.totRate;
        System.out.println("num random samples for map test = " + numSamples + "\ntotRate=" + this.totRate);
        CalcProgressBar progressBar = new CalcProgressBar("Looping random samples", "junk");
        progressBar.showProgress(true);
        for (long i = 0L; i < numSamples; ++i) {
            progressBar.updateProgress(i, numSamples);
            int indexFromSampler = this.cubeSamplerGriddedRatesOnly.getRandomInt(this.etas_utils.getRandomDouble());
            int[] regAndDepIndex = this.getCubeRegAndDepIndicesForIndex(indexFromSampler);
            int indexForMap = mapGriddedRegion.indexForLocation(this.gridRegForCubes.locationForIndex(regAndDepIndex[0]));
            if (indexForMap <= 0) continue;
            double oldNum = xyzDataSet.get(indexForMap) * (double)numYrs;
            xyzDataSet.set(indexForMap, (1.0 + oldNum) / (double)numYrs);
        }
        progressBar.showProgress(false);
        if (D) {
            System.out.println("RandomSampleRatesMap: min=" + xyzDataSet.getMinZ() + "; max=" + xyzDataSet.getMaxZ());
        }
        Object metadata = "Map from calling RandomSampleRatesMap() method";
        try {
            String url = mapGen.makeMapUsingServlet(xyzDataSet, "RandomSampleRatesMap", (String)metadata, dirName);
            metadata = (String)metadata + GMT_MapGuiBean.getClickHereHTML(mapGen.getGMTFilesWebAddress());
            ImageViewerWindow imgView = new ImageViewerWindow(url, (String)metadata, true);
            File downloadDir = new File(GMT_CA_Maps.GMT_DIR, dirName);
            if (!downloadDir.exists()) {
                downloadDir.mkdir();
            }
            File zipFile = new File(downloadDir, "allFiles.zip");
            String zipURL = url.substring(0, url.lastIndexOf(47) + 1) + "allFiles.zip";
            FileUtils.downloadURL(zipURL, zipFile);
            FileUtils.unzipFile(zipFile, downloadDir);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return "For RandomSampleRatesMap: " + mapGen.getGMTFilesWebAddress() + " (deleted at midnight)";
    }
}

