/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.NoFaultsModel;

import com.google.common.base.Preconditions;
import com.google.common.collect.Range;
import com.google.common.primitives.Doubles;
import java.awt.HeadlessException;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.PriorityQueue;
import javax.swing.JOptionPane;
import org.dom4j.DocumentException;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.param.Parameter;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupOrigTimeComparator;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_CubeDiscretizationParams;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_ProbabilityModelOptions;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_SimulationMetadata;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.ETAS_PrimaryEventSampler_noFaults;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.UCERF3_GriddedSeisOnlyERF_ETAS;
import scratch.UCERF3.erf.ETAS.SeisDepthDistribution;
import scratch.UCERF3.utils.RELM_RegionUtils;

public class ETAS_Simulator_NoFaults {
    public static boolean D = true;
    private static boolean live_map = false;
    static boolean pause_for_events = false;
    static boolean exit_after_scenario_diagnostics = false;

    public static ETAS_SimulationMetadata runETAS_Simulation(File resultsDir, AbstractNthRupERF erf, GriddedRegion griddedRegion, ETAS_EqkRupture scenarioRup, List<? extends ObsEqkRupture> histQkList, boolean includeSpontEvents, boolean includeIndirectTriggering, double gridSeisDiscr, String simulationName, Long randomSeed, ETAS_ParameterList etasParams, ETAS_CubeDiscretizationParams cubeParams) throws IOException {
        ArrayList<ETAS_EqkRupture> scenarioRups = null;
        if (scenarioRup != null) {
            scenarioRups = new ArrayList<ETAS_EqkRupture>();
            scenarioRups.add(scenarioRup);
        }
        return ETAS_Simulator_NoFaults.runETAS_Simulation(resultsDir, erf, griddedRegion, scenarioRups, histQkList, includeSpontEvents, includeIndirectTriggering, gridSeisDiscr, simulationName, randomSeed, etasParams, cubeParams);
    }

    /*
     * WARNING - void declaration
     */
    public static ETAS_SimulationMetadata runETAS_Simulation(File resultsDir, AbstractNthRupERF erf, GriddedRegion griddedRegion, List<ETAS_EqkRupture> scenarioRups, List<? extends ObsEqkRupture> histQkList, boolean includeSpontEvents, boolean includeIndirectTriggering, double gridSeisDiscr, String simulationName, Long randomSeed, ETAS_ParameterList etasParams, ETAS_CubeDiscretizationParams cubeParams) throws IOException {
        CalcProgressBar progressBar;
        long simulationStartTime = System.currentTimeMillis();
        boolean generateDiagnosticsForScenario = false;
        if (randomSeed == null) {
            randomSeed = System.currentTimeMillis();
        }
        ETAS_Utils etas_utils = new ETAS_Utils(randomSeed);
        SeisDepthDistribution seisDepthDistribution = new SeisDepthDistribution();
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        int bufferSize = 1000000;
        BufferedWriter info_fr = new BufferedWriter(new FileWriter(new File(resultsDir, "infoString.txt")), bufferSize);
        BufferedWriter simulatedEventsFileWriter = new BufferedWriter(new FileWriter(new File(resultsDir, "simulatedEvents.txt")), bufferSize);
        ETAS_CatalogIO.writeEventHeaderToFile(simulatedEventsFileWriter);
        info_fr.write(simulationName + "\n");
        info_fr.write("\nrandomSeed=" + etas_utils.getRandomSeed() + "\n");
        if (D) {
            System.out.println("\nrandomSeed=" + etas_utils.getRandomSeed());
        }
        if (histQkList == null) {
            info_fr.write("\nhistQkList.size()=null\n");
        } else {
            info_fr.write("\nhistQkList.size()=" + histQkList.size() + "\n");
        }
        info_fr.write("includeSpontEvents=" + includeSpontEvents + "\n");
        info_fr.write("includeIndirectTriggering=" + includeIndirectTriggering + "\n");
        info_fr.write("\nERF Adjustable Paramteres:\n\n");
        for (Parameter<?> param : erf.getAdjustableParameterList()) {
            info_fr.write("\t" + param.getName() + " = " + String.valueOf(param.getValue()) + "\n");
        }
        TimeSpan tsp = erf.getTimeSpan();
        String startTimeString = tsp.getStartTimeMonth() + "/" + tsp.getStartTimeDay() + "/" + tsp.getStartTimeYear() + "; hr=" + tsp.getStartTimeHour() + "; min=" + tsp.getStartTimeMinute() + "; sec=" + tsp.getStartTimeSecond();
        info_fr.write("\nERF StartTime: " + startTimeString + "\n");
        info_fr.write("\nERF TimeSpan Duration: " + erf.getTimeSpan().getDuration() + " years\n");
        info_fr.write("\nETAS Paramteres:\n\n");
        if (D) {
            System.out.println("\nETAS Paramteres:\n\n");
        }
        for (Parameter<?> param : etasParams) {
            info_fr.write("\t" + param.getName() + " = " + String.valueOf(param.getValue()) + "\n");
            if (!D) continue;
            System.out.println("\t" + param.getName() + " = " + String.valueOf(param.getValue()));
        }
        if (D) {
            ((Writer)info_fr).flush();
        }
        ArrayList<ETAS_EqkRupture> obsEqkRuptureList = new ArrayList<ETAS_EqkRupture>();
        Range rangeHistCatalogParentIDs = null;
        if (histQkList != null) {
            int id = scenarioRups != null && !scenarioRups.isEmpty() ? scenarioRups.size() : 1;
            int startID = id;
            for (ObsEqkRupture obsEqkRupture : histQkList) {
                Location hyp = obsEqkRupture.getHypocenterLocation();
                if (!griddedRegion.contains(hyp) || !(hyp.getDepth() < 24.0)) continue;
                ETAS_EqkRupture etasRup = obsEqkRupture instanceof ETAS_EqkRupture ? (ETAS_EqkRupture)obsEqkRupture : new ETAS_EqkRupture(obsEqkRupture);
                etasRup.setID(id);
                obsEqkRuptureList.add(etasRup);
                ++id;
            }
            if (id > startID) {
                rangeHistCatalogParentIDs = Range.closed((Comparable)Integer.valueOf(startID), (Comparable)Integer.valueOf(id - 1));
            }
            System.out.println("histQkList.size()=" + histQkList.size());
            System.out.println("obsEqkRuptureList.size()=" + obsEqkRuptureList.size());
        }
        int[] scenarioRupIDs = null;
        HashMap<Integer, Integer> numPrimaryAshockForScenarios = null;
        Range rangeTriggerRupIDs = null;
        if (scenarioRups != null && !scenarioRups.isEmpty()) {
            void var28_30;
            scenarioRupIDs = new int[scenarioRups.size()];
            numPrimaryAshockForScenarios = new HashMap<Integer, Integer>();
            boolean bl = false;
            while (var28_30 < scenarioRups.size()) {
                ETAS_EqkRupture scenarioRup = scenarioRups.get((int)var28_30);
                scenarioRupIDs[var28_30] = var28_30;
                scenarioRup.setID((int)var28_30);
                obsEqkRuptureList.add(scenarioRup);
                if (D) {
                    System.out.println("Num locs on scenario rup surface: " + scenarioRup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface().size());
                }
                ++var28_30;
            }
            rangeTriggerRupIDs = Range.closed((Comparable)Integer.valueOf(0), (Comparable)Integer.valueOf(scenarioRups.size() - 1));
        }
        ObsEqkRupOrigTimeComparator obsEqkRupOrigTimeComparator = new ObsEqkRupOrigTimeComparator();
        PriorityQueue<ObsEqkRupture> simulatedRupsQueue = new PriorityQueue<ObsEqkRupture>(1000, obsEqkRupOrigTimeComparator);
        ArrayList nthFaultSysRupAftershocks = new ArrayList();
        long simStartTimeMillis = erf.getTimeSpan().getStartTimeCalendar().getTimeInMillis();
        long simEndTimeMillis = erf.getTimeSpan().getEndTimeCalendar().getTimeInMillis();
        double simDurationYrs = erf.getTimeSpan().getDuration();
        if (D) {
            System.out.println("Updating forecast in testETAS_Simulation");
        }
        erf.getTimeSpan().setDuration(1.0);
        erf.updateForecast();
        if (D) {
            System.out.println("Done updating forecast in testETAS_Simulation");
        }
        if (D) {
            System.out.println("Computing origTotRate");
        }
        long st = System.currentTimeMillis();
        double origTotRate = 0.0;
        for (int sourceID = 0; sourceID < erf.getNumSources(); ++sourceID) {
            ProbEqkSource src = erf.getSource(sourceID);
            for (int rupID = 0; rupID < src.getNumRuptures(); ++rupID) {
                ProbEqkRupture rup = src.getRupture(rupID);
                double rupRate = rup.getMeanAnnualRate(erf.getTimeSpan().getDuration());
                Preconditions.checkState((boolean)Doubles.isFinite((double)rupRate), (String)"Non fininte rup rate: %s, prob=%s, src=%s, rup=%s, mag=%s, ptSource=%s", (Object[])new Object[]{rupRate, rup.getProbability(), sourceID, rupID, rup.getMag(), rup.getRuptureSurface().isPointSurface()});
                origTotRate += rupRate;
            }
        }
        if (D) {
            System.out.println("\torigTotRate=" + (float)origTotRate + "; that took (sec): " + (float)(System.currentTimeMillis() - st) / 1000.0f);
        }
        info_fr.write("\nExpected mean annual rate over timeSpan (per year) = " + (float)origTotRate + "\n");
        if (D) {
            System.out.println("Computing original spontaneousRupSampler & sourceRates[s]");
        }
        st = System.currentTimeMillis();
        double[] sourceRates = new double[erf.getNumSources()];
        double duration = erf.getTimeSpan().getDuration();
        IntegerPDF_FunctionSampler spontaneousRupSampler = new IntegerPDF_FunctionSampler(erf.getTotNumRups());
        int nthRup = 0;
        if (D) {
            System.out.println("total number of ruptures: " + erf.getTotNumRups());
        }
        for (int s = 0; s < erf.getNumSources(); ++s) {
            ProbEqkSource src = erf.getSource(s);
            sourceRates[s] = src.computeTotalEquivMeanAnnualRate(duration);
            if (D && sourceRates[s] == 0.0) {
                System.out.println("ZERO RATE SOURCE: " + src.getRupture(0).getProbability() + "\t" + src.getName());
            }
            for (Object rup : src) {
                if (nthRup >= spontaneousRupSampler.size()) {
                    throw new RuntimeException("Weird...tot num=" + erf.getTotNumRups() + ", nth=" + nthRup);
                }
                spontaneousRupSampler.set(nthRup, ((ProbEqkRupture)rup).getMeanAnnualRate(duration));
                ++nthRup;
            }
        }
        if (D) {
            System.out.println("\tspontaneousRupSampler.calcSumOfY_Vals()=" + (float)spontaneousRupSampler.calcSumOfY_Vals() + "; that took (sec): " + (float)(System.currentTimeMillis() - st) / 1000.0f);
        }
        if (D) {
            System.out.println("Making ETAS_PrimaryEventSampler");
        }
        st = System.currentTimeMillis();
        if (cubeParams == null) {
            cubeParams = new ETAS_CubeDiscretizationParams(griddedRegion);
        }
        ETAS_PrimaryEventSampler_noFaults etas_PrimEventSampler = new ETAS_PrimaryEventSampler_noFaults(cubeParams, erf, sourceRates, null, etasParams, etas_utils);
        if (D) {
            System.out.println("ETAS_PrimaryEventSampler creation took " + (float)(System.currentTimeMillis() - st) / 60000.0f + " min");
        }
        info_fr.write("\nMaking ETAS_PrimaryEventSampler took " + (System.currentTimeMillis() - st) / 60000L + " min");
        if (D) {
            System.out.println("Making primary aftershocks from input obsEqkRuptureList, size = " + obsEqkRuptureList.size());
        }
        PriorityQueue<ObsEqkRupture> eventsToProcess = new PriorityQueue<ObsEqkRupture>(1000, obsEqkRupOrigTimeComparator);
        int eventID = obsEqkRuptureList.size();
        for (ETAS_EqkRupture parRup : obsEqkRuptureList) {
            int parID = parRup.getID();
            long rupOT = parRup.getOriginTime();
            double startDay = (double)(simStartTimeMillis - rupOT) / 8.64E7;
            double endDay = (double)(simEndTimeMillis - rupOT) / 8.64E7;
            etas_utils.setETAS_ParamsForRupture(parRup, etasParams);
            double[] randomAftShockTimes = etas_utils.getRandomEventTimes(parRup.getETAS_k(), parRup.getETAS_p(), parRup.getMag(), 2.5, parRup.getETAS_c(), startDay, endDay);
            if (scenarioRupIDs != null && rangeTriggerRupIDs.contains((Comparable)Integer.valueOf(parRup.getID()))) {
                numPrimaryAshockForScenarios.put(parRup.getID(), randomAftShockTimes.length);
            }
            Object var59_77 = null;
            if (randomAftShockTimes.length <= 0) continue;
            for (int i = 0; i < randomAftShockTimes.length; ++i) {
                long ot = rupOT + (long)(randomAftShockTimes[i] * 8.64E7);
                ETAS_EqkRupture newRup = new ETAS_EqkRupture(parRup, eventID, ot);
                newRup.setParentID(parID);
                newRup.setGeneration(1);
                if (parRup.getFSSIndex() == -1) {
                    newRup.setParentTriggerLoc(etas_utils.getRandomLocationOnRupSurface(parRup));
                } else {
                    Location tempLoc = etas_utils.getRandomLocationOnRupSurface(parRup);
                    if (tempLoc.getDepth() > etas_PrimEventSampler.maxDepth) {
                        Location newLoc;
                        tempLoc = newLoc = new Location(tempLoc.getLatitude(), tempLoc.getLongitude(), etas_PrimEventSampler.maxDepth);
                    }
                    newRup.setParentTriggerLoc(etas_PrimEventSampler.getRandomFuzzyLocation(tempLoc));
                }
                etas_PrimEventSampler.addRuptureToProcess(newRup);
                eventsToProcess.add(newRup);
                ++eventID;
            }
        }
        if (D) {
            System.out.println("The " + obsEqkRuptureList.size() + " input events produced " + eventsToProcess.size() + " primary aftershocks");
        }
        info_fr.write("\nThe " + obsEqkRuptureList.size() + " input observed events produced " + eventsToProcess.size() + " primary aftershocks\n");
        if (includeSpontEvents) {
            if (D) {
                System.out.println("Making spontaneous events and times of primary aftershocks...");
            }
            long histCatStartTime = simStartTimeMillis;
            IncrementalMagFreqDist mfd = etas_PrimEventSampler.getLongTermTotalERF_MFD().deepClone();
            mfd.scale(etasParams.getTotalRateScaleFactor());
            System.out.println("Starting getRandomSpontanousEventTimes");
            long[] spontEventTimes = histQkList == null || histQkList.isEmpty() ? etas_utils.getRandomSpontanousEventTimes(mfd, histCatStartTime, simStartTimeMillis, simEndTimeMillis, 1000, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c()) : etas_utils.getRandomSpontanousEventTimes(mfd, etasParams.getStatewideCompletenessModel().getEvenlyDiscretizedMagYearFunc(), simStartTimeMillis, simEndTimeMillis, 1000, etasParams.get_k(), etasParams.get_p(), 2.5, etasParams.get_c());
            System.out.println("Done with getRandomSpontanousEventTimes");
            for (int r = 0; r < spontEventTimes.length; ++r) {
                ETAS_EqkRupture rup = new ETAS_EqkRupture();
                rup.setOriginTime(spontEventTimes[r]);
                rup.setID(eventID);
                rup.setGeneration(0);
                eventsToProcess.add(rup);
                ++eventID;
            }
            double fractionNonTriggered = (double)spontEventTimes.length / (origTotRate * simDurationYrs);
            String spEvStringInfo = "Spontaneous Events:\n\n\tFraction non-triggered = " + fractionNonTriggered + "\t(sample num over total expected num)\n\tnumSpontEventsSampled=" + spontEventTimes.length + "\n";
            if (D) {
                System.out.println(spEvStringInfo);
            }
            info_fr.write("\n" + spEvStringInfo);
        }
        List<EvenlyDiscretizedFunc> expectedPrimaryMFDsForScenarioList = null;
        if (scenarioRups != null && !scenarioRups.isEmpty()) {
            for (int i = 0; i < scenarioRups.size(); ++i) {
                boolean scenWrite;
                ETAS_EqkRupture scenarioRup = scenarioRups.get(i);
                boolean bl = scenWrite = D || scenarioRups.size() < 100 || scenarioRup.getMag() >= 5.0;
                if (!scenWrite) continue;
                long rupOT = scenarioRup.getOriginTime();
                double startDay = (double)(simStartTimeMillis - rupOT) / 8.64E7;
                double endDay = (double)(simEndTimeMillis - rupOT) / 8.64E7;
                info_fr.write("\nMagnitude of Scenario: " + (float)scenarioRup.getMag() + "\n");
                if (D) {
                    System.out.println("\nMagnitude of Scenario: " + (float)scenarioRup.getMag());
                }
                double d = scenarioRup.getETAS_k();
                double p = scenarioRup.getETAS_p();
                double c = scenarioRup.getETAS_c();
                if (d != etasParams.get_k()) {
                    info_fr.write("\tCustom k-value for Scenario: " + d + "\n");
                    if (D) {
                        System.out.println("\tCustom k-value for Scenario: " + d + "\n");
                    }
                }
                if (p != etasParams.get_p()) {
                    info_fr.write("\tCustom p-value for Scenario: " + p + "\n");
                    if (D) {
                        System.out.println("\tCustom p-value for Scenario: " + p + "\n");
                    }
                }
                if (c != etasParams.get_c()) {
                    info_fr.write("\tCustom c-value for Scenario: " + c + "\n");
                    if (D) {
                        System.out.println("\tCustom c-value for Scenario: " + c + "\n");
                    }
                }
                double expNum = ETAS_Utils.getExpectedNumEvents(d, p, scenarioRup.getMag(), 2.5, c, startDay, endDay);
                info_fr.write("Expected number of primary events for Scenario: " + expNum + "\n");
                int numPrimaryAftershocks = (Integer)numPrimaryAshockForScenarios.get(scenarioRup.getID());
                info_fr.write("Observed number of primary events for Scenario: " + numPrimaryAftershocks + "\n");
                if (D) {
                    System.out.println("Expected number of primary events for Scenario: " + expNum);
                    System.out.println("Observed number of primary events for Scenario: " + numPrimaryAftershocks + "\n");
                }
                if (!D || !generateDiagnosticsForScenario) continue;
                System.out.println("Computing Scenario Diagnostics");
                long timeMillis = System.currentTimeMillis();
                expectedPrimaryMFDsForScenarioList = etas_PrimEventSampler.generateRuptureDiagnostics(scenarioRup, expNum, "Scenario", resultsDir, info_fr);
                float timeMin = (float)(System.currentTimeMillis() - timeMillis) / 60000.0f;
                System.out.println("Computing Scenario Diagnostics took (min): " + timeMin);
                if (!exit_after_scenario_diagnostics) continue;
                ((Writer)info_fr).close();
                System.exit(0);
            }
        }
        if (D) {
            System.out.println("Testing the etas_PrimEventSampler");
            etas_PrimEventSampler.testRates();
        }
        try {
            progressBar = new CalcProgressBar("Primary aftershocks to process", "junk");
            progressBar.showProgress(true);
        }
        catch (Throwable t) {
            progressBar = null;
        }
        if (D) {
            System.out.println("Looping over eventsToProcess (initial num = " + eventsToProcess.size() + ")...\n");
        }
        if (D) {
            ((Writer)info_fr).flush();
        }
        st = System.currentTimeMillis();
        int numSimulatedEvents = 0;
        ETAS_SimAnalysisTools.EpicenterMapThread mapThread = D && live_map ? ETAS_SimAnalysisTools.plotUpdatingEpicenterMap(simulationName, null, simulatedRupsQueue, griddedRegion.getBorder()) : null;
        if (D && pause_for_events) {
            try {
                JOptionPane.showMessageDialog(null, "Continue", "Ready To Generate Events", -1);
            }
            catch (HeadlessException rupOT) {
                // empty catch block
            }
        }
        if (D) {
            ((Writer)info_fr).flush();
        }
        double maxPointSourceMag = etasParams.getMaxPointSourceMag();
        while (eventsToProcess.size() > 0) {
            if (progressBar != null) {
                progressBar.updateProgress(numSimulatedEvents, eventsToProcess.size() + numSimulatedEvents);
            }
            ETAS_EqkRupture rup = (ETAS_EqkRupture)eventsToProcess.poll();
            boolean succeededInSettingRupture = true;
            if (rup.getParentID() == -1) {
                Location hypoLoc = null;
                nthRup = spontaneousRupSampler.getRandomInt(etas_utils.getRandomDouble());
                ProbEqkRupture erf_rup = erf.getNthRupture(nthRup);
                LocationList locationList = erf_rup.getRuptureSurface().getEvenlyDiscritizedListOfLocsOnSurface();
                if (locationList.size() == 1) {
                    Location ptLoc = (Location)locationList.get(0);
                    hypoLoc = new Location(ptLoc.getLatitude() + (etas_utils.getRandomDouble() - 0.5) * 0.1 * 0.99, ptLoc.getLongitude() + (etas_utils.getRandomDouble() - 0.5) * 0.1 * 0.99, seisDepthDistribution.getRandomDepth(etas_utils));
                    if (erf_rup.getMag() < maxPointSourceMag) {
                        rup.setPointSurface(hypoLoc);
                    } else {
                        double aveDip = erf_rup.getRuptureSurface().getAveDip();
                        rup.setRuptureSurface(etas_utils.getRandomFiniteRupSurface(erf_rup.getMag(), hypoLoc, aveDip));
                    }
                } else {
                    int hypIndex = etas_utils.getRandomInt(locationList.size() - 1);
                    hypoLoc = (Location)locationList.get(hypIndex);
                    rup.setRuptureSurface(erf_rup.getRuptureSurface());
                }
                rup.setAveRake(erf_rup.getAveRake());
                rup.setMag(erf_rup.getMag());
                rup.setNthERF_Index(nthRup);
                rup.setHypocenterLocation(hypoLoc);
                int sourceIndex = erf.getSrcIndexForNthRup(nthRup);
                rup.setGridNodeIndex(sourceIndex);
            } else {
                succeededInSettingRupture = etas_PrimEventSampler.setRandomPrimaryEvent(rup, maxPointSourceMag);
            }
            if (!succeededInSettingRupture) continue;
            nthRup = rup.getNthERF_Index();
            int srcIndex = erf.getSrcIndexForNthRup(nthRup);
            simulatedRupsQueue.add(rup);
            ++numSimulatedEvents;
            if (includeIndirectTriggering) {
                etas_utils.setETAS_ParamsForRupture(rup, etasParams);
            }
            ETAS_CatalogIO.writeEventToFile(simulatedEventsFileWriter, rup);
            long rupOT = rup.getOriginTime();
            if (includeIndirectTriggering) {
                int parID = rup.getID();
                int gen = rup.getGeneration() + 1;
                double startDay = 0.0;
                double endDay = (double)(simEndTimeMillis - rupOT) / 8.64E7;
                double[] eventTimes = etas_utils.getRandomEventTimes(rup.getETAS_k(), rup.getETAS_p(), rup.getMag(), 2.5, rup.getETAS_c(), startDay, endDay);
                Object locList = null;
                if (eventTimes.length > 0) {
                    for (int i = 0; i < eventTimes.length; ++i) {
                        long ot = rupOT + (long)(eventTimes[i] * 8.64E7);
                        ETAS_EqkRupture newRup = new ETAS_EqkRupture(rup, eventID, ot);
                        newRup.setGeneration(gen);
                        newRup.setParentID(parID);
                        if (rup.getFSSIndex() == -1) {
                            newRup.setParentTriggerLoc(etas_utils.getRandomLocationOnRupSurface(rup));
                        } else {
                            Location tempLoc = etas_utils.getRandomLocationOnRupSurface(rup);
                            if (tempLoc.getDepth() > etas_PrimEventSampler.maxDepth) {
                                Location newLoc;
                                tempLoc = newLoc = new Location(tempLoc.getLatitude(), tempLoc.getLongitude(), etas_PrimEventSampler.maxDepth);
                            }
                            newRup.setParentTriggerLoc(etas_PrimEventSampler.getRandomFuzzyLocation(tempLoc));
                        }
                        etas_PrimEventSampler.addRuptureToProcess(newRup);
                        eventsToProcess.add(newRup);
                        ++eventID;
                    }
                }
            }
            if (!D) continue;
            ((Writer)info_fr).flush();
        }
        if (progressBar != null) {
            progressBar.showProgress(false);
        }
        if (mapThread != null) {
            mapThread.kill();
        }
        if (D) {
            System.out.println("\nLooping over events took " + (System.currentTimeMillis() - st) / 1000L + " secs\n");
        }
        info_fr.write("\nLooping over events took " + (System.currentTimeMillis() - st) / 1000L + " secs\n\n");
        ETAS_SimAnalysisTools.writeMemoryUse("Memory after loop:");
        int[] numInEachGeneration = ETAS_SimAnalysisTools.getNumAftershocksForEachGeneration(simulatedRupsQueue, 10);
        String numInfo = "Total num ruptures: " + simulatedRupsQueue.size() + "\n";
        numInfo = numInfo + "Num spontaneous: " + numInEachGeneration[0] + "\n";
        numInfo = numInfo + "Num 1st Gen: " + numInEachGeneration[1] + "\n";
        numInfo = numInfo + "Num 2nd Gen: " + numInEachGeneration[2] + "\n";
        numInfo = numInfo + "Num 3rd Gen: " + numInEachGeneration[3] + "\n";
        numInfo = numInfo + "Num 4th Gen: " + numInEachGeneration[4] + "\n";
        numInfo = numInfo + "Num 5th Gen: " + numInEachGeneration[5] + "\n";
        numInfo = numInfo + "Num 6th Gen: " + numInEachGeneration[6] + "\n";
        numInfo = numInfo + "Num 7th Gen: " + numInEachGeneration[7] + "\n";
        numInfo = numInfo + "Num 8th Gen: " + numInEachGeneration[8] + "\n";
        numInfo = numInfo + "Num 9th Gen: " + numInEachGeneration[9] + "\n";
        numInfo = numInfo + "Num 10th Gen: " + numInEachGeneration[10] + "\n";
        if (D) {
            System.out.println(numInfo);
        }
        info_fr.write(numInfo + "\n");
        if (scenarioRups != null && !scenarioRups.isEmpty() && D) {
            for (int i = 0; i < scenarioRups.size(); ++i) {
                ETAS_EqkRupture scenarioRup = scenarioRups.get(i);
                int n = scenarioRup.getID();
                ArrayList<IncrementalMagFreqDist> obsAshockMFDsForScenario = ETAS_SimAnalysisTools.getAftershockMFDsForRup(simulatedRupsQueue, n, simulationName);
                ETAS_SimAnalysisTools.plotRateVsLogTimeForPrimaryAshocksOfRup(simulationName, new File(resultsDir, "logRateDecayForScenarioPrimaryAftershocks.pdf").getAbsolutePath(), simulatedRupsQueue, scenarioRup, etasParams.get_k(), etasParams.get_p(), etasParams.get_c());
                ETAS_SimAnalysisTools.plotRateVsLogTimeForAllAshocksOfRup(simulationName, new File(resultsDir, "logRateDecayForScenarioAllAftershocks.pdf").getAbsolutePath(), simulatedRupsQueue, scenarioRup, etasParams.get_k(), etasParams.get_p(), etasParams.get_c());
                ETAS_SimAnalysisTools.plotEpicenterMap(simulationName, new File(resultsDir, "hypoMap.pdf").getAbsolutePath(), (ObsEqkRupture)obsEqkRuptureList.get(0), simulatedRupsQueue, griddedRegion.getBorder());
                ETAS_SimAnalysisTools.plotDistDecayDensityOfAshocksForRup("Scenario in " + simulationName, new File(resultsDir, "distDecayDensityForScenario.pdf").getAbsolutePath(), simulatedRupsQueue, etasParams.get_q(), etasParams.get_d(), scenarioRup);
                if (generateDiagnosticsForScenario) {
                    obsAshockMFDsForScenario.add((IncrementalMagFreqDist)expectedPrimaryMFDsForScenarioList.get(0));
                }
                ETAS_SimAnalysisTools.plotMagFreqDistsForRup("AshocksOfScenarioMFD", resultsDir, obsAshockMFDsForScenario);
                double expPrimNumAtMainMag = Double.NaN;
                double expPrimNumAtMainMagMinusOne = Double.NaN;
                if (generateDiagnosticsForScenario && expectedPrimaryMFDsForScenarioList.get(1) != null) {
                    expPrimNumAtMainMag = expectedPrimaryMFDsForScenarioList.get(1).getInterpolatedY(scenarioRup.getMag());
                    expPrimNumAtMainMagMinusOne = expectedPrimaryMFDsForScenarioList.get(1).getInterpolatedY(scenarioRup.getMag() - 1.0);
                }
                EvenlyDiscretizedFunc obsPrimCumMFD = obsAshockMFDsForScenario.get(1).getCumRateDistWithOffset();
                double obsPrimNumAtMainMag = obsPrimCumMFD.getInterpolatedY(scenarioRup.getMag());
                double obsPrimNumAtMainMagMinusOne = obsPrimCumMFD.getInterpolatedY(scenarioRup.getMag() - 1.0);
                EvenlyDiscretizedFunc obsAllCumMFD = obsAshockMFDsForScenario.get(1).getCumRateDistWithOffset();
                double obsAllNumAtMainMag = obsAllCumMFD.getInterpolatedY(scenarioRup.getMag());
                double obsAllNumAtMainMagMinusOne = obsAllCumMFD.getInterpolatedY(scenarioRup.getMag() - 1.0);
                Object testEventStats = "\nAftershock Stats for Scenario event (only):\n";
                testEventStats = (String)testEventStats + "\tNum Primary Aftershocks at main shock mag(" + (float)scenarioRup.getMag() + "):\n\t\tExpected=" + expPrimNumAtMainMag + "\n\t\tObserved=" + obsPrimNumAtMainMag + "\n";
                testEventStats = (String)testEventStats + "\tNum Primary Aftershocks at one minus main-shock mag(" + (float)(scenarioRup.getMag() - 1.0) + "):\n\t\tExpected=" + expPrimNumAtMainMagMinusOne + "\n\t\tObserved=" + obsPrimNumAtMainMagMinusOne + "\n";
                testEventStats = (String)testEventStats + "\tTotal Observed Num Aftershocks:\n\t\tAt main-shock mag = " + obsAllNumAtMainMag + "\n\t\tAt one minus main-shock mag = " + obsAllNumAtMainMagMinusOne + "\n";
                if (D) {
                    System.out.println((String)testEventStats);
                }
                info_fr.write((String)testEventStats);
            }
        } else if (D) {
            ETAS_SimAnalysisTools.plotEpicenterMap(simulationName, new File(resultsDir, "hypoMap.pdf").getAbsolutePath(), null, simulatedRupsQueue, griddedRegion.getBorder());
            ArrayList<ETAS_EqkRupture> bigGridSeisEventsList = new ArrayList<ETAS_EqkRupture>();
            for (ETAS_EqkRupture eTAS_EqkRupture : simulatedRupsQueue) {
                if (eTAS_EqkRupture.getFSSIndex() != -1 || !(eTAS_EqkRupture.getMag() > maxPointSourceMag)) continue;
                bigGridSeisEventsList.add(eTAS_EqkRupture);
            }
            ETAS_SimAnalysisTools.plotFiniteGridSeisRupMap(simulationName, new File(resultsDir, "hypoMapBigGridSeisEvents.pdf").getAbsolutePath(), bigGridSeisEventsList, griddedRegion.getBorder());
        }
        if (D) {
            ETAS_SimAnalysisTools.plotRateVsLogTimeForPrimaryAshocks(simulationName, new File(resultsDir, "logRateDecayPDF_ForAllPrimaryEvents.pdf").getAbsolutePath(), simulatedRupsQueue, etasParams.get_k(), etasParams.get_p(), etasParams.get_c());
            ETAS_SimAnalysisTools.plotDistDecayDensityFromParentTriggerLocHist(simulationName, new File(resultsDir, "distDecayForAllPrimaryEvents.pdf").getAbsolutePath(), simulatedRupsQueue, etasParams.get_q(), etasParams.get_d());
            ETAS_SimAnalysisTools.plotMagFreqDists(simulationName, resultsDir, simulatedRupsQueue);
        }
        ((Writer)info_fr).close();
        ETAS_SimulationMetadata meta = ETAS_SimulationMetadata.instance(randomSeed, -1, (Range<Integer>)rangeHistCatalogParentIDs, (Range<Integer>)rangeTriggerRupIDs, simulationStartTime, System.currentTimeMillis(), 2.5, simulatedRupsQueue);
        ETAS_CatalogIO.writeMetadataToFile(simulatedEventsFileWriter, meta);
        ((Writer)simulatedEventsFileWriter).close();
        ETAS_SimAnalysisTools.writeMemoryUse("Memory at end of simultation");
        return meta;
    }

    public static void configAndRunSimulation() {
        D = true;
        live_map = true;
        ETAS_Simulator.TestScenario scenario = null;
        Object simulationName = "Test40yrSim";
        String incrementString = "_2";
        Long seed = null;
        double startTimeYear = 2012.0;
        long startTimeMillis = ETAS_Simulator.getTimeInMillisFromYear(startTimeYear);
        double durationYears = 40.0;
        ETAS_ParameterList params = new ETAS_ParameterList();
        params.setImposeGR(false);
        params.setApplyGridSeisCorr(false);
        params.setApplySubSeisForSupraNucl(false);
        params.setTotalRateScaleFactor(1.0);
        params.setU3ETAS_ProbModel(U3ETAS_ProbabilityModelOptions.POISSON);
        params.setMaxPointSourceMag(6.0);
        boolean includeSpontEvents = true;
        boolean includeIndirectTriggering = true;
        double gridSeisDiscr = 0.1;
        boolean includeHistCat = true;
        simulationName = (String)simulationName + "NoFaults_";
        simulationName = scenario == null ? (String)simulationName + "NoScenario" : (String)simulationName + String.valueOf(scenario);
        simulationName = (String)simulationName + incrementString;
        ETAS_SimAnalysisTools.writeMemoryUse("Memory at beginning of run");
        Long st = System.currentTimeMillis();
        if (simulationName == null) {
            throw new RuntimeException("simulationName is null");
        }
        CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        FaultSystemSolutionERF_ETAS erf = null;
        if (scenario != null && scenario.getFSS_Index() >= 0 || includeHistCat) {
            erf = ETAS_Simulator.getU3_ETAS_ERF(startTimeMillis, durationYears, params.getApplyGridSeisCorr());
        }
        List<ETAS_EqkRupture> histQkList = null;
        if (includeHistCat) {
            try {
                histQkList = ETAS_Simulator.getFilteredHistCatalog(startTimeMillis, erf, params.getStatewideCompletenessModel());
            }
            catch (IOException | DocumentException e1) {
                e1.printStackTrace();
            }
        }
        ArrayList<ETAS_EqkRupture> scenarioList = null;
        if (scenario != null) {
            ETAS_EqkRupture scenarioRup = ETAS_Simulator.buildScenarioRup(scenario, erf, startTimeMillis);
            scenarioList = new ArrayList<ETAS_EqkRupture>();
            scenarioList.add(scenarioRup);
        }
        UCERF3_GriddedSeisOnlyERF_ETAS erf_noFlts = ETAS_Simulator_NoFaults.getU3_ETAS_ERF__GriddedSeisOnly(startTimeMillis, durationYears);
        System.out.println("Starting testETAS_Simulation");
        try {
            String dirNameForSavingFiles = "U3_ETAS_" + (String)simulationName + "/";
            File resultsDir = new File(dirNameForSavingFiles);
            ETAS_Simulator_NoFaults.runETAS_Simulation(resultsDir, (AbstractNthRupERF)erf_noFlts, (GriddedRegion)griddedRegion, scenarioList, histQkList, includeSpontEvents, includeIndirectTriggering, gridSeisDiscr, (String)simulationName, seed, params, null);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        float timeMin = (float)(System.currentTimeMillis() - st) / 60000.0f;
        System.out.println("Total simulation took " + timeMin + " min");
    }

    public static void runBugReproduce() throws IOException {
    }

    public static UCERF3_GriddedSeisOnlyERF_ETAS getU3_ETAS_ERF__GriddedSeisOnly(long startTimeMillis, double durationYears) {
        Long st = System.currentTimeMillis();
        UCERF3_GriddedSeisOnlyERF_ETAS erf = new UCERF3_GriddedSeisOnlyERF_ETAS();
        erf.setParameter("Treat Background Seismicity As", (Object)BackgroundRupType.POINT);
        erf.setParameter("Apply Aftershock Filter", false);
        erf.setParameter("Maximum Magnitude", 8.3);
        erf.setParameter("Total Regional Rate", TotalMag5Rate.RATE_7p9);
        erf.setParameter("Spatial Seis PDF", SpatialSeisPDF.UCERF3);
        erf.getTimeSpan().setStartTimeInMillis(startTimeMillis);
        erf.getTimeSpan().setDuration(durationYears);
        erf.updateForecast();
        float timeSec = (float)(System.currentTimeMillis() - st) / 1000.0f;
        System.out.println("ERF instantiation took " + timeSec + " sec");
        return erf;
    }

    public static void main(String[] args) {
        ETAS_Simulator_NoFaults.configAndRunSimulation();
    }
}

