/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.NoFaultsModel;

import java.util.ArrayList;
import java.util.EnumSet;
import java.util.EventObject;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.faultSysSolution.modules.GridSourceProvider;
import org.opensha.sha.earthquake.param.ApplyGardnerKnopoffAftershockFilterParam;
import org.opensha.sha.earthquake.param.BackgroundRupParam;
import org.opensha.sha.earthquake.param.GriddedSeismicitySettingsParam;
import org.opensha.sha.earthquake.param.MaximumMagnitudeParam;
import org.opensha.sha.earthquake.util.GriddedSeismicitySettings;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.griddedSeismicity.AbstractGridSourceProvider;
import scratch.UCERF3.griddedSeismicity.UCERF3_NoFaultsGridSourceGenerator;

public class UCERF3_GriddedSeisOnlyERF_ETAS
extends AbstractNthRupERF {
    private static final long serialVersionUID = 1L;
    private static final boolean D = true;
    public static final String NAME = "UCERF3_GriddedSeisOnlyERF_ETAS";
    private String name = "UCERF3_GriddedSeisOnlyERF_ETAS";
    protected ApplyGardnerKnopoffAftershockFilterParam applyAftershockFilterParam;
    protected BackgroundRupParam bgRupTypeParam;
    protected GriddedSeismicitySettingsParam bgSettingsParam;
    protected MaximumMagnitudeParam maxMagParam;
    protected EnumParameter<TotalMag5Rate> totalRateParam;
    protected EnumParameter<SpatialSeisPDF> spatialSeisPDF_Param;
    protected GriddedSeismicitySettings bgSettings = FaultSystemSolutionERF_ETAS.GRID_SEIS_SETTINGS;
    protected boolean applyAftershockFilter = false;
    protected double maxMag = 8.3;
    protected TotalMag5Rate totalMag5Rate = TotalMag5Rate.RATE_7p9;
    protected SpatialSeisPDF spatialSeisPDF = SpatialSeisPDF.UCERF3;
    protected boolean applyAftershockFilterChanged = true;
    protected boolean bgRupTypeChanged = true;
    protected boolean maxMagChanged = true;
    protected boolean totalMag5RateChanged = true;
    protected boolean spatialSeisPDF_Changed = true;
    protected static final double DURATION_DEFAULT = 30.0;
    protected static final double DURATION_MIN = 1.0E-4;
    public static final double DURATION_MAX = 100000.0;
    public static final int START_TIME_DEFAULT = 2014;
    protected static final int START_TIME_MIN = 1800;
    protected static final int START_TIME_MAX = 2100;
    boolean timeSpanChangeFlag = true;
    private GridSourceProvider gridSources;
    protected ArrayList<int[]> nthRupIndicesForSource;
    protected int totNumRups;
    protected int[] srcIndexForNthRup;
    protected int[] rupIndexForNthRup;

    public UCERF3_GriddedSeisOnlyERF_ETAS() {
        this.initParams();
        this.initTimeSpan();
    }

    protected void initTimeSpan() {
        this.timeSpan = new TimeSpan("Milliseconds", "Years");
        this.timeSpan.setDuractionConstraint(1.0E-4, 100000.0);
        this.timeSpan.setDuration(30.0);
        this.timeSpan.setStartTimeConstraint("Start Year", 1800, 2100);
        this.timeSpan.setStartTime(2014, 1, 1, 0, 0, 0, 0);
        this.timeSpan.addParameterChangeListener(this);
    }

    protected void initParams() {
        this.applyAftershockFilterParam = new ApplyGardnerKnopoffAftershockFilterParam();
        this.bgRupTypeParam = new BackgroundRupParam();
        this.bgRupTypeParam.setValue(this.bgSettings.surfaceType);
        this.bgSettingsParam = new GriddedSeismicitySettingsParam(this.bgSettings, this.bgRupTypeParam);
        this.maxMagParam = new MaximumMagnitudeParam();
        this.totalRateParam = new EnumParameter<TotalMag5Rate>("Total Regional Rate", EnumSet.of(TotalMag5Rate.RATE_6p5, TotalMag5Rate.RATE_7p9, TotalMag5Rate.RATE_9p6), TotalMag5Rate.RATE_7p9, null);
        this.totalRateParam.setUnits("per year");
        this.totalRateParam.setInfo("Total regional rate of M\u22655 events");
        this.spatialSeisPDF_Param = new EnumParameter<SpatialSeisPDF>("Spatial Seis PDF", EnumSet.of(SpatialSeisPDF.UCERF2, SpatialSeisPDF.UCERF3), SpatialSeisPDF.UCERF3, "Uniform");
        this.spatialSeisPDF_Param.setInfo("How seismicity is distribute; use null for uniform");
        this.applyAftershockFilterParam.addParameterChangeListener(this);
        this.bgRupTypeParam.addParameterChangeListener(this);
        this.bgSettingsParam.addParameterChangeListener(this);
        this.maxMagParam.addParameterChangeListener(this);
        this.totalRateParam.addParameterChangeListener(this);
        this.spatialSeisPDF_Param.addParameterChangeListener(this);
        this.applyAftershockFilterParam.setValue(this.applyAftershockFilter);
        this.bgRupTypeParam.setValue(this.bgSettings.surfaceType);
        this.maxMagParam.setValue(this.maxMag);
        this.totalRateParam.setValue(this.totalMag5Rate);
        this.spatialSeisPDF_Param.setValue(this.spatialSeisPDF);
        this.createParamList();
    }

    protected void createParamList() {
        this.adjustableParams = new ParameterList();
        this.adjustableParams.addParameter(this.applyAftershockFilterParam);
        this.adjustableParams.addParameter(this.bgRupTypeParam);
        this.adjustableParams.addParameter(this.bgSettingsParam);
        this.adjustableParams.addParameter(this.maxMagParam);
        this.adjustableParams.addParameter(this.totalRateParam);
        this.adjustableParams.addParameter(this.spatialSeisPDF_Param);
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public void updateForecast() {
        System.out.println("Updating forecast");
        if (this.spatialSeisPDF_Changed || this.totalMag5RateChanged || this.maxMagChanged) {
            double[] seisPDF = null;
            if (this.spatialSeisPDF != null) {
                seisPDF = this.spatialSeisPDF.getPDF();
            }
            System.out.println(String.valueOf(this.spatialSeisPDF) + "\n" + this.totalMag5Rate.getRateMag5() + "\n" + this.maxMag);
            this.gridSources = new UCERF3_NoFaultsGridSourceGenerator(seisPDF, this.totalMag5Rate.getRateMag5(), this.maxMag);
        }
        if (this.bgRupTypeChanged) {
            this.setAllNthRupRelatedArrays();
        }
        this.applyAftershockFilterChanged = false;
        this.bgRupTypeChanged = false;
        this.spatialSeisPDF_Changed = false;
        this.totalMag5RateChanged = false;
        this.maxMagChanged = false;
        this.timeSpanChangeFlag = false;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        super.parameterChange(event);
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(this.applyAftershockFilterParam.getName())) {
            this.applyAftershockFilter = (Boolean)this.applyAftershockFilterParam.getValue();
            this.applyAftershockFilterChanged = true;
        } else if (paramName.equalsIgnoreCase(this.bgRupTypeParam.getName())) {
            this.bgRupTypeChanged = true;
        } else if (paramName.equalsIgnoreCase(this.bgSettingsParam.getName())) {
            this.bgSettings = (GriddedSeismicitySettings)this.bgSettingsParam.getValue();
            this.bgRupTypeChanged = true;
        } else if (paramName.equalsIgnoreCase(this.maxMagParam.getName())) {
            this.maxMag = (Double)this.maxMagParam.getValue();
            this.maxMagChanged = true;
        } else if (paramName.equalsIgnoreCase(this.totalRateParam.getName())) {
            this.totalMag5Rate = (TotalMag5Rate)this.totalRateParam.getValue();
            this.totalMag5RateChanged = true;
        } else if (paramName.equalsIgnoreCase(this.spatialSeisPDF_Param.getName())) {
            this.spatialSeisPDF = (SpatialSeisPDF)this.spatialSeisPDF_Param.getValue();
            this.spatialSeisPDF_Changed = true;
        } else {
            throw new RuntimeException("parameter name not recognized");
        }
    }

    public GridSourceProvider getGridSourceProvider() {
        return this.gridSources;
    }

    @Override
    public int getNumSources() {
        return this.gridSources.getNumSources();
    }

    @Override
    public ProbEqkSource getSource(int iSource) {
        return this.gridSources.getSource(iSource, this.timeSpan.getDuration(), this.applyAftershockFilter ? AbstractGridSourceProvider.GK_AFTERSHOCK_FILTER : null, this.bgSettings);
    }

    @Override
    public void timeSpanChange(EventObject event) {
        this.timeSpanChangeFlag = true;
    }

    public static void main(String[] args) {
        UCERF3_GriddedSeisOnlyERF_ETAS erf = new UCERF3_GriddedSeisOnlyERF_ETAS();
        erf.getTimeSpan().setDuration(1.0);
        erf.getParameter("Spatial Seis PDF").setValue(null);
        erf.updateForecast();
        ParameterList paramList = erf.getAdjustableParameterList();
        for (int p = 0; p < paramList.size(); ++p) {
            System.out.println(paramList.getByIndex(p).getName() + "\t" + String.valueOf(paramList.getByIndex(p).getValue()));
        }
        System.out.println("erf.getNumSources()=" + erf.getNumSources());
        GriddedGeoDataSet data = ERF_Calculator.getNucleationRatesInRegion(erf, erf.getGridSourceProvider().getGriddedRegion(), 0.0, 10.0);
        System.out.println("data.getMaxZ()=" + data.getMaxZ());
        if (erf.spatialSeisPDF_Param.getValue() != null) {
            double[] seisPDF = ((SpatialSeisPDF)erf.spatialSeisPDF_Param.getValue()).getPDF();
            for (int i = 0; i < data.size(); ++i) {
                Location loc = data.getLocation(i);
                System.out.println(loc.getLongitude() + "\t" + loc.getLatitude() + "\t" + data.get(i) + "\t" + seisPDF[i]);
            }
        } else {
            for (int i = 0; i < data.size(); ++i) {
                Location loc = data.getLocation(i);
                System.out.println(loc.getLongitude() + "\t" + loc.getLatitude() + "\t" + data.get(i));
            }
        }
        SummedMagFreqDist totMFD = ERF_Calculator.getTotalMFD_ForERF(erf, 2.55, 8.45, 60, true);
        System.out.println("totMFD.getCumRate(5.05)=" + totMFD.getCumRate(5.05));
    }
}

