/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Stopwatch;
import java.awt.Color;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import java.util.ArrayList;
import java.util.List;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotPreferences;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_Utils;
import scratch.UCERF3.erf.ETAS.analysis.SimulationMarkdownGenerator;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_CatalogIteration;

public abstract class ETAS_AbstractPlot {
    private ETAS_Config config;
    private ETAS_Launcher launcher;
    private Stopwatch processStopwatch;
    private AsyncManager asyncManager;
    private int numProcessed = 0;
    protected static final DecimalFormat optionalDigitDF = new DecimalFormat("0.##");
    private static final DecimalFormat optionalSingleDigitDF = new DecimalFormat("0.#");
    protected static DecimalFormat normProbDF = new DecimalFormat("0.000");
    protected static DecimalFormat expProbDF = new DecimalFormat("0.00E0");
    protected static DecimalFormat percentProbDF = new DecimalFormat("0.00%");
    private static final int GLOBAL_MAX_PRELOAD = 50;
    private static final double MAX_PRELOAD_YEARS = 1000.0;

    protected ETAS_AbstractPlot(ETAS_Config config, ETAS_Launcher launcher) {
        this.config = config;
        this.launcher = launcher;
        this.processStopwatch = Stopwatch.createUnstarted();
        if (this.isProcessAsync()) {
            this.asyncManager = new AsyncManager(config);
        }
    }

    public abstract int getVersion();

    public boolean shouldReplot(SimulationMarkdownGenerator.PlotResult prevResult) {
        return ETAS_AbstractPlot.shouldReplot(prevResult, this.getVersion());
    }

    static boolean shouldReplot(SimulationMarkdownGenerator.PlotResult prevResult, int version) {
        return prevResult == null || prevResult.version < version;
    }

    public abstract boolean isFilterSpontaneous();

    public boolean isEvaluationPlot() {
        return false;
    }

    protected void processCatalogsFile(File catalogsFile) {
        final FaultSystemSolution fss = this.getLauncher().checkOutFSS();
        ETAS_CatalogIteration.processCatalogs(catalogsFile, new ETAS_CatalogIteration.Callback(){
            final /* synthetic */ ETAS_AbstractPlot this$0;
            {
                this.this$0 = this$0;
            }

            @Override
            public void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog, int index) {
                this.this$0.processCatalog(catalog, fss);
            }
        });
        this.getLauncher().checkInFSS(fss);
    }

    public final void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog, FaultSystemSolution fss) {
        ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog = null;
        if (this.isFilterSpontaneous()) {
            triggeredOnlyCatalog = ETAS_Launcher.getFilteredNoSpontaneous(this.config, catalog);
        }
        this.processCatalog(catalog, triggeredOnlyCatalog, fss);
    }

    public final void processCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        this.processStopwatch.start();
        try {
            if (this.asyncManager == null) {
                this.doProcessCatalog(completeCatalog, triggeredOnlyCatalog, fss);
            } else {
                this.asyncManager.processAsync(completeCatalog, triggeredOnlyCatalog, fss);
            }
        }
        catch (RuntimeException e) {
            throw e;
        }
        finally {
            this.processStopwatch.stop();
        }
        ++this.numProcessed;
    }

    protected int getNumProcessed() {
        return this.numProcessed;
    }

    public long getProcessTimeMS() {
        return this.processStopwatch.elapsed(TimeUnit.MILLISECONDS);
    }

    protected abstract void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog var1, ETAS_CatalogIO.ETAS_Catalog var2, FaultSystemSolution var3);

    public ETAS_Config getConfig() {
        return this.config;
    }

    public ETAS_Launcher getLauncher() {
        return this.launcher;
    }

    protected boolean isProcessAsync() {
        return false;
    }

    public final void finalize(File outputDir, FaultSystemSolution fss) throws IOException {
        int threads = Integer.min(8, Runtime.getRuntime().availableProcessors());
        ExecutorService exec = Executors.newFixedThreadPool(threads);
        List<? extends Runnable> runnables = this.finalize(outputDir, fss, exec);
        if (runnables != null && !runnables.isEmpty()) {
            ArrayList futures = new ArrayList();
            for (Runnable runnable : runnables) {
                futures.add(exec.submit(runnable));
            }
            for (Future future : futures) {
                try {
                    future.get();
                }
                catch (InterruptedException | ExecutionException e) {
                    exec.shutdown();
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }
        exec.shutdown();
    }

    public final List<? extends Runnable> finalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        if (this.asyncManager != null) {
            this.asyncManager.waitOnFutures();
        }
        return this.doFinalize(outputDir, fss, exec);
    }

    protected abstract List<? extends Runnable> doFinalize(File var1, FaultSystemSolution var2, ExecutorService var3) throws IOException;

    public abstract List<String> generateMarkdown(String var1, String var2, String var3) throws IOException;

    public static HeadlessGraphPanel buildGraphPanel() {
        PlotPreferences plotPrefs = PlotPreferences.getDefault();
        plotPrefs.setTickLabelFontSize(20);
        plotPrefs.setAxisLabelFontSize(22);
        plotPrefs.setPlotLabelFontSize(24);
        plotPrefs.setLegendFontSize(20);
        plotPrefs.setBackgroundColor(Color.WHITE);
        return new HeadlessGraphPanel(plotPrefs);
    }

    public static String getTimeLabel(double years, boolean plural) {
        double fractionalDays = years * 365.25;
        if (fractionalDays < 0.99) {
            double hours = fractionalDays * 24.0;
            double mins = hours * 60.0;
            double secs = mins * 60.0;
            if (hours > 0.99) {
                if (hours >= 1.05 && plural) {
                    return optionalSingleDigitDF.format(hours) + " Hours";
                }
                return optionalSingleDigitDF.format(hours) + " Hour";
            }
            if (mins > 0.99) {
                if (mins >= 1.05 && plural) {
                    return optionalSingleDigitDF.format(mins) + " Minutes";
                }
                return optionalSingleDigitDF.format(mins) + " Minute";
            }
            if (secs >= 1.05 && plural) {
                return optionalSingleDigitDF.format(secs) + " Seconds";
            }
            return optionalSingleDigitDF.format(secs) + " Second";
        }
        if (years < 1.0) {
            boolean isRoundedMonth;
            int days = (int)(fractionalDays + 0.5);
            double months = years * 12.0;
            boolean bl = isRoundedMonth = (double)Math.round(months) == (double)Math.round(10.0 * months) / 10.0;
            if (days > 28 && isRoundedMonth) {
                if (months >= 1.05 && plural) {
                    return optionalSingleDigitDF.format(months) + " Months";
                }
                return optionalSingleDigitDF.format(months) + " Month";
            }
            if (days >= 7 && days % 7 == 0) {
                int weeks = days / 7;
                if (weeks > 1 && plural) {
                    return weeks + " Weeks";
                }
                return weeks + " Week";
            }
            if (fractionalDays >= 1.05 && plural) {
                return optionalSingleDigitDF.format(fractionalDays) + " Days";
            }
            return optionalSingleDigitDF.format(fractionalDays) + " Day";
        }
        if (plural && years >= 1.05) {
            return optionalSingleDigitDF.format(years) + " Years";
        }
        return optionalSingleDigitDF.format(years) + " Year";
    }

    public static String getTimeShortLabel(double years) {
        String label = ETAS_AbstractPlot.getTimeLabel(years, false);
        label = label.replaceAll("Seconds", "s");
        label = label.replaceAll("Second", "s");
        label = label.replaceAll("Minutes", "m");
        label = label.replaceAll("Minute", "m");
        label = label.replaceAll("Hours", "hr");
        label = label.replaceAll("Hour", "hr");
        label = label.replaceAll("Days", "d");
        label = label.replaceAll("Day", "d");
        label = label.replaceAll("Weeks", "wk");
        label = label.replaceAll("Week", "wk");
        label = label.replaceAll("Months", "mo");
        label = label.replaceAll("Month", "mo");
        label = label.replaceAll("Years", "yr");
        label = label.replaceAll("Year", "yr");
        return label;
    }

    protected static String getProbStr(double prob) {
        return ETAS_AbstractPlot.getProbStr(prob, false);
    }

    protected static String getProbStr(double prob, boolean includePercent) {
        return ETAS_AbstractPlot.getProbStr(prob, includePercent, -1);
    }

    protected static String getProbStr(double prob, boolean includePercent, int numForConf) {
        Object ret = prob < 0.01 && prob > 0.0 ? expProbDF.format(prob) : normProbDF.format(prob);
        if (includePercent) {
            ret = (String)ret + " (" + percentProbDF.format(prob) + ")";
        }
        if (numForConf > 0) {
            ret = (String)ret + ", <small>*CI<sup>95%</sup>=" + ETAS_AbstractPlot.getConfString(prob, numForConf, includePercent) + "*</small>";
        }
        return ret;
    }

    protected static String getConfString(double prob, int num, boolean percent) {
        double[] conf = ETAS_Utils.getBinomialProportion95confidenceInterval(prob, num);
        if (percent) {
            return "[" + percentProbDF.format(conf[0]) + " " + percentProbDF.format(conf[1]) + "]";
        }
        return "[" + ETAS_AbstractPlot.getProbStr(conf[0]) + " " + ETAS_AbstractPlot.getProbStr(conf[1]) + "]";
    }

    private class AsyncManager {
        private ExecutorService exec;
        private List<Future<?>> futures;

        public AsyncManager(ETAS_Config config) {
            int maxPreload = 50;
            maxPreload = Integer.min(maxPreload, config.getNumSimulations() / 100);
            maxPreload = Integer.min(maxPreload, (int)(1000.0 / config.getDuration() + 0.5));
            maxPreload = Integer.max(2, maxPreload);
            this.exec = new ThreadPoolExecutor(1, 1, 0L, TimeUnit.MILLISECONDS, new LimitedQueue<Runnable>(maxPreload));
            this.futures = new ArrayList(config.getNumSimulations());
        }

        public void processAsync(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
            this.futures.add(this.exec.submit(new ProcessRunnable(completeCatalog, triggeredOnlyCatalog, fss)));
        }

        public void waitOnFutures() {
            try {
                for (Future<?> future : this.futures) {
                    future.get();
                }
            }
            catch (InterruptedException | ExecutionException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            this.exec.shutdown();
        }
    }

    public static class LimitedQueue<E>
    extends LinkedBlockingQueue<E> {
        public LimitedQueue(int maxSize) {
            super(maxSize);
        }

        @Override
        public boolean offer(E e) {
            try {
                this.put(e);
                return true;
            }
            catch (InterruptedException ie) {
                Thread.currentThread().interrupt();
                return false;
            }
        }
    }

    private class ProcessRunnable
    implements Runnable {
        private final ETAS_CatalogIO.ETAS_Catalog completeCatalog;
        private final ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog;
        private final FaultSystemSolution fss;

        public ProcessRunnable(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
            this.completeCatalog = completeCatalog;
            this.triggeredOnlyCatalog = triggeredOnlyCatalog;
            this.fss = fss;
        }

        @Override
        public void run() {
            ETAS_AbstractPlot.this.doProcessCatalog(this.completeCatalog, this.triggeredOnlyCatalog, this.fss);
        }
    }
}

