/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Date;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.jfree.chart.axis.NumberTickUnit;
import org.jfree.chart.axis.TickUnit;
import org.jfree.chart.axis.TickUnitSource;
import org.jfree.chart.axis.TickUnits;
import org.jfree.chart.ui.RectangleEdge;
import org.jfree.data.Range;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.comcat.ComcatAccessor;
import org.opensha.commons.data.comcat.ComcatRegion;
import org.opensha.commons.data.comcat.ComcatRegionAdapter;
import org.opensha.commons.data.comcat.plot.ComcatDataPlotter;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.data.uncertainty.UncertainArbDiscFunc;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.mapping.PoliticalBoundariesData;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.magComplete.Helmstetter2006_TimeDepMc;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_EventMapPlotUtils;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_MFD_Plot;
import scratch.UCERF3.erf.ETAS.analysis.SimulationMarkdownGenerator;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.ETAS.launcher.TriggerRupture;

public class ETAS_ComcatComparePlot
extends ETAS_AbstractPlot {
    private double minSpan;
    private Region mapRegion;
    private GriddedRegion gridRegion;
    private long fetchEndTime;
    private ObsEqkRupList comcatEvents;
    private double modalMag;
    private double comcatMc;
    private double comcatMinMag;
    private double comcatMaxMag;
    private double simMc;
    private double overallMc;
    private boolean smallSequence;
    private static final double CISN_MC = 2.3;
    private static double MAX_MAG_FOR_TD_MC = 5.0;
    private Helmstetter2006_TimeDepMc timeDepMc;
    private double innerBoxMinLat;
    private double innerBoxMaxLat;
    private double innerBoxMinLon;
    private double innerBoxMaxLon;
    private boolean timeDays;
    private double[] magBins;
    private int catalogsProcessed = 0;
    private List<short[][][]> catalogDurMagGridCounts;
    private String[][] mapProbPrefixes;
    private String[][] mapMeanPrefixes;
    private String[][] mapMedianPrefixes;
    private double[][] catalogProbsSummary;
    private double[][][] catalogProbs;
    private double[][] catalogMeansSummary;
    private double[][][] catalogMeans;
    private double[][][] catalogMedians;
    private int[][] comcatCountsSummary;
    private EvenlyDiscretizedFunc magTimeYAxis;
    private double magTimeXAxisFullMax;
    private EvenlyDiscretizedFunc magTimeXAxisFull;
    private double magTimeXAxisWeekMax;
    private EvenlyDiscretizedFunc magTimeXAxisWeek;
    private double magTimeXAxisMonthMax;
    private EvenlyDiscretizedFunc magTimeXAxisMonth;
    private double[][] magTimeProbsFull;
    private double[][] magTimeProbsWeek;
    private double[][] magTimeProbsMonth;
    private List<IncrementalMagFreqDist> catalogRegionMFDs;
    private double[] timeFuncMcs;
    private List<EvenlyDiscretizedFunc[]> catalogTimeFuncs;
    private EvenlyDiscretizedFunc[] catalogDepthDistributions;
    private HistogramFunction totalCountHist;
    private ComcatDataPlotter plotter;
    private static double[] default_durations = new double[]{0.0027378507871321013, 0.019164955509924708, 0.08213552361396304, 1.0};
    private static final boolean map_plot_probs = true;
    private static final boolean map_plot_means = true;
    private static final boolean map_plot_medians = false;
    private double[] durations;
    private long[] maxOTs;
    private long startTime;
    private long curTime;
    private double curDuration;
    private CPT baseCPT = null;
    private Double minZ = null;
    private Color mapDataColor = Color.CYAN;
    private static final int cpt_discretizations = 4;
    private static final int VERSION = 19;
    boolean forecastOnly;

    public ETAS_ComcatComparePlot(ETAS_Config config, ETAS_Launcher launcher) {
        this(config, launcher, null);
    }

    public ETAS_ComcatComparePlot(ETAS_Config config, ETAS_Launcher launcher, ObsEqkRupList inputEvents) {
        super(config, launcher);
        ETAS_Config.ComcatMetadata comcatMeta = config.getComcatMetadata();
        Preconditions.checkNotNull((Object)comcatMeta, (Object)"Must have ComCat metadata for ComCat Plot");
        this.mapRegion = ETAS_EventMapPlotUtils.getMapRegion(config, launcher);
        this.minSpan = Math.min(this.mapRegion.getMaxLat() - this.mapRegion.getMinLat(), this.mapRegion.getMaxLon() - this.mapRegion.getMinLon());
        double spacing = this.minSpan > 4.0 ? 0.1 : (this.minSpan > 2.0 ? 0.05 : config.getGridSeisDiscr() / 5.0);
        System.out.println("ComCat map grid spacing: " + (float)spacing + " for minSpan=" + (float)this.minSpan);
        Location anchor = GriddedRegion.ANCHOR_0_0;
        this.gridRegion = new GriddedRegion(this.mapRegion, spacing, anchor);
        this.startTime = config.getSimulationStartTimeMillis();
        this.curTime = System.currentTimeMillis();
        Preconditions.checkState((this.curTime > this.startTime ? 1 : 0) != 0, (Object)"Simulation starts in the future?");
        this.curDuration = (double)(this.curTime - this.startTime) / 3.15576E10;
        System.out.println("Current duration from start time: " + (float)this.curDuration);
        ArrayList<Double> durationsList = new ArrayList<Double>();
        for (double duration : default_durations) {
            if (!(duration < config.getDuration())) continue;
            durationsList.add(duration);
        }
        if (this.curDuration < config.getDuration()) {
            durationsList.add(this.curDuration);
        } else {
            durationsList.add(config.getDuration());
        }
        Collections.sort(durationsList);
        this.durations = Doubles.toArray(durationsList);
        this.maxOTs = new long[this.durations.length];
        for (int i = 0; i < this.durations.length; ++i) {
            this.maxOTs[i] = this.startTime + (long)(3.15576E10 * this.durations[i] + 0.5);
        }
        System.out.println("Max comcat compare duration: " + (float)this.durations[this.durations.length - 1]);
        if (inputEvents != null) {
            this.fetchEndTime = System.currentTimeMillis();
            this.comcatEvents = inputEvents;
        } else {
            this.fetchEndTime = Long.min(this.curTime, this.maxOTs[this.maxOTs.length - 1]);
            try {
                this.comcatEvents = ETAS_ComcatComparePlot.loadComcatEvents(config, comcatMeta, this.mapRegion, this.fetchEndTime);
            }
            catch (Exception e) {
                System.err.println("Error fetching ComCat events, skipping");
                e.printStackTrace();
                this.comcatEvents = new ObsEqkRupList();
                return;
            }
        }
        if (this.comcatEvents.isEmpty()) {
            System.out.println("No ComCat events found");
            return;
        }
        this.smallSequence = false;
        double minMag = Double.POSITIVE_INFINITY;
        for (ObsEqkRupture comcatEvent : this.comcatEvents) {
            if (comcatEvent.getMag() < comcatMeta.minMag) {
                this.smallSequence = true;
            }
            minMag = Math.min(comcatEvent.getMag(), minMag);
        }
        System.out.println("Min ComCat mag: " + minMag);
    }

    public static boolean isSmallSequence(ETAS_Config config) {
        List<TriggerRupture> triggers = config.getTriggerRuptures();
        if (triggers == null) {
            return false;
        }
        for (TriggerRupture trigger : triggers) {
            Double mag = trigger.getMag(null);
            if (mag == null) {
                return false;
            }
            if (!(mag >= 6.0)) continue;
            return false;
        }
        return true;
    }

    public synchronized ComcatDataPlotter getPlotter() {
        if (this.plotter == null) {
            this.init();
        }
        return this.plotter;
    }

    public double[] getDurations() {
        return this.durations;
    }

    public double getCurDuration() {
        return this.curDuration;
    }

    public double[] getMinMags() {
        return this.magBins;
    }

    public String[][] getMapProbPrefixes() {
        return this.mapProbPrefixes;
    }

    public static ObsEqkRupList loadComcatEvents(ETAS_Config config, ETAS_Config.ComcatMetadata comcatMeta, Region mapRegion, long endTime) {
        ComcatAccessor accessor = new ComcatAccessor();
        ComcatRegion cReg = mapRegion instanceof ComcatRegion ? (ComcatRegion)((Object)mapRegion) : new ComcatRegionAdapter(mapRegion);
        boolean smallSequence = ETAS_ComcatComparePlot.isSmallSequence(config);
        if (smallSequence) {
            System.out.println("Small sequence, will plot below minMag");
        }
        double minMag = smallSequence ? 0.0 : comcatMeta.minMag;
        return accessor.fetchEventList(comcatMeta.eventID, config.getSimulationStartTimeMillis(), endTime, comcatMeta.minDepth, comcatMeta.maxDepth, cReg, false, false, minMag);
    }

    private void init() {
        double delta;
        double magDelta;
        ETAS_Config config = this.getConfig();
        ETAS_Launcher launcher = this.getLauncher();
        ETAS_Config.ComcatMetadata comcatMeta = config.getComcatMetadata();
        double maxTriggerMag = Double.NEGATIVE_INFINITY;
        ETAS_EqkRupture maxMainshock = null;
        ArrayList<ETAS_EqkRupture> inputRups = new ArrayList<ETAS_EqkRupture>();
        ObsEqkRupture inputMS = null;
        for (ETAS_EqkRupture rup : launcher.getTriggerRuptures()) {
            if (rup.getMag() > maxTriggerMag) {
                maxMainshock = rup;
                maxTriggerMag = rup.getMag();
            }
            if (rup.getEventId() != null && rup.getEventId().equals(comcatMeta.eventID)) {
                inputMS = rup;
                continue;
            }
            inputRups.add(rup);
        }
        long plotOT = inputMS == null ? this.startTime : inputMS.getOriginTime();
        long plotET = Long.max(this.curTime, this.startTime + 604800000L);
        this.plotter = new ComcatDataPlotter(inputMS, plotOT, plotET, inputRups, this.comcatEvents);
        this.comcatMinMag = this.smallSequence ? 0.05 : 2.5;
        this.comcatMaxMag = this.plotter.getMaxAftershockMag();
        this.modalMag = this.plotter.calcModalMag(this.comcatMinMag, false, false);
        System.out.println("Found " + this.comcatEvents.size() + " ComCat events in region. Max mag: " + (float)this.comcatMaxMag + ". Modal mag: " + (float)this.modalMag);
        if (comcatMeta.magComplete == null) {
            System.out.println("Using default Mc = modalMag + 0.5");
            this.comcatMc = this.modalMag + 0.5;
        } else {
            System.out.println("Using supplied ComCat Mc");
            this.comcatMc = comcatMeta.magComplete;
        }
        System.out.println("Mc=" + (float)this.comcatMc);
        this.timeDays = this.plotter.isTimeDays();
        double maxCurTimeFunc = (double)(config.getSimulationStartTimeMillis() - plotOT) / 3.15576E10;
        if (maxCurTimeFunc > 6.944444444444445E-4) {
            double maxPlotTimeFunc = (double)(plotET - plotOT) / 3.15576E10;
            if (this.timeDays) {
                maxCurTimeFunc *= 365.25;
                maxPlotTimeFunc *= 365.25;
            }
            double origDelta = maxPlotTimeFunc / 500.0;
            int partialNum = (int)Math.ceil(maxCurTimeFunc / origDelta);
            partialNum = Math.max(partialNum, 5);
            EvenlyDiscretizedFunc timeFunc = new EvenlyDiscretizedFunc(0.0, maxCurTimeFunc, partialNum);
            int extraNum = (int)Math.round((maxPlotTimeFunc - maxCurTimeFunc) / timeFunc.getDelta());
            timeFunc = new EvenlyDiscretizedFunc(0.0, timeFunc.size() + extraNum, timeFunc.getDelta());
            this.plotter.setTimeFuncDiscretization(timeFunc);
        }
        System.out.println("Time function has " + this.plotter.getTimeFuncDiscretization().size() + " points");
        ArrayList<ObsEqkRupture> mainshocksForTimeDepMc = new ArrayList<ObsEqkRupture>();
        mainshocksForTimeDepMc.add(maxMainshock);
        for (ObsEqkRupture rup : this.comcatEvents) {
            if (!(rup.getMag() >= MAX_MAG_FOR_TD_MC)) continue;
            mainshocksForTimeDepMc.add(rup);
        }
        for (ETAS_EqkRupture rup : launcher.getTriggerRuptures()) {
            if (rup == maxMainshock || !(rup.getMag() >= MAX_MAG_FOR_TD_MC)) continue;
            mainshocksForTimeDepMc.add(rup);
        }
        this.timeDepMc = new Helmstetter2006_TimeDepMc(mainshocksForTimeDepMc, Math.max(2.5, 2.3));
        double maxMag = Math.max(maxTriggerMag, this.comcatMaxMag);
        double maxTestMag = Math.ceil(maxMag);
        double d = magDelta = maxMag < 6.0 ? 0.5 : 1.0;
        if (maxTestMag - maxMag < 0.5 && maxTestMag < 8.0) {
            maxTestMag += magDelta;
        }
        ArrayList<Double> mags = new ArrayList<Double>();
        mags.add(-1.0);
        double minMag = Math.max(2.5, this.comcatMc);
        if (minMag < Math.ceil(minMag)) {
            mags.add(minMag);
        }
        double mag = minMag = Math.ceil(minMag);
        while ((float)mag <= (float)maxTestMag) {
            mags.add(mag);
            mag += magDelta;
        }
        System.out.println("Magnitudes for ComCat comparison: " + Joiner.on((String)", ").join(mags));
        this.magBins = Doubles.toArray(mags);
        ArrayList timeMags = new ArrayList(mags);
        double maxTimeFuncMag = Math.ceil(Math.max(this.comcatMc, this.comcatMaxMag) + 1.0);
        int m = timeMags.size();
        while (--m >= 1) {
            if (!(((Double)timeMags.get(m)).floatValue() > (float)maxTimeFuncMag)) continue;
            timeMags.remove(m);
        }
        this.timeFuncMcs = Doubles.toArray(timeMags);
        this.catalogProbs = new double[this.durations.length][this.magBins.length][this.gridRegion.getNodeCount()];
        this.catalogProbsSummary = new double[this.durations.length][this.magBins.length];
        this.catalogMeans = new double[this.durations.length][this.magBins.length][this.gridRegion.getNodeCount()];
        this.catalogMeansSummary = new double[this.durations.length][this.magBins.length];
        this.catalogRegionMFDs = new ArrayList<IncrementalMagFreqDist>();
        this.catalogTimeFuncs = new ArrayList<EvenlyDiscretizedFunc[]>();
        this.totalCountHist = new HistogramFunction(ETAS_MFD_Plot.mfdMinMag, ETAS_MFD_Plot.mfdNumMag, ETAS_MFD_Plot.mfdDelta);
        this.catalogDepthDistributions = new EvenlyDiscretizedFunc[this.magBins.length];
        double minDepthBin = 0.5;
        double deltaDepth = 1.0;
        int numDepth = (int)Math.ceil(24.0);
        for (int i = 0; i < this.magBins.length; ++i) {
            this.catalogDepthDistributions[i] = new EvenlyDiscretizedFunc(minDepthBin, numDepth, deltaDepth);
        }
        this.magTimeYAxis = new EvenlyDiscretizedFunc(0.25 + this.totalCountHist.getMinX() - 0.5 * this.totalCountHist.getDelta(), 13, 0.5);
        if (this.timeDays) {
            delta = this.curDuration * 365.25 / 15.0;
            this.magTimeXAxisFull = new EvenlyDiscretizedFunc(0.5 * delta, 15, delta);
            this.magTimeXAxisWeek = new EvenlyDiscretizedFunc(0.25, 14, 0.5);
            this.magTimeXAxisMonth = new EvenlyDiscretizedFunc(1.0, 15, 2.0);
        } else {
            delta = this.curDuration / 15.0;
            this.magTimeXAxisFull = new EvenlyDiscretizedFunc(0.5 * delta, 15, delta);
            double yearScalar = 0.0027378507871321013;
            this.magTimeXAxisWeek = new EvenlyDiscretizedFunc(yearScalar * 0.25, 14, yearScalar * 0.5);
            this.magTimeXAxisMonth = new EvenlyDiscretizedFunc(yearScalar * 1.0, 15, yearScalar * 2.0);
        }
        this.magTimeProbsFull = new double[this.magTimeXAxisFull.size()][this.magTimeYAxis.size()];
        this.magTimeXAxisFullMax = this.magTimeXAxisFull.getMaxX() + 0.5 * this.magTimeXAxisFull.getDelta();
        this.magTimeProbsWeek = new double[this.magTimeXAxisWeek.size()][this.magTimeYAxis.size()];
        this.magTimeXAxisWeekMax = this.magTimeXAxisWeek.getMaxX() + 0.5 * this.magTimeXAxisWeek.getDelta();
        this.magTimeProbsMonth = new double[this.magTimeXAxisMonth.size()][this.magTimeYAxis.size()];
        this.magTimeXAxisMonthMax = this.magTimeXAxisMonth.getMaxX() + 0.5 * this.magTimeXAxisMonth.getDelta();
        this.innerBoxMinLat = this.mapRegion.getMinLat();
        this.innerBoxMaxLat = this.mapRegion.getMaxLat();
        this.innerBoxMinLon = this.mapRegion.getMinLon();
        this.innerBoxMaxLon = this.mapRegion.getMaxLon();
        if (!this.mapRegion.isRectangular()) {
            double lat;
            int y;
            double lon;
            double lon2;
            int x;
            double lat2;
            System.out.println("Searching for rectangular region inside of irregular ComCat region for faster contains tests");
            System.out.println("Outer box: [" + (float)this.innerBoxMinLat + " " + (float)this.innerBoxMaxLat + "], [" + (float)this.innerBoxMinLon + " " + (float)this.innerBoxMaxLon + "]");
            double gridSpacing = this.minSpan / 100.0;
            int nx = (int)((this.innerBoxMaxLon - this.innerBoxMinLon) / gridSpacing) + 1;
            int ny = (int)((this.innerBoxMaxLat - this.innerBoxMinLat) / gridSpacing) + 1;
            EvenlyDiscrXYZ_DataSet xyz = new EvenlyDiscrXYZ_DataSet(nx, ny, this.innerBoxMinLon, this.innerBoxMinLat, gridSpacing);
            int centerX = (int)Math.round((double)nx * 0.5);
            int centerY = (int)Math.round((double)ny * 0.5);
            double centerLat = xyz.getY(centerY);
            double centerLon = xyz.getX(centerX);
            System.out.println("Center point: at " + centerY + "," + centerX + ": " + (float)centerLat + ", " + (float)centerLon + ". Contains? " + this.mapRegion.contains(new Location(centerLat, centerLon)));
            System.out.println("spacing: " + (float)gridSpacing + ", nx=" + nx + ", ny=" + ny);
            int squareAdd = 0;
            while (true) {
                int add = squareAdd + 1;
                boolean inside = true;
                block9: for (int x2 = centerX - add; inside && x2 <= centerX + add; ++x2) {
                    if (x2 < 0 || x2 == nx) {
                        inside = false;
                        break;
                    }
                    double lon3 = xyz.getX(x2);
                    for (int y2 = centerY - add; inside && y2 <= centerY + add; ++y2) {
                        if (y2 < 0 || y2 == ny) {
                            inside = false;
                            continue block9;
                        }
                        double lat3 = xyz.getY(y2);
                        inside = inside && this.mapRegion.contains(new Location(lat3, lon3));
                    }
                }
                if (!inside) break;
                ++squareAdd;
            }
            System.out.println("SquareAdd=" + squareAdd + ", " + (float)((double)squareAdd * 2.0 * gridSpacing) + " degrees");
            int minY = centerY - squareAdd;
            int maxY = centerY + squareAdd;
            int minX = centerX - squareAdd;
            int maxX = centerX + squareAdd;
            while (maxY + 1 < ny) {
                lat2 = xyz.getY(maxY + 1);
                boolean inside = true;
                for (x = minX; inside && x <= maxX; ++x) {
                    lon2 = xyz.getX(x);
                    inside = inside && this.mapRegion.contains(new Location(lat2, lon2));
                }
                if (!inside) break;
                ++maxY;
            }
            while (minY > 0) {
                lat2 = xyz.getY(minY - 1);
                boolean inside = true;
                for (x = minX; inside && x <= maxX; ++x) {
                    lon2 = xyz.getX(x);
                    inside = inside && this.mapRegion.contains(new Location(lat2, lon2));
                }
                if (!inside) break;
                --minY;
            }
            while (maxX + 1 < nx) {
                lon = xyz.getX(maxX + 1);
                boolean inside = true;
                for (y = minY; inside && y <= maxY; ++y) {
                    lat = xyz.getY(y);
                    inside = inside && this.mapRegion.contains(new Location(lat, lon));
                }
                if (!inside) break;
                ++maxX;
            }
            while (minX > 0) {
                lon = xyz.getX(minX - 1);
                boolean inside = true;
                for (y = minY; inside && y <= maxY; ++y) {
                    lat = xyz.getY(y);
                    inside = inside && this.mapRegion.contains(new Location(lat, lon));
                }
                if (!inside) break;
                --minX;
            }
            if (maxX > minX && maxY > minY) {
                this.innerBoxMinLat = xyz.getY(minY);
                this.innerBoxMaxLat = xyz.getY(maxY);
                this.innerBoxMinLon = xyz.getX(minX);
                this.innerBoxMaxLon = xyz.getX(maxX);
                System.out.println("Inner box: [" + (float)this.innerBoxMinLat + " " + (float)this.innerBoxMaxLat + "], [" + (float)this.innerBoxMinLon + " " + (float)this.innerBoxMaxLon + "]");
            } else {
                this.innerBoxMinLat = Double.NaN;
                this.innerBoxMaxLat = Double.NaN;
                this.innerBoxMinLon = Double.NaN;
                this.innerBoxMaxLon = Double.NaN;
            }
        }
        try {
            this.baseCPT = GMT_CPT_Files.BLACK_RED_YELLOW_UNIFORM.instance().reverse();
        }
        catch (IOException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    @Override
    public boolean isFilterSpontaneous() {
        return false;
    }

    @Override
    protected boolean isProcessAsync() {
        return true;
    }

    @Override
    public int getVersion() {
        return 19;
    }

    @Override
    public boolean isEvaluationPlot() {
        return true;
    }

    @Override
    public boolean shouldReplot(SimulationMarkdownGenerator.PlotResult prevResult) {
        return !this.comcatEvents.isEmpty() && ETAS_ComcatComparePlot.shouldReplot(prevResult, this.getConfig());
    }

    public static boolean shouldReplot(SimulationMarkdownGenerator.PlotResult prevResult, ETAS_Config config) {
        Object updateStr;
        boolean comcatUpdate;
        if (ETAS_ComcatComparePlot.shouldReplot(prevResult, 19)) {
            return true;
        }
        long curTime = System.currentTimeMillis();
        double mpd = 8.64E7;
        long millisSinceUpdate = curTime - prevResult.time;
        double daysSinceUpdate = (double)millisSinceUpdate / mpd;
        long millisSinceStartTime = curTime - config.getSimulationStartTimeMillis();
        double daysSinceStartTime = (double)millisSinceStartTime / mpd;
        double threshold = daysSinceStartTime < 1.0 ? 0.020833333333333332 : (daysSinceStartTime < 2.0 ? 0.041666666666666664 : (daysSinceStartTime < 7.0 ? 0.25 : (daysSinceStartTime < 14.0 ? 0.5 : (daysSinceStartTime < 31.0 ? 1.0 : (daysSinceStartTime < 90.0 ? 7.0 : (daysSinceStartTime < 182.5 ? 14.0 : 30.0))))));
        threshold += new Random(prevResult.time).nextDouble() * threshold * 0.1;
        boolean bl = comcatUpdate = daysSinceUpdate > threshold;
        if (comcatUpdate) {
            updateStr = "true";
        } else {
            double daysUntil = threshold - daysSinceUpdate;
            updateStr = "false (will update in " + ETAS_ComcatComparePlot.getTimeShortLabel(daysUntil / 365.25) + ")";
        }
        System.out.println("\t" + (float)daysSinceUpdate + " d since last ComCat update, threshold is " + (float)threshold + ". Update? " + (String)updateStr);
        return comcatUpdate;
    }

    private boolean quickContains(Location hypocenter) {
        double lat = hypocenter.getLatitude();
        double lon = hypocenter.getLongitude();
        if (!Double.isNaN(this.innerBoxMinLat) && lat >= this.innerBoxMinLat && lat <= this.innerBoxMaxLat && lon >= this.innerBoxMinLon && lon <= this.innerBoxMaxLon) {
            return true;
        }
        return this.mapRegion.contains(hypocenter);
    }

    private boolean isRupAboveMinMag(ObsEqkRupture rup, double minMag, double timeDepMc) {
        if (minMag < 0.0) {
            return rup.getMag() >= timeDepMc;
        }
        return rup.getMag() >= minMag;
    }

    @Override
    protected void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        int x;
        this.getPlotter();
        short[][][] magGridCounts = new short[this.durations.length][this.magBins.length][];
        IncrementalMagFreqDist catMFD = new IncrementalMagFreqDist(this.totalCountHist.getMinX(), this.totalCountHist.getMaxX(), this.totalCountHist.size());
        EvenlyDiscretizedFunc[] timeFuncs = new EvenlyDiscretizedFunc[this.timeFuncMcs.length];
        for (int i = 0; i < timeFuncs.length; ++i) {
            timeFuncs[i] = this.plotter.getTimeFuncDiscretization().deepClone();
        }
        boolean[][] magTimesFull = new boolean[this.magTimeProbsFull.length][this.magTimeProbsFull[0].length];
        boolean[][] magTimesWeek = new boolean[this.magTimeProbsWeek.length][this.magTimeProbsWeek[0].length];
        boolean[][] magTimesMonth = new boolean[this.magTimeProbsMonth.length][this.magTimeProbsMonth[0].length];
        for (ETAS_EqkRupture rup : completeCatalog) {
            int gridNode;
            int m;
            Location hypo;
            double mag = rup.getMag();
            int mfdIndex = this.totalCountHist.getClosestXIndex(mag);
            this.totalCountHist.add(mfdIndex, 1.0);
            long ot = rup.getOriginTime();
            if (ot > this.maxOTs[this.maxOTs.length - 1] || !this.quickContains(hypo = rup.getHypocenterLocation())) continue;
            double timeDepMc = this.timeDepMc.calcTimeDepMc(rup);
            if (ot <= this.curTime) {
                catMFD.add(mfdIndex, 1.0);
                if (mag < this.magBins[1] && mag < timeDepMc) continue;
                int depthIndex = this.catalogDepthDistributions[0].getClosestXIndex(hypo.getDepth());
                for (m = 0; m < this.magBins.length; ++m) {
                    if (!this.isRupAboveMinMag(rup, this.magBins[m], timeDepMc)) continue;
                    this.catalogDepthDistributions[m].add(depthIndex, 1.0);
                }
            }
            if (ot <= this.plotter.getEndTime() && mag >= this.timeFuncMcs[0]) {
                int timeIndex = this.plotter.getTimeFuncIndex(rup);
                for (m = 0; m < this.timeFuncMcs.length; ++m) {
                    if (!this.isRupAboveMinMag(rup, this.timeFuncMcs[m], timeDepMc)) continue;
                    for (int i = timeIndex; i < timeFuncs[m].size(); ++i) {
                        timeFuncs[m].add(i, 1.0);
                    }
                }
            }
            if ((gridNode = this.gridRegion.indexForLocation(hypo)) >= 0) {
                for (int d = 0; d < this.durations.length; ++d) {
                    if (ot > this.maxOTs[d]) continue;
                    for (int m2 = 0; m2 < this.magBins.length; ++m2) {
                        if (!this.isRupAboveMinMag(rup, this.magBins[m2], timeDepMc)) continue;
                        if (magGridCounts[d][m2] == null) {
                            magGridCounts[d][m2] = new short[this.gridRegion.getNodeCount()];
                        }
                        Preconditions.checkState((magGridCounts[d][m2][gridNode] < Short.MAX_VALUE ? 1 : 0) != 0, (Object)"Using shorts to conserve memory for grid node event counts within each catalog, but we have more than MAX_SHORT in a single cell!");
                        short[] sArray = magGridCounts[d][m2];
                        int n = gridNode;
                        sArray[n] = (short)(sArray[n] + 1);
                    }
                }
            }
            int magTimeY = this.magTimeYAxis.getClosestXIndex(mag);
            double magTimeX = (double)(ot - this.startTime) / 3.15576E10;
            if (this.timeDays) {
                magTimeX *= 365.25;
            }
            if (magTimeX <= this.magTimeXAxisFullMax) {
                magTimesFull[this.magTimeXAxisFull.getClosestXIndex((double)magTimeX)][magTimeY] = true;
            }
            if (magTimeX <= this.magTimeXAxisWeekMax) {
                magTimesWeek[this.magTimeXAxisWeek.getClosestXIndex((double)magTimeX)][magTimeY] = true;
            }
            if (!(magTimeX <= this.magTimeXAxisMonthMax)) continue;
            magTimesMonth[this.magTimeXAxisMonth.getClosestXIndex((double)magTimeX)][magTimeY] = true;
        }
        for (x = 0; x < magTimesFull.length; ++x) {
            for (int y = 0; y < magTimesFull[0].length; ++y) {
                if (!magTimesFull[x][y]) continue;
                double[] dArray = this.magTimeProbsFull[x];
                int n = y;
                dArray[n] = dArray[n] + 1.0;
            }
        }
        if (magTimesWeek != null) {
            for (x = 0; x < magTimesWeek.length; ++x) {
                for (int y = 0; y < magTimesWeek[0].length; ++y) {
                    if (!magTimesWeek[x][y]) continue;
                    double[] dArray = this.magTimeProbsWeek[x];
                    int n = y;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
        }
        if (magTimesMonth != null) {
            for (x = 0; x < magTimesMonth.length; ++x) {
                for (int y = 0; y < magTimesMonth[0].length; ++y) {
                    if (!magTimesMonth[x][y]) continue;
                    double[] dArray = this.magTimeProbsMonth[x];
                    int n = y;
                    dArray[n] = dArray[n] + 1.0;
                }
            }
        }
        for (int d = 0; d < this.durations.length; ++d) {
            int m = 0;
            while (m < this.magBins.length) {
                double totCount = 0.0;
                int n = 0;
                while (n < this.gridRegion.getNodeCount()) {
                    short count = magGridCounts[d][m] == null ? (short)0 : magGridCounts[d][m][n];
                    totCount += (double)count;
                    if (count > 0) {
                        double[] dArray = this.catalogProbs[d][m];
                        int n2 = n;
                        dArray[n2] = dArray[n2] + 1.0;
                    }
                    double[] dArray = this.catalogMeans[d][m];
                    int n3 = n++;
                    dArray[n3] = dArray[n3] + (double)count;
                }
                if (totCount > 0.0) {
                    double[] dArray = this.catalogProbsSummary[d];
                    int n4 = m;
                    dArray[n4] = dArray[n4] + 1.0;
                }
                double[] dArray = this.catalogMeansSummary[d];
                int n5 = m++;
                dArray[n5] = dArray[n5] + totCount;
            }
        }
        this.catalogRegionMFDs.add(catMFD);
        this.catalogTimeFuncs.add(timeFuncs);
        ++this.catalogsProcessed;
    }

    private static String minMagPrefix(double mag) {
        if (mag < 0.0) {
            return "td_mc";
        }
        return "m" + optionalDigitDF.format(mag);
    }

    private static String minMagLabel(double mag) {
        if (mag < 0.0) {
            return "M\u2265Mc(t)";
        }
        return "M\u2265" + optionalDigitDF.format(mag);
    }

    private boolean shouldIncludeMinMag(double minMag) {
        boolean ret = (float)minMag >= (float)this.simMc || minMag < 0.0 && (float)this.simMc <= (float)this.timeDepMc.getMinMagThreshold();
        return ret;
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        boolean bl = this.forecastOnly = this.getConfig().getSimulationStartTimeMillis() >= this.fetchEndTime - 600000L;
        if (this.forecastOnly) {
            System.out.println("Will only make ComCat forecast plots");
        }
        int numToTrim = ETAS_MFD_Plot.calcNumToTrim(this.totalCountHist);
        this.simMc = this.totalCountHist.getX(numToTrim) - 0.5 * this.totalCountHist.getDelta();
        System.out.println("Simulation Mc: " + this.simMc);
        ArrayList<Runnable> runnables = new ArrayList<Runnable>();
        if (!this.forecastOnly) {
            System.out.println("Building ComCat time func plot runnables");
            this.overallMc = Math.max(this.comcatMc, this.simMc);
            for (int m = 0; m < this.timeFuncMcs.length; ++m) {
                if (!this.shouldIncludeMinMag(this.timeFuncMcs[m])) continue;
                runnables.add(new TimeFuncPlotRunnable(outputDir, "comcat_compare_cumulative_num_" + ETAS_ComcatComparePlot.minMagPrefix(this.timeFuncMcs[m]), m));
            }
        }
        System.out.println("Writing ComCat Incremental MND");
        FractileCurveCalculator incrMNDCalc = this.buildFractileCalc(this.catalogRegionMFDs);
        this.plotter.plotMagNumPlot(outputDir, "comcat_compare_mag_num", false, this.comcatMinMag, this.comcatMc, false, false, incrMNDCalc);
        System.out.println("Calculating Catalog Cumulative MNDs");
        ArrayList<EvenlyDiscretizedFunc> cumulativeMNDs = new ArrayList<EvenlyDiscretizedFunc>();
        for (IncrementalMagFreqDist incr : this.catalogRegionMFDs) {
            cumulativeMNDs.add(incr.getCumRateDistWithOffset());
        }
        FractileCurveCalculator cumMNDCalc = this.buildFractileCalc(cumulativeMNDs);
        System.out.println("Writing ComCat Cumulative MND");
        this.plotter.plotMagNumPlot(outputDir, "comcat_compare_mag_num_cumulative", true, this.comcatMinMag, this.comcatMc, false, false, cumMNDCalc);
        if (!this.forecastOnly) {
            System.out.println("Writing ComCat Percentile Cumulative Plot");
            this.plotMagPercentileCumulativeNumPlot(outputDir, "comcat_compare_cumulative_num_percentile", cumulativeMNDs);
        }
        System.out.println("Writing ComCat Mag-Time plots");
        this.calcMagTimeProbs();
        if (!this.forecastOnly) {
            this.plotMagTimeFunc(this.magTimeProbsFull, this.magTimeXAxisFull, "To Date Magnitude vs Time", outputDir, "mag_time_full");
        }
        this.plotMagTimeFunc(this.magTimeProbsWeek, this.magTimeXAxisWeek, "One Week Magnitude vs Time Forecast", outputDir, "mag_time_week");
        this.plotMagTimeFunc(this.magTimeProbsMonth, this.magTimeXAxisMonth, "One Month Magnitude vs Time Forecast", outputDir, "mag_time_month");
        System.out.println("Writing time-dep Mc plot");
        this.plotter.plotTimeDepMcPlot(outputDir, "comcat_compare_td_mc", this.timeDepMc);
        System.out.println("Calculating ComCat map data");
        this.calcMapData();
        System.out.println("Will write ComCat maps in parallel in background");
        this.comcatCountsSummary = new int[this.durations.length][this.magBins.length];
        this.mapProbPrefixes = this.writeMapPlots(outputDir, "comcat_compare_prob", "Probability", this.catalogProbs, true, fss.getRupSet(), runnables);
        this.mapMeanPrefixes = this.writeMapPlots(outputDir, "comcat_compare_mean", "Mean Expected Number", this.catalogMeans, false, fss.getRupSet(), runnables);
        System.out.println("Writing ComCat Depth plots");
        this.writeDepthPlots(outputDir, "comcat_compare_depth");
        System.out.println("Done with ComCat doFinalize (still waiting on parallel background calcs)");
        return runnables;
    }

    private FractileCurveCalculator buildFractileCalc(List<? extends EvenlyDiscretizedFunc> funcs) {
        XY_DataSetList functionList = new XY_DataSetList();
        ArrayList<Double> relativeWts = new ArrayList<Double>();
        for (EvenlyDiscretizedFunc evenlyDiscretizedFunc : funcs) {
            functionList.add(evenlyDiscretizedFunc);
            relativeWts.add(1.0);
        }
        return new FractileCurveCalculator(functionList, relativeWts);
    }

    private void plotTimeFuncPlot(File outputDir, String prefix, int magIndex) throws IOException {
        double mc = this.timeFuncMcs[magIndex];
        String magLabel = ETAS_ComcatComparePlot.minMagLabel(mc);
        EvenlyDiscretizedFunc timeFunc = mc < 0.0 ? this.plotter.calcCumulativeTimeFunc(this.timeDepMc) : this.plotter.calcCumulativeTimeFunc(mc);
        double simStartX = (double)(this.startTime - this.plotter.getOriginTime()) / 3.15576E10;
        if (this.timeDays) {
            simStartX *= 365.25;
        }
        double simShiftY = timeFunc.getInterpolatedY(simStartX);
        Double minTime = null;
        if (this.timeDays) {
            if (simStartX > 60.0) {
                minTime = simStartX - 60.0;
            }
        } else if (simStartX > 0.16427104722792607) {
            minTime = simStartX - 0.16427104722792607;
        }
        XY_DataSetList functionList = new XY_DataSetList();
        ArrayList<Double> relativeWts = new ArrayList<Double>();
        for (EvenlyDiscretizedFunc[] func : this.catalogTimeFuncs) {
            EvenlyDiscretizedFunc myFunc = func[magIndex];
            if (simStartX != 0.0 || simShiftY != 0.0) {
                int minIndex = 0;
                for (int i = 0; i < myFunc.size() && myFunc.getX(i) < simStartX; ++i) {
                    ++minIndex;
                }
                EvenlyDiscretizedFunc shift = new EvenlyDiscretizedFunc(myFunc.getX(minIndex), myFunc.size() - minIndex, myFunc.getDelta());
                for (int i = 0; i < shift.size(); ++i) {
                    shift.set(i, myFunc.getY(i + minIndex) + simShiftY);
                }
                myFunc = shift;
            }
            functionList.add(myFunc);
            relativeWts.add(1.0);
        }
        FractileCurveCalculator timeFractals = new FractileCurveCalculator(functionList, relativeWts);
        this.plotter.plotTimeFuncPlot(outputDir, prefix, magLabel, timeFunc, minTime, timeFractals);
    }

    public static double invPercentile(double[] counts, double dataVal) {
        int index;
        Arrays.sort(counts);
        if (index < 0) {
            index = -(index + 1);
        } else {
            for (index = Arrays.binarySearch(counts, dataVal); index > 0 && (float)counts[index - 1] == (float)dataVal; --index) {
            }
        }
        double numBelow = index;
        return 100.0 * numBelow / (double)counts.length;
    }

    private void plotMagPercentileCumulativeNumPlot(File outputDir, String prefix, List<EvenlyDiscretizedFunc> cumulativeMNDs) throws IOException {
        ArrayList<AbstractXY_DataSet> funcs = new ArrayList<AbstractXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
        EvenlyDiscretizedFunc magFunc = cumulativeMNDs.get(0);
        ArbitrarilyDiscretizedFunc upper95 = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc lower95 = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc upper68 = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc lower68 = new ArbitrarilyDiscretizedFunc();
        ArbitrarilyDiscretizedFunc middle = new ArbitrarilyDiscretizedFunc();
        EvenlyDiscretizedFunc dataFunc = new EvenlyDiscretizedFunc(magFunc.getMinX(), magFunc.getMaxX(), magFunc.size());
        EvenlyDiscretizedFunc comcatCumulativeMND = this.plotter.calcIncrementalMagNum(this.comcatMinMag, false, false).getCumRateDistWithOffset();
        if ((float)comcatCumulativeMND.getMinX() != (float)magFunc.getMinX() || comcatCumulativeMND.size() != magFunc.size()) {
            EvenlyDiscretizedFunc comcatAligned = new EvenlyDiscretizedFunc(magFunc.getMinX(), magFunc.getMaxX(), magFunc.size());
            double minX = magFunc.getMinX() - 0.5 * magFunc.getDelta();
            double maxX = magFunc.getMaxX() + 0.5 * magFunc.getDelta();
            for (Point2D pt : comcatCumulativeMND) {
                if ((float)pt.getX() < (float)minX || (float)pt.getX() > (float)maxX) continue;
                comcatAligned.add(magFunc.getClosestXIndex(pt.getX()), pt.getY());
            }
            comcatCumulativeMND = comcatAligned;
        }
        for (int i = 0; i < magFunc.size(); ++i) {
            double mag = magFunc.getX(i);
            upper95.set(mag, 97.5);
            lower95.set(mag, 2.5);
            upper68.set(mag, 84.0);
            lower68.set(mag, 16.0);
            middle.set(mag, 50.0);
            double[] counts = new double[cumulativeMNDs.size()];
            for (int j = 0; j < counts.length; ++j) {
                counts[j] = cumulativeMNDs.get(j).getY(i);
            }
            Preconditions.checkState(((float)mag == (float)comcatCumulativeMND.getX(i) ? 1 : 0) != 0);
            double dataVal = comcatCumulativeMND.getY(i);
            double percentile = ETAS_ComcatComparePlot.invPercentile(counts, dataVal);
            dataFunc.set(i, percentile);
        }
        UncertainArbDiscFunc bounds95 = new UncertainArbDiscFunc(middle, lower95, upper95);
        bounds95.setName("95% Confidence");
        funcs.add(bounds95);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, new Color(0, 0, 0, 20)));
        UncertainArbDiscFunc bounds68 = new UncertainArbDiscFunc(middle, lower68, upper68);
        bounds68.setName("68% Confidence");
        funcs.add(bounds68);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SHADED_UNCERTAIN, 1.0f, new Color(0, 0, 0, 40)));
        double minY = 0.0;
        double maxY = 100.0;
        if ((float)this.comcatMc > (float)this.simMc) {
            DefaultXY_DataSet mcFunc = new DefaultXY_DataSet();
            mcFunc.set(this.comcatMc, minY);
            mcFunc.set(this.comcatMc, maxY);
            mcFunc.setName("Mc");
            funcs.add(mcFunc);
            chars.add(new PlotCurveCharacterstics(PlotLineType.DASHED, 1.0f, this.plotter.getDataColor()));
        }
        dataFunc.setName("ComCat Data Num\u2265M");
        funcs.add(dataFunc);
        chars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK));
        PlotSpec spec = new PlotSpec(funcs, chars, this.plotter.isNoTitles() ? " " : "Cumulative Count Data Percentile Comparison", "Minimum Magnitude", "Simulation Percentile");
        spec.setLegendVisible(true);
        HeadlessGraphPanel gp = ETAS_ComcatComparePlot.buildGraphPanel();
        gp.setLegendFontSize(18);
        gp.setUserBounds(this.simMc, comcatCumulativeMND.getMaxX(), minY, maxY);
        gp.drawGraphPanel(spec, false, false);
        gp.getChartPanel().setSize(800, 600);
        gp.saveAsPNG(new File(outputDir, prefix + ".png").getAbsolutePath());
        gp.saveAsPDF(new File(outputDir, prefix + ".pdf").getAbsolutePath());
    }

    private void calcMagTimeProbs() {
        int i;
        double scalar = 1.0 / (double)this.catalogsProcessed;
        for (double[] column : this.magTimeProbsFull) {
            i = 0;
            while (i < column.length) {
                int n = i++;
                column[n] = column[n] * scalar;
            }
        }
        if (this.magTimeProbsWeek != null) {
            for (double[] column : this.magTimeProbsWeek) {
                i = 0;
                while (i < column.length) {
                    int n = i++;
                    column[n] = column[n] * scalar;
                }
            }
        }
        if (this.magTimeProbsMonth != null) {
            for (double[] column : this.magTimeProbsMonth) {
                i = 0;
                while (i < column.length) {
                    int n = i++;
                    column[n] = column[n] * scalar;
                }
            }
        }
    }

    private void plotMagTimeFunc(double[][] magTimeProbs, EvenlyDiscretizedFunc magTimeXAxis, String title, File outputDir, String prefix) throws IOException {
        double timeOffset = (double)(this.startTime - this.plotter.getOriginTime()) / 3.15576E10;
        if (this.timeDays) {
            timeOffset *= 365.25;
        }
        EvenlyDiscrXYZ_DataSet xyz = new EvenlyDiscrXYZ_DataSet(magTimeXAxis.size(), this.magTimeYAxis.size(), timeOffset + magTimeXAxis.getMinX(), this.magTimeYAxis.getMinX(), magTimeXAxis.getDelta(), this.magTimeYAxis.getDelta());
        for (int x = 0; x < magTimeProbs.length; ++x) {
            for (int y = 0; y < magTimeProbs[x].length; ++y) {
                xyz.set(x, y, magTimeProbs[x][y]);
            }
        }
        Double minTime = null;
        double xyzMinTime = xyz.getMinX() - 0.5 * xyz.getGridSpacingX();
        if (this.timeDays) {
            if (xyzMinTime > 60.0) {
                minTime = xyzMinTime - 60.0;
            }
        } else if (xyzMinTime > 0.16427104722792607) {
            minTime = xyzMinTime - 0.16427104722792607;
        }
        this.plotter.plotMagTimeFunc(outputDir, prefix, title, minTime, xyz.getMaxX() + 0.5 * xyz.getGridSpacingX(), xyz);
    }

    private void calcMapData() {
        double scalar = 1.0 / (double)this.catalogsProcessed;
        for (int d = 0; d < this.durations.length; ++d) {
            int m = 0;
            while (m < this.magBins.length) {
                int n = 0;
                while (n < this.gridRegion.getNodeCount()) {
                    double[] dArray = this.catalogProbs[d][m];
                    int n2 = n;
                    dArray[n2] = dArray[n2] * scalar;
                    double[] dArray2 = this.catalogMeans[d][m];
                    int n3 = n++;
                    dArray2[n3] = dArray2[n3] * scalar;
                }
                double[] dArray = this.catalogProbsSummary[d];
                int n4 = m;
                dArray[n4] = dArray[n4] * scalar;
                double[] dArray3 = this.catalogMeansSummary[d];
                int n5 = m++;
                dArray3[n5] = dArray3[n5] * scalar;
            }
        }
    }

    public void setMapMinZ(double minZ) {
        this.minZ = minZ;
    }

    public void setMapCPT(CPT cpt) {
        this.baseCPT = cpt;
    }

    public void setMapDataColor(Color color) {
        this.mapDataColor = color;
    }

    private String[][] writeMapPlots(File outputDir, String prefix, String zName, double[][][] data, boolean isProb, FaultSystemRupSet rupSet, List<Runnable> mapRunnables) throws IOException {
        CPT cpt = this.baseCPT;
        cpt.setBelowMinColor(Color.WHITE);
        cpt.setNanColor(Color.WHITE);
        double minZ = this.minZ == null ? 1.0 / (double)this.catalogsProcessed : this.minZ;
        ArrayList<XY_DataSet> faultFuncs = new ArrayList<XY_DataSet>();
        ArrayList<PlotCurveCharacterstics> faultChars = new ArrayList<PlotCurveCharacterstics>();
        for (XY_DataSet xY_DataSet : PoliticalBoundariesData.loadCAOutlines()) {
            faultFuncs.add(xY_DataSet);
            faultChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
        }
        PlotCurveCharacterstics outlineChar = new PlotCurveCharacterstics(PlotLineType.DOTTED, 1.0f, Color.GRAY);
        PlotCurveCharacterstics traceChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GRAY);
        for (FaultSection faultSection : rupSet.getFaultSectionDataList()) {
            RuptureSurface surf = faultSection.getFaultSurface(1.0, false, false);
            for (XY_DataSet xy : ETAS_EventMapPlotUtils.getSurfOutlines(surf)) {
                faultFuncs.add(xy);
                faultChars.add(outlineChar);
            }
            for (XY_DataSet xy : ETAS_EventMapPlotUtils.getSurfTraces(surf)) {
                faultFuncs.add(xy);
                faultChars.add(traceChar);
            }
        }
        double latSpan = this.mapRegion.getMaxLat() - this.mapRegion.getMinLat();
        double lonSpan = this.mapRegion.getMaxLon() - this.mapRegion.getMinLon();
        double tickUnit = lonSpan > 5.0 ? 1.0 : (lonSpan > 2.0 ? 0.5 : (lonSpan > 1.0 ? 0.25 : 0.1));
        String[][] prefixes = new String[this.durations.length][this.magBins.length];
        for (int d = 0; d < this.durations.length; ++d) {
            String durPrefix = (float)this.durations[d] == (float)this.curDuration ? "current" : ETAS_ComcatComparePlot.getTimeShortLabel(this.durations[d]).replace(" ", "");
            for (int m = 0; m < this.magBins.length; ++m) {
                if (!this.shouldIncludeMinMag(this.magBins[m])) continue;
                String myPrefix = prefix + "_" + durPrefix + "_" + ETAS_ComcatComparePlot.minMagPrefix(this.magBins[m]);
                prefixes[d][m] = myPrefix;
                GriddedGeoDataSet xyz = new GriddedGeoDataSet(this.gridRegion, false);
                for (int i = 0; i < data[d][m].length; ++i) {
                    xyz.set(i, data[d][m][i]);
                }
                ArrayList<ObsEqkRupture> catalogEvents = new ArrayList<ObsEqkRupture>();
                String title = ETAS_ComcatComparePlot.getTimeLabel(this.durations[d], false) + " " + ETAS_ComcatComparePlot.minMagLabel(this.magBins[m]);
                if (this.maxOTs[d] <= this.curTime) {
                    ObsEqkRupList comcatEvents = this.magBins[m] < 0.0 ? this.timeDepMc.getFiltered(this.comcatEvents) : this.comcatEvents;
                    for (ObsEqkRupture rup : comcatEvents) {
                        if (!(rup.getMag() >= this.magBins[m]) || rup.getOriginTime() > this.maxOTs[d]) continue;
                        catalogEvents.add(rup);
                    }
                    this.comcatCountsSummary[d][m] = catalogEvents.size();
                    title = title + " Comparison";
                } else {
                    title = title + " Forecast";
                }
                String zLabel = zName + " " + ETAS_ComcatComparePlot.minMagLabel(this.magBins[m]) + ", " + ETAS_ComcatComparePlot.getTimeLabel(this.durations[d], false);
                mapRunnables.add(new MapRunnable(outputDir, zLabel, cpt, minZ, isProb, faultFuncs, faultChars, latSpan, lonSpan, tickUnit, myPrefix, xyz, catalogEvents, title));
            }
        }
        return prefixes;
    }

    private XY_DataSet getDepthXY(EvenlyDiscretizedFunc func) {
        double numRups = func.calcSumOfY_Vals();
        DefaultXY_DataSet xy = new DefaultXY_DataSet();
        if (numRups == 0.0) {
            xy.set(0.0, 0.0);
            xy.set(0.0, func.getMaxX() + 0.5 * func.getDelta());
        } else {
            for (int i = 0; i < func.size(); ++i) {
                double middle = func.getX(i);
                double top = middle - 0.5 * func.getDelta();
                double bottom = middle + 0.5 * func.getDelta();
                double num = func.getY(i) / numRups;
                xy.set(num, top);
                xy.set(num, bottom);
            }
        }
        return xy;
    }

    private void writeDepthPlots(File outputDir, String prefix) throws IOException {
        for (int m = 0; m < this.magBins.length; ++m) {
            if (!this.shouldIncludeMinMag(this.magBins[m])) continue;
            String myPrefix = prefix + "_" + ETAS_ComcatComparePlot.minMagPrefix(this.magBins[m]);
            EvenlyDiscretizedFunc catalogFunc = this.catalogDepthDistributions[m];
            catalogFunc.scale(1.0 / (double)this.catalogsProcessed);
            this.plotter.plotMagDepthPlot(outputDir, myPrefix, this.magBins[m] > 0.0 ? null : this.timeDepMc, this.magBins[m], catalogFunc);
        }
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        Iterator mag;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add(topLevelHeading + " ComCat Data Comparisons");
        lines.add(topLink);
        lines.add("");
        lines.add("These plots compare simulated sequences with data from ComCat. All plots only consider events with hypocenters inside the ComCat region defined in the JSON input file.");
        lines.add("");
        Object line = "Last updated at " + SimulationMarkdownGenerator.df.format(new Date(this.curTime)) + ", " + ETAS_ComcatComparePlot.getTimeLabel(this.curDuration, true).toLowerCase() + " after the simulation start time";
        if (this.plotter.getMainshock() != null && this.startTime - this.plotter.getOriginTime() > 1000L) {
            double msDuration = this.curDuration + (double)(this.startTime - this.plotter.getOriginTime()) / 3.15576E10;
            line = (String)line + " and " + ETAS_ComcatComparePlot.getTimeLabel(msDuration, true).toLowerCase() + " after the mainshock";
        }
        line = (String)line + ".";
        lines.add((String)line);
        lines.add("");
        lines.add("Total matching ComCat events found: " + this.comcatEvents.size());
        lines.add("");
        lines.add(topLevelHeading + "# ComCat Magnitude-Number Distributions");
        lines.add(topLink);
        lines.add("");
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.addLine("Incremental MND", "Cumulative MND");
        table.addLine("![Incremental MND](" + relativePathToOutputDir + "/comcat_compare_mag_num.png)", "![Cumi MND](" + relativePathToOutputDir + "/comcat_compare_mag_num_cumulative.png)");
        lines.addAll(table.build());
        lines.add("");
        lines.add(topLevelHeading + "# ComCat Magnitude-Time Functions");
        lines.add(topLink);
        lines.add("");
        line = "These plots show the show the magnitude versus time probability function since simulation start. Observed event data lie on top, with those input to the simulation plotted as magenta circles and those that occurred after the simulation start time as cyan circles. Time is relative to ";
        if (this.plotter.getMainshock() == null) {
            line = (String)line + "the simulation start time.";
        } else {
            ObsEqkRupture mainshock = this.plotter.getMainshock();
            mag = mainshock.getMag();
            line = (String)line + "the mainshock (M" + optionalDigitDF.format(mag) + ", " + mainshock.getEventId() + ", plotted as a brown circle).";
        }
        line = (String)line + " Probabilities are only shown above the minimum simulated magnitude, M=" + optionalDigitDF.format(this.simMc) + ".";
        lines.add((String)line);
        table = MarkdownUtils.tableBuilder();
        if (this.magTimeProbsWeek != null) {
            table.addLine("![One Week](" + relativePathToOutputDir + "/mag_time_week.png)");
        }
        if (this.magTimeProbsMonth != null) {
            table.addLine("![One Month](" + relativePathToOutputDir + "/mag_time_month.png)");
        }
        if (!this.forecastOnly) {
            table.addLine("![Full Mag/Time](" + relativePathToOutputDir + "/mag_time_full.png)");
        }
        lines.add("");
        lines.addAll(table.build());
        lines.add("");
        if (this.shouldIncludeMinMag(-1.0)) {
            lines.add(topLevelHeading + "# ComCat Time-Dependent Mc");
            lines.add(topLink);
            lines.add("");
            lines.add("The following plots compare simulation results with ComCat data above a magnitude threshold. Plots labeled as *M&ge;Mc(t)* use the time-dependent magnitude of completeness (Mc) defined in Helmstetter et al. (2006), which is plotted below. In the case of multiple M&ge;" + optionalDigitDF.format(MAX_MAG_FOR_TD_MC) + " ruptures, either as input to the simulation or in the comparison data, the maximum calculated time-dependent Mc is used. This time-dependent Mc function is plotted below.");
            lines.add("");
            lines.add("![TD MC](" + relativePathToOutputDir + "/comcat_compare_td_mc.png)");
            lines.add("");
        }
        if (!this.forecastOnly) {
            ArrayList<Double> timeFuncMags = new ArrayList<Double>();
            for (Object mag2 : (Iterator)this.timeFuncMcs) {
                if (!this.shouldIncludeMinMag((double)mag2)) continue;
                timeFuncMags.add((double)mag2);
            }
            if (!timeFuncMags.isEmpty()) {
                lines.add(topLevelHeading + "# ComCat Cumulative Number Vs Time");
                lines.add(topLink);
                lines.add("");
                table = MarkdownUtils.tableBuilder();
                table.initNewLine();
                mag = timeFuncMags.iterator();
                while (mag.hasNext()) {
                    double mag3 = (Double)mag.next();
                    table.addColumn(ETAS_ComcatComparePlot.minMagLabel(mag3).replaceAll("\u2265", "&ge;"));
                }
                table.finalizeLine();
                table.initNewLine();
                mag = timeFuncMags.iterator();
                while (mag.hasNext()) {
                    double mag4 = (Double)mag.next();
                    table.addColumn("![MND](" + relativePathToOutputDir + "/comcat_compare_cumulative_num_" + ETAS_ComcatComparePlot.minMagPrefix(mag4) + ".png)");
                }
                table.finalizeLine();
                lines.addAll(table.build());
                lines.add("");
            }
            lines.add(topLevelHeading + "# ComCat Cumulative Number Simulation Percentiles");
            lines.add(topLink);
            lines.add("");
            lines.add("![MND](" + relativePathToOutputDir + "/comcat_compare_cumulative_num_percentile.png)");
            lines.add("");
        }
        String mapForecastLine = null;
        if (this.curTime < this.maxOTs[this.maxOTs.length - 1]) {
            mapForecastLine = "*Note: maps labeled 'Forecast' are for a duration that extends into the future, only forecasted values are plotted (ComCat data omitted)*";
        }
        lines.add(topLevelHeading + "# ComCat Probability Spatial Distribution");
        lines.add(topLink);
        lines.add("");
        if (mapForecastLine != null) {
            lines.add(mapForecastLine);
            lines.add("");
        }
        lines.addAll(this.mapPlotTable(relativePathToOutputDir, this.mapProbPrefixes, this.catalogProbsSummary, true).build());
        lines.add("");
        lines.add(topLevelHeading + "# ComCat Mean Expectation Spatial Distribution");
        lines.add(topLink);
        lines.add("");
        if (mapForecastLine != null) {
            lines.add(mapForecastLine);
            lines.add("");
        }
        lines.addAll(this.mapPlotTable(relativePathToOutputDir, this.mapMeanPrefixes, this.catalogMeansSummary, false).build());
        lines.add("");
        ArrayList<Double> depthMags = new ArrayList<Double>();
        for (double mag5 : this.magBins) {
            if (!this.shouldIncludeMinMag(mag5)) continue;
            depthMags.add(mag5);
        }
        if (!depthMags.isEmpty()) {
            lines.add(topLevelHeading + "# ComCat Depth Distribution");
            lines.add(topLink);
            lines.add("");
            table = MarkdownUtils.tableBuilder();
            table.initNewLine();
            Object object = depthMags.iterator();
            while (object.hasNext()) {
                double mag6 = (Double)object.next();
                table.addColumn(ETAS_ComcatComparePlot.minMagLabel(mag6).replaceAll("\u2265", "&ge;"));
            }
            table.finalizeLine();
            table.initNewLine();
            object = depthMags.iterator();
            while (object.hasNext()) {
                double mag7 = (Double)object.next();
                table.addColumn("![Depth Distribution](" + relativePathToOutputDir + "/comcat_compare_depth_" + ETAS_ComcatComparePlot.minMagPrefix(mag7) + ".png)");
            }
            table.finalizeLine();
            lines.addAll(table.build());
        }
        return lines;
    }

    public String getMapTableLabel(double duration) {
        if ((float)duration == (float)this.curDuration) {
            return "Current (" + ETAS_ComcatComparePlot.getTimeLabel(duration, false) + ")";
        }
        if ((float)duration > (float)this.curDuration) {
            return "Forecast: " + ETAS_ComcatComparePlot.getTimeLabel(duration, false);
        }
        return ETAS_ComcatComparePlot.getTimeLabel(duration, false);
    }

    private MarkdownUtils.TableBuilder mapPlotTable(String relativePathToOutputDir, String[][] prefixes, double[][] valueSummaries, boolean prob) {
        MarkdownUtils.TableBuilder table = MarkdownUtils.tableBuilder();
        table.initNewLine();
        table.addColumn("");
        for (double duration : this.durations) {
            table.addColumn(this.getMapTableLabel(duration));
        }
        table.finalizeLine();
        for (int m = 0; m < this.magBins.length; ++m) {
            int d;
            if (!this.shouldIncludeMinMag(this.magBins[m])) continue;
            table.initNewLine();
            table.addColumn("**" + ETAS_ComcatComparePlot.minMagLabel(this.magBins[m]).replaceAll("\u2265", "&ge;") + "**");
            for (d = 0; d < this.durations.length; ++d) {
                table.addColumn("![Map](" + relativePathToOutputDir + "/" + prefixes[d][m] + ".png)");
            }
            table.finalizeLine();
            if (valueSummaries == null) continue;
            table.initNewLine();
            table.addColumn("");
            for (d = 0; d < this.durations.length; ++d) {
                String col = prob ? "Prob: " + percentProbDF.format(valueSummaries[d][m]) : "Mean: " + ETAS_ComcatComparePlot.getProbStr(valueSummaries[d][m]);
                if ((float)this.durations[d] <= (float)this.curDuration) {
                    col = col + ", Actual: " + this.comcatCountsSummary[d][m];
                }
                table.addColumn(col);
            }
            table.finalizeLine();
        }
        return table;
    }

    public static void main(String[] args) {
        File simDir = new File("/home/kevin/OpenSHA/UCERF3/etas/simulations/2020_04_08-ComCatM4p87_ci39126079_4p7DaysAfter_PointSources_kCOV1p5");
        File configFile = new File(simDir, "config.json");
        try {
            ETAS_Config config = ETAS_Config.readJSON(configFile);
            ETAS_Launcher launcher = new ETAS_Launcher(config, false);
            int maxNumCatalogs = 0;
            ETAS_ComcatComparePlot plot = new ETAS_ComcatComparePlot(config, launcher);
            File outputDir = new File(simDir, "plots");
            Preconditions.checkState((outputDir.exists() || outputDir.mkdir() ? 1 : 0) != 0);
            FaultSystemSolution fss = launcher.checkOutFSS();
            File inputFile = SimulationMarkdownGenerator.locateInputFile(config);
            int processed = 0;
            for (ETAS_CatalogIO.ETAS_Catalog catalog : ETAS_CatalogIO.getBinaryCatalogsIterable(inputFile, 0.0)) {
                if (processed % 1000 == 0) {
                    System.out.println("Catalog " + processed);
                }
                plot.processCatalog(catalog, fss);
                if (maxNumCatalogs <= 0 || ++processed != maxNumCatalogs) continue;
                break;
            }
            plot.finalize(outputDir, launcher.checkOutFSS());
            List<String> lines = ((ETAS_AbstractPlot)plot).generateMarkdown(outputDir.getName(), "##", "*(top)*");
            MarkdownUtils.writeReadmeAndHTML(lines, simDir);
            System.exit(0);
        }
        catch (Throwable e) {
            e.printStackTrace();
            System.exit(1);
        }
    }

    private class TimeFuncPlotRunnable
    implements Runnable {
        private final File outputDir;
        private final String prefix;
        private final int magIndex;

        public TimeFuncPlotRunnable(File outputDir, String prefix, int magIndex) {
            this.outputDir = outputDir;
            this.prefix = prefix;
            this.magIndex = magIndex;
        }

        @Override
        public void run() {
            try {
                ETAS_ComcatComparePlot.this.plotTimeFuncPlot(this.outputDir, this.prefix, this.magIndex);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
    }

    private class MapRunnable
    implements Runnable {
        private File outputDir;
        private String zLabel;
        private CPT cpt;
        private double minZ;
        private boolean isProb;
        private List<XY_DataSet> faultFuncs;
        private List<PlotCurveCharacterstics> faultChars;
        private double latSpan;
        private double lonSpan;
        private double tickUnit;
        private String myPrefix;
        private GriddedGeoDataSet xyz;
        private List<ObsEqkRupture> catalogEvents;
        private String title;

        public MapRunnable(File outputDir, String zLabel, CPT cpt, double minZ, boolean isProb, List<XY_DataSet> faultFuncs, List<PlotCurveCharacterstics> faultChars, double latSpan, double lonSpan, double tickUnit, String myPrefix, GriddedGeoDataSet xyz, List<ObsEqkRupture> catalogEvents, String title) {
            this.outputDir = outputDir;
            this.zLabel = zLabel;
            this.cpt = cpt;
            this.minZ = minZ;
            this.isProb = isProb;
            this.faultFuncs = faultFuncs;
            this.faultChars = faultChars;
            this.latSpan = latSpan;
            this.lonSpan = lonSpan;
            this.tickUnit = tickUnit;
            this.myPrefix = myPrefix;
            this.xyz = xyz;
            this.catalogEvents = catalogEvents;
            this.title = title;
        }

        @Override
        public void run() {
            try {
                double maxLogZ;
                ArrayList<XY_DataSet> funcs = new ArrayList<XY_DataSet>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                ETAS_EventMapPlotUtils.buildEventPlot(this.catalogEvents, funcs, chars, ETAS_ComcatComparePlot.this.comcatMaxMag);
                for (PlotCurveCharacterstics pChar : chars) {
                    pChar.setColor(ETAS_ComcatComparePlot.this.mapDataColor);
                }
                funcs.addAll(0, this.faultFuncs);
                chars.addAll(0, this.faultChars);
                double minLogZ = Math.floor(Math.log10(this.minZ));
                if (this.isProb) {
                    maxLogZ = 0.0;
                } else {
                    double maxZ = this.xyz.getMaxZ();
                    if (maxZ == 0.0) {
                        maxZ = 1.0;
                    }
                    maxLogZ = Math.ceil(Math.log10(maxZ));
                }
                while (maxLogZ <= minLogZ) {
                    maxLogZ += 1.0;
                }
                CPT myCPT = this.cpt.rescale(minLogZ, maxLogZ);
                int num = (int)Math.round((myCPT.getMaxValue() - myCPT.getMinValue()) * 4.0);
                myCPT = myCPT.asDiscrete(num, true);
                this.xyz.log10();
                XYZPlotSpec spec = new XYZPlotSpec(this.xyz, myCPT, ETAS_ComcatComparePlot.this.plotter.isNoTitles() ? " " : this.title, "Longitude", "Latitude", "Log10 " + this.zLabel);
                spec.setXYElems(funcs);
                spec.setXYChars(chars);
                spec.setCPTPosition(RectangleEdge.BOTTOM);
                HeadlessGraphPanel gp = ETAS_AbstractPlot.buildGraphPanel();
                int width = 800;
                TickUnits tus = new TickUnits();
                NumberTickUnit tu = new NumberTickUnit(this.tickUnit);
                tus.add((TickUnit)tu);
                gp.drawGraphPanel(spec, false, false, new Range(ETAS_ComcatComparePlot.this.mapRegion.getMinLon(), ETAS_ComcatComparePlot.this.mapRegion.getMaxLon()), new Range(ETAS_ComcatComparePlot.this.mapRegion.getMinLat(), ETAS_ComcatComparePlot.this.mapRegion.getMaxLat()));
                gp.getYAxis().setStandardTickUnits((TickUnitSource)tus);
                gp.getXAxis().setStandardTickUnits((TickUnitSource)tus);
                gp.getChartPanel().setSize(width, (int)((double)width * this.latSpan / this.lonSpan));
                gp.saveAsPNG(new File(this.outputDir, this.myPrefix + ".png").getAbsolutePath());
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
    }
}

