/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.analysis;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.primitives.Doubles;
import java.awt.Color;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Random;
import java.util.concurrent.ExecutorService;
import org.jfree.chart.plot.DatasetRenderingOrder;
import org.jfree.data.Range;
import org.opensha.commons.calc.FractileCurveCalculator;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.XY_DataSet;
import org.opensha.commons.data.function.XY_DataSetList;
import org.opensha.commons.gui.plot.HeadlessGraphPanel;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSpec;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_MFD_Plot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;

public class ETAS_LongTermRateVariabilityPlot
extends ETAS_AbstractPlot {
    private static double[] FIXED_DURATIONS_DEFAULT = new double[]{162.0, 80.0, 28.0};
    private static boolean OVERLAP = false;
    private static double[] fractiles = new double[]{0.025, 0.16, 0.84, 0.975};
    private static int target_sim_mfds_per_duration = 50;
    private DiscretizedFunc durationFunc;
    private Map<Double, List<IncrementalMagFreqDist>> durMFDsListMap;
    private HistogramFunction totalCountHist;
    private String prefix;
    private double[] fixedDurations;
    private List<CSVFile<String>> fixedDurCSVs;
    private List<String> fixedDurPrefixes;
    private double[] durMinMags;
    private List<CSVFile<String>> durCSVs;
    private List<String> durPrefixes;
    private Random r;

    protected ETAS_LongTermRateVariabilityPlot(ETAS_Config config, ETAS_Launcher launcher, String prefix) {
        this(config, launcher, prefix, FIXED_DURATIONS_DEFAULT);
    }

    protected ETAS_LongTermRateVariabilityPlot(ETAS_Config config, ETAS_Launcher launcher, String prefix, double[] fixedDurations) {
        super(config, launcher);
        this.prefix = prefix;
        if (fixedDurations != null) {
            ArrayList<Double> myDurs = new ArrayList<Double>();
            for (double duration : fixedDurations) {
                if (!(config.getDuration() >= duration)) continue;
                myDurs.add(duration);
            }
            fixedDurations = myDurs.isEmpty() ? null : Doubles.toArray(myDurs);
        }
        this.fixedDurations = fixedDurations;
        Preconditions.checkState((boolean)config.isIncludeSpontaneous(), (Object)"Long term variability requires spontaneous ruptures");
        double totDuration = config.getDuration();
        this.r = new Random((long)(totDuration * (double)config.getNumSimulations()));
        double evenMaxDuration = Math.min(100.0, totDuration);
        int targetNumDurations = totDuration > 100.0 ? 25 : 50;
        int myDelta = 1;
        while (evenMaxDuration / (double)myDelta > (double)targetNumDurations) {
            ++myDelta;
        }
        EvenlyDiscretizedFunc evenDurFunc = new EvenlyDiscretizedFunc((double)myDelta, (int)(evenMaxDuration / (double)myDelta), (double)myDelta);
        if (myDelta > 1) {
            this.durationFunc = new ArbitrarilyDiscretizedFunc();
            this.durationFunc.set(1.0, 0.0);
            for (Point2D pt : evenDurFunc) {
                this.durationFunc.set(pt);
            }
        } else {
            this.durationFunc = evenDurFunc;
        }
        if (totDuration > evenMaxDuration) {
            myDelta = totDuration >= 500.0 ? 100 : (totDuration >= 250.0 ? 50 : 20);
            evenDurFunc = new EvenlyDiscretizedFunc(evenMaxDuration + (double)myDelta, (int)(totDuration / (double)myDelta), (double)myDelta);
            for (Point2D pt : evenDurFunc) {
                if (!(pt.getX() <= totDuration)) continue;
                this.durationFunc.set(pt);
            }
        }
        Preconditions.checkState(((float)this.durationFunc.getMaxX() <= (float)totDuration ? 1 : 0) != 0);
        System.out.println("Calculating long term variability with " + this.durationFunc.size() + " durations");
        this.durMFDsListMap = new HashMap<Double, List<IncrementalMagFreqDist>>();
        for (Point2D pt : this.durationFunc) {
            this.durMFDsListMap.put(pt.getX(), new ArrayList());
        }
        if (fixedDurations != null) {
            for (Object duration : (Object)fixedDurations) {
                if (!(duration <= config.getDuration())) continue;
                this.durMFDsListMap.put((double)duration, new ArrayList());
            }
        }
        this.totalCountHist = new HistogramFunction(ETAS_MFD_Plot.mfdMinMag, ETAS_MFD_Plot.mfdNumMag, ETAS_MFD_Plot.mfdDelta);
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public boolean isFilterSpontaneous() {
        return false;
    }

    @Override
    protected void doProcessCatalog(ETAS_CatalogIO.ETAS_Catalog completeCatalog, ETAS_CatalogIO.ETAS_Catalog triggeredOnlyCatalog, FaultSystemSolution fss) {
        long simStartTime = this.getConfig().getSimulationStartTimeMillis();
        double simDuration = this.getConfig().getDuration();
        long simEndTime = simStartTime + (long)(simDuration * 3.15576E10) + 1000L;
        for (double duration : this.durMFDsListMap.keySet()) {
            long sweepStartTime;
            long sweepDeltaMillis;
            List<IncrementalMagFreqDist> mfdList = this.durMFDsListMap.get(duration);
            long durationMillis = (long)(duration * 3.15576E10);
            if (OVERLAP) {
                double maxSweeps = simDuration - duration;
                double sweepDeltaYears = 1.0;
                if (maxSweeps > (double)target_sim_mfds_per_duration) {
                    sweepDeltaYears = Math.min(duration, maxSweeps / (double)target_sim_mfds_per_duration);
                }
                sweepDeltaMillis = (long)(sweepDeltaYears * 3.15576E10);
                sweepStartTime = simStartTime;
            } else {
                sweepDeltaMillis = durationMillis;
                long durMod = durationMillis % sweepDeltaMillis;
                sweepStartTime = durMod > 1L ? simStartTime + Math.round(this.r.nextDouble() * (double)durMod) : simStartTime;
            }
            int numProcessed = 0;
            long startTime = sweepStartTime;
            while (startTime + durationMillis <= simEndTime) {
                long endTime = startTime + durationMillis;
                mfdList.add(this.calcSubMFD(completeCatalog, startTime, endTime));
                ++numProcessed;
                startTime += sweepDeltaMillis;
            }
            Preconditions.checkState((numProcessed > 0 ? 1 : 0) != 0, (String)"Sub-duration of %s is too long for simulation?", (Object)duration);
        }
        for (ETAS_EqkRupture rup : completeCatalog) {
            this.totalCountHist.add(this.totalCountHist.getClosestXIndex(rup.getMag()), 1.0);
        }
    }

    private IncrementalMagFreqDist calcSubMFD(List<ETAS_EqkRupture> catalog, long startTime, long endTime) {
        IncrementalMagFreqDist mfd = new IncrementalMagFreqDist(ETAS_MFD_Plot.mfdMinMag, ETAS_MFD_Plot.mfdNumMag, ETAS_MFD_Plot.mfdDelta);
        for (ETAS_EqkRupture rup : catalog) {
            if (rup.getOriginTime() < startTime) continue;
            if (rup.getOriginTime() >= endTime) break;
            int index = mfd.getClosestXIndex(rup.getMag());
            mfd.add(index, 1.0);
        }
        return mfd;
    }

    @Override
    protected List<? extends Runnable> doFinalize(File outputDir, FaultSystemSolution fss, ExecutorService exec) throws IOException {
        int numToTrim = ETAS_MFD_Plot.calcNumToTrim(this.totalCountHist);
        HashMap<Double, MFD_VarStats> durStatsMap = new HashMap<Double, MFD_VarStats>();
        Double myMinMag = null;
        for (Double d : this.durMFDsListMap.keySet()) {
            List<IncrementalMagFreqDist> mfds = this.durMFDsListMap.get(d);
            Preconditions.checkState((!mfds.isEmpty() ? 1 : 0) != 0);
            MFD_VarStats stats = new MFD_VarStats(mfds, numToTrim, d);
            durStatsMap.put(d, stats);
            if (myMinMag != null) continue;
            myMinMag = stats.meanFunc.getMinX();
        }
        ArrayList<Object> commonHeader = new ArrayList<Object>();
        commonHeader.add("Mean");
        commonHeader.add("Median");
        commonHeader.add("Mode");
        commonHeader.add("Std. Dev.");
        for (double fractile : fractiles) {
            commonHeader.add(optionalDigitDF.format(fractile * 100.0) + " %-ile");
        }
        PlotCurveCharacterstics plotCurveCharacterstics = new PlotCurveCharacterstics(PlotLineType.SOLID, 4.0f, Color.BLACK);
        PlotCurveCharacterstics fractileChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK);
        PlotCurveCharacterstics medianChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE);
        PlotCurveCharacterstics modeChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.CYAN.darker());
        PlotCurveCharacterstics stdDevChar = new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.GREEN.darker());
        if (this.fixedDurations != null && this.fixedDurations.length > 0) {
            this.fixedDurPrefixes = new ArrayList<String>();
            this.fixedDurCSVs = new ArrayList<CSVFile<String>>();
            for (int i = 0; i < this.fixedDurations.length; ++i) {
                double duration = this.fixedDurations[i];
                MFD_VarStats stats = (MFD_VarStats)durStatsMap.get(duration);
                CSVFile durCSV = new CSVFile(true);
                this.fixedDurCSVs.add(durCSV);
                ArrayList<String> header = new ArrayList<String>(commonHeader);
                header.add(0, "Magnitude");
                durCSV.addLine(header);
                for (int m = 0; m < stats.meanFunc.size(); ++m) {
                    durCSV.addLine(stats.getCSVLine(m, "" + (float)stats.meanFunc.getX(m)));
                }
                String myPrefix = this.prefix + "_" + optionalDigitDF.format(duration) + "yr";
                this.fixedDurPrefixes.add(myPrefix);
                durCSV.writeToFile(new File(outputDir, myPrefix + ".csv"));
                ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
                ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
                stats.meanFunc.setName("Mean");
                funcs.add(stats.meanFunc);
                chars.add(plotCurveCharacterstics);
                EvenlyDiscretizedFunc[] fractileFuncs = stats.fractileFuncs;
                for (int j = 0; j < fractileFuncs.length; ++j) {
                    EvenlyDiscretizedFunc func = fractileFuncs[j];
                    if (j == 0) {
                        func.setName(ETAS_LongTermRateVariabilityPlot.getFractilesString());
                    }
                    funcs.add(func);
                    chars.add(fractileChar);
                }
                stats.medianFunc.setName("Median");
                funcs.add(stats.medianFunc);
                chars.add(medianChar);
                stats.modeFunc.setName("Mode");
                funcs.add(stats.modeFunc);
                chars.add(modeChar);
                stats.stdDevFunc.setName("Std. Dev.");
                funcs.add(stats.stdDevFunc);
                chars.add(stdDevChar);
                String yAxisLabel = "Cumulative Annual Rate (1/yr)";
                String title = ETAS_LongTermRateVariabilityPlot.getTimeLabel(duration, false) + " MFD Variability";
                PlotSpec spec = new PlotSpec(funcs, chars, title, "Magnitude", yAxisLabel);
                spec.setLegendVisible(true);
                Range xRange = new Range(stats.meanFunc.getMinX(), stats.meanFunc.getMaxX());
                Range yRange = ETAS_LongTermRateVariabilityPlot.getYRange(stats.meanFunc, stats.stdDevFunc);
                HeadlessGraphPanel gp = ETAS_LongTermRateVariabilityPlot.buildGraphPanel();
                gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
                gp.drawGraphPanel(spec, false, true, xRange, yRange);
                gp.getChartPanel().setSize(800, 600);
                gp.saveAsPNG(new File(outputDir, myPrefix + ".png").getAbsolutePath());
                gp.saveAsPDF(new File(outputDir, myPrefix + ".pdf").getAbsolutePath());
                gp.saveAsTXT(new File(outputDir, myPrefix + ".txt").getAbsolutePath());
            }
        }
        this.durMinMags = myMinMag < 5.0 ? new double[]{myMinMag, 5.0} : new double[]{myMinMag};
        this.durCSVs = new ArrayList<CSVFile<String>>();
        this.durPrefixes = new ArrayList<String>();
        for (double durMag : this.durMinMags) {
            ArbitrarilyDiscretizedFunc meanFunc = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc[] fractileFuncs = new ArbitrarilyDiscretizedFunc[fractiles.length];
            for (int i = 0; i < fractileFuncs.length; ++i) {
                fractileFuncs[i] = new ArbitrarilyDiscretizedFunc();
            }
            ArbitrarilyDiscretizedFunc medianFunc = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc modeFunc = new ArbitrarilyDiscretizedFunc();
            ArbitrarilyDiscretizedFunc stdDevFunc = new ArbitrarilyDiscretizedFunc();
            CSVFile csv = new CSVFile(true);
            ArrayList<String> header = new ArrayList<String>(commonHeader);
            header.add(0, "Duration (years)");
            csv.addLine(header);
            for (int i = 0; i < this.durationFunc.size(); ++i) {
                double duration = this.durationFunc.getX(i);
                MFD_VarStats stats = (MFD_VarStats)durStatsMap.get(duration);
                int magIndex = stats.meanFunc.getClosestXIndex(durMag);
                meanFunc.set(duration, stats.meanFunc.getY(magIndex));
                for (int f = 0; f < fractileFuncs.length; ++f) {
                    fractileFuncs[f].set(duration, stats.fractileFuncs[f].getY(magIndex));
                }
                medianFunc.set(duration, stats.medianFunc.getY(magIndex));
                modeFunc.set(duration, stats.modeFunc.getY(magIndex));
                stdDevFunc.set(duration, stats.stdDevFunc.getY(magIndex));
                csv.addLine(stats.getCSVLine(magIndex, "" + (float)duration));
            }
            String myPrefix = this.prefix + "_m" + optionalDigitDF.format(durMag);
            this.durCSVs.add(csv);
            this.durPrefixes.add(myPrefix);
            this.fixedDurPrefixes.add(myPrefix);
            csv.writeToFile(new File(outputDir, myPrefix + ".csv"));
            ArrayList<ArbitrarilyDiscretizedFunc> funcs = new ArrayList<ArbitrarilyDiscretizedFunc>();
            ArrayList<PlotCurveCharacterstics> chars = new ArrayList<PlotCurveCharacterstics>();
            meanFunc.setName("Mean");
            funcs.add(meanFunc);
            chars.add(plotCurveCharacterstics);
            for (int j = 0; j < fractileFuncs.length; ++j) {
                ArbitrarilyDiscretizedFunc func = fractileFuncs[j];
                if (j == 0) {
                    func.setName(ETAS_LongTermRateVariabilityPlot.getFractilesString());
                }
                funcs.add(func);
                chars.add(fractileChar);
            }
            medianFunc.setName("Median");
            funcs.add(medianFunc);
            chars.add(medianChar);
            modeFunc.setName("Mode");
            funcs.add(modeFunc);
            chars.add(modeChar);
            stdDevFunc.setName("Std. Dev.");
            funcs.add(stdDevFunc);
            chars.add(stdDevChar);
            String yAxisLabel = "Cumulative Annual Rate (1/yr)";
            String title = "M" + optionalDigitDF.format(durMag) + " Rate Variability";
            PlotSpec spec = new PlotSpec(funcs, chars, title, "Duration (years)", yAxisLabel);
            spec.setLegendVisible(true);
            Range xRange = new Range(this.durationFunc.getMinX(), this.durationFunc.getMaxX());
            Range yRange = ETAS_LongTermRateVariabilityPlot.getYRange(meanFunc, stdDevFunc);
            HeadlessGraphPanel gp = ETAS_LongTermRateVariabilityPlot.buildGraphPanel();
            gp.setRenderingOrder(DatasetRenderingOrder.REVERSE);
            gp.drawGraphPanel(spec, false, true, xRange, yRange);
            gp.getChartPanel().setSize(800, 600);
            gp.saveAsPNG(new File(outputDir, myPrefix + ".png").getAbsolutePath());
            gp.saveAsPDF(new File(outputDir, myPrefix + ".pdf").getAbsolutePath());
            gp.saveAsTXT(new File(outputDir, myPrefix + ".txt").getAbsolutePath());
        }
        return null;
    }

    private static Range getYRange(DiscretizedFunc ... funcs) {
        double maxY = 0.0;
        double minY = Double.POSITIVE_INFINITY;
        for (DiscretizedFunc func : funcs) {
            for (Point2D pt : func) {
                if (pt.getY() > 0.0) {
                    minY = Math.min(minY, pt.getY());
                }
                maxY = Math.max(maxY, pt.getY());
            }
        }
        minY /= 2.0;
        maxY *= 2.0;
        minY = Math.pow(10.0, Math.floor(Math.log10(minY)));
        maxY = Math.pow(10.0, Math.ceil(Math.log10(maxY)));
        return new Range(minY, maxY);
    }

    private static String getFractilesString() {
        ArrayList<CallSite> percents = new ArrayList<CallSite>();
        for (double fractile : fractiles) {
            percents.add((CallSite)((Object)(optionalDigitDF.format(fractile * 100.0) + "%")));
        }
        return Joiner.on((String)",").join(percents);
    }

    @Override
    public List<String> generateMarkdown(String relativePathToOutputDir, String topLevelHeading, String topLink) throws IOException {
        int i;
        ArrayList<String> lines = new ArrayList<String>();
        lines.add((String)topLevelHeading + " Long Term Rate Variability");
        lines.add(topLink);
        lines.add("");
        if (this.fixedDurPrefixes != null) {
            topLevelHeading = (String)topLevelHeading + "#";
            for (i = 0; i < this.fixedDurations.length; ++i) {
                String prefix = this.fixedDurPrefixes.get(i);
                CSVFile<String> csv = this.fixedDurCSVs.get(i);
                lines.add((String)topLevelHeading + " " + ETAS_LongTermRateVariabilityPlot.getTimeLabel(this.fixedDurations[i], false) + " Variability");
                lines.add(topLink);
                lines.add("");
                lines.add("![Fixed Time Plot](" + relativePathToOutputDir + "/" + prefix + ".png)");
                lines.add("");
                lines.add("[Download CSV Here](" + relativePathToOutputDir + "/" + prefix + ".csv)");
                lines.add("");
                lines.addAll(MarkdownUtils.tableFromCSV(csv, true).build());
                lines.add("");
            }
            if (this.durMinMags.length < 2) {
                lines.add((String)topLevelHeading + " Variability Duration Dependence");
                lines.add(topLink);
                lines.add("");
            }
        }
        for (i = 0; i < this.durMinMags.length; ++i) {
            double durMag = this.durMinMags[i];
            if (this.durMinMags.length > 1) {
                lines.add((String)topLevelHeading + " M" + optionalDigitDF.format(durMag) + "  Variability Duration Dependence");
                lines.add(topLink);
                lines.add("");
            }
            String prefix = this.durPrefixes.get(i);
            lines.add("![Duration Dependence Plot](" + relativePathToOutputDir + "/" + prefix + ".png)");
            lines.add("");
            lines.add("[Download CSV Here](" + relativePathToOutputDir + "/" + prefix + ".csv)");
            lines.add("");
            lines.addAll(MarkdownUtils.tableFromCSV(this.durCSVs.get(i), true).build());
            lines.add("");
        }
        return lines;
    }

    private class MFD_VarStats {
        private XY_DataSetList cumulativeMFDs = new XY_DataSetList();
        private List<Double> relativeWeights = new ArrayList<Double>();
        private EvenlyDiscretizedFunc meanFunc;
        private EvenlyDiscretizedFunc medianFunc;
        private EvenlyDiscretizedFunc modeFunc;
        private EvenlyDiscretizedFunc stdDevFunc;
        private EvenlyDiscretizedFunc[] fractileFuncs;

        public MFD_VarStats(List<IncrementalMagFreqDist> mfds, int numToTrim, double duration) {
            for (IncrementalMagFreqDist mfd : mfds) {
                if (numToTrim > 0) {
                    IncrementalMagFreqDist trimmed = new IncrementalMagFreqDist(mfd.getX(numToTrim), mfd.size() - numToTrim, mfd.getDelta());
                    for (int i = 0; i < trimmed.size(); ++i) {
                        trimmed.set(i, mfd.getY(i + numToTrim));
                    }
                    mfd = trimmed;
                }
                EvenlyDiscretizedFunc cumulative = mfd.getCumRateDistWithOffset();
                this.cumulativeMFDs.add(cumulative);
                this.relativeWeights.add(1.0);
            }
            double minMag = ((XY_DataSet)this.cumulativeMFDs.get(0)).getMinX();
            int numMag = ((XY_DataSet)this.cumulativeMFDs.get(0)).size();
            double deltaMag = mfds.get(0).getDelta();
            FractileCurveCalculator fractileCalc = new FractileCurveCalculator(this.cumulativeMFDs, this.relativeWeights);
            this.meanFunc = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            this.stdDevFunc = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            this.medianFunc = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            this.modeFunc = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            this.fractileFuncs = new EvenlyDiscretizedFunc[fractiles.length];
            for (int i = 0; i < fractiles.length; ++i) {
                this.fractileFuncs[i] = new EvenlyDiscretizedFunc(minMag, numMag, deltaMag);
            }
            AbstractXY_DataSet meanCurve = fractileCalc.getMeanCurve();
            HashMap<Double, AbstractXY_DataSet> fractileCurves = new HashMap<Double, AbstractXY_DataSet>();
            double[] dArray = fractiles;
            int n = dArray.length;
            for (int i = 0; i < n; ++i) {
                Double fractile = dArray[i];
                fractileCurves.put(fractile, fractileCalc.getFractile(fractile));
            }
            fractileCurves.put(0.5, fractileCalc.getFractile(0.5));
            double rateScalar = 1.0 / duration;
            for (int i = 0; i < meanCurve.size(); ++i) {
                this.meanFunc.set(i, meanCurve.getY(i) * rateScalar);
                ArbDiscrEmpiricalDistFunc dist = fractileCalc.getEmpiricalDist(i);
                double mode = dist.size() == 1 ? dist.getX(0) : dist.getMostCentralMode();
                this.modeFunc.set(i, mode * rateScalar);
                this.stdDevFunc.set(i, dist.getStdDev() * rateScalar);
                for (int j = 0; j < fractiles.length; ++j) {
                    double fractile = fractiles[j];
                    AbstractXY_DataSet fractileCurve = (AbstractXY_DataSet)fractileCurves.get(fractile);
                    this.fractileFuncs[j].set(i, fractileCurve.getY(i) * rateScalar);
                }
                AbstractXY_DataSet medianCurve = (AbstractXY_DataSet)fractileCurves.get(0.5);
                this.medianFunc.set(i, medianCurve.getY(i) * rateScalar);
            }
        }

        public List<String> getCSVLine(int magIndex, String ... leadingVals) {
            ArrayList<String> line = new ArrayList<String>();
            for (String val : leadingVals) {
                line.add(val);
            }
            line.add("" + (float)this.meanFunc.getY(magIndex));
            line.add("" + (float)this.medianFunc.getY(magIndex));
            line.add("" + (float)this.modeFunc.getY(magIndex));
            line.add("" + (float)this.stdDevFunc.getY(magIndex));
            for (int f = 0; f < this.fractileFuncs.length; ++f) {
                line.add("" + (float)this.fractileFuncs[f].getY(magIndex));
            }
            return line;
        }
    }
}

