/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.association;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.dom4j.Document;
import org.dom4j.Element;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class FaultPolygonXMLWriter {
    public static void main(String[] args) throws IOException {
        double[] buffers = new double[]{1.0, 2.0, 4.0, 6.0, 8.0, 10.0, 12.0};
        File outputDir = new File("/tmp");
        FaultModels[] fms = new FaultModels[]{FaultModels.FM3_1, FaultModels.FM3_2};
        DeformationModels dm = DeformationModels.GEOLOGIC;
        for (FaultModels fm : fms) {
            List<? extends FaultSection> sects = new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1).getSubSectionList();
            for (double d : buffers) {
                FaultPolyMgr polyMgr = FaultPolyMgr.create(sects, d);
                Document doc = XMLUtils.createDocumentWithRoot();
                Element root = doc.getRootElement();
                for (FaultSection faultSection : sects) {
                    Region poly = polyMgr.getPoly(faultSection.getSectionId());
                    Preconditions.checkNotNull((Object)poly, (String)"Null poly for sect %s", (Object)faultSection);
                    poly.setName(faultSection.getName());
                    poly.toXMLMetadata(root);
                }
                XMLUtils.writeDocumentToFile(new File(outputDir, fm.encodeChoiceString() + "_sub_sects_" + (int)d + "km_buffer.xml"), doc);
            }
            sects = fm.getFaultSections();
            Document doc = XMLUtils.createDocumentWithRoot();
            Element root = doc.getRootElement();
            for (FaultSection faultSection : sects) {
                Region poly = faultSection.getZonePolygon();
                if (poly == null) {
                    System.out.println("WARNING: no polygon for section " + faultSection.getName());
                    continue;
                }
                poly.setName(faultSection.getName());
                poly.toXMLMetadata(root);
            }
            XMLUtils.writeDocumentToFile(new File(outputDir, fm.encodeChoiceString() + "_sects_geologic.xml"), doc);
        }
    }
}

