/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import com.google.common.io.Files;
import com.google.common.primitives.Floats;
import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.text.SimpleDateFormat;
import java.util.ArrayDeque;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.Deque;
import java.util.GregorianCalendar;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.dom4j.DocumentException;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.AbstractNthRupERF;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.earthquake.observedEarthquake.parsers.UCERF3_CatalogParser;
import org.opensha.sha.earthquake.param.BPTAveragingTypeOptions;
import org.opensha.sha.earthquake.param.BackgroundRupType;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityOptions;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_CubeDiscretizationParams;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.ETAS_LongTermMFDs;
import scratch.UCERF3.erf.ETAS.ETAS_Params.ETAS_ParameterList;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_MaxPointSourceMagParam;
import scratch.UCERF3.erf.ETAS.ETAS_Params.U3ETAS_StatewideCatalogCompletenessParam;
import scratch.UCERF3.erf.ETAS.ETAS_SimAnalysisTools;
import scratch.UCERF3.erf.ETAS.ETAS_SimulationMetadata;
import scratch.UCERF3.erf.ETAS.ETAS_Simulator;
import scratch.UCERF3.erf.ETAS.FaultSystemSolutionERF_ETAS;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.ETAS_Simulator_NoFaults;
import scratch.UCERF3.erf.ETAS.NoFaultsModel.UCERF3_GriddedSeisOnlyERF_ETAS;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.analysis.SimulationMarkdownGenerator;
import scratch.UCERF3.erf.ETAS.association.FiniteFaultMappingData;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_BinaryWriter;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.TriggerRupture;
import scratch.UCERF3.inversion.InversionFaultSystemSolution;
import scratch.UCERF3.utils.LastEventData;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.U3_EqkCatalogStatewideCompleteness;

public class ETAS_Launcher {
    protected DebugLevel debugLevel = DebugLevel.FINE;
    private ETAS_Config config;
    private long simulationOT;
    private String simulationName;
    private File fssFile;
    private Map<TriggerRupture, ETAS_EqkRupture> triggerRupturesMap;
    private List<ETAS_EqkRupture> triggerRuptures;
    private List<ETAS_EqkRupture> histQkList;
    private double[] gridSeisCorrections;
    private List<float[]> fractionSrcAtPointList;
    private List<int[]> srcAtPointList;
    private int[] isCubeInsideFaultPolygon;
    private Deque<FaultSystemSolution> fssDeque = new ArrayDeque<FaultSystemSolution>();
    private Deque<AbstractNthRupERF> erfDeque = new ArrayDeque<AbstractNthRupERF>();
    private Map<Integer, List<LastEventData>> lastEventData;
    private Map<Long, List<Integer>> resetSubSectsMap;
    private GriddedRegion griddedRegion;
    private ETAS_CubeDiscretizationParams cubeParams;
    private ETAS_LongTermMFDs longTermMFDs;
    private File tempResultsDir;
    private File resultsDir;
    private long[] randSeeds;
    private ETAS_ParameterList params;
    private boolean dateLastDebug = false;
    private static final SimpleDateFormat df = new SimpleDateFormat("HH:mm:ss.SSS");
    private int threadLimit = Integer.MAX_VALUE;
    private ThreadPoolExecutor exec;

    public ETAS_Launcher(ETAS_Config config) throws IOException {
        this(config, true);
    }

    public ETAS_Launcher(ETAS_Config config, boolean mkdirs) throws IOException {
        this(config, mkdirs, config.getRandomSeed());
    }

    public ETAS_Launcher(ETAS_Config config, boolean mkdirs, Long randSeed) throws IOException {
        this(config, mkdirs, randSeed, null);
    }

    ETAS_Launcher(ETAS_Config config, boolean mkdirs, Long randSeed, ETAS_CubeDiscretizationParams cubeParams) throws IOException {
        ETAS_Simulator.D = false;
        if (config.isGriddedOnly()) {
            ETAS_Simulator_NoFaults.D = false;
        }
        this.config = config;
        this.simulationOT = config.getSimulationStartTimeMillis();
        this.debug(DebugLevel.INFO, "Simulation start time (epoch milliseconds): " + this.simulationOT);
        this.debug(DebugLevel.INFO, "Simulation start date: " + SimulationMarkdownGenerator.df.format(new Date(config.getSimulationStartTimeMillis())));
        this.params = new ETAS_ParameterList();
        this.params.setImposeGR(config.isImposeGR());
        this.params.setU3ETAS_ProbModel(config.getProbModel());
        if (config.isGriddedOnly() && config.isGridSeisCorr()) {
            this.debug(DebugLevel.INFO, "WARNING: grid seis correction not applied in gridded only case");
        }
        this.params.setApplyGridSeisCorr(config.isGridSeisCorr() && !config.isGriddedOnly());
        this.params.setApplySubSeisForSupraNucl(config.isApplySubSeisForSupraNucl());
        this.params.setTotalRateScaleFactor(config.getTotRateScaleFactor());
        if (config.getETAS_P() != null) {
            this.debug(DebugLevel.INFO, "Setting custom p parameter value: " + config.getETAS_P());
            this.params.set_p(config.getETAS_P());
        }
        if (config.getETAS_C() != null) {
            this.debug(DebugLevel.INFO, "Setting custom c parameter value: " + config.getETAS_C());
            this.params.set_c(config.getETAS_C());
        }
        if (config.getETAS_Log10_K() != null) {
            double log10k = config.getETAS_Log10_K();
            double k = Math.pow(10.0, log10k);
            this.debug(DebugLevel.INFO, "Setting custom k from Log10(k)=" + (float)log10k + ": " + k);
            this.params.set_k(k);
        }
        if (config.getETAS_K_COV() != null) {
            double kCOV = config.getETAS_K_COV();
            this.debug(DebugLevel.INFO, "Setting k COV: " + (float)kCOV);
            this.params.set_kCOV(kCOV);
        }
        if (config.getMaxPointSourceMag() != null) {
            double maxPtSrcMag = config.getMaxPointSourceMag();
            this.debug(DebugLevel.INFO, "Setting maximum point source mag: " + (float)maxPtSrcMag);
            this.params.setMaxPointSourceMag(maxPtSrcMag);
        } else {
            this.debug(DebugLevel.INFO, "No maximum point source mag specified, disabling");
            this.params.setMaxPointSourceMag(U3ETAS_MaxPointSourceMagParam.MAX);
        }
        if (config.getCompletenessModel() != null) {
            if (config.getCompletenessModel() != U3ETAS_StatewideCatalogCompletenessParam.DEFAULT_VALUE) {
                this.debug(DebugLevel.INFO, "Setting completeness model: " + config.getCompletenessModel().name());
            }
            this.params.setStatewideCompletenessModel(config.getCompletenessModel());
        }
        this.lastEventData = LastEventData.load();
        this.resetSubSectsMap = new HashMap<Long, List<Integer>>();
        this.fssFile = ETAS_Config.resolvePath(config.getFSS_File());
        LastEventData.filterDataAfterTime(this.lastEventData, this.simulationOT);
        Preconditions.checkState((config.isIncludeSpontaneous() || config.hasTriggers() || config.getTriggerCatalogFile() != null ? 1 : 0) != 0, (Object)"Empty simulation! Must include spontaneous, trigger ruptures, and/or a trigger catalog");
        this.simulationName = config.getSimulationName();
        if (this.simulationName == null || this.simulationName.isEmpty()) {
            List<ETAS_EqkRupture> histQkList;
            List<ETAS_EqkRupture> triggerRuptures;
            if (config.getTriggerRuptures() != null && !config.getTriggerRuptures().isEmpty() && (triggerRuptures = this.getTriggerRuptures()).size() > 1) {
                float[] mags = new float[triggerRuptures.size()];
                float maxMag = Float.NEGATIVE_INFINITY;
                for (int i = 0; i < mags.length; ++i) {
                    mags[i] = (float)triggerRuptures.get(i).getMag();
                    if (!(mags[i] > maxMag)) continue;
                    maxMag = mags[i];
                }
                this.simulationName = mags.length < 5 ? mags.length + " Scenarios (M=" + Joiner.on((String)", M=").join((Iterable)Floats.asList((float[])mags)) + ")" : mags.length + " Scenarios (Max=" + maxMag + ")";
            }
            if (config.getTriggerCatalogFile() != null && !(histQkList = this.getHistQkList()).isEmpty()) {
                this.simulationName = this.simulationName != null ? this.simulationName + ", " : "";
                this.simulationName = this.simulationName + histQkList.size() + " Hist EQs";
            }
            if (config.isIncludeSpontaneous()) {
                this.simulationName = this.simulationName != null ? this.simulationName + ", " : "";
                this.simulationName = this.simulationName + "Spontaneous";
            }
        }
        this.debug(DebugLevel.FINE, "Simulation name: " + this.simulationName);
        File outputDir = ETAS_Config.resolvePath(config.getOutputDir());
        if (mkdirs) {
            ETAS_Launcher.waitOnDirCreation(outputDir, 10, 2000L);
        }
        this.resultsDir = ETAS_Launcher.getResultsDir(outputDir);
        if (mkdirs) {
            ETAS_Launcher.waitOnDirCreation(this.resultsDir, 10, 2000L);
        }
        this.griddedRegion = RELM_RegionUtils.getGriddedRegionInstance();
        if (randSeed == null) {
            randSeed = System.nanoTime();
            this.debug("determining random seeds with current nano time=" + randSeed);
        } else {
            this.debug("determining random seeds from input seed=" + randSeed);
        }
        this.buildRandomSeeds(randSeed);
        if (cubeParams == null) {
            cubeParams = new ETAS_CubeDiscretizationParams(this.griddedRegion);
        }
        this.cubeParams = cubeParams;
    }

    static File getResultsDir(File outputDir) {
        return new File(outputDir, "results");
    }

    private void buildRandomSeeds(long seed) {
        this.randSeeds = new long[this.config.getNumSimulations()];
        if (this.randSeeds.length == 1) {
            this.randSeeds[0] = seed;
        } else {
            RandomDataGenerator r = new RandomDataGenerator();
            r.reSeed(seed);
            for (int i = 0; i < this.config.getNumSimulations(); ++i) {
                this.randSeeds[i] = r.nextLong(Long.MIN_VALUE, Long.MAX_VALUE);
            }
        }
    }

    public void setRandomSeeds(long[] randSeeds) {
        Preconditions.checkState((randSeeds.length == this.config.getNumSimulations() ? 1 : 0) != 0);
        this.randSeeds = randSeeds;
    }

    public void debug(String message) {
        this.debug(DebugLevel.INFO, message);
    }

    public void debug(DebugLevel level, String message) {
        if (this.debugLevel.shouldPrint(level)) {
            System.out.println("[" + df.format(new Date()) + " (" + Thread.currentThread().getName() + ")]: " + message);
        }
    }

    public void setDebugLevel(DebugLevel level) {
        this.debugLevel = level;
    }

    private List<Long> getSortedResetTimes() {
        ArrayList<Long> times = new ArrayList<Long>(this.resetSubSectsMap.keySet());
        Collections.sort(times);
        return times;
    }

    public synchronized List<ETAS_EqkRupture> getTriggerRuptures() {
        List<TriggerRupture> triggerRuptureConfigs;
        if (this.triggerRuptures == null && (triggerRuptureConfigs = this.config.getTriggerRuptures()) != null && !triggerRuptureConfigs.isEmpty()) {
            this.debug(DebugLevel.INFO, "Building " + triggerRuptureConfigs.size() + " trigger ruptures");
            FaultSystemSolution fss = this.checkOutFSS();
            FaultSystemRupSet rupSet = fss.getRupSet();
            this.triggerRuptures = new ArrayList<ETAS_EqkRupture>();
            this.triggerRupturesMap = new HashMap<TriggerRupture, ETAS_EqkRupture>();
            for (TriggerRupture triggerRup : triggerRuptureConfigs) {
                ETAS_EqkRupture rup = triggerRup.buildRupture(rupSet, this.simulationOT, this.params);
                this.triggerRupturesMap.put(triggerRup, rup);
                this.triggerRuptures.add(rup);
                int[] rupturedSects = triggerRup.getSectionsRuptured(rupSet);
                if (rupturedSects == null || rupturedSects.length <= 0) continue;
                long time = rup.getOriginTime();
                List<Integer> sects = this.resetSubSectsMap.get(time);
                if (sects == null) {
                    sects = new ArrayList<Integer>();
                    this.resetSubSectsMap.put(time, sects);
                }
                for (int sect : rupturedSects) {
                    sects.add(sect);
                }
            }
            this.checkInFSS(fss);
            if (!this.resetSubSectsMap.isEmpty()) {
                this.debug(DebugLevel.FINE, "The following subsections' time of occurrence will be reset:");
                for (Long time : this.getSortedResetTimes()) {
                    this.debug(DebugLevel.FINE, "\t" + time + ": " + Joiner.on((String)",").join((Iterable)this.resetSubSectsMap.get(time)));
                }
            }
        }
        return this.triggerRuptures;
    }

    public ETAS_EqkRupture getRuptureForTrigger(TriggerRupture trigger) {
        this.getTriggerRuptures();
        return this.triggerRupturesMap.get(trigger);
    }

    public ETAS_ParameterList getETAS_Params() {
        return this.params;
    }

    public synchronized List<ETAS_EqkRupture> getHistQkList() {
        if (this.histQkList == null) {
            this.histQkList = new ArrayList<ETAS_EqkRupture>();
            if (this.config.getTriggerCatalogFile() != null) {
                this.debug(DebugLevel.INFO, "Loading historical catalog: " + this.config.getTriggerCatalogFile().getName());
                if (this.config.getCompletenessModel() == null) {
                    this.debug(DebugLevel.INFO, "WARNING: statewide completeness model not specified, using default. Specify with `catalogCompletenessModel` JSON parameter");
                } else {
                    this.params.setStatewideCompletenessModel(this.config.getCompletenessModel());
                }
                FaultSystemSolution fss = this.checkOutFSS();
                try {
                    this.histQkList.addAll(ETAS_Launcher.loadHistoricalCatalog(ETAS_Config.resolvePath(this.config.getTriggerCatalogFile()), ETAS_Config.resolvePath(this.config.getTriggerCatalogSurfaceMappingsFile()), fss, this.simulationOT, this.resetSubSectsMap, this.params.getStatewideCompletenessModel()));
                }
                catch (IOException | DocumentException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                this.checkInFSS(fss);
            }
        }
        return this.histQkList;
    }

    public GriddedRegion getRegion() {
        return this.griddedRegion;
    }

    public List<ETAS_EqkRupture> getCombinedTriggers() {
        List<ETAS_EqkRupture> hist;
        ArrayList<ETAS_EqkRupture> rups = new ArrayList<ETAS_EqkRupture>();
        List<ETAS_EqkRupture> triggers = this.getTriggerRuptures();
        if (triggers != null) {
            rups.addAll(triggers);
        }
        if ((hist = this.getHistQkList()) != null && !this.config.isTreatTriggerCatalogAsSpontaneous()) {
            rups.addAll(hist);
        }
        return rups;
    }

    private List<ETAS_EqkRupture> threadSafeInputs(List<ETAS_EqkRupture> inputEvents) {
        if (inputEvents == null) {
            return null;
        }
        if (this.config.getETAS_K_COV() != null && this.config.getETAS_K_COV() > 0.0) {
            ArrayList<ETAS_EqkRupture> cloned = new ArrayList<ETAS_EqkRupture>(inputEvents.size());
            for (ETAS_EqkRupture input : inputEvents) {
                cloned.add((ETAS_EqkRupture)input.clone());
            }
            return cloned;
        }
        return inputEvents;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public FaultSystemSolution checkOutFSS() {
        FaultSystemSolution fss;
        block12: {
            fss = null;
            Deque<FaultSystemSolution> deque = this.fssDeque;
            synchronized (deque) {
                if (!this.fssDeque.isEmpty()) {
                    fss = this.fssDeque.pop();
                }
            }
            if (fss == null) {
                try {
                    this.debug(DebugLevel.FINE, "Loading a new Fault System Solution from " + this.fssFile.getAbsolutePath());
                    fss = FaultSystemSolution.load(this.fssFile);
                    if (!this.config.isGridSeisCorr() || this.config.isGriddedOnly()) break block12;
                    if (this.gridSeisCorrections == null) {
                        deque = this.fssDeque;
                        synchronized (deque) {
                            if (this.gridSeisCorrections == null) {
                                File cacheFile = new File(ETAS_Config.resolvePath(this.config.getCacheDir()), "griddedSeisCorrectionCache");
                                this.debug(DebugLevel.FINE, "Loading gridded seismicity correction cache file from " + cacheFile.getAbsolutePath());
                                this.gridSeisCorrections = MatrixIO.doubleArrayFromFile(cacheFile);
                            }
                        }
                    }
                    ETAS_Simulator.correctGriddedSeismicityRatesInERF(fss, false, this.gridSeisCorrections);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }
        FaultSystemRupSet rupSet = fss.getRupSet();
        this.resetLastEventData(rupSet);
        return fss;
    }

    private void resetLastEventData(FaultSystemRupSet rupSet) {
        block4: {
            block3: {
                if (!this.config.isTimeIndependentERF()) break block3;
                for (int s = 0; s < rupSet.getNumSections(); ++s) {
                    rupSet.getFaultSectionData(s).setDateOfLastEvent(Long.MIN_VALUE);
                }
                break block4;
            }
            LastEventData.populateSubSects(rupSet.getFaultSectionDataList(), this.lastEventData);
            if (this.resetSubSectsMap.isEmpty()) break block4;
            for (Long time : this.getSortedResetTimes()) {
                for (int s : this.resetSubSectsMap.get(time)) {
                    rupSet.getFaultSectionData(s).setDateOfLastEvent(time);
                }
            }
        }
    }

    public synchronized void checkInFSS(FaultSystemSolution fss) {
        this.fssDeque.push(fss);
    }

    public static List<ETAS_EqkRupture> loadHistoricalCatalog(File catFile, File surfsFile, FaultSystemSolution sol, long ot, Map<Long, List<Integer>> resetSubSectsMap, U3_EqkCatalogStatewideCompleteness completenessModel) throws IOException, DocumentException {
        ArrayList<ETAS_EqkRupture> histQkList = new ArrayList<ETAS_EqkRupture>();
        Preconditions.checkArgument((boolean)catFile.exists(), (Object)("Catalog file doesn't exist: " + catFile.getAbsolutePath()));
        ObsEqkRupList loadedRups = UCERF3_CatalogParser.loadCatalog(catFile);
        if (surfsFile != null) {
            FaultModels fm = ETAS_Launcher.getFaultModel(sol);
            Preconditions.checkArgument((boolean)surfsFile.exists(), (Object)("Rupture surfaces file doesn't exist: " + surfsFile.getAbsolutePath()));
            FiniteFaultMappingData.loadRuptureSurfaces(surfsFile, loadedRups, fm, sol.getRupSet());
        }
        loadedRups = completenessModel.getFilteredCatalog(loadedRups);
        int numAfter = 0;
        for (ObsEqkRupture rup : loadedRups) {
            ETAS_EqkRupture etasRup;
            if (rup.getOriginTime() > ot) {
                if (numAfter < 10) {
                    System.out.println("Skipping a M" + rup.getMag() + " after sim start (" + rup.getOriginTime() + " > " + ot + ")");
                }
                if (++numAfter != 10) continue;
                System.out.println("(supressing future output on skipped ruptures)");
                continue;
            }
            ETAS_EqkRupture eTAS_EqkRupture = etasRup = rup instanceof ETAS_EqkRupture ? (ETAS_EqkRupture)rup : new ETAS_EqkRupture(rup);
            if (etasRup.getFSSIndex() >= 0 && resetSubSectsMap != null) {
                List<Integer> sectIndexes = sol.getRupSet().getSectionsIndicesForRup(etasRup.getFSSIndex());
                resetSubSectsMap.put(etasRup.getOriginTime(), sectIndexes);
            }
            etasRup.setID(Integer.parseInt(rup.getEventId()));
            histQkList.add(etasRup);
        }
        System.out.println("Skipped " + numAfter + " ruptures after sim start");
        return histQkList;
    }

    private static FaultModels getFaultModel(FaultSystemSolution sol) {
        int numRups = sol.getRupSet().getNumRuptures();
        if (sol instanceof InversionFaultSystemSolution) {
            return ((InversionFaultSystemSolution)sol).getLogicTreeBranch().getValue(FaultModels.class);
        }
        if (numRups == 253706) {
            return FaultModels.FM3_1;
        }
        if (numRups == 305709) {
            return FaultModels.FM3_2;
        }
        throw new IllegalStateException("Don't know Fault Model for solution with " + numRups + " ruptures");
    }

    static void waitOnDirCreation(File dir, int maxRetries, long sleepMillis) {
        int retry = 0;
        while (!dir.exists() && !dir.mkdir()) {
            try {
                Thread.sleep(sleepMillis);
            }
            catch (InterruptedException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            if (retry++ <= maxRetries) continue;
            throw new IllegalStateException("Directory doesn't exist and couldn't be created after " + maxRetries + " retries: " + dir.getAbsolutePath());
        }
    }

    void setTempDir(File tempResultsDir) {
        this.tempResultsDir = tempResultsDir;
    }

    File getTempResultsDir(int index) {
        return this.getResultsDir(this.tempResultsDir == null ? this.resultsDir : this.tempResultsDir, index);
    }

    File getResultsDir(int index) {
        return this.getResultsDir(this.resultsDir, index);
    }

    File getResultsDir(File parentDir, int index) {
        String runName = "" + index;
        int desiredLen = ("" + (this.config.getNumSimulations() - 1)).length();
        while (runName.length() < desiredLen) {
            runName = "0" + runName;
        }
        runName = "sim_" + runName;
        return new File(parentDir, runName);
    }

    public static FaultSystemSolutionERF_ETAS buildERF(FaultSystemSolution sol, boolean timeIndep, double duration, int startYear) {
        long ot = Math.round(((double)startYear - 1970.0) * 3.15576E10);
        return ETAS_Launcher.buildERF_millis(sol, timeIndep, duration, ot);
    }

    public static FaultSystemSolutionERF_ETAS buildERF_millis(FaultSystemSolution sol, boolean timeIndep, double duration, long ot) {
        FaultSystemSolutionERF_ETAS erf = new FaultSystemSolutionERF_ETAS(sol);
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.INCLUDE);
        erf.setParameter("Treat Background Seismicity As", (Object)BackgroundRupType.POINT);
        erf.setParameter("Apply Aftershock Filter", false);
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.U3_BPT);
        erf.getParameter("Aperiodicity").setValue(MagDependentAperiodicityOptions.MID_VALUES);
        BPTAveragingTypeOptions aveType = BPTAveragingTypeOptions.AVE_RI_AVE_NORM_TIME_SINCE;
        erf.setParameter("BPT Averaging Type", (Object)aveType);
        erf.setParameter("Aleatory Mag-Area StdDev", 0.0);
        if (!timeIndep) {
            double startYear = 1970.0 + (double)ot / 3.15576E10;
            erf.getParameter("Historic Open Interval").setValue(startYear - 1875.0);
        }
        erf.getTimeSpan().setStartTimeInMillis(ot + 1L);
        erf.getTimeSpan().setDuration(duration);
        erf.setCacheGridSources(false);
        return erf;
    }

    public static UCERF3_GriddedSeisOnlyERF_ETAS buildGriddedERF(long ot, double duration) {
        UCERF3_GriddedSeisOnlyERF_ETAS erf = new UCERF3_GriddedSeisOnlyERF_ETAS();
        erf.setParameter("Treat Background Seismicity As", (Object)BackgroundRupType.POINT);
        erf.setParameter("Apply Aftershock Filter", false);
        erf.setParameter("Maximum Magnitude", 8.3);
        erf.setParameter("Total Regional Rate", TotalMag5Rate.RATE_7p9);
        erf.setParameter("Spatial Seis PDF", SpatialSeisPDF.UCERF3);
        erf.getTimeSpan().setStartTimeInMillis(ot);
        erf.getTimeSpan().setDuration(duration);
        return erf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public AbstractNthRupERF checkOutERF() {
        AbstractNthRupERF erf = null;
        Deque<AbstractNthRupERF> deque = this.erfDeque;
        synchronized (deque) {
            if (!this.erfDeque.isEmpty()) {
                erf = this.erfDeque.pop();
            }
        }
        if (erf == null) {
            this.debug(DebugLevel.FINE, "Loading a new ERF");
            FaultSystemSolution sol = null;
            if (this.config.isGriddedOnly()) {
                erf = ETAS_Launcher.buildGriddedERF(this.simulationOT, this.config.getDuration());
            } else {
                sol = this.checkOutFSS();
                erf = ETAS_Launcher.buildERF_millis(sol, this.config.isTimeIndependentERF(), this.config.getDuration(), this.simulationOT);
            }
            erf.updateForecast();
        } else {
            if (!this.config.isGriddedOnly() && !this.config.isTimeIndependentERF()) {
                double startYear = 1970.0 + (double)this.simulationOT / 3.15576E10;
                erf.getParameter("Historic Open Interval").setValue(startYear - 1875.0);
            }
            erf.getTimeSpan().setStartTimeInMillis(this.simulationOT + 1L);
            erf.getTimeSpan().setDuration(this.config.getDuration());
            if (!this.config.isGriddedOnly()) {
                FaultSystemSolutionERF_ETAS fssERF = (FaultSystemSolutionERF_ETAS)erf;
                FaultSystemRupSet rupSet = fssERF.getSolution().getRupSet();
                this.resetLastEventData(rupSet);
                for (int s = 0; s < rupSet.getNumSections(); ++s) {
                    fssERF.setFltSectOccurranceTime(s, rupSet.getFaultSectionData(s).getDateOfLastEvent());
                }
            }
            erf.updateForecast();
        }
        return erf;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkInERF(AbstractNthRupERF erf) {
        Deque<AbstractNthRupERF> deque = this.erfDeque;
        synchronized (deque) {
            this.erfDeque.push(erf);
        }
    }

    public static boolean isAlreadyDone(File resultsDir) {
        return ETAS_Launcher.isAlreadyDoneASCII(resultsDir) || ETAS_Launcher.isAlreadyDoneBinary(resultsDir);
    }

    public static boolean isAlreadyDoneASCII(File resultsDir) {
        File infoFile = new File(resultsDir, "infoString.txt");
        File eventsFile = new File(resultsDir, "simulatedEvents.txt");
        if (!infoFile.exists() || !eventsFile.exists() || eventsFile.length() == 0L) {
            return false;
        }
        try {
            for (String line : Files.readLines((File)infoFile, (Charset)Charset.defaultCharset())) {
                if (!line.contains("Total num ruptures: ")) continue;
                return true;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return false;
    }

    public static boolean isAlreadyDoneBinary(File resultsDir) {
        File eventsFile = new File(resultsDir, "simulatedEvents.bin");
        if (!eventsFile.exists()) {
            eventsFile = new File(resultsDir, "simulatedEvents.bin.gz");
        }
        if (!eventsFile.exists() || eventsFile.length() == 0L) {
            return false;
        }
        return ETAS_CatalogIO.isBinaryCatalogFileComplete(eventsFile);
    }

    private static Long getPrevRandSeed(File resultsDir) throws IOException {
        File infoFile = new File(resultsDir, "infoString.txt");
        if (!infoFile.exists()) {
            return null;
        }
        for (String line : Files.readLines((File)infoFile, (Charset)Charset.defaultCharset())) {
            if (!line.contains("randomSeed=")) continue;
            line = line.trim();
            line = line.substring(line.indexOf("=") + 1);
            return Long.parseLong(line);
        }
        return null;
    }

    private synchronized void checkLoadCaches(FaultSystemSolutionERF_ETAS erf) throws IOException {
        if (this.fractionSrcAtPointList == null) {
            File cacheDir = this.config.getCacheDir();
            File fractionSrcAtPointListFile = new File(cacheDir, "sectDistForCubeCache");
            File srcAtPointListFile = new File(cacheDir, "sectInCubeCache");
            File isCubeInsideFaultPolygonFile = new File(cacheDir, "cubeInsidePolyCache");
            Preconditions.checkState((boolean)fractionSrcAtPointListFile.exists(), (Object)("cache file not found: " + fractionSrcAtPointListFile.getAbsolutePath()));
            Preconditions.checkState((boolean)srcAtPointListFile.exists(), (Object)("cache file not found: " + srcAtPointListFile.getAbsolutePath()));
            Preconditions.checkState((boolean)isCubeInsideFaultPolygonFile.exists(), (Object)("cache file not found: " + isCubeInsideFaultPolygonFile.getAbsolutePath()));
            this.debug("loading cache from " + fractionSrcAtPointListFile.getAbsolutePath() + " (" + this.getMemoryDebug() + ")");
            this.fractionSrcAtPointList = MatrixIO.floatArraysListFromFile(fractionSrcAtPointListFile);
            this.debug("loading cache from " + srcAtPointListFile.getAbsolutePath() + " (" + this.getMemoryDebug() + ")");
            this.srcAtPointList = MatrixIO.intArraysListFromFile(srcAtPointListFile);
            this.debug("loading cache from " + srcAtPointListFile.getAbsolutePath() + " (" + this.getMemoryDebug() + ")");
            this.isCubeInsideFaultPolygon = MatrixIO.intArrayFromFile(isCubeInsideFaultPolygonFile);
            this.debug("done loading caches (" + this.getMemoryDebug() + ")");
        }
        if (this.longTermMFDs == null) {
            this.debug("building long-term MFDs...");
            this.longTermMFDs = new ETAS_LongTermMFDs(erf, this.params.getApplySubSeisForSupraNucl());
            this.debug("done building long-term MFDs");
        }
    }

    private String getMemoryDebug() {
        Runtime rt = Runtime.getRuntime();
        long totalMB = rt.totalMemory() / 1024L / 1024L;
        long freeMB = rt.freeMemory() / 1024L / 1024L;
        long usedMB = totalMB - freeMB;
        return "mem t/u/f: " + totalMB + "/" + usedMB + "/" + freeMB;
    }

    public static long getMaxMemMB() {
        return Runtime.getRuntime().maxMemory() / 1024L / 1024L;
    }

    private static int defaultNumThreads() {
        long maxMemMB = ETAS_Launcher.getMaxMemMB();
        int maxThreads = (int)(maxMemMB / 5000L);
        return Integer.max(1, Integer.min(maxThreads, Runtime.getRuntime().availableProcessors()));
    }

    public void calculateAll() {
        this.debug(DebugLevel.FINE, "max mem MB: " + ETAS_Launcher.getMaxMemMB());
        int threads = ETAS_Launcher.defaultNumThreads();
        this.debug(DebugLevel.FINE, "max threads calculated from max mem & available procs: " + threads);
        this.calculateAll(threads);
    }

    public void calculateAll(int numThreads) {
        ETAS_BinaryWriter binaryWriter = null;
        int[] batch = null;
        if (this.config.hasBinaryOutputFilters()) {
            this.debug(DebugLevel.FINE, "initializing binary filter writers");
            try {
                binaryWriter = new ETAS_BinaryWriter(this.config.getOutputDir(), this.config);
                HashSet<Integer> doneSet = binaryWriter.getDoneIndexes();
                if (doneSet != null && !doneSet.isEmpty()) {
                    int i;
                    ArrayList<Integer> indexes = new ArrayList<Integer>();
                    for (i = 0; i < this.config.getNumSimulations(); ++i) {
                        if (doneSet.contains(i)) continue;
                        indexes.add(i);
                    }
                    batch = new int[indexes.size()];
                    for (i = 0; i < batch.length; ++i) {
                        batch[i] = (Integer)indexes.get(i);
                    }
                }
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        this.calculate(numThreads, batch, binaryWriter, false);
        if (binaryWriter != null) {
            try {
                this.debug(DebugLevel.FINE, "finalizing");
                binaryWriter.close();
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }
        this.shutdownExecutor();
    }

    public void calculateBatch(int numThreads, int[] batch) {
        this.calculate(numThreads, batch, null, false);
    }

    private void updateExecutorNumThreads(int numThreads) {
        if (this.exec == null) {
            return;
        }
        this.exec.setCorePoolSize(numThreads);
        this.exec.setMaximumPoolSize(numThreads);
    }

    private ExecutorService getExecutor(int numThreads) {
        if (this.exec != null && !this.exec.isShutdown()) {
            this.updateExecutorNumThreads(numThreads);
        } else {
            this.debug(DebugLevel.DEBUG, "building new executor for numThreads=" + numThreads);
            this.exec = new ThreadPoolExecutor(numThreads, numThreads, 0L, TimeUnit.MILLISECONDS, new LinkedBlockingQueue<Runnable>());
        }
        return this.exec;
    }

    void shutdownExecutor() {
        if (this.exec != null) {
            this.debug(DebugLevel.DEBUG, "shutting down executor");
            this.exec.shutdown();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void calculate(int numThreads, int[] batch, ETAS_BinaryWriter binaryWriter, boolean binaryPreStage) {
        Stopwatch watch = Stopwatch.createStarted();
        ArrayList<CalcRunnable> tasks = new ArrayList<CalcRunnable>();
        if (batch != null && batch.length > 0) {
            for (int index : batch) {
                tasks.add(new CalcRunnable(index, this.randSeeds[index], binaryPreStage));
            }
        } else {
            for (int index = 0; index < this.config.getNumSimulations(); ++index) {
                tasks.add(new CalcRunnable(index, this.randSeeds[index], binaryPreStage));
            }
        }
        if (numThreads > this.threadLimit) {
            this.debug("reducing thread count to previously encountered limit of " + this.threadLimit);
            numThreads = this.threadLimit;
        }
        System.gc();
        this.debug("starting " + tasks.size() + " simulations with " + numThreads + " threads");
        if (numThreads > 1) {
            ExecutorService exec = this.getExecutor(numThreads);
            ArrayDeque<FutureContainer> futures = new ArrayDeque<FutureContainer>();
            for (CalcRunnable task : tasks) {
                futures.add(new FutureContainer(task, exec.submit(task)));
            }
            while (!futures.isEmpty()) {
                ExecutorService resultsDir;
                FutureContainer future = (FutureContainer)futures.pop();
                try {
                    int index = future.future.get();
                    if (binaryWriter == null) continue;
                    this.debug(DebugLevel.FINE, "processing binary filter for " + index);
                    resultsDir = this.getResultsDir(index);
                    binaryWriter.processCatalog(index, (File)((Object)resultsDir));
                }
                catch (IOException | InterruptedException | OutOfMemoryError | ExecutionException e) {
                    if (e instanceof ExecutionException && e.getCause() instanceof OutOfMemoryError || e instanceof OutOfMemoryError) {
                        if (numThreads <= 1) {
                            System.err.println("Ran out of memory and can't further reduce thread count (already at 1 thread)");
                            exec.shutdownNow();
                            if (e instanceof ExecutionException) {
                                throw ExceptionUtils.asRuntimeException(e.getCause());
                            }
                            throw ExceptionUtils.asRuntimeException(e);
                        }
                        resultsDir = exec;
                        synchronized (resultsDir) {
                            if (numThreads <= this.threadLimit) {
                                this.threadLimit = numThreads - 1;
                            }
                        }
                        Preconditions.checkState((this.threadLimit < numThreads ? 1 : 0) != 0, (Object)"Ran out of memory but can't reduce thread count further as we're already at 1 thread.");
                        CalcRunnable task = future.task;
                        this.debug("Resubmitting task " + task.index + " with threadLimit=" + this.threadLimit);
                        futures.add(new FutureContainer(task, exec.submit(task)));
                        continue;
                    }
                    exec.shutdownNow();
                    if (e instanceof ExecutionException) {
                        throw ExceptionUtils.asRuntimeException(e.getCause());
                    }
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        } else {
            for (CalcRunnable task : tasks) {
                int index = task.call();
                if (binaryWriter == null) continue;
                File resultsDir = this.getResultsDir(index);
                try {
                    binaryWriter.processCatalog(index, resultsDir);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        }
        watch.stop();
        double secs = (double)watch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
        double mins = secs / 60.0;
        double hours = mins / 60.0;
        String timeStr = hours > 1.5 ? (float)hours + " hours" : (mins > 1.5 ? (float)mins + " minutes" : (float)secs + " seconds");
        this.debug("done with " + tasks.size() + " simulations in " + timeStr);
    }

    private void preStage(int index, ETAS_CatalogIO.ETAS_Catalog catalog, File resultsDir) throws IOException {
        if (this.config.getBinaryOutputFilters() == null) {
            return;
        }
        this.debug("pre-staging catalog " + index);
        for (ETAS_Config.BinaryFilteredOutputConfig binaryConf : this.config.getBinaryOutputFilters()) {
            File stageFile = binaryConf.getPreStagedCatalogFile(resultsDir);
            if (stageFile.exists()) continue;
            ETAS_CatalogIO.ETAS_Catalog filtered = binaryConf.filter(this.config, catalog);
            ETAS_CatalogIO.writeCatalogBinary(stageFile, (List<ETAS_EqkRupture>)filtered);
        }
        this.debug("done pre-staging catalog " + index);
    }

    public static ETAS_CatalogIO.ETAS_Catalog getFilteredNoSpontaneous(ETAS_Config config, ETAS_CatalogIO.ETAS_Catalog catalog) {
        int[] parentIDs;
        int numTriggerRuptures;
        Preconditions.checkNotNull((Object)catalog, (Object)"ETAS_Catalog is null");
        Preconditions.checkNotNull((Object)config, (Object)"ETAS_Config is null");
        ETAS_SimulationMetadata meta = catalog.getSimulationMetadata();
        int n = numTriggerRuptures = config.getTriggerRuptures() == null ? 0 : config.getTriggerRuptures().size();
        if (numTriggerRuptures == 0 && (config.getTriggerCatalogFile() == null || config.isTreatTriggerCatalogAsSpontaneous())) {
            return null;
        }
        if (catalog.isEmpty()) {
            return catalog;
        }
        if (!(config.isIncludeSpontaneous() || config.getTriggerCatalogFile() != null && config.isTreatTriggerCatalogAsSpontaneous())) {
            return catalog;
        }
        if (meta != null) {
            int i;
            ArrayList<Integer> ids = new ArrayList<Integer>();
            if (meta.rangeTriggerRupIDs != null) {
                for (i = ((Integer)meta.rangeTriggerRupIDs.lowerEndpoint()).intValue(); i <= (Integer)meta.rangeTriggerRupIDs.upperEndpoint(); ++i) {
                    ids.add(i);
                }
            }
            if (meta.rangeHistCatalogIDs != null && !config.isTreatTriggerCatalogAsSpontaneous()) {
                for (i = ((Integer)meta.rangeHistCatalogIDs.lowerEndpoint()).intValue(); i <= (Integer)meta.rangeHistCatalogIDs.upperEndpoint(); ++i) {
                    ids.add(i);
                }
            }
            parentIDs = new int[ids.size()];
            for (i = 0; i < parentIDs.length; ++i) {
                parentIDs[i] = (Integer)ids.get(i);
            }
        } else {
            int maxParentID = config.getTriggerCatalogFile() != null && !config.isTreatTriggerCatalogAsSpontaneous() ? ((ETAS_EqkRupture)catalog.get(0)).getID() - 1 : numTriggerRuptures - 1;
            parentIDs = new int[maxParentID + 1];
            for (int i = 0; i <= maxParentID; ++i) {
                parentIDs[i] = i;
            }
        }
        return ETAS_SimAnalysisTools.getChildrenFromCatalog(catalog, parentIDs);
    }

    private static Options createOptions() {
        Options ops = new Options();
        Option threadsOption = new Option("t", "threads", true, "Number of calculation threads. Default is the calculated from max JVM memory (set via -Xmx) and the number of available processors (in this case: " + ETAS_Launcher.defaultNumThreads() + ")");
        threadsOption.setRequired(false);
        ops.addOption(threadsOption);
        Option dateLastDebugOption = new Option("d", "date-last-debug", false, "Flag to print out date of last event data for debugging");
        dateLastDebugOption.setRequired(false);
        ops.addOption(dateLastDebugOption);
        return ops;
    }

    public static void main(String[] args) throws IOException {
        CommandLine cmd;
        if (args.length == 1 && args[0].equals("--hardcoded")) {
            String argsStr = "--threads 1 /home/kevin/OpenSHA/UCERF3/etas/simulations/2019_10_16-Start1919_100yr_Spontaneous_HistoricalCatalog/config.json";
            args = argsStr.split(" ");
        }
        System.setProperty("java.awt.headless", "true");
        Options options = ETAS_Launcher.createOptions();
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(ClassUtils.getClassNameWithoutPackage(ETAS_Launcher.class), options, true);
            System.exit(2);
            return;
        }
        args = cmd.getArgs();
        if (args.length != 1) {
            System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(ETAS_Launcher.class) + " [options] <conf-file.json>");
            System.exit(2);
        }
        File confFile = new File(args[0]);
        Preconditions.checkArgument((boolean)confFile.exists(), (Object)("configuration file doesn't exist: " + confFile.getAbsolutePath()));
        ETAS_Config config = ETAS_Config.readJSON(confFile);
        ETAS_Launcher launcher = new ETAS_Launcher(config);
        launcher.dateLastDebug = cmd.hasOption("date-last-debug");
        if (cmd.hasOption("threads")) {
            int numThreads = Integer.parseInt(cmd.getOptionValue("threads"));
            launcher.calculateAll(numThreads);
        } else {
            launcher.calculateAll();
        }
    }

    public static enum DebugLevel {
        ERROR(0),
        INFO(1),
        FINE(2),
        DEBUG(3);

        private int val;

        private DebugLevel(int val) {
            this.val = val;
        }

        boolean shouldPrint(DebugLevel o) {
            return o.val <= this.val;
        }
    }

    private class CalcRunnable
    implements Callable<Integer> {
        private final int index;
        private long randSeed;
        private final boolean binaryPreStage;

        public CalcRunnable(int index, long randSeed, boolean binaryPreStage) {
            Preconditions.checkArgument((index >= 0 ? 1 : 0) != 0);
            this.index = index;
            this.randSeed = randSeed;
            this.binaryPreStage = binaryPreStage;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * WARNING - void declaration
         */
        @Override
        public Integer call() {
            FaultSystemSolution sol;
            File resultsDir = ETAS_Launcher.this.getResultsDir(this.index);
            File tempResultsDir = ETAS_Launcher.this.getTempResultsDir(this.index);
            if (!ETAS_Launcher.this.config.isForceRecalc() && ETAS_Launcher.isAlreadyDone(resultsDir)) {
                ETAS_Launcher.this.debug(this.index + " is already done: " + resultsDir.getName());
                if (this.binaryPreStage && ETAS_Launcher.this.config.hasBinaryOutputFilters()) {
                    boolean alreadyStaged = true;
                    for (ETAS_Config.BinaryFilteredOutputConfig binaryConf : ETAS_Launcher.this.config.getBinaryOutputFilters()) {
                        if (binaryConf.getPreStagedCatalogFile(resultsDir).exists()) continue;
                        alreadyStaged = false;
                        break;
                    }
                    if (!alreadyStaged) {
                        ETAS_Launcher.this.debug("loading " + this.index + " in order to pre-stage");
                        try {
                            File catalogFile = ETAS_BinaryWriter.locateCatalogFile(resultsDir);
                            ETAS_CatalogIO.ETAS_Catalog catalog = ETAS_CatalogIO.loadCatalog(catalogFile);
                            ETAS_Launcher.this.preStage(this.index, catalog, resultsDir);
                        }
                        catch (Exception e) {
                            e.printStackTrace();
                            ETAS_Launcher.this.debug("exception pre-staging " + this.index + ": " + e.getMessage());
                        }
                    }
                }
                return this.index;
            }
            if (!resultsDir.exists()) {
                resultsDir.mkdir();
            }
            ETAS_Launcher.waitOnDirCreation(tempResultsDir, 5, 2000L);
            ETAS_Launcher.this.debug("calculating " + this.index);
            ETAS_Launcher.this.debug("Instantiating ERF");
            AbstractNthRupERF erf = ETAS_Launcher.this.checkOutERF();
            FaultSystemSolution faultSystemSolution = sol = ETAS_Launcher.this.config.isGriddedOnly() ? null : ((FaultSystemSolutionERF_ETAS)erf).getSolution();
            if (this.index == 0 && ETAS_Launcher.this.dateLastDebug && sol != null) {
                ETAS_Launcher.this.debug(DebugLevel.INFO, "Date of last event information:");
                HashMap<Object, ArrayList<FaultSection>> lastEventSects = new HashMap<Object, ArrayList<FaultSection>>();
                for (FaultSection faultSection : sol.getRupSet().getFaultSectionDataList()) {
                    Long dateLast = faultSection.getDateOfLastEvent();
                    if (dateLast <= Long.MIN_VALUE) continue;
                    ArrayList<FaultSection> sects = (ArrayList<FaultSection>)lastEventSects.get(dateLast);
                    if (sects == null) {
                        sects = new ArrayList<FaultSection>();
                        lastEventSects.put(dateLast, sects);
                    }
                    sects.add(faultSection);
                }
                ArrayList allTimes = new ArrayList(lastEventSects.keySet());
                Collections.sort(allTimes);
                SimpleDateFormat simpleDateFormat = new SimpleDateFormat("yyyy/MM/dd hh:mm:ss.SSS z");
                for (Long time : allTimes) {
                    GregorianCalendar cal = new GregorianCalendar(TimeZone.getTimeZone("UTC"));
                    long timeDelta = ETAS_Launcher.this.simulationOT - time;
                    double timeDeltaYears = (double)timeDelta / 3.15576E10;
                    cal.setTimeInMillis(time);
                    String timeStr = simpleDateFormat.format(cal.getTime());
                    ETAS_Launcher.this.debug(DebugLevel.INFO, time + ": " + timeStr + " (" + ETAS_AbstractPlot.getTimeShortLabel(timeDeltaYears) + " before simulation start)");
                    for (FaultSection sect : (List)lastEventSects.get(time)) {
                        ETAS_Launcher.this.debug(DebugLevel.INFO, "\t" + sect.getName());
                    }
                }
                ETAS_Launcher.this.debug(DebugLevel.INFO, "Sim start: " + ETAS_Launcher.this.simulationOT + ": " + simpleDateFormat.format(new Date(ETAS_Launcher.this.simulationOT)));
            }
            ETAS_Launcher.this.debug("Done instantiating ERF");
            if (ETAS_Launcher.this.config.getRandomSeed() == null) {
                Long prevRandSeed;
                try {
                    prevRandSeed = ETAS_Launcher.getPrevRandSeed(tempResultsDir);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                if (prevRandSeed != null) {
                    this.randSeed = prevRandSeed;
                    ETAS_Launcher.this.debug("Resuming old rand seed of " + this.randSeed + " for " + tempResultsDir.getName());
                }
            }
            boolean success = false;
            int attempts = 0;
            Object var7_16 = null;
            int retries = ETAS_Launcher.this.config.getNumRetries();
            if (retries < 1) {
                retries = 1;
            }
            while (!success && attempts < retries) {
                ++attempts;
                try {
                    ETAS_SimulationMetadata meta;
                    List<ETAS_EqkRupture> histQkList = ETAS_Launcher.this.threadSafeInputs(ETAS_Launcher.this.getHistQkList());
                    List<ETAS_EqkRupture> triggers = ETAS_Launcher.this.threadSafeInputs(ETAS_Launcher.this.getTriggerRuptures());
                    if (ETAS_Launcher.this.config.isGriddedOnly()) {
                        meta = ETAS_Simulator_NoFaults.runETAS_Simulation(tempResultsDir, (AbstractNthRupERF)((UCERF3_GriddedSeisOnlyERF_ETAS)erf), ETAS_Launcher.this.griddedRegion, triggers, histQkList, ETAS_Launcher.this.config.isIncludeSpontaneous(), ETAS_Launcher.this.config.isIncludeIndirectTriggering(), ETAS_Launcher.this.config.getGridSeisDiscr(), ETAS_Launcher.this.simulationName, (Long)this.randSeed, ETAS_Launcher.this.params, ETAS_Launcher.this.cubeParams);
                    } else {
                        ETAS_Launcher.this.checkLoadCaches((FaultSystemSolutionERF_ETAS)erf);
                        meta = ETAS_Simulator.runETAS_Simulation(tempResultsDir, (AbstractNthRupERF)((FaultSystemSolutionERF_ETAS)erf), ETAS_Launcher.this.griddedRegion, triggers, histQkList, ETAS_Launcher.this.config.isIncludeSpontaneous(), ETAS_Launcher.this.config.isIncludeIndirectTriggering(), ETAS_Launcher.this.config.getGridSeisDiscr(), ETAS_Launcher.this.simulationName, (Long)this.randSeed, ETAS_Launcher.this.fractionSrcAtPointList, ETAS_Launcher.this.srcAtPointList, ETAS_Launcher.this.isCubeInsideFaultPolygon, ETAS_Launcher.this.params, ETAS_Launcher.this.cubeParams, ETAS_Launcher.this.longTermMFDs);
                    }
                    meta = meta.getModCatalogIndex(this.index);
                    ETAS_Launcher.this.debug("completed " + this.index + " (" + meta.totalNumRuptures + " ruptures)");
                    File asciiFile = new File(tempResultsDir, "simulatedEvents.txt");
                    ETAS_CatalogIO.ETAS_Catalog catalog = null;
                    ETAS_Launcher.waitOnDirCreation(resultsDir, 5, 2000L);
                    if (ETAS_Launcher.this.config.isBinaryOutput()) {
                        catalog = ETAS_CatalogIO.loadCatalog(asciiFile);
                        catalog.setSimulationMetadata(meta);
                        File binaryFile = new File(resultsDir, "simulatedEvents.bin");
                        ETAS_CatalogIO.writeCatalogBinary(binaryFile, (List<ETAS_EqkRupture>)catalog);
                        if (binaryFile.length() > 0L) {
                            asciiFile.delete();
                        } else {
                            binaryFile.delete();
                        }
                        ETAS_Launcher.this.debug("completed binary output " + this.index);
                    } else if (!tempResultsDir.equals(resultsDir)) {
                        File newAscii = new File(resultsDir, asciiFile.getName());
                        Files.copy((File)asciiFile, (File)newAscii);
                        File infoString = new File(tempResultsDir, "infoString.txt");
                        if (infoString.exists()) {
                            Files.copy((File)infoString, (File)new File(resultsDir, infoString.getName()));
                        }
                        if (newAscii.length() > 0L) {
                            asciiFile.delete();
                            asciiFile = newAscii;
                        } else {
                            newAscii.delete();
                        }
                    }
                    if (this.binaryPreStage) {
                        if (catalog == null) {
                            catalog = ETAS_CatalogIO.loadCatalog(asciiFile);
                        }
                        ETAS_Launcher.this.preStage(this.index, catalog, resultsDir);
                    }
                    success = true;
                }
                catch (Throwable t) {
                    if (t instanceof OutOfMemoryError && ETAS_Launcher.this.exec != null) {
                        ThreadPoolExecutor threadPoolExecutor = ETAS_Launcher.this.exec;
                        synchronized (threadPoolExecutor) {
                            if (!ETAS_Launcher.this.exec.isShutdown() && ETAS_Launcher.this.exec.getMaximumPoolSize() > 1) {
                                int newThreads = ETAS_Launcher.this.exec.getMaximumPoolSize() > 10 ? ETAS_Launcher.this.exec.getMaximumPoolSize() - 2 : ETAS_Launcher.this.exec.getMaximumPoolSize() - 1;
                                ETAS_Launcher.this.threadLimit = Integer.max(1, newThreads);
                                ETAS_Launcher.this.debug(DebugLevel.ERROR, "Calc ran out of memory, reducing numThreads to " + ETAS_Launcher.this.threadLimit);
                                ETAS_Launcher.this.updateExecutorNumThreads(ETAS_Launcher.this.threadLimit);
                                throw (OutOfMemoryError)t;
                            }
                        }
                    }
                    Throwable throwable = t;
                    ETAS_Launcher.this.debug(DebugLevel.ERROR, "Calc failed with seed " + this.randSeed + ". Exception: " + String.valueOf(t));
                    t.printStackTrace();
                    if (t.getCause() != null) {
                        System.err.println("cause exception:");
                        t.getCause().printStackTrace();
                    }
                    System.err.flush();
                }
            }
            if (ETAS_Launcher.this.config.isReuseERFs()) {
                ETAS_Launcher.this.checkInERF(erf);
            } else if (sol != null) {
                ETAS_Launcher.this.checkInFSS(sol);
            }
            if (!success) {
                void var7_17;
                Preconditions.checkState((var7_17 != null ? 1 : 0) != 0);
                ETAS_Launcher.this.debug("Index " + this.index + " failed " + attempts + " times, bailing");
                ExceptionUtils.throwAsRuntimeException((Throwable)var7_17);
            }
            return this.index;
        }
    }

    private class FutureContainer {
        CalcRunnable task;
        Future<Integer> future;

        public FutureContainer(CalcRunnable task, Future<Integer> future) {
            this.task = task;
            this.future = future;
        }
    }
}

