/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.gson.Gson;
import com.google.gson.GsonBuilder;
import com.google.gson.stream.JsonReader;
import com.google.gson.stream.JsonWriter;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.lang.invoke.CallSite;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.TimeZone;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensha.commons.data.comcat.ComcatAccessor;
import org.opensha.commons.data.comcat.ComcatInvertedFiniteFault;
import org.opensha.commons.data.comcat.ComcatInvertedFiniteFaultAccessor;
import org.opensha.commons.data.comcat.ComcatRegion;
import org.opensha.commons.data.comcat.ComcatRegionAdapter;
import org.opensha.commons.data.comcat.ShakeMapFiniteFaultAccessor;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.DataUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.MarkdownUtils;
import org.opensha.sha.earthquake.EqkRupture;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupList;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_TriggerRuptureFaultDistancesPlot;
import scratch.UCERF3.erf.ETAS.analysis.SimulationMarkdownGenerator;
import scratch.UCERF3.erf.ETAS.association.FiniteFaultSectionResetCalc;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.ETAS.launcher.TriggerRupture;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_ComcatEventFetcher;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_ConfigBuilder;

public abstract class ETAS_AbstractComcatConfigBuilder
extends ETAS_ConfigBuilder {
    protected static double SHAKEMAP_MIN_MAG_DEFAULT = 5.0;
    protected static double INVERSION_MIN_MAG_DEFAULT = 5.0;
    protected static String historicalEndDate = "2012-04-24T19:44:19";
    protected static SimpleDateFormat argDateFormat = new SimpleDateFormat("yyyy-MM-dd");
    protected static SimpleDateFormat argDateTimeFormat = new SimpleDateFormat("yyyy-MM-dd'T'HH:mm:ss");
    protected String[] args;
    protected CommandLine cmd;
    protected ComcatAccessor accessor;
    private String primaryEventID;
    protected ObsEqkRupture primaryRupture;
    protected Double minMag;
    private Region region;
    private List<RuptureBuilder> ruptureBuilders;
    private Map<String, int[]> resetSectsMap;
    private ObsEqkRupList comcatEvents;
    private File configFile;
    protected ETAS_Config config;
    private File outputDir;
    public static boolean CACHE_TRIGGER_RUPS;
    private static HashMap<String, TriggerRupture> triggerRupCache;

    protected long parseDateString(String dateStr) {
        try {
            if (dateStr.contains("T")) {
                return argDateTimeFormat.parse(dateStr).getTime();
            }
            return argDateFormat.parse(dateStr).getTime();
        }
        catch (ParseException e) {
            throw ExceptionUtils.asRuntimeException(e);
        }
    }

    public static Options getCommonOptions() {
        Options ops = ETAS_ConfigBuilder.getCommonOptions();
        Option minDepthOption = new Option("mind", "min-depth", true, "Min depth (km) considered for ComCat events (default: -10)");
        minDepthOption.setRequired(false);
        ops.addOption(minDepthOption);
        Option maxDepthOption = new Option("maxd", "max-depth", true, "Max depth (km) considered for ComCat events (default: is 24.0 km, or in event mode the larger of 24.0 km and twice the hypocentral depth of the primary event)");
        maxDepthOption.setRequired(false);
        ops.addOption(maxDepthOption);
        Option minMagOption = new Option("minm", "min-mag", true, "Minimum magnitude event from ComCat (default: 2.5)");
        minMagOption.setRequired(false);
        ops.addOption(minMagOption);
        Option comcatFileOption = new Option("ccfile", "comcat-file", true, "Comcat file to use instead of accessing ComCat directly");
        comcatFileOption.setRequired(false);
        ops.addOption(comcatFileOption);
        Option finiteSurfShakeMap = new Option("fssm", "finite-surf-shakemap", false, "Fetch finite surfaces from ShakeMap when available. In event mode, applies only to the specified event by default. In region/swarm mode, applies to all events with M>=" + (float)SHAKEMAP_MIN_MAG_DEFAULT + ". Supply --finite-surf-shakemap-min-mag to override this behavior and specify a minimum magnitude above which to always look for shakemap surfaces.");
        finiteSurfShakeMap.setRequired(false);
        ops.addOption(finiteSurfShakeMap);
        Option finiteSurfShakeMapPlanar = new Option("fssmp", "finite-surf-shakemap-planar-extents", false, "Flag to build a planar surface based off of the extents (min & max lat, lon, depth) instead of using the actual surface");
        finiteSurfShakeMapPlanar.setRequired(false);
        ops.addOption(finiteSurfShakeMapPlanar);
        Option finiteSurfShakeMapMag = new Option("fssmmm", "finite-surf-shakemap-min-mag", true, "Minimum magnitude above which to search for shakemap finite surfaces. Must also supply --finite-surf-shakemap option");
        finiteSurfShakeMapMag.setRequired(false);
        ops.addOption(finiteSurfShakeMapMag);
        Option finiteSurfShakeMapVersion = new Option("fssmv", "finite-surf-shakemap-version", true, "ShakeMap source Version number to use for individual events with the format --finite-surf-shakemap-version  <event-id>:<version>, e.g. --finite-surf-shakemap-version ci38457511:10. In event mode, you can omit the event ID to override the version of the mainshock. You can also chain multiple arguments as --finite-surf-shakemap-version <event1>:<version> --finite-surf-shakemap-version <event2>:<version>. Must also supply --finite-surf-shakemap option");
        finiteSurfShakeMapVersion.setRequired(false);
        ops.addOption(finiteSurfShakeMapVersion);
        Option finiteSurfInversion = new Option("fsi", "finite-surf-inversion", false, "Fetch inverted finite surfaces from ComCat when available. In event mode, applies only to the specified event by default. In region/swarm mode, applies to all events with M>=" + (float)INVERSION_MIN_MAG_DEFAULT + ". Supply --finite-surf-inversion-min-mag to override this behavior and specify a minimum magnitude above which to always look for inverted surfaces. ");
        finiteSurfInversion.setRequired(false);
        ops.addOption(finiteSurfInversion);
        Option finiteSurfInversionMag = new Option("fsimm", "finite-surf-inversion-min-mag", true, "Minimum magnitude above which to search for inverted finite surfaces. Must also supply --finite-surf-inversion option");
        finiteSurfInversionMag.setRequired(false);
        ops.addOption(finiteSurfInversionMag);
        Option finiteSurfInversionSlip = new Option("fsis", "finite-surf-inversion-min-slip", true, "Minimum slip on each patch for inverted fault surface for inclusion in ETAS rupture surface. Must also supply --finite-surf-inversion option");
        finiteSurfInversionSlip.setRequired(false);
        ops.addOption(finiteSurfInversionSlip);
        ops.addOption(null, "finite-surf-cache", true, "Path to cache directory to store finite surface representations to avoid repeated HTTP requests. If you use this option and change finite surface parameterizations between runs, be sure to clear the cache.");
        Option kOption = new Option("mek", "event-etas-k", true, "Mainshock-specific ETAS productivity parameter parameter, k, in Log10 units, with the format --event-etas-k <event-id>:<value>. In event mode, you can omit the '<event-id>:' to specify a value for the primary event.");
        kOption.setRequired(false);
        ops.addOption(kOption);
        Option pOption = new Option("mep", "event-etas-p", true, "Mainshock-specific ETAS temporal decay paramter, p, with the format --event-etas-p <event-id>:<value>. In event mode, you can omit the '<event-id>:' to specify a value for the primary event.");
        pOption.setRequired(false);
        ops.addOption(pOption);
        Option cOption = new Option("mec", "event-etas-c", true, "Mainshock-specific ETAS minimum time paramter, c, with the format --event-etas-c <event-id>:<value>. In event mode, you can omit the '<event-id>:' to specify a value for the primary event.");
        cOption.setRequired(false);
        ops.addOption(cOption);
        Option modMagOption = new Option("mm", "mod-mag", true, "Modify the magnitude of a specific event with the format --mod-mag <event-id>:<mag>, e.g. --mod-mag ci38443183:6.48. In event mode, you can omit the event ID to override the magnitude of the mainshock. You can also chain multiple arguments as --mod-mag <arg1> --mod-mag <arg2>");
        modMagOption.setRequired(false);
        ops.addOption(modMagOption);
        Option finiteResetSects = new Option("rs", "reset-sects", true, "UCERF3 sub-section indices to reset (elastic rebound) with the format --reset-sects <event-id>:<sect1>,<sect2>,<sectN>. In event mode, you can omit the '<event-id>:' to specify a value for the primary event.");
        finiteResetSects.setRequired(false);
        ops.addOption(finiteResetSects);
        Option finiteSurfFromSects = new Option("fsfs", "finite-surf-from-sections", false, "If supplied, finite rupture surface will be constructed from the fault sections specified with --reset-sections");
        finiteSurfFromSects.setRequired(false);
        ops.addOption(finiteSurfFromSects);
        Option mcOption = new Option("mc", "mag-complete", true, "Magnitude of Completeness for evaluation plots");
        mcOption.setRequired(false);
        ops.addOption(mcOption);
        Option skipPlotsOption = new Option("skpl", "skip-input-plots", false, "Flag to skip input plots");
        skipPlotsOption.setRequired(false);
        ops.addOption(skipPlotsOption);
        return ops;
    }

    protected static LocationList[] getPlanarExtentsSurface(LocationList[] rawSurf) {
        double endLon;
        double startLon;
        DataUtils.MinMaxAveTracker latTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker lonTrack = new DataUtils.MinMaxAveTracker();
        DataUtils.MinMaxAveTracker depthTrack = new DataUtils.MinMaxAveTracker();
        for (LocationList surf : rawSurf) {
            for (Location loc : surf) {
                latTrack.addValue(loc.getLatitude());
                lonTrack.addValue(loc.getLongitude());
                depthTrack.addValue(loc.getDepth());
            }
        }
        Location bottomLeft = new Location(latTrack.getMin(), lonTrack.getMin());
        Location bottomRight = new Location(latTrack.getMin(), lonTrack.getMax());
        double distFromBottomLeft = 0.0;
        double distFromBottomRight = 0.0;
        for (LocationList surf : rawSurf) {
            for (Location loc : surf) {
                distFromBottomLeft += LocationUtils.horzDistanceFast(loc, bottomLeft);
                distFromBottomRight += LocationUtils.horzDistanceFast(loc, bottomRight);
            }
        }
        LocationList extents = new LocationList();
        double startLat = latTrack.getMin();
        double endLat = latTrack.getMax();
        if (distFromBottomLeft < distFromBottomRight) {
            startLon = lonTrack.getMin();
            endLon = lonTrack.getMax();
        } else {
            startLon = lonTrack.getMax();
            endLon = lonTrack.getMin();
        }
        double startDepth = depthTrack.getMin();
        double endDepth = depthTrack.getMax();
        extents.add(new Location(startLat, startLon, startDepth));
        extents.add(new Location(endLat, endLon, startDepth));
        extents.add(new Location(endLat, endLon, endDepth));
        extents.add(new Location(startLat, startLon, endDepth));
        extents.add(new Location(startLat, startLon, startDepth));
        return new LocationList[]{extents};
    }

    public ETAS_AbstractComcatConfigBuilder(String[] args, Options options) {
        this.args = args;
        DefaultParser parser = new DefaultParser();
        try {
            this.cmd = parser.parse(options, args);
        }
        catch (org.apache.commons.cli.ParseException e) {
            e.printStackTrace();
            HelpFormatter formatter = new HelpFormatter();
            formatter.setWidth(150);
            formatter.printHelp(ClassUtils.getClassNameWithoutPackage(this.getClass()), options, true);
            System.exit(2);
            return;
        }
        this.accessor = new ComcatAccessor();
    }

    private Map<String, int[]> getResetSectsMap() {
        if (this.resetSectsMap != null && this.cmd.hasOption("reset-sects")) {
            Map<String, String> resetSectsStrMap = ETAS_AbstractComcatConfigBuilder.getEventSpecificOptions(this.cmd, "reset-sects", this.primaryEventID);
            this.resetSectsMap = new HashMap<String, int[]>();
            for (String key : resetSectsStrMap.keySet()) {
                String val = resetSectsStrMap.get(key);
                if (val.contains(",")) {
                    String[] split = val.split(",");
                    int[] ids = new int[split.length];
                    for (int i = 0; i < ids.length; ++i) {
                        ids[i] = Integer.parseInt(split[i]);
                    }
                    this.resetSectsMap.put(key, ids);
                    continue;
                }
                this.resetSectsMap.put(key, new int[]{Integer.parseInt(val)});
            }
        }
        return this.resetSectsMap;
    }

    /*
     * WARNING - void declaration
     */
    public void buildConfiguration() throws IOException {
        Object name;
        long comcatEndTime;
        long comcatStartTime;
        Double maxDepth;
        this.primaryEventID = this.getPrimaryEventID();
        if (this.primaryEventID != null) {
            this.primaryRupture = this.accessor.fetchEvent(this.primaryEventID, false);
            Location hypo = this.primaryRupture.getHypocenterLocation();
            System.out.println("Found event " + this.primaryEventID + " with M=" + (float)this.primaryRupture.getMag() + " and Hypocenter=[" + String.valueOf(hypo) + "] at " + this.primaryRupture.getOriginTime());
        }
        this.initRuptureBuilders(this.cmd, this.primaryEventID);
        Map<String, Double> modMags = ETAS_AbstractComcatConfigBuilder.getEventSpecificDoubleOptions(this.cmd, "mod-mag", this.primaryEventID);
        Map<String, Double> modK = ETAS_AbstractComcatConfigBuilder.getEventSpecificDoubleOptions(this.cmd, "event-etas-k", this.primaryEventID);
        Map<String, Double> modP = ETAS_AbstractComcatConfigBuilder.getEventSpecificDoubleOptions(this.cmd, "event-etas-p", this.primaryEventID);
        Map<String, Double> modC = ETAS_AbstractComcatConfigBuilder.getEventSpecificDoubleOptions(this.cmd, "event-etas-c", this.primaryEventID);
        Map<String, int[]> resetSectsMap = this.getResetSectsMap();
        TriggerRupture primaryTrigger = null;
        if (this.primaryRupture != null) {
            primaryTrigger = this.buildRupture(modMags, modK, modP, modC, resetSectsMap, this.primaryRupture);
        }
        this.region = this.buildRegion(this.primaryRupture, primaryTrigger);
        this.minMag = ETAS_AbstractComcatConfigBuilder.doubleArgIfPresent(this.cmd, "min-mag");
        if (this.minMag == null) {
            this.minMag = 2.5;
        } else {
            Preconditions.checkArgument((this.minMag >= 2.5 ? 1 : 0) != 0, (Object)"Cannot include ruptures below M=2.5");
        }
        Double minDepth = ETAS_AbstractComcatConfigBuilder.doubleArgIfPresent(this.cmd, "min-depth");
        if (minDepth == null) {
            minDepth = -10.0;
        }
        if ((maxDepth = ETAS_AbstractComcatConfigBuilder.doubleArgIfPresent(this.cmd, "max-depth")) == null) {
            maxDepth = 24.0;
            if (this.primaryRupture != null) {
                maxDepth = Math.max(maxDepth, 2.0 * this.primaryRupture.getHypocenterLocation().getDepth());
            }
        }
        Preconditions.checkState(((comcatStartTime = this.getComCatStartTime()) <= (comcatEndTime = this.getComCatEndTime()) ? 1 : 0) != 0, (String)"ComCat start time must be before (or equal to) end time: start=%s, end=%s", (long)comcatStartTime, (long)comcatEndTime);
        if (comcatStartTime == comcatEndTime) {
            Preconditions.checkState((this.primaryRupture != null ? 1 : 0) != 0, (String)"ComCat start and end times are identical (%s), but no primary rupture supplied!", (long)comcatStartTime);
            this.comcatEvents = new ObsEqkRupList();
        } else if (this.cmd.hasOption("comcat-file")) {
            ObsEqkRupList allComcatEvents;
            try {
                allComcatEvents = ETAS_ComcatEventFetcher.loadCatalogFile(ETAS_Config.resolvePath(this.cmd.getOptionValue("comcat-file")));
            }
            catch (Exception e) {
                if (e instanceof IOException) {
                    throw (IOException)e;
                }
                throw ExceptionUtils.asRuntimeException(e);
            }
            this.comcatEvents = new ObsEqkRupList();
            for (ObsEqkRupture rup : allComcatEvents) {
                if (rup.getOriginTime() < comcatStartTime || rup.getOriginTime() > comcatEndTime) continue;
                this.comcatEvents.add(rup);
            }
            System.out.println("Retained " + this.comcatEvents.size() + " of " + allComcatEvents.size() + " events from input file");
        } else {
            ComcatRegion cReg = this.region instanceof ComcatRegion ? (ComcatRegion)((Object)this.region) : new ComcatRegionAdapter(this.region);
            this.comcatEvents = this.accessor.fetchEventList(this.primaryEventID, comcatStartTime, comcatEndTime, minDepth, maxDepth, cReg, false, false, this.minMag);
            System.out.println("Fetched " + this.comcatEvents.size() + " events from ComCat");
        }
        if (this.primaryRupture != null) {
            this.comcatEvents.add(this.primaryRupture);
        }
        this.comcatEvents.sortByOriginTime();
        if (this.comcatEvents.size() == 1) {
            ObsEqkRupture event = (ObsEqkRupture)this.comcatEvents.get(0);
            System.out.println("\tSingle event: " + event.getEventId() + ", M" + (float)event.getMag());
        } else if (this.comcatEvents.size() > 1) {
            ObsEqkRupture first = (ObsEqkRupture)this.comcatEvents.get(0);
            ObsEqkRupture last = (ObsEqkRupture)this.comcatEvents.get(this.comcatEvents.size() - 1);
            Object largest = first;
            for (Object rup : this.comcatEvents) {
                if (!(((EqkRupture)rup).getMag() > ((EqkRupture)largest).getMag())) continue;
                largest = rup;
            }
            System.out.println("\tFirst event: " + first.getEventId() + ", M" + (float)first.getMag());
            System.out.println("\tLast event: " + last.getEventId() + ", M" + (float)last.getMag());
            System.out.println("\tLargest event: " + ((ObsEqkRupture)largest).getEventId() + ", M" + (float)((EqkRupture)largest).getMag());
        } else {
            System.out.println("\tNo Events Found");
        }
        System.out.println("Building trigger ruptures for " + this.comcatEvents.size() + " events");
        long lastInputTime = Long.MIN_VALUE;
        ArrayList<TriggerRupture> triggerRuptures = new ArrayList<TriggerRupture>();
        HashSet<String> prevIDs = new HashSet<String>();
        for (ObsEqkRupture eq : this.comcatEvents) {
            Preconditions.checkState((!prevIDs.contains(eq.getEventId()) ? 1 : 0) != 0, (String)"Duplicate event found: %s", (Object)eq.getEventId());
            prevIDs.add(eq.getEventId());
            TriggerRupture triggerRup = eq.getEventId().equals(this.primaryEventID) ? primaryTrigger : this.buildRupture(modMags, modK, modP, modC, resetSectsMap, eq);
            triggerRuptures.add(triggerRup);
            lastInputTime = Long.max(lastInputTime, eq.getOriginTime());
        }
        long simulationStartTime = this.getSimulationStartTime(comcatStartTime, comcatEndTime);
        Preconditions.checkState((lastInputTime < simulationStartTime ? 1 : 0) != 0, (String)"Last input event time (%s) is after simulation start time (%s)? ", (long)lastInputTime, (long)simulationStartTime);
        if (this.cmd.hasOption("name")) {
            Preconditions.checkArgument((!this.cmd.hasOption("name-add") ? 1 : 0) != 0, (Object)"Can't supply both --name and --name-add");
            name = this.cmd.getOptionValue("name");
        } else {
            List<String> nonDefaultOptions;
            name = this.getBaseSimName();
            HashSet<String> modParamIDs = new HashSet<String>();
            if (modK != null) {
                modParamIDs.addAll(modK.keySet());
            }
            if (modP != null) {
                modParamIDs.addAll(modP.keySet());
            }
            if (modC != null) {
                modParamIDs.addAll(modC.keySet());
            }
            if (!modParamIDs.isEmpty()) {
                if (modParamIDs.size() == 1 || modParamIDs.contains(this.primaryEventID)) {
                    Double ms_c;
                    Object id;
                    if (modParamIDs.contains(this.primaryEventID)) {
                        id = this.primaryEventID;
                        name = (String)name + ", Mainshock ";
                    } else {
                        id = (String)modParamIDs.iterator().next();
                        name = (String)name + ", Mod " + (String)id + " ";
                    }
                    ArrayList<CallSite> arrayList = new ArrayList<CallSite>();
                    Double ms_log10_k = modK != null ? modK.get(id) : null;
                    Double ms_p = modP != null ? modP.get(id) : null;
                    Double d = ms_c = modC != null ? modC.get(id) : null;
                    if (ms_log10_k != null) {
                        arrayList.add((CallSite)((Object)("Log10(k)=" + ms_log10_k.floatValue())));
                    }
                    if (ms_p != null) {
                        arrayList.add((CallSite)((Object)("p=" + ms_p.floatValue())));
                    }
                    if (ms_c != null) {
                        arrayList.add((CallSite)((Object)("c=" + ms_c.floatValue())));
                    }
                    name = (String)name + Joiner.on((String)",").join(arrayList);
                } else {
                    name = (String)name + ", " + modParamIDs.size() + " Events Mod Params";
                }
            }
            for (RuptureBuilder ruptureBuilder : this.ruptureBuilders) {
                String str = ruptureBuilder.getDisplayName(triggerRuptures.size());
                if (str == null) continue;
                name = (String)name + ", " + str;
            }
            if (modMags != null && !modMags.isEmpty()) {
                if (modMags.size() == 1 && modMags.keySet().iterator().next().equals(this.primaryEventID)) {
                    name = (String)name + ", Mod Mag M" + modMags.get(this.primaryEventID).floatValue();
                } else {
                    boolean first = true;
                    name = (String)name + ", Mod Mag ";
                    for (String id : modMags.keySet()) {
                        if (first) {
                            first = false;
                        } else {
                            name = (String)name + ",";
                        }
                        name = (String)name + id + "=M" + modMags.get(id).floatValue();
                    }
                }
            }
            if ((nonDefaultOptions = ETAS_AbstractComcatConfigBuilder.getNonDefaultOptionsStrings(this.cmd)) != null && !nonDefaultOptions.isEmpty()) {
                name = (String)name + ", " + Joiner.on((String)", ").join(nonDefaultOptions);
            }
            if (this.cmd.hasOption("name-add")) {
                void var22_32;
                String string = this.cmd.getOptionValue("name-add");
                if (!string.startsWith(",")) {
                    String string2 = ", " + string;
                }
                name = (String)name + (String)var22_32;
            }
        }
        String configCommand = this.getScriptName() + " " + Joiner.on((String)" ").join((Object[])this.args);
        this.config = ETAS_AbstractComcatConfigBuilder.buildBasicConfig(this.cmd, (String)name, triggerRuptures, configCommand);
        this.config.setStartTimeMillis(simulationStartTime);
        ETAS_Config.ComcatMetadata meta = new ETAS_Config.ComcatMetadata(this.region, this.primaryEventID, minDepth, maxDepth, this.minMag, comcatStartTime, comcatEndTime);
        if (this.cmd.hasOption("mag-complete")) {
            meta.magComplete = Double.parseDouble(this.cmd.getOptionValue("mag-complete"));
        }
        this.config.setComcatMetadata(meta);
        this.outputDir = this.config.getOutputDir();
        System.out.println("Output dir: " + this.outputDir.getPath());
        File file = new File(this.outputDir, "config.json");
        this.configFile = ETAS_Config.resolvePath(file);
        File resolved = ETAS_Config.resolvePath(this.outputDir);
        if (!resolved.equals(this.outputDir)) {
            System.out.println("Resolved output dir: " + resolved.getAbsolutePath());
        }
        this.outputDir = resolved;
        Preconditions.checkState((this.outputDir.exists() || this.outputDir.mkdir() ? 1 : 0) != 0, (String)"Output directory does not exist and cannot be created: %s", (Object)this.outputDir.getAbsolutePath());
        if (this.configFile.exists()) {
            System.err.println("WARNING: overwriting previous configuration file");
        }
        this.config.writeJSON(this.configFile);
        ETAS_AbstractComcatConfigBuilder.checkWriteHPC(this.config, file, this.cmd);
    }

    TriggerRupture buildRupture(Map<String, Double> modMags, Map<String, Double> modK, Map<String, Double> modP, Map<String, Double> modC, Map<String, int[]> resetSectsMap, ObsEqkRupture eq) {
        Double etasC;
        if (CACHE_TRIGGER_RUPS && triggerRupCache.containsKey(eq.getEventId())) {
            return triggerRupCache.get(eq.getEventId());
        }
        if (modMags != null && modMags.containsKey(eq.getEventId())) {
            double mag = modMags.get(eq.getEventId());
            System.out.println("Overriding magnitude of " + eq.getEventId() + " from " + (float)eq.getMag() + " to " + (float)mag);
            eq.setMag(mag);
        }
        int[] resetSubSects = resetSectsMap == null ? null : resetSectsMap.get(eq.getEventId());
        TriggerRupture triggerRup = null;
        CachedRuptureBuilder cachedBuilder = null;
        for (RuptureBuilder builder : this.ruptureBuilders) {
            if (!(builder instanceof CachedRuptureBuilder)) continue;
            cachedBuilder = (CachedRuptureBuilder)builder;
        }
        for (RuptureBuilder builder : this.ruptureBuilders) {
            triggerRup = builder.build(eq, resetSubSects);
            if (triggerRup == null) continue;
            if (eq.getEventId().equals(this.primaryEventID)) {
                System.out.println("Primary rupture type: " + ClassUtils.getClassNameWithoutPackage(triggerRup.getClass()));
            }
            if (cachedBuilder == null || cachedBuilder == builder) break;
            try {
                cachedBuilder.cacheTriggerRupture(eq, triggerRup);
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            break;
        }
        Preconditions.checkNotNull(triggerRup, (String)"Could not build trigger rupture for %s", (Object)eq.getEventId());
        Double etasK = modK == null ? null : modK.get(eq.getEventId());
        Double etasP = modP == null ? null : modP.get(eq.getEventId());
        Double d = etasC = modC == null ? null : modC.get(eq.getEventId());
        if (etasK != null || etasP != null || etasC != null) {
            System.out.println("Setting custom ETAS parameters for " + eq.getEventId());
            triggerRup.setETAS_Params(etasK, etasP, etasC);
        }
        triggerRup.setComcatEventID(eq.getEventId());
        if (CACHE_TRIGGER_RUPS) {
            triggerRupCache.put(eq.getEventId(), triggerRup);
        }
        return triggerRup;
    }

    public void buildInputPlots() throws IOException {
        if (this.cmd.hasOption("skip-input-plots")) {
            return;
        }
        File plotDir = new File(this.outputDir, "config_input_plots");
        System.out.println();
        System.out.println("Writing diagnostic plots and input data to: " + plotDir.getAbsolutePath());
        Preconditions.checkState((plotDir.exists() || plotDir.mkdir() ? 1 : 0) != 0);
        ArrayList<String> lines = new ArrayList<String>();
        lines.add("# ETAS Configuration for " + this.config.getSimulationName());
        lines.add("");
        ETAS_Launcher launcher = new ETAS_Launcher(this.config, false);
        lines.addAll(SimulationMarkdownGenerator.getCatalogSummarytable(this.config, this.config.getNumSimulations(), launcher.getTriggerRuptures(), launcher.getHistQkList()));
        lines.add("");
        int tocIndex = lines.size();
        String topLink = "*[(top)](#table-of-contents)*";
        lines.add("");
        FaultSystemSolution fss = launcher.checkOutFSS();
        ETAS_TriggerRuptureFaultDistancesPlot mapPlot = new ETAS_TriggerRuptureFaultDistancesPlot(this.config, launcher, 25.0);
        mapPlot.finalize(plotDir, fss);
        lines.addAll(mapPlot.generateMarkdown(".", "##", topLink));
        if (!this.config.isGriddedOnly()) {
            FiniteFaultSectionResetCalc mapper = null;
            for (TriggerRupture trigger : this.config.getTriggerRuptures()) {
                boolean primary;
                ETAS_EqkRupture rup = launcher.getRuptureForTrigger(trigger);
                RuptureSurface surface = rup.getRuptureSurface();
                boolean bl = primary = this.primaryRupture != null && trigger.getComcatEventID().equals(this.primaryEventID);
                if (!primary && surface.isPointSurface() && !(rup.getMag() >= 6.0)) continue;
                if (mapper == null) {
                    double minFractionalAreaInPolygon = 0.5;
                    FaultSystemRupSet rupSet = fss.getRupSet();
                    mapper = new FiniteFaultSectionResetCalc(rupSet, rupSet.getModule(PolygonFaultGridAssociations.class), minFractionalAreaInPolygon, true);
                }
                lines.add("");
                lines.addAll(mapper.writeSectionResetMarkdown(plotDir, ".", "##", topLink, surface, rup.getHypocenterLocation(), trigger.getComcatEventID()));
            }
        }
        lines.add("");
        lines.add("## JSON Input File");
        lines.add(topLink);
        lines.add("");
        SimulationMarkdownGenerator.addConfigLines(this.config, this.configFile, lines);
        lines.add("");
        launcher.checkInFSS(fss);
        ArrayList<String> tocLines = new ArrayList<String>();
        tocLines.add("## Table Of Contents");
        tocLines.add("");
        tocLines.addAll(MarkdownUtils.buildTOC(lines, 2));
        lines.addAll(tocIndex, tocLines);
        System.out.println("Writing markdown and HTML");
        MarkdownUtils.writeReadmeAndHTML(lines, plotDir);
    }

    private void initRuptureBuilders(CommandLine cmd, String primaryEventID) {
        this.ruptureBuilders = new ArrayList<RuptureBuilder>();
        for (Option opt : cmd.getOptions()) {
            RuptureBuilder builder = this.getRuptureBuilder(cmd, opt, primaryEventID);
            if (builder == null) continue;
            this.ruptureBuilders.add(builder);
        }
        CachedRuptureBuilder cachedBuilder = null;
        double minNonzerMinMag = Double.POSITIVE_INFINITY;
        for (RuptureBuilder builder : this.ruptureBuilders) {
            if (builder instanceof CachedRuptureBuilder) {
                cachedBuilder = (CachedRuptureBuilder)builder;
                continue;
            }
            if (!(builder.getMinMag() > 0.0)) continue;
            minNonzerMinMag = Math.min(minNonzerMinMag, builder.getMinMag());
        }
        if (cachedBuilder != null) {
            cachedBuilder.setMinMag(minNonzerMinMag);
        }
        this.ruptureBuilders.add(new PointRuptureBuilder());
    }

    private static Map<String, Double> getEventSpecificDoubleOptions(CommandLine cmd, String opt, String primaryEventID) {
        Map<String, String> strings = ETAS_AbstractComcatConfigBuilder.getEventSpecificOptions(cmd, opt, primaryEventID);
        if (strings == null) {
            return null;
        }
        HashMap<String, Double> ret = new HashMap<String, Double>();
        for (String key : strings.keySet()) {
            ret.put(key, Double.parseDouble(strings.get(key)));
        }
        return ret;
    }

    private static Map<String, String> getEventSpecificOptions(CommandLine cmd, String opt, String primaryEventID) {
        String[] values = cmd.getOptionValues(opt);
        if (values == null || values.length == 0) {
            return null;
        }
        HashMap<String, String> map = new HashMap<String, String>();
        for (String value : values) {
            Preconditions.checkArgument((value.contains(":") || primaryEventID != null ? 1 : 0) != 0, (String)"Expected --%s <event-id>:<value>, got --%s %s", (Object)opt, (Object)opt, (Object)value);
            if (value.contains(":")) {
                String[] split = value.split(":");
                Preconditions.checkState((split.length == 2 ? 1 : 0) != 0, (String)"Expected --%s <event-id>:<value>, got --%s %s", (Object)opt, (Object)opt, (Object)value);
                map.put(split[0], split[1]);
                continue;
            }
            map.put(primaryEventID, value);
        }
        return map;
    }

    protected RuptureBuilder getRuptureBuilder(CommandLine cmd, Option option, String primaryEventID) {
        switch (option.getLongOpt()) {
            case "finite-surf-shakemap": {
                Double minMag = ETAS_AbstractComcatConfigBuilder.doubleArgIfPresent(cmd, "finite-surf-shakemap-min-mag");
                if (minMag == null) {
                    minMag = primaryEventID == null ? Double.valueOf(SHAKEMAP_MIN_MAG_DEFAULT) : Double.valueOf(Double.POSITIVE_INFINITY);
                }
                ShakeMapRuptureBuilder smBuilder = new ShakeMapRuptureBuilder(minMag, primaryEventID);
                smBuilder.setPlanarExtents(cmd.hasOption("finite-surf-shakemap-planar-extents"));
                if (cmd.hasOption("finite-surf-shakemap-version")) {
                    Map<String, String> eventOps = ETAS_AbstractComcatConfigBuilder.getEventSpecificOptions(cmd, "finite-surf-shakemap-version", primaryEventID);
                    for (String id : eventOps.keySet()) {
                        smBuilder.setShakeMapVerison(id, Integer.parseInt(eventOps.get(id)));
                    }
                }
                return smBuilder;
            }
            case "finite-surf-inversion": {
                Double minSlip;
                Double minMag = ETAS_AbstractComcatConfigBuilder.doubleArgIfPresent(cmd, "finite-surf-inversion-min-mag");
                if (minMag == null) {
                    minMag = primaryEventID == null ? Double.valueOf(SHAKEMAP_MIN_MAG_DEFAULT) : Double.valueOf(Double.POSITIVE_INFINITY);
                }
                if ((minSlip = ETAS_AbstractComcatConfigBuilder.doubleArgIfPresent(cmd, "finite-surf-inversion-min-slip")) == null) {
                    minSlip = 0.0;
                }
                return new InvertedSurfRuptureBuilder(minMag, minSlip, primaryEventID);
            }
            case "finite-surf-from-sections": {
                Map<String, int[]> resetSectsMap = this.getResetSectsMap();
                Preconditions.checkArgument((resetSectsMap != null && !resetSectsMap.isEmpty() ? 1 : 0) != 0, (Object)"must supply --reset-sects argument with --finite-surf-from-sections");
                return new SectionRuptureBuilder(resetSectsMap);
            }
            case "finite-surf-cache": {
                File cacheDir = new File(cmd.getOptionValue("finite-surf-cache"));
                Preconditions.checkState((cacheDir.exists() || cacheDir.mkdir() ? 1 : 0) != 0, (String)"Finite surfaces cache doesn't exist and couldn't be created: %s", (Object)cacheDir.getAbsolutePath());
                return new CachedRuptureBuilder(cacheDir);
            }
        }
        return null;
    }

    protected abstract String getPrimaryEventID();

    protected abstract Region buildRegion(ObsEqkRupture var1, TriggerRupture var2);

    protected abstract long getComCatStartTime();

    protected abstract long getComCatEndTime();

    protected abstract long getSimulationStartTime(long var1, long var3);

    protected abstract String getBaseSimName();

    protected abstract String getScriptName();

    static {
        TimeZone utc = TimeZone.getTimeZone("UTC");
        argDateFormat.setTimeZone(utc);
        argDateTimeFormat.setTimeZone(utc);
        CACHE_TRIGGER_RUPS = false;
        triggerRupCache = new HashMap();
    }

    protected static interface RuptureBuilder {
        public TriggerRupture build(ObsEqkRupture var1, int[] var2);

        public String getDisplayName(int var1);

        public double getMinMag();
    }

    protected static class CachedRuptureBuilder
    implements RuptureBuilder {
        private double minMag;
        private Gson gson;
        private ETAS_Config.TriggerRuptureTypeAdapter adapter;
        private File cacheDir;

        public CachedRuptureBuilder(File cacheDir) {
            this.cacheDir = cacheDir;
            this.adapter = new ETAS_Config.TriggerRuptureTypeAdapter();
            GsonBuilder builder = new GsonBuilder();
            builder.setPrettyPrinting();
            builder.registerTypeAdapter(TriggerRupture.class, (Object)this.adapter);
            this.gson = builder.create();
        }

        private File getCacheFile(ObsEqkRupture rup) {
            return new File(this.cacheDir, rup.getEventId() + ".json");
        }

        @Override
        public TriggerRupture build(ObsEqkRupture rup, int[] resetSubSects) {
            File rupFile = this.getCacheFile(rup);
            if (!rupFile.exists()) {
                return null;
            }
            System.out.println("Loading cached TriggerRupture for " + rup.getEventId() + " from " + rupFile.getAbsolutePath());
            try {
                JsonReader in = this.gson.newJsonReader((Reader)new BufferedReader(new FileReader(rupFile)));
                return this.adapter.read(in);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
        }

        public void cacheTriggerRupture(ObsEqkRupture rup, TriggerRupture trigRup) throws IOException {
            if (rup.getMag() < this.minMag) {
                return;
            }
            File rupFile = this.getCacheFile(rup);
            System.out.println("Caching TriggerRupture for " + rup.getEventId() + " to " + rupFile.getAbsolutePath());
            FileWriter fw = new FileWriter(rupFile);
            JsonWriter out = this.gson.newJsonWriter((Writer)fw);
            this.adapter.write(out, trigRup);
            fw.write("\n");
            fw.close();
        }

        @Override
        public String getDisplayName(int totalNumRuptures) {
            return null;
        }

        @Override
        public double getMinMag() {
            return this.minMag;
        }

        public void setMinMag(double minMag) {
            this.minMag = minMag;
        }
    }

    protected static class PointRuptureBuilder
    implements RuptureBuilder {
        private int numProcessed = 0;

        @Override
        public TriggerRupture build(ObsEqkRupture rup, int[] resetSubSects) {
            ++this.numProcessed;
            return new TriggerRupture.Point(rup.getHypocenterLocation(), rup.getOriginTime(), rup.getMag(), resetSubSects);
        }

        @Override
        public String getDisplayName(int totalNumRuptures) {
            if (this.numProcessed < totalNumRuptures) {
                return null;
            }
            Object name = "Point Source";
            if (this.numProcessed > 1) {
                name = (String)name + "s";
            }
            return name;
        }

        @Override
        public double getMinMag() {
            return 0.0;
        }
    }

    protected static class ShakeMapRuptureBuilder
    implements RuptureBuilder {
        private ShakeMapFiniteFaultAccessor smAccessor;
        private Map<String, Integer> versions = new HashMap<String, Integer>();
        private double minMag;
        private String primaryEventID;
        private boolean planarExtents;
        private int numProcessed = 0;

        public ShakeMapRuptureBuilder(double minMag, String primaryEventID) {
            this.minMag = minMag;
            this.primaryEventID = primaryEventID;
            this.smAccessor = new ShakeMapFiniteFaultAccessor();
        }

        public void setShakeMapVerison(String eventID, int version) {
            this.versions.put(eventID, version);
        }

        public void setPlanarExtents(boolean planarExtents) {
            this.planarExtents = planarExtents;
        }

        @Override
        public TriggerRupture build(ObsEqkRupture rup, int[] resetSubSects) {
            LocationList[] outlines;
            if (rup.getMag() < this.minMag && !rup.getEventId().equals(this.primaryEventID)) {
                return null;
            }
            Integer version = this.versions.get(rup.getEventId());
            if (version == null) {
                version = -1;
                System.out.println("Looking for ShakeMaps for " + rup.getEventId() + ", M" + (float)rup.getMag());
            } else {
                System.out.println("Looking for ShakeMap version " + version + " for " + rup.getEventId() + ", M" + (float)rup.getMag());
            }
            try {
                outlines = this.smAccessor.fetchShakemapSourceOutlines(rup.getEventId(), version);
            }
            catch (Exception e) {
                e.printStackTrace();
                return null;
            }
            if (outlines == null) {
                return null;
            }
            ++this.numProcessed;
            if (this.planarExtents) {
                outlines = ETAS_AbstractComcatConfigBuilder.getPlanarExtentsSurface(outlines);
            }
            return new TriggerRupture.EdgeFault((Long)rup.getOriginTime(), rup.getHypocenterLocation(), rup.getMag(), resetSubSects, outlines);
        }

        @Override
        public String getDisplayName(int totalNumRuptures) {
            if (this.numProcessed == 0) {
                return null;
            }
            Object name = "ShakeMap Surface";
            if (this.numProcessed > 1) {
                name = (String)name + "s";
            }
            if (!this.versions.isEmpty()) {
                if (this.versions.size() == 1) {
                    name = (String)name + " (Version " + String.valueOf(this.versions.values().iterator().next()) + ")";
                } else {
                    Object versionStr = null;
                    for (String key : this.versions.keySet()) {
                        versionStr = versionStr == null ? " (Version " : (String)versionStr + ",";
                        versionStr = (String)versionStr + key + ":" + String.valueOf(this.versions.get(key));
                    }
                    name = (String)name + versionStr + ")";
                }
            }
            if (this.planarExtents) {
                name = (String)name + " (Planar Extents)";
            }
            return name;
        }

        @Override
        public double getMinMag() {
            return this.minMag;
        }
    }

    protected static class InvertedSurfRuptureBuilder
    implements RuptureBuilder {
        private ComcatInvertedFiniteFaultAccessor invAccessor;
        private double minMag;
        private double minSlip;
        private String primaryEventID;
        private int numProcessed = 0;

        public InvertedSurfRuptureBuilder(double minMag, double minSlip, String primaryEventID) {
            this.minMag = minMag;
            this.minSlip = minSlip;
            this.primaryEventID = primaryEventID;
            this.invAccessor = new ComcatInvertedFiniteFaultAccessor();
        }

        @Override
        public TriggerRupture build(ObsEqkRupture rup, int[] resetSubSects) {
            if (rup.getMag() < this.minMag && !rup.getEventId().equals(this.primaryEventID)) {
                return null;
            }
            System.out.println("Looking for inverted surfaces for " + rup.getEventId() + ", M" + (float)rup.getMag());
            ComcatInvertedFiniteFault finiteSurf = this.invAccessor.fetchFiniteFault(rup.getEventId());
            if (finiteSurf == null) {
                return null;
            }
            ++this.numProcessed;
            LocationList[] outlines = finiteSurf.getOutlines(this.minSlip);
            return new TriggerRupture.EdgeFault((Long)rup.getOriginTime(), rup.getHypocenterLocation(), rup.getMag(), resetSubSects, outlines);
        }

        @Override
        public String getDisplayName(int totalNumRuptures) {
            if (this.numProcessed == 0) {
                return null;
            }
            Object name = "Inverted Surface";
            if (this.numProcessed > 1) {
                name = (String)name + "s";
            }
            if (this.minSlip > 0.0) {
                name = (String)name + " (minSlip=" + (float)this.minSlip + ")";
            }
            return name;
        }

        @Override
        public double getMinMag() {
            return this.minMag;
        }
    }

    protected static class SectionRuptureBuilder
    implements RuptureBuilder {
        private Map<String, int[]> resetSectsMap;
        private int numProcessed = 0;

        public SectionRuptureBuilder(Map<String, int[]> resetSectsMap) {
            this.resetSectsMap = resetSectsMap;
        }

        @Override
        public TriggerRupture build(ObsEqkRupture rup, int[] resetSubSects) {
            if (this.resetSectsMap.containsKey(rup.getEventId())) {
                return null;
            }
            ++this.numProcessed;
            return new TriggerRupture.SectionBased(this.resetSectsMap.get(rup.getEventId()), rup.getOriginTime(), rup.getMag());
        }

        @Override
        public String getDisplayName(int totalNumRuptures) {
            if (this.numProcessed == 0) {
                return null;
            }
            Object name = "Surf";
            if (this.numProcessed > 1) {
                name = (String)name + "s";
            }
            name = (String)name + " From Sects";
            return name;
        }

        @Override
        public double getMinMag() {
            return 0.0;
        }
    }
}

