/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.text.DecimalFormat;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.opensha.commons.calc.magScalingRelations.magScalingRelImpl.WC1994_MagLengthRelationship;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.observedEarthquake.ObsEqkRupture;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.SimpleFaultData;
import scratch.UCERF3.erf.ETAS.analysis.ETAS_AbstractPlot;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.TriggerRupture;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_AbstractComcatConfigBuilder;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_ConfigBuilder;

public class ETAS_ComcatEventConfigBuilder
extends ETAS_AbstractComcatConfigBuilder {
    private static final double MIN_WC_RADIUS = 20.0;
    private double daysBefore;
    private double daysAfter;
    private static final DecimalFormat daysDF = new DecimalFormat("0.#");

    public static void main(String[] args) {
        if (args.length == 1 && args[0].equals("--hardcoded")) {
            Object argz = "";
            argz = (String)argz + " --event-id nc73584926";
            argz = (String)argz + " --radius 25";
            argz = (String)argz + " --num-simulations 100000";
            argz = (String)argz + " --days-before 7";
            argz = (String)argz + " --max-point-src-mag 6";
            argz = (String)argz + " --etas-k-cov 1.5";
            argz = (String)argz + " --finite-surf-shakemap";
            argz = (String)argz + " --finite-surf-shakemap-min-mag 4.5";
            argz = (String)argz + " --hpc-site USC_CARC";
            argz = (String)argz + " --nodes 32";
            argz = (String)argz + " --hours 24";
            args = ((String)argz).trim().split(" ");
        }
        System.setProperty("java.awt.headless", "true");
        Options options = ETAS_ComcatEventConfigBuilder.createOptions();
        try {
            ETAS_ComcatEventConfigBuilder builder = new ETAS_ComcatEventConfigBuilder(args, options);
            builder.buildConfiguration();
            builder.buildInputPlots();
            System.out.println("DONE");
        }
        catch (Exception e) {
            e.printStackTrace();
            System.exit(1);
        }
        System.exit(0);
    }

    public static Options createOptions() {
        Options ops = ETAS_ComcatEventConfigBuilder.getCommonOptions();
        Option idOption = new Option("id", "event-id", true, "Primary ComCat event ID of interest");
        idOption.setRequired(true);
        ops.addOption(idOption);
        Option daysBeforeOption = new Option("db", "days-before", true, "Number of hours before primary event (which is specified with --event-id <id>) to include events in the region as triggers");
        daysBeforeOption.setRequired(false);
        ops.addOption(daysBeforeOption);
        Option hoursBeforeOption = new Option("hb", "hours-before", true, "Number of days before primary event (which is specified with --event-id <id>) to include events in the region as triggers");
        hoursBeforeOption.setRequired(false);
        ops.addOption(hoursBeforeOption);
        Option daysAfterOption = new Option("da", "days-after", true, "Number of days after primary event (which is specified with --event-id <id>) to include events in the region as triggers");
        daysAfterOption.setRequired(false);
        ops.addOption(daysAfterOption);
        Option hoursAfterOption = new Option("ha", "hours-after", true, "Number of hours after primary event (which is specified with --event-id <id>) to include events in the region as triggers");
        hoursAfterOption.setRequired(false);
        ops.addOption(hoursAfterOption);
        Option nowOption = new Option("now", "end-now", false, "Include all aftershocks of primary event (which is specified with --event-id <id>) up to the current instant");
        nowOption.setRequired(false);
        ops.addOption(nowOption);
        Option startTimeOption = new Option("st", "start-time", true, "ComCat data start time in epoch milliseconds");
        startTimeOption.setRequired(false);
        ops.addOption(startTimeOption);
        Option startDateOption = new Option("sd", "start-date", true, "ComCat data start date in the format 'yyyy-MM-dd' (e.g. 2019-01-01) or 'yyyy-MM-ddTHH:mm:ss' (e.g. 2019-01-01T01:23:45). All dates and times in UTC");
        startDateOption.setRequired(false);
        ops.addOption(startDateOption);
        Option endTimeOption = new Option("et", "end-time", true, "ComCat data end time in epoch milliseconds");
        endTimeOption.setRequired(false);
        ops.addOption(endTimeOption);
        Option endDateOption = new Option("ed", "end-date", true, "ComCat data end date in the format 'yyyy-MM-dd' (e.g. 2019-01-01) or 'yyyy-MM-ddTHH:mm:ss' (e.g. 2019-01-01T01:23:45). All dates and times in UTC.");
        endDateOption.setRequired(false);
        ops.addOption(endDateOption);
        Option regionOption = new Option("reg", "region", true, "Region to fetch events in the format lat1,lon1[,lat2,lon2]. If only one location is supplied, then a circular region is built and you must also supply the --radius argument. Otherwise, if two locations and the --radius option is supplied, a sausage region is drawn around the line defined, otherwise a rectangular region is defined between the two points.");
        regionOption.setRequired(false);
        ops.addOption(regionOption);
        Option radiusOption = new Option("r", "radius", true, "Radius (km) about main event for avershock search. If not supplied, W-C 1994 radius used");
        radiusOption.setRequired(false);
        ops.addOption(radiusOption);
        Option finiteDipOption = new Option("fd", "finite-surf-dip", true, "Dip (degrees) of the primary rupture's finite rupture surface");
        finiteDipOption.setRequired(false);
        ops.addOption(finiteDipOption);
        Option finiteStrikeOption = new Option("fs", "finite-surf-strike", true, "Strike (degrees) of the primary rupture's finite rupture surface");
        finiteStrikeOption.setRequired(false);
        ops.addOption(finiteStrikeOption);
        Option finiteLengthAlongOption = new Option("fla", "finite-surf-length-along", true, "Length (km) of the primary rupture in the along-strike direction, from the hypocenter");
        finiteLengthAlongOption.setRequired(false);
        ops.addOption(finiteLengthAlongOption);
        Option finiteLengthBeforeOption = new Option("flb", "finite-surf-length-before", true, "Length (km) of the primary rupture in the along-strike direction, before the hypocenter");
        finiteLengthBeforeOption.setRequired(false);
        ops.addOption(finiteLengthBeforeOption);
        Option finiteUpperDepth = new Option("fud", "finite-surf-upper-depth", true, "Upper depth (km) of the finite rupture surface");
        finiteUpperDepth.setRequired(false);
        ops.addOption(finiteUpperDepth);
        Option finiteLowerDepth = new Option("fld", "finite-surf-lower-depth", true, "Lower depth (km) of the finite rupture surface");
        finiteLowerDepth.setRequired(false);
        ops.addOption(finiteLowerDepth);
        ETAS_ComcatEventConfigBuilder.createKMLOptions(ops);
        return ops;
    }

    public ETAS_ComcatEventConfigBuilder(String[] args, Options options) {
        super(args, options);
    }

    @Override
    protected String getPrimaryEventID() {
        String eventID = this.cmd.getOptionValue("event-id");
        Preconditions.checkArgument((eventID != null ? 1 : 0) != 0, (Object)"Must supply event ID!");
        return eventID;
    }

    @Override
    protected Region buildRegion(ObsEqkRupture primaryRupture, TriggerRupture primaryTrigger) {
        Region region;
        double radius;
        if (this.cmd.hasOption("radius")) {
            radius = Double.parseDouble(this.cmd.getOptionValue("radius"));
        } else {
            radius = Math.max(20.0, new WC1994_MagLengthRelationship().getMedianLength(primaryRupture.getMag()));
            System.out.println("W-C 1994 Radius: " + (float)radius);
        }
        if (this.cmd.hasOption("region")) {
            Location loc2;
            String regStr = this.cmd.getOptionValue("region");
            String[] regSplit = regStr.split(",");
            Preconditions.checkArgument((regSplit.length == 2 || regSplit.length == 4 ? 1 : 0) != 0, (Object)"--region format: lat1,lon1[,lat2,lon2]");
            double lat1 = Double.parseDouble(regSplit[0]);
            double lon1 = Double.parseDouble(regSplit[1]);
            Location loc1 = new Location(lat1, lon1);
            if (regSplit.length == 2) {
                Preconditions.checkState((boolean)this.cmd.hasOption("radius"), (Object)"you only supplied one location for a region, but didn't supply a radius");
                loc2 = null;
            } else {
                double lat2 = Double.parseDouble(regSplit[2]);
                double lon2 = Double.parseDouble(regSplit[3]);
                loc2 = new Location(lat2, lon2);
            }
            if (this.cmd.hasOption("radius")) {
                if (loc2 == null) {
                    region = new ETAS_Config.CircularRegion(loc1, radius);
                } else {
                    LocationList line = new LocationList();
                    line.add(loc1);
                    line.add(loc2);
                    region = new Region(line, radius);
                }
            } else {
                region = new Region(loc1, loc2);
            }
        } else {
            FaultTrace primaryTrace;
            if (primaryTrigger instanceof TriggerRupture.SimpleFault) {
                primaryTrace = new FaultTrace(null);
                for (SimpleFaultData sfd : ((TriggerRupture.SimpleFault)primaryTrigger).sfds) {
                    primaryTrace.addAll(sfd.getFaultTrace());
                }
            } else if (primaryTrigger instanceof TriggerRupture.SectionBased) {
                FaultSystemRupSet rupSet;
                primaryTrace = new FaultTrace(null);
                LocationList[] fm = ETAS_ComcatEventConfigBuilder.getFM(this.cmd);
                System.out.println("Need to load UCERF3 Fault System Solution to build rupture from sub sections");
                File fssFile = (File)fmFSSfileMap.get(fm);
                if (fssFile != null) {
                    fssFile = ETAS_Config.resolvePath(fssFile);
                }
                try {
                    rupSet = FaultSystemRupSet.load(fssFile);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
                for (int sectIndex : ((TriggerRupture.SectionBased)primaryTrigger).subSects) {
                    primaryTrace.addAll(rupSet.getFaultSectionData(sectIndex).getFaultTrace());
                }
            } else if (primaryTrigger instanceof TriggerRupture.EdgeFault) {
                primaryTrace = new FaultTrace(null);
                for (LocationList outline : ((TriggerRupture.EdgeFault)primaryTrigger).outlines) {
                    for (int i = 0; i < outline.size() / 2; ++i) {
                        primaryTrace.add((Location)outline.get(i));
                    }
                }
            } else {
                primaryTrace = null;
            }
            if (primaryTrace != null) {
                try {
                    region = new Region((LocationList)primaryTrace, radius);
                }
                catch (Exception e) {
                    System.out.println("Failed to create sausage region around SM fault trace, using simple straight line trace");
                    LocationList planar = ETAS_ComcatEventConfigBuilder.getPlanarExtentsSurface(new LocationList[]{primaryTrace})[0];
                    FaultTrace simpleTrace = new FaultTrace(null);
                    simpleTrace.add((Location)planar.get(0));
                    simpleTrace.add((Location)planar.get(1));
                    region = new Region((LocationList)simpleTrace, radius);
                }
            } else {
                Location hypo = primaryRupture.getHypocenterLocation();
                region = new ETAS_Config.CircularRegion(new Location(hypo.getLatitude(), hypo.getLongitude()), radius);
            }
        }
        return region;
    }

    @Override
    protected long getComCatStartTime() {
        if (this.cmd.hasOption("days-before") || this.cmd.hasOption("hours-before")) {
            this.daysBefore = this.cmd.hasOption("days-before") ? Double.parseDouble(this.cmd.getOptionValue("days-before")) : Double.parseDouble(this.cmd.getOptionValue("hours-before")) / 24.0;
            Preconditions.checkState((this.daysBefore > 0.0 ? 1 : 0) != 0, (Object)"Days before event must be >0");
            long beforeStartMillis = this.primaryRupture.getOriginTime() - (long)(this.daysBefore * 8.64E7 + 0.5);
            System.out.println("Fetching events before primary from comcat:");
            System.out.println("\tComCat start time: " + beforeStartMillis + " (" + (float)this.daysBefore + " days before primary)");
            return beforeStartMillis;
        }
        if (this.cmd.hasOption("start-time")) {
            long comcatStartTime = Long.parseLong(this.cmd.getOptionValue("start-time"));
            System.out.println("Will start ComCat data fetch at " + comcatStartTime);
            return comcatStartTime;
        }
        if (this.cmd.hasOption("start-date")) {
            String dateStr = this.cmd.getOptionValue("start-date");
            long comcatStartTime = this.parseDateString(dateStr);
            System.out.println("Will start ComCat data fetch at " + comcatStartTime + ", from date: " + dateStr);
            return comcatStartTime;
        }
        return this.primaryRupture.getOriginTime();
    }

    @Override
    protected long getComCatEndTime() {
        if (this.cmd.hasOption("days-after") || this.cmd.hasOption("hours-after") || this.cmd.hasOption("end-now")) {
            long afterEndMillis;
            long curTime = System.currentTimeMillis();
            if (this.cmd.hasOption("end-now")) {
                afterEndMillis = curTime;
                this.daysAfter = (double)(afterEndMillis - this.primaryRupture.getOriginTime()) / 8.64E7;
            } else {
                this.daysAfter = this.cmd.hasOption("days-after") ? Double.parseDouble(this.cmd.getOptionValue("days-after")) : Double.parseDouble(this.cmd.getOptionValue("hours-after")) / 24.0;
                Preconditions.checkState((this.daysAfter > 0.0 ? 1 : 0) != 0, (Object)"Days after event must be >0");
                afterEndMillis = this.primaryRupture.getOriginTime() + (long)(this.daysAfter * 8.64E7 + 0.5);
                Preconditions.checkState((afterEndMillis <= curTime ? 1 : 0) != 0, (String)"ComCat end time is %s in the future: %s > %s", (Object)ETAS_AbstractPlot.getTimeShortLabel((double)(afterEndMillis - curTime) / 3.15576E10), (Object)afterEndMillis, (Object)curTime);
            }
            System.out.println("Fetching events after primary from comcat:");
            System.out.println("\tEnd time: " + afterEndMillis + " (" + (float)this.daysAfter + " days after primary)");
            return afterEndMillis;
        }
        if (this.cmd.hasOption("end-time")) {
            long comcatEndTime = Long.parseLong(this.cmd.getOptionValue("end-time"));
            System.out.println("Will end ComCat data fetch at " + comcatEndTime);
            Preconditions.checkArgument((comcatEndTime >= this.primaryRupture.getOriginTime() ? 1 : 0) != 0, (Object)"End time is before primary rupture origin time");
            this.daysAfter = (double)(comcatEndTime - this.primaryRupture.getOriginTime()) / 8.64E7;
            return comcatEndTime;
        }
        if (this.cmd.hasOption("end-date")) {
            String dateStr = this.cmd.getOptionValue("end-date");
            long comcatEndTime = this.parseDateString(dateStr);
            System.out.println("Will end ComCat data fetch at " + comcatEndTime + ", from date: " + dateStr);
            Preconditions.checkArgument((comcatEndTime >= this.primaryRupture.getOriginTime() ? 1 : 0) != 0, (Object)"End time is before primary rupture origin time");
            this.daysAfter = (double)(comcatEndTime - this.primaryRupture.getOriginTime()) / 8.64E7;
            return comcatEndTime;
        }
        return this.primaryRupture.getOriginTime();
    }

    @Override
    protected long getSimulationStartTime(long comcatStartTime, long comcatEndTime) {
        return comcatEndTime + 1000L;
    }

    @Override
    protected String getBaseSimName() {
        String name = "ComCat M" + (float)this.primaryRupture.getMag() + " (" + this.primaryRupture.getEventId() + ")";
        if (this.daysAfter > 0.0) {
            name = name + ", " + daysDF.format(this.daysAfter) + " Days After";
        }
        return name;
    }

    @Override
    protected String getScriptName() {
        return "u3etas_comcat_event_config_builder.sh";
    }

    @Override
    protected ETAS_AbstractComcatConfigBuilder.RuptureBuilder getRuptureBuilder(CommandLine cmd, Option option, String primaryEventID) {
        switch (option.getLongOpt()) {
            case "finite-surf-dip": {
                Preconditions.checkState((boolean)cmd.hasOption("finite-surf-strike"), (Object)"Must supply all or no finite surface options");
                Preconditions.checkState((boolean)cmd.hasOption("finite-surf-length-along"), (Object)"Must supply all or no finite surface options");
                Preconditions.checkState((boolean)cmd.hasOption("finite-surf-length-before"), (Object)"Must supply all or no finite surface options");
                Preconditions.checkState((boolean)cmd.hasOption("finite-surf-upper-depth"), (Object)"Must supply all or no finite surface options");
                Preconditions.checkState((boolean)cmd.hasOption("finite-surf-lower-depth"), (Object)"Must supply all or no finite surface options");
                double dip = Double.parseDouble(cmd.getOptionValue("finite-surf-dip"));
                double strike = Double.parseDouble(cmd.getOptionValue("finite-surf-strike"));
                double lenAlong = Double.parseDouble(cmd.getOptionValue("finite-surf-length-along"));
                double lenBefore = Double.parseDouble(cmd.getOptionValue("finite-surf-length-before"));
                Preconditions.checkState((lenAlong > 0.0 || lenBefore > 0.0 ? 1 : 0) != 0, (Object)"Length along or before must be > 0");
                double upperDepth = Double.parseDouble(cmd.getOptionValue("finite-surf-upper-depth"));
                double lowerDepth = Double.parseDouble(cmd.getOptionValue("finite-surf-lower-depth"));
                Preconditions.checkArgument((lowerDepth > upperDepth ? 1 : 0) != 0, (Object)"Lower depth must be > upper depth");
                return new CustomRuptureBuilder(primaryEventID, dip, strike, lenAlong, lenBefore, upperDepth, lowerDepth);
            }
            case "kml-surf": {
                return new KMLRuptureBuilder(cmd, primaryEventID);
            }
        }
        return super.getRuptureBuilder(cmd, option, primaryEventID);
    }

    private static class CustomRuptureBuilder
    implements ETAS_AbstractComcatConfigBuilder.RuptureBuilder {
        private String eventID;
        private double dip;
        private double strike;
        private double lenAlong;
        private double lenBefore;
        private double upperDepth;
        private double lowerDepth;
        private boolean processed = false;

        public CustomRuptureBuilder(String eventID, double dip, double strike, double lenAlong, double lenBefore, double upperDepth, double lowerDepth) {
            this.eventID = eventID;
            this.dip = dip;
            this.strike = strike;
            this.lenAlong = lenAlong;
            this.lenBefore = lenBefore;
            this.upperDepth = upperDepth;
            this.lowerDepth = lowerDepth;
        }

        @Override
        public TriggerRupture build(ObsEqkRupture rup, int[] resetSubSects) {
            if (!rup.getEventId().equals(this.eventID)) {
                return null;
            }
            FaultTrace faultTrace = new FaultTrace("Trace");
            Location hypo = rup.getHypocenterLocation();
            Location surfPoint = new Location(hypo.getLatitude(), hypo.getLongitude());
            if (this.dip < 90.0 && hypo.getDepth() != 0.0) {
                double horzDist = hypo.getDepth() / Math.tan(Math.toRadians(this.dip));
                System.out.println("Moving hypocenter up dip to determine fault trace");
                System.out.println("\tHorizontal distance: " + (float)horzDist);
                double direction = this.strike - 90.0;
                if (direction < 0.0) {
                    direction += 360.0;
                }
                System.out.println("\tDirection: " + (float)direction);
                surfPoint = LocationUtils.location(surfPoint, Math.toRadians(direction), horzDist);
                System.out.println("\tNew surface point on fault trace: " + String.valueOf(surfPoint));
            }
            if (this.lenBefore > 0.0) {
                double direction = this.strike + 180.0;
                if (direction >= 360.0) {
                    direction -= 360.0;
                }
                Location locBefore = LocationUtils.location(surfPoint, Math.toRadians(direction), this.lenBefore);
                System.out.println("Trace point before hypocenter: " + String.valueOf(locBefore));
                faultTrace.add(locBefore);
            }
            faultTrace.add(surfPoint);
            if (this.lenAlong > 0.0) {
                Location locAfter = LocationUtils.location(surfPoint, Math.toRadians(this.strike), this.lenAlong);
                System.out.println("Trace point after hypocenter: " + String.valueOf(locAfter));
                faultTrace.add(locAfter);
            }
            System.out.println("Total trace length: " + (float)faultTrace.getTraceLength());
            SimpleFaultData sfd = new SimpleFaultData(this.dip, this.lowerDepth, this.upperDepth, faultTrace);
            this.processed = true;
            return new TriggerRupture.SimpleFault((Long)rup.getOriginTime(), rup.getHypocenterLocation(), rup.getMag(), resetSubSects, sfd);
        }

        @Override
        public String getDisplayName(int totalNumRuptures) {
            if (this.processed) {
                return "Custom Surface";
            }
            return null;
        }

        @Override
        public double getMinMag() {
            return 0.0;
        }
    }

    private static class KMLRuptureBuilder
    implements ETAS_AbstractComcatConfigBuilder.RuptureBuilder {
        private CommandLine cmd;
        private String eventID;
        private boolean processed = false;

        public KMLRuptureBuilder(CommandLine cmd, String eventID) {
            this.cmd = cmd;
            this.eventID = eventID;
        }

        @Override
        public TriggerRupture build(ObsEqkRupture rup, int[] resetSubSects) {
            if (rup.getEventId().equals(this.eventID)) {
                SimpleFaultData[] sfd = ETAS_ConfigBuilder.loadKMLSurface(this.cmd);
                this.processed = true;
                return new TriggerRupture.SimpleFault((Long)rup.getOriginTime(), rup.getHypocenterLocation(), rup.getMag(), resetSubSects, sfd);
            }
            return null;
        }

        @Override
        public String getDisplayName(int totalNumRuptures) {
            if (this.processed) {
                return "KML Surface";
            }
            return null;
        }

        @Override
        public double getMinMag() {
            return 0.0;
        }
    }
}

