/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Preconditions;
import java.io.BufferedOutputStream;
import java.io.DataOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.RandomAccessFile;
import java.util.List;
import org.opensha.commons.util.ClassUtils;
import org.opensha.commons.util.ExceptionUtils;
import scratch.UCERF3.erf.ETAS.ETAS_CatalogIO;
import scratch.UCERF3.erf.ETAS.ETAS_EqkRupture;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Config;
import scratch.UCERF3.erf.ETAS.launcher.ETAS_Launcher;
import scratch.UCERF3.erf.ETAS.launcher.util.ETAS_CatalogIteration;

public class ETAS_FilterDescendants {
    public static void main(String[] args) throws IOException {
        if (args.length != 3) {
            System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(ETAS_FilterDescendants.class) + " <etas-config.json> <input-file.bin OR results-dir> <output-file.bin>");
            System.exit(2);
        }
        File jsonFile = new File(args[0]);
        Preconditions.checkState((boolean)jsonFile.exists(), (String)"ETAS JSON file doesn't exist: %s", (Object)jsonFile.getAbsoluteFile());
        System.out.println("Loading ETAS JSON file from " + jsonFile.getAbsolutePath());
        final ETAS_Config config = ETAS_Config.readJSON(jsonFile);
        File inputFile = new File(args[1]);
        Preconditions.checkState((boolean)inputFile.exists(), (String)"Input binary file doesn't exist: %s", (Object)inputFile.getAbsoluteFile());
        File outputFile = new File(args[args.length - 1]);
        final DataOutputStream out = new DataOutputStream(new BufferedOutputStream(new FileOutputStream(outputFile), 0x640000));
        out.writeInt(-1);
        int numProcessed = ETAS_CatalogIteration.processCatalogs(inputFile, new ETAS_CatalogIteration.Callback(){

            @Override
            public void processCatalog(ETAS_CatalogIO.ETAS_Catalog catalog, int index) {
                ETAS_CatalogIO.ETAS_Catalog filtered = ETAS_Launcher.getFilteredNoSpontaneous(config, catalog);
                try {
                    ETAS_CatalogIO.writeCatalogBinary(out, (List<ETAS_EqkRupture>)filtered);
                }
                catch (IOException e) {
                    throw ExceptionUtils.asRuntimeException(e);
                }
            }
        });
        out.close();
        System.out.println("Filtered " + numProcessed + " catalogs)");
        RandomAccessFile raFile = new RandomAccessFile(outputFile, "rw");
        raFile.seek(0L);
        raFile.writeInt(numProcessed);
        raFile.close();
    }
}

