/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.IOException;
import java.util.List;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.DefaultParser;
import org.apache.commons.cli.HelpFormatter;
import org.apache.commons.cli.Option;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.dom4j.DocumentException;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.util.ClassUtils;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.faultSurface.FaultSection;

public class ETAS_SectionSearch {
    private static final double RADIUS_DEFAULT = 50.0;

    private static Options createOptions() {
        Options ops = new Options();
        Option latOption = new Option("lat", "latitude", true, "Latitude of location around which to search for UCERF3 subsections");
        latOption.setRequired(false);
        ops.addOption(latOption);
        Option lonOption = new Option("lon", "longitude", true, "Longitue of location around which to search for UCERF3 subsections");
        lonOption.setRequired(false);
        ops.addOption(lonOption);
        Option radiusOption = new Option("r", "radius", true, "Radius around location in which to search for UCERF3 subsections in km. Default: 50.0 km");
        radiusOption.setRequired(false);
        ops.addOption(radiusOption);
        Option nameOption = new Option("n", "name", true, "Only return subsections which contain this string (ignoring case) in their name.");
        nameOption.setRequired(false);
        ops.addOption(nameOption);
        return ops;
    }

    public static void main(String[] args) throws IOException, DocumentException {
        CommandLine cmd;
        if (args.length == 1 && args[0].equals("--hardcoded")) {
            String argsStr = "--latitude 34 --longitude -118 --radius 20 /home/kevin/git/ucerf3-etas-launcher/inputs/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_SpatSeisU3_MEAN_BRANCH_AVG_SOL.zip";
            args = argsStr.split(" ");
        }
        System.setProperty("java.awt.headless", "true");
        Options options = ETAS_SectionSearch.createOptions();
        DefaultParser parser = new DefaultParser();
        try {
            cmd = parser.parse(options, args);
        }
        catch (ParseException e) {
            HelpFormatter formatter = new HelpFormatter();
            formatter.printHelp(ClassUtils.getClassNameWithoutPackage(ETAS_SectionSearch.class), options, true);
            System.exit(2);
            return;
        }
        args = cmd.getArgs();
        if (args.length != 1) {
            System.err.println("USAGE: " + ClassUtils.getClassNameWithoutPackage(ETAS_SectionSearch.class) + " [options] <fss_file.zip>");
            System.exit(2);
        }
        File fssFile = new File(args[0]);
        Preconditions.checkArgument((boolean)fssFile.exists(), (String)"FSS file doesn't exist: %s", (Object)fssFile.getAbsolutePath());
        System.out.println("Loading fault system solution from " + fssFile.getAbsolutePath());
        FaultSystemSolution fss = FaultSystemSolution.load(fssFile);
        Region searchReg = null;
        Location centerLoc = null;
        if (cmd.hasOption("latitude")) {
            Preconditions.checkArgument((boolean)cmd.hasOption("longitude"), (Object)"supplied latitude but not longitude");
            double lat = Double.parseDouble(cmd.getOptionValue("latitude"));
            double lon = Double.parseDouble(cmd.getOptionValue("longitude"));
            centerLoc = new Location(lat, lon);
            System.out.println("Using search circular region around " + (float)lat + ", " + (float)lon);
            double radius = cmd.hasOption("radius") ? Double.parseDouble(cmd.getOptionValue("radius")) : 50.0;
            System.out.println("Search radius: " + (float)radius + " km");
            searchReg = new Region(centerLoc, radius);
        }
        String name = null;
        if (cmd.hasOption("name")) {
            name = cmd.getOptionValue("name").trim();
        }
        List<? extends FaultSection> sects = fss.getRupSet().getFaultSectionDataList();
        for (FaultSection faultSection : sects) {
            if (searchReg != null) {
                boolean match = false;
                for (Location loc : faultSection.getFaultTrace()) {
                    if (!searchReg.contains(loc)) continue;
                    match = true;
                    break;
                }
                if (!match) continue;
            }
            if (name != null && !faultSection.getName().toLowerCase().contains(name.toLowerCase())) continue;
            System.out.println(faultSection.getSectionId() + ": " + faultSection.getName());
            if (searchReg != null) {
                double dist = faultSection.getFaultSurface(0.1, false, true).getDistanceJB(centerLoc);
                System.out.println("\thorizontal distance to search location: " + (float)dist);
            }
            System.out.println("\tupper depth: " + (float)faultSection.getReducedAveUpperDepth());
            System.out.println("\tlower depth: " + (float)faultSection.getAveLowerDepth());
            System.out.println("\tstrike: " + (float)faultSection.getFaultTrace().getAveStrike());
            System.out.println("\tdip: " + (float)faultSection.getAveDip());
            System.out.println("\trake: " + (float)faultSection.getAveRake());
            System.out.println("\ttrace:");
            for (Location loc : faultSection.getFaultTrace()) {
                System.out.println("\t\t" + String.valueOf(loc));
            }
        }
    }
}

