/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.ETAS.launcher.util;

import com.google.common.base.Preconditions;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashSet;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.FaultTrace;
import org.opensha.sha.faultSurface.RuptureSurface;
import org.opensha.sha.faultSurface.SimpleFaultData;
import org.opensha.sha.faultSurface.StirlingGriddedSurface;

public class KML_RuptureLoader {
    private static final HashSet<String> elementsToParse = new HashSet();

    public static KML_Node parseKML(File kmlFile) throws IOException, DocumentException {
        String fName = kmlFile.getName().toLowerCase();
        if (fName.endsWith(".kmz")) {
            ZipFile zip = new ZipFile(kmlFile);
            Enumeration<? extends ZipEntry> entries = zip.entries();
            InputStream is = null;
            while (entries.hasMoreElements()) {
                ZipEntry entry = entries.nextElement();
                String name = entry.getName();
                if (!name.toLowerCase().endsWith(".kml")) continue;
                is = zip.getInputStream(entry);
            }
            if (is == null) {
                zip.close();
                throw new IllegalStateException("No .kml files found within kmz file");
            }
            KML_Node ret = KML_RuptureLoader.parseKML(is);
            zip.close();
            return ret;
        }
        return KML_RuptureLoader.parseKML(new FileInputStream(kmlFile));
    }

    public static KML_Node parseKML(InputStream is) throws DocumentException, IOException {
        Document doc = XMLUtils.loadDocument(is);
        Element rootEl = doc.getRootElement();
        ArrayList<KML_Node> nodes = new ArrayList<KML_Node>();
        for (Element el : XMLUtils.getSubElementsList(rootEl)) {
            nodes.add(new KML_Node(null, el));
        }
        is.close();
        if (nodes.size() == 0) {
            return null;
        }
        if (nodes.size() == 1) {
            return (KML_Node)nodes.get(0);
        }
        ArrayList<KML_Node> children = new ArrayList<KML_Node>();
        KML_Node parent = new KML_Node(null, "KML", null, children, null);
        for (KML_Node node : nodes) {
            children.add(new KML_Node(parent, node.type, node.name, node.children, node.trace));
        }
        return parent;
    }

    private static int countChildren(KML_Node node) {
        int children = 0;
        if (node.children != null) {
            for (KML_Node child : node.children) {
                ++children;
                children += KML_RuptureLoader.countChildren(child);
            }
        }
        return children;
    }

    private static int countTraces(KML_Node node) {
        int traces = 0;
        if (node.trace != null) {
            ++traces;
        }
        if (node.children != null) {
            for (KML_Node child : node.children) {
                if (child.trace != null) {
                    ++traces;
                    continue;
                }
                traces += KML_RuptureLoader.countTraces(child);
            }
        }
        return traces;
    }

    public static void printTree(KML_Node node) {
        KML_RuptureLoader.printTree(node, 0);
    }

    public static void printTree(KML_Node node, int maxLevels) {
        KML_RuptureLoader.doPrintTree(node, "", 0, maxLevels);
    }

    private static void doPrintTree(KML_Node node, String indent, int curLevel, int maxLevels) {
        String str = indent + "type='" + node.type + "', name='" + node.name + "'";
        if (node.trace != null) {
            str = str + ", trace with " + node.trace.size() + " points";
        }
        str = str + ", parent to " + KML_RuptureLoader.countTraces(node) + " traces across " + KML_RuptureLoader.countChildren(node) + " children";
        if (node.children != null) {
            str = str + " (" + node.children.size() + " direct children)";
        }
        System.out.println(str);
        if (node.children != null && (maxLevels <= 0 || curLevel < maxLevels)) {
            String subIndent = indent + "\t";
            int nextLevel = curLevel + 1;
            for (KML_Node child : node.children) {
                KML_RuptureLoader.doPrintTree(child, subIndent, nextLevel, maxLevels);
            }
        }
    }

    public static List<FaultTrace> loadTraces(KML_Node node) {
        ArrayList<FaultTrace> traces = new ArrayList<FaultTrace>();
        KML_RuptureLoader.doLoadTracesByName(traces, node, false, null);
        return traces;
    }

    public static List<FaultTrace> loadTracesByName(KML_Node node, boolean exactMatch, String ... names) {
        Preconditions.checkArgument((names.length > 0 ? 1 : 0) != 0, (Object)"No names supplied");
        for (String name : names) {
            Preconditions.checkState((!name.isEmpty() ? 1 : 0) != 0, (Object)"Empty name supplied");
        }
        ArrayList<FaultTrace> traces = new ArrayList<FaultTrace>();
        KML_RuptureLoader.doLoadTracesByName(traces, node, exactMatch, names);
        return traces;
    }

    private static void doLoadTracesByName(List<FaultTrace> traces, KML_Node node, boolean exactMatch, String[] names) {
        boolean inside;
        boolean bl = inside = names == null;
        if (node.trace != null) {
            if (inside) {
                traces.add(node.trace);
            }
        } else if (node.children != null) {
            for (KML_Node child : node.children) {
                boolean childInside = inside;
                if (!childInside && names != null && child.name != null) {
                    for (String testName : names) {
                        childInside = exactMatch ? childInside || testName.equals(child.name) : childInside || child.name.contains(testName);
                    }
                }
                KML_RuptureLoader.doLoadTracesByName(traces, child, exactMatch, childInside ? null : names);
            }
        }
    }

    public static List<SimpleFaultData> buildRuptureSFDs(List<FaultTrace> traces, double upperDepth, double lowerDepth, double dip, double dipDirection) {
        ArrayList<SimpleFaultData> sfds = new ArrayList<SimpleFaultData>();
        for (FaultTrace trace : traces) {
            double traceUpperDepth;
            if (Double.isNaN(upperDepth)) {
                traceUpperDepth = 0.0;
                for (Location loc : trace) {
                    upperDepth += loc.getDepth();
                }
                upperDepth /= (double)trace.size();
            } else {
                traceUpperDepth = upperDepth;
            }
            SimpleFaultData sfd = new SimpleFaultData(dip, lowerDepth, traceUpperDepth, trace, dipDirection);
            sfds.add(sfd);
        }
        return sfds;
    }

    public static RuptureSurface buildRuptureSurface(List<FaultTrace> traces, double upperDepth, double lowerDepth, double dip, double dipDirection, double gridSpacing) {
        List<SimpleFaultData> sfds = KML_RuptureLoader.buildRuptureSFDs(traces, upperDepth, lowerDepth, dip, dipDirection);
        ArrayList<StirlingGriddedSurface> surfs = new ArrayList<StirlingGriddedSurface>();
        for (SimpleFaultData sfd : sfds) {
            surfs.add(new StirlingGriddedSurface(sfd, gridSpacing, gridSpacing));
        }
        if (surfs.size() == 1) {
            return (RuptureSurface)surfs.get(0);
        }
        return new CompoundSurface(surfs);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File kmlFile = new File("/tmp/ridgecrest.kmz");
        KML_Node node = KML_RuptureLoader.parseKML(kmlFile);
        int totChildren = KML_RuptureLoader.countChildren(node);
        int totTraces = KML_RuptureLoader.countTraces(node);
        KML_RuptureLoader.printTree(node, 2);
        System.out.println("Parsed " + totTraces + " traces across " + totChildren + " children");
        System.out.println(KML_RuptureLoader.loadTraces(node).size() + " total traces");
        System.out.println(KML_RuptureLoader.loadTracesByName(node, true, "Field Verified Rupture Traces").size() + " field verified traces");
        System.out.println(KML_RuptureLoader.loadTracesByName(node, false, "Verified").size() + " contains 'Verified' traces");
        System.out.println(KML_RuptureLoader.loadTracesByName(node, false, "Field").size() + " contains 'Field' traces");
        KML_RuptureLoader.buildRuptureSurface(KML_RuptureLoader.loadTraces(node), Double.NaN, 12.0, 90.0, Double.NaN, 1.0);
    }

    static {
        elementsToParse.add("Document");
        elementsToParse.add("Folder");
        elementsToParse.add("Placemark");
        elementsToParse.add("MultiGeometry");
        elementsToParse.add("LineString");
    }

    public static class KML_Node {
        public final KML_Node parent;
        public final String type;
        public final String name;
        public final List<KML_Node> children;
        public final FaultTrace trace;

        private KML_Node(KML_Node parent, String type, String name, List<KML_Node> children, FaultTrace trace) {
            this.parent = parent;
            this.type = type;
            this.name = name;
            this.children = children;
            this.trace = trace;
        }

        private KML_Node(KML_Node parent, Element element) {
            String tempName;
            this.parent = parent;
            this.type = element.getName();
            Element nameEl = element.element("name");
            this.name = nameEl == null ? null : ((tempName = nameEl.getTextTrim()).isEmpty() ? null : tempName);
            if (this.type.equals("LineString")) {
                this.children = null;
                this.trace = new FaultTrace(null);
                Element coordsEl = element.element("coordinates");
                Preconditions.checkNotNull((Object)coordsEl, (Object)"LineString element doesn't have coordinates");
                String coordsText = coordsEl.getTextTrim();
                String[] coordsSplit = coordsText.split(" ");
                Preconditions.checkState((coordsSplit.length > 0 ? 1 : 0) != 0, (Object)"Coordinates element is empty!");
                for (String coords : coordsSplit) {
                    String[] ptSplit = coords.split(",");
                    Preconditions.checkState((ptSplit.length == 2 || ptSplit.length == 3 ? 1 : 0) != 0, (String)"Expected either 2 or 3 points, have %s", (int)ptSplit.length);
                    double lon = Double.parseDouble(ptSplit[0]);
                    double lat = Double.parseDouble(ptSplit[1]);
                    double depth = ptSplit.length == 3 ? -Double.parseDouble(ptSplit[2]) : 0.0;
                    this.trace.add(new Location(lat, lon, depth));
                }
            } else {
                this.trace = null;
                this.children = new ArrayList<KML_Node>();
                for (Element el : XMLUtils.getSubElementsList(element)) {
                    if (!elementsToParse.contains(el.getName())) continue;
                    this.children.add(new KML_Node(this, el));
                }
            }
        }
    }
}

