/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf;

import com.google.common.base.Preconditions;
import java.awt.HeadlessException;
import java.io.File;
import java.io.FileWriter;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.swing.JOptionPane;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.sha.earthquake.aftershocks.MagnitudeDependentAftershockFilter;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.erf.BaseFaultSystemSolutionERF;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.param.AleatoryMagAreaStdDevParam;
import org.opensha.sha.earthquake.param.ApplyGardnerKnopoffAftershockFilterParam;
import org.opensha.sha.earthquake.param.BPTAveragingTypeOptions;
import org.opensha.sha.earthquake.param.BPTAveragingTypeParam;
import org.opensha.sha.earthquake.param.HistoricOpenIntervalParam;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityOptions;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityParam;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.earthquake.param.ProbabilityModelParam;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.GaussianMagFreqDist;
import scratch.UCERF3.erf.utils.ProbabilityModelsCalc;
import scratch.UCERF3.griddedSeismicity.AbstractGridSourceProvider;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;

public class FaultSystemSolutionERF
extends BaseFaultSystemSolutionERF {
    public boolean aveRecurIntervalsInU3_BPTcalc = false;
    public boolean aveNormTimeSinceLastInU3_BPTcalc = true;
    private static final long serialVersionUID = 1L;
    protected TimeSpan tiTimeSpanCache;
    protected TimeSpan tdTimeSpanCache;
    protected AleatoryMagAreaStdDevParam aleatoryMagAreaStdDevParam;
    protected ApplyGardnerKnopoffAftershockFilterParam applyAftershockFilterParam;
    private ProbabilityModelParam probModelParam;
    private MagDependentAperiodicityParam magDepAperiodicityParam;
    private HistoricOpenIntervalParam histOpenIntervalParam;
    private BPTAveragingTypeParam averagingTypeParam;
    double aleatoryMagAreaStdDev = 0.0;
    protected boolean applyAftershockFilter = false;
    protected ProbabilityModelOptions probModel = ProbabilityModelOptions.POISSON;
    private MagDependentAperiodicityOptions magDepAperiodicity = MagDependentAperiodicityOptions.MID_VALUES;
    private double histOpenInterval = 0.0;
    protected boolean aleatoryMagAreaStdDevChanged = true;
    protected boolean applyAftershockFilterChanged = true;
    protected boolean probModelChanged = true;
    protected boolean magDepAperiodicityChanged = true;
    protected boolean histOpenIntervalChanged = true;
    public static final double MO_RATE_REDUCTION_FOR_SUPRA_SEIS_RUPS = 0.97;
    public static final int START_TIME_DEFAULT = 2014;
    protected static final int START_TIME_MIN = 1800;
    protected static final int START_TIME_MAX = 2100;
    ProbabilityModelsCalc probModelsCalc;
    public static final double PREF_BLEND_COV_LOW_WEIGHT = 0.1;
    public static final double PREF_BLEND_COV_MID_WEIGHT = 0.4;
    public static final double PREF_BLEND_COV_HIGH_WEIGHT = 0.3;
    public static final double PREF_BLEND_POISSON_WEIGHT = 0.2;
    Map<ProbabilityModelsCalc, Double> prefBlendProbModelsCalc;

    public FaultSystemSolutionERF(FaultSystemSolution faultSysSolution) {
        this();
        this.setSolution(faultSysSolution);
        this.adjustableParams.removeParameter(this.fileParam);
    }

    public FaultSystemSolutionERF(String fullPathInputFile) {
        this();
        this.fileParam.setValue(new File(fullPathInputFile));
        this.adjustableParams.removeParameter(this.fileParam);
    }

    public FaultSystemSolutionERF() {
        super(false);
        this.initParams();
        this.initTimeSpan();
    }

    @Override
    protected void initParams() {
        this.aleatoryMagAreaStdDevParam = new AleatoryMagAreaStdDevParam();
        this.applyAftershockFilterParam = new ApplyGardnerKnopoffAftershockFilterParam();
        this.probModelParam = new ProbabilityModelParam();
        this.magDepAperiodicityParam = new MagDependentAperiodicityParam();
        this.histOpenIntervalParam = new HistoricOpenIntervalParam();
        this.averagingTypeParam = new BPTAveragingTypeParam();
        this.aleatoryMagAreaStdDevParam.addParameterChangeListener(this);
        this.applyAftershockFilterParam.addParameterChangeListener(this);
        this.probModelParam.addParameterChangeListener(this);
        this.magDepAperiodicityParam.addParameterChangeListener(this);
        this.histOpenIntervalParam.addParameterChangeListener(this);
        this.averagingTypeParam.addParameterChangeListener(this);
        this.aleatoryMagAreaStdDevParam.setValue(this.aleatoryMagAreaStdDev);
        this.applyAftershockFilterParam.setValue(this.applyAftershockFilter);
        this.probModelParam.setValue(this.probModel);
        this.magDepAperiodicityParam.setValue(this.magDepAperiodicity);
        this.histOpenIntervalParam.setValue(this.histOpenInterval);
        this.updateBPTAveragingMethod();
        super.initParams();
    }

    @Override
    protected void createParamList() {
        super.createParamList();
        this.adjustableParams.addParameter(this.applyAftershockFilterParam);
        this.adjustableParams.addParameter(this.aleatoryMagAreaStdDevParam);
        this.adjustableParams.addParameter(this.probModelParam);
        if (!((ProbabilityModelOptions)((Object)this.probModelParam.getValue())).equals((Object)ProbabilityModelOptions.POISSON)) {
            if (!((ProbabilityModelOptions)((Object)this.probModelParam.getValue())).equals((Object)ProbabilityModelOptions.U3_PREF_BLEND)) {
                this.adjustableParams.addParameter(this.magDepAperiodicityParam);
            }
            this.adjustableParams.addParameter(this.histOpenIntervalParam);
        }
        if (((ProbabilityModelOptions)((Object)this.probModelParam.getValue())).equals((Object)ProbabilityModelOptions.U3_BPT) || ((ProbabilityModelOptions)((Object)this.probModelParam.getValue())).equals((Object)ProbabilityModelOptions.U3_PREF_BLEND)) {
            this.adjustableParams.addParameter(this.averagingTypeParam);
        }
    }

    public void setFltSystemSourceOccurranceTime(int srcIndex, Long epoch) {
        int fltSysRupIndex = this.getFltSysRupIndexForSource(srcIndex);
        this.setFltSystemSourceOccurranceTimeForFSSIndex(fltSysRupIndex, epoch);
    }

    public double[] getNormTimeSinceLastForSections() {
        if (this.probModelsCalc != null) {
            return this.probModelsCalc.getNormTimeSinceLastForSections(this.timeSpan.getStartTimeInMillis());
        }
        return null;
    }

    public void setFltSystemSourceOccurranceTimeForFSSIndex(int fltSysRupIndex, Long epoch) {
        FaultSystemRupSet rupSet = this.faultSysSolution.getRupSet();
        List<Integer> sectIndexList = rupSet.getSectionsIndicesForRup(fltSysRupIndex);
        Iterator<Object> iterator = sectIndexList.iterator();
        while (iterator.hasNext()) {
            int sectIndex = iterator.next();
            rupSet.getFaultSectionData(sectIndex).setDateOfLastEvent(epoch);
        }
        if (this.probModelsCalc != null) {
            this.probModelsCalc.setFltSystemRupOccurranceTime(fltSysRupIndex, epoch);
        }
        if (this.prefBlendProbModelsCalc != null) {
            for (ProbabilityModelsCalc calc : this.prefBlendProbModelsCalc.keySet()) {
                if (calc == null) continue;
                calc.setFltSystemRupOccurranceTime(fltSysRupIndex, epoch);
            }
        }
        this.probModelChanged = true;
    }

    public void setFltSectOccurranceTime(int sectIndex, Long epoch) {
        this.faultSysSolution.getRupSet().getFaultSectionData(sectIndex).setDateOfLastEvent(epoch);
        if (this.probModelsCalc != null) {
            this.probModelsCalc.setFltSectRupOccurranceTime(sectIndex, epoch);
        }
        if (this.prefBlendProbModelsCalc != null) {
            for (ProbabilityModelsCalc calc : this.prefBlendProbModelsCalc.keySet()) {
                if (calc == null) continue;
                calc.setFltSectRupOccurranceTime(sectIndex, epoch);
            }
        }
        this.probModelChanged = true;
    }

    public boolean isPoisson() {
        return this.probModel == ProbabilityModelOptions.POISSON;
    }

    @Override
    protected boolean shouldRebuildFaultSystemSources() {
        return super.shouldRebuildFaultSystemSources() || this.aleatoryMagAreaStdDevChanged || this.applyAftershockFilterChanged || this.probModelChanged || this.magDepAperiodicityChanged || this.histOpenIntervalChanged;
    }

    @Override
    protected void updateHookBeforeFaultSourceBuild() {
        if (this.faultSysSolutionChanged || this.magDepAperiodicityChanged || this.probModelChanged || this.probModelsCalc == null) {
            this.probModelsCalc = null;
            this.prefBlendProbModelsCalc = null;
            if (this.probModel != ProbabilityModelOptions.POISSON) {
                boolean hasTD = false;
                for (FaultSection faultSection : this.faultSysSolution.getRupSet().getFaultSectionDataList()) {
                    if (faultSection.getDateOfLastEvent() <= Long.MIN_VALUE) continue;
                    hasTD = true;
                    break;
                }
                if (!hasTD) {
                    String message = "WARNING: TD calculation but no sections contain date of last event data.\nOnly historical open interval will be used in TD calculations.";
                    System.out.println(message);
                    try {
                        JOptionPane.showMessageDialog(null, message, "WARNING: No Last Event Data", 0);
                    }
                    catch (HeadlessException headlessException) {
                        // empty catch block
                    }
                }
                if (this.probModel == ProbabilityModelOptions.U3_PREF_BLEND) {
                    this.prefBlendProbModelsCalc = new HashMap<ProbabilityModelsCalc, Double>(4);
                    this.prefBlendProbModelsCalc.put(new ProbabilityModelsCalc(this.faultSysSolution, this.longTermRateOfFltSysRupInERF, MagDependentAperiodicityOptions.LOW_VALUES), 0.1);
                    this.prefBlendProbModelsCalc.put(new ProbabilityModelsCalc(this.faultSysSolution, this.longTermRateOfFltSysRupInERF, MagDependentAperiodicityOptions.MID_VALUES), 0.4);
                    this.prefBlendProbModelsCalc.put(new ProbabilityModelsCalc(this.faultSysSolution, this.longTermRateOfFltSysRupInERF, MagDependentAperiodicityOptions.HIGH_VALUES), 0.3);
                    this.prefBlendProbModelsCalc.put(null, 0.2);
                    double sum = 0.0;
                    for (Double weight : this.prefBlendProbModelsCalc.values()) {
                        sum += weight.doubleValue();
                    }
                    Preconditions.checkState(((float)sum == 1.0f ? 1 : 0) != 0, (Object)"Preferred Blend weights don't sum to 1!");
                } else {
                    this.probModelsCalc = new ProbabilityModelsCalc(this.faultSysSolution, this.longTermRateOfFltSysRupInERF, this.magDepAperiodicity);
                }
            }
        }
        super.updateHookBeforeFaultSourceBuild();
    }

    @Override
    public void updateForecast() {
        super.updateForecast();
        this.aleatoryMagAreaStdDevChanged = false;
        this.applyAftershockFilterChanged = false;
        this.probModelChanged = false;
        this.magDepAperiodicityChanged = false;
        this.histOpenIntervalChanged = false;
    }

    public static double getWeightForCOV(MagDependentAperiodicityOptions cov) {
        if (cov == null) {
            return 0.2;
        }
        switch (cov) {
            case LOW_VALUES: {
                return 0.1;
            }
            case MID_VALUES: {
                return 0.4;
            }
            case HIGH_VALUES: {
                return 0.3;
            }
        }
        return 0.0;
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        String paramName = event.getParameterName();
        if (paramName.equalsIgnoreCase(this.aleatoryMagAreaStdDevParam.getName())) {
            this.aleatoryMagAreaStdDev = (Double)this.aleatoryMagAreaStdDevParam.getValue();
            this.aleatoryMagAreaStdDevChanged = true;
        } else if (paramName.equalsIgnoreCase(this.applyAftershockFilterParam.getName())) {
            this.applyAftershockFilter = (Boolean)this.applyAftershockFilterParam.getValue();
            this.applyAftershockFilterChanged = true;
        } else if (paramName.equals(this.probModelParam.getName())) {
            this.probModel = (ProbabilityModelOptions)((Object)this.probModelParam.getValue());
            this.probModelChanged = true;
            this.initTimeSpan();
            this.createParamList();
        } else if (paramName.equals(this.magDepAperiodicityParam.getName())) {
            this.magDepAperiodicity = (MagDependentAperiodicityOptions)((Object)this.magDepAperiodicityParam.getValue());
            this.magDepAperiodicityChanged = true;
        } else if (paramName.equals(this.histOpenIntervalParam.getName())) {
            this.histOpenInterval = (Double)this.histOpenIntervalParam.getValue();
            this.histOpenIntervalChanged = true;
        } else if (paramName.equals(this.averagingTypeParam.getName())) {
            this.updateBPTAveragingMethod();
        } else {
            super.parameterChange(event);
        }
    }

    private void updateBPTAveragingMethod() {
        BPTAveragingTypeOptions types = (BPTAveragingTypeOptions)((Object)this.averagingTypeParam.getValue());
        this.aveRecurIntervalsInU3_BPTcalc = types.isAveRI();
        this.aveNormTimeSinceLastInU3_BPTcalc = types.isAveNTS();
        this.histOpenIntervalChanged = true;
    }

    @Override
    protected void initTimeSpan() {
        if (this.probModel == ProbabilityModelOptions.POISSON) {
            if (this.tiTimeSpanCache == null) {
                this.tiTimeSpanCache = new TimeSpan("None", "Years");
                this.tiTimeSpanCache.setDuration(30.0);
                this.tiTimeSpanCache.addParameterChangeListener(this);
            }
            this.timeSpan = this.tiTimeSpanCache;
        } else {
            if (this.tdTimeSpanCache == null) {
                this.tdTimeSpanCache = new TimeSpan("Years", "Years");
                this.tdTimeSpanCache.setDuractionConstraint(1.0E-4, 1000000.0);
                this.tdTimeSpanCache.setDuration(30.0);
                this.tdTimeSpanCache.setStartTimeConstraint("Start Year", 1800, 2100);
                this.tdTimeSpanCache.setStartTime(2014);
                this.tdTimeSpanCache.addParameterChangeListener(this);
            }
            this.timeSpan = this.tdTimeSpanCache;
        }
    }

    @Override
    protected boolean isRuptureIncluded(int fltSystRupIndex) {
        FaultSystemRupSet rupSet = this.faultSysSolution.getRupSet();
        if (rupSet instanceof InversionFaultSystemRupSet) {
            return !((InversionFaultSystemRupSet)rupSet).isRuptureBelowSectMinMag(fltSystRupIndex);
        }
        ModSectMinMags minMags = rupSet.getModule(ModSectMinMags.class);
        if (minMags != null) {
            return !minMags.isRupBelowSectMinMag(fltSystRupIndex);
        }
        return true;
    }

    @Override
    protected MagnitudeDependentAftershockFilter getGridSourceAftershockFilter() {
        return this.applyAftershockFilter ? AbstractGridSourceProvider.GK_AFTERSHOCK_FILTER : null;
    }

    @Override
    protected DiscretizedFunc getFaultSysRupMFD(int fltSystRupIndex) {
        if (this.aleatoryMagAreaStdDev != 0.0) {
            FaultSystemRupSet rupSet = this.faultSysSolution.getRupSet();
            double meanMag = rupSet.getMagForRup(fltSystRupIndex);
            double rupRate = this.longTermRateOfFltSysRupInERF[fltSystRupIndex];
            double totMoRate = rupRate * MagUtils.magToMoment(meanMag);
            return new GaussianMagFreqDist(5.05, 8.65, 37, meanMag, this.aleatoryMagAreaStdDev, totMoRate, 2.0, 2);
        }
        return super.getFaultSysRupMFD(fltSystRupIndex);
    }

    @Override
    protected double getFaultSysRupRateGain(int fltSystRupIndex) {
        double probGain;
        double aftRateCorr = 1.0;
        if (this.applyAftershockFilter) {
            aftRateCorr = 0.97;
        }
        double duration = this.timeSpan.getDuration();
        switch (this.probModel) {
            case POISSON: {
                probGain = 1.0;
                break;
            }
            case U3_BPT: {
                probGain = this.probModelsCalc.getU3_ProbGainForRup(fltSystRupIndex, this.histOpenInterval, false, this.aveRecurIntervalsInU3_BPTcalc, this.aveNormTimeSinceLastInU3_BPTcalc, this.timeSpan.getStartTimeInMillis(), duration);
                break;
            }
            case U3_PREF_BLEND: {
                probGain = 0.0;
                for (ProbabilityModelsCalc calc : this.prefBlendProbModelsCalc.keySet()) {
                    double weight = this.prefBlendProbModelsCalc.get(calc);
                    double subProbGain = calc == null ? 1.0 : calc.getU3_ProbGainForRup(fltSystRupIndex, this.histOpenInterval, false, this.aveRecurIntervalsInU3_BPTcalc, this.aveNormTimeSinceLastInU3_BPTcalc, this.timeSpan.getStartTimeInMillis(), duration);
                    probGain += weight * subProbGain;
                }
                break;
            }
            case WG02_BPT: {
                probGain = this.probModelsCalc.getWG02_ProbGainForRup(fltSystRupIndex, false, this.timeSpan.getStartTimeInMillis(), duration);
                break;
            }
            default: {
                throw new IllegalStateException("Unrecognized Probability Model");
            }
        }
        return aftRateCorr * probGain;
    }

    @Override
    protected boolean isFaultSysRupPoisson(int fltSystRupIndex) {
        return this.probModel != ProbabilityModelOptions.U3_BPT && this.probModel != ProbabilityModelOptions.U3_PREF_BLEND;
    }

    public void writeSourceNamesToFile(String fileNameAndPath) {
        try {
            FileWriter fw1 = new FileWriter(fileNameAndPath);
            fw1.write("s\tname\n");
            for (int i = 0; i < this.getNumSources(); ++i) {
                fw1.write(i + "\t" + this.getSource(i).getName() + "\n");
            }
            fw1.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public void eraseDatesOfLastEventAfterStartTime() {
        if (this.faultSysSolution == null) {
            this.readFaultSysSolutionFromFile();
        }
        long startTime = this.getTimeSpan().getStartTimeInMillis();
        for (FaultSection faultSection : this.faultSysSolution.getRupSet().getFaultSectionDataList()) {
            if (faultSection.getDateOfLastEvent() <= startTime) continue;
            faultSection.setDateOfLastEvent(Long.MIN_VALUE);
        }
        this.probModelsCalc = null;
    }

    public static void main(String[] args) {
        long runtime = System.currentTimeMillis();
        String fileName = "dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(fileName);
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.U3_BPT);
        erf.updateForecast();
        System.out.println("run took " + runtime / 60000L + " minutes");
    }
}

