/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.epistemic;

import com.google.common.base.Preconditions;
import com.google.common.base.Stopwatch;
import java.awt.geom.Point2D;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.EnumSet;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipException;
import javax.swing.JOptionPane;
import org.opensha.commons.data.Site;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.Region;
import org.opensha.commons.logicTree.LogicTree;
import org.opensha.commons.logicTree.LogicTreeBranch;
import org.opensha.commons.logicTree.LogicTreeLevel;
import org.opensha.commons.logicTree.LogicTreeNode;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.param.ParameterList;
import org.opensha.commons.param.event.ParameterChangeEvent;
import org.opensha.commons.param.event.ParameterChangeListener;
import org.opensha.commons.param.impl.EnumParameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.modules.ModuleArchive;
import org.opensha.sha.calc.HazardCurveCalculator;
import org.opensha.sha.earthquake.BaseERF;
import org.opensha.sha.earthquake.ERF;
import org.opensha.sha.earthquake.EpistemicListERF;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.SolutionLogicTree;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.gui.infoTools.IMT_Info;
import org.opensha.sha.imr.AttenRelRef;
import org.opensha.sha.imr.AttenuationRelationship;
import org.opensha.sha.imr.ScalarIMR;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.erf.mean.MeanUCERF3;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;
import scratch.UCERF3.utils.UCERF3_Downloader;

public class UCERF3EpistemicListERF
implements EpistemicListERF,
ParameterChangeListener {
    public static final String NAME = "UCERF3 Epistemic List ERF";
    private CompletableFuture<SolutionLogicTree> fetchFuture;
    private LogicTree<?> tree;
    private FaultSystemSolutionERF paramERF;
    private ParameterList paramList;
    private static final String LOGIC_TREE_BRANCH_ALL_NAME = "(all)";
    private Map<LogicTreeLevel<? extends LogicTreeNode>, EnumParameter<?>> enumParamsMap;
    private List<LogicTreeBranch<?>> branches;
    private static final String COMPOUND_FILE_NAME = "full_logic_tree.zip";
    private HashSet<Parameter<?>> listeningParams = new HashSet();

    private static CompletableFuture<SolutionLogicTree> loadFetcher() throws ZipException, IOException {
        File storeDir = UCERF3_Downloader.getStoreDir();
        return MeanUCERF3.checkDownload(new File(storeDir, COMPOUND_FILE_NAME)).thenApply(treeFile -> {
            if (treeFile == null || !treeFile.exists()) {
                JOptionPane.showMessageDialog(null, "Failed to download full_logic_tree.zip. Verify internet connection and restart. Server may be down.", "UCERF3EpistemicListERF", 0);
                return null;
            }
            try {
                return new ModuleArchive<SolutionLogicTree>((File)treeFile, SolutionLogicTree.class).requireModule(SolutionLogicTree.class);
            }
            catch (IOException e) {
                e.printStackTrace();
                JOptionPane.showMessageDialog(null, e.getMessage(), "UCERF3EpistemicListERF", 0);
                return null;
            }
        });
    }

    public UCERF3EpistemicListERF() throws ZipException, IOException {
        this(UCERF3EpistemicListERF.loadFetcher());
    }

    public UCERF3EpistemicListERF(CompletableFuture<SolutionLogicTree> fetchFuture) {
        this.fetchFuture = fetchFuture;
        this.enumParamsMap = new HashMap();
        fetchFuture.thenAccept(fetch -> {
            this.tree = fetch.getLogicTree().sorted(new ReadOptimizedBranchComparator());
            Preconditions.checkState((fetch != null && !this.tree.getBranches().isEmpty() ? 1 : 0) != 0);
            for (LogicTreeLevel level : this.tree.getLevels()) {
                EnumParameter param = UCERF3EpistemicListERF.buildParam(this.tree, level);
                param.addParameterChangeListener(this);
                this.enumParamsMap.put(level, param);
            }
        });
        this.paramERF = new FaultSystemSolutionERF();
        this.paramERF.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
        this.createParamList();
    }

    private void createParamList() {
        this.paramList = new ParameterList();
        for (Parameter<?> param : this.paramERF.getAdjustableParameterList()) {
            if (param.getName().equals("Solution Input File")) continue;
            if (!this.listeningParams.contains(param)) {
                param.addParameterChangeListener(this);
                this.listeningParams.add(param);
            }
            this.paramList.addParameter(param);
        }
        this.fetchFuture.thenRun(() -> {
            for (LogicTreeLevel level : this.tree.getLevels()) {
                EnumParameter<?> param = this.enumParamsMap.get(level);
                if (param == null) continue;
                this.paramList.addParameter(param);
            }
        });
    }

    private static EnumParameter buildParam(LogicTree<?> tree, LogicTreeLevel<?> level) {
        HashSet<Enum> set = new HashSet<Enum>();
        Enum defaultValue = null;
        String name = level.getName();
        for (LogicTreeBranch<?> branch : tree) {
            Preconditions.checkState((boolean)branch.isFullySpecified());
            Object val = branch.getValueUnchecked(level.getType());
            Preconditions.checkNotNull(val);
            set.add((Enum)val);
        }
        Preconditions.checkState((!set.isEmpty() ? 1 : 0) != 0);
        EnumSet choices = EnumSet.copyOf(set);
        if (set.size() == 1) {
            defaultValue = (Enum)set.iterator().next();
            return new EnumParameter<Enum>(name, choices, defaultValue, null);
        }
        return new EnumParameter<Enum>(name, choices, defaultValue, LOGIC_TREE_BRANCH_ALL_NAME);
    }

    private synchronized void updateBranches() {
        this.fetchFuture.thenRun(() -> {
            if (this.branches != null) {
                return;
            }
            this.branches = new ArrayList();
            for (LogicTreeBranch<?> branch : this.tree) {
                boolean keep = true;
                for (LogicTreeLevel<? extends LogicTreeNode> level : this.enumParamsMap.keySet()) {
                    EnumParameter<?> enumParam = this.enumParamsMap.get(level);
                    LogicTreeNode node = (LogicTreeNode)enumParam.getValue();
                    if (node == null || branch.getValue(level.getType()).equals(node)) continue;
                    keep = false;
                    break;
                }
                if (!keep) continue;
                this.branches.add(branch);
            }
            System.out.println("Retained " + this.branches.size() + " branches");
        });
    }

    @Override
    public void updateForecast() {
        this.updateBranches();
    }

    @Override
    public void setTimeSpan(TimeSpan time) {
        this.paramERF.setTimeSpan(time);
    }

    @Override
    public TimeSpan getTimeSpan() {
        return this.paramERF.getTimeSpan();
    }

    @Override
    public void setParameter(String name, Object value) {
        this.paramList.getParameter(name).setValue(value);
    }

    @Override
    public ParameterList getAdjustableParameterList() {
        return this.paramList;
    }

    @Override
    public Region getApplicableRegion() {
        return null;
    }

    @Override
    public ArrayList<TectonicRegionType> getIncludedTectonicRegionTypes() {
        ArrayList<TectonicRegionType> list = new ArrayList<TectonicRegionType>();
        list.add(TectonicRegionType.ACTIVE_SHALLOW);
        return list;
    }

    @Override
    public String getName() {
        return NAME;
    }

    @Override
    public int compareTo(BaseERF o) {
        return this.getName().compareToIgnoreCase(o.getName());
    }

    @Override
    public ERF getERF(int index) {
        this.updateBranches();
        this.fetchFuture.join();
        LogicTreeBranch<?> branch = this.branches.get(index);
        try {
            return this.loadERF(branch).get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
            return null;
        }
    }

    private CompletableFuture<FaultSystemSolutionERF> loadERF(LogicTreeBranch<?> branch) {
        System.out.println("LoadERF for " + branch.buildFileName());
        System.out.println("Loading solution...");
        return this.fetchFuture.thenApply(fetch -> {
            FaultSystemSolution sol;
            try {
                sol = fetch.forBranch(branch);
            }
            catch (IOException e) {
                throw ExceptionUtils.asRuntimeException(e);
            }
            System.out.println("DONE loading");
            System.out.println("Building ERF...");
            FaultSystemSolutionERF erf = new FaultSystemSolutionERF(sol);
            erf.setCacheGridSources(false);
            for (Parameter<?> param : this.paramERF.getAdjustableParameterList()) {
                if (param.getName().equals("Solution Input File")) continue;
                erf.setParameter(param.getName(), param.getValue());
            }
            erf.setTimeSpan(this.paramERF.getTimeSpan());
            System.out.println("Updating forecast...");
            erf.updateForecast();
            System.out.println("DONE LoadERF");
            return erf;
        });
    }

    @Override
    public double getERF_RelativeWeight(int index) {
        this.updateBranches();
        return this.tree.getBranchWeight(this.branches.get(index));
    }

    @Override
    public ArrayList<Double> getRelativeWeightsList() {
        this.updateBranches();
        ArrayList<Double> weights = new ArrayList<Double>();
        for (LogicTreeBranch<?> branch : this.branches) {
            weights.add(this.tree.getBranchWeight(branch));
        }
        return weights;
    }

    @Override
    public int getNumERFs() {
        try {
            this.fetchFuture.get();
        }
        catch (InterruptedException | ExecutionException e) {
            e.printStackTrace();
        }
        this.updateBranches();
        return this.branches.size();
    }

    @Override
    public void parameterChange(ParameterChangeEvent event) {
        if (this.enumParamsMap.containsValue(event.getParameter())) {
            this.branches = null;
        }
        this.createParamList();
    }

    public static void main(String[] args) throws ZipException, IOException {
        UCERF3EpistemicListERF erf = new UCERF3EpistemicListERF();
        Stopwatch totalWatch = Stopwatch.createStarted();
        erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.INCLUDE);
        erf.setParameter("Fault Model", FaultModels.FM3_1);
        erf.setParameter("Deformation Model", DeformationModels.ZENGBB);
        erf.setParameter("Scaling Relationship", ScalingRelationships.SHAW_2009_MOD);
        erf.updateForecast();
        HazardCurveCalculator calc = new HazardCurveCalculator();
        AttenuationRelationship gmpe = AttenRelRef.ASK_2014.instance(null);
        gmpe.setParamDefaults();
        Site site = new Site(new Location(34.0, -118.0));
        site.addParameterList(gmpe.getSiteParams());
        ArbitrarilyDiscretizedFunc xVals = IMT_Info.getUSGS_SA_Function();
        ArbitrarilyDiscretizedFunc logXVals = new ArbitrarilyDiscretizedFunc();
        for (Point2D pt : xVals) {
            logXVals.set(Math.log(pt.getX()), 0.0);
        }
        double totCalcSecs = 0.0;
        double totLoadSecs = 0.0;
        for (int i = 0; i < erf.getNumERFs(); ++i) {
            Stopwatch buildWatch = Stopwatch.createStarted();
            ERF subERF = erf.getERF(i);
            buildWatch.stop();
            double secs = (double)buildWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            totLoadSecs += secs;
            System.out.println("Took " + (float)secs + " s to build");
            System.out.println("Calculating...");
            Stopwatch calcWatch = Stopwatch.createStarted();
            calc.getHazardCurve((DiscretizedFunc)logXVals, site, (ScalarIMR)gmpe, subERF);
            calcWatch.stop();
            secs = (double)calcWatch.elapsed(TimeUnit.MILLISECONDS) / 1000.0;
            totCalcSecs += secs;
            System.out.println("Took " + (float)secs + " s to calc");
        }
        totalWatch.stop();
        System.out.println("TOTAL took " + totalWatch.elapsed(TimeUnit.SECONDS) + " s");
        System.out.println("\t" + (float)totLoadSecs + " s loading");
        System.out.println("\t" + (float)totCalcSecs + " s calculating");
    }

    private class ReadOptimizedBranchComparator
    implements Comparator<LogicTreeBranch<? extends LogicTreeNode>> {
        List<Class<? extends U3LogicTreeBranchNode<?>>> sortOrderClasses = new ArrayList();

        public ReadOptimizedBranchComparator() {
            this.sortOrderClasses.addAll(U3LogicTreeBranch.getLogicTreeNodeClasses());
        }

        @Override
        public int compare(LogicTreeBranch<? extends LogicTreeNode> b1, LogicTreeBranch<? extends LogicTreeNode> b2) {
            Preconditions.checkState((b1.size() == this.sortOrderClasses.size() ? 1 : 0) != 0);
            Preconditions.checkState((b2.size() == this.sortOrderClasses.size() ? 1 : 0) != 0);
            for (Class<? extends U3LogicTreeBranchNode<?>> clazz : this.sortOrderClasses) {
                LogicTreeNode val = b1.getValueUnchecked(clazz);
                LogicTreeNode oval = b2.getValueUnchecked(clazz);
                int cmp = val.getShortName().compareTo(oval.getShortName());
                if (cmp == 0) continue;
                return cmp;
            }
            return 0;
        }
    }
}

