/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.mean;

import com.google.common.base.Stopwatch;
import java.io.File;
import java.io.IOException;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.zip.ZipException;
import java.util.zip.ZipFile;
import org.dom4j.DocumentException;
import org.opensha.commons.data.CSVFile;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.faultSysSolution.modules.RupMFDsModule;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.faultSurface.CompoundSurface;
import org.opensha.sha.faultSurface.RuptureSurface;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.erf.mean.MeanUCERF3;
import scratch.UCERF3.erf.mean.RakeBasisWriter;
import scratch.UCERF3.erf.mean.RuptureCombiner;
import scratch.UCERF3.utils.U3FaultSystemIO;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class ERF_Tester {
    private static void asdf(FaultSystemSolution sol) throws ZipException, IOException {
        FaultSystemRupSet rupSet = sol.getRupSet();
        double upperDepthTol = 0.0;
        boolean combineRakes = false;
        double combineMags = 0.0;
        Map<Set<String>, Double> rakeBasis = null;
        if (combineRakes) {
            System.out.println("Loading rake basis...");
            ZipFile rakeBasisZip = new ZipFile(new File("/tmp/rake_basis.zip"));
            rakeBasis = RakeBasisWriter.loadRakeBasis(rakeBasisZip, DeformationModels.GEOLOGIC);
        }
        System.out.println("Combining rups for tol=" + upperDepthTol + ", combineRakes=" + combineRakes + ", combineMags=" + combineMags);
        Stopwatch watch = Stopwatch.createStarted();
        FaultSystemSolution reducedSol = RuptureCombiner.getCombinedSolution(sol, upperDepthTol, false, combineRakes, rakeBasis);
        if (combineMags > 0.0) {
            reducedSol.addModule(new RupMFDsModule(reducedSol, RuptureCombiner.combineMFDs(combineMags, reducedSol.getModule(RupMFDsModule.class).getRuptureMFDs())));
        }
        FaultSystemRupSet reducedRupSet = reducedSol.getRupSet();
        watch.stop();
        System.out.println("DONE. Took " + watch.elapsed(TimeUnit.SECONDS) + "s to reduce to " + reducedRupSet.getNumRuptures() + "/" + rupSet.getNumRuptures() + " rups and " + reducedRupSet.getNumSections() + "/" + rupSet.getNumSections() + " sects");
        RuptureCombiner.checkIdentical(sol, reducedSol, true);
        System.exit(0);
    }

    private static void debugOrig(FaultSystemSolution sol) {
        HashSet rupsList = new HashSet();
        FaultSystemRupSet rupSet = sol.getRupSet();
        for (int i = 0; i < rupSet.getNumRuptures(); ++i) {
            HashSet<Integer> hashSet = new HashSet<Integer>(rupSet.getSectionsIndicesForRup(i));
        }
        System.exit(0);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File invDir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "InversionSolutions");
        File meanSolFile = new File(invDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_TRUE_HAZARD_MEAN_SOL.zip");
        System.out.println("Loading solution...");
        U3FaultSystemSolution sol = U3FaultSystemIO.loadSol(meanSolFile);
        ERF_Tester.asdf(sol);
        FaultSystemRupSet rupSet = ((FaultSystemSolution)sol).getRupSet();
        System.out.println("done.");
        System.out.println("Instantiating ERF...");
        MeanUCERF3 erf = new MeanUCERF3(sol);
        System.out.println("done.");
        System.out.println("Updating forecast...");
        erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
        erf.updateForecast();
        System.out.println("done.");
        System.out.println("sources: " + erf.getNumSources());
        int totRups = 0;
        long surfPts = 0L;
        for (int i = 0; i < erf.getNumSources(); ++i) {
            ProbEqkSource source = erf.getSource(i);
            totRups += source.getNumRuptures();
            CompoundSurface surf = (CompoundSurface)source.getSourceSurface();
            for (RuptureSurface ruptureSurface : surf.getSurfaceList()) {
                surfPts += (long)ruptureSurface.getEvenlyDiscritizedListOfLocsOnSurface().size();
            }
        }
        System.out.println("ruptures: " + totRups);
        System.out.println("surf locs: " + surfPts);
        System.exit(0);
        CSVFile<String> csv = new CSVFile<String>(true);
        csv.addLine("Upper Depth Tol (km)", "Combine Mags?", "Combine Rakes?", "# FSS Rups", "# FSS Sects", "# Sources", "# Rups");
        double[] upperDepthTols = new double[]{0.0, 1.0, 5.0, Double.POSITIVE_INFINITY};
        boolean[] rakeCombines = new boolean[]{false, true};
        for (Object upperDepthTol : (Object)upperDepthTols) {
            for (boolean combineRakes : rakeCombines) {
                int i;
                erf = null;
                System.gc();
                System.out.println("Combining rups for tol=" + (double)upperDepthTol + ", combineRakes=" + combineRakes);
                Stopwatch watch = Stopwatch.createStarted();
                FaultSystemSolution reducedSol = RuptureCombiner.getCombinedSolution(sol, (double)upperDepthTol, false, combineRakes, null);
                FaultSystemRupSet reducedRupSet = reducedSol.getRupSet();
                watch.stop();
                System.out.println("DONE. Took " + watch.elapsed(TimeUnit.SECONDS) + "s to reduce to " + reducedRupSet.getNumRuptures() + "/" + rupSet.getNumRuptures() + " rups and " + reducedRupSet.getNumSections() + "/" + rupSet.getNumSections() + " sects");
                System.out.println("Instantiating ERF...");
                erf = new MeanUCERF3(reducedSol);
                System.out.println("done.");
                System.out.println("Updating forecast...");
                erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
                erf.updateForecast();
                System.out.println("done.");
                System.out.println("sources: " + erf.getNumSources());
                totRups = 0;
                for (i = 0; i < erf.getNumSources(); ++i) {
                    totRups += erf.getNumRuptures(i);
                }
                System.out.println("ruptures: " + totRups);
                csv.addLine("" + (double)upperDepthTol, "false", "" + combineRakes, "" + reducedRupSet.getNumRuptures(), "" + reducedRupSet.getNumSections(), "" + erf.getNumSources(), "" + totRups);
                System.out.println("Clearning rup MFDs for mean mags");
                reducedSol.removeModuleInstances(RupMFDsModule.class);
                System.out.println("Instantiating ERF...");
                erf = new MeanUCERF3(reducedSol);
                System.out.println("done.");
                System.out.println("Updating forecast...");
                erf.setParameter("Background Seismicity", (Object)IncludeBackgroundOption.EXCLUDE);
                erf.updateForecast();
                System.out.println("done.");
                System.out.println("sources: " + erf.getNumSources());
                totRups = 0;
                for (i = 0; i < erf.getNumSources(); ++i) {
                    totRups += erf.getNumRuptures(i);
                }
                System.out.println("ruptures: " + totRups);
                csv.addLine("" + (double)upperDepthTol, "true", "" + combineRakes, "" + reducedRupSet.getNumRuptures(), "" + reducedRupSet.getNumSections(), "" + erf.getNumSources(), "" + totRups);
            }
        }
        csv.writeToFile(new File("/tmp/mean_ucerf3_counts.csv"));
    }
}

