/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.mean;

import java.io.File;
import java.io.IOException;
import org.dom4j.DocumentException;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.utils.U3FaultSystemIO;

public class MemoryDebug {
    public static void main(String[] args) throws IOException, DocumentException, InterruptedException {
        File meanTotalSolFile = new File("/home/kevin/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/InversionSolutions/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip");
        System.out.println("Loading sol");
        U3FaultSystemSolution meanTotalSol = U3FaultSystemIO.loadSol(meanTotalSolFile);
        System.out.println("Done");
        System.out.println("Creating ERF");
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(meanTotalSol);
        System.out.println("Updating forecast");
        erf.updateForecast();
        System.out.println("Done");
        System.out.println(MemoryDebug.getMemoryDebug());
        while (true) {
            erf.getSource((int)(Math.random() * (double)erf.getNumSources() - 1.0));
            Thread.sleep(10000L);
        }
    }

    private static String getMemoryDebug() {
        System.gc();
        try {
            Thread.sleep(1000L);
        }
        catch (InterruptedException interruptedException) {
            // empty catch block
        }
        Runtime rt = Runtime.getRuntime();
        long totalMB = rt.totalMemory() / 1024L / 1024L;
        long freeMB = rt.freeMemory() / 1024L / 1024L;
        long usedMB = totalMB - freeMB;
        return "mem t/u/f: " + totalMB + "/" + usedMB + "/" + freeMB;
    }
}

