/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.erf.utils;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.invoke.CallSite;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.math3.random.RandomDataGenerator;
import org.opensha.commons.calc.FaultMomentCalc;
import org.opensha.commons.data.TimeSpan;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.AbstractXY_DataSet;
import org.opensha.commons.data.function.ArbDiscrEmpiricalDistFunc_3D;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.data.function.DefaultXY_DataSet;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.HistogramFunction;
import org.opensha.commons.data.function.IntegerPDF_FunctionSampler;
import org.opensha.commons.data.xyz.EvenlyDiscrXYZ_DataSet;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.commons.gui.plot.jfreechart.xyzPlot.XYZPlotSpec;
import org.opensha.commons.mapping.gmt.elements.GMT_CPT_Files;
import org.opensha.commons.param.Parameter;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.cpt.CPT;
import org.opensha.sha.earthquake.ProbEqkRupture;
import org.opensha.sha.earthquake.ProbEqkSource;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.calc.recurInterval.BPT_DistCalc;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemSolution;
import org.opensha.sha.earthquake.param.BPTAveragingTypeOptions;
import org.opensha.sha.earthquake.param.IncludeBackgroundOption;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityOptions;
import org.opensha.sha.earthquake.param.MagDependentAperiodicityParam;
import org.opensha.sha.earthquake.param.ProbabilityModelOptions;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.gui.infoTools.CalcProgressBar;
import org.opensha.sha.magdist.SummedMagFreqDist;
import scratch.UCERF3.erf.FaultSystemSolutionERF;
import scratch.UCERF3.erf.utils.ProbModelsPlottingUtils;
import scratch.UCERF3.inversion.InversionFaultSystemRupSet;
import scratch.UCERF3.utils.UCERF3_DataUtils;
import scratch.UCERF3.utils.paleoRateConstraints.U3PaleoRateConstraint;
import scratch.UCERF3.utils.paleoRateConstraints.UCERF3_PaleoRateConstraintFetcher;

public class ProbabilityModelsCalc {
    public static final boolean D = true;
    public static final double MILLISEC_PER_YEAR = 3.15576E10;
    public static final long MILLISEC_PER_DAY = 86400000L;
    FaultSystemSolutionERF erf;
    FaultSystemSolution fltSysSolution;
    double[] longTermRateOfFltSysRup;
    FaultSystemRupSet fltSysRupSet;
    int numRupsInFaultSystem;
    int numSections;
    double[] longTermPartRateForSectArray;
    double[] sectionArea;
    long[] dateOfLastForSect;
    double[] aveCondRecurIntervalForFltSysRups_type1;
    double[] aveCondRecurIntervalForFltSysRups_type2;
    static double refRI = 1.0;
    static double deltaT = 5.0E-4;
    public static boolean interpolate = false;
    BPT_DistCalc[] refBPT_CalcArray;
    int numAperValues;
    double[] aperValues;
    double[] aperMagBoundaries;
    static double max_time_for_normBPT_CDF = 5.0;
    static int num_for_normBPT_CDF = 501;
    EvenlyDiscretizedFunc[] normBPT_CDF_Array;
    ArbitrarilyDiscretizedFunc OLDbptTimeToPoisCondProbFunc;
    double[] OLDbptNormTimeToPoisCondProbFuncForSect;
    EvenlyDiscrXYZ_DataSet equivLastEventTimeForHistOpenInterval_XYZ_Func;
    double[] sectionGainArray;
    boolean[] sectionGainReal;
    double totRupArea;
    double totRupAreaWithDateOfLast;
    boolean allSectionsHadDateOfLast;
    boolean noSectionsHadDateOfLast;
    public String u3_ProgGainForRupInfoString;
    static final File dataDir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, File.separator + "erSimulations");
    boolean simulationMode = false;
    HistogramFunction simNormTimeSinceLastHist;
    HistogramFunction simNormTimeSinceLastForMagBelow7_Hist;
    HistogramFunction simNormTimeSinceLastForMagAbove7_Hist;
    HistogramFunction simProbGainHist;
    HistogramFunction simProbGainForMagBelow7_Hist;
    HistogramFunction simProbGainForMagAbove7_Hist;

    public ProbabilityModelsCalc(FaultSystemSolution fltSysSolution, double[] longTermRateOfFltSysRupInERF, MagDependentAperiodicityOptions magDepAperiodicity) {
        this.fltSysSolution = fltSysSolution;
        this.longTermRateOfFltSysRup = longTermRateOfFltSysRupInERF;
        this.aperValues = magDepAperiodicity.getAperValuesArray();
        this.numAperValues = this.aperValues.length;
        this.aperMagBoundaries = magDepAperiodicity.getAperMagBoundariesArray();
        this.fltSysRupSet = fltSysSolution.getRupSet();
        this.numRupsInFaultSystem = this.fltSysRupSet.getNumRuptures();
        this.numSections = this.fltSysRupSet.getNumSections();
        this.initializeArrays();
        this.refBPT_CalcArray = this.getRef_BPT_DistCalcArray();
        this.normBPT_CDF_Array = this.getNormBPT_CDF_Array();
    }

    public ProbabilityModelsCalc(FaultSystemSolutionERF erf) {
        this.erf = erf;
        this.fltSysSolution = erf.getSolution();
        this.longTermRateOfFltSysRup = erf.getLongTermRateOfFltSysRupInERF();
        if (erf.getParameter("Probability Model").getValue() == ProbabilityModelOptions.U3_PREF_BLEND) {
            throw new RuntimeException("This constructor can't be used with " + String.valueOf((Object)ProbabilityModelOptions.U3_PREF_BLEND));
        }
        MagDependentAperiodicityOptions magDepAperiodicity = null;
        if (erf.getAdjustableParameterList().containsParameter("Aperiodicity")) {
            magDepAperiodicity = (MagDependentAperiodicityOptions)((Object)((MagDependentAperiodicityParam)erf.getParameter("Aperiodicity")).getValue());
            this.aperValues = magDepAperiodicity.getAperValuesArray();
            this.numAperValues = this.aperValues.length;
            this.aperMagBoundaries = magDepAperiodicity.getAperMagBoundariesArray();
        } else {
            this.numAperValues = 0;
        }
        this.fltSysRupSet = this.fltSysSolution.getRupSet();
        this.numRupsInFaultSystem = this.fltSysRupSet.getNumRuptures();
        this.numSections = this.fltSysRupSet.getNumSections();
        this.initializeArrays();
        this.refBPT_CalcArray = this.getRef_BPT_DistCalcArray();
        this.normBPT_CDF_Array = this.getNormBPT_CDF_Array();
    }

    public ProbabilityModelsCalc(double aperiodicity) {
        this.numAperValues = 1;
        this.aperValues = new double[1];
        this.aperValues[0] = aperiodicity;
        this.aperMagBoundaries = null;
        this.refBPT_CalcArray = this.getRef_BPT_DistCalcArray();
        this.normBPT_CDF_Array = this.getNormBPT_CDF_Array();
    }

    private void initializeArrays() {
        this.longTermPartRateForSectArray = new double[this.numSections];
        for (int r = 0; r < this.numRupsInFaultSystem; ++r) {
            List<Integer> sectIndices = this.fltSysRupSet.getSectionsIndicesForRup(r);
            for (int s = 0; s < sectIndices.size(); ++s) {
                int sectID;
                int n = sectID = sectIndices.get(s).intValue();
                this.longTermPartRateForSectArray[n] = this.longTermPartRateForSectArray[n] + this.longTermRateOfFltSysRup[r];
            }
        }
        this.sectionArea = new double[this.numSections];
        this.dateOfLastForSect = new long[this.numSections];
        for (int s = 0; s < this.numSections; ++s) {
            FaultSection sectData = this.fltSysRupSet.getFaultSectionData(s);
            this.sectionArea[s] = sectData.getTraceLength() * sectData.getReducedDownDipWidth();
            this.dateOfLastForSect[s] = sectData.getDateOfLastEvent();
        }
    }

    private double[] computeAveCondRecurIntervalForFltSysRups(int typeCalc) {
        double[] aveCondRecurIntervalForFltSysRups = new double[this.numRupsInFaultSystem];
        for (int r = 0; r < this.numRupsInFaultSystem; ++r) {
            List<FaultSection> fltData = this.fltSysRupSet.getFaultSectionDataForRupture(r);
            double ave = 0.0;
            double totArea = 0.0;
            double maxRI = 0.0;
            for (FaultSection data : fltData) {
                int sectID = data.getSectionId();
                double area = this.sectionArea[sectID];
                totArea += area;
                if (1.0 / this.longTermPartRateForSectArray[sectID] > maxRI) {
                    maxRI = 1.0 / this.longTermPartRateForSectArray[sectID];
                }
                if (typeCalc == 1) {
                    ave += area / this.longTermPartRateForSectArray[sectID];
                    continue;
                }
                if (typeCalc == 2) {
                    ave += this.longTermPartRateForSectArray[sectID] * area;
                    continue;
                }
                throw new RuntimeException("Bad typeCalcForU3_Probs");
            }
            aveCondRecurIntervalForFltSysRups[r] = typeCalc == 1 ? ave / totArea : 1.0 / (ave / totArea);
        }
        return aveCondRecurIntervalForFltSysRups;
    }

    private double computeAveCondRecurIntForFltSysRupsWhereDateLastUnknown(int fltSysRupIndex, boolean aveRI_CalcType, long presentTimeMillis) {
        List<Integer> sectID_List = this.fltSysRupSet.getSectionsIndicesForRup(fltSysRupIndex);
        double ave = 0.0;
        double totArea = 0.0;
        for (Integer sectID : sectID_List) {
            long dateOfLastMillis = this.dateOfLastForSect[sectID];
            if (dateOfLastMillis != Long.MIN_VALUE && dateOfLastMillis <= presentTimeMillis) continue;
            double area = this.sectionArea[sectID];
            totArea += area;
            if (aveRI_CalcType) {
                ave += area / this.longTermPartRateForSectArray[sectID];
                continue;
            }
            ave += this.longTermPartRateForSectArray[sectID] * area;
        }
        if (totArea == 0.0) {
            return Double.NaN;
        }
        if (aveRI_CalcType) {
            return ave / totArea;
        }
        return 1.0 / (ave / totArea);
    }

    public long getAveDateOfLastEventWhereKnown(int fltSystRupIndex, Long presentTimeMillis) {
        this.totRupArea = 0.0;
        this.totRupAreaWithDateOfLast = 0.0;
        int numWithDateOfLast = 0;
        this.allSectionsHadDateOfLast = true;
        this.noSectionsHadDateOfLast = false;
        double sumDateOfLast = 0.0;
        for (int s : this.fltSysRupSet.getSectionsIndicesForRup(fltSystRupIndex)) {
            long dateOfLast = this.dateOfLastForSect[s];
            double area = this.sectionArea[s];
            this.totRupArea += area;
            if (dateOfLast != Long.MIN_VALUE && (presentTimeMillis == null || dateOfLast <= presentTimeMillis)) {
                sumDateOfLast += (double)dateOfLast * area;
                this.totRupAreaWithDateOfLast += area;
                ++numWithDateOfLast;
                continue;
            }
            this.allSectionsHadDateOfLast = false;
        }
        if (numWithDateOfLast > 0) {
            return Math.round(sumDateOfLast / this.totRupAreaWithDateOfLast);
        }
        this.noSectionsHadDateOfLast = true;
        return Long.MIN_VALUE;
    }

    public double getAveNormTimeSinceLastEventWhereKnown(int fltSystRupIndex, long presentTimeMillis) {
        this.totRupArea = 0.0;
        this.totRupAreaWithDateOfLast = 0.0;
        this.allSectionsHadDateOfLast = true;
        int numWithDateOfLast = 0;
        this.noSectionsHadDateOfLast = false;
        double sumNormTimeSinceLast = 0.0;
        for (int s : this.fltSysRupSet.getSectionsIndicesForRup(fltSystRupIndex)) {
            long dateOfLast = this.dateOfLastForSect[s];
            double area = this.sectionArea[s];
            this.totRupArea += area;
            if (dateOfLast != Long.MIN_VALUE && dateOfLast <= presentTimeMillis) {
                sumNormTimeSinceLast += area * ((double)(presentTimeMillis - dateOfLast) / 3.15576E10) * this.longTermPartRateForSectArray[s];
                this.totRupAreaWithDateOfLast += area;
                ++numWithDateOfLast;
                continue;
            }
            this.allSectionsHadDateOfLast = false;
        }
        if (numWithDateOfLast > 0) {
            return sumNormTimeSinceLast / this.totRupAreaWithDateOfLast;
        }
        this.noSectionsHadDateOfLast = true;
        return Double.NaN;
    }

    public int writeSectionsWithDateOfLastEvent() {
        List<? extends FaultSection> fltData = this.fltSysRupSet.getFaultSectionDataList();
        int numWith = 0;
        System.out.println("Sections With Date of Last Event Data (timeSinceLastYears, dateOfLastMillis, sectName):");
        for (FaultSection faultSection : fltData) {
            long dateOfLastMillis = faultSection.getDateOfLastEvent();
            if (dateOfLastMillis == Long.MIN_VALUE) continue;
            System.out.println(dateOfLastMillis + "\t" + faultSection.getName());
            ++numWith;
        }
        return numWith;
    }

    public void writeInfoForRupsOnSect(int sectID) {
        String fileName = "RupInfoForSect" + sectID + ".txt";
        if (!dataDir.exists()) {
            dataDir.mkdir();
        }
        File dataFile = new File(dataDir, File.separator + fileName);
        String sectName = this.fltSysRupSet.getFaultSectionData(sectID).getName();
        try {
            FileWriter fileWriter = new FileWriter(dataFile);
            fileWriter.write("rupID\trate\tyrsSince\tfracWithDateOfLast\t" + sectName + "\n");
            for (int r = 0; r < this.fltSysRupSet.getNumRuptures(); ++r) {
                if (!this.fltSysRupSet.getSectionsIndicesForRup(r).contains(sectID)) continue;
                double rate = this.longTermRateOfFltSysRup[r];
                long aveDateOfLastMillis = this.getAveDateOfLastEventWhereKnown(r, null);
                double yrsSinceLast = (1.3885344E12 - (double)aveDateOfLastMillis) / 3.15576E10;
                List<Integer> indices = this.fltSysRupSet.getSectionsIndicesForRup(r);
                String name1 = this.fltSysRupSet.getFaultSectionData(indices.get(0)).getName();
                String name2 = this.fltSysRupSet.getFaultSectionData(indices.get(indices.size() - 1)).getName();
                String line = r + "\t" + rate + "\t" + yrsSinceLast + "\t" + this.totRupAreaWithDateOfLast / this.totRupArea + "\t" + name1 + "\t" + name2 + "\n";
                fileWriter.write(line);
            }
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public double getU3_ProbGainForRup(int fltSysRupIndex, double histOpenInterval, boolean onlyIfAllSectionsHaveDateOfLast, boolean aveRecurIntervals, boolean aveNormTimeSinceLast, long presentTimeMillis, double durationYears) {
        double probGain;
        double aveTimeSinceLastWhereKnownYears;
        double aveCondRecurInterval;
        double rupMag = this.fltSysRupSet.getMagForRup(fltSysRupIndex);
        if (aveRecurIntervals) {
            if (this.aveCondRecurIntervalForFltSysRups_type1 == null) {
                this.aveCondRecurIntervalForFltSysRups_type1 = this.computeAveCondRecurIntervalForFltSysRups(1);
            }
            aveCondRecurInterval = this.aveCondRecurIntervalForFltSysRups_type1[fltSysRupIndex];
        } else {
            if (this.aveCondRecurIntervalForFltSysRups_type2 == null) {
                this.aveCondRecurIntervalForFltSysRups_type2 = this.computeAveCondRecurIntervalForFltSysRups(2);
            }
            aveCondRecurInterval = this.aveCondRecurIntervalForFltSysRups_type2[fltSysRupIndex];
        }
        double aveNormTimeSinceLastEventWhereKnown = Double.NaN;
        if (aveNormTimeSinceLast) {
            aveNormTimeSinceLastEventWhereKnown = this.getAveNormTimeSinceLastEventWhereKnown(fltSysRupIndex, presentTimeMillis);
            aveTimeSinceLastWhereKnownYears = aveNormTimeSinceLastEventWhereKnown * aveCondRecurInterval;
        } else {
            long aveTimeOfLastMillisWhereKnown = this.getAveDateOfLastEventWhereKnown(fltSysRupIndex, presentTimeMillis);
            aveTimeSinceLastWhereKnownYears = aveTimeOfLastMillisWhereKnown != Long.MIN_VALUE ? (double)(presentTimeMillis - aveTimeOfLastMillisWhereKnown) / 3.15576E10 : Double.NaN;
        }
        Preconditions.checkState((Double.isNaN(aveTimeSinceLastWhereKnownYears) || aveTimeSinceLastWhereKnownYears >= 0.0 ? 1 : 0) != 0, (String)"aveTimeSinceLastWhereKnownYears=%s", (Object)aveTimeSinceLastWhereKnownYears);
        double expNum = durationYears / aveCondRecurInterval;
        if (onlyIfAllSectionsHaveDateOfLast && !this.allSectionsHadDateOfLast) {
            probGain = Double.NaN;
        } else if (this.allSectionsHadDateOfLast) {
            probGain = this.computeBPT_ProbFast(aveCondRecurInterval, aveTimeSinceLastWhereKnownYears, durationYears, rupMag) / expNum;
        } else if (this.noSectionsHadDateOfLast) {
            probGain = this.computeBPT_ProbForUnknownDateOfLastFast(aveCondRecurInterval, histOpenInterval, durationYears, rupMag) / expNum;
        } else {
            int i;
            EvenlyDiscretizedFunc normBPT_CDF = this.normBPT_CDF_Array[this.getAperIndexForRupMag(rupMag)];
            double sumCondProbGain = 0.0;
            double totWeight = 0.0;
            double areaWithOutDateOfLast = this.totRupArea - this.totRupAreaWithDateOfLast;
            double condRecurIntWhereUnknown = this.computeAveCondRecurIntForFltSysRupsWhereDateLastUnknown(fltSysRupIndex, aveRecurIntervals, presentTimeMillis);
            if (aveNormTimeSinceLast) {
                for (i = 0; i < normBPT_CDF.size(); ++i) {
                    double normTimeSinceYears = normBPT_CDF.getX(i);
                    double relProbForTimeSinceLast = 1.0 - normBPT_CDF.getY(i);
                    if (!(normTimeSinceYears * condRecurIntWhereUnknown >= histOpenInterval) || !(relProbForTimeSinceLast > 1.0E-15)) continue;
                    double aveNormTS = (normTimeSinceYears * areaWithOutDateOfLast + aveNormTimeSinceLastEventWhereKnown * this.totRupAreaWithDateOfLast) / this.totRupArea;
                    double condProb = this.computeBPT_ProbFast(1.0, aveNormTS, durationYears / aveCondRecurInterval, rupMag);
                    sumCondProbGain += condProb / expNum * relProbForTimeSinceLast;
                    totWeight += relProbForTimeSinceLast;
                }
            } else {
                for (i = 0; i < normBPT_CDF.size(); ++i) {
                    double timeSinceYears = normBPT_CDF.getX(i) * condRecurIntWhereUnknown;
                    double relProbForTimeSinceLast = 1.0 - normBPT_CDF.getY(i);
                    if (!(timeSinceYears >= histOpenInterval) || !(relProbForTimeSinceLast > 1.0E-15)) continue;
                    double aveTimeSinceLast = (timeSinceYears * areaWithOutDateOfLast + aveTimeSinceLastWhereKnownYears * this.totRupAreaWithDateOfLast) / this.totRupArea;
                    double condProb = this.computeBPT_ProbFast(aveCondRecurInterval, aveTimeSinceLast, durationYears, rupMag);
                    sumCondProbGain += condProb / expNum * relProbForTimeSinceLast;
                    totWeight += relProbForTimeSinceLast;
                }
            }
            if (totWeight > 0.0) {
                probGain = sumCondProbGain / totWeight;
            } else if (aveNormTimeSinceLast) {
                double normTimeSinceYearsUnknown = histOpenInterval / condRecurIntWhereUnknown;
                double aveNormTS = (normTimeSinceYearsUnknown * areaWithOutDateOfLast + aveNormTimeSinceLastEventWhereKnown * this.totRupAreaWithDateOfLast) / this.totRupArea;
                double condProb = this.computeBPT_ProbFast(1.0, aveNormTS, durationYears / aveCondRecurInterval, rupMag);
                probGain = condProb / expNum;
            } else {
                double aveTimeSinceLast = (histOpenInterval * areaWithOutDateOfLast + aveTimeSinceLastWhereKnownYears * this.totRupAreaWithDateOfLast) / this.totRupArea;
                double condProb = this.computeBPT_ProbFast(aveCondRecurInterval, aveTimeSinceLast, durationYears, rupMag);
                probGain = condProb / expNum;
            }
        }
        this.u3_ProgGainForRupInfoString = new String();
        this.u3_ProgGainForRupInfoString = this.u3_ProgGainForRupInfoString + fltSysRupIndex + ",";
        this.u3_ProgGainForRupInfoString = this.u3_ProgGainForRupInfoString + rupMag + ",";
        this.u3_ProgGainForRupInfoString = this.u3_ProgGainForRupInfoString + aveCondRecurInterval + ",";
        this.u3_ProgGainForRupInfoString = this.u3_ProgGainForRupInfoString + aveNormTimeSinceLastEventWhereKnown + ",";
        this.u3_ProgGainForRupInfoString = this.u3_ProgGainForRupInfoString + probGain + ",";
        this.u3_ProgGainForRupInfoString = this.u3_ProgGainForRupInfoString + this.totRupArea + ",";
        this.u3_ProgGainForRupInfoString = this.u3_ProgGainForRupInfoString + this.totRupAreaWithDateOfLast + ",";
        this.u3_ProgGainForRupInfoString = this.u3_ProgGainForRupInfoString + this.allSectionsHadDateOfLast + ",";
        this.u3_ProgGainForRupInfoString = this.u3_ProgGainForRupInfoString + this.noSectionsHadDateOfLast;
        if (this.simulationMode) {
            if (aveTimeSinceLastWhereKnownYears / aveCondRecurInterval > this.simNormTimeSinceLastHist.getMaxX()) {
                this.simNormTimeSinceLastHist.add(this.simNormTimeSinceLastHist.getMaxX(), this.longTermRateOfFltSysRup[fltSysRupIndex]);
                if (rupMag <= 7.0) {
                    this.simNormTimeSinceLastForMagBelow7_Hist.add(this.simNormTimeSinceLastHist.getMaxX(), this.longTermRateOfFltSysRup[fltSysRupIndex]);
                } else {
                    this.simNormTimeSinceLastForMagAbove7_Hist.add(this.simNormTimeSinceLastHist.getMaxX(), this.longTermRateOfFltSysRup[fltSysRupIndex]);
                }
            } else {
                this.simNormTimeSinceLastHist.add(aveTimeSinceLastWhereKnownYears / aveCondRecurInterval, this.longTermRateOfFltSysRup[fltSysRupIndex]);
                if (rupMag <= 7.0) {
                    this.simNormTimeSinceLastForMagBelow7_Hist.add(aveTimeSinceLastWhereKnownYears / aveCondRecurInterval, this.longTermRateOfFltSysRup[fltSysRupIndex]);
                } else {
                    this.simNormTimeSinceLastForMagAbove7_Hist.add(aveTimeSinceLastWhereKnownYears / aveCondRecurInterval, this.longTermRateOfFltSysRup[fltSysRupIndex]);
                }
            }
            if (probGain > this.simProbGainHist.getMaxX()) {
                this.simProbGainHist.add(this.simProbGainHist.getMaxX(), this.longTermRateOfFltSysRup[fltSysRupIndex]);
                if (rupMag <= 7.0) {
                    this.simProbGainForMagBelow7_Hist.add(this.simProbGainHist.getMaxX(), this.longTermRateOfFltSysRup[fltSysRupIndex]);
                } else {
                    this.simProbGainForMagAbove7_Hist.add(this.simProbGainHist.getMaxX(), this.longTermRateOfFltSysRup[fltSysRupIndex]);
                }
            } else {
                this.simProbGainHist.add(probGain, this.longTermRateOfFltSysRup[fltSysRupIndex]);
                if (rupMag <= 7.0) {
                    this.simProbGainForMagBelow7_Hist.add(probGain, this.longTermRateOfFltSysRup[fltSysRupIndex]);
                } else {
                    this.simProbGainForMagAbove7_Hist.add(probGain, this.longTermRateOfFltSysRup[fltSysRupIndex]);
                }
            }
        }
        if (Double.isNaN(probGain)) {
            throw new RuntimeException("NaN fltSysRupIndex=" + fltSysRupIndex);
        }
        return probGain;
    }

    public double getWG02_ProbGainForRup(int fltSysRupIndex, boolean onlyIfAllSectionsHaveDateOfLast, long presentTimeMillis, double durationYears) {
        if (this.aperValues.length > 1) {
            throw new RuntimeException("WG02 option can only have one aperiodicity value");
        }
        BPT_DistCalc refBPT_DistributionCalc = ProbabilityModelsCalc.getRef_BPT_DistCalc(this.aperValues[0]);
        if (this.sectionGainArray == null) {
            this.sectionGainArray = new double[this.numSections];
            this.sectionGainReal = new boolean[this.numSections];
            for (int s = 0; s < this.numSections; ++s) {
                long timeOfLastMillis = this.dateOfLastForSect[s];
                if (timeOfLastMillis != Long.MIN_VALUE && timeOfLastMillis <= presentTimeMillis) {
                    double timeSinceLastYears = (double)(presentTimeMillis - timeOfLastMillis) / 3.15576E10;
                    double refTimeSinceLast = timeSinceLastYears * refRI * this.longTermPartRateForSectArray[s];
                    double refDuration = durationYears * refRI * this.longTermPartRateForSectArray[s];
                    double prob_bpt = refBPT_DistributionCalc.getCondProb(refTimeSinceLast, refDuration);
                    double prob_pois = durationYears * this.longTermPartRateForSectArray[s];
                    this.sectionGainArray[s] = prob_bpt / prob_pois;
                    this.sectionGainReal[s] = true;
                    continue;
                }
                this.sectionGainArray[s] = 1.0;
                this.sectionGainReal[s] = false;
            }
        }
        double totalWt = 0.0;
        double sumGains = 0.0;
        boolean noneAreReal = true;
        for (int sect : this.fltSysRupSet.getSectionsIndicesForRup(fltSysRupIndex)) {
            double wt = this.sectionArea[sect];
            totalWt += wt;
            sumGains += this.sectionGainArray[sect] * wt;
            if (!this.sectionGainReal[sect] && onlyIfAllSectionsHaveDateOfLast) {
                return Double.NaN;
            }
            if (!this.sectionGainReal[sect]) continue;
            noneAreReal = false;
        }
        if (noneAreReal) {
            return 1.0;
        }
        return sumGains / totalWt;
    }

    public void plotXYZ_FuncOfCondProbForUnknownDateOfLastEvent() {
        double aperiodicity = this.aperValues[0];
        BPT_DistCalc bptCalc2 = ProbabilityModelsCalc.getRef_BPT_DistCalc(aperiodicity);
        double minLogDurOverMean = -7.0;
        double maxLogDurOverMean = Math.log10(5.01187);
        double deltaLogDurOverMean = 0.1;
        int numLogDurOverMean = 1 + (int)Math.ceil((maxLogDurOverMean - minLogDurOverMean) / deltaLogDurOverMean);
        double minLogHistOpenIntOverMean = -2.0;
        double maxLogHistOpenIntOverMean = Math.log10(5.01187);
        double deltaLogHistOpenIntOverMean = 0.025;
        int numLogHistOpenIntOverMean = 1 + (int)Math.ceil((maxLogHistOpenIntOverMean - minLogHistOpenIntOverMean) / deltaLogHistOpenIntOverMean);
        EvenlyDiscrXYZ_DataSet xyzDataCondProbForUnknown = new EvenlyDiscrXYZ_DataSet(numLogDurOverMean, numLogHistOpenIntOverMean, minLogDurOverMean, minLogHistOpenIntOverMean, deltaLogDurOverMean, deltaLogHistOpenIntOverMean);
        EvenlyDiscrXYZ_DataSet xyzDataProbGain = new EvenlyDiscrXYZ_DataSet(numLogDurOverMean, numLogHistOpenIntOverMean, minLogDurOverMean, minLogHistOpenIntOverMean, deltaLogDurOverMean, deltaLogHistOpenIntOverMean);
        for (int y = 0; y < xyzDataCondProbForUnknown.getNumY(); ++y) {
            double logHistOpenIntOverMean = xyzDataCondProbForUnknown.getY(y);
            double histOpenIntOverMean = Math.pow(10.0, logHistOpenIntOverMean);
            double histOpenInterval = histOpenIntOverMean * refRI;
            for (int x = 0; x < xyzDataCondProbForUnknown.getNumX(); ++x) {
                double logDurOverMean = xyzDataCondProbForUnknown.getX(x);
                double durOverMean = Math.pow(10.0, logDurOverMean);
                double duration = durOverMean * refRI;
                bptCalc2.setDurationAndHistOpenInterval(duration, histOpenInterval);
                double condProbForUnknownTimeSinceLast = bptCalc2.getCondProbForUnknownTimeSinceLastEvent();
                xyzDataCondProbForUnknown.set(x, y, Math.log10(condProbForUnknownTimeSinceLast));
                double probGain = condProbForUnknownTimeSinceLast / ProbabilityModelsCalc.computePoissonProb(refRI, duration);
                xyzDataProbGain.set(x, y, Math.log10(probGain));
            }
        }
        CPT cpt_prob = null;
        CPT cpt_probGain = null;
        try {
            cpt_prob = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-8.0, 0.0);
            cpt_probGain = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(-1.0, 2.0);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XYZPlotSpec spec_prob = new XYZPlotSpec(xyzDataCondProbForUnknown, cpt_prob, "CondProbForUnknownLast; aper=" + (float)aperiodicity, "LogNormDuration", "LogNormHistOpenInt", "Probability");
        GraphWindow window_prob = new GraphWindow(spec_prob);
        XYZPlotSpec spec_probGain = new XYZPlotSpec(xyzDataProbGain, cpt_probGain, "Log10 Prob Gain (vs Poisson); aper=" + (float)aperiodicity, "LogNormDuration", "LogNormHistOpenInt", "Log10 Prob Gain");
        GraphWindow window_probGain = new GraphWindow(spec_probGain);
    }

    public void plotXYZ_FuncOfCondProb() {
        double aperiodicity = this.aperValues[0];
        BPT_DistCalc bptCalc2 = ProbabilityModelsCalc.getRef_BPT_DistCalc(aperiodicity);
        double minLogDurOverMean = -1.0;
        double maxLogDurOverMean = Math.log10(5.01187);
        double deltaLogDurOverMean = 0.01;
        int numLogDurOverMean = 1 + (int)Math.ceil((maxLogDurOverMean - minLogDurOverMean) / deltaLogDurOverMean);
        double minLogNormTimeSinceLast = -1.0;
        double maxLogNormTimeSinceLast = Math.log10(5.01187);
        double deltaLogNormTimeSinceLast = 0.01;
        int numLogNormTimeSinceLast = 1 + (int)Math.ceil((maxLogNormTimeSinceLast - minLogNormTimeSinceLast) / deltaLogNormTimeSinceLast);
        EvenlyDiscrXYZ_DataSet xyzDataCondProb = new EvenlyDiscrXYZ_DataSet(numLogNormTimeSinceLast, numLogDurOverMean, minLogNormTimeSinceLast, minLogDurOverMean, deltaLogNormTimeSinceLast, deltaLogDurOverMean);
        EvenlyDiscrXYZ_DataSet xyzDataProbGain = new EvenlyDiscrXYZ_DataSet(numLogNormTimeSinceLast, numLogDurOverMean, minLogNormTimeSinceLast, minLogDurOverMean, deltaLogNormTimeSinceLast, deltaLogDurOverMean);
        for (int x = 0; x < xyzDataCondProb.getNumX(); ++x) {
            double logNormTimeSinceLast = xyzDataCondProb.getX(x);
            double normTimeSinceLast = Math.pow(10.0, logNormTimeSinceLast);
            double timeSinceLast = normTimeSinceLast * refRI;
            for (int y = 0; y < xyzDataCondProb.getNumY(); ++y) {
                double logDurOverMean = xyzDataCondProb.getY(y);
                double durOverMean = Math.pow(10.0, logDurOverMean);
                double duration = durOverMean * refRI;
                double condProb = bptCalc2.getCondProb(timeSinceLast, duration);
                if (condProb == 0.0) {
                    condProb = Double.NaN;
                }
                xyzDataCondProb.set(x, y, Math.log10(condProb));
                double probGain = condProb / ProbabilityModelsCalc.computePoissonProb(refRI, duration);
                xyzDataProbGain.set(x, y, Math.log10(probGain));
            }
        }
        CPT cpt_prob = null;
        CPT cpt_probGain = null;
        try {
            cpt_prob = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(xyzDataCondProb.getMinZ(), xyzDataCondProb.getMaxZ());
            cpt_probGain = GMT_CPT_Files.MAX_SPECTRUM.instance().rescale(xyzDataProbGain.getMinZ(), xyzDataProbGain.getMaxZ());
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        XYZPlotSpec spec_prob = new XYZPlotSpec(xyzDataCondProb, cpt_prob, "Log10 BPT Cond Prob; aper=" + (float)aperiodicity, "LogNormTimeSinceLast", "LogNormDuration", "Probability");
        GraphWindow window_prob = new GraphWindow(spec_prob);
        XYZPlotSpec spec_probGain = new XYZPlotSpec(xyzDataProbGain, cpt_probGain, "Log10 Prob Gain (vs Poisson); aper=" + (float)aperiodicity, "LogNormTimeSinceLast", "LogNormDuration", "Log10 Prob Gain");
        GraphWindow window_probGain = new GraphWindow(spec_probGain);
    }

    public double computeBPT_ProbFast(double aveRecurIntervalYears, double aveTimeSinceLastYears, double durationYears, double rupMag) {
        BPT_DistCalc refBPT_DistributionCalc = this.refBPT_CalcArray[this.getAperIndexForRupMag(rupMag)];
        double newTimeSinceLast = aveTimeSinceLastYears * refRI / aveRecurIntervalYears;
        if (newTimeSinceLast < 0.0 && newTimeSinceLast > -1.0E-10) {
            newTimeSinceLast = 0.0;
        }
        double prob = refBPT_DistributionCalc.getCondProb(newTimeSinceLast, durationYears * refRI / aveRecurIntervalYears);
        return prob;
    }

    public double computeBPT_Prob(double aveRecurIntervalYears, double aveTimeSinceLastYears, double durationYears, double aperiodicity) {
        double delta = interpolate ? aveRecurIntervalYears / 2000.0 : aveRecurIntervalYears / 200.0;
        int numPts = (int)Math.round(9.0 * aveRecurIntervalYears / delta);
        BPT_DistCalc bptCalc = new BPT_DistCalc();
        bptCalc.setInterpolate(interpolate);
        bptCalc.setAll(aveRecurIntervalYears, aperiodicity, delta, numPts);
        return bptCalc.getCondProb(aveTimeSinceLastYears, durationYears);
    }

    public double computeBPT_ProbForUnknownDateOfLastFast(double aveRecurIntervalYears, double histOpenIntervalYears, double durationYears, double rupMag) {
        BPT_DistCalc refBPT_DistributionCalc = this.refBPT_CalcArray[this.getAperIndexForRupMag(rupMag)];
        refBPT_DistributionCalc.setDurationAndHistOpenInterval(durationYears * refRI / aveRecurIntervalYears, histOpenIntervalYears * refRI / aveRecurIntervalYears);
        return refBPT_DistributionCalc.getCondProbForUnknownTimeSinceLastEvent();
    }

    public double computeBPT_ProbForUnknownDateOfLast(double aveRecurIntervalYears, double histOpenIntervalYears, double durationYears, double aperiodicity) {
        double delta = interpolate ? aveRecurIntervalYears / 2000.0 : aveRecurIntervalYears / 200.0;
        int numPts = (int)Math.round(9.0 * aveRecurIntervalYears / delta);
        BPT_DistCalc bptCalc = new BPT_DistCalc();
        bptCalc.setInterpolate(interpolate);
        bptCalc.setAll(aveRecurIntervalYears, aperiodicity, delta, numPts, durationYears, histOpenIntervalYears);
        return bptCalc.getCondProbForUnknownTimeSinceLastEvent();
    }

    public static double computePoissonProb(double aveRecurIntevalYears, double durationYears) {
        return 1.0 - Math.exp(-durationYears / aveRecurIntevalYears);
    }

    protected static BPT_DistCalc getRef_BPT_DistCalc(double bpt_Aperiodicity) {
        int numPts = (int)Math.round(9.0 * refRI / deltaT);
        BPT_DistCalc bptCalc = new BPT_DistCalc();
        bptCalc.setInterpolate(interpolate);
        bptCalc.setAll(refRI, bpt_Aperiodicity, deltaT, numPts);
        return bptCalc;
    }

    protected BPT_DistCalc[] getRef_BPT_DistCalcArray() {
        BPT_DistCalc[] bptCalcArray = new BPT_DistCalc[this.numAperValues];
        int numPts = (int)Math.round(9.0 * refRI / deltaT);
        for (int i = 0; i < this.numAperValues; ++i) {
            BPT_DistCalc bptCalc = new BPT_DistCalc();
            bptCalc.setInterpolate(interpolate);
            bptCalc.setAll(refRI, this.aperValues[i], deltaT, numPts);
            bptCalcArray[i] = bptCalc;
        }
        return bptCalcArray;
    }

    protected int getAperIndexForRupMag(double rupMag) {
        int index = -1;
        if (this.numAperValues == 1) {
            index = 0;
        } else if (rupMag > this.aperMagBoundaries[this.numAperValues - 2]) {
            index = this.numAperValues - 1;
        } else {
            for (int m = 0; m < this.aperMagBoundaries.length; ++m) {
                if (!(rupMag <= this.aperMagBoundaries[m])) continue;
                index = m;
                break;
            }
        }
        return index;
    }

    protected String getMagDepAperInfoString(int aperIndex) {
        if (this.numAperValues == 1) {
            return "aper=" + this.aperValues[0];
        }
        if (aperIndex == 0) {
            return "M<=" + this.aperMagBoundaries[0] + "; aper=" + this.aperValues[0];
        }
        if (aperIndex == this.numAperValues - 1) {
            return "M>" + this.aperMagBoundaries[this.numAperValues - 2] + "; aper=" + this.aperValues[this.numAperValues - 1];
        }
        return this.aperMagBoundaries[aperIndex - 1] + "<M<=" + this.aperMagBoundaries[aperIndex] + "; aper=" + this.aperValues[aperIndex];
    }

    protected EvenlyDiscretizedFunc[] getNormBPT_CDF_Array() {
        EvenlyDiscretizedFunc[] normCDF_Array = new EvenlyDiscretizedFunc[this.numAperValues];
        for (int i = 0; i < this.numAperValues; ++i) {
            BPT_DistCalc tempCalc = new BPT_DistCalc();
            double delta = max_time_for_normBPT_CDF / (double)(num_for_normBPT_CDF - 1);
            tempCalc.setAll(1.0, this.aperValues[i], delta, num_for_normBPT_CDF);
            normCDF_Array[i] = tempCalc.getCDF();
        }
        return normCDF_Array;
    }

    public static void testFastCalculations(int numTests) {
        double[] apers;
        System.out.println("Prob\tdiff\tprob\tprob_fast\taperiodicity\taveRI\tdur\ttimeSince\thistOpenInt\tnormDur\tnormTimeSince\tnormHistOpenInt");
        for (double aper : apers = new double[]{0.1, 0.2, 0.3, 0.4, 0.5, 0.6, 0.7, 0.8, 0.9, 1.0}) {
            ProbabilityModelsCalc calc = new ProbabilityModelsCalc(aper);
            double diffThresh = 0.001;
            for (int i = 0; i < numTests; ++i) {
                double normTimeSince;
                double aveRI = 20.0 + Math.random() * 100000.0;
                double normDur = 0.001 + Math.random() * 5.0;
                double normHistOpenInt = normTimeSince = Math.random() * 5.0;
                double dur = normDur * aveRI;
                double timeSince = normTimeSince * aveRI;
                double histOpenInt = normHistOpenInt * aveRI;
                double rupMag = Double.NaN;
                double prob1 = calc.computeBPT_Prob(aveRI, timeSince, dur, aper);
                double prob2 = calc.computeBPT_ProbForUnknownDateOfLast(aveRI, histOpenInt, dur, aper);
                double prob1_fast = calc.computeBPT_ProbFast(aveRI, timeSince, dur, rupMag);
                double prob2_fast = calc.computeBPT_ProbForUnknownDateOfLastFast(aveRI, histOpenInt, dur, rupMag);
                double diff1 = Math.abs((prob1 - prob1_fast) / prob1);
                if (prob1 < 1.0E-12 && prob1_fast < 1.0E-12) {
                    diff1 = 0.0;
                }
                double diff2 = Math.abs((prob2 - prob2_fast) / prob2);
                if (prob2 < 1.0E-12 && prob2_fast < 1.0E-12) {
                    diff2 = 0.0;
                }
                if (diff1 > diffThresh) {
                    System.out.println("Prob1\t" + diff1 + "\t" + prob1 + "\t" + prob1_fast + "\t" + aper + "\t" + aveRI + "\t" + dur + "\t" + timeSince + "\tNaN\t" + normDur + "\t" + normTimeSince + "\tNaN");
                }
                if (!(diff2 > diffThresh)) continue;
                System.out.println("Prob2\t" + diff2 + "\t" + prob2 + "\t" + prob2_fast + "\t" + aper + "\t" + aveRI + "\t" + dur + "\tNaN\t" + histOpenInt + "\t" + normDur + "\tNaN\t" + normHistOpenInt);
            }
        }
    }

    public void testER_Simulation(String inputDateOfLastFileName, String outputDateOfLastFileName, FaultSystemSolutionERF erf, double numYears, String dirNameSuffix) {
        int i;
        double[] aveCondRecurIntervalForFltSysRups;
        String probTypeString;
        int testSectionIndex = 1946;
        boolean aveRecurIntervals = erf.aveRecurIntervalsInU3_BPTcalc;
        boolean aveNormTimeSinceLast = erf.aveNormTimeSinceLastInU3_BPTcalc;
        this.simulationMode = true;
        this.simNormTimeSinceLastHist = new HistogramFunction(0.05, 100, 0.1);
        this.simNormTimeSinceLastForMagBelow7_Hist = new HistogramFunction(0.05, 100, 0.1);
        this.simNormTimeSinceLastForMagAbove7_Hist = new HistogramFunction(0.05, 100, 0.1);
        this.simProbGainHist = new HistogramFunction(0.05, 100, 0.1);
        this.simProbGainForMagAbove7_Hist = new HistogramFunction(0.05, 100, 0.1);
        this.simProbGainForMagBelow7_Hist = new HistogramFunction(0.05, 100, 0.1);
        Object typeCalcForU3_Probs = aveRecurIntervals ? "aveRI" : "aveRate";
        typeCalcForU3_Probs = aveNormTimeSinceLast ? (String)typeCalcForU3_Probs + "_aveNormTimeSince" : (String)typeCalcForU3_Probs + "_aveTimeSince";
        ProbabilityModelOptions probTypeEnum = (ProbabilityModelOptions)((Object)erf.getParameter("Probability Model").getValue());
        Object aperString = "aper";
        if (probTypeEnum != ProbabilityModelOptions.POISSON) {
            boolean first = true;
            for (double aperVal : this.aperValues) {
                aperString = first ? (String)aperString + aperVal : (String)aperString + "," + aperVal;
                first = false;
            }
            aperString = ((String)aperString).replace(".", "pt");
        }
        System.out.println("\naperString: " + (String)aperString + "\n");
        int tempDur = (int)Math.round(numYears / 1000.0);
        if (probTypeEnum == ProbabilityModelOptions.POISSON) {
            probTypeString = "Pois";
        } else if (probTypeEnum == ProbabilityModelOptions.U3_BPT) {
            probTypeString = "U3BPT";
        } else if (probTypeEnum == ProbabilityModelOptions.WG02_BPT) {
            probTypeString = "WG02BPT";
        } else {
            throw new RuntimeException("Porbability type unrecognized");
        }
        String dirNameForSavingFiles = "U3ER_" + probTypeString + "_" + tempDur + "kyr";
        if (probTypeEnum != ProbabilityModelOptions.POISSON) {
            dirNameForSavingFiles = dirNameForSavingFiles + "_" + (String)aperString;
            dirNameForSavingFiles = dirNameForSavingFiles + "_" + (String)typeCalcForU3_Probs;
        }
        dirNameForSavingFiles = dirNameForSavingFiles + "_" + dirNameSuffix;
        Object plotLabelString = probTypeString;
        if (probTypeEnum == ProbabilityModelOptions.U3_BPT) {
            plotLabelString = (String)plotLabelString + " (" + (String)aperString + ", " + (String)typeCalcForU3_Probs + ")";
        } else if (probTypeEnum == ProbabilityModelOptions.WG02_BPT) {
            plotLabelString = (String)plotLabelString + " (" + (String)aperString + ")";
        }
        File resultsDir = new File(dirNameForSavingFiles);
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        double[] probGainForFaultSystemSource = new double[erf.getNumFaultSystemSources()];
        for (int s = 0; s < probGainForFaultSystemSource.length; ++s) {
            probGainForFaultSystemSource[s] = 1.0;
        }
        long origStartTimeMillis = 0L;
        if (probTypeEnum != ProbabilityModelOptions.POISSON) {
            origStartTimeMillis = erf.getTimeSpan().getStartTimeInMillis();
        }
        double origStartYear = (double)origStartTimeMillis / 3.15576E10 + 1970.0;
        System.out.println("orig start time: " + origStartTimeMillis + " millis (" + origStartYear + " yrs)");
        System.out.println("numYears: " + numYears);
        ArrayList<Double> normalizedRupRecurIntervals = new ArrayList<Double>();
        ArrayList<Double> normalizedSectRecurIntervals = new ArrayList<Double>();
        ArrayList<Double> normalizedSectRecurIntervalsForTestSect = new ArrayList<Double>();
        ArrayList normalizedRupRecurIntervalsMagDepList = new ArrayList();
        ArrayList normalizedSectRecurIntervalsMagDepList = new ArrayList();
        for (int i3 = 0; i3 < this.numAperValues; ++i3) {
            normalizedRupRecurIntervalsMagDepList.add(new ArrayList());
            normalizedSectRecurIntervalsMagDepList.add(new ArrayList());
        }
        ArrayList<Double> yearsIntoSimulation = new ArrayList<Double>();
        ArrayList<Double> totRateAtYearsIntoSimulation = new ArrayList<Double>();
        ArbDiscrEmpiricalDistFunc_3D normRI_AlongStrike = new ArbDiscrEmpiricalDistFunc_3D(0.05, 0.95, 10);
        double[] obsSectRateArray = new double[this.numSections];
        double[] obsSectSlipRateArray = new double[this.numSections];
        double[] obsSectRateArrayM6pt05to6pt65 = new double[this.numSections];
        double[] obsSectRateArrayM7pt95to8pt25 = new double[this.numSections];
        double[] obsRupRateArray = new double[erf.getTotNumRups()];
        double[] aveRupProbGainArray = new double[erf.getTotNumRups()];
        double[] minRupProbGainArray = new double[erf.getTotNumRups()];
        double[] maxRupProbGainArray = new double[erf.getTotNumRups()];
        FileWriter eventFileWriter = null;
        try {
            eventFileWriter = new FileWriter(dirNameForSavingFiles + "/sampledEventsData.txt");
            eventFileWriter.write("nthRupIndex\tfssRupIndex\tyear\tepoch\tnormRupRI\n");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int numRups = 0;
        RandomDataGenerator randomDataSampler = new RandomDataGenerator();
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        double totalRate = 0.0;
        IntegerPDF_FunctionSampler nthRupRandomSampler = new IntegerPDF_FunctionSampler(erf.getTotNumRups());
        double[] longTermRateOfNthRups = new double[erf.getTotNumRups()];
        double[] magOfNthRups = new double[erf.getTotNumRups()];
        double[] longTermSlipRateForSectArray = new double[this.numSections];
        int nthRup = 0;
        for (ProbEqkSource src : erf) {
            for (ProbEqkRupture rup : src) {
                double rate;
                longTermRateOfNthRups[nthRup] = rate = rup.getMeanAnnualRate(erf.getTimeSpan().getDuration());
                magOfNthRups[nthRup] = rup.getMag();
                totalRate += longTermRateOfNthRups[nthRup];
                nthRupRandomSampler.set(nthRup, rate);
                if (erf.getSrcIndexForNthRup(nthRup) < erf.getNumFaultSystemSources()) {
                    double[] slips;
                    int fltSysIndex = erf.getFltSysRupIndexForNthRup(nthRup);
                    List<Integer> sectIndices = this.fltSysRupSet.getSectionsIndicesForRup(fltSysIndex);
                    if (this.fltSysRupSet instanceof InversionFaultSystemRupSet) {
                        slips = ((InversionFaultSystemRupSet)this.fltSysRupSet).getSlipOnSectionsForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                    } else {
                        double mag = this.fltSysRupSet.getMagForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                        double area = this.fltSysRupSet.getAreaForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                        double aveSlip = FaultMomentCalc.getSlip(area, MagUtils.magToMoment(mag));
                        slips = new double[sectIndices.size()];
                        for (int i4 = 0; i4 < slips.length; ++i4) {
                            slips[i4] = aveSlip;
                        }
                    }
                    for (int s = 0; s < sectIndices.size(); ++s) {
                        int sectID;
                        int n = sectID = sectIndices.get(s).intValue();
                        longTermSlipRateForSectArray[n] = longTermSlipRateForSectArray[n] + rate * slips[s];
                    }
                }
                ++nthRup;
            }
        }
        System.out.println("totalRate long term = " + totalRate);
        double totalLongTermRate = totalRate;
        double simDuration = 1.0 / totalLongTermRate;
        ArrayList<int[]> sectIndexArrayForSrcList = new ArrayList<int[]>();
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            List<Integer> indexList = this.fltSysRupSet.getSectionsIndicesForRup(erf.getFltSysRupIndexForSource(s));
            int[] indexArray = new int[indexList.size()];
            for (int i5 = 0; i5 < indexList.size(); ++i5) {
                indexArray[i5] = indexList.get(i5);
            }
            sectIndexArrayForSrcList.add(indexArray);
        }
        ArrayList<AbstractXY_DataSet> safEventFuncs = new ArrayList<AbstractXY_DataSet>();
        ArrayList<PlotCurveCharacterstics> safPlotChars4 = new ArrayList<PlotCurveCharacterstics>();
        System.out.println("Making target MFD");
        SummedMagFreqDist targetMFD = ERF_Calculator.getTotalMFD_ForERF(erf, 5.05, 8.95, 40, true);
        double origTotMoRate = ERF_Calculator.getTotalMomentRateInRegion(erf, null);
        System.out.println("originalTotalMomentRate: " + origTotMoRate);
        targetMFD.setName("Target MFD");
        String tempString = "total rate = " + (float)targetMFD.getTotalIncrRate();
        tempString = tempString + "\ntotal rate >= 6.7 = " + (float)targetMFD.getCumRate(6.75);
        tempString = tempString + "\ntotal MoRate = " + (float)origTotMoRate;
        targetMFD.setInfo(tempString);
        SummedMagFreqDist obsMFD = new SummedMagFreqDist(5.05, 8.95, 40);
        double obsMoRate = 0.0;
        if (aveRecurIntervals) {
            if (this.aveCondRecurIntervalForFltSysRups_type1 == null) {
                this.aveCondRecurIntervalForFltSysRups_type1 = this.computeAveCondRecurIntervalForFltSysRups(1);
            }
            aveCondRecurIntervalForFltSysRups = this.aveCondRecurIntervalForFltSysRups_type1;
        } else {
            if (this.aveCondRecurIntervalForFltSysRups_type2 == null) {
                this.aveCondRecurIntervalForFltSysRups_type2 = this.computeAveCondRecurIntervalForFltSysRups(2);
            }
            aveCondRecurIntervalForFltSysRups = this.aveCondRecurIntervalForFltSysRups_type2;
        }
        double minCondRI = Double.MAX_VALUE;
        double maxCondRI = 0.0;
        for (double ri : aveCondRecurIntervalForFltSysRups) {
            if (Double.isInfinite(ri)) continue;
            if (ri < minCondRI) {
                minCondRI = ri;
            }
            if (!(ri > maxCondRI)) continue;
            maxCondRI = ri;
        }
        System.out.println("minCondRI=" + minCondRI);
        System.out.println("maxCondRI=" + maxCondRI);
        double currentYear = origStartYear;
        long currentTimeMillis = origStartTimeMillis;
        int percDoneThresh = 0;
        int percDoneIncrement = 5;
        long startRunTime = System.currentTimeMillis();
        if (inputDateOfLastFileName != null && probTypeEnum != ProbabilityModelOptions.POISSON) {
            this.readSectTimeSinceLastEventFromFile(inputDateOfLastFileName, currentTimeMillis);
        } else {
            this.getSectNormTimeSinceLastHistPlot(currentTimeMillis, "From Pref Data");
        }
        CalcProgressBar progressBar = new CalcProgressBar(dirNameForSavingFiles, "Num Years Done");
        progressBar.showProgress(true);
        boolean firstEvent = true;
        while (currentYear < numYears + origStartYear) {
            progressBar.updateProgress((int)Math.round(currentYear - origStartYear), (int)Math.round(numYears));
            int percDone = (int)Math.round(100.0 * (currentYear - origStartYear) / numYears);
            if (percDone >= percDoneThresh) {
                double timeInMin = (double)(System.currentTimeMillis() - startRunTime) / 60000.0;
                int numGoodDateOfLast = 0;
                for (long dateOfLast : this.dateOfLastForSect) {
                    if (dateOfLast == Long.MIN_VALUE) continue;
                    ++numGoodDateOfLast;
                }
                int percentGood = (int)Math.round(100.0 * (double)numGoodDateOfLast / (double)this.dateOfLastForSect.length);
                System.out.println("\n" + percDoneThresh + "% done in " + (float)timeInMin + " minutes;  totalRate=" + (float)totalRate + "; yr=" + (float)currentYear + ";  % sect with date of last = " + percentGood + "\n");
                percDoneThresh += percDoneIncrement;
            }
            if (probTypeEnum != ProbabilityModelOptions.POISSON) {
                if (probTypeEnum == ProbabilityModelOptions.U3_BPT) {
                    for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
                        int fltSysRupIndex = erf.getFltSysRupIndexForSource(s);
                        probGainForFaultSystemSource[s] = this.getU3_ProbGainForRup(fltSysRupIndex, 0.0, false, aveRecurIntervals, aveNormTimeSinceLast, currentTimeMillis, simDuration);
                    }
                } else if (probTypeEnum == ProbabilityModelOptions.WG02_BPT) {
                    this.sectionGainArray = null;
                    for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
                        int fltSysRupIndex = erf.getFltSysRupIndexForSource(s);
                        probGainForFaultSystemSource[s] = this.getWG02_ProbGainForRup(fltSysRupIndex, false, currentTimeMillis, simDuration);
                    }
                }
                for (int n = 0; n < erf.getTotNumRupsFromFaultSystem(); ++n) {
                    double probGain = probGainForFaultSystemSource[erf.getSrcIndexForNthRup(n)];
                    double newRate = longTermRateOfNthRups[n] * probGain;
                    nthRupRandomSampler.set(n, newRate);
                    int n2 = n;
                    aveRupProbGainArray[n2] = aveRupProbGainArray[n2] + probGain;
                    if (minRupProbGainArray[n] > probGain) {
                        minRupProbGainArray[n] = probGain;
                    }
                    if (!(maxRupProbGainArray[n] < probGain)) continue;
                    maxRupProbGainArray[n] = probGain;
                }
                totalRate = nthRupRandomSampler.getSumOfY_vals();
            }
            yearsIntoSimulation.add(currentYear);
            totRateAtYearsIntoSimulation.add(totalRate);
            double timeToNextInYrs = randomDataSampler.nextExponential(1.0 / totalRate);
            long eventTimeMillis = currentTimeMillis + (long)(timeToNextInYrs * 3.15576E10);
            nthRup = nthRupRandomSampler.getRandomInt();
            int srcIndex = erf.getSrcIndexForNthRup(nthRup);
            int n = nthRup;
            obsRupRateArray[n] = obsRupRateArray[n] + 1.0;
            if (srcIndex < erf.getNumFaultSystemSources()) {
                double numYrs;
                double[] slips;
                int fltSystRupIndex = erf.getFltSysRupIndexForSource(srcIndex);
                double rupMag = this.fltSysRupSet.getMagForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                if (aveNormTimeSinceLast) {
                    double aveNormYearsSinceLast = this.getAveNormTimeSinceLastEventWhereKnown(fltSystRupIndex, eventTimeMillis);
                    if (this.allSectionsHadDateOfLast) {
                        normalizedRupRecurIntervals.add(aveNormYearsSinceLast);
                        if (this.numAperValues > 0) {
                            ((ArrayList)normalizedRupRecurIntervalsMagDepList.get(this.getAperIndexForRupMag(rupMag))).add(aveNormYearsSinceLast);
                        }
                    }
                } else {
                    long aveDateOfLastMillis = this.getAveDateOfLastEventWhereKnown(fltSystRupIndex, eventTimeMillis);
                    if (this.allSectionsHadDateOfLast) {
                        double timeSinceLast = (double)(eventTimeMillis - aveDateOfLastMillis) / 3.15576E10;
                        double normRI = timeSinceLast / aveCondRecurIntervalForFltSysRups[fltSystRupIndex];
                        normalizedRupRecurIntervals.add(normRI);
                        if (this.numAperValues > 0) {
                            ((ArrayList)normalizedRupRecurIntervalsMagDepList.get(this.getAperIndexForRupMag(rupMag))).add(normRI);
                        }
                    }
                }
                try {
                    eventFileWriter.write(nthRup + "\t" + fltSystRupIndex + "\t" + (currentYear + timeToNextInYrs) + "\t" + eventTimeMillis + "\t" + String.valueOf(normalizedRupRecurIntervals.get(normalizedRupRecurIntervals.size() - 1)) + "\n");
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                HistogramFunction sumRI_AlongHist = new HistogramFunction(normRI_AlongStrike.getMinX(), normRI_AlongStrike.getMaxX(), normRI_AlongStrike.getNumX());
                HistogramFunction numRI_AlongHist = new HistogramFunction(normRI_AlongStrike.getMinX(), normRI_AlongStrike.getMaxX(), normRI_AlongStrike.getNumX());
                int[] sectID_Array = (int[])sectIndexArrayForSrcList.get(erf.getSrcIndexForFltSysRup(fltSystRupIndex));
                int numSectInRup = sectID_Array.length;
                if (this.fltSysRupSet instanceof InversionFaultSystemRupSet) {
                    slips = ((InversionFaultSystemRupSet)this.fltSysRupSet).getSlipOnSectionsForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                } else {
                    double area = this.fltSysRupSet.getAreaForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                    double aveSlip = FaultMomentCalc.getSlip(area, MagUtils.magToMoment(rupMag));
                    slips = new double[numSectInRup];
                    for (int i2 = 0; i2 < slips.length; ++i2) {
                        slips[i2] = aveSlip;
                    }
                }
                int ithSectInRup = 0;
                int[] nArray = sectID_Array;
                int aveSlip = nArray.length;
                for (int j = 0; j < aveSlip; ++j) {
                    int sect;
                    int n3 = sect = nArray[j];
                    obsSectSlipRateArray[n3] = obsSectSlipRateArray[n3] + slips[ithSectInRup];
                    long timeOfLastMillis = this.dateOfLastForSect[sect];
                    if (timeOfLastMillis != Long.MIN_VALUE) {
                        double normYrsSinceLast = (double)(eventTimeMillis - timeOfLastMillis) / 3.15576E10 * this.longTermPartRateForSectArray[sect];
                        normalizedSectRecurIntervals.add(normYrsSinceLast);
                        if (sect == testSectionIndex) {
                            normalizedSectRecurIntervalsForTestSect.add(normYrsSinceLast);
                        }
                        if (this.numAperValues > 0) {
                            ((ArrayList)normalizedSectRecurIntervalsMagDepList.get(this.getAperIndexForRupMag(rupMag))).add(normYrsSinceLast);
                        }
                        double normDistAlong = ((double)ithSectInRup + 0.5) / (double)numSectInRup;
                        sumRI_AlongHist.add(normDistAlong, normYrsSinceLast);
                        numRI_AlongHist.add(normDistAlong, 1.0);
                    }
                    ++ithSectInRup;
                }
                if (numSectInRup > 10) {
                    for (int i6 = 0; i6 < sumRI_AlongHist.size(); ++i6) {
                        double num = numRI_AlongHist.getY(i6);
                        if (!(num > 0.0)) continue;
                        normRI_AlongStrike.set(sumRI_AlongHist.getX(i6), sumRI_AlongHist.getY(i6) / num, 1.0);
                    }
                }
                if ((numYrs = (double)(eventTimeMillis - origStartTimeMillis) / 3.15576E10) < 11000.0 && numYrs > 1000.0) {
                    if (firstEvent) {
                        for (int s = 0; s < this.fltSysRupSet.getNumSections(); ++s) {
                            double tenPercentRI = 0.1 / this.longTermPartRateForSectArray[s];
                            FaultSection sectData = this.fltSysRupSet.getFaultSectionData(s);
                            if (!sectData.getParentSectionName().contains("San Andreas")) continue;
                            ArbitrarilyDiscretizedFunc newFunc = new ArbitrarilyDiscretizedFunc();
                            newFunc.set(sectData.getFaultTrace().first().getLatitude(), tenPercentRI);
                            newFunc.set(sectData.getFaultTrace().last().getLatitude(), tenPercentRI);
                            safEventFuncs.add(newFunc);
                            safPlotChars4.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.BLACK));
                        }
                    }
                    ArrayList<Integer> safSections = new ArrayList<Integer>();
                    for (int id : sectID_Array) {
                        if (!this.fltSysRupSet.getFaultSectionData(id).getParentSectionName().contains("San Andreas")) continue;
                        safSections.add(id);
                    }
                    if (safSections.size() > 0) {
                        double[] lats = new double[2 * safSections.size()];
                        ArrayList<Double> shortSectRI_Lats = new ArrayList<Double>();
                        for (int i7 = 0; i7 < safSections.size(); ++i7) {
                            double normYrsSinceLast;
                            lats[2 * i7] = this.fltSysRupSet.getFaultSectionData((Integer)safSections.get(i7)).getFaultTrace().first().getLatitude();
                            lats[2 * i7 + 1] = this.fltSysRupSet.getFaultSectionData((Integer)safSections.get(i7)).getFaultTrace().last().getLatitude();
                            long timeOfLastMillis = this.dateOfLastForSect[(Integer)safSections.get(i7)];
                            if (timeOfLastMillis == Long.MIN_VALUE || !((normYrsSinceLast = (double)(eventTimeMillis - timeOfLastMillis) / 3.15576E10 * this.longTermPartRateForSectArray[(Integer)safSections.get(i7)]) < 0.1)) continue;
                            double lat1 = this.fltSysRupSet.getFaultSectionData((Integer)safSections.get(i7)).getFaultTrace().first().getLatitude();
                            double lat2 = this.fltSysRupSet.getFaultSectionData((Integer)safSections.get(i7)).getFaultTrace().last().getLatitude();
                            shortSectRI_Lats.add((lat1 + lat2) / 2.0);
                        }
                        double min = Double.POSITIVE_INFINITY;
                        double max = Double.NEGATIVE_INFINITY;
                        for (double val : lats) {
                            if (min > val) {
                                min = val;
                            }
                            if (!(max < val)) continue;
                            max = val;
                        }
                        ArbitrarilyDiscretizedFunc newFunc = new ArbitrarilyDiscretizedFunc();
                        newFunc.set(min, (double)eventTimeMillis / 3.15576E10);
                        newFunc.set(max, (double)eventTimeMillis / 3.15576E10);
                        safEventFuncs.add(newFunc);
                        safPlotChars4.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 1.0f, Color.GRAY));
                        if (shortSectRI_Lats.size() > 0) {
                            DefaultXY_DataSet shortRIsFunc = new DefaultXY_DataSet();
                            Iterator iterator = shortSectRI_Lats.iterator();
                            while (iterator.hasNext()) {
                                double lat = (Double)iterator.next();
                                shortRIsFunc.set(lat, (double)eventTimeMillis / 3.15576E10);
                            }
                            safEventFuncs.add(shortRIsFunc);
                            safPlotChars4.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 2.0f, Color.BLACK));
                        }
                    }
                }
                for (int sect : (int[])sectIndexArrayForSrcList.get(srcIndex)) {
                    this.dateOfLastForSect[sect] = eventTimeMillis;
                    int n4 = sect;
                    obsSectRateArray[n4] = obsSectRateArray[n4] + 1.0;
                    double mag = magOfNthRups[nthRup];
                    if (mag > 6.0 && mag < 6.7) {
                        int n5 = sect;
                        obsSectRateArrayM6pt05to6pt65[n5] = obsSectRateArrayM6pt05to6pt65[n5] + 1.0;
                        continue;
                    }
                    if (!(mag > 7.9) || !(mag < 8.3)) continue;
                    int n6 = sect;
                    obsSectRateArrayM7pt95to8pt25[n6] = obsSectRateArrayM7pt95to8pt25[n6] + 1.0;
                }
            }
            ++numRups;
            obsMFD.addResampledMagRate(magOfNthRups[nthRup], 1.0, true);
            obsMoRate += MagUtils.magToMoment(magOfNthRups[nthRup]);
            currentYear += timeToNextInYrs;
            currentTimeMillis = eventTimeMillis;
            firstEvent = false;
        }
        progressBar.showProgress(false);
        try {
            eventFileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (outputDateOfLastFileName != null) {
            this.writeSectTimeSinceLastEventToFile(outputDateOfLastFileName, currentTimeMillis);
        }
        String infoString = dirNameForSavingFiles;
        infoString = infoString + "\ninputDateOfLastFileName: " + inputDateOfLastFileName;
        infoString = infoString + "\nnumRups=" + numRups;
        double[] tempMagArray = new double[aveRupProbGainArray.length];
        for (int i8 = 0; i8 < aveRupProbGainArray.length; ++i8) {
            int n = i8;
            aveRupProbGainArray[n] = aveRupProbGainArray[n] / (double)numRups;
            tempMagArray[i8] = magOfNthRups[i8];
        }
        DefaultXY_DataSet aveRupProbGainVsMag = new DefaultXY_DataSet(tempMagArray, aveRupProbGainArray);
        DefaultXY_DataSet minRupProbGainVsMag = new DefaultXY_DataSet(tempMagArray, minRupProbGainArray);
        DefaultXY_DataSet maxRupProbGainVsMag = new DefaultXY_DataSet(tempMagArray, maxRupProbGainArray);
        aveRupProbGainVsMag.setName("Ave Rup Prob Gain vs Mag");
        double meanProbGain = 0.0;
        for (double val : aveRupProbGainArray) {
            meanProbGain += val;
        }
        aveRupProbGainVsMag.setInfo("meanProbGain=" + (float)(meanProbGain /= (double)aveRupProbGainArray.length));
        minRupProbGainVsMag.setName("Min Rup Prob Gain vs Mag");
        maxRupProbGainVsMag.setName("Max Rup Prob Gain vs Mag");
        ArrayList<DefaultXY_DataSet> aveRupProbGainVsMagFuncs = new ArrayList<DefaultXY_DataSet>();
        aveRupProbGainVsMagFuncs.add(aveRupProbGainVsMag);
        aveRupProbGainVsMagFuncs.add(minRupProbGainVsMag);
        aveRupProbGainVsMagFuncs.add(maxRupProbGainVsMag);
        ArrayList<PlotCurveCharacterstics> plotCharsAveGain = new ArrayList<PlotCurveCharacterstics>();
        plotCharsAveGain.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotCharsAveGain.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.GREEN));
        plotCharsAveGain.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.RED));
        GraphWindow graphAveRupProbGainVsMag = new GraphWindow(aveRupProbGainVsMagFuncs, "Ave Rup Prob Gain vs Mag; " + (String)plotLabelString, plotCharsAveGain);
        graphAveRupProbGainVsMag.setX_AxisLabel("Magnitude");
        graphAveRupProbGainVsMag.setY_AxisLabel("Ave Rup Prob Gain");
        try {
            FileWriter gain_fr = new FileWriter(dirNameForSavingFiles + "/aveRupGainData.txt");
            gain_fr.write("nthRupIndex\taveRupGain\tminRupGain\tmaxRupGain\trupMag\trupLongTermRate\trupCondRI\trupName\n");
            for (int i9 = 0; i9 < aveRupProbGainArray.length; ++i9) {
                gain_fr.write(i9 + "\t" + aveRupProbGainArray[i9] + "\t" + minRupProbGainArray[i9] + "\t" + maxRupProbGainArray[i9] + "\t" + magOfNthRups[i9] + "\t" + longTermRateOfNthRups[i9] + "\t" + aveCondRecurIntervalForFltSysRups[erf.getFltSysRupIndexForNthRup(i9)] + "\t" + erf.getSource(erf.getSrcIndexForNthRup(i9)).getName() + "\n");
            }
            gain_fr.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        HistogramFunction aveGainVsMagHist = new HistogramFunction(5.05, 40, 0.1);
        HistogramFunction tempWtHist = new HistogramFunction(5.05, 40, 0.1);
        for (i = 0; i < aveRupProbGainArray.length; ++i) {
            aveGainVsMagHist.add(magOfNthRups[i], aveRupProbGainArray[i] * longTermRateOfNthRups[i]);
            tempWtHist.add(magOfNthRups[i], longTermRateOfNthRups[i]);
        }
        for (i = 0; i < aveGainVsMagHist.size(); ++i) {
            double wt = tempWtHist.getY(i);
            if (!(wt > 1.0E-15)) continue;
            aveGainVsMagHist.set(i, aveGainVsMagHist.getY(i) / wt);
        }
        aveGainVsMagHist.setName("aveGainVsMagHist");
        aveGainVsMagHist.setInfo("weighted by rupture long-term rates");
        GraphWindow graphAveGainVsMagHist = new GraphWindow(aveGainVsMagHist, "Ave Rup Gain vs Mag; " + (String)plotLabelString);
        graphAveGainVsMagHist.setX_AxisLabel("Mag");
        graphAveGainVsMagHist.setY_AxisLabel("Ave Gain");
        graphAveGainVsMagHist.setAxisLabelFontSize(22);
        graphAveGainVsMagHist.setTickLabelFontSize(20);
        graphAveGainVsMagHist.setPlotLabelFontSize(22);
        double aper = Double.NaN;
        if (this.numAperValues == 1) {
            aper = this.aperValues[0];
        }
        ArrayList<EvenlyDiscretizedFunc> funcList = ProbModelsPlottingUtils.getNormRI_DistributionWithFits(normalizedRupRecurIntervals, aper);
        GraphWindow grapha_a = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcList, "Normalized Rupture RIs; " + (String)plotLabelString);
        infoString = infoString + "\n\nRup " + funcList.get(0).getName() + ":";
        infoString = infoString + "\n" + funcList.get(0).getInfo();
        infoString = infoString + "\n\n" + funcList.get(1).getName();
        infoString = infoString + "\n" + funcList.get(1).getInfo();
        if (this.numAperValues > 1) {
            for (int i2 = 0; i2 < this.numAperValues; ++i2) {
                ArrayList<EvenlyDiscretizedFunc> funcListMagDep = ProbModelsPlottingUtils.getNormRI_DistributionWithFits((ArrayList)normalizedRupRecurIntervalsMagDepList.get(i2), this.aperValues[i2]);
                String label = this.getMagDepAperInfoString(i2);
                GraphWindow graphaMagDep = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListMagDep, "Norm Rup RIs; " + label + "; " + (String)plotLabelString);
                infoString = infoString + "\n\nRup " + funcListMagDep.get(0).getName() + " for " + label + ":";
                infoString = infoString + "\n" + funcListMagDep.get(0).getInfo();
                infoString = infoString + "\n\n" + funcListMagDep.get(1).getName();
                infoString = infoString + "\n" + funcListMagDep.get(1).getInfo();
                try {
                    graphaMagDep.saveAsPDF(dirNameForSavingFiles + "/normRupRecurIntsForMagRange" + i2 + ".pdf");
                    graphaMagDep.saveAsTXT(dirNameForSavingFiles + "/normRupRecurIntsForMagRange" + i2 + ".txt");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<EvenlyDiscretizedFunc> funcList2 = ProbModelsPlottingUtils.getNormRI_DistributionWithFits(normalizedSectRecurIntervals, aper);
        GraphWindow graph2_b = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcList2, "Normalized Section RIs; " + (String)plotLabelString);
        infoString = infoString + "\n\nSect " + funcList2.get(0).getName() + ":";
        infoString = infoString + "\n" + funcList2.get(0).getInfo();
        String sectName = erf.getSolution().getRupSet().getFaultSectionData(testSectionIndex).getName();
        ArrayList<EvenlyDiscretizedFunc> funcListTestSect = ProbModelsPlottingUtils.getNormRI_DistributionWithFits(normalizedSectRecurIntervalsForTestSect, aper);
        GraphWindow graphTestSect = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListTestSect, "Normalized Section RIs for " + sectName);
        infoString = infoString + "\n\nTestSect " + funcListTestSect.get(0).getName() + ":";
        infoString = infoString + "\n" + funcListTestSect.get(0).getInfo();
        if (this.numAperValues > 1) {
            for (int i10 = 0; i10 < this.numAperValues; ++i10) {
                ArrayList<EvenlyDiscretizedFunc> funcListMagDep = ProbModelsPlottingUtils.getNormRI_DistributionWithFits((ArrayList)normalizedSectRecurIntervalsMagDepList.get(i10), this.aperValues[i10]);
                String label = this.getMagDepAperInfoString(i10);
                GraphWindow graphaMagDep = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListMagDep, "Norm Sect RIs; " + label + "; " + (String)plotLabelString);
                infoString = infoString + "\n\nSect " + funcListMagDep.get(0).getName() + " for " + label + ":";
                infoString = infoString + "\n" + funcListMagDep.get(0).getInfo();
                infoString = infoString + "\n\n" + funcListMagDep.get(1).getName();
                infoString = infoString + "\n" + funcListMagDep.get(1).getInfo();
                try {
                    graphaMagDep.saveAsPDF(dirNameForSavingFiles + "/normSectRecurIntsForMagRange" + i10 + ".pdf");
                    graphaMagDep.saveAsTXT(dirNameForSavingFiles + "/normSectRecurIntsForMagRange" + i10 + ".txt");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        boolean doThis = true;
        if (probTypeEnum == ProbabilityModelOptions.U3_BPT && doThis) {
            this.simNormTimeSinceLastHist.scale(1.0 / (this.simNormTimeSinceLastHist.calcSumOfY_Vals() * this.simNormTimeSinceLastHist.getDelta()));
            ArrayList<EvenlyDiscretizedFunc> funcListForSimNormTimeSinceLastHist = ProbModelsPlottingUtils.addBPT_Fit(this.simNormTimeSinceLastHist);
            this.simNormTimeSinceLastHist.setName("simNormTimeSinceLastHist");
            this.simNormTimeSinceLastHist.setInfo("Dist of normalized time since last for each rupture at all event times\nMean = " + this.simNormTimeSinceLastHist.computeMean());
            GraphWindow graphSimNormTimeSinceLastHist = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListForSimNormTimeSinceLastHist, "simNormTimeSinceLastHist; " + (String)plotLabelString);
            this.simNormTimeSinceLastForMagBelow7_Hist.scale(1.0 / (this.simNormTimeSinceLastForMagBelow7_Hist.calcSumOfY_Vals() * this.simNormTimeSinceLastForMagBelow7_Hist.getDelta()));
            ArrayList<EvenlyDiscretizedFunc> funcListForSimNormTimeSinceLastHistForSmall = ProbModelsPlottingUtils.addBPT_Fit(this.simNormTimeSinceLastForMagBelow7_Hist);
            this.simNormTimeSinceLastForMagBelow7_Hist.setName("simNormTimeSinceLastForMagBelow7_Hist");
            this.simNormTimeSinceLastForMagBelow7_Hist.setInfo("Dist of normalized time since last for each rupture at all event times from M<=7\nMean = " + this.simNormTimeSinceLastForMagBelow7_Hist.computeMean());
            GraphWindow graphSimNormTimeSinceLastForMagBelow7_Hist = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListForSimNormTimeSinceLastHistForSmall, "simNormTimeSinceLastForMagBelow7_Hist; " + (String)plotLabelString);
            this.simNormTimeSinceLastForMagAbove7_Hist.scale(1.0 / (this.simNormTimeSinceLastForMagAbove7_Hist.calcSumOfY_Vals() * this.simNormTimeSinceLastForMagAbove7_Hist.getDelta()));
            ArrayList<EvenlyDiscretizedFunc> funcListForSimNormTimeSinceLastHistForLarge = ProbModelsPlottingUtils.addBPT_Fit(this.simNormTimeSinceLastForMagAbove7_Hist);
            this.simNormTimeSinceLastForMagAbove7_Hist.setName("simNormTimeSinceLastForMagAbove7_Hist");
            this.simNormTimeSinceLastForMagAbove7_Hist.setInfo("Dist of normalized time since last for each rupture at all event times from M>7\nMean = " + this.simNormTimeSinceLastForMagAbove7_Hist.computeMean());
            GraphWindow graphSimNormTimeSinceLastForMagAbove7_Hist = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListForSimNormTimeSinceLastHistForLarge, "simNormTimeSinceLastForMagAbove7_Hist; " + (String)plotLabelString);
            this.simProbGainHist.scale(1.0 / (this.simProbGainHist.calcSumOfY_Vals() * this.simProbGainHist.getDelta()));
            this.simProbGainHist.setName("simProbGainHist");
            this.simProbGainHist.setInfo("Dist of gains for each rupture at all event times (simProbGainHist)\nMean = " + this.simProbGainHist.computeMean());
            ArrayList<HistogramFunction> funcListForSimProbGainHist = new ArrayList<HistogramFunction>();
            funcListForSimProbGainHist.add(this.simProbGainHist);
            this.simProbGainForMagBelow7_Hist.scale(1.0 / (this.simProbGainForMagBelow7_Hist.calcSumOfY_Vals() * this.simProbGainForMagBelow7_Hist.getDelta()));
            this.simProbGainForMagAbove7_Hist.scale(1.0 / (this.simProbGainForMagAbove7_Hist.calcSumOfY_Vals() * this.simProbGainForMagAbove7_Hist.getDelta()));
            this.simProbGainForMagBelow7_Hist.setName("simProbGainForMagBelow7_Hist");
            this.simProbGainForMagAbove7_Hist.setName("simProbGainForMagAbove7_Hist");
            this.simProbGainForMagBelow7_Hist.setInfo("Mean = " + this.simProbGainForMagBelow7_Hist.computeMean());
            this.simProbGainForMagAbove7_Hist.setInfo("Mean = " + this.simProbGainForMagAbove7_Hist.computeMean());
            funcListForSimProbGainHist.add(this.simProbGainForMagBelow7_Hist);
            funcListForSimProbGainHist.add(this.simProbGainForMagAbove7_Hist);
            ArrayList<PlotCurveCharacterstics> plotCharsForSimProbGainHist = new ArrayList<PlotCurveCharacterstics>();
            plotCharsForSimProbGainHist.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.RED));
            plotCharsForSimProbGainHist.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
            plotCharsForSimProbGainHist.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            GraphWindow graphSimProbGainHistWindow = new GraphWindow(funcListForSimProbGainHist, "simProbGainHist", plotCharsForSimProbGainHist);
            graphSimProbGainHistWindow.setX_AxisLabel("Gain");
            graphSimProbGainHistWindow.setY_AxisLabel("Density");
            graphSimProbGainHistWindow.setAxisLabelFontSize(22);
            graphSimProbGainHistWindow.setTickLabelFontSize(20);
            graphSimProbGainHistWindow.setPlotLabelFontSize(22);
            try {
                graphSimNormTimeSinceLastHist.saveAsPDF(dirNameForSavingFiles + "/simNormTimeSinceLastHist.pdf");
                graphSimProbGainHistWindow.saveAsPDF(dirNameForSavingFiles + "/simProbGainHist.pdf");
                graphSimNormTimeSinceLastForMagBelow7_Hist.saveAsPDF(dirNameForSavingFiles + "/simNormTimeSinceLastForMagBelow7_Hist.pdf");
                graphSimNormTimeSinceLastForMagAbove7_Hist.saveAsPDF(dirNameForSavingFiles + "/simNormTimeSinceLastForMagAbove7_Hist.pdf");
                graphSimNormTimeSinceLastHist.saveAsTXT(dirNameForSavingFiles + "/simNormTimeSinceLastHist.txt");
                graphSimProbGainHistWindow.saveAsTXT(dirNameForSavingFiles + "/simProbGainHist.txt");
                graphSimNormTimeSinceLastForMagBelow7_Hist.saveAsTXT(dirNameForSavingFiles + "/simNormTimeSinceLastForMagBelow7_Hist.txt");
                graphSimNormTimeSinceLastForMagAbove7_Hist.saveAsTXT(dirNameForSavingFiles + "/simNormTimeSinceLastForMagAbove7_Hist.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DefaultXY_DataSet totRateVersusTime = new DefaultXY_DataSet(yearsIntoSimulation, totRateAtYearsIntoSimulation);
        double meanTotRate = 0.0;
        double totWt = 0.0;
        for (int i11 = 0; i11 < totRateAtYearsIntoSimulation.size() - 1; ++i11) {
            double wt = yearsIntoSimulation.get(i11 + 1) - yearsIntoSimulation.get(i11);
            meanTotRate += totRateAtYearsIntoSimulation.get(i11) * wt;
            totWt += wt;
        }
        totRateVersusTime.setName("Total Rate vs Time");
        totRateVersusTime.setInfo("Mean Total Rate = " + (meanTotRate /= totWt) + "\nLong Term Rate = " + totalLongTermRate);
        DefaultXY_DataSet longTermRateFunc = new DefaultXY_DataSet();
        longTermRateFunc.set(totRateVersusTime.getMinX(), totalLongTermRate);
        longTermRateFunc.set(totRateVersusTime.getMaxX(), totalLongTermRate);
        longTermRateFunc.setName("Long term rate");
        ArrayList<DefaultXY_DataSet> funcsTotRate = new ArrayList<DefaultXY_DataSet>();
        funcsTotRate.add(totRateVersusTime);
        funcsTotRate.add(longTermRateFunc);
        ArrayList<PlotCurveCharacterstics> plotCharsTotRate = new ArrayList<PlotCurveCharacterstics>();
        plotCharsTotRate.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotCharsTotRate.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        GraphWindow graphTotalRateVsTime = new GraphWindow(funcsTotRate, "Total Rate vs Time; " + (String)plotLabelString, plotCharsTotRate);
        graphTotalRateVsTime.setX_AxisLabel("Times (years)");
        graphTotalRateVsTime.setY_AxisLabel("Total Rate (per year)");
        obsMFD.scale(1.0 / numYears);
        obsMFD.setName("Simulated MFD");
        obsMoRate /= numYears;
        double obsTotRate = obsMFD.getTotalIncrRate();
        double rateRatio = obsTotRate / targetMFD.getTotalIncrRate();
        String infoString2 = "total rate = " + (float)obsTotRate + " (ratio=" + (float)rateRatio + ")";
        double obsTotRateAbove6pt7 = obsMFD.getCumRate(6.75);
        double rateAbove6pt7_Ratio = obsTotRateAbove6pt7 / targetMFD.getCumRate(6.75);
        infoString2 = infoString2 + "\ntotal rate >= 6.7 = " + (float)obsTotRateAbove6pt7 + " (ratio=" + (float)rateAbove6pt7_Ratio + ")";
        double moRateRatio = obsMoRate / origTotMoRate;
        infoString2 = infoString2 + "\ntotal MoRate = " + (float)obsMoRate + " (ratio=" + (float)moRateRatio + ")";
        obsMFD.setInfo(infoString2);
        infoString = infoString + "\n\nSimulationStats:\n";
        infoString = infoString + "totRate\tratio\ttotRateM>=6.7\tratio\ttotMoRate\tratio\n";
        infoString = infoString + (float)obsTotRate + "\t" + (float)rateRatio + "\t" + (float)obsTotRateAbove6pt7 + "\t" + (float)rateAbove6pt7_Ratio + "\t" + (float)obsMoRate + "\t" + (float)moRateRatio;
        try {
            FileWriter info_fr = new FileWriter(dirNameForSavingFiles + "/infoString.txt");
            info_fr.write(infoString);
            info_fr.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println("INFO STRING:\n\n" + infoString);
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(targetMFD);
        funcs.add(obsMFD);
        funcs.add(targetMFD.getCumRateDistWithOffset());
        funcs.add(obsMFD.getCumRateDistWithOffset());
        GraphWindow graph = new GraphWindow(funcs, "Incremental Mag-Freq Dists; " + (String)plotLabelString);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setYLog(true);
        graph.setY_AxisRange(1.0E-4, 1.0);
        graph.setX_AxisRange(5.5, 8.5);
        for (int i12 = 0; i12 < obsRupRateArray.length; ++i12) {
            obsRupRateArray[i12] = obsRupRateArray[i12] / numYears;
        }
        DefaultXY_DataSet obsVsImposedRupRates = new DefaultXY_DataSet(longTermRateOfNthRups, obsRupRateArray);
        obsVsImposedRupRates.setName("Simulated vs Imposed Rup Rates");
        DefaultXY_DataSet perfectAgreementFunc4 = new DefaultXY_DataSet();
        perfectAgreementFunc4.set(1.0E-5, 1.0E-5);
        perfectAgreementFunc4.set(0.05, 0.05);
        perfectAgreementFunc4.setName("Perfect agreement line");
        ArrayList<DefaultXY_DataSet> funcs4 = new ArrayList<DefaultXY_DataSet>();
        funcs4.add(obsVsImposedRupRates);
        funcs4.add(perfectAgreementFunc4);
        ArrayList<PlotCurveCharacterstics> plotChars4 = new ArrayList<PlotCurveCharacterstics>();
        plotChars4.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotChars4.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        GraphWindow graph4 = new GraphWindow(funcs4, "Obs vs Imposed Rup Rates; " + (String)plotLabelString, plotChars4);
        graph4.setX_AxisRange(5.0 / numYears, 0.01);
        graph4.setY_AxisRange(5.0 / numYears, 0.01);
        graph4.setYLog(true);
        graph4.setXLog(true);
        graph4.setX_AxisLabel("Imposed Rup Rate (per yr)");
        graph4.setY_AxisLabel("Simulated Rup Rate (per yr)");
        GraphWindow graph9 = new GraphWindow(safEventFuncs, "SAF events; " + (String)plotLabelString, safPlotChars4);
        graph9.setX_AxisRange(36.8, 40.2);
        graph9.setY_AxisRange(1000.0, 11000.0);
        graph9.setX_AxisLabel("Latitute");
        graph9.setY_AxisLabel("Year");
        graph9.setSize(240, 800);
        for (int i13 = 0; i13 < obsSectSlipRateArray.length; ++i13) {
            obsSectSlipRateArray[i13] = obsSectSlipRateArray[i13] / numYears;
        }
        DefaultXY_DataSet obsVsImposedSectSlipRates = new DefaultXY_DataSet(longTermSlipRateForSectArray, obsSectSlipRateArray);
        obsVsImposedSectSlipRates.setName("Simulated vs Imposed Section Slip Rates");
        DefaultXY_DataSet perfectAgreementSlipRateFunc = new DefaultXY_DataSet();
        perfectAgreementSlipRateFunc.set(1.0E-5, 1.0E-5);
        perfectAgreementSlipRateFunc.set(0.05, 0.05);
        perfectAgreementSlipRateFunc.setName("Perfect agreement line");
        ArrayList<DefaultXY_DataSet> funcsSR = new ArrayList<DefaultXY_DataSet>();
        funcsSR.add(obsVsImposedSectSlipRates);
        funcsSR.add(perfectAgreementSlipRateFunc);
        ArrayList<PlotCurveCharacterstics> plotCharsSR = new ArrayList<PlotCurveCharacterstics>();
        plotCharsSR.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotCharsSR.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        GraphWindow graphSR = new GraphWindow(funcsSR, "Obs vs Imposed Section Slip Rates; " + (String)plotLabelString, plotCharsSR);
        graphSR.setX_AxisRange(1.0E-5, 0.05);
        graphSR.setY_AxisRange(1.0E-5, 0.05);
        graphSR.setYLog(true);
        graphSR.setXLog(true);
        graphSR.setX_AxisLabel("Imposed Section Slip Rate (mm/yr)");
        graphSR.setY_AxisLabel("Simulated Section Slip Rate (mm/yr)");
        for (int i14 = 0; i14 < obsSectRateArray.length; ++i14) {
            obsSectRateArray[i14] = obsSectRateArray[i14] / numYears;
            obsSectRateArrayM6pt05to6pt65[i14] = obsSectRateArrayM6pt05to6pt65[i14] / numYears;
            obsSectRateArrayM7pt95to8pt25[i14] = obsSectRateArrayM7pt95to8pt25[i14] / numYears;
        }
        DefaultXY_DataSet obsVsImposedSectRates = new DefaultXY_DataSet(this.longTermPartRateForSectArray, obsSectRateArray);
        obsVsImposedSectRates.setName("Simulated vs Imposed Section Event Rates");
        DefaultXY_DataSet perfectAgreementFunc = new DefaultXY_DataSet();
        perfectAgreementFunc.set(1.0E-5, 1.0E-5);
        perfectAgreementFunc.set(0.05, 0.05);
        perfectAgreementFunc.setName("Perfect agreement line");
        ArrayList<DefaultXY_DataSet> funcs2 = new ArrayList<DefaultXY_DataSet>();
        funcs2.add(obsVsImposedSectRates);
        funcs2.add(perfectAgreementFunc);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        GraphWindow graph2 = new GraphWindow(funcs2, "Obs vs Imposed Section Rates; " + probTypeString, plotChars);
        graph2.setX_AxisRange(5.0 / numYears, 0.05);
        graph2.setY_AxisRange(5.0 / numYears, 0.05);
        graph2.setYLog(true);
        graph2.setXLog(true);
        graph2.setX_AxisLabel("Imposed Section Participation Rate (per yr)");
        graph2.setY_AxisLabel("Simulated Section Participation Rate (per yr)");
        try {
            FileWriter eventRates_fr = new FileWriter(dirNameForSavingFiles + "/obsVsImposedSectionPartRates.txt");
            eventRates_fr.write("sectID\timposedRate\tsimulatedRate\tsimOverImpRateRatio\thasDateOfLast\tsectName\n");
            for (int i15 = 0; i15 < this.fltSysRupSet.getNumSections(); ++i15) {
                FaultSection fltData = this.fltSysRupSet.getFaultSectionData(i15);
                double ratio = obsSectRateArray[i15] / this.longTermPartRateForSectArray[i15];
                boolean hasDateOfLast = false;
                if (fltData.getDateOfLastEvent() != Long.MIN_VALUE) {
                    hasDateOfLast = true;
                }
                eventRates_fr.write(fltData.getSectionId() + "\t" + this.longTermPartRateForSectArray[i15] + "\t" + obsSectRateArray[i15] + "\t" + ratio + "\t" + hasDateOfLast + "\t" + fltData.getName() + "\n");
            }
            eventRates_fr.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ArrayList<EvenlyDiscretizedFunc> funcs8 = new ArrayList<EvenlyDiscretizedFunc>();
        EvenlyDiscretizedFunc meanAlongFunc = normRI_AlongStrike.getMeanCurve();
        meanAlongFunc.setName("mean");
        funcs8.add(normRI_AlongStrike.getMeanCurve());
        EvenlyDiscretizedFunc alongFunc2pt5 = normRI_AlongStrike.getInterpolatedFractileCurve(0.025);
        EvenlyDiscretizedFunc alongFunc97pt5 = normRI_AlongStrike.getInterpolatedFractileCurve(0.975);
        alongFunc2pt5.setInfo("2.5 percentile");
        alongFunc97pt5.setInfo("97.5 percentile");
        funcs8.add(alongFunc2pt5);
        funcs8.add(alongFunc97pt5);
        ArrayList<PlotCurveCharacterstics> plotChars8 = new ArrayList<PlotCurveCharacterstics>();
        plotChars8.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotChars8.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars8.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        GraphWindow graph8 = new GraphWindow(funcs8, "Normalized RI vs Normalized Dist Along Strike; " + probTypeString, plotChars8);
        graph8.setX_AxisLabel("Norm Dist Along Strike");
        graph8.setY_AxisLabel("Normalized RI");
        ArrayList<CallSite> outStringList = new ArrayList<CallSite>();
        int numSect = this.fltSysRupSet.getNumSections();
        double[] predSectRateArrayM6pt05to6pt65 = new double[numSect];
        double[] predSectRateArrayM7pt95to8pt25 = new double[numSect];
        for (int s = 0; s < numSect; ++s) {
            double partRateMlow = 0.0;
            double d = 0.0;
            for (int r : this.fltSysRupSet.getRupturesForSection(s)) {
                double mag = this.fltSysRupSet.getMagForRup(r);
                if (mag > 6.0 && mag < 6.7) {
                    partRateMlow += this.fltSysSolution.getRateForRup(r);
                    continue;
                }
                if (!(mag > 7.9) || !(mag < 8.3)) continue;
                d = this.fltSysSolution.getRateForRup(r);
            }
            predSectRateArrayM6pt05to6pt65[s] = partRateMlow;
            predSectRateArrayM7pt95to8pt25[s] = d;
            outStringList.add((CallSite)((Object)(s + "\t" + obsSectRateArray[s] + "\t" + this.longTermPartRateForSectArray[s] + "\t" + obsSectRateArray[s] / this.longTermPartRateForSectArray[s] + "\t" + predSectRateArrayM6pt05to6pt65[s] + "\t" + obsSectRateArrayM6pt05to6pt65[s] + "\t" + predSectRateArrayM7pt95to8pt25[s] + "\t" + obsSectRateArrayM7pt95to8pt25[s] + "\t" + this.fltSysRupSet.getFaultSectionData(s).getName() + "\n")));
        }
        File dataFile = new File(resultsDir, File.separator + "testSectRates");
        try {
            FileWriter fileWriter = new FileWriter(dataFile);
            for (String string : outStringList) {
                fileWriter.write(string);
            }
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        DefaultXY_DataSet obs_pred_ratioForSections = new DefaultXY_DataSet();
        for (int s = 0; s < numSect; ++s) {
            if (!(predSectRateArrayM6pt05to6pt65[s] >= 10.0 / numYears)) continue;
            obs_pred_ratioForSections.set(predSectRateArrayM6pt05to6pt65[s], obsSectRateArrayM6pt05to6pt65[s] / predSectRateArrayM6pt05to6pt65[s]);
        }
        DefaultXY_DataSet perfectAgreementFunc2 = new DefaultXY_DataSet();
        perfectAgreementFunc2.set(10.0 / numYears, 1.0);
        perfectAgreementFunc2.set(0.1, 1.0);
        perfectAgreementFunc2.setName("Perfect agreement line");
        ArrayList<DefaultXY_DataSet> arrayList = new ArrayList<DefaultXY_DataSet>();
        arrayList.add(obs_pred_ratioForSections);
        arrayList.add(perfectAgreementFunc2);
        ArrayList<PlotCurveCharacterstics> plotChars2 = new ArrayList<PlotCurveCharacterstics>();
        plotChars2.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotChars2.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        GraphWindow graph3 = new GraphWindow(arrayList, "Obs/imposed vs Imposed Section Rates for M 6.0 to 6.7; " + (String)plotLabelString, plotChars2);
        graph3.setX_AxisLabel("Imposed Section Participation Rate (per yr)");
        graph3.setY_AxisLabel("Ratio of Observed to Imposed");
        graph3.setXLog(true);
        try {
            graphAveRupProbGainVsMag.saveAsPDF(dirNameForSavingFiles + "/aveRupProbGainVsMag.pdf");
            graphAveRupProbGainVsMag.saveAsTXT(dirNameForSavingFiles + "/aveRupProbGainVsMag.txt");
            grapha_a.saveAsPDF(dirNameForSavingFiles + "/normalizedRupRecurIntervals.pdf");
            grapha_a.saveAsTXT(dirNameForSavingFiles + "/normalizedRupRecurIntervalsPlot.txt");
            graph2_b.saveAsPDF(dirNameForSavingFiles + "/normalizedSectRecurIntervals.pdf");
            graph2_b.saveAsTXT(dirNameForSavingFiles + "/normalizedSectRecurIntervalsPlot.txt");
            graphTestSect.saveAsPDF(dirNameForSavingFiles + "/normalizedRecurIntervalsForTestSect.pdf");
            graphTestSect.saveAsTXT(dirNameForSavingFiles + "/normalizedRecurIntervalsForTestSect.txt");
            graphTotalRateVsTime.saveAsPDF(dirNameForSavingFiles + "/totalRateVsTime.pdf");
            graph.saveAsPDF(dirNameForSavingFiles + "/magFreqDists.pdf");
            graph2.saveAsPDF(dirNameForSavingFiles + "/obsVsImposedSectionPartRates.pdf");
            graph4.saveAsPDF(dirNameForSavingFiles + "/obsVsImposedRupRates.pdf");
            graph4.saveAsTXT(dirNameForSavingFiles + "/obsVsImposedRupRates.txt");
            graph3.saveAsPDF(dirNameForSavingFiles + "/obsOverImposedVsImposedSectionPartRatesM6to6pt7.pdf");
            graph8.saveAsPDF(dirNameForSavingFiles + "/normRI_AlongRupTrace.pdf");
            graphSR.saveAsPDF(dirNameForSavingFiles + "/obsVsImposedSectionSlipRates.pdf");
            graphSR.saveAsTXT(dirNameForSavingFiles + "/obsVsImposedSectionSlipRates.txt");
            graphAveGainVsMagHist.saveAsPDF(dirNameForSavingFiles + "/aveRupGainVsMagHist.pdf");
            graphAveGainVsMagHist.saveAsTXT(dirNameForSavingFiles + "/aveRupGainVsMagHist.txt");
            FileWriter fr = new FileWriter(dirNameForSavingFiles + "/normalizedRupRecurIntervals.txt");
            for (double val : normalizedRupRecurIntervals) {
                fr.write(val + "\n");
            }
            fr.close();
            fr = new FileWriter(dirNameForSavingFiles + "/normalizedSectRecurIntervals.txt");
            for (double val : normalizedSectRecurIntervals) {
                fr.write(val + "\n");
            }
            fr.close();
            AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)targetMFD, dirNameForSavingFiles + "/targetMFD.txt");
            AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)obsMFD, dirNameForSavingFiles + "/simulatedMFD.txt");
            AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)targetMFD.getCumRateDistWithOffset(), dirNameForSavingFiles + "/targetCumMFD.txt");
            AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)obsMFD.getCumRateDistWithOffset(), dirNameForSavingFiles + "/simulatedCumMFD.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testER_SimulationOnParentSection(String inputDateOfLastFileName, String outputDateOfLastFileName, FaultSystemSolutionERF erf, double numYears, String dirNameSuffix, int parentSectIndex) {
        int i;
        double[] aveCondRecurIntervalForFltSysRups;
        String probTypeString;
        boolean aveRecurIntervals = erf.aveRecurIntervalsInU3_BPTcalc;
        boolean aveNormTimeSinceLast = erf.aveNormTimeSinceLastInU3_BPTcalc;
        this.simulationMode = true;
        this.simNormTimeSinceLastHist = new HistogramFunction(0.05, 100, 0.1);
        this.simNormTimeSinceLastForMagBelow7_Hist = new HistogramFunction(0.05, 100, 0.1);
        this.simNormTimeSinceLastForMagAbove7_Hist = new HistogramFunction(0.05, 100, 0.1);
        this.simProbGainHist = new HistogramFunction(0.05, 100, 0.1);
        this.simProbGainForMagAbove7_Hist = new HistogramFunction(0.05, 100, 0.1);
        this.simProbGainForMagBelow7_Hist = new HistogramFunction(0.05, 100, 0.1);
        Object typeCalcForU3_Probs = aveRecurIntervals ? "aveRI" : "aveRate";
        typeCalcForU3_Probs = aveNormTimeSinceLast ? (String)typeCalcForU3_Probs + "_aveNormTimeSince" : (String)typeCalcForU3_Probs + "_aveTimeSince";
        ProbabilityModelOptions probTypeEnum = (ProbabilityModelOptions)((Object)erf.getParameter("Probability Model").getValue());
        Object aperString = "aper";
        if (probTypeEnum != ProbabilityModelOptions.POISSON) {
            boolean first = true;
            for (double aperVal : this.aperValues) {
                aperString = first ? (String)aperString + aperVal : (String)aperString + "," + aperVal;
                first = false;
            }
            aperString = ((String)aperString).replace(".", "pt");
        }
        System.out.println("\naperString: " + (String)aperString + "\n");
        int tempDur = (int)Math.round(numYears / 1000.0);
        if (probTypeEnum == ProbabilityModelOptions.POISSON) {
            probTypeString = "Pois";
        } else if (probTypeEnum == ProbabilityModelOptions.U3_BPT) {
            probTypeString = "U3BPT";
        } else if (probTypeEnum == ProbabilityModelOptions.WG02_BPT) {
            probTypeString = "WG02BPT";
        } else {
            throw new RuntimeException("Porbability type unrecognized");
        }
        String dirNameForSavingFiles = "Psect_" + parentSectIndex + "_" + probTypeString + "_" + tempDur + "kyr";
        if (probTypeEnum != ProbabilityModelOptions.POISSON) {
            dirNameForSavingFiles = dirNameForSavingFiles + "_" + (String)aperString;
            dirNameForSavingFiles = dirNameForSavingFiles + "_" + (String)typeCalcForU3_Probs;
        }
        dirNameForSavingFiles = dirNameForSavingFiles + "_" + dirNameSuffix;
        Object plotLabelString = probTypeString;
        if (probTypeEnum == ProbabilityModelOptions.U3_BPT) {
            plotLabelString = (String)plotLabelString + " (" + (String)aperString + ", " + (String)typeCalcForU3_Probs + ")";
        } else if (probTypeEnum == ProbabilityModelOptions.WG02_BPT) {
            plotLabelString = (String)plotLabelString + " (" + (String)aperString + ")";
        }
        File resultsDir = new File(dirNameForSavingFiles);
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        double[] probGainForFaultSystemSource = new double[erf.getNumFaultSystemSources()];
        for (int s = 0; s < probGainForFaultSystemSource.length; ++s) {
            probGainForFaultSystemSource[s] = 1.0;
        }
        long origStartTimeMillis = 0L;
        if (probTypeEnum != ProbabilityModelOptions.POISSON) {
            origStartTimeMillis = erf.getTimeSpan().getStartTimeInMillis();
        }
        double origStartYear = (double)origStartTimeMillis / 3.15576E10 + 1970.0;
        System.out.println("orig start time: " + origStartTimeMillis + " millis (" + origStartYear + " yrs)");
        System.out.println("numYears: " + numYears);
        double simDuration = 5.0;
        ArrayList<Double> normalizedRupRecurIntervals = new ArrayList<Double>();
        ArrayList<Double> normalizedSectRecurIntervals = new ArrayList<Double>();
        ArrayList normalizedRupRecurIntervalsMagDepList = new ArrayList();
        ArrayList normalizedSectRecurIntervalsMagDepList = new ArrayList();
        for (int i2 = 0; i2 < this.numAperValues; ++i2) {
            normalizedRupRecurIntervalsMagDepList.add(new ArrayList());
            normalizedSectRecurIntervalsMagDepList.add(new ArrayList());
        }
        ArrayList<Double> yearsIntoSimulation = new ArrayList<Double>();
        ArrayList<Double> totRateAtYearsIntoSimulation = new ArrayList<Double>();
        double[] obsSectRateArray = new double[this.numSections];
        double[] obsSectSlipRateArray = new double[this.numSections];
        double[] obsRupRateArray = new double[erf.getTotNumRups()];
        double[] aveRupProbGainArray = new double[erf.getTotNumRups()];
        double[] minRupProbGainArray = new double[erf.getTotNumRups()];
        double[] maxRupProbGainArray = new double[erf.getTotNumRups()];
        FileWriter eventFileWriter = null;
        try {
            eventFileWriter = new FileWriter(dirNameForSavingFiles + "/sampledEventsData.txt");
            eventFileWriter.write("nthRupIndex\tfssRupIndex\tyear\tepoch\tnormRupRI\n");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        int numRups = 0;
        int numSteps = 0;
        RandomDataGenerator randomDataSampler = new RandomDataGenerator();
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.POISSON);
        erf.updateForecast();
        List<Integer> fltSysRupIndicesForParentList = this.fltSysRupSet.getRupturesForParentSection(parentSectIndex);
        double totalRate = 0.0;
        IntegerPDF_FunctionSampler nthRupRandomSampler = new IntegerPDF_FunctionSampler(erf.getTotNumRups());
        double[] longTermRateOfNthRups = new double[erf.getTotNumRups()];
        double[] magOfNthRups = new double[erf.getTotNumRups()];
        double[] longTermSlipRateForSectArray = new double[this.numSections];
        int nthRup = 0;
        for (ProbEqkSource src : erf) {
            for (ProbEqkRupture rup : src) {
                double rate = rup.getMeanAnnualRate(erf.getTimeSpan().getDuration());
                int fltSysRupIndex = erf.getFltSysRupIndexForNthRup(nthRup);
                longTermRateOfNthRups[nthRup] = fltSysRupIndicesForParentList.contains(fltSysRupIndex) ? rate : 0.0;
                magOfNthRups[nthRup] = rup.getMag();
                totalRate += longTermRateOfNthRups[nthRup];
                nthRupRandomSampler.set(nthRup, longTermRateOfNthRups[nthRup]);
                if (erf.getSrcIndexForNthRup(nthRup) < erf.getNumFaultSystemSources()) {
                    double[] slips;
                    int fltSysIndex = erf.getFltSysRupIndexForNthRup(nthRup);
                    List<Integer> sectIndices = this.fltSysRupSet.getSectionsIndicesForRup(fltSysIndex);
                    if (this.fltSysRupSet instanceof InversionFaultSystemRupSet) {
                        slips = ((InversionFaultSystemRupSet)this.fltSysRupSet).getSlipOnSectionsForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                    } else {
                        double mag = this.fltSysRupSet.getMagForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                        double area = this.fltSysRupSet.getAreaForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                        double aveSlip = FaultMomentCalc.getSlip(area, MagUtils.magToMoment(mag));
                        slips = new double[sectIndices.size()];
                        for (int i3 = 0; i3 < slips.length; ++i3) {
                            slips[i3] = aveSlip;
                        }
                    }
                    for (int s = 0; s < sectIndices.size(); ++s) {
                        int sectID;
                        int n = sectID = sectIndices.get(s).intValue();
                        longTermSlipRateForSectArray[n] = longTermSlipRateForSectArray[n] + rate * slips[s];
                    }
                }
                ++nthRup;
            }
        }
        System.out.println("totalRate long term = " + totalRate);
        double totalLongTermRate = totalRate;
        ArrayList<int[]> sectIndexArrayForSrcList = new ArrayList<int[]>();
        for (int s = 0; s < erf.getNumFaultSystemSources(); ++s) {
            List<Integer> indexList = this.fltSysRupSet.getSectionsIndicesForRup(erf.getFltSysRupIndexForSource(s));
            int[] indexArray = new int[indexList.size()];
            for (int i4 = 0; i4 < indexList.size(); ++i4) {
                indexArray[i4] = indexList.get(i4);
            }
            sectIndexArrayForSrcList.add(indexArray);
        }
        System.out.println("Making target MFD");
        SummedMagFreqDist targetMFD = ERF_Calculator.getTotalMFD_ForERF(erf, 5.05, 8.95, 40, true);
        double origTotMoRate = ERF_Calculator.getTotalMomentRateInRegion(erf, null);
        System.out.println("originalTotalMomentRate: " + origTotMoRate);
        targetMFD.setName("Target MFD");
        String tempString = "total rate = " + (float)targetMFD.getTotalIncrRate();
        tempString = tempString + "\ntotal rate >= 6.7 = " + (float)targetMFD.getCumRate(6.75);
        tempString = tempString + "\ntotal MoRate = " + (float)origTotMoRate;
        targetMFD.setInfo(tempString);
        SummedMagFreqDist obsMFD = new SummedMagFreqDist(5.05, 8.95, 40);
        double obsMoRate = 0.0;
        if (aveRecurIntervals) {
            if (this.aveCondRecurIntervalForFltSysRups_type1 == null) {
                this.aveCondRecurIntervalForFltSysRups_type1 = this.computeAveCondRecurIntervalForFltSysRups(1);
            }
            aveCondRecurIntervalForFltSysRups = this.aveCondRecurIntervalForFltSysRups_type1;
        } else {
            if (this.aveCondRecurIntervalForFltSysRups_type2 == null) {
                this.aveCondRecurIntervalForFltSysRups_type2 = this.computeAveCondRecurIntervalForFltSysRups(2);
            }
            aveCondRecurIntervalForFltSysRups = this.aveCondRecurIntervalForFltSysRups_type2;
        }
        double currentYear = origStartYear;
        long currentTimeMillis = origStartTimeMillis;
        int percDoneThresh = 0;
        int percDoneIncrement = 5;
        long startRunTime = System.currentTimeMillis();
        if (inputDateOfLastFileName != null && probTypeEnum != ProbabilityModelOptions.POISSON) {
            this.readSectTimeSinceLastEventFromFile(inputDateOfLastFileName, currentTimeMillis);
        } else {
            this.getSectNormTimeSinceLastHistPlot(currentTimeMillis, "From Pref Data");
        }
        CalcProgressBar progressBar = new CalcProgressBar(dirNameForSavingFiles, "Num Years Done");
        progressBar.showProgress(true);
        boolean firstEvent = true;
        while (currentYear < numYears + origStartYear) {
            progressBar.updateProgress((int)Math.round(currentYear - origStartYear), (int)Math.round(numYears));
            int percDone = (int)Math.round(100.0 * (currentYear - origStartYear) / numYears);
            if (percDone >= percDoneThresh) {
                double timeInMin = (double)(System.currentTimeMillis() - startRunTime) / 60000.0;
                System.out.println("\n" + percDoneThresh + "% done in " + (float)timeInMin + " minutes;  totalRate=" + (float)totalRate + "; yr=" + (float)currentYear + ": numRups=" + numRups + "\n");
                percDoneThresh += percDoneIncrement;
            }
            if (probTypeEnum != ProbabilityModelOptions.POISSON) {
                if (probTypeEnum == ProbabilityModelOptions.U3_BPT) {
                    for (int fltSysRupIndex : fltSysRupIndicesForParentList) {
                        int s = erf.getSrcIndexForFltSysRup(fltSysRupIndex);
                        probGainForFaultSystemSource[s] = this.getU3_ProbGainForRup(fltSysRupIndex, 0.0, false, aveRecurIntervals, aveNormTimeSinceLast, currentTimeMillis, simDuration);
                    }
                } else if (probTypeEnum == ProbabilityModelOptions.WG02_BPT) {
                    this.sectionGainArray = null;
                    for (int fltSysRupIndex : fltSysRupIndicesForParentList) {
                        int s = erf.getSrcIndexForFltSysRup(fltSysRupIndex);
                        probGainForFaultSystemSource[s] = this.getWG02_ProbGainForRup(fltSysRupIndex, false, currentTimeMillis, simDuration);
                    }
                }
                for (int fltSysRupIndex : fltSysRupIndicesForParentList) {
                    int srcIndex = erf.getSrcIndexForFltSysRup(fltSysRupIndex);
                    for (int n : erf.get_nthRupIndicesForSource(srcIndex)) {
                        double probGain = probGainForFaultSystemSource[srcIndex];
                        double newRate = longTermRateOfNthRups[n] * probGain;
                        nthRupRandomSampler.set(n, newRate);
                        int n2 = n;
                        aveRupProbGainArray[n2] = aveRupProbGainArray[n2] + probGain;
                        if (minRupProbGainArray[n] > probGain) {
                            minRupProbGainArray[n] = probGain;
                        }
                        if (!(maxRupProbGainArray[n] < probGain)) continue;
                        maxRupProbGainArray[n] = probGain;
                    }
                }
                totalRate = nthRupRandomSampler.getSumOfY_vals();
            }
            ++numSteps;
            yearsIntoSimulation.add(currentYear);
            totRateAtYearsIntoSimulation.add(totalRate);
            double timeToNextInYrs = totalRate > 1.0E-6 ? randomDataSampler.nextExponential(1.0 / totalRate) : simDuration * 10.0;
            if (timeToNextInYrs <= simDuration) {
                long eventTimeMillis = currentTimeMillis + (long)(timeToNextInYrs * 3.15576E10);
                nthRup = nthRupRandomSampler.getRandomInt();
                int srcIndex = erf.getSrcIndexForNthRup(nthRup);
                int n = nthRup;
                obsRupRateArray[n] = obsRupRateArray[n] + 1.0;
                if (srcIndex < erf.getNumFaultSystemSources()) {
                    double[] slips;
                    int fltSystRupIndex = erf.getFltSysRupIndexForSource(srcIndex);
                    double rupMag = this.fltSysRupSet.getMagForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                    if (aveNormTimeSinceLast) {
                        double aveNormYearsSinceLast = this.getAveNormTimeSinceLastEventWhereKnown(fltSystRupIndex, eventTimeMillis);
                        if (this.allSectionsHadDateOfLast) {
                            normalizedRupRecurIntervals.add(aveNormYearsSinceLast);
                            if (this.numAperValues > 0) {
                                ((ArrayList)normalizedRupRecurIntervalsMagDepList.get(this.getAperIndexForRupMag(rupMag))).add(aveNormYearsSinceLast);
                            }
                        }
                    } else {
                        long aveDateOfLastMillis = this.getAveDateOfLastEventWhereKnown(fltSystRupIndex, eventTimeMillis);
                        if (this.allSectionsHadDateOfLast) {
                            double timeSinceLast = (double)(eventTimeMillis - aveDateOfLastMillis) / 3.15576E10;
                            double normRI = timeSinceLast / aveCondRecurIntervalForFltSysRups[fltSystRupIndex];
                            normalizedRupRecurIntervals.add(normRI);
                            if (this.numAperValues > 0) {
                                ((ArrayList)normalizedRupRecurIntervalsMagDepList.get(this.getAperIndexForRupMag(rupMag))).add(normRI);
                            }
                        }
                    }
                    try {
                        eventFileWriter.write(nthRup + "\t" + fltSystRupIndex + "\t" + (currentYear + timeToNextInYrs) + "\t" + eventTimeMillis + "\t" + String.valueOf(normalizedRupRecurIntervals.get(normalizedRupRecurIntervals.size() - 1)) + "\n");
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    int[] sectID_Array = (int[])sectIndexArrayForSrcList.get(erf.getSrcIndexForFltSysRup(fltSystRupIndex));
                    int numSectInRup = sectID_Array.length;
                    if (this.fltSysRupSet instanceof InversionFaultSystemRupSet) {
                        slips = ((InversionFaultSystemRupSet)this.fltSysRupSet).getSlipOnSectionsForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                    } else {
                        double area = this.fltSysRupSet.getAreaForRup(erf.getFltSysRupIndexForNthRup(nthRup));
                        double aveSlip = FaultMomentCalc.getSlip(area, MagUtils.magToMoment(rupMag));
                        slips = new double[numSectInRup];
                        for (int i5 = 0; i5 < slips.length; ++i5) {
                            slips[i5] = aveSlip;
                        }
                    }
                    int ithSectInRup = 0;
                    int[] normRI = sectID_Array;
                    int aveSlip = normRI.length;
                    for (int j = 0; j < aveSlip; ++j) {
                        int sect;
                        int n3 = sect = normRI[j];
                        obsSectSlipRateArray[n3] = obsSectSlipRateArray[n3] + slips[ithSectInRup];
                        long timeOfLastMillis = this.dateOfLastForSect[sect];
                        if (timeOfLastMillis != Long.MIN_VALUE) {
                            double normYrsSinceLast = (double)(eventTimeMillis - timeOfLastMillis) / 3.15576E10 * this.longTermPartRateForSectArray[sect];
                            normalizedSectRecurIntervals.add(normYrsSinceLast);
                            if (this.numAperValues > 0) {
                                ((ArrayList)normalizedSectRecurIntervalsMagDepList.get(this.getAperIndexForRupMag(rupMag))).add(normYrsSinceLast);
                            }
                        }
                        ++ithSectInRup;
                    }
                    for (int sect : (int[])sectIndexArrayForSrcList.get(srcIndex)) {
                        this.dateOfLastForSect[sect] = eventTimeMillis;
                        int n4 = sect;
                        obsSectRateArray[n4] = obsSectRateArray[n4] + 1.0;
                    }
                }
                ++numRups;
                obsMFD.addResampledMagRate(magOfNthRups[nthRup], 1.0, true);
                obsMoRate += MagUtils.magToMoment(magOfNthRups[nthRup]);
                currentYear += timeToNextInYrs;
                currentTimeMillis = eventTimeMillis;
                firstEvent = false;
                continue;
            }
            currentYear += simDuration;
            currentTimeMillis += (long)(simDuration * 3.15576E10);
        }
        progressBar.showProgress(false);
        try {
            eventFileWriter.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (outputDateOfLastFileName != null) {
            this.writeSectTimeSinceLastEventToFile(outputDateOfLastFileName, currentTimeMillis);
        }
        String infoString = dirNameForSavingFiles;
        infoString = infoString + "\ninputDateOfLastFileName: " + inputDateOfLastFileName;
        infoString = infoString + "\nnumRups=" + numRups;
        double[] tempMagArray = new double[aveRupProbGainArray.length];
        for (int i6 = 0; i6 < aveRupProbGainArray.length; ++i6) {
            int n = i6;
            aveRupProbGainArray[n] = aveRupProbGainArray[n] / (double)numSteps;
            tempMagArray[i6] = magOfNthRups[i6];
        }
        DefaultXY_DataSet aveRupProbGainVsMag = new DefaultXY_DataSet(tempMagArray, aveRupProbGainArray);
        DefaultXY_DataSet minRupProbGainVsMag = new DefaultXY_DataSet(tempMagArray, minRupProbGainArray);
        DefaultXY_DataSet maxRupProbGainVsMag = new DefaultXY_DataSet(tempMagArray, maxRupProbGainArray);
        aveRupProbGainVsMag.setName("Ave Rup Prob Gain vs Mag");
        double meanProbGain = 0.0;
        for (double val : aveRupProbGainArray) {
            meanProbGain += val;
        }
        aveRupProbGainVsMag.setInfo("meanProbGain=" + (float)(meanProbGain /= (double)aveRupProbGainArray.length));
        minRupProbGainVsMag.setName("Min Rup Prob Gain vs Mag");
        maxRupProbGainVsMag.setName("Max Rup Prob Gain vs Mag");
        ArrayList<DefaultXY_DataSet> aveRupProbGainVsMagFuncs = new ArrayList<DefaultXY_DataSet>();
        aveRupProbGainVsMagFuncs.add(aveRupProbGainVsMag);
        aveRupProbGainVsMagFuncs.add(minRupProbGainVsMag);
        aveRupProbGainVsMagFuncs.add(maxRupProbGainVsMag);
        ArrayList<PlotCurveCharacterstics> plotCharsAveGain = new ArrayList<PlotCurveCharacterstics>();
        plotCharsAveGain.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotCharsAveGain.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.GREEN));
        plotCharsAveGain.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.RED));
        GraphWindow graphAveRupProbGainVsMag = new GraphWindow(aveRupProbGainVsMagFuncs, "Ave Rup Prob Gain vs Mag; " + (String)plotLabelString, plotCharsAveGain);
        graphAveRupProbGainVsMag.setX_AxisLabel("Magnitude");
        graphAveRupProbGainVsMag.setY_AxisLabel("Ave Rup Prob Gain");
        for (int i7 = 0; i7 < obsRupRateArray.length; ++i7) {
            obsRupRateArray[i7] = obsRupRateArray[i7] / numYears;
        }
        try {
            FileWriter gain_fr = new FileWriter(dirNameForSavingFiles + "/aveRupGainData.txt");
            gain_fr.write("nthRupIndex\taveRupGain\tminRupGain\tmaxRupGain\trupMag\trupLongTermRate\tobsRupRate\texpNumRups\trupCondRI\trupName\n");
            for (int i8 = 0; i8 < aveRupProbGainArray.length; ++i8) {
                if (!(longTermRateOfNthRups[i8] > 0.0)) continue;
                gain_fr.write(i8 + "\t" + aveRupProbGainArray[i8] + "\t" + minRupProbGainArray[i8] + "\t" + maxRupProbGainArray[i8] + "\t" + magOfNthRups[i8] + "\t" + longTermRateOfNthRups[i8] + "\t" + obsRupRateArray[i8] + "\t" + numYears * longTermRateOfNthRups[i8] + "\t" + aveCondRecurIntervalForFltSysRups[erf.getFltSysRupIndexForNthRup(i8)] + "\t" + erf.getSource(erf.getSrcIndexForNthRup(i8)).getName() + "\n");
            }
            gain_fr.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        HistogramFunction aveGainVsMagHist = new HistogramFunction(5.05, 40, 0.1);
        HistogramFunction tempWtHist = new HistogramFunction(5.05, 40, 0.1);
        for (i = 0; i < aveRupProbGainArray.length; ++i) {
            aveGainVsMagHist.add(magOfNthRups[i], aveRupProbGainArray[i] * longTermRateOfNthRups[i]);
            tempWtHist.add(magOfNthRups[i], longTermRateOfNthRups[i]);
        }
        for (i = 0; i < aveGainVsMagHist.size(); ++i) {
            double wt = tempWtHist.getY(i);
            if (!(wt > 1.0E-15)) continue;
            aveGainVsMagHist.set(i, aveGainVsMagHist.getY(i) / wt);
        }
        aveGainVsMagHist.setName("aveGainVsMagHist");
        aveGainVsMagHist.setInfo("weighted by rupture long-term rates");
        GraphWindow graphAveGainVsMagHist = new GraphWindow(aveGainVsMagHist, "Ave Rup Gain vs Mag; " + (String)plotLabelString);
        graphAveGainVsMagHist.setX_AxisLabel("Mag");
        graphAveGainVsMagHist.setY_AxisLabel("Ave Gain");
        graphAveGainVsMagHist.setAxisLabelFontSize(22);
        graphAveGainVsMagHist.setTickLabelFontSize(20);
        graphAveGainVsMagHist.setPlotLabelFontSize(22);
        double aper = Double.NaN;
        if (this.numAperValues == 1) {
            aper = this.aperValues[0];
        }
        ArrayList<EvenlyDiscretizedFunc> funcList = ProbModelsPlottingUtils.getNormRI_DistributionWithFits(normalizedRupRecurIntervals, aper);
        GraphWindow grapha_a = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcList, "Normalized Rupture RIs; " + (String)plotLabelString);
        infoString = infoString + "\n\nRup " + funcList.get(0).getName() + ":";
        infoString = infoString + "\n" + funcList.get(0).getInfo();
        infoString = infoString + "\n\n" + funcList.get(1).getName();
        infoString = infoString + "\n" + funcList.get(1).getInfo();
        if (this.numAperValues > 1) {
            for (int i9 = 0; i9 < this.numAperValues; ++i9) {
                ArrayList<EvenlyDiscretizedFunc> funcListMagDep = ProbModelsPlottingUtils.getNormRI_DistributionWithFits((ArrayList)normalizedRupRecurIntervalsMagDepList.get(i9), this.aperValues[i9]);
                String label = this.getMagDepAperInfoString(i9);
                GraphWindow graphaMagDep = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListMagDep, "Norm Rup RIs; " + label + "; " + (String)plotLabelString);
                infoString = infoString + "\n\nRup " + funcListMagDep.get(0).getName() + " for " + label + ":";
                infoString = infoString + "\n" + funcListMagDep.get(0).getInfo();
                infoString = infoString + "\n\n" + funcListMagDep.get(1).getName();
                infoString = infoString + "\n" + funcListMagDep.get(1).getInfo();
                try {
                    graphaMagDep.saveAsPDF(dirNameForSavingFiles + "/normRupRecurIntsForMagRange" + i9 + ".pdf");
                    graphaMagDep.saveAsTXT(dirNameForSavingFiles + "/normRupRecurIntsForMagRange" + i9 + ".txt");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        ArrayList<EvenlyDiscretizedFunc> funcList2 = ProbModelsPlottingUtils.getNormRI_DistributionWithFits(normalizedSectRecurIntervals, aper);
        GraphWindow graph2_b = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcList2, "Normalized Section RIs; " + (String)plotLabelString);
        infoString = infoString + "\n\nSect " + funcList2.get(0).getName() + ":";
        infoString = infoString + "\n" + funcList2.get(0).getInfo();
        if (this.numAperValues > 1) {
            for (int i10 = 0; i10 < this.numAperValues; ++i10) {
                ArrayList<EvenlyDiscretizedFunc> funcListMagDep = ProbModelsPlottingUtils.getNormRI_DistributionWithFits((ArrayList)normalizedSectRecurIntervalsMagDepList.get(i10), this.aperValues[i10]);
                String label = this.getMagDepAperInfoString(i10);
                GraphWindow graphaMagDep = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListMagDep, "Norm Sect RIs; " + label + "; " + (String)plotLabelString);
                infoString = infoString + "\n\nSect " + funcListMagDep.get(0).getName() + " for " + label + ":";
                infoString = infoString + "\n" + funcListMagDep.get(0).getInfo();
                infoString = infoString + "\n\n" + funcListMagDep.get(1).getName();
                infoString = infoString + "\n" + funcListMagDep.get(1).getInfo();
                try {
                    graphaMagDep.saveAsPDF(dirNameForSavingFiles + "/normSectRecurIntsForMagRange" + i10 + ".pdf");
                    graphaMagDep.saveAsTXT(dirNameForSavingFiles + "/normSectRecurIntsForMagRange" + i10 + ".txt");
                    continue;
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
            }
        }
        if (probTypeEnum == ProbabilityModelOptions.U3_BPT) {
            this.simNormTimeSinceLastHist.scale(1.0 / (this.simNormTimeSinceLastHist.calcSumOfY_Vals() * this.simNormTimeSinceLastHist.getDelta()));
            ArrayList<EvenlyDiscretizedFunc> funcListForSimNormTimeSinceLastHist = ProbModelsPlottingUtils.addBPT_Fit(this.simNormTimeSinceLastHist);
            this.simNormTimeSinceLastHist.setName("simNormTimeSinceLastHist");
            this.simNormTimeSinceLastHist.setInfo("Dist of normalized time since last for each rupture at all event times\nMean = " + this.simNormTimeSinceLastHist.computeMean());
            GraphWindow graphSimNormTimeSinceLastHist = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListForSimNormTimeSinceLastHist, "simNormTimeSinceLastHist; " + (String)plotLabelString);
            this.simNormTimeSinceLastForMagBelow7_Hist.scale(1.0 / (this.simNormTimeSinceLastForMagBelow7_Hist.calcSumOfY_Vals() * this.simNormTimeSinceLastForMagBelow7_Hist.getDelta()));
            ArrayList<EvenlyDiscretizedFunc> funcListForSimNormTimeSinceLastHistForSmall = ProbModelsPlottingUtils.addBPT_Fit(this.simNormTimeSinceLastForMagBelow7_Hist);
            this.simNormTimeSinceLastForMagBelow7_Hist.setName("simNormTimeSinceLastForMagBelow7_Hist");
            this.simNormTimeSinceLastForMagBelow7_Hist.setInfo("Dist of normalized time since last for each rupture at all event times from M<=7\nMean = " + this.simNormTimeSinceLastForMagBelow7_Hist.computeMean());
            GraphWindow graphSimNormTimeSinceLastForMagBelow7_Hist = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListForSimNormTimeSinceLastHistForSmall, "simNormTimeSinceLastForMagBelow7_Hist; " + (String)plotLabelString);
            this.simNormTimeSinceLastForMagAbove7_Hist.scale(1.0 / (this.simNormTimeSinceLastForMagAbove7_Hist.calcSumOfY_Vals() * this.simNormTimeSinceLastForMagAbove7_Hist.getDelta()));
            ArrayList<EvenlyDiscretizedFunc> funcListForSimNormTimeSinceLastHistForLarge = ProbModelsPlottingUtils.addBPT_Fit(this.simNormTimeSinceLastForMagAbove7_Hist);
            this.simNormTimeSinceLastForMagAbove7_Hist.setName("simNormTimeSinceLastForMagAbove7_Hist");
            this.simNormTimeSinceLastForMagAbove7_Hist.setInfo("Dist of normalized time since last for each rupture at all event times from M>7\nMean = " + this.simNormTimeSinceLastForMagAbove7_Hist.computeMean());
            GraphWindow graphSimNormTimeSinceLastForMagAbove7_Hist = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListForSimNormTimeSinceLastHistForLarge, "simNormTimeSinceLastForMagAbove7_Hist; " + (String)plotLabelString);
            this.simProbGainHist.scale(1.0 / (this.simProbGainHist.calcSumOfY_Vals() * this.simProbGainHist.getDelta()));
            this.simProbGainHist.setName("simProbGainHist");
            this.simProbGainHist.setInfo("Dist of gains for each rupture at all event times (simProbGainHist)\nMean = " + this.simProbGainHist.computeMean());
            ArrayList<HistogramFunction> funcListForSimProbGainHist = new ArrayList<HistogramFunction>();
            funcListForSimProbGainHist.add(this.simProbGainHist);
            this.simProbGainForMagBelow7_Hist.scale(1.0 / (this.simProbGainForMagBelow7_Hist.calcSumOfY_Vals() * this.simProbGainForMagBelow7_Hist.getDelta()));
            this.simProbGainForMagAbove7_Hist.scale(1.0 / (this.simProbGainForMagAbove7_Hist.calcSumOfY_Vals() * this.simProbGainForMagAbove7_Hist.getDelta()));
            this.simProbGainForMagBelow7_Hist.setName("simProbGainForMagBelow7_Hist");
            this.simProbGainForMagAbove7_Hist.setName("simProbGainForMagAbove7_Hist");
            this.simProbGainForMagBelow7_Hist.setInfo("Mean = " + this.simProbGainForMagBelow7_Hist.computeMean());
            this.simProbGainForMagAbove7_Hist.setInfo("Mean = " + this.simProbGainForMagAbove7_Hist.computeMean());
            funcListForSimProbGainHist.add(this.simProbGainForMagBelow7_Hist);
            funcListForSimProbGainHist.add(this.simProbGainForMagAbove7_Hist);
            ArrayList<PlotCurveCharacterstics> plotCharsForSimProbGainHist = new ArrayList<PlotCurveCharacterstics>();
            plotCharsForSimProbGainHist.add(new PlotCurveCharacterstics(PlotLineType.HISTOGRAM, 2.0f, Color.RED));
            plotCharsForSimProbGainHist.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
            plotCharsForSimProbGainHist.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
            GraphWindow graphSimProbGainHistWindow = new GraphWindow(funcListForSimProbGainHist, "simProbGainHist", plotCharsForSimProbGainHist);
            graphSimProbGainHistWindow.setX_AxisLabel("Gain");
            graphSimProbGainHistWindow.setY_AxisLabel("Density");
            graphSimProbGainHistWindow.setAxisLabelFontSize(22);
            graphSimProbGainHistWindow.setTickLabelFontSize(20);
            graphSimProbGainHistWindow.setPlotLabelFontSize(22);
            try {
                graphSimNormTimeSinceLastHist.saveAsPDF(dirNameForSavingFiles + "/simNormTimeSinceLastHist.pdf");
                graphSimProbGainHistWindow.saveAsPDF(dirNameForSavingFiles + "/simProbGainHist.pdf");
                graphSimNormTimeSinceLastForMagBelow7_Hist.saveAsPDF(dirNameForSavingFiles + "/simNormTimeSinceLastForMagBelow7_Hist.pdf");
                graphSimNormTimeSinceLastForMagAbove7_Hist.saveAsPDF(dirNameForSavingFiles + "/simNormTimeSinceLastForMagAbove7_Hist.pdf");
                graphSimNormTimeSinceLastHist.saveAsTXT(dirNameForSavingFiles + "/simNormTimeSinceLastHist.txt");
                graphSimProbGainHistWindow.saveAsTXT(dirNameForSavingFiles + "/simProbGainHist.txt");
                graphSimNormTimeSinceLastForMagBelow7_Hist.saveAsTXT(dirNameForSavingFiles + "/simNormTimeSinceLastForMagBelow7_Hist.txt");
                graphSimNormTimeSinceLastForMagAbove7_Hist.saveAsTXT(dirNameForSavingFiles + "/simNormTimeSinceLastForMagAbove7_Hist.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        DefaultXY_DataSet totRateVersusTime = new DefaultXY_DataSet(yearsIntoSimulation, totRateAtYearsIntoSimulation);
        double meanTotRate = 0.0;
        double totWt = 0.0;
        for (int i11 = 0; i11 < totRateAtYearsIntoSimulation.size() - 1; ++i11) {
            double wt = yearsIntoSimulation.get(i11 + 1) - yearsIntoSimulation.get(i11);
            meanTotRate += totRateAtYearsIntoSimulation.get(i11) * wt;
            totWt += wt;
        }
        totRateVersusTime.setName("Total Rate vs Time");
        totRateVersusTime.setInfo("Mean Total Rate = " + (meanTotRate /= totWt) + "\nLong Term Rate = " + totalLongTermRate);
        DefaultXY_DataSet longTermRateFunc = new DefaultXY_DataSet();
        longTermRateFunc.set(totRateVersusTime.getMinX(), totalLongTermRate);
        longTermRateFunc.set(totRateVersusTime.getMaxX(), totalLongTermRate);
        longTermRateFunc.setName("Long term rate");
        ArrayList<DefaultXY_DataSet> funcsTotRate = new ArrayList<DefaultXY_DataSet>();
        funcsTotRate.add(totRateVersusTime);
        funcsTotRate.add(longTermRateFunc);
        ArrayList<PlotCurveCharacterstics> plotCharsTotRate = new ArrayList<PlotCurveCharacterstics>();
        plotCharsTotRate.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotCharsTotRate.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        GraphWindow graphTotalRateVsTime = new GraphWindow(funcsTotRate, "Total Rate vs Time; " + (String)plotLabelString, plotCharsTotRate);
        graphTotalRateVsTime.setX_AxisLabel("Times (years)");
        graphTotalRateVsTime.setY_AxisLabel("Total Rate (per year)");
        obsMFD.scale(1.0 / numYears);
        obsMFD.setName("Simulated MFD");
        obsMoRate /= numYears;
        double obsTotRate = obsMFD.getTotalIncrRate();
        double rateRatio = obsTotRate / targetMFD.getTotalIncrRate();
        String infoString2 = "total rate = " + (float)obsTotRate + " (ratio=" + (float)rateRatio + ")";
        double obsTotRateAbove6pt7 = obsMFD.getCumRate(6.75);
        double rateAbove6pt7_Ratio = obsTotRateAbove6pt7 / targetMFD.getCumRate(6.75);
        infoString2 = infoString2 + "\ntotal rate >= 6.7 = " + (float)obsTotRateAbove6pt7 + " (ratio=" + (float)rateAbove6pt7_Ratio + ")";
        double moRateRatio = obsMoRate / origTotMoRate;
        infoString2 = infoString2 + "\ntotal MoRate = " + (float)obsMoRate + " (ratio=" + (float)moRateRatio + ")";
        obsMFD.setInfo(infoString2);
        infoString = infoString + "\n\nSimulationStats:\n";
        infoString = infoString + "totRate\tratio\ttotRateM>=6.7\tratio\ttotMoRate\tratio\n";
        infoString = infoString + (float)obsTotRate + "\t" + (float)rateRatio + "\t" + (float)obsTotRateAbove6pt7 + "\t" + (float)rateAbove6pt7_Ratio + "\t" + (float)obsMoRate + "\t" + (float)moRateRatio;
        try {
            FileWriter info_fr = new FileWriter(dirNameForSavingFiles + "/infoString.txt");
            info_fr.write(infoString);
            info_fr.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        System.out.println("INFO STRING:\n\n" + infoString);
        ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
        funcs.add(targetMFD);
        funcs.add(obsMFD);
        funcs.add(targetMFD.getCumRateDistWithOffset());
        funcs.add(obsMFD.getCumRateDistWithOffset());
        GraphWindow graph = new GraphWindow(funcs, "Incremental Mag-Freq Dists; " + (String)plotLabelString);
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Rate");
        graph.setYLog(true);
        graph.setY_AxisRange(1.0E-4, 1.0);
        graph.setX_AxisRange(5.5, 8.5);
        DefaultXY_DataSet obsVsImposedRupRates = new DefaultXY_DataSet(longTermRateOfNthRups, obsRupRateArray);
        obsVsImposedRupRates.setName("Simulated vs Imposed Rup Rates");
        DefaultXY_DataSet perfectAgreementFunc4 = new DefaultXY_DataSet();
        perfectAgreementFunc4.set(1.0E-5, 1.0E-5);
        perfectAgreementFunc4.set(0.05, 0.05);
        perfectAgreementFunc4.setName("Perfect agreement line");
        ArrayList<DefaultXY_DataSet> funcs4 = new ArrayList<DefaultXY_DataSet>();
        funcs4.add(obsVsImposedRupRates);
        funcs4.add(perfectAgreementFunc4);
        ArrayList<PlotCurveCharacterstics> plotChars4 = new ArrayList<PlotCurveCharacterstics>();
        plotChars4.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotChars4.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        GraphWindow graph4 = new GraphWindow(funcs4, "Obs vs Imposed Rup Rates; " + (String)plotLabelString, plotChars4);
        graph4.setX_AxisRange(5.0 / numYears, 0.01);
        graph4.setY_AxisRange(5.0 / numYears, 0.01);
        graph4.setYLog(true);
        graph4.setXLog(true);
        graph4.setX_AxisLabel("Imposed Rup Rate (per yr)");
        graph4.setY_AxisLabel("Simulated Rup Rate (per yr)");
        for (int i12 = 0; i12 < obsSectSlipRateArray.length; ++i12) {
            obsSectSlipRateArray[i12] = obsSectSlipRateArray[i12] / numYears;
        }
        DefaultXY_DataSet obsVsImposedSectSlipRates = new DefaultXY_DataSet(longTermSlipRateForSectArray, obsSectSlipRateArray);
        obsVsImposedSectSlipRates.setName("Simulated vs Imposed Section Slip Rates");
        DefaultXY_DataSet perfectAgreementSlipRateFunc = new DefaultXY_DataSet();
        perfectAgreementSlipRateFunc.set(1.0E-5, 1.0E-5);
        perfectAgreementSlipRateFunc.set(0.05, 0.05);
        perfectAgreementSlipRateFunc.setName("Perfect agreement line");
        ArrayList<DefaultXY_DataSet> funcsSR = new ArrayList<DefaultXY_DataSet>();
        funcsSR.add(obsVsImposedSectSlipRates);
        funcsSR.add(perfectAgreementSlipRateFunc);
        ArrayList<PlotCurveCharacterstics> plotCharsSR = new ArrayList<PlotCurveCharacterstics>();
        plotCharsSR.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotCharsSR.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        GraphWindow graphSR = new GraphWindow(funcsSR, "Obs vs Imposed Section Slip Rates; " + (String)plotLabelString, plotCharsSR);
        graphSR.setX_AxisRange(1.0E-5, 0.05);
        graphSR.setY_AxisRange(1.0E-5, 0.05);
        graphSR.setYLog(true);
        graphSR.setXLog(true);
        graphSR.setX_AxisLabel("Imposed Section Slip Rate (mm/yr)");
        graphSR.setY_AxisLabel("Simulated Section Slip Rate (mm/yr)");
        for (int i13 = 0; i13 < obsSectRateArray.length; ++i13) {
            obsSectRateArray[i13] = obsSectRateArray[i13] / numYears;
        }
        DefaultXY_DataSet obsVsImposedSectRates = new DefaultXY_DataSet(this.longTermPartRateForSectArray, obsSectRateArray);
        obsVsImposedSectRates.setName("Simulated vs Imposed Section Event Rates");
        DefaultXY_DataSet perfectAgreementFunc = new DefaultXY_DataSet();
        perfectAgreementFunc.set(1.0E-5, 1.0E-5);
        perfectAgreementFunc.set(0.05, 0.05);
        perfectAgreementFunc.setName("Perfect agreement line");
        ArrayList<DefaultXY_DataSet> funcs2 = new ArrayList<DefaultXY_DataSet>();
        funcs2.add(obsVsImposedSectRates);
        funcs2.add(perfectAgreementFunc);
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        GraphWindow graph2 = new GraphWindow(funcs2, "Obs vs Imposed Section Rates; " + probTypeString, plotChars);
        graph2.setX_AxisRange(5.0 / numYears, 0.05);
        graph2.setY_AxisRange(5.0 / numYears, 0.05);
        graph2.setYLog(true);
        graph2.setXLog(true);
        graph2.setX_AxisLabel("Imposed Section Participation Rate (per yr)");
        graph2.setY_AxisLabel("Simulated Section Participation Rate (per yr)");
        try {
            FileWriter eventRates_fr = new FileWriter(dirNameForSavingFiles + "/obsVsImposedSectionPartRates.txt");
            eventRates_fr.write("sectID\timposedRate\tsimulatedRate\tsimOverImpRateRatio\thasDateOfLast\tsectName\n");
            for (int i14 = 0; i14 < this.fltSysRupSet.getNumSections(); ++i14) {
                FaultSection fltData = this.fltSysRupSet.getFaultSectionData(i14);
                double ratio = obsSectRateArray[i14] / this.longTermPartRateForSectArray[i14];
                boolean hasDateOfLast = false;
                if (fltData.getDateOfLastEvent() != Long.MIN_VALUE) {
                    hasDateOfLast = true;
                }
                eventRates_fr.write(fltData.getSectionId() + "\t" + this.longTermPartRateForSectArray[i14] + "\t" + obsSectRateArray[i14] + "\t" + ratio + "\t" + hasDateOfLast + "\t" + fltData.getName() + "\n");
            }
            eventRates_fr.close();
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        try {
            graphAveRupProbGainVsMag.saveAsPDF(dirNameForSavingFiles + "/aveRupProbGainVsMag.pdf");
            graphAveRupProbGainVsMag.saveAsTXT(dirNameForSavingFiles + "/aveRupProbGainVsMag.txt");
            grapha_a.saveAsPDF(dirNameForSavingFiles + "/normalizedRupRecurIntervals.pdf");
            grapha_a.saveAsTXT(dirNameForSavingFiles + "/normalizedRupRecurIntervalsPlot.txt");
            graph2_b.saveAsPDF(dirNameForSavingFiles + "/normalizedSectRecurIntervals.pdf");
            graph2_b.saveAsTXT(dirNameForSavingFiles + "/normalizedSectRecurIntervalsPlot.txt");
            graphTotalRateVsTime.saveAsPDF(dirNameForSavingFiles + "/totalRateVsTime.pdf");
            graph.saveAsPDF(dirNameForSavingFiles + "/magFreqDists.pdf");
            graph2.saveAsPDF(dirNameForSavingFiles + "/obsVsImposedSectionPartRates.pdf");
            graph4.saveAsPDF(dirNameForSavingFiles + "/obsVsImposedRupRates.pdf");
            graph4.saveAsTXT(dirNameForSavingFiles + "/obsVsImposedRupRates.txt");
            graphSR.saveAsPDF(dirNameForSavingFiles + "/obsVsImposedSectionSlipRates.pdf");
            graphSR.saveAsTXT(dirNameForSavingFiles + "/obsVsImposedSectionSlipRates.txt");
            graphAveGainVsMagHist.saveAsPDF(dirNameForSavingFiles + "/aveRupGainVsMagHist.pdf");
            graphAveGainVsMagHist.saveAsTXT(dirNameForSavingFiles + "/aveRupGainVsMagHist.txt");
            FileWriter fr = new FileWriter(dirNameForSavingFiles + "/normalizedRupRecurIntervals.txt");
            for (double val : normalizedRupRecurIntervals) {
                fr.write(val + "\n");
            }
            fr.close();
            fr = new FileWriter(dirNameForSavingFiles + "/normalizedSectRecurIntervals.txt");
            for (double val : normalizedSectRecurIntervals) {
                fr.write(val + "\n");
            }
            fr.close();
            AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)targetMFD, dirNameForSavingFiles + "/targetMFD.txt");
            AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)obsMFD, dirNameForSavingFiles + "/simulatedMFD.txt");
            AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)targetMFD.getCumRateDistWithOffset(), dirNameForSavingFiles + "/targetCumMFD.txt");
            AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)obsMFD.getCumRateDistWithOffset(), dirNameForSavingFiles + "/simulatedCumMFD.txt");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void testER_NextXyrSimulation(File resultsDir, String inputDateOfLastFileName, int numCatalogs, boolean makePlots, Long randomSeed) throws IOException {
        this.testER_NextXyrSimulation(resultsDir, inputDateOfLastFileName, numCatalogs, makePlots, randomSeed, this.erf.getTimeSpan().getDuration());
    }

    public void testER_NextXyrSimulation(File resultsDir, String inputDateOfLastFileName, int numCatalogs, boolean makePlots, Long randomSeed, double forecastDurationYrs) throws IOException {
        CalcProgressBar progressBar;
        double[] aveCondRecurIntervalForFltSysRups;
        if (!resultsDir.exists()) {
            resultsDir.mkdir();
        }
        FileWriter info_fr = new FileWriter(new File(resultsDir, "infoString.txt"));
        info_fr.write("resultsDir: " + resultsDir.getPath() + "\n");
        FileWriter eventFileWriter = null;
        try {
            eventFileWriter = new FileWriter(new File(resultsDir, "sampledEventsData.txt"));
            eventFileWriter.write("nthRupIndex\tfssRupIndex\tyear\tepoch\tnormRI\tmag\tnthCatalog\ttimeToNextInYrs\tutilizedPaleoSite\n");
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        ArrayList<U3PaleoRateConstraint> paleoConstraints = UCERF3_PaleoRateConstraintFetcher.getConstraints(this.fltSysRupSet.getFaultSectionDataList());
        ArrayList<Integer> paleoConstrainSections = new ArrayList<Integer>();
        info_fr.write("\n" + paleoConstraints.size() + " Paleo Sites (site, sectID, sectName):\n");
        for (U3PaleoRateConstraint u3PaleoRateConstraint : paleoConstraints) {
            paleoConstrainSections.add(u3PaleoRateConstraint.getSectionIndex());
            info_fr.write("\t" + u3PaleoRateConstraint.getPaleoSiteName() + "\t" + u3PaleoRateConstraint.getSectionIndex() + "\t" + u3PaleoRateConstraint.getFaultSectionName() + "\n");
        }
        RandomDataGenerator randomDataSampler = new RandomDataGenerator();
        if (randomSeed == null) {
            randomSeed = System.currentTimeMillis();
            info_fr.write("\nRandom Seed: " + randomSeed + " (from System.currentTimeMillis() since input null)\n");
        } else {
            randomDataSampler.reSeed(randomSeed.longValue());
            info_fr.write("\nRandom Seed: " + randomSeed + " (input value)\n");
        }
        randomDataSampler.reSeed(randomSeed.longValue());
        info_fr.write("\nERF Adjustable Paramteres:\n\n");
        for (Parameter<?> param : this.erf.getAdjustableParameterList()) {
            info_fr.write("\t" + param.getName() + " = " + String.valueOf(param.getValue()) + "\n");
        }
        TimeSpan timeSpan = this.erf.getTimeSpan();
        if (!timeSpan.getStartTimePrecision().equals("None")) {
            info_fr.write("\nERF StartTime: " + timeSpan.getStartTimeYear() + "\n");
        }
        info_fr.write("\nERF TimeSpan Duration: " + this.erf.getTimeSpan().getDuration() + " years\n");
        info_fr.flush();
        boolean aveRecurIntervals = this.erf.aveRecurIntervalsInU3_BPTcalc;
        boolean aveNormTimeSinceLast = this.erf.aveNormTimeSinceLastInU3_BPTcalc;
        ProbabilityModelOptions probTypeEnum = (ProbabilityModelOptions)((Object)this.erf.getParameter("Probability Model").getValue());
        String plotLabelString = resultsDir.getPath();
        double[] probGainForFaultSystemSource = new double[this.erf.getNumFaultSystemSources()];
        for (int s = 0; s < probGainForFaultSystemSource.length; ++s) {
            probGainForFaultSystemSource[s] = 1.0;
        }
        long origStartTimeMillis = 0L;
        if (probTypeEnum != ProbabilityModelOptions.POISSON) {
            origStartTimeMillis = this.erf.getTimeSpan().getStartTimeInMillis();
        }
        double origStartYear = (double)origStartTimeMillis / 3.15576E10 + 1970.0;
        System.out.println("orig start time: " + origStartTimeMillis + " millis (" + origStartYear + " yrs)");
        double[] obsRupRateArray = new double[this.erf.getTotNumRups()];
        double[] obsSectRateArray = new double[this.numSections];
        double totalTargetRate = 0.0;
        IntegerPDF_FunctionSampler nthRupRandomSampler = new IntegerPDF_FunctionSampler(this.erf.getTotNumRups());
        double[] targetRateOfNthRups = new double[this.erf.getTotNumRups()];
        double[] targetRateOfSection = new double[this.numSections];
        double[] magOfNthRups = new double[this.erf.getTotNumRups()];
        int nthRup = 0;
        double maxRupProb = 0.0;
        for (ProbEqkSource src : this.erf) {
            for (ProbEqkRupture rup : src) {
                double rate;
                if (rup.getProbability() > maxRupProb) {
                    maxRupProb = rup.getProbability();
                }
                targetRateOfNthRups[nthRup] = rate = rup.getMeanAnnualRate(this.erf.getTimeSpan().getDuration());
                magOfNthRups[nthRup] = rup.getMag();
                totalTargetRate += targetRateOfNthRups[nthRup];
                nthRupRandomSampler.set(nthRup, rate);
                if (this.erf.getSrcIndexForNthRup(nthRup) < this.erf.getNumFaultSystemSources()) {
                    int fltSysIndex = this.erf.getFltSysRupIndexForNthRup(nthRup);
                    Iterator<Integer> iterator = this.fltSysRupSet.getSectionsIndicesForRup(fltSysIndex).iterator();
                    while (iterator.hasNext()) {
                        int sectID;
                        int n = sectID = iterator.next().intValue();
                        targetRateOfSection[n] = targetRateOfSection[n] + rate;
                    }
                }
                ++nthRup;
            }
        }
        System.out.println("totalRate long term = " + totalTargetRate + "\nmaxRupProb = " + maxRupProb);
        info_fr.write("\ntotalTargetRate = " + totalTargetRate + "\nmaxRupProb = " + maxRupProb + "\n");
        ArrayList<int[]> sectIndexArrayForSrcList = new ArrayList<int[]>();
        for (int s = 0; s < this.erf.getNumFaultSystemSources(); ++s) {
            List<Integer> indexList = this.fltSysRupSet.getSectionsIndicesForRup(this.erf.getFltSysRupIndexForSource(s));
            int[] indexArray = new int[indexList.size()];
            for (int i = 0; i < indexList.size(); ++i) {
                indexArray[i] = indexList.get(i);
            }
            sectIndexArrayForSrcList.add(indexArray);
        }
        System.out.println("Making target MFD");
        SummedMagFreqDist targetMFD = ERF_Calculator.getTotalMFD_ForERF(this.erf, 5.05, 8.95, 40, true);
        double origTotMoRate = ERF_Calculator.getTotalMomentRateInRegion(this.erf, null);
        System.out.println("originalTotalMomentRate: " + origTotMoRate);
        targetMFD.setName("Target MFD");
        String tempString = "total rate = " + (float)targetMFD.getTotalIncrRate();
        tempString = tempString + "\ntotal rate >= 6.7 = " + (float)targetMFD.getCumRate(6.75);
        tempString = tempString + "\ntotal MoRate = " + (float)origTotMoRate;
        targetMFD.setInfo(tempString);
        SummedMagFreqDist obsMFD = new SummedMagFreqDist(5.05, 8.95, 40);
        double obsMoRate = 0.0;
        if (aveRecurIntervals) {
            if (this.aveCondRecurIntervalForFltSysRups_type1 == null) {
                this.aveCondRecurIntervalForFltSysRups_type1 = this.computeAveCondRecurIntervalForFltSysRups(1);
            }
            aveCondRecurIntervalForFltSysRups = this.aveCondRecurIntervalForFltSysRups_type1;
        } else {
            if (this.aveCondRecurIntervalForFltSysRups_type2 == null) {
                this.aveCondRecurIntervalForFltSysRups_type2 = this.computeAveCondRecurIntervalForFltSysRups(2);
            }
            aveCondRecurIntervalForFltSysRups = this.aveCondRecurIntervalForFltSysRups_type2;
        }
        double minCondRI = Double.MAX_VALUE;
        double maxCondRI = 0.0;
        for (double ri : aveCondRecurIntervalForFltSysRups) {
            if (Double.isInfinite(ri)) continue;
            if (ri < minCondRI) {
                minCondRI = ri;
            }
            if (!(ri > maxCondRI)) continue;
            maxCondRI = ri;
        }
        System.out.println("minCondRI=" + minCondRI);
        System.out.println("maxCondRI=" + maxCondRI);
        int percDoneThresh = 0;
        int percDoneIncrement = 5;
        long startRunTime = System.currentTimeMillis();
        if (inputDateOfLastFileName != null && probTypeEnum != ProbabilityModelOptions.POISSON) {
            this.readSectTimeSinceLastEventFromFile(inputDateOfLastFileName, origStartTimeMillis);
            info_fr.write("\nDate of Last Event from File: " + inputDateOfLastFileName + "\n");
            if (makePlots) {
                this.getSectNormTimeSinceLastHistPlot(origStartTimeMillis, "From File");
            }
        } else {
            info_fr.write("\nDate of Last Event from Fault Data in ER\n");
            if (makePlots) {
                this.getSectNormTimeSinceLastHistPlot(origStartTimeMillis, "From Pref Data");
            }
        }
        try {
            progressBar = new CalcProgressBar(plotLabelString, "Num Catalogs Generated");
            progressBar.showProgress(true);
        }
        catch (Throwable t) {
            progressBar = null;
        }
        long[] origDateOfLastForSect = (long[])this.dateOfLastForSect.clone();
        ArrayList<Double> normalizedRupRecurIntervals = new ArrayList<Double>();
        int nthCatalog = 0;
        info_fr.write("numRupsAtPaleoSites\tnthCatalog\n");
        int numRups = 0;
        for (nthCatalog = 0; nthCatalog < numCatalogs; ++nthCatalog) {
            int percDone;
            if (progressBar != null) {
                progressBar.updateProgress(nthCatalog, numCatalogs);
            }
            if ((percDone = (int)Math.round(100.0 * (double)nthCatalog / (double)numCatalogs)) >= percDoneThresh) {
                double timeInMin = (double)(System.currentTimeMillis() - startRunTime) / 60000.0;
                System.out.println("\n" + percDoneThresh + "% done in " + (float)timeInMin + " minutes;  nthCatalog=" + nthCatalog + " (out of " + numCatalogs + ")\n");
                percDoneThresh += percDoneIncrement;
            }
            double currentYear = origStartYear;
            long currentTimeMillis = origStartTimeMillis;
            this.dateOfLastForSect = (long[])origDateOfLastForSect.clone();
            double simDuration = 1.0 / totalTargetRate;
            numRups = 0;
            int numRupsAtPaleoSites = 0;
            System.out.print("\n");
            while (currentYear <= origStartYear + forecastDurationYrs) {
                System.out.print(", " + Math.round(currentYear));
                if (probTypeEnum != ProbabilityModelOptions.POISSON) {
                    if (probTypeEnum == ProbabilityModelOptions.U3_BPT) {
                        for (int s = 0; s < this.erf.getNumFaultSystemSources(); ++s) {
                            int fltSysRupIndex = this.erf.getFltSysRupIndexForSource(s);
                            probGainForFaultSystemSource[s] = this.getU3_ProbGainForRup(fltSysRupIndex, 0.0, false, aveRecurIntervals, aveNormTimeSinceLast, currentTimeMillis, simDuration);
                        }
                    } else if (probTypeEnum == ProbabilityModelOptions.WG02_BPT) {
                        this.sectionGainArray = null;
                        for (int s = 0; s < this.erf.getNumFaultSystemSources(); ++s) {
                            int fltSysRupIndex = this.erf.getFltSysRupIndexForSource(s);
                            probGainForFaultSystemSource[s] = this.getWG02_ProbGainForRup(fltSysRupIndex, false, currentTimeMillis, simDuration);
                        }
                    }
                    for (int n = 0; n < this.erf.getTotNumRupsFromFaultSystem(); ++n) {
                        double probGain = probGainForFaultSystemSource[this.erf.getSrcIndexForNthRup(n)];
                        double newRate = probGain * this.longTermRateOfFltSysRup[this.erf.getFltSysRupIndexForNthRup(n)];
                        nthRupRandomSampler.set(n, newRate);
                    }
                    totalTargetRate = nthRupRandomSampler.getSumOfY_vals();
                }
                double timeToNextInYrs = randomDataSampler.nextExponential(1.0 / totalTargetRate);
                currentYear += timeToNextInYrs;
                currentTimeMillis += (long)(timeToNextInYrs * 3.15576E10);
                ++numRups;
                if (!(currentYear <= origStartYear + forecastDurationYrs)) continue;
                nthRup = nthRupRandomSampler.getRandomInt();
                int srcIndex = this.erf.getSrcIndexForNthRup(nthRup);
                int n = nthRup;
                obsRupRateArray[n] = obsRupRateArray[n] + 1.0;
                int fltSystRupIndex = -1;
                double normRI = Double.NaN;
                int utilizedPaleoSite = 0;
                if (srcIndex < this.erf.getNumFaultSystemSources()) {
                    fltSystRupIndex = this.erf.getFltSysRupIndexForSource(srcIndex);
                    if (aveNormTimeSinceLast) {
                        normRI = this.getAveNormTimeSinceLastEventWhereKnown(fltSystRupIndex, currentTimeMillis);
                        if (this.allSectionsHadDateOfLast) {
                            normalizedRupRecurIntervals.add(normRI);
                        }
                    } else {
                        long aveDateOfLastMillis = this.getAveDateOfLastEventWhereKnown(fltSystRupIndex, currentTimeMillis);
                        if (this.allSectionsHadDateOfLast) {
                            double timeSinceLast = (double)(currentTimeMillis - aveDateOfLastMillis) / 3.15576E10;
                            normRI = timeSinceLast / aveCondRecurIntervalForFltSysRups[fltSystRupIndex];
                            normalizedRupRecurIntervals.add(normRI);
                        }
                    }
                    for (int sect : (int[])sectIndexArrayForSrcList.get(srcIndex)) {
                        this.dateOfLastForSect[sect] = currentTimeMillis;
                        int n2 = sect;
                        obsSectRateArray[n2] = obsSectRateArray[n2] + 1.0;
                        if (utilizedPaleoSite != 0 || !paleoConstrainSections.contains(sect)) continue;
                        utilizedPaleoSite = 1;
                    }
                    numRupsAtPaleoSites += utilizedPaleoSite;
                }
                double mag = this.erf.getNthRupture(nthRup).getMag();
                try {
                    eventFileWriter.write(nthRup + "\t" + fltSystRupIndex + "\t" + currentYear + "\t" + currentTimeMillis + "\t" + normRI + "\t" + mag + "\t" + nthCatalog + "\t" + timeToNextInYrs + "\t" + utilizedPaleoSite + "\n");
                    eventFileWriter.flush();
                }
                catch (IOException e1) {
                    e1.printStackTrace();
                }
                obsMFD.addResampledMagRate(magOfNthRups[nthRup], 1.0, true);
                obsMoRate += MagUtils.magToMoment(magOfNthRups[nthRup]);
            }
            info_fr.write(numRupsAtPaleoSites + "\t" + nthCatalog + "\n");
            System.out.println("\nnumRupsAtPaleoSites=" + numRupsAtPaleoSites + "\n");
        }
        if (progressBar != null) {
            progressBar.showProgress(false);
        }
        obsMFD.scale(1.0 / (forecastDurationYrs * (double)numCatalogs));
        obsMFD.setName("Simulated MFD");
        obsMoRate /= forecastDurationYrs * (double)numCatalogs;
        double obsTotRate = obsMFD.getTotalIncrRate();
        double rateRatio = obsTotRate / targetMFD.getTotalIncrRate();
        String statsString = "total rate = " + (float)obsTotRate + " (ratio=" + (float)rateRatio + ")";
        double obsTotRateAbove6pt7 = obsMFD.getCumRate(6.75);
        double rateAbove6pt7_Ratio = obsTotRateAbove6pt7 / targetMFD.getCumRate(6.75);
        statsString = statsString + "\ntotal rate >= 6.7 = " + (float)obsTotRateAbove6pt7 + " (ratio=" + (float)rateAbove6pt7_Ratio + ")";
        double moRateRatio = obsMoRate / origTotMoRate;
        statsString = statsString + "\ntotal MoRate = " + (float)obsMoRate + " (ratio=" + (float)moRateRatio + ")";
        obsMFD.setInfo(statsString);
        info_fr.write("\nSimulation Stats:\n" + statsString + "\n\n");
        try {
            eventFileWriter.close();
            info_fr.close();
        }
        catch (IOException e2) {
            e2.printStackTrace();
        }
        if (makePlots) {
            double aper = Double.NaN;
            if (this.numAperValues == 1) {
                aper = this.aperValues[0];
            }
            ArrayList<EvenlyDiscretizedFunc> funcList = ProbModelsPlottingUtils.getNormRI_DistributionWithFits(normalizedRupRecurIntervals, aper);
            GraphWindow normRI_graph = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcList, "Normalized Rupture RIs; " + plotLabelString);
            ArrayList<EvenlyDiscretizedFunc> funcs = new ArrayList<EvenlyDiscretizedFunc>();
            funcs.add(targetMFD);
            funcs.add(obsMFD);
            funcs.add(targetMFD.getCumRateDistWithOffset());
            funcs.add(obsMFD.getCumRateDistWithOffset());
            GraphWindow mfd_graph = new GraphWindow(funcs, "Mag-Freq Dists; " + plotLabelString);
            mfd_graph.setX_AxisLabel("Mag");
            mfd_graph.setY_AxisLabel("Rate");
            mfd_graph.setYLog(true);
            mfd_graph.setY_AxisRange(1.0E-4, 1.0);
            mfd_graph.setX_AxisRange(5.5, 8.5);
            for (int i = 0; i < obsSectRateArray.length; ++i) {
                obsSectRateArray[i] = obsSectRateArray[i] / (forecastDurationYrs * (double)numCatalogs);
            }
            DefaultXY_DataSet obsVsImposedSectRates = new DefaultXY_DataSet(targetRateOfSection, obsSectRateArray);
            obsVsImposedSectRates.setName("Simulated vs Target Section Event Rates");
            double rateTrans = 1.0 / forecastDurationYrs;
            obsVsImposedSectRates.setInfo("Simulated rates should be above target for rates above ~" + (float)rateTrans + " due to second events in simulation");
            DefaultXY_DataSet perfectAgreementFunc = new DefaultXY_DataSet();
            perfectAgreementFunc.set(1.0E-5, 1.0E-5);
            perfectAgreementFunc.set(0.05, 0.05);
            perfectAgreementFunc.setName("Perfect agreement line");
            ArrayList<DefaultXY_DataSet> funcs2 = new ArrayList<DefaultXY_DataSet>();
            funcs2.add(obsVsImposedSectRates);
            funcs2.add(perfectAgreementFunc);
            ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
            plotChars.add(new PlotCurveCharacterstics(PlotSymbol.CROSS, 4.0f, Color.BLUE));
            plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
            GraphWindow sectRates_graph = new GraphWindow(funcs2, "Obs vs Target Section Rates; ", plotChars);
            sectRates_graph.setYLog(true);
            sectRates_graph.setXLog(true);
            sectRates_graph.setX_AxisLabel("Target Participation Rate (per yr)");
            sectRates_graph.setY_AxisLabel("Simulated Participation Rate (per yr)");
            try {
                FileWriter eventRates_fr = new FileWriter(new File(resultsDir, "obsVsTargetSectionPartRates.txt"));
                eventRates_fr.write("sectID\tlongTermRate\ttargetRate\tsimulatedRate\tsimOverTargetRateRatio\taveSectGain\thasDateOfLast\tnormTimeSince\tsectName\n");
                for (int i = 0; i < this.fltSysRupSet.getNumSections(); ++i) {
                    FaultSection fltData = this.fltSysRupSet.getFaultSectionData(i);
                    double ratio = obsSectRateArray[i] / targetRateOfSection[i];
                    boolean hasDateOfLast = false;
                    if (fltData.getDateOfLastEvent() != Long.MIN_VALUE) {
                        hasDateOfLast = true;
                    }
                    double normTimeSince = hasDateOfLast ? (double)(origStartTimeMillis - origDateOfLastForSect[i]) / 3.15576E10 * this.longTermPartRateForSectArray[i] : Double.NaN;
                    eventRates_fr.write(fltData.getSectionId() + "\t" + this.longTermPartRateForSectArray[i] + "\t" + targetRateOfSection[i] + "\t" + obsSectRateArray[i] + "\t" + ratio + "\t" + targetRateOfSection[i] / this.longTermPartRateForSectArray[i] + "\t" + hasDateOfLast + "\t" + normTimeSince + "\t" + fltData.getName() + "\n");
                }
                eventRates_fr.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
            String dirNameForSavingFiles = resultsDir.getPath();
            try {
                normRI_graph.saveAsPDF(dirNameForSavingFiles + "/normalizedRupRecurIntervals.pdf");
                normRI_graph.saveAsTXT(dirNameForSavingFiles + "/normalizedRupRecurIntervalsPlot.txt");
                mfd_graph.saveAsPDF(dirNameForSavingFiles + "/magFreqDists.pdf");
                sectRates_graph.saveAsPDF(dirNameForSavingFiles + "/obsVsTargetSectionPartRates.pdf");
                AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)targetMFD, dirNameForSavingFiles + "/targetMFD.txt");
                AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)obsMFD, dirNameForSavingFiles + "/simulatedMFD.txt");
                AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)targetMFD.getCumRateDistWithOffset(), dirNameForSavingFiles + "/targetCumMFD.txt");
                AbstractDiscretizedFunc.writeSimpleFuncFile((DiscretizedFunc)obsMFD.getCumRateDistWithOffset(), dirNameForSavingFiles + "/simulatedCumMFD.txt");
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }

    private void writeSectTimeSinceLastEventToFile(String fileName, long currentTimeMillis) {
        if (!dataDir.exists()) {
            dataDir.mkdir();
        }
        File dataFile = new File(dataDir, File.separator + fileName);
        try {
            FileWriter fileWriter = new FileWriter(dataFile);
            int numBad = 0;
            for (int i = 0; i < this.dateOfLastForSect.length; ++i) {
                if (this.dateOfLastForSect[i] != Long.MIN_VALUE) {
                    long timeSince = currentTimeMillis - this.dateOfLastForSect[i];
                    if (timeSince < 0L) {
                        if ((double)timeSince > -3.15576E10) {
                            System.out.println("Converting slightly negative time since last (" + timeSince + ") to zero");
                            timeSince = 0L;
                        } else {
                            throw new RuntimeException("bad time since last");
                        }
                    }
                    fileWriter.write(i + "\t" + timeSince + "\n");
                    continue;
                }
                fileWriter.write(i + "\t-9223372036854775808\n");
                ++numBad;
            }
            fileWriter.close();
            int percBad = (int)Math.round(100.0 * (double)numBad / (double)this.dateOfLastForSect.length);
            System.out.println(numBad + " sections out of " + this.dateOfLastForSect.length + " had no date of last event in output file (" + percBad + "%)");
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    private GraphWindow getSectNormTimeSinceLastHistPlot(long currentTimeMillis, String labelPrefix) {
        ArrayList<Double> normRI_List = new ArrayList<Double>();
        for (int s = 0; s < this.dateOfLastForSect.length; ++s) {
            long epochOfLast = this.dateOfLastForSect[s];
            if (epochOfLast == Long.MIN_VALUE) continue;
            double yearsSinceLast = (double)(currentTimeMillis - epochOfLast) / 3.15576E10;
            double normTimeSinceLast = this.longTermPartRateForSectArray[s] * yearsSinceLast;
            normRI_List.add(normTimeSinceLast);
        }
        HistogramFunction dist = ProbModelsPlottingUtils.getNormRI_Distribution(normRI_List, 0.1);
        dist.setName(labelPrefix + " NormSectTimeSinceLast");
        dist.setInfo(normRI_List.size() + " of " + this.dateOfLastForSect.length + " sections had date of last");
        GraphWindow graph = new GraphWindow(dist, labelPrefix + " NormSectTimeSinceLast");
        return graph;
    }

    public double[] getNormTimeSinceLastForSections(long currentTimeMillis) {
        double[] normTimeSince = new double[this.numSections];
        for (int s = 0; s < this.numSections; ++s) {
            long epochOfLast = this.dateOfLastForSect[s];
            if (epochOfLast != Long.MIN_VALUE && epochOfLast <= currentTimeMillis) {
                double yearsSinceLast = (double)(currentTimeMillis - epochOfLast) / 3.15576E10;
                normTimeSince[s] = this.longTermPartRateForSectArray[s] * yearsSinceLast;
                continue;
            }
            normTimeSince[s] = Double.NaN;
        }
        return normTimeSince;
    }

    private void readSectTimeSinceLastEventFromFile(String fileName, long currentTimeMillis) {
        try {
            String line;
            File dataFile = new File(fileName);
            System.out.println("Reading file " + fileName + "; currentTimeMillis+" + currentTimeMillis);
            BufferedReader reader = new BufferedReader(UCERF3_DataUtils.getReader(dataFile.toURL()));
            int s = 0;
            int numBad = 0;
            while ((line = reader.readLine()) != null) {
                String[] st = StringUtils.split((String)line, (String)"\t");
                int sectIndex = Integer.valueOf(st[0]);
                long timeSince = Long.valueOf(st[1]);
                if (timeSince != Long.MIN_VALUE) {
                    this.dateOfLastForSect[s] = currentTimeMillis - timeSince;
                } else {
                    this.dateOfLastForSect[s] = Long.MIN_VALUE;
                    ++numBad;
                }
                if (s != sectIndex) {
                    throw new RuntimeException("bad index");
                }
                ++s;
            }
            int percBad = (int)Math.round(100.0 * (double)numBad / (double)this.dateOfLastForSect.length);
            System.out.println(numBad + " sections out of " + this.dateOfLastForSect.length + " had no date of last event in input file (" + percBad + "%)");
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    public void writeRupProbGainsForDiffAveragingMethods(long presentTimeMillis, double durationYears, String fileName) {
        this.writeRupProbGainsForDiffAveragingMethods(presentTimeMillis, durationYears, fileName, -1);
    }

    public void writeRupProbGainsForDiffAveragingMethods(long presentTimeMillis, double durationYears, String fileName, int subSectIndex) {
        boolean[] aveRI_array = new boolean[]{true, false};
        boolean[] aveNormTS_array = new boolean[]{true, false};
        File dataFile = new File(fileName);
        String sectName = this.fltSysRupSet.getFaultSectionData(subSectIndex).getName();
        System.out.println("Working on ruptures for section " + subSectIndex + "; " + sectName);
        List<Integer> rupIndexList = null;
        if (subSectIndex != -1) {
            rupIndexList = this.fltSysRupSet.getRupturesForSection(subSectIndex);
        }
        try {
            FileWriter fileWriter = new FileWriter(dataFile);
            fileWriter.write("rupIndex\tRI_NTS\tRI_TS\tRateNTS\tRateTS\tcondRI_RI\tcondRI_Rate\tlongTermRate\tmaxOverMin\tMaxMinusMin\tsigDiff\trupMag\trupAper\trupName\n");
            for (int fltSystRupIndex = 0; fltSystRupIndex < this.numRupsInFaultSystem; ++fltSystRupIndex) {
                if (!(this.longTermRateOfFltSysRup[fltSystRupIndex] > 0.0)) continue;
                Object line = Integer.toString(fltSystRupIndex);
                double min = Double.MAX_VALUE;
                double max = -1.0;
                for (boolean aveRI : aveRI_array) {
                    for (boolean aveNormTS : aveNormTS_array) {
                        double gain = this.getU3_ProbGainForRup(fltSystRupIndex, 0.0, false, aveRI, aveNormTS, presentTimeMillis, durationYears);
                        line = (String)line + "\t" + gain;
                        if (min > gain) {
                            min = gain;
                        }
                        if (!(max < gain)) continue;
                        max = gain;
                    }
                }
                List<FaultSection> data = this.fltSysRupSet.getFaultSectionDataForRupture(fltSystRupIndex);
                String name = data.size() + " SECTIONS BETWEEN " + data.get(0).getName() + " AND " + data.get(data.size() - 1).getName();
                boolean sigDiff = max / min > 1.1 && max - min > 0.1;
                double rupMag = this.fltSysRupSet.getMagForRup(fltSystRupIndex);
                line = (String)line + "\t" + this.aveCondRecurIntervalForFltSysRups_type1[fltSystRupIndex] + "\t" + this.aveCondRecurIntervalForFltSysRups_type2[fltSystRupIndex] + "\t" + this.longTermRateOfFltSysRup[fltSystRupIndex] + "\t" + max / min + "\t" + (max - min) + "\t" + sigDiff + "\t" + rupMag + "\t" + this.aperValues[this.getAperIndexForRupMag(rupMag)] + "\t" + name;
                if (subSectIndex == -1) {
                    fileWriter.write((String)line + "\n");
                    continue;
                }
                if (!rupIndexList.contains(fltSystRupIndex)) continue;
                fileWriter.write((String)line + "\n");
            }
            fileWriter.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        System.out.println("Done with writeRupProbGainsForDiffAveragingMethods for " + fileName);
    }

    public String getInfoAboutRupture(int fltSystRupIndex, long presentTimeMillis) {
        String info = "fltSystRupIndex=" + fltSystRupIndex + "\n";
        info = info + "mag=" + this.fltSysRupSet.getMagForRup(fltSystRupIndex) + "\n";
        info = info + "Index\tRI\tRate\tTimeSince\tNormTimeSince\tArea\tName\n";
        List<Integer> sectIndicesList = this.fltSysRupSet.getSectionsIndicesForRup(fltSystRupIndex);
        for (int sectIndex : sectIndicesList) {
            FaultSection fltData = this.fltSysRupSet.getFaultSectionData(sectIndex);
            long dateOfLastMillis = fltData.getDateOfLastEvent();
            double yrsSinceLast = Double.NaN;
            if (dateOfLastMillis != Long.MIN_VALUE) {
                yrsSinceLast = (double)(presentTimeMillis - dateOfLastMillis) / 3.15576E10;
            }
            info = info + sectIndex + "\t" + 1.0 / this.longTermPartRateForSectArray[sectIndex] + "\t" + this.longTermPartRateForSectArray[sectIndex] + "\t" + yrsSinceLast + "\t" + yrsSinceLast * this.longTermPartRateForSectArray[sectIndex] + "\t" + this.sectionArea[sectIndex] + "\t" + fltData.getName() + "\n";
        }
        return info;
    }

    public String getInfoAboutRupsOnSection(int sectID, String fileName) {
        Object info = new String();
        List<Integer> rupIDsList = this.fltSysRupSet.getRupturesForSection(sectID);
        for (int rupID : rupIDsList) {
            info = (String)info + rupID + "\t" + this.longTermRateOfFltSysRup[rupID] + "\t" + this.fltSysRupSet.getMagForRup(rupID) + "\n";
        }
        try {
            FileWriter fileWriter = new FileWriter(fileName);
            fileWriter.write((String)info);
            fileWriter.close();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return info;
    }

    public static void simpleModelTest(int numSimulatedRups) {
        double aper = 0.2;
        int[] sampledRupArray = new int[numSimulatedRups];
        double[] yearOfSampledRupArray = new double[numSimulatedRups];
        double rup1_RI = 50.0;
        double rup2_RI = 200.0;
        double[] longTermRupRateArray = new double[]{1.0 / rup1_RI, 1.0 / rup2_RI};
        double[] longTermSectRateArray = new double[]{1.0 / rup1_RI + 1.0 / rup2_RI, 1.0 / rup2_RI};
        double[] sectYearOfLastArray = new double[]{-1.0 / longTermSectRateArray[0], -1.0 / longTermSectRateArray[1]};
        double[] condRI_Array = new double[]{1.0 / longTermSectRateArray[0], (1.0 / longTermSectRateArray[0] + 1.0 / longTermSectRateArray[1]) / 2.0};
        System.out.println("longTermRupRateArray: " + longTermRupRateArray[0] + ", " + longTermRupRateArray[1]);
        System.out.println("longTermSectRateArray: " + longTermSectRateArray[0] + ", " + longTermSectRateArray[1]);
        System.out.println("condRI_Array: " + condRI_Array[0] + ", " + condRI_Array[1]);
        double[] aveNormTimeSinceArray = new double[2];
        double[] condProbArray = new double[2];
        double[] tdRupRateArray = new double[2];
        double year = 0.0;
        int nthRup = 0;
        int num0thRups = 0;
        CalcProgressBar progressBar = new CalcProgressBar("simpleModelTest", "Num Rups Done");
        progressBar.showProgress(true);
        BPT_DistCalc bptRefCalc = ProbabilityModelsCalc.getRef_BPT_DistCalc(aper);
        double stepDurationYears = 1.0;
        IntegerPDF_FunctionSampler nthRupRandomSampler = new IntegerPDF_FunctionSampler(2);
        RandomDataGenerator randomDataSampler = new RandomDataGenerator();
        ArrayList<Double> normalizedRupRecurIntervals = new ArrayList<Double>();
        ArrayList<Double> normalizedSectRecurIntervals = new ArrayList<Double>();
        while (nthRup < numSimulatedRups) {
            progressBar.updateProgress(nthRup, numSimulatedRups);
            aveNormTimeSinceArray[0] = (year - sectYearOfLastArray[0]) * longTermSectRateArray[0];
            aveNormTimeSinceArray[1] = ((year - sectYearOfLastArray[0]) * longTermSectRateArray[0] + (year - sectYearOfLastArray[1]) * longTermSectRateArray[1]) / 2.0;
            condProbArray[0] = bptRefCalc.getCondProb(aveNormTimeSinceArray[0], stepDurationYears * refRI / condRI_Array[0]);
            condProbArray[1] = bptRefCalc.getCondProb(aveNormTimeSinceArray[1], stepDurationYears * refRI / condRI_Array[1]);
            tdRupRateArray[0] = condProbArray[0] / (stepDurationYears / condRI_Array[0]) * (1.0 / rup1_RI);
            tdRupRateArray[1] = condProbArray[1] / (stepDurationYears / condRI_Array[1]) * (1.0 / rup2_RI);
            if (year < 10000.0) {
                System.out.println(condProbArray[0] / (stepDurationYears / condRI_Array[0]) + "\t" + condProbArray[1] / (stepDurationYears / condRI_Array[1]));
            }
            nthRupRandomSampler.set(0, tdRupRateArray[0]);
            nthRupRandomSampler.set(1, tdRupRateArray[1]);
            double totRate = tdRupRateArray[0] + tdRupRateArray[1];
            double timeToNextInYrs = randomDataSampler.nextExponential(1.0 / totRate);
            if (timeToNextInYrs < stepDurationYears) {
                int r;
                sampledRupArray[nthRup] = r = nthRupRandomSampler.getRandomInt();
                yearOfSampledRupArray[nthRup] = year + timeToNextInYrs;
                if (r == 0) {
                    normalizedRupRecurIntervals.add(aveNormTimeSinceArray[0]);
                    normalizedSectRecurIntervals.add((year - sectYearOfLastArray[0]) * longTermSectRateArray[0]);
                    sectYearOfLastArray[0] = year + timeToNextInYrs;
                    ++num0thRups;
                } else {
                    normalizedRupRecurIntervals.add(aveNormTimeSinceArray[1]);
                    normalizedSectRecurIntervals.add((year - sectYearOfLastArray[0]) * longTermSectRateArray[0]);
                    normalizedSectRecurIntervals.add((year - sectYearOfLastArray[1]) * longTermSectRateArray[1]);
                    sectYearOfLastArray[0] = year + timeToNextInYrs;
                    sectYearOfLastArray[1] = year + timeToNextInYrs;
                }
                year += timeToNextInYrs;
                ++nthRup;
                continue;
            }
            year += stepDurationYears;
        }
        double simRate = (double)numSimulatedRups / year;
        double expectedRate = longTermRupRateArray[0] + longTermRupRateArray[1];
        System.out.println("simulated rate = " + simRate + "\t(" + simRate / expectedRate + ")");
        System.out.println("expected rate = " + expectedRate);
        System.out.println("simulated rate 0th rup = " + (double)num0thRups / year + "\t(" + (double)num0thRups / year / longTermRupRateArray[0] + ")");
        System.out.println("expected rate 0th rup = " + longTermRupRateArray[0]);
        System.out.println("simulated rate 1st rup = " + (double)(numSimulatedRups - num0thRups) / year + "\t(" + (double)(numSimulatedRups - num0thRups) / year / longTermRupRateArray[1] + ")");
        System.out.println("expected rate 1st rup = " + longTermRupRateArray[1]);
        ArrayList<EvenlyDiscretizedFunc> funcList = ProbModelsPlottingUtils.getNormRI_DistributionWithFits(normalizedRupRecurIntervals, aper);
        GraphWindow grapha_a = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcList, "Normalized Rupture RIs; simple problem");
        Object infoString = "";
        infoString = (String)infoString + "\nRup " + funcList.get(0).getName() + ":";
        infoString = (String)infoString + "\n" + funcList.get(0).getInfo();
        ArrayList<EvenlyDiscretizedFunc> funcListSect = ProbModelsPlottingUtils.getNormRI_DistributionWithFits(normalizedSectRecurIntervals, aper);
        GraphWindow grapha_b = ProbModelsPlottingUtils.plotNormRI_DistributionWithFits(funcListSect, "Normalized Section RIs; simple problem");
        infoString = (String)infoString + "\n\nSect " + funcListSect.get(0).getName() + ":";
        infoString = (String)infoString + "\n" + funcListSect.get(0).getInfo();
        System.out.println("infoString: \n" + (String)infoString);
        progressBar.dispose();
    }

    public void plotRatioHistOfRupCondProbs() {
        this.aveCondRecurIntervalForFltSysRups_type1 = this.computeAveCondRecurIntervalForFltSysRups(1);
        this.aveCondRecurIntervalForFltSysRups_type2 = this.computeAveCondRecurIntervalForFltSysRups(2);
        HistogramFunction hist = new HistogramFunction(0.0, 20, 0.1);
        for (int r = 0; r < this.aveCondRecurIntervalForFltSysRups_type1.length; ++r) {
            double ratio = this.aveCondRecurIntervalForFltSysRups_type2[r] / this.aveCondRecurIntervalForFltSysRups_type1[r];
            if (ratio < hist.getMaxX() + hist.getDelta() / 2.0) {
                hist.add(ratio, this.longTermRateOfFltSysRup[r]);
                continue;
            }
            System.out.println(ratio);
        }
        hist.setInfo("mean=" + (float)hist.computeMean());
        GraphWindow graphMagHist = new GraphWindow(hist, "Ratio of aveRate to aveRI Cond RI values");
    }

    public void setFltSystemRupOccurranceTime(int fltSysRupIndex, Long epoch) {
        for (int sectIndex : this.fltSysRupSet.getSectionsIndicesForRup(fltSysRupIndex)) {
            this.dateOfLastForSect[sectIndex] = epoch;
        }
    }

    public void setFltSectRupOccurranceTime(int sectIndex, Long epoch) {
        this.dateOfLastForSect[sectIndex] = epoch;
    }

    public static void main(String[] args) {
        String fileName = "/Users/field/Library/CloudStorage/OneDrive-DOI/Field_Other/CEA_WGCEP/UCERF3/UCERF3-TI/Figures/Fig11_FaultClusterFig/2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_FM3_1_MEAN_BRANCH_AVG_SOL.zip";
        String timeSinceLastFileName = "/Users/field/FilesFromOldComputerTransfer/workspace/OpenSHA/dev/scratch/UCERF3/data/scratch/erSimulations/timeSinceLastForSimulation.txt";
        FaultSystemSolutionERF erf = new FaultSystemSolutionERF(fileName);
        erf.getParameter("Background Seismicity").setValue(IncludeBackgroundOption.EXCLUDE);
        erf.getParameter("Probability Model").setValue(ProbabilityModelOptions.U3_BPT);
        erf.getParameter("Aperiodicity").setValue(MagDependentAperiodicityOptions.MID_VALUES);
        BPTAveragingTypeOptions aveType = BPTAveragingTypeOptions.AVE_RI_AVE_NORM_TIME_SINCE;
        erf.setParameter("BPT Averaging Type", (Object)aveType);
        erf.updateForecast();
        ProbabilityModelsCalc testCalc = new ProbabilityModelsCalc(erf);
        testCalc.testER_Simulation(timeSinceLastFileName, null, erf, 20000.0, "TestRun_120915");
    }
}

