/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.griddedSeismicity;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.data.function.AbstractDiscretizedFunc;
import org.opensha.commons.data.function.DiscretizedFunc;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.data.function.LightFixedXFunc;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.geo.GriddedRegion;
import org.opensha.commons.metadata.XMLSaveable;
import org.opensha.commons.util.XMLUtils;
import org.opensha.sha.earthquake.faultSysSolution.modules.MFDGridSourceProvider;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import org.opensha.sha.util.TectonicRegionType;
import scratch.UCERF3.U3FaultSystemSolution;
import scratch.UCERF3.griddedSeismicity.AbstractGridSourceProvider;
import scratch.UCERF3.griddedSeismicity.GridReader;
import scratch.UCERF3.utils.MatrixIO;
import scratch.UCERF3.utils.U3FaultSystemIO;

@Deprecated
public class GridSourceFileReader
extends AbstractGridSourceProvider
implements XMLSaveable {
    private static final String NODE_MFD_LIST_EL_NAME = "MFDNodeList";
    private static final String NODE_MFD_ITEM_EL_NAME = "MFDNode";
    private static final String SUB_SIZE_MFD_EL_NAME = "SubSeisMFD";
    private static final String UNASSOCIATED_MFD_EL_NAME = "UnassociatedFD";
    private GriddedRegion region;
    private Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs;
    private Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs;
    private double[] fracStrikeSlip;
    private double[] fracNormal;
    private double[] fracReverse;

    public GridSourceFileReader(GriddedRegion region, Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs, Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs) {
        this.initFocalMechGrids();
        this.region = region;
        this.nodeSubSeisMFDs = nodeSubSeisMFDs;
        this.nodeUnassociatedMFDs = nodeUnassociatedMFDs;
    }

    @Override
    public IncrementalMagFreqDist getMFD_Unassociated(int idx) {
        return this.nodeUnassociatedMFDs.get(idx);
    }

    @Override
    public IncrementalMagFreqDist getMFD_SubSeisOnFault(int idx) {
        return this.nodeSubSeisMFDs.get(idx);
    }

    @Override
    public GriddedRegion getGriddedRegion() {
        return this.region;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        this.region.toXMLMetadata(root);
        Element nodeListEl = root.addElement(NODE_MFD_LIST_EL_NAME);
        nodeListEl.addAttribute("num", "" + this.region.getNumLocations());
        for (int i = 0; i < this.region.getNumLocations(); ++i) {
            Element nodeEl = nodeListEl.addElement(NODE_MFD_ITEM_EL_NAME);
            nodeEl.addAttribute("index", "" + i);
            IncrementalMagFreqDist subSeisMFD = this.nodeSubSeisMFDs.get(i);
            IncrementalMagFreqDist unassociatedMFD = this.nodeUnassociatedMFDs.get(i);
            if (subSeisMFD != null) {
                subSeisMFD.toXMLMetadata(nodeEl, SUB_SIZE_MFD_EL_NAME);
            }
            if (unassociatedMFD == null) continue;
            unassociatedMFD.toXMLMetadata(nodeEl, UNASSOCIATED_MFD_EL_NAME);
        }
        return root;
    }

    public void writeGriddedSeisFile(File file) throws IOException {
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        this.toXMLMetadata(root);
        XMLUtils.writeDocumentToFile(file, doc);
    }

    private static double[] funcToArray(boolean x, DiscretizedFunc func, double minX) {
        int firstIndex = 0;
        for (int i = 0; i < func.size(); ++i) {
            if (!(func.getX(i) >= minX)) continue;
            firstIndex = i;
            break;
        }
        int numAbove = func.size() - firstIndex;
        double[] ret = new double[numAbove];
        for (int i = 0; i < numAbove; ++i) {
            ret[i] = x ? func.getX(firstIndex + i) : func.getY(firstIndex + i);
        }
        return ret;
    }

    public static void writeGriddedSeisBinFile(File binFile, File regXMLFile, MFDGridSourceProvider gridProv, double minMag) throws IOException {
        IncrementalMagFreqDist refFunc = null;
        for (int i = 0; i < gridProv.getNumLocations(); ++i) {
            if (gridProv.getMFD_Unassociated(i) != null) {
                refFunc = gridProv.getMFD_Unassociated(i);
                break;
            }
            if (gridProv.getMFD_SubSeisOnFault(i) == null) continue;
            refFunc = gridProv.getMFD_SubSeisOnFault(i);
            break;
        }
        Preconditions.checkNotNull(refFunc, (Object)"All funcs are null!");
        ArrayList arrays = Lists.newArrayList();
        arrays.add(GridSourceFileReader.funcToArray(true, refFunc, minMag));
        for (int i = 0; i < gridProv.getNumLocations(); ++i) {
            IncrementalMagFreqDist unMFD = gridProv.getMFD_Unassociated(i);
            if (unMFD != null && unMFD.getMaxY() > 0.0) {
                Preconditions.checkState((unMFD.getMinX() == refFunc.getMinX() && unMFD.getMaxX() == refFunc.getMaxX() ? 1 : 0) != 0);
                arrays.add(GridSourceFileReader.funcToArray(false, unMFD, minMag));
            } else {
                arrays.add(new double[0]);
            }
            IncrementalMagFreqDist subSeisMFD = gridProv.getMFD_SubSeisOnFault(i);
            if (subSeisMFD != null && subSeisMFD.getMaxY() > 0.0) {
                Preconditions.checkState((subSeisMFD.getMinX() == refFunc.getMinX() && subSeisMFD.getMaxX() == refFunc.getMaxX() ? 1 : 0) != 0);
                arrays.add(GridSourceFileReader.funcToArray(false, subSeisMFD, minMag));
                continue;
            }
            arrays.add(new double[0]);
        }
        MatrixIO.doubleArraysListToFile(arrays, binFile);
        if (regXMLFile == null) {
            return;
        }
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        gridProv.getGriddedRegion().toXMLMetadata(root);
        XMLUtils.writeDocumentToFile(regXMLFile, doc);
    }

    public static GridSourceFileReader fromBinFile(File binFile, File regXMLFile) throws IOException, DocumentException {
        return GridSourceFileReader.fromBinStreams(new BufferedInputStream(new FileInputStream(binFile)), new BufferedInputStream(new FileInputStream(regXMLFile)));
    }

    private static GriddedRegion loadU3RegionJSON() {
        System.out.println("Avoided GriddedRegion XML deserialization issue due to new location, loading GeoJSON instead");
        return new CaliforniaRegions.RELM_TESTING_GRIDDED();
    }

    public static GridSourceFileReader fromBinStreams(InputStream binFileStream, InputStream regXMLFileStream) throws IOException, DocumentException {
        Document doc = XMLUtils.loadDocument(regXMLFileStream);
        Element regionEl = doc.getRootElement().element("evenlyGriddedGeographicRegion");
        List<double[]> arrays = MatrixIO.doubleArraysListFromInputStream(binFileStream);
        int calcNumNodes = (arrays.size() - 1) / 2;
        GriddedRegion region = GriddedRegion.fromXMLMetadata(regionEl);
        if (region.getNodeCount() == 7637 && calcNumNodes == 7636) {
            region = GridSourceFileReader.loadU3RegionJSON();
        }
        Preconditions.checkState((calcNumNodes == region.getNodeCount() ? 1 : 0) != 0);
        int cnt = 0;
        double[] xVals = arrays.get(cnt++);
        HashMap nodeSubSeisMFDs = Maps.newHashMap();
        HashMap nodeUnassociatedMFDs = Maps.newHashMap();
        for (int i = 0; i < region.getNodeCount(); ++i) {
            double[] unY = arrays.get(cnt++);
            double[] subY = arrays.get(cnt++);
            if (unY.length > 0) {
                nodeUnassociatedMFDs.put(i, U3FaultSystemIO.asIncr(new LightFixedXFunc(xVals, unY)));
            }
            if (subY.length <= 0) continue;
            nodeSubSeisMFDs.put(i, U3FaultSystemIO.asIncr(new LightFixedXFunc(xVals, subY)));
        }
        Preconditions.checkState((cnt == arrays.size() ? 1 : 0) != 0);
        return new GridSourceFileReader(region, nodeSubSeisMFDs, nodeUnassociatedMFDs);
    }

    public static void writeGriddedSeisFile(File file, MFDGridSourceProvider gridProv) throws IOException {
        GridSourceFileReader fileBased;
        if (gridProv instanceof GridSourceFileReader) {
            fileBased = (GridSourceFileReader)gridProv;
        } else {
            GriddedRegion region = gridProv.getGriddedRegion();
            HashMap nodeSubSeisMFDs = Maps.newHashMap();
            HashMap nodeUnassociatedMFDs = Maps.newHashMap();
            for (int i = 0; i < region.getNumLocations(); ++i) {
                nodeSubSeisMFDs.put(i, gridProv.getMFD_SubSeisOnFault(i));
                nodeUnassociatedMFDs.put(i, gridProv.getMFD_Unassociated(i));
            }
            fileBased = new GridSourceFileReader(region, nodeSubSeisMFDs, nodeUnassociatedMFDs);
        }
        fileBased.writeGriddedSeisFile(file);
    }

    public static GridSourceFileReader fromFile(File file) throws IOException, DocumentException {
        Document doc = XMLUtils.loadDocument(file);
        return GridSourceFileReader.fromXMLMetadata(doc.getRootElement());
    }

    public static GridSourceFileReader fromInputStream(InputStream is) throws DocumentException {
        Document doc = XMLUtils.loadDocument(is);
        return GridSourceFileReader.fromXMLMetadata(doc.getRootElement());
    }

    public static GridSourceFileReader fromXMLMetadata(Element root) {
        Element regionEl = root.element("evenlyGriddedGeographicRegion");
        GriddedRegion region = GriddedRegion.fromXMLMetadata(regionEl);
        HashMap nodeSubSeisMFDs = Maps.newHashMap();
        HashMap nodeUnassociatedMFDs = Maps.newHashMap();
        Element nodeListEl = root.element(NODE_MFD_LIST_EL_NAME);
        int numNodes = Integer.parseInt(nodeListEl.attributeValue("num"));
        if (region.getNodeCount() == 7637 && (numNodes == 7636 || region.getName().startsWith("RELM"))) {
            region = GridSourceFileReader.loadU3RegionJSON();
        }
        Iterator nodeElIt = nodeListEl.elementIterator(NODE_MFD_ITEM_EL_NAME);
        while (nodeElIt.hasNext()) {
            Element nodeEl = (Element)nodeElIt.next();
            int index = Integer.parseInt(nodeEl.attributeValue("index"));
            nodeSubSeisMFDs.put(index, GridSourceFileReader.loadMFD(nodeEl.element(SUB_SIZE_MFD_EL_NAME)));
            nodeUnassociatedMFDs.put(index, GridSourceFileReader.loadMFD(nodeEl.element(UNASSOCIATED_MFD_EL_NAME)));
        }
        Preconditions.checkState((nodeSubSeisMFDs.size() == numNodes ? 1 : 0) != 0, (Object)"Num MFDs inconsistant with number listed in XML file");
        return new GridSourceFileReader(region, nodeSubSeisMFDs, nodeUnassociatedMFDs);
    }

    private static IncrementalMagFreqDist loadMFD(Element funcEl) {
        if (funcEl == null) {
            return null;
        }
        EvenlyDiscretizedFunc func = (EvenlyDiscretizedFunc)AbstractDiscretizedFunc.fromXMLMetadata(funcEl);
        return U3FaultSystemIO.asIncr(func);
    }

    public static void main(String[] args) throws IOException, DocumentException {
        File dataDir = new File("/home/kevin/OpenSHA/UCERF3/fss_csvs");
        File solFile = new File(dataDir, "2013_05_10-ucerf3p3-production-10runs_COMPOUND_SOL_TRUE_HAZARD_MEAN_SOL.zip");
        File outputFile = new File(dataDir, solFile.getName().replaceAll(".zip", "") + "_grid_sources.xml");
        U3FaultSystemSolution fss = U3FaultSystemIO.loadSol(solFile);
        GridSourceFileReader.writeGriddedSeisFile(outputFile, fss.requireModule(MFDGridSourceProvider.class));
    }

    @Override
    public double getFracStrikeSlip(int idx) {
        return this.fracStrikeSlip[idx];
    }

    @Override
    public double getFracReverse(int idx) {
        return this.fracReverse[idx];
    }

    @Override
    public double getFracNormal(int idx) {
        return this.fracNormal[idx];
    }

    private void initFocalMechGrids() {
        GridReader gRead = new GridReader("StrikeSlipWts.txt");
        this.fracStrikeSlip = gRead.getValues();
        gRead = new GridReader("ReverseWts.txt");
        this.fracReverse = gRead.getValues();
        gRead = new GridReader("NormalWts.txt");
        this.fracNormal = gRead.getValues();
    }

    @Override
    public MFDGridSourceProvider newInstance(Map<Integer, IncrementalMagFreqDist> nodeSubSeisMFDs, Map<Integer, IncrementalMagFreqDist> nodeUnassociatedMFDs, double[] fracStrikeSlip, double[] fracNormal, double[] fracReverse, TectonicRegionType[] trts) {
        return new AbstractGridSourceProvider.Precomputed(this.getGriddedRegion(), nodeSubSeisMFDs, nodeUnassociatedMFDs, fracStrikeSlip, fracNormal, fracReverse, trts);
    }
}

