/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.FileWriter;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import java.util.concurrent.Callable;
import org.apache.commons.math3.geometry.euclidean.threed.Vector3D;
import org.opensha.commons.eq.MagUtils;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.util.FaultUtils;
import org.opensha.commons.util.IDPairing;
import org.opensha.commons.util.modules.OpenSHA_Module;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.earthquake.faultSysSolution.FaultSystemRupSet;
import org.opensha.sha.earthquake.faultSysSolution.modules.AveSlipModule;
import org.opensha.sha.earthquake.faultSysSolution.modules.ClusterRuptures;
import org.opensha.sha.earthquake.faultSysSolution.modules.InversionTargetMFDs;
import org.opensha.sha.earthquake.faultSysSolution.modules.ModSectMinMags;
import org.opensha.sha.earthquake.faultSysSolution.modules.PolygonFaultGridAssociations;
import org.opensha.sha.earthquake.faultSysSolution.modules.SectSlipRates;
import org.opensha.sha.earthquake.faultSysSolution.modules.SubSeismoOnFaultMFDs;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityConfiguration;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.RuptureConnectionSearch;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.util.SectionDistanceAzimuthCalculator;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.magdist.IncrementalMagFreqDist;
import scratch.UCERF3.U3SlipAlongRuptureModelRupSet;
import scratch.UCERF3.analysis.DeformationModelsCalc;
import scratch.UCERF3.analysis.FaultSystemRupSetCalc;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.enumTreeBranches.MaxMagOffFault;
import scratch.UCERF3.enumTreeBranches.MomentRateFixes;
import scratch.UCERF3.enumTreeBranches.ScalingRelationships;
import scratch.UCERF3.enumTreeBranches.SlipAlongRuptureModels;
import scratch.UCERF3.enumTreeBranches.SpatialSeisPDF;
import scratch.UCERF3.enumTreeBranches.TotalMag5Rate;
import scratch.UCERF3.griddedSeismicity.FaultPolyMgr;
import scratch.UCERF3.inversion.SectionCluster;
import scratch.UCERF3.inversion.SectionClusterList;
import scratch.UCERF3.inversion.U3InversionTargetMFDs;
import scratch.UCERF3.inversion.laughTest.OldPlausibilityConfiguration;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.FaultSectionDataWriter;
import scratch.UCERF3.utils.U3SectionMFD_constraint;

public class InversionFaultSystemRupSet
extends U3SlipAlongRuptureModelRupSet {
    protected static final boolean D = false;
    private DeformationModels defModName;
    private FaultModels faultModel;
    private String deformationModelString;
    private SlipAlongRuptureModels slipModelType;
    private ScalingRelationships scalingRelationship;
    private InversionModels inversionModel;
    private double totalRegionRateMgt5;
    private double mMaxOffFault;
    private boolean applyImpliedCouplingCoeff;
    private SpatialSeisPDF spatialSeisPDF;
    private List<? extends FaultSection> faultSectionData;
    private U3LogicTreeBranch logicTreeBranch;
    private OldPlausibilityConfiguration filter;
    static final double MIN_MO_RATE_REDUCTION = 0.1;
    private double[] rupMeanSlip;
    private List<List<Integer>> clusterRups;
    private List<List<Integer>> clusterSects;
    private List<List<Integer>> sectionConnectionsListList;
    private Map<IDPairing, Double> subSectionDistances;
    public static final double MIN_MAG_FOR_SEISMOGENIC_RUPS = 6.0;
    private boolean[] isRupBelowMinMagsForSects;

    public InversionFaultSystemRupSet(FaultSystemRupSet rupSet, U3LogicTreeBranch branch) {
        super(branch.getValue(SlipAlongRuptureModels.class));
        this.init(branch);
        this.init(rupSet);
        if (!rupSet.hasModule(ClusterRuptures.class)) {
            PlausibilityConfiguration plausibility = rupSet.getModule(PlausibilityConfiguration.class);
            if (plausibility != null) {
                SectionDistanceAzimuthCalculator distCalc = plausibility.getDistAzCalc();
                double maxDist = plausibility.getConnectionStrategy().getMaxJumpDist();
                boolean cumulativeJumps = true;
                RuptureConnectionSearch search = new RuptureConnectionSearch(rupSet, distCalc, maxDist, cumulativeJumps);
                rupSet.addModule(ClusterRuptures.instance((FaultSystemRupSet)this, search));
            }
        } else {
            this.addModule(rupSet.getModule(ClusterRuptures.class));
        }
    }

    public InversionFaultSystemRupSet(U3LogicTreeBranch branch, SectionClusterList sectionClusterList, List<? extends FaultSection> faultSectionData) {
        super(branch.getValue(SlipAlongRuptureModels.class));
        Preconditions.checkNotNull((Object)branch, (Object)"LogicTreeBranch cannot be null!");
        Preconditions.checkArgument((boolean)branch.isFullySpecified(), (Object)"LogicTreeBranch must be fully specified.");
        if (faultSectionData == null) {
            faultSectionData = sectionClusterList.getFaultSectionData();
        }
        this.faultSectionData = faultSectionData;
        this.init(branch);
        this.filter = sectionClusterList.getPlausibilityConfiguration();
        this.subSectionDistances = sectionClusterList.getSubSectionDistances();
        this.sectionConnectionsListList = sectionClusterList.getSectionConnectionsListList();
        for (int i = 0; i < faultSectionData.size(); ++i) {
            Preconditions.checkState((faultSectionData.get(i).getSectionId() == i ? 1 : 0) != 0, (Object)"RupsInFaultSystemInversion: Error - indices of faultSectionData don't match IDs");
        }
        this.calcRuptureAttributes(faultSectionData, sectionClusterList);
    }

    public InversionFaultSystemRupSet(FaultSystemRupSet rupSet, U3LogicTreeBranch branch, OldPlausibilityConfiguration filter, double[] rupAveSlips, List<List<Integer>> sectionConnectionsListList, List<List<Integer>> clusterRups, List<List<Integer>> clusterSects) {
        super(branch.getValue(SlipAlongRuptureModels.class));
        this.setLogicTreeBranch(branch);
        this.init(rupSet);
        this.init(branch);
        int numSects = rupSet.getNumSections();
        int numRups = rupSet.getNumRuptures();
        Preconditions.checkArgument((rupAveSlips == null || rupAveSlips.length == this.getNumRuptures() ? 1 : 0) != 0, (Object)"rupAveSlips sizes inconsistent!");
        this.rupMeanSlip = rupAveSlips;
        Preconditions.checkNotNull((Object)branch, (Object)"LogicTreeBranch cannot be null");
        if (!branch.isFullySpecified()) {
            System.err.println("WARNING: LogicTreeBranch not fully specified");
        }
        this.filter = filter;
        Preconditions.checkArgument((sectionConnectionsListList == null || sectionConnectionsListList.size() == numSects ? 1 : 0) != 0, (Object)"close sub section size doesn't match number of sections!");
        this.sectionConnectionsListList = sectionConnectionsListList;
        this.clusterRups = clusterRups;
        this.clusterSects = clusterSects;
    }

    private void init(U3LogicTreeBranch branch) {
        if (branch.hasValue(FaultModels.class)) {
            this.faultModel = branch.getValue(FaultModels.class);
        }
        if (branch.hasValue(DeformationModels.class)) {
            this.defModName = branch.getValue(DeformationModels.class);
        }
        if (branch.hasValue(ScalingRelationships.class)) {
            this.scalingRelationship = branch.getValue(ScalingRelationships.class);
            this.addModule(AveSlipModule.forModel(this, this.scalingRelationship));
        }
        if (branch.hasValue(SlipAlongRuptureModels.class)) {
            this.slipModelType = branch.getValue(SlipAlongRuptureModels.class);
        }
        if (branch.hasValue(InversionModels.class)) {
            this.inversionModel = branch.getValue(InversionModels.class);
        }
        if (branch.hasValue(TotalMag5Rate.class)) {
            this.totalRegionRateMgt5 = branch.getValue(TotalMag5Rate.class).getRateMag5();
        }
        if (branch.hasValue(MaxMagOffFault.class)) {
            this.mMaxOffFault = branch.getValue(MaxMagOffFault.class).getMaxMagOffFault();
        }
        if (branch.hasValue(MomentRateFixes.class)) {
            this.applyImpliedCouplingCoeff = branch.getValue(MomentRateFixes.class).isApplyCC();
        }
        if (branch.hasValue(SpatialSeisPDF.class)) {
            this.spatialSeisPDF = branch.getValue(SpatialSeisPDF.class);
        }
        this.setLogicTreeBranch(branch);
        this.offerAvailableModule(new Callable<PolygonFaultGridAssociations>(){

            @Override
            public PolygonFaultGridAssociations call() throws Exception {
                if (InversionFaultSystemRupSet.this.faultModel == FaultModels.FM3_1 || InversionFaultSystemRupSet.this.faultModel == FaultModels.FM3_2) {
                    return FaultPolyMgr.loadSerializedUCERF3(InversionFaultSystemRupSet.this.faultModel);
                }
                System.err.println("WARNING: rupture set doesn't have polygons attached, building with default buffer");
                return FaultPolyMgr.create(InversionFaultSystemRupSet.this.getFaultSectionDataList(), 12.0);
            }
        }, PolygonFaultGridAssociations.class);
        if (this.hasAvailableModule(ModSectMinMags.class)) {
            this.removeModuleInstances(ModSectMinMags.class);
        }
        this.addAvailableModule((Callable<OpenSHA_Module>)new Callable<ModSectMinMags>(){

            @Override
            public ModSectMinMags call() throws Exception {
                return ModSectMinMags.instance(InversionFaultSystemRupSet.this, InversionFaultSystemRupSet.this.calcFinalMinMagForSections());
            }
        }, ModSectMinMags.class);
        this.offerAvailableModule(new Callable<U3InversionTargetMFDs>(){

            @Override
            public U3InversionTargetMFDs call() throws Exception {
                return new U3InversionTargetMFDs(InversionFaultSystemRupSet.this);
            }
        }, U3InversionTargetMFDs.class);
        if (this.hasAvailableModule(SectSlipRates.class)) {
            this.removeModuleInstances(SectSlipRates.class);
        }
        this.addAvailableModule((Callable<OpenSHA_Module>)new Callable<SectSlipRates>(){

            @Override
            public SectSlipRates call() throws Exception {
                return InversionFaultSystemRupSet.computeTargetSlipRates((FaultSystemRupSet)InversionFaultSystemRupSet.this, InversionFaultSystemRupSet.this.inversionModel.isCharacteristic(), InversionFaultSystemRupSet.this.applyImpliedCouplingCoeff, (InversionTargetMFDs)InversionFaultSystemRupSet.this.getInversionTargetMFDs());
            }
        }, SectSlipRates.class);
    }

    public static Vector3D getSlipVector(FaultSectionPrefData section) {
        double[] strikeDipRake = new double[]{section.getFaultTrace().getAveStrike(), section.getAveDip(), section.getAveRake()};
        double[] vect = FaultUtils.getSlipVector(strikeDipRake);
        return new Vector3D(vect[0], vect[1], vect[2]);
    }

    public void plotMagHistogram() {
        IncrementalMagFreqDist magHist = new IncrementalMagFreqDist(5.05, 40, 0.1);
        magHist.setTolerance(0.2);
        for (int r = 0; r < this.getNumRuptures(); ++r) {
            magHist.add(this.getMagForRup(r), 1.0);
        }
        ArrayList<IncrementalMagFreqDist> funcs = new ArrayList<IncrementalMagFreqDist>();
        funcs.add(magHist);
        magHist.setName("Histogram of Inversion ruptures");
        magHist.setInfo("(number in each mag bin)");
        GraphWindow graph = new GraphWindow(funcs, "Magnitude Histogram");
        graph.setX_AxisLabel("Mag");
        graph.setY_AxisLabel("Num");
    }

    private void calcRuptureAttributes(List<? extends FaultSection> faultSectionData, SectionClusterList sectionClusterList) {
        Object infoString = "FaultSystemRupSet Parameter Settings:\n\n";
        infoString = (String)infoString + "\tfaultModel = " + String.valueOf(this.faultModel) + "\n";
        infoString = (String)infoString + "\tdefModName = " + String.valueOf(this.defModName) + "\n";
        infoString = (String)infoString + "\tdefMod filter basis = " + String.valueOf(this.faultModel.getFilterBasis()) + "\n";
        infoString = (String)infoString + "\t" + String.valueOf(sectionClusterList.getPlausibilityConfiguration()) + "\n";
        infoString = (String)infoString + "\tscalingRelationship = " + String.valueOf(this.scalingRelationship) + "\n";
        infoString = (String)infoString + "\tinversionModel = " + String.valueOf(this.inversionModel) + "\n";
        infoString = (String)infoString + "\tslipModelType = " + String.valueOf(this.slipModelType) + "\n";
        int numSections = faultSectionData.size();
        double[] sectAreasReduced = new double[numSections];
        double[] sectAreasOrig = new double[numSections];
        for (int sectIndex = 0; sectIndex < numSections; ++sectIndex) {
            FaultSection sectData = faultSectionData.get(sectIndex);
            sectAreasReduced[sectIndex] = sectData.getArea(true);
            sectAreasOrig[sectIndex] = sectData.getArea(false);
        }
        int numRuptures = 0;
        for (int c = 0; c < sectionClusterList.size(); ++c) {
            numRuptures += ((SectionCluster)sectionClusterList.get(c)).getNumRuptures();
        }
        ArrayList sectionsForRups = Lists.newArrayList();
        double[] rupMeanMag = new double[numRuptures];
        double[] rupMeanMoment = new double[numRuptures];
        double[] rupArea = new double[numRuptures];
        double[] rupLength = new double[numRuptures];
        double[] rupRake = new double[numRuptures];
        this.clusterRups = Lists.newArrayList();
        this.clusterSects = Lists.newArrayList();
        int rupIndex = -1;
        for (int c = 0; c < sectionClusterList.size(); ++c) {
            SectionCluster cluster = (SectionCluster)sectionClusterList.get(c);
            List<List<Integer>> clusterRupSects = cluster.getSectionIndicesForRuptures();
            ArrayList<Integer> clusterRupIndexes = new ArrayList<Integer>(this.clusterRups.size());
            this.clusterRups.add(clusterRupIndexes);
            this.clusterSects.add(cluster.getAllSectionsIdList());
            for (int r = 0; r < clusterRupSects.size(); ++r) {
                double mag;
                clusterRupIndexes.add(++rupIndex);
                double totArea = 0.0;
                double totOrigArea = 0.0;
                double totLength = 0.0;
                List<Integer> sectsInRup = clusterRupSects.get(r);
                sectionsForRups.add(sectsInRup);
                ArrayList<Double> areas = new ArrayList<Double>();
                ArrayList<Double> rakes = new ArrayList<Double>();
                for (Integer sectID : sectsInRup) {
                    double length = faultSectionData.get(sectID).getTraceLength() * 1000.0;
                    totLength += length;
                    double area = sectAreasReduced[sectID];
                    totArea += area;
                    totOrigArea += sectAreasOrig[sectID];
                    areas.add(area);
                    rakes.add(faultSectionData.get(sectID).getAveRake());
                }
                rupArea[rupIndex] = totArea;
                rupLength[rupIndex] = totLength;
                rupRake[rupIndex] = FaultUtils.getInRakeRange(FaultUtils.getScaledAngleAverage(areas, rakes));
                double origDDW = totOrigArea / totLength;
                rupMeanMag[rupIndex] = mag = this.scalingRelationship.getMag(totArea, totLength, totArea / totLength, origDDW, rupRake[rupIndex]);
                rupMeanMoment[rupIndex] = MagUtils.magToMoment(rupMeanMag[rupIndex]);
            }
        }
        this.init(faultSectionData, null, null, sectAreasReduced, sectionsForRups, rupMeanMag, rupRake, rupArea, rupLength, (String)infoString);
    }

    public static SectSlipRates computeTargetSlipRates(FaultSystemRupSet rupSet, InversionModels inversionModel, MomentRateFixes momentRateFixes, InversionTargetMFDs inversionMFDs) {
        return InversionFaultSystemRupSet.computeTargetSlipRates(rupSet, inversionModel.isCharacteristic(), momentRateFixes.isApplyCC(), inversionMFDs);
    }

    public static SectSlipRates computeTargetSlipRates(FaultSystemRupSet rupSet, boolean characteristic, boolean applyImpliedCouplingCoeff, InversionTargetMFDs inversionMFDs) {
        double[] targetSlipRateStdDev;
        int numSections = rupSet.getNumSections();
        double[] targetSlipRate = new double[numSections];
        Preconditions.checkState((targetSlipRate.length == (targetSlipRateStdDev = new double[numSections]).length ? 1 : 0) != 0);
        SubSeismoOnFaultMFDs subSeismoOnFaultMFDs = inversionMFDs.getOnFaultSubSeisMFDs();
        double impliedCC_reduction = 1.0;
        if (applyImpliedCouplingCoeff) {
            Preconditions.checkState((boolean)(inversionMFDs instanceof U3InversionTargetMFDs), (Object)"Can only use applyImpliedCouplingCoeff option on U3InversionTargetMFDs instance. This option was only used in early UCERF3 tests, and was not carried forward");
            double impliedOnFaultCouplingCoeff = ((U3InversionTargetMFDs)inversionMFDs).getImpliedOnFaultCouplingCoeff();
            if (impliedOnFaultCouplingCoeff < 1.0) {
                impliedCC_reduction = impliedOnFaultCouplingCoeff;
            }
        }
        double totalOrigOnFaultMoRate = DeformationModelsCalc.calculateTotalMomentRate(rupSet.getFaultSectionDataList(), true);
        double totalFinalOnFaultMoRate = totalOrigOnFaultMoRate * impliedCC_reduction;
        double aveCharSubSeismoMoRateFraction = inversionMFDs.getTotalOnFaultSubSeisMFD().getTotalMomentRate() / totalFinalOnFaultMoRate;
        for (int s = 0; s < numSections; ++s) {
            FaultSection sect = rupSet.getFaultSectionData(s);
            double origSectMoRate = sect.calcMomentRate(true);
            if (Double.isNaN(origSectMoRate)) {
                origSectMoRate = 0.0;
            }
            double impliedCC_reducedSectMoRate = origSectMoRate * impliedCC_reduction;
            double fractionalSlipRateReduction = 1.0;
            if (origSectMoRate > 0.0) {
                if (characteristic) {
                    fractionalSlipRateReduction = impliedCC_reducedSectMoRate * (1.0 - aveCharSubSeismoMoRateFraction) / origSectMoRate;
                } else {
                    double subSeismoMoRate = subSeismoOnFaultMFDs.get(s).getTotalMomentRate();
                    fractionalSlipRateReduction = (impliedCC_reducedSectMoRate - subSeismoMoRate) / origSectMoRate;
                }
            }
            targetSlipRate[s] = sect.getReducedAveSlipRate() * 0.001 * fractionalSlipRateReduction;
            targetSlipRateStdDev[s] = sect.getReducedSlipRateStdDev() * 0.001 * fractionalSlipRateReduction;
        }
        return SectSlipRates.precomputed(rupSet, targetSlipRate, targetSlipRateStdDev);
    }

    public void writeRupsToFiles(String filePathAndName) {
        try {
            FileWriter fw = new FileWriter(filePathAndName);
            fw.write("rupID\tclusterID\trupInClustID\tmag\tnumSectIDs\tsect1_ID\tsect2_ID\t...\n");
            int rupIndex = 0;
            for (int c = 0; c < this.getNumClusters(); ++c) {
                List<Integer> clusterRupIndexes = this.clusterRups.get(c);
                for (int r = 0; r < clusterRupIndexes.size(); ++r) {
                    List<Integer> rup = this.getSectionsIndicesForRup(clusterRupIndexes.get(r));
                    String line = Integer.toString(rupIndex) + "\t" + Integer.toString(c) + "\t" + Integer.toString(r) + "\t" + (float)this.getMagForRup(rupIndex) + "\t" + rup.size();
                    for (Integer sectID : rup) {
                        line = line + "\t" + sectID;
                    }
                    line = line + "\n";
                    fw.write(line);
                    ++rupIndex;
                }
            }
            fw.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void writeSectionsToFile(String filePathAndName) throws IOException {
        ArrayList<String> metaData = new ArrayList<String>();
        metaData.add("defModName = " + String.valueOf(this.defModName));
        FaultSectionDataWriter.writeSectionsToFile(this.getFaultSectionDataList(), metaData, filePathAndName);
    }

    @Override
    public void copyCacheFrom(FaultSystemRupSet rupSet) {
        super.copyCacheFrom(rupSet);
        if (rupSet instanceof InversionFaultSystemRupSet) {
            FaultModels myFM = this.getFaultModel();
            DeformationModels myDM = this.getDeformationModel();
            U3LogicTreeBranch branch = this.getLogicTreeBranch();
            ScalingRelationships myScale = branch.getValue(ScalingRelationships.class);
            SlipAlongRuptureModels mySlipAlong = branch.getValue(SlipAlongRuptureModels.class);
            InversionFaultSystemRupSet invRupSet = (InversionFaultSystemRupSet)rupSet;
            U3LogicTreeBranch oBranch = invRupSet.getLogicTreeBranch();
            FaultModels oFM = invRupSet.getFaultModel();
            DeformationModels oDM = invRupSet.getDeformationModel();
            ScalingRelationships oScale = oBranch.getValue(ScalingRelationships.class);
            SlipAlongRuptureModels oSlipAlong = oBranch.getValue(SlipAlongRuptureModels.class);
            if (myFM == oFM && myDM == oDM && myScale == oScale) {
                this.surfCache = invRupSet.surfCache;
                if (mySlipAlong == oSlipAlong) {
                    this.rupSectionSlipsCache = invRupSet.rupSectionSlipsCache;
                }
            }
        }
    }

    @Override
    public double getAveSlipForRup(int rupIndex) {
        return this.getAveSlipForAllRups()[rupIndex];
    }

    @Override
    public synchronized double[] getAveSlipForAllRups() {
        if (this.rupMeanSlip == null) {
            double[] slips = new double[this.getNumRuptures()];
            AveSlipModule aveSlips = this.getModule(AveSlipModule.class);
            for (int r = 0; r < slips.length; ++r) {
                slips[r] = aveSlips.getAveSlip(r);
            }
            this.rupMeanSlip = slips;
        }
        return this.rupMeanSlip;
    }

    public int getNumClusters() {
        if (this.clusterRups == null) {
            return 0;
        }
        return this.clusterRups.size();
    }

    public int getNumRupturesForCluster(int index) {
        return this.clusterRups.get(index).size();
    }

    public List<Integer> getRupturesForCluster(int index) throws IndexOutOfBoundsException {
        return this.clusterRups.get(index);
    }

    public List<List<Integer>> getRupturesForClusters() {
        return this.clusterRups;
    }

    public List<Integer> getSectionsForCluster(int index) {
        return this.clusterSects.get(index);
    }

    public List<List<Integer>> getSectionsForClusters() {
        return this.clusterSects;
    }

    public List<Integer> getCloseSectionsList(int sectIndex) {
        return this.sectionConnectionsListList.get(sectIndex);
    }

    public List<List<Integer>> getCloseSectionsListList() {
        return this.sectionConnectionsListList;
    }

    public OldPlausibilityConfiguration getOldPlausibilityConfiguration() {
        return this.filter;
    }

    public U3LogicTreeBranch getLogicTreeBranch() {
        return this.logicTreeBranch;
    }

    public void setLogicTreeBranch(U3LogicTreeBranch logicTreeBranch) {
        this.addModule(logicTreeBranch);
        this.logicTreeBranch = logicTreeBranch;
    }

    public DeformationModels getDeformationModel() {
        return this.defModName;
    }

    public FaultModels getFaultModel() {
        return this.faultModel;
    }

    public SlipAlongRuptureModels getSlipAlongRuptureModel() {
        return this.slipModelType;
    }

    public U3InversionTargetMFDs getInversionTargetMFDs() {
        return this.getModule(U3InversionTargetMFDs.class);
    }

    public synchronized Map<IDPairing, Double> getSubSectionDistances() {
        if (this.subSectionDistances == null) {
            this.subSectionDistances = DeformationModelFetcher.calculateDistances(this.filter.getMaxJumpDist(), this.getFaultSectionDataList());
            for (IDPairing pair : Lists.newArrayList(this.subSectionDistances.keySet())) {
                this.subSectionDistances.put(pair.getReversed(), this.subSectionDistances.get(pair));
            }
        }
        return this.subSectionDistances;
    }

    public String getPreInversionAnalysisData(boolean includeHeader) {
        Object str = "";
        if (includeHeader) {
            str = (String)str + this.logicTreeBranch.getTabSepValStringHeader() + "\t" + this.getInversionTargetMFDs().getPreInversionAnalysisDataHeader() + "\ttargetOnFaultMoRate\tMMaxOffFaultIfDefModMoRateSatisfied\n";
        }
        str = (String)str + this.logicTreeBranch.getTabSepValString() + "\t" + this.getInversionTargetMFDs().getPreInversionAnalysisData() + "\t" + (float)this.getTotalReducedMomentRate() + "\t" + (float)this.getInversionTargetMFDs().getOffFaultMmaxIfOrigMoRateSatisfied();
        return str;
    }

    protected double[] calcFinalMinMagForSections() {
        return FaultSystemRupSetCalc.computeMinSeismoMagForSections(this, 6.0);
    }

    public synchronized double getFinalMinMagForSection(int sectIndex) {
        return this.getModule(ModSectMinMags.class).getMinMagForSection(sectIndex);
    }

    public synchronized boolean isRuptureBelowSectMinMag(int rupIndex) {
        if (this.isRupBelowMinMagsForSects == null) {
            ModSectMinMags minMagsModule = this.getModule(ModSectMinMags.class);
            this.isRupBelowMinMagsForSects = FaultSystemRupSetCalc.computeWhichRupsFallBelowSectionMinMags(this, minMagsModule);
        }
        return this.isRupBelowMinMagsForSects[rupIndex];
    }

    public boolean[] getRuptureBelowSectMinMagArray() {
        this.isRuptureBelowSectMinMag(0);
        return this.isRupBelowMinMagsForSects;
    }

    public double getUpperMagForSubseismoRuptures(int sectIndex) {
        return InversionFaultSystemRupSet.getUpperMagForSubseismoRuptures(this.getFinalMinMagForSection(sectIndex));
    }

    public static double getUpperMagForSubseismoRuptures(double finalMinMag) {
        return U3SectionMFD_constraint.getLowerEdgeOfFirstBin(finalMinMag) - 0.05;
    }
}

