/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.coulomb;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.dom4j.Element;
import org.opensha.commons.metadata.XMLSaveable;
import scratch.UCERF3.inversion.coulomb.CoulombRatesRecord;

public class CoulombRatesTester
implements XMLSaveable {
    public static final String XML_METADATA_NAME = "CoulombRatesTester";
    private boolean BUGGY_MIN_STRESS = false;
    private double minAverageProb;
    private double minIndividualProb;
    private double minimumStressExclusionCeiling;
    private TestType testType;
    private boolean applyBranchesOnly;
    private boolean allowAnyWay;

    public CoulombRatesTester(TestType testType, double minAverageProb, double minIndividualProb, double minimumStressExclusionCeiling, boolean applyBranchesOnly, boolean allowAnyWay) {
        this.minAverageProb = minAverageProb;
        this.minIndividualProb = minIndividualProb;
        this.minimumStressExclusionCeiling = minimumStressExclusionCeiling;
        Preconditions.checkNotNull((Object)((Object)testType), (Object)"Test type must be specified!");
        this.testType = testType;
        this.applyBranchesOnly = applyBranchesOnly;
        this.allowAnyWay = allowAnyWay;
    }

    public void setBuggyMinStress(boolean buggyMinStress) {
        if (buggyMinStress) {
            System.err.println("WARNING: buggy coulomb min stress exclusion implementation being used.");
        }
        this.BUGGY_MIN_STRESS = buggyMinStress;
    }

    public boolean isApplyBranchesOnly() {
        return this.applyBranchesOnly;
    }

    public boolean doesRupturePass(List<CoulombRatesRecord> forwardRates, List<CoulombRatesRecord> backwardRates) {
        if (forwardRates.isEmpty()) {
            return true;
        }
        if (this.testType == TestType.SHEAR_STRESS || this.testType == TestType.COULOMB_STRESS) {
            return this.doesRupturePass(forwardRates, backwardRates, this.testType);
        }
        boolean coulombPass = this.doesRupturePass(forwardRates, backwardRates, TestType.COULOMB_STRESS);
        if (this.testType == TestType.EITHER && coulombPass) {
            return true;
        }
        if (this.testType == TestType.BOTH && !coulombPass) {
            return false;
        }
        return this.doesRupturePass(forwardRates, backwardRates, TestType.SHEAR_STRESS);
    }

    private boolean doesRupturePass(List<CoulombRatesRecord> forwardRates, List<CoulombRatesRecord> backwardRates, TestType type) {
        if (this.allowAnyWay) {
            return this.doesRupturePassAnyWay(forwardRates, backwardRates, type);
        }
        return this.doesRupturePassOneWay(forwardRates, type) || this.doesRupturePassOneWay(backwardRates, type);
    }

    private boolean doesRupturePassAnyWay(List<CoulombRatesRecord> forwardRates, List<CoulombRatesRecord> backwardRates, TestType type) {
        for (int i = 0; i <= forwardRates.size(); ++i) {
            int j;
            ArrayList rates = Lists.newArrayList();
            for (j = 0; j < i; ++j) {
                rates.add(backwardRates.get(backwardRates.size() - 1 - j));
            }
            for (j = i; j < forwardRates.size(); ++j) {
                rates.add(forwardRates.get(j));
            }
            Preconditions.checkState((rates.size() == forwardRates.size() ? 1 : 0) != 0);
            if (!this.doesRupturePassOneWay(rates, this.testType)) continue;
            return true;
        }
        return false;
    }

    private boolean doesRupturePassOneWay(List<CoulombRatesRecord> rates, TestType type) {
        double minStress = Double.POSITIVE_INFINITY;
        double minProb = Double.POSITIVE_INFINITY;
        double sumProbs = 0.0;
        int pairs = rates.size();
        int num = 0;
        for (CoulombRatesRecord record : rates) {
            double stress = CoulombRatesTester.getStress(type, record);
            double prob = CoulombRatesTester.getProbability(type, record);
            if (!this.BUGGY_MIN_STRESS && stress >= this.minimumStressExclusionCeiling) continue;
            if (stress < minStress) {
                minStress = stress;
            }
            if (prob < minProb) {
                minProb = prob;
            }
            sumProbs += prob;
            ++num;
        }
        if (num == 0) {
            return true;
        }
        double avgProb = sumProbs / (double)num;
        if (minStress > this.minimumStressExclusionCeiling) {
            return true;
        }
        return avgProb > this.minAverageProb && minProb > this.minIndividualProb;
    }

    private static double getStress(TestType type, CoulombRatesRecord record) {
        switch (type.ordinal()) {
            case 0: {
                return record.getCoulombStressChange();
            }
            case 1: {
                return record.getShearStressChange();
            }
        }
        throw new IllegalStateException();
    }

    private static double getProbability(TestType type, CoulombRatesRecord record) {
        switch (type.ordinal()) {
            case 0: {
                return record.getCoulombStressProbability();
            }
            case 1: {
                return record.getShearStressProbability();
            }
        }
        throw new IllegalStateException();
    }

    public String toString() {
        return "CoulombRatesFilter [minAverageProb=" + this.minAverageProb + ", minIndividualProb=" + this.minIndividualProb + ", minimumStressExclusionCeiling=" + this.minimumStressExclusionCeiling + ", testType=" + String.valueOf((Object)this.testType) + "]";
    }

    public double getMinAverageProb() {
        return this.minAverageProb;
    }

    public void setMinAverageProb(double minAverageProb) {
        this.minAverageProb = minAverageProb;
    }

    public double getMinIndividualProb() {
        return this.minIndividualProb;
    }

    public void setMinIndividualProb(double minIndividualProb) {
        this.minIndividualProb = minIndividualProb;
    }

    public double getMinimumStressExclusionCeiling() {
        return this.minimumStressExclusionCeiling;
    }

    public void setMinimumStressExclusionCeiling(double minimumStressExclusionCeiling) {
        this.minimumStressExclusionCeiling = minimumStressExclusionCeiling;
    }

    public TestType getTestType() {
        return this.testType;
    }

    public void setTestType(TestType testType) {
        this.testType = testType;
    }

    public void setApplyBranchesOnly(boolean applyBranchesOnly) {
        this.applyBranchesOnly = applyBranchesOnly;
    }

    public boolean isAllowAnyWay() {
        return this.allowAnyWay;
    }

    public void setAllowAnyWay(boolean allowAnyWay) {
        this.allowAnyWay = allowAnyWay;
    }

    @Override
    public Element toXMLMetadata(Element root) {
        Element el = root.addElement(XML_METADATA_NAME);
        el.addAttribute("minAverageProb", "" + this.minAverageProb);
        el.addAttribute("minIndividualProb", "" + this.minIndividualProb);
        el.addAttribute("minimumStressExclusionCeiling", "" + this.minimumStressExclusionCeiling);
        el.addAttribute("testType", this.testType.name());
        el.addAttribute("applyBranchesOnly", "" + this.applyBranchesOnly);
        el.addAttribute("allowAnyWay", "" + this.allowAnyWay);
        if (this.BUGGY_MIN_STRESS) {
            el.addAttribute("buggyMinStress", "true");
        }
        return root;
    }

    public static CoulombRatesTester fromXMLMetadata(Element coulombEl) {
        double minAverageProb = Double.parseDouble(coulombEl.attributeValue("minAverageProb"));
        double minIndividualProb = Double.parseDouble(coulombEl.attributeValue("minIndividualProb"));
        double minimumStressExclusionCeiling = Double.parseDouble(coulombEl.attributeValue("minimumStressExclusionCeiling"));
        TestType testType = TestType.valueOf(coulombEl.attributeValue("testType"));
        boolean applyBranchesOnly = Boolean.parseBoolean(coulombEl.attributeValue("applyBranchesOnly"));
        boolean allowAnyWay = Boolean.parseBoolean(coulombEl.attributeValue("allowAnyWay"));
        CoulombRatesTester tester = new CoulombRatesTester(testType, minAverageProb, minIndividualProb, minimumStressExclusionCeiling, applyBranchesOnly, allowAnyWay);
        if (coulombEl.attribute("buggyMinStress") != null && Boolean.parseBoolean(coulombEl.attributeValue("buggyMinStress"))) {
            tester.BUGGY_MIN_STRESS = true;
        }
        return tester;
    }

    public static enum TestType {
        COULOMB_STRESS,
        SHEAR_STRESS,
        BOTH,
        EITHER;

    }
}

