/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.laughTest;

import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.data.ShortNamed;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;

public abstract class AbstractPlausibilityFilter
implements ShortNamed {
    public PlausibilityResult apply(List<? extends FaultSection> rupture) {
        ArrayList subRup = Lists.newArrayList();
        ArrayList subJunctions = Lists.newArrayList();
        ArrayList pairings = Lists.newArrayList();
        PlausibilityResult result = PlausibilityResult.PASS;
        for (int i = 0; i < rupture.size(); ++i) {
            boolean junction;
            FaultSection sect = rupture.get(i);
            subRup.add(sect);
            if (i > 0) {
                pairings.add(new IDPairing(rupture.get(i - 1).getSectionId(), sect.getSectionId()));
            }
            boolean bl = junction = i > 0 && ((FaultSection)subRup.get(i)).getParentSectionId() != ((FaultSection)subRup.get(i - 1)).getParentSectionId();
            if (junction) {
                subJunctions.add(i);
            } else if (this.isApplyJunctionsOnly()) continue;
            result = this.applyLastSection(subRup, pairings, subJunctions);
            if (!result.canContinue()) break;
        }
        return result;
    }

    public abstract PlausibilityResult applyLastSection(List<? extends FaultSection> var1, List<IDPairing> var2, List<Integer> var3);

    public abstract boolean isApplyJunctionsOnly();
}

