/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.laughTest;

import com.google.common.base.Joiner;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.List;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.coulomb.CoulombRates;
import scratch.UCERF3.inversion.coulomb.CoulombRatesRecord;
import scratch.UCERF3.inversion.coulomb.CoulombRatesTester;
import scratch.UCERF3.inversion.laughTest.AbstractPlausibilityFilter;

public class BuggyCoulombFilter
extends AbstractPlausibilityFilter {
    private CoulombRates rates;
    private CoulombRatesTester tester;
    private boolean minEqualsAvg;
    private List<? extends FaultSection> sectionDataList;
    private List<List<Integer>> sectionConnectionsListList;

    public BuggyCoulombFilter(CoulombRates rates, CoulombRatesTester tester, List<? extends FaultSection> sectionDataList, List<List<Integer>> sectionConnectionsListList) {
        this.rates = rates;
        this.tester = tester;
        this.minEqualsAvg = tester.getMinAverageProb() <= tester.getMinIndividualProb();
        this.sectionDataList = sectionDataList;
        this.sectionConnectionsListList = sectionConnectionsListList;
    }

    @Override
    public PlausibilityResult applyLastSection(List<? extends FaultSection> rupture, List<IDPairing> pairings, List<Integer> junctionIndexes) {
        if (rupture.size() < 2 || junctionIndexes.isEmpty()) {
            return PlausibilityResult.PASS;
        }
        ArrayList rupIndexes = Lists.newArrayList();
        for (FaultSection faultSection : rupture) {
            rupIndexes.add(faultSection.getSectionId());
        }
        ArrayList forwardRates = Lists.newArrayList();
        ArrayList arrayList = Lists.newArrayList();
        for (int i = 1; i < rupture.size(); ++i) {
            if (!this.isBranchPoint((Integer)rupIndexes.get(i), rupIndexes.subList(0, i + 1))) continue;
            IDPairing pair = new IDPairing((Integer)rupIndexes.get(i - 1), (Integer)rupIndexes.get(i));
            forwardRates.add((CoulombRatesRecord)this.rates.get(pair));
            arrayList.add(0, (CoulombRatesRecord)this.rates.get(pair.getReversed()));
            if (this.rates.get(pair) != null) continue;
            System.out.println("Weird...missing: " + String.valueOf(pair));
        }
        if (this.tester.doesRupturePass(forwardRates, arrayList)) {
            return PlausibilityResult.PASS;
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    public static void printDebugRates(List<Integer> rupIndexes, List<CoulombRatesRecord> forwardRates, List<CoulombRatesRecord> backwardRates) {
        ArrayList fwStrings = Lists.newArrayList();
        ArrayList bwStrings = Lists.newArrayList();
        ArrayList indexStrings = Lists.newArrayList();
        for (int index : rupIndexes) {
            Object str = "";
            for (CoulombRatesRecord r : forwardRates) {
                if (r.getPairing().getID1() != index) continue;
                str = "[";
            }
            str = (String)str + index;
            for (CoulombRatesRecord r : forwardRates) {
                if (r.getPairing().getID2() != index) continue;
                str = (String)str + "]";
            }
            indexStrings.add(str);
        }
        System.out.println("Indexes: " + Joiner.on((String)";").join((Iterable)indexStrings));
        for (int i = 0; i < forwardRates.size(); ++i) {
            IDPairing pair = forwardRates.get(i).getPairing();
            fwStrings.add(String.valueOf(pair) + ": " + forwardRates.get(i).getCoulombStressProbability());
            bwStrings.add(String.valueOf(pair) + ": " + backwardRates.get(backwardRates.size() - 1 - i).getCoulombStressProbability());
        }
        System.out.println("Forward: " + Joiner.on((String)"; ").join((Iterable)fwStrings));
        System.out.println("Backward: " + Joiner.on((String)"; ").join((Iterable)bwStrings));
    }

    @Override
    public boolean isApplyJunctionsOnly() {
        return false;
    }

    private boolean isBranchPoint(int index, List<Integer> rupture) {
        List<Integer> branches = this.sectionConnectionsListList.get(index);
        int sectParent = this.sectionDataList.get(index).getParentSectionId();
        for (int branch : branches) {
            int branchParent;
            if (rupture.contains(branch) || (branchParent = this.sectionDataList.get(branch).getParentSectionId()) == sectParent) continue;
            return true;
        }
        return false;
    }

    @Override
    public String getName() {
        return "Buggy Coulomb Filter";
    }

    @Override
    public String getShortName() {
        return "CoulombOld";
    }
}

