/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.laughTest;

import java.util.List;
import java.util.Map;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.laughTest.AbstractPlausibilityFilter;
import scratch.UCERF3.inversion.laughTest.AzimuthChangeFilter;

public class CumulativeAzimuthChangeFilter
extends AbstractPlausibilityFilter {
    private boolean USE_BUGGY_AZ_CHANGE = false;
    private Map<IDPairing, Double> azimuths;
    private double maxCmlAzimuthChange;

    public CumulativeAzimuthChangeFilter(Map<IDPairing, Double> azimuths, double maxCmlAzimuthChange) {
        this.azimuths = azimuths;
        this.maxCmlAzimuthChange = maxCmlAzimuthChange;
    }

    public void setBuggyAzChange(boolean buggyAzChange) {
        this.USE_BUGGY_AZ_CHANGE = buggyAzChange;
        if (this.USE_BUGGY_AZ_CHANGE) {
            System.err.println("WARNING: CumulativeAzimuthChangeFilter has buggy implementation with respect to the 0/360 boundary. Bug left in for compatibility but should be removed for next runs");
        }
    }

    @Override
    public PlausibilityResult applyLastSection(List<? extends FaultSection> rupture, List<IDPairing> pairings, List<Integer> junctionIndexes) {
        double cmlAzimuthChange = 0.0;
        for (int i = 1; i < pairings.size(); ++i) {
            double prevAzimuth = this.azimuths.get(pairings.get(i - 1));
            double newAzimuth = this.azimuths.get(pairings.get(i));
            if (this.USE_BUGGY_AZ_CHANGE) {
                cmlAzimuthChange += Math.abs(newAzimuth - prevAzimuth);
                continue;
            }
            cmlAzimuthChange += Math.abs(AzimuthChangeFilter.getAzimuthDifference(newAzimuth, prevAzimuth));
        }
        if (cmlAzimuthChange <= this.maxCmlAzimuthChange) {
            return PlausibilityResult.PASS;
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    @Override
    public boolean isApplyJunctionsOnly() {
        return false;
    }

    @Override
    public String getName() {
        return "Cumulative Azimuth Filter";
    }

    @Override
    public String getShortName() {
        return "CumAzimuth";
    }
}

