/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.inversion.laughTest;

import java.util.List;
import java.util.Map;
import org.opensha.commons.util.IDPairing;
import org.opensha.sha.earthquake.faultSysSolution.ruptures.plausibility.PlausibilityResult;
import org.opensha.sha.faultSurface.FaultSection;
import scratch.UCERF3.inversion.laughTest.AbstractPlausibilityFilter;

public class CumulativeRakeChangeFilter
extends AbstractPlausibilityFilter {
    private Map<Integer, Double> rakesMap;
    private double maxCmlRakeChange;
    private static final boolean D = false;

    public CumulativeRakeChangeFilter(Map<Integer, Double> rakesMap, double maxCmlRakeChange) {
        this.rakesMap = rakesMap;
        this.maxCmlRakeChange = maxCmlRakeChange;
    }

    @Override
    public PlausibilityResult applyLastSection(List<? extends FaultSection> rupture, List<IDPairing> pairings, List<Integer> junctionIndexes) {
        double cmlRakeChange = 0.0;
        for (int i = 1; i < rupture.size(); ++i) {
            double rake2;
            FaultSection sect1 = rupture.get(i - 1);
            FaultSection sect2 = rupture.get(i);
            double rake1 = this.getRake(sect1);
            double rakeDiff = Math.abs(rake1 - (rake2 = this.getRake(sect2)));
            if (rakeDiff > 180.0) {
                rakeDiff = 360.0 - rakeDiff;
            }
            cmlRakeChange += rakeDiff;
        }
        if (cmlRakeChange <= this.maxCmlRakeChange) {
            return PlausibilityResult.PASS;
        }
        return PlausibilityResult.FAIL_HARD_STOP;
    }

    private double getRake(FaultSection sect) {
        if (this.rakesMap == null) {
            return sect.getAveRake();
        }
        return this.rakesMap.get(sect.getSectionId());
    }

    @Override
    public boolean isApplyJunctionsOnly() {
        return true;
    }

    @Override
    public String getName() {
        return "Cumulative Rake Change Filter";
    }

    @Override
    public String getShortName() {
        return "CumRake";
    }
}

