/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.logicTree;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import scratch.UCERF3.logicTree.ListBasedTreeTrimmer;
import scratch.UCERF3.logicTree.TreeTrimmer;
import scratch.UCERF3.logicTree.U3LogicTreeBranch;
import scratch.UCERF3.logicTree.U3LogicTreeBranchNode;

public class LogicTreeBranchIterator
implements Iterable<U3LogicTreeBranch>,
Iterator<U3LogicTreeBranch> {
    private List<Class<? extends U3LogicTreeBranchNode<?>>> classes;
    private int[] maxNums;
    private int[] curNums;
    private U3LogicTreeBranch next = null;
    private TreeTrimmer trimmer;
    private Iterator<U3LogicTreeBranch> customIt;
    private boolean exhausted = false;

    public LogicTreeBranchIterator() {
        this(null);
    }

    public LogicTreeBranchIterator(TreeTrimmer trimmer) {
        this.trimmer = trimmer;
        if (trimmer instanceof Iterable) {
            this.customIt = ((Iterable)((Object)trimmer)).iterator();
        }
        this.classes = U3LogicTreeBranch.getLogicTreeNodeClasses();
        this.maxNums = new int[this.classes.size()];
        this.curNums = new int[this.classes.size()];
        for (int i = 0; i < this.classes.size(); ++i) {
            this.maxNums[i] = this.classes.get(i).getEnumConstants().length - 1;
        }
        this.loadNext();
    }

    private void loadNext() {
        this.next = null;
        if (this.exhausted) {
            return;
        }
        if (this.customIt != null) {
            while (this.customIt.hasNext() && this.next == null) {
                U3LogicTreeBranch candidate = this.customIt.next();
                if (!this.trimmer.isTreeValid(candidate)) continue;
                this.next = candidate;
            }
            if (this.next == null) {
                this.exhausted = true;
            }
        } else {
            block1: while (this.next == null) {
                U3LogicTreeBranch candidate = this.buildBranch();
                if (this.trimmer == null || this.trimmer.isTreeValid(candidate)) {
                    this.next = candidate;
                }
                int i = this.maxNums.length;
                while (--i >= 0) {
                    if (this.curNums[i] < this.maxNums[i]) {
                        int n = i;
                        this.curNums[n] = this.curNums[n] + 1;
                        continue block1;
                    }
                    this.curNums[i] = 0;
                    if (i == 0) {
                        this.exhausted = true;
                        break block1;
                    }
                    for (int j = i + 1; j < this.curNums.length; ++j) {
                        this.curNums[j] = 0;
                    }
                }
            }
        }
    }

    public void printNextState() {
        Object str = null;
        for (int val : this.curNums) {
            str = str == null ? "" : (String)str + ",";
            str = (String)str + val;
        }
        System.out.println((String)str);
    }

    private U3LogicTreeBranch buildBranch() {
        ArrayList vals = Lists.newArrayList();
        for (int i = 0; i < this.curNums.length; ++i) {
            vals.add(this.classes.get(i).getEnumConstants()[this.curNums[i]]);
        }
        return U3LogicTreeBranch.fromValues(vals);
    }

    @Override
    public Iterator<U3LogicTreeBranch> iterator() {
        return this;
    }

    @Override
    public boolean hasNext() {
        return this.next != null;
    }

    @Override
    public U3LogicTreeBranch next() {
        Preconditions.checkState((boolean)this.hasNext(), (Object)"next() called with no more branches!");
        U3LogicTreeBranch ret = this.next;
        this.loadNext();
        return ret;
    }

    @Override
    public void remove() {
        throw new UnsupportedOperationException("remove not supported!");
    }

    public static void main(String[] args) {
        ListBasedTreeTrimmer trimmer = ListBasedTreeTrimmer.getNonZeroWeightsTrimmer();
        LogicTreeBranchIterator it = new LogicTreeBranchIterator(trimmer);
        double wtTotal = 0.0;
        int cnt = 0;
        for (U3LogicTreeBranch br : it) {
            Preconditions.checkNotNull((Object)br);
            ++cnt;
            wtTotal += br.getAprioriBranchWt();
        }
        System.out.println("TOTAL: " + cnt);
        System.out.println("WEIGHT SUM: " + wtTotal);
    }
}

