/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.simulatedAnnealing.hpc;

import com.google.common.base.Joiner;
import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Iterables;
import com.google.common.collect.Lists;
import edu.usc.kmilner.mpj.taskDispatch.MPJTaskCalculator;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import mpi.MPI;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.dom4j.Document;
import org.dom4j.DocumentException;
import org.dom4j.Element;
import org.opensha.commons.util.XMLUtils;
import scratch.UCERF3.analysis.MPJDistributedCompoundFSSPlots;
import scratch.UCERF3.inversion.CommandLineInversionRunner;

public class MPJInversionDistributor
extends MPJTaskCalculator {
    private List<String[]> argsList;

    public MPJInversionDistributor(CommandLine cmd, List<String[]> argsList) {
        super(cmd);
        this.argsList = argsList;
    }

    protected int getNumTasks() {
        return this.argsList.size();
    }

    protected void calculateBatch(int[] batch) throws Exception {
        Thread[] threads = new Thread[batch.length];
        for (int i = 0; i < batch.length; ++i) {
            threads[i] = new Thread(new CalculationThread(this.argsList.get(batch[i])));
        }
        for (Thread thread : threads) {
            thread.start();
        }
        for (Thread thread : threads) {
            thread.join();
        }
    }

    protected void doFinalAssembly() throws Exception {
    }

    private static List<String[]> loadXMLInputFile(File file) throws IOException, DocumentException {
        ArrayList argsList = Lists.newArrayList();
        Document doc = XMLUtils.loadDocument(file);
        Element root = doc.getRootElement();
        Element invConfEl = root.element("InversionConfigurations");
        int numArgs = Integer.parseInt(invConfEl.attributeValue("num"));
        while (argsList.size() < numArgs) {
            argsList.add(null);
        }
        Iterator it = invConfEl.elementIterator();
        while (it.hasNext()) {
            int num;
            Element invEl = (Element)it.next();
            String command = invEl.attributeValue("args");
            String[] args = (String[])Iterables.toArray((Iterable)Splitter.on((String)" ").split((CharSequence)command), String.class);
            Preconditions.checkState((args.length == (num = Integer.parseInt(invEl.attributeValue("num"))) ? 1 : 0) != 0, (Object)("Incorrect argument lengh on parse! Expected=" + num + ", actual=" + args.length + ". Command: " + command));
            int index = Integer.parseInt(invEl.attributeValue("index"));
            argsList.set(index, args);
        }
        for (String[] args : argsList) {
            Preconditions.checkNotNull((Object)args, (Object)"Missing args from XML file!");
        }
        return argsList;
    }

    public static void writeXMLInputFile(List<String[]> argsList, File file) throws IOException {
        Document doc = XMLUtils.createDocumentWithRoot();
        Element root = doc.getRootElement();
        Element invConfEl = root.addElement("InversionConfigurations");
        invConfEl.addAttribute("num", "" + argsList.size());
        for (int i = 0; i < argsList.size(); ++i) {
            Object[] args = argsList.get(i);
            Element invEl = invConfEl.addElement("InversionConfiguration");
            for (int j = 0; j < args.length; ++j) {
                args[j] = ((String)args[j]).trim();
            }
            String command = Joiner.on((String)" ").join(args);
            invEl.addAttribute("index", "" + i);
            invEl.addAttribute("args", command);
            invEl.addAttribute("num", "" + args.length);
        }
        XMLUtils.writeDocumentToFile(file, doc);
    }

    public static void main(String[] args) {
        System.out.println("ARGS: " + Joiner.on((String)" ").join((Object[])args));
        args = MPJTaskCalculator.initMPJ((String[])args);
        try {
            Options options = MPJInversionDistributor.createOptions();
            CommandLine cmd = MPJInversionDistributor.parse((Options)options, (String[])args, MPJDistributedCompoundFSSPlots.class);
            args = cmd.getArgs();
            Preconditions.checkArgument((boolean)cmd.hasOption("exact"), (Object)"Must specify exact dispatch!");
            int dispatchNum = Integer.parseInt(cmd.getOptionValue("exact"));
            Preconditions.checkArgument((args.length == 1 ? 1 : 0) != 0, (Object)"Must specify input XML file!");
            File inputFile = new File(args[0]);
            System.out.println("Loading Input File: " + inputFile.getAbsolutePath());
            List<String[]> argsList = MPJInversionDistributor.loadXMLInputFile(inputFile);
            System.out.println("Loaded " + argsList.size() + " inversion args");
            int numNodes = MPI.COMM_WORLD.Size();
            int numInversions = argsList.size();
            int numSlots = numNodes * dispatchNum;
            Preconditions.checkState((numInversions <= numSlots ? 1 : 0) != 0, (Object)("Too few slots! slots=" + numSlots + ", inversions=" + numInversions));
            System.out.println("Launching!");
            MPJInversionDistributor driver = new MPJInversionDistributor(cmd, argsList);
            driver.run();
            MPJInversionDistributor.finalizeMPJ();
            System.exit(0);
        }
        catch (Throwable t) {
            MPJInversionDistributor.abortAndExit((Throwable)t);
        }
    }

    private static class CalculationThread
    implements Runnable {
        private String[] args;

        public CalculationThread(String[] args) {
            this.args = args;
        }

        @Override
        public void run() {
            CommandLineInversionRunner.run(this.args, true);
        }
    }
}

