/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import com.google.common.base.Splitter;
import com.google.common.collect.Lists;
import com.google.common.collect.Maps;
import java.io.BufferedReader;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.sql.SQLException;
import java.text.Collator;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;
import org.apache.poi.hssf.usermodel.HSSFCell;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.poifs.filesystem.POIFSFileSystem;
import org.opensha.commons.data.CSVFile;
import org.opensha.commons.data.function.ArbitrarilyDiscretizedFunc;
import org.opensha.commons.geo.Location;
import org.opensha.commons.geo.LocationList;
import org.opensha.commons.geo.LocationUtils;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.commons.util.FaultUtils;
import org.opensha.refFaultParamDb.dao.db.DB_AccessAPI;
import org.opensha.refFaultParamDb.dao.db.DB_ConnectionPool;
import org.opensha.refFaultParamDb.dao.db.FaultModelDB_DAO;
import org.opensha.refFaultParamDb.dao.db.PrefFaultSectionDataDB_DAO;
import org.opensha.refFaultParamDb.vo.FaultSectionPrefData;
import org.opensha.sha.faultSurface.FaultSection;
import org.opensha.sha.faultSurface.FaultTrace;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.enumTreeBranches.InversionModels;
import scratch.UCERF3.utils.DeformationModelFetcher;
import scratch.UCERF3.utils.FaultSectionDataWriter;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class DeformationModelFileParser {
    private static Map<String, Double> creepData = null;
    private static ArbitrarilyDiscretizedFunc momentReductionConversionFunc = null;

    public static Map<Integer, DeformationSection> load(File file) throws IOException {
        return DeformationModelFileParser.load(file.toURI().toURL());
    }

    public static Map<Integer, DeformationSection> load(URL url) throws IOException {
        CSVFile<String> csv;
        try {
            csv = CSVFile.readURL(url, true);
        }
        catch (RuntimeException e1) {
            System.out.println("Couldn't load: " + String.valueOf(url));
            throw e1;
        }
        HashMap<Integer, DeformationSection> defs = new HashMap<Integer, DeformationSection>();
        for (List<String> list : csv) {
            double rake;
            double slip;
            int[] id = DeformationModelFileParser.parseMinisectionNumber(list.get(0));
            DeformationSection def = defs.get(id[0]);
            if (def == null) {
                def = new DeformationSection(id[0]);
                defs.put(id[0], def);
            }
            double lon1 = Double.parseDouble(list.get(1));
            double lat1 = Double.parseDouble(list.get(2));
            double lon2 = Double.parseDouble(list.get(3));
            double lat2 = Double.parseDouble(list.get(4));
            Location loc1 = new Location(lat1, lon1);
            Location loc2 = new Location(lat2, lon2);
            try {
                slip = Double.parseDouble(list.get(5));
            }
            catch (NumberFormatException e) {
                slip = Double.NaN;
            }
            try {
                rake = Double.parseDouble(list.get(6));
            }
            catch (NumberFormatException e) {
                rake = Double.NaN;
            }
            Preconditions.checkState((def.slips.size() == id[1] - 1 ? 1 : 0) != 0, (Object)("bad row with minisectin: " + list.get(0) + " (parsed as: " + id[0] + ", " + id[1] + ")"));
            def.add(loc1, loc2, slip, rake);
        }
        return defs;
    }

    public static int[] parseMinisectionNumber(String miniSection) {
        String[] split = miniSection.trim().split("\\.");
        int id = Integer.parseInt(split[0]);
        Preconditions.checkState((split.length > 1 && !split[1].isEmpty() ? 1 : 0) != 0, (Object)("Mini section was left blank for " + id + ": " + miniSection));
        Object str = split[1];
        if (((String)str).length() == 1) {
            str = (String)str + "0";
        }
        int section = Integer.parseInt((String)str);
        int[] ret = new int[]{id, section};
        return ret;
    }

    public static String getMinisectionString(int[] miniSection) {
        return DeformationModelFileParser.getMinisectionString(miniSection[0], miniSection[1]);
    }

    public static String getMinisectionString(int parentID, int mini) {
        String str = parentID + ".";
        if (mini < 10) {
            str = str + "0";
        }
        str = str + mini;
        return str;
    }

    public static boolean compareAgainst(Map<Integer, DeformationSection> defs, List<FaultSectionPrefData> datas, List<Integer> fm) throws IOException {
        boolean ret = true;
        HashSet<DeformationSection> dones = new HashSet<DeformationSection>();
        int noneCnt = 0;
        Iterator<Object> iterator = fm.iterator();
        while (iterator.hasNext()) {
            int id = iterator.next();
            DeformationSection def = defs.get(id);
            FaultSectionPrefData data = null;
            for (FaultSectionPrefData myData : datas) {
                if (myData.getSectionId() != id) continue;
                data = myData;
                break;
            }
            Preconditions.checkNotNull(data);
            if (def == null) {
                System.out.println("No def model data for: " + data.getSectionId() + ". " + data.getSectionName());
                ret = false;
                ++noneCnt;
                continue;
            }
            ret = ret && def.validateAgainst(data);
            dones.add(def);
        }
        if (noneCnt > 0) {
            System.out.println("No def model data for: " + noneCnt + " sections");
        }
        for (DeformationSection def : defs.values()) {
            if (dones.contains(def)) continue;
            System.out.println("No fault exists for def model section of id: " + def.id);
            ret = false;
        }
        return ret;
    }

    public static void write(Map<Integer, DeformationSection> model, File file) throws IOException {
        DeformationModelFileParser.write(model.values(), file);
    }

    public static void write(Collection<DeformationSection> model, File file) throws IOException {
        DeformationModelFileParser.write(model, file, null);
    }

    public static void write(Collection<DeformationSection> model, File file, Map<Integer, String> namesMap) throws IOException {
        CSVFile csv = new CSVFile(true);
        for (DeformationSection def : model) {
            List<Location> locs1 = def.getLocs1();
            List<Location> locs2 = def.getLocs2();
            List<Double> slips = def.getSlips();
            List<Double> rakes = def.getRakes();
            for (int i = 0; i < slips.size(); ++i) {
                int[] mini = new int[]{def.getId(), i + 1};
                String id = DeformationModelFileParser.getMinisectionString(mini);
                ArrayList<Object> line = new ArrayList<Object>();
                line.add(id);
                line.add("" + (float)locs1.get(i).getLongitude());
                line.add("" + (float)locs1.get(i).getLatitude());
                line.add("" + (float)locs2.get(i).getLongitude());
                line.add("" + (float)locs2.get(i).getLatitude());
                line.add("" + slips.get(i).floatValue());
                line.add("" + rakes.get(i).floatValue());
                if (namesMap != null) {
                    line.add(namesMap.get(def.id));
                }
                csv.addLine(line);
            }
        }
        csv.writeToFile(file);
    }

    private static <E> E getFromEnd(List<E> list, int numFromEnd) {
        return list.get(list.size() - 1 - numFromEnd);
    }

    private static void fixForRevisedFM(Map<Integer, DeformationSection> sects, FaultModels fm) {
        int i;
        ArrayList<FaultSection> datas = fm.fetchFaultSections(true);
        HashMap fmMap = Maps.newHashMap();
        for (FaultSection data : datas) {
            fmMap.put(data.getSectionId(), data);
        }
        FaultSection data = (FaultSection)fmMap.get(667);
        FaultTrace trace = data.getFaultTrace();
        DeformationSection sect = sects.get(667);
        sect.add(DeformationModelFileParser.getFromEnd(trace, 1), DeformationModelFileParser.getFromEnd(trace, 0), DeformationModelFileParser.getFromEnd(sect.getSlips(), 0), DeformationModelFileParser.getFromEnd(sect.getRakes(), 0));
        sect = sects.get(74);
        ArrayList slipsForOceanic = Lists.newArrayList();
        ArrayList rakesForOceanic = Lists.newArrayList();
        for (int i2 = sect.getSlips().size() - 4; i2 < sect.getSlips().size(); ++i2) {
            slipsForOceanic.add(sect.getSlips().get(i2));
            rakesForOceanic.add(sect.getRakes().get(i2));
        }
        sect.remove(sect.getSlips().size() - 1);
        sect.remove(sect.getSlips().size() - 1);
        sect.remove(sect.getSlips().size() - 1);
        data = (FaultSection)fmMap.get(82);
        sect = sects.get(82);
        trace = data.getFaultTrace();
        sect.remove(0);
        double slip = FaultUtils.getLengthBasedAngleAverage(sect.getLocsAsTrace().subList(0, 3), sect.getSlips().subList(0, 2));
        double rake = FaultUtils.getLengthBasedAngleAverage(sect.getLocsAsTrace().subList(0, 3), sect.getRakes().subList(0, 2));
        sect.remove(0);
        sect.remove(0);
        sect.remove(0);
        sect.add(0, (Location)trace.get(0), (Location)trace.get(1), slip, rake);
        sect.add(1, (Location)trace.get(1), (Location)trace.get(2), slip, rake);
        sect.add(2, (Location)trace.get(2), (Location)trace.get(3), slip, rake);
        sect.add(3, (Location)trace.get(3), (Location)trace.get(4), slip, rake);
        data = (FaultSection)fmMap.get(687);
        sect = sects.get(687);
        trace = data.getFaultTrace();
        slip = DeformationModelFileParser.getFromEnd(sect.getSlips(), 0);
        rake = DeformationModelFileParser.getFromEnd(sect.getRakes(), 0);
        sect.remove(sect.getSlips().size() - 1);
        sect.add(DeformationModelFileParser.getFromEnd(trace, 2), DeformationModelFileParser.getFromEnd(trace, 1), slip, rake);
        sect.add(DeformationModelFileParser.getFromEnd(trace, 1), DeformationModelFileParser.getFromEnd(trace, 0), slip, rake);
        sect.getLocs1().set(0, (Location)trace.get(0));
        sect.getLocs2().set(0, (Location)trace.get(1));
        data = (FaultSection)fmMap.get(709);
        sect = sects.get(709);
        trace = data.getFaultTrace();
        sect.add(0, (Location)trace.get(0), (Location)trace.get(1), (Double)DeformationModelFileParser.getFromEnd(slipsForOceanic, 0), (Double)DeformationModelFileParser.getFromEnd(rakesForOceanic, 0));
        sect.add(1, (Location)trace.get(1), (Location)trace.get(2), (Double)DeformationModelFileParser.getFromEnd(slipsForOceanic, 1), (Double)DeformationModelFileParser.getFromEnd(rakesForOceanic, 1));
        sect.add(2, (Location)trace.get(2), (Location)trace.get(3), (Double)DeformationModelFileParser.getFromEnd(slipsForOceanic, 2), (Double)DeformationModelFileParser.getFromEnd(rakesForOceanic, 2));
        data = (FaultSection)fmMap.get(123);
        sect = sects.get(123);
        trace = data.getFaultTrace();
        for (i = 1; i < trace.size(); ++i) {
            sect.getLocs1().set(i - 1, (Location)trace.get(i - 1));
            sect.getLocs2().set(i - 1, (Location)trace.get(i));
        }
        data = (FaultSection)fmMap.get(113);
        sect = sects.get(113);
        trace = data.getFaultTrace();
        for (i = 1; i < trace.size(); ++i) {
            sect.getLocs1().set(i - 1, (Location)trace.get(i - 1));
            sect.getLocs2().set(i - 1, (Location)trace.get(i));
        }
        sects.remove(182);
    }

    private static synchronized void loadMomentReductionsData() throws IOException {
        if (creepData == null) {
            momentReductionConversionFunc = new ArbitrarilyDiscretizedFunc();
            BufferedReader convReader = new BufferedReader(UCERF3_DataUtils.getReader("creep", "moment-reductions-conversion-table-2012_06_08.txt"));
            convReader.readLine();
            String line = convReader.readLine();
            while (line != null) {
                if ((line = line.trim()).isEmpty()) continue;
                ArrayList vals = Lists.newArrayList((Iterable)Splitter.on((String)"\t").split((CharSequence)line));
                double x = Double.parseDouble((String)vals.get(0));
                double y = Double.parseDouble((String)vals.get(1));
                momentReductionConversionFunc.set(x, y);
                line = convReader.readLine();
            }
            String creepFileName = "creep-by-minisection-2012_12_27.xls";
            InputStream is = UCERF3_DataUtils.locateResourceAsStream("creep", creepFileName);
            POIFSFileSystem fs = new POIFSFileSystem(is);
            HSSFWorkbook wb = new HSSFWorkbook(fs);
            HSSFSheet sheet = wb.getSheetAt(0);
            int lastRowIndex = sheet.getLastRowNum();
            creepData = new HashMap<String, Double>();
            for (int r = 1; r <= lastRowIndex; ++r) {
                HSSFCell miniCell;
                HSSFRow row = sheet.getRow(r);
                if (row == null || (miniCell = row.getCell(1)) == null) continue;
                Object miniSection = miniCell.getCellType() == 0 ? "" + (float)miniCell.getNumericCellValue() : miniCell.getStringCellValue();
                HSSFCell dataCell = row.getCell(2);
                Preconditions.checkState((dataCell.getCellType() == 0 ? 1 : 0) != 0, (Object)"non numeric data cell!");
                double creep = dataCell.getNumericCellValue();
                creepData.put((String)miniSection, creep);
            }
        }
    }

    public static void applyMomentReductions(Map<Integer, DeformationSection> model, double maxMomentReduction) {
        try {
            DeformationModelFileParser.loadMomentReductionsData();
        }
        catch (IOException e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        for (String miniSectionStr : creepData.keySet()) {
            double creep = creepData.get(miniSectionStr);
            int[] miniSection = DeformationModelFileParser.parseMinisectionNumber(miniSectionStr);
            int id = miniSection[0];
            int sect = miniSection[1];
            DeformationSection def = model.get(id);
            Preconditions.checkNotNull((Object)def, (Object)("The given deformation model doesn't have a mapping for section " + id));
            int numMinisForSection = def.getSlips().size();
            if (def.momentReductions == null) {
                def.momentReductions = new ArrayList<Double>(numMinisForSection);
                for (int i = 0; i < numMinisForSection; ++i) {
                    def.momentReductions.add(0.0);
                }
            }
            Preconditions.checkState((sect <= numMinisForSection ? 1 : 0) != 0, (Object)("Mini sections inconsistant for section: " + id));
            double slip = def.getSlips().get(sect - 1);
            double creepOverSlip = creep / slip;
            double momentRecution = creepOverSlip > momentReductionConversionFunc.getMaxX() ? 1.0 : momentReductionConversionFunc.getClosestYtoX(creepOverSlip);
            if (momentRecution <= maxMomentReduction) {
                def.momentReductions.set(sect - 1, momentRecution);
                continue;
            }
            def.momentReductions.set(sect - 1, maxMomentReduction);
        }
    }

    static void writeFromDatabase(FaultModels fm, File file, boolean names) throws IOException {
        int fmID = fm.getID();
        DB_AccessAPI db = fm.getDBAccess();
        PrefFaultSectionDataDB_DAO pref2db = new PrefFaultSectionDataDB_DAO(db);
        ArrayList<FaultSectionPrefData> datas = pref2db.getAllFaultSectionPrefData();
        FaultModelDB_DAO fm2db = new FaultModelDB_DAO(db);
        ArrayList<Integer> faultSectionIds = fm2db.getFaultSectionIdList(fmID);
        ArrayList<FaultSectionPrefData> faultModel = new ArrayList<FaultSectionPrefData>();
        for (FaultSectionPrefData data : datas) {
            if (!faultSectionIds.contains(data.getSectionId())) continue;
            faultModel.add(data);
        }
        if (names) {
            Collections.sort(faultModel, new Comparator<FaultSectionPrefData>(){
                private Collator c = Collator.getInstance();

                @Override
                public int compare(FaultSectionPrefData o1, FaultSectionPrefData o2) {
                    return this.c.compare(o1.getSectionName(), o2.getSectionName());
                }
            });
        } else {
            Collections.sort(faultModel, new Comparator<FaultSectionPrefData>(){

                @Override
                public int compare(FaultSectionPrefData o1, FaultSectionPrefData o2) {
                    return Double.compare(o1.getSectionId(), o2.getSectionId());
                }
            });
        }
        ArrayList<DeformationSection> sects = new ArrayList<DeformationSection>();
        HashMap namesMap = names ? Maps.newHashMap() : null;
        for (FaultSectionPrefData data : faultModel) {
            DeformationSection sect = new DeformationSection(data.getSectionId());
            double slip = data.getOrigAveSlipRate();
            double rake = data.getAveRake();
            FaultTrace trace = data.getFaultTrace();
            for (int i = 1; i < trace.size(); ++i) {
                sect.add((Location)trace.get(i - 1), (Location)trace.get(i), slip, rake);
            }
            if (namesMap != null) {
                namesMap.put(data.getSectionId(), data.getSectionName());
            }
            sects.add(sect);
        }
        DeformationModelFileParser.write(sects, file, namesMap);
        File asciiFile = new File(file.getParentFile(), file.getName().replaceAll(".csv", ".txt"));
        FaultSectionDataWriter.writeSectionsToFile(faultModel, null, asciiFile.getAbsolutePath());
        try {
            db.destroy();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void writeSlipCreepTable(File file, FaultModels fm) throws IOException {
        DeformationModelFileParser.loadMomentReductionsData();
        List<DeformationModels> dms = DeformationModels.forFaultModel(fm);
        CSVFile csv = new CSVFile(true);
        ArrayList header = Lists.newArrayList((Object[])new String[]{"Minisection ID", "Name", "Creep Rate"});
        ArrayList sectsList = Lists.newArrayList();
        HashMap namesMap = Maps.newHashMap();
        for (FaultSection sect : fm.getFaultSections()) {
            namesMap.put(sect.getSectionId(), sect.getSectionName());
        }
        for (int i = 0; i < dms.size(); ++i) {
            DeformationModels dm = dms.get(i);
            if (dm.getRelativeWeight(null) == 0.0 && dm != DeformationModels.GEOLOGIC_LOWER && dm != DeformationModels.GEOLOGIC_UPPER) continue;
            header.add(dm.getName());
            Map<Integer, DeformationSection> sects = DeformationModelFileParser.load(dm.getDataFileURL(fm));
            DeformationModelFileParser.applyMomentReductions(sects, 10.0);
            sectsList.add(sects);
        }
        csv.addLine(header);
        ArrayList keys = Lists.newArrayList();
        for (Integer key : ((Map)sectsList.get(0)).keySet()) {
            keys.add(key);
        }
        Collections.sort(keys);
        HashMap creepMap = Maps.newHashMap();
        for (String key : creepData.keySet()) {
            int[] miniSection = DeformationModelFileParser.parseMinisectionNumber(key);
            int id = miniSection[0];
            int sect = miniSection[1];
            List creepVals = (List)creepMap.get(id);
            if (creepVals == null) {
                creepVals = Lists.newArrayList();
                for (int i = 0; i < ((DeformationSection)((Map)sectsList.get(0)).get(id)).getSlips().size(); ++i) {
                    creepVals.add(0.0);
                }
                creepMap.put(id, creepVals);
            }
            creepVals.set(sect - 1, creepData.get(key));
        }
        for (Integer id : keys) {
            List creep = (List)creepMap.get(id);
            ArrayList dmSects = Lists.newArrayList();
            for (Map sects : sectsList) {
                dmSects.add((DeformationSection)sects.get(id));
            }
            for (int i = 0; i < ((DeformationSection)((Map)sectsList.get(0)).get(id)).getSlips().size(); ++i) {
                int[] miniSection = new int[]{id, i + 1};
                ArrayList line = Lists.newArrayList((Object[])new String[]{DeformationModelFileParser.getMinisectionString(miniSection), (String)namesMap.get(id)});
                if (creep == null) {
                    line.add("");
                } else {
                    line.add(String.valueOf(creep.get(i)));
                }
                for (DeformationSection sect : dmSects) {
                    line.add(String.valueOf(sect.getSlips().get(i)));
                }
                csv.addLine(line);
            }
        }
        csv.writeToFile(file);
        csv.writeToTabSeparatedFile(new File(file.getParentFile(), file.getName().replaceAll(".csv", ".txt")), 1);
    }

    private static void writeCreepReductionsTable(File file, FaultModels fm) throws IOException {
        List<DeformationModels> dms = DeformationModels.forFaultModel(fm);
        CSVFile csv = new CSVFile(true);
        ArrayList header = Lists.newArrayList((Object[])new String[]{"Minisection ID", "Name", "Creep Rate"});
        ArrayList sectsList = Lists.newArrayList();
        final HashMap namesMap = Maps.newHashMap();
        for (FaultSection sect : fm.getFaultSections()) {
            namesMap.put(sect.getSectionId(), sect.getSectionName());
        }
        for (int i = 0; i < dms.size(); ++i) {
            DeformationModels dm = dms.get(i);
            if (dm == DeformationModels.GEOLOGIC_LOWER || dm == DeformationModels.GEOLOGIC_UPPER || dm == DeformationModels.MEAN_UCERF3 || dm.getRelativeWeight(InversionModels.CHAR_CONSTRAINED) == 0.0) continue;
            System.out.println("DM: " + String.valueOf(dm));
            header.add(dm.getShortName() + " Slip");
            header.add(dm.getShortName() + " Moment Reduction");
            Map<Integer, DeformationSection> sects = DeformationModelFileParser.load(dm.getDataFileURL(fm));
            DeformationModelFileParser.applyMomentReductions(sects, 10.0);
            sectsList.add(sects);
        }
        csv.addLine(header);
        ArrayList keys = Lists.newArrayList();
        for (String key : creepData.keySet()) {
            keys.add(key);
        }
        Collections.sort(keys, new Comparator<String>(){
            private Collator c = Collator.getInstance();

            @Override
            public int compare(String o1, String o2) {
                String name2;
                int[] miniSection1 = DeformationModelFileParser.parseMinisectionNumber(o1);
                int[] miniSection2 = DeformationModelFileParser.parseMinisectionNumber(o2);
                String name1 = (String)namesMap.get(miniSection1[0]);
                int ret = this.c.compare(name1, name2 = (String)namesMap.get(miniSection2[0]));
                if (ret == 0) {
                    ret = Double.compare(miniSection1[1], miniSection2[1]);
                }
                return ret;
            }
        });
        for (String miniSectionStr : keys) {
            double creep = creepData.get(miniSectionStr);
            int[] miniSection = DeformationModelFileParser.parseMinisectionNumber(miniSectionStr);
            int id = miniSection[0];
            int sect = miniSection[1];
            ArrayList line = Lists.newArrayList((Object[])new String[]{DeformationModelFileParser.getMinisectionString(miniSection), (String)namesMap.get(id), "" + creep});
            for (int i = 0; i < sectsList.size(); ++i) {
                DeformationSection def = (DeformationSection)((Map)sectsList.get(i)).get(id);
                double momRed = def.getMomentReductions().get(sect - 1);
                if (momRed > 0.95) {
                    momRed = 0.95;
                }
                double slip = def.getSlips().get(sect - 1);
                line.add("" + slip);
                line.add("" + momRed);
            }
            csv.addLine(line);
        }
        csv.writeToFile(file);
        csv.writeToTabSeparatedFile(new File(file.getParentFile(), file.getName().replaceAll(".csv", ".txt")), 1);
    }

    public static Map<Integer, DeformationSection> loadMeanUCERF3_DM(FaultModels fm) throws IOException {
        ArrayList weights = Lists.newArrayList();
        ArrayList models = Lists.newArrayList();
        Map<Integer, DeformationSection> rakeBasis = null;
        Set<Integer> parentIDs = null;
        double weightSum = 0.0;
        for (DeformationModels dm : DeformationModels.values()) {
            double weight = dm.getRelativeWeight(null);
            if (!(weight > 0.0)) continue;
            weights.add(weight);
            Map<Integer, DeformationSection> model = DeformationModelFileParser.load(dm.getDataFileURL(fm));
            models.add(model);
            if (parentIDs == null) {
                parentIDs = model.keySet();
            } else {
                Preconditions.checkState((parentIDs.size() == model.size() ? 1 : 0) != 0, (Object)"DM's have different numbers of parents");
            }
            if (dm == DeformationModels.GEOLOGIC) {
                rakeBasis = model;
            }
            weightSum += weight;
        }
        if (weightSum != 1.0) {
            for (int i = 0; i < weights.size(); ++i) {
                weights.set(i, (Double)weights.get(i) / weightSum);
            }
        }
        Preconditions.checkNotNull(rakeBasis, (Object)"Is geologic zero weight? We need it for rakes...");
        HashMap mean = Maps.newHashMap();
        for (Integer parentID : parentIDs) {
            int i;
            DeformationSection sect = new DeformationSection(parentID);
            DeformationSection sectRakeBasis = (DeformationSection)rakeBasis.get(parentID);
            int numMinis = sectRakeBasis.getSlips().size();
            for (i = 0; i < numMinis; ++i) {
                sect.add(sectRakeBasis.getLocs1().get(i), sectRakeBasis.getLocs2().get(i), 0.0, sectRakeBasis.getRakes().get(i));
            }
            for (i = 0; i < weights.size(); ++i) {
                DeformationSection oSect = (DeformationSection)((Map)models.get(i)).get(parentID);
                double weight = (Double)weights.get(i);
                for (int j = 0; j < numMinis; ++j) {
                    double slip = oSect.slips.get(j);
                    if (Double.isNaN(slip)) {
                        slip = 0.0;
                    }
                    sect.slips.set(j, sect.slips.get(j) + weight * slip);
                }
            }
            mean.put(parentID, sect);
        }
        return mean;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        DeformationModelFileParser.writeSlipCreepTable(new File("/tmp/slips_creep.csv"), FaultModels.FM3_1);
        DeformationModelFileParser.writeCreepReductionsTable(new File("/tmp/new_creep_data.csv"), FaultModels.FM3_1);
        System.exit(0);
        FaultModels[] fms = new FaultModels[]{FaultModels.FM3_1, FaultModels.FM3_2};
        DB_AccessAPI db = DB_ConnectionPool.getDB3ReadOnlyConn();
        PrefFaultSectionDataDB_DAO pref2db = new PrefFaultSectionDataDB_DAO(db);
        FaultModelDB_DAO fm2db = new FaultModelDB_DAO(db);
        ArrayList<FaultSectionPrefData> datas = pref2db.getAllFaultSectionPrefData();
        for (FaultModels fm : fms) {
            ArrayList<Integer> fmSects = fm2db.getFaultSectionIdList(fm.getID());
            for (DeformationModels dm : DeformationModels.forFaultModel(fm)) {
                if (dm.getRelativeWeight(null) == 0.0) continue;
                Map<Integer, DeformationSection> sects = DeformationModelFileParser.load(dm.getDataFileURL(fm));
                System.out.println("TESTING " + String.valueOf(fm) + " : " + String.valueOf(dm));
                boolean success = DeformationModelFileParser.compareAgainst(sects, datas, fmSects);
                System.out.println("VALIDATED??? " + success);
                int nanSlips = 0;
                int nanRakes = 0;
                int zeroSlips = 0;
                for (DeformationSection sect : sects.values()) {
                    for (double slip : sect.getSlips()) {
                        if (!Double.isNaN(slip)) continue;
                        ++nanSlips;
                    }
                    for (double slip : sect.getSlips()) {
                        if (slip != 0.0) continue;
                        ++zeroSlips;
                    }
                    for (double rake : sect.getRakes()) {
                        if (!Double.isNaN(rake)) continue;
                        ++nanRakes;
                    }
                }
                System.out.println("NaNs: " + nanSlips + " slips, " + nanRakes + " rakes");
                System.out.println("Zeros Slips: " + zeroSlips);
                try {
                    new DeformationModelFetcher(fm, dm, UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, 0.1);
                }
                catch (Exception e) {
                    System.out.println(String.valueOf(dm) + " failed!");
                    e.printStackTrace();
                }
            }
        }
        System.exit(0);
        File precomputedDataDir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR, "FaultSystemRupSets");
        try {
            File defFile;
            FaultModels fm = FaultModels.FM3_2;
            ArrayList<Integer> fmSects = fm2db.getFaultSectionIdList(fm.getID());
            File dir = new File(UCERF3_DataUtils.DEFAULT_SCRATCH_DATA_DIR.getParentFile(), "DeformationModels");
            for (DeformationModels dm : DeformationModels.forFaultModel(fm)) {
                if (dm == DeformationModels.GEOLOGIC) continue;
                Object name = dm.getDataFileName(fm);
                defFile = new File(dir, (String)name);
                System.out.println("******** FIXING " + String.valueOf(dm));
                Map<Integer, DeformationSection> defs = DeformationModelFileParser.load(defFile);
                boolean success = DeformationModelFileParser.compareAgainst(defs, datas, fmSects);
                if (success) continue;
                System.out.println("ok lets fix it...");
                DeformationModelFileParser.fixForRevisedFM(defs, fm);
                success = DeformationModelFileParser.compareAgainst(defs, datas, fmSects);
                Preconditions.checkState((boolean)success, (Object)"...still couldn't fix it :-(");
                if (((String)name).contains("2012_")) {
                    name = ((String)name).substring(0, ((String)name).indexOf("2012"));
                    name = (String)name + "_MAPPED_2012_06_05.csv";
                }
                DeformationModelFileParser.write(defs, new File(dir, (String)name));
            }
            System.exit(0);
            defFile = new File(dir, "geologic_slip_rake_2012_03_02.csv");
            Map<Integer, DeformationSection> defs = DeformationModelFileParser.load(defFile);
            DeformationModelFileParser.compareAgainst(defs, datas, fmSects);
            System.out.println("ok lets fix it...");
            DeformationModelFileParser.fixForRevisedFM(defs, fm);
            DeformationModelFileParser.compareAgainst(defs, datas, fmSects);
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        finally {
            try {
                db.destroy();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
        System.exit(0);
    }

    public static class DeformationSection {
        private int id;
        private List<Location> locs1;
        private List<Location> locs2;
        private List<Double> slips;
        private List<Double> rakes;
        private List<Double> momentReductions;

        public int getId() {
            return this.id;
        }

        protected void setID(int id) {
            this.id = id;
        }

        public List<Location> getLocs1() {
            return this.locs1;
        }

        public List<Location> getLocs2() {
            return this.locs2;
        }

        public List<Double> getSlips() {
            return this.slips;
        }

        public List<Double> getRakes() {
            return this.rakes;
        }

        public DeformationSection(int id) {
            this.id = id;
            this.locs1 = new ArrayList<Location>();
            this.locs2 = new ArrayList<Location>();
            this.slips = new ArrayList<Double>();
            this.rakes = new ArrayList<Double>();
        }

        public void add(Location loc1, Location loc2, double slip, double rake) {
            this.locs1.add(loc1);
            this.locs2.add(loc2);
            this.slips.add(slip);
            this.rakes.add(rake);
        }

        public void add(int index, Location loc1, Location loc2, double slip, double rake) {
            this.locs1.add(index, loc1);
            this.locs2.add(index, loc2);
            this.slips.add(index, slip);
            this.rakes.add(index, rake);
        }

        public void remove(int index) {
            this.locs1.remove(index);
            this.locs2.remove(index);
            this.slips.remove(index);
            this.rakes.remove(index);
        }

        public void setMomentReductions(List<Double> momentReductions) {
            Preconditions.checkState((momentReductions.size() == this.slips.size() ? 1 : 0) != 0, (Object)"Size of moment reductions must match that of the slips");
        }

        public List<Double> getMomentReductions() {
            return this.momentReductions;
        }

        public LocationList getLocsAsTrace() {
            LocationList trace = new LocationList();
            trace.addAll(this.locs1);
            trace.add(this.locs2.get(this.locs2.size() - 1));
            return trace;
        }

        public boolean validateAgainst(FaultSectionPrefData data) {
            int i;
            String nameID = this.id + ". " + data.getName();
            boolean mismatch = false;
            FaultTrace trace = data.getFaultTrace();
            if (trace.size() - 1 != this.locs1.size()) {
                System.out.println(nameID + ": trace size mismatch (" + trace.getNumLocations() + " trace pts, " + this.locs1.size() + " slip vals)");
                mismatch = true;
            }
            LocationList fileLocs = this.getLocsAsTrace();
            for (i = 0; i < fileLocs.size() && i < trace.size(); ++i) {
                double dist = LocationUtils.horzDistance((Location)fileLocs.get(i), (Location)trace.get(i));
                if (!(dist > 0.5)) continue;
                System.out.println(nameID + ": trace location mismatch at index " + i + "/" + (fileLocs.size() - 1));
                mismatch = true;
            }
            if (mismatch) {
                for (i = 0; i < fileLocs.size(); ++i) {
                    Location loc = (Location)fileLocs.get(i);
                    System.out.print("[" + (float)loc.getLatitude() + "\t" + (float)loc.getLongitude() + "\t0]");
                    if (trace.size() > i) {
                        Location traceLoc = (Location)trace.get(i);
                        System.out.print("\t[" + (float)traceLoc.getLatitude() + "\t" + (float)traceLoc.getLongitude() + "\t0]");
                        System.out.print("\tdist: " + (float)LocationUtils.linearDistanceFast(loc, traceLoc));
                    }
                    System.out.println();
                }
            }
            if (mismatch) {
                return false;
            }
            double dist1 = LocationUtils.horzDistance(this.locs1.get(0), (Location)trace.get(0));
            if (dist1 > 1.0) {
                System.out.println(nameID + ": start trace location mismatch (" + dist1 + " km)");
                return false;
            }
            double dist2 = LocationUtils.horzDistance(this.locs2.get(this.locs2.size() - 1), (Location)trace.get(trace.size() - 1));
            if (dist2 > 1.0) {
                System.out.println(nameID + ": end trace location mismatch (" + dist2 + " km)");
                return false;
            }
            for (int i2 = 1; i2 < this.locs2.size(); ++i2) {
                if (LocationUtils.areSimilar(this.locs1.get(i2), this.locs2.get(i2 - 1))) continue;
                System.out.println(nameID + ": trace locations inconsistant in def model!");
                for (int j = 0; j < this.locs1.size(); ++j) {
                    System.out.print("[" + (float)this.locs1.get(j).getLatitude() + "\t" + (float)this.locs1.get(j).getLongitude() + "\t0]");
                    System.out.println("\t[" + (float)this.locs2.get(j).getLatitude() + "\t" + (float)this.locs2.get(j).getLongitude() + "\t0]");
                }
                return false;
            }
            return true;
        }
    }
}

