/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import com.google.common.collect.Lists;
import java.io.BufferedReader;
import java.io.IOException;
import java.util.ArrayList;
import org.apache.commons.lang3.StringUtils;
import org.opensha.commons.data.region.CaliforniaRegions;
import org.opensha.commons.data.xyz.GriddedGeoDataSet;
import org.opensha.commons.geo.Location;
import org.opensha.commons.util.ExceptionUtils;
import org.opensha.sha.earthquake.calc.ERF_Calculator;
import org.opensha.sha.earthquake.rupForecastImpl.WGCEP_UCERF_2_Final.UCERF2;
import scratch.UCERF3.analysis.DeformationModelsCalc;
import scratch.UCERF3.analysis.GMT_CA_Maps;
import scratch.UCERF3.enumTreeBranches.DeformationModels;
import scratch.UCERF3.enumTreeBranches.FaultModels;
import scratch.UCERF3.utils.ModUCERF2.ModMeanUCERF2;
import scratch.UCERF3.utils.RELM_RegionUtils;
import scratch.UCERF3.utils.UCERF3_DataUtils;

public class DeformationModelOffFaultMoRateData {
    private static DeformationModelOffFaultMoRateData data;
    public static final String SUBDIR = "DeformationModels";
    public static final String FILENAME_FM3_1 = "gridded_moment_fm_3_1_jan14_2013_combined.txt";
    public static final String FILENAME_FM3_2 = "gridded_moment_fm_3_2_jan14_2013_combined.txt";
    public static final double KAJ_SEISMO_THICKNESS = 11.0;
    public static final double REVISED_SEISMO_THICKNESS = 11.0;
    public static final double NEOK_ZERO_VALS;
    static final CaliforniaRegions.RELM_TESTING_GRIDDED griddedRegion;
    GriddedGeoDataSet neok_Fm3pt1_xyzData;
    GriddedGeoDataSet zeng_b_bound_Fm3pt1_xyzData;
    GriddedGeoDataSet zeng_orig_Fm3pt1_xyzData;
    GriddedGeoDataSet abm_Fm3pt1_xyzData;
    GriddedGeoDataSet geol_Fm3pt1_xyzData;
    GriddedGeoDataSet abmPlusGeol_Fm3pt1_xyzData;
    GriddedGeoDataSet neok_Fm3pt2_xyzData;
    GriddedGeoDataSet zeng_b_bound_Fm3pt2_xyzData;
    GriddedGeoDataSet zeng_orig_Fm3pt2_xyzData;
    GriddedGeoDataSet abm_Fm3pt2_xyzData;
    GriddedGeoDataSet geol_Fm3pt2_xyzData;
    GriddedGeoDataSet abmPlusGeol_Fm3pt2_xyzData;

    public static DeformationModelOffFaultMoRateData getInstance() {
        if (data == null) {
            data = new DeformationModelOffFaultMoRateData();
        }
        return data;
    }

    private DeformationModelOffFaultMoRateData() {
        this.readDefModelGridData();
    }

    private void makeGeolData() {
        int i;
        FaultModels fm = FaultModels.FM3_1;
        DeformationModels dm = DeformationModels.ABM;
        double assumedTotalMoRate = DeformationModelsCalc.calcFaultMoRateForDefModel(fm, dm, true) + this.getTotalOffFaultMomentRate(fm, dm);
        double geolMoRate = assumedTotalMoRate - DeformationModelsCalc.calcFaultMoRateForDefModel(fm, DeformationModels.GEOLOGIC, true);
        this.geol_Fm3pt1_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        int numPts = this.geol_Fm3pt1_xyzData.size();
        for (i = 0; i < numPts; ++i) {
            this.geol_Fm3pt1_xyzData.set(i, geolMoRate / (double)numPts);
        }
        this.abmPlusGeol_Fm3pt1_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        for (i = 0; i < numPts; ++i) {
            this.abmPlusGeol_Fm3pt1_xyzData.set(i, (this.geol_Fm3pt1_xyzData.get(i) + this.abm_Fm3pt1_xyzData.get(i)) / 2.0);
        }
        fm = FaultModels.FM3_2;
        dm = DeformationModels.ABM;
        assumedTotalMoRate = DeformationModelsCalc.calcFaultMoRateForDefModel(fm, dm, true) + this.getTotalOffFaultMomentRate(fm, dm);
        geolMoRate = assumedTotalMoRate - DeformationModelsCalc.calcFaultMoRateForDefModel(fm, DeformationModels.GEOLOGIC, true);
        this.geol_Fm3pt2_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        numPts = this.geol_Fm3pt2_xyzData.size();
        for (i = 0; i < numPts; ++i) {
            this.geol_Fm3pt2_xyzData.set(i, geolMoRate / (double)numPts);
        }
        this.abmPlusGeol_Fm3pt2_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        for (i = 0; i < numPts; ++i) {
            this.abmPlusGeol_Fm3pt2_xyzData.set(i, (this.geol_Fm3pt2_xyzData.get(i) + this.abm_Fm3pt2_xyzData.get(i)) / 2.0);
        }
    }

    public double getTotalOffFaultMomentRate(FaultModels fm, DeformationModels dm) {
        if (dm == DeformationModels.UCERF2_ALL) {
            return 5.4E18;
        }
        double total = 0.0;
        GriddedGeoDataSet data = this.getDefModSpatialOffFaultMoRates(fm, dm);
        for (int i = 0; i < data.size(); ++i) {
            total += data.get(i);
        }
        return total;
    }

    private void readDefModelGridData() {
        int index;
        Location loc;
        String[] st;
        String line;
        int l;
        BufferedReader reader;
        this.neok_Fm3pt1_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        this.zeng_orig_Fm3pt1_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        this.zeng_b_bound_Fm3pt1_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        this.abm_Fm3pt1_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        this.neok_Fm3pt2_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        this.zeng_orig_Fm3pt2_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        this.zeng_b_bound_Fm3pt2_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        this.abm_Fm3pt2_xyzData = new GriddedGeoDataSet(griddedRegion, true);
        double CONVERSION = 1.0;
        try {
            reader = new BufferedReader(UCERF3_DataUtils.getReader(SUBDIR, FILENAME_FM3_1));
            l = -1;
            while ((line = reader.readLine()) != null) {
                if (++l == 0) continue;
                st = StringUtils.split((String)line, (String)",");
                loc = new Location(Double.valueOf(st[0]), Double.valueOf(st[1]));
                index = griddedRegion.indexForLocation(loc);
                this.neok_Fm3pt1_xyzData.set(index, Math.pow(10.0, Double.valueOf(st[2])) * CONVERSION);
                this.zeng_b_bound_Fm3pt1_xyzData.set(index, Math.pow(10.0, Double.valueOf(st[3])) * CONVERSION);
                this.zeng_orig_Fm3pt1_xyzData.set(index, Math.pow(10.0, Double.valueOf(st[4])) * CONVERSION);
                this.abm_Fm3pt1_xyzData.set(index, Math.pow(10.0, Double.valueOf(st[5])) * CONVERSION);
            }
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
        try {
            reader = new BufferedReader(UCERF3_DataUtils.getReader(SUBDIR, FILENAME_FM3_2));
            l = -1;
            while ((line = reader.readLine()) != null) {
                if (++l == 0) continue;
                st = StringUtils.split((String)line, (String)",");
                loc = new Location(Double.valueOf(st[0]), Double.valueOf(st[1]));
                index = griddedRegion.indexForLocation(loc);
                this.neok_Fm3pt2_xyzData.set(index, Math.pow(10.0, Double.valueOf(st[2])) * CONVERSION);
                this.zeng_b_bound_Fm3pt2_xyzData.set(index, Math.pow(10.0, Double.valueOf(st[3])) * CONVERSION);
                this.zeng_orig_Fm3pt2_xyzData.set(index, Math.pow(10.0, Double.valueOf(st[4])) * CONVERSION);
                this.abm_Fm3pt2_xyzData.set(index, Math.pow(10.0, Double.valueOf(st[5])) * CONVERSION);
            }
        }
        catch (Exception e) {
            ExceptionUtils.throwAsRuntimeException(e);
        }
    }

    public GriddedGeoDataSet getAveDefModelSpatialOffFaultMoRates(FaultModels fm, boolean includeGeologic) {
        GriddedGeoDataSet abm_xyzData;
        GriddedGeoDataSet zeng_b_bound_xyzData;
        GriddedGeoDataSet neok_xyzData;
        GriddedGeoDataSet aveData = new GriddedGeoDataSet(griddedRegion, true);
        GriddedGeoDataSet geol_xyzData = null;
        if (fm == FaultModels.FM3_1) {
            neok_xyzData = this.neok_Fm3pt1_xyzData;
            zeng_b_bound_xyzData = this.zeng_b_bound_Fm3pt1_xyzData;
            abm_xyzData = this.abm_Fm3pt1_xyzData;
            if (includeGeologic) {
                if (this.geol_Fm3pt1_xyzData == null) {
                    this.makeGeolData();
                }
                geol_xyzData = this.geol_Fm3pt1_xyzData;
            }
        } else if (fm == FaultModels.FM3_2) {
            neok_xyzData = this.neok_Fm3pt2_xyzData;
            zeng_b_bound_xyzData = this.zeng_b_bound_Fm3pt2_xyzData;
            abm_xyzData = this.abm_Fm3pt2_xyzData;
            if (includeGeologic) {
                if (this.geol_Fm3pt2_xyzData == null) {
                    this.makeGeolData();
                }
                geol_xyzData = this.geol_Fm3pt2_xyzData;
            }
        } else {
            throw new RuntimeException("Error - Unsupported fault model: " + String.valueOf(fm));
        }
        double sum = 0.0;
        for (int i = 0; i < aveData.size(); ++i) {
            double val = 0.0;
            int num = 0;
            if (neok_xyzData.get(i) > 2.0 * NEOK_ZERO_VALS) {
                val += neok_xyzData.get(i);
                ++num;
            }
            if (zeng_b_bound_xyzData.get(i) > 2.0 * NEOK_ZERO_VALS) {
                val += zeng_b_bound_xyzData.get(i);
                ++num;
            }
            if (abm_xyzData.get(i) > 2.0 * NEOK_ZERO_VALS) {
                val += abm_xyzData.get(i);
                ++num;
            }
            if (includeGeologic && geol_xyzData.get(i) > 2.0 * NEOK_ZERO_VALS) {
                val += geol_xyzData.get(i);
                ++num;
            }
            if (num != 0) {
                aveData.set(i, val / (double)num);
                sum += aveData.get(i);
                continue;
            }
            aveData.set(i, 0.0);
        }
        return aveData;
    }

    public GriddedGeoDataSet getAveDefModelPDF(FaultModels fm, boolean includeGeologic) {
        return DeformationModelOffFaultMoRateData.getNormalizdeData(this.getAveDefModelSpatialOffFaultMoRates(fm, includeGeologic));
    }

    public GriddedGeoDataSet getAveDefModelPDF(boolean includeGeologic) {
        GriddedGeoDataSet aveData = new GriddedGeoDataSet(griddedRegion, true);
        GriddedGeoDataSet data1 = this.getAveDefModelPDF(FaultModels.FM3_1, includeGeologic);
        GriddedGeoDataSet data2 = this.getAveDefModelPDF(FaultModels.FM3_2, includeGeologic);
        for (int i = 0; i < data1.size(); ++i) {
            aveData.set(i, data1.get(i) + data2.get(i));
        }
        return DeformationModelOffFaultMoRateData.getNormalizdeData(aveData);
    }

    public void writeAllTotalMomentRates() {
        System.out.println("For FM3.1:");
        FaultModels fm = FaultModels.FM3_1;
        System.out.println("\t" + DeformationModels.ABM.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.ABM));
        System.out.println("\t" + DeformationModels.NEOKINEMA.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.NEOKINEMA));
        System.out.println("\t" + DeformationModels.ZENG.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.ZENG));
        System.out.println("\t" + DeformationModels.GEOLOGIC.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.GEOLOGIC));
        System.out.println("\t" + DeformationModels.GEOLOGIC_PLUS_ABM.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.GEOLOGIC_PLUS_ABM));
        System.out.println("For FM3.2:");
        fm = FaultModels.FM3_2;
        System.out.println("\t" + DeformationModels.ABM.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.ABM));
        System.out.println("\t" + DeformationModels.NEOKINEMA.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.NEOKINEMA));
        System.out.println("\t" + DeformationModels.ZENG.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.ZENG));
        System.out.println("\t" + DeformationModels.GEOLOGIC.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.GEOLOGIC));
        System.out.println("\t" + DeformationModels.GEOLOGIC_PLUS_ABM.getShortName() + "\t" + (float)this.getTotalOffFaultMomentRate(fm, DeformationModels.GEOLOGIC_PLUS_ABM));
    }

    public GriddedGeoDataSet getDefModSpatialOffFaultMoRates(FaultModels fm, DeformationModels dm) {
        GriddedGeoDataSet data = null;
        if (fm == FaultModels.FM3_1) {
            switch (dm) {
                case ABM: {
                    data = this.abm_Fm3pt1_xyzData;
                    break;
                }
                case NEOKINEMA: {
                    data = this.neok_Fm3pt1_xyzData;
                    break;
                }
                case ZENG: {
                    data = this.zeng_orig_Fm3pt1_xyzData;
                    break;
                }
                case ZENGBB: {
                    data = this.zeng_b_bound_Fm3pt1_xyzData;
                    break;
                }
                case GEOLOGIC: {
                    if (this.geol_Fm3pt1_xyzData == null) {
                        this.makeGeolData();
                    }
                    data = this.geol_Fm3pt1_xyzData;
                    break;
                }
                case GEOLOGIC_PLUS_ABM: {
                    if (this.abmPlusGeol_Fm3pt1_xyzData == null) {
                        this.makeGeolData();
                    }
                    data = this.abmPlusGeol_Fm3pt1_xyzData;
                    break;
                }
                case GEOL_P_ABM_OLD_MAPPED: {
                    if (this.abmPlusGeol_Fm3pt1_xyzData == null) {
                        this.makeGeolData();
                    }
                    data = this.abmPlusGeol_Fm3pt1_xyzData;
                }
            }
        } else if (fm == FaultModels.FM3_2) {
            switch (dm) {
                case ABM: {
                    data = this.abm_Fm3pt2_xyzData;
                    break;
                }
                case NEOKINEMA: {
                    data = this.neok_Fm3pt2_xyzData;
                    break;
                }
                case ZENG: {
                    data = this.zeng_orig_Fm3pt2_xyzData;
                    break;
                }
                case ZENGBB: {
                    data = this.zeng_b_bound_Fm3pt2_xyzData;
                    break;
                }
                case GEOLOGIC: {
                    if (this.geol_Fm3pt2_xyzData == null) {
                        this.makeGeolData();
                    }
                    data = this.geol_Fm3pt2_xyzData;
                    break;
                }
                case GEOLOGIC_PLUS_ABM: {
                    if (this.abmPlusGeol_Fm3pt2_xyzData == null) {
                        this.makeGeolData();
                    }
                    data = this.abmPlusGeol_Fm3pt2_xyzData;
                }
            }
        } else {
            throw new RuntimeException("Error - unrecognized fault model: " + String.valueOf(fm));
        }
        if (dm == DeformationModels.MEAN_UCERF3) {
            ArrayList weights = Lists.newArrayList();
            ArrayList dms = Lists.newArrayList();
            double sum = 0.0;
            for (DeformationModels d : DeformationModels.values()) {
                double weight = d.getRelativeWeight(null);
                if (!(weight > 0.0)) continue;
                weights.add(weight);
                sum += weight;
                dms.add(d);
            }
            if (sum != 0.0) {
                for (int i = 0; i < weights.size(); ++i) {
                    weights.set(i, (Double)weights.get(i) / sum);
                }
            }
            data = null;
            for (int i = 0; i < dms.size(); ++i) {
                DeformationModels d = (DeformationModels)dms.get(i);
                double weight = (Double)weights.get(i);
                GriddedGeoDataSet subData = this.getDefModSpatialOffFaultMoRates(fm, d);
                if (data == null) {
                    data = new GriddedGeoDataSet(subData.getRegion(), subData.isLatitudeX());
                }
                Preconditions.checkState((subData.size() == data.size() ? 1 : 0) != 0);
                for (int j = 0; j < data.size(); ++j) {
                    data.set(j, data.get(j) + weight * subData.get(j));
                }
            }
        }
        if (data == null) {
            throw new RuntimeException("Error - unrecognized deformation model: " + String.valueOf(dm));
        }
        return data;
    }

    public GriddedGeoDataSet getDefModSpatialOffFaultPDF(FaultModels fm, DeformationModels dm) {
        return DeformationModelOffFaultMoRateData.getNormalizdeData(this.getDefModSpatialOffFaultMoRates(fm, dm));
    }

    private static int countZeroValues(GriddedGeoDataSet data) {
        int numZeros = 0;
        double sum = 0.0;
        for (int i = 0; i < data.size(); ++i) {
            if (data.get(i) <= 2.0 * NEOK_ZERO_VALS) {
                ++numZeros;
                continue;
            }
            sum += data.get(i);
        }
        return numZeros;
    }

    public static GriddedGeoDataSet getNormalizdeData(GriddedGeoDataSet data) {
        int i;
        GriddedGeoDataSet normData = new GriddedGeoDataSet(griddedRegion, true);
        double sum = 0.0;
        for (i = 0; i < data.size(); ++i) {
            sum += data.get(i);
        }
        for (i = 0; i < data.size(); ++i) {
            normData.set(i, data.get(i) / sum);
        }
        return normData;
    }

    private void testPlotMaps() {
        try {
            FaultModels fm = FaultModels.FM3_1;
            GMT_CA_Maps.plotSpatialPDF_Map(this.getDefModSpatialOffFaultPDF(fm, DeformationModels.NEOKINEMA), "NeoKinema FM3.1 PDF", "test meta data", "NeoKinema3pt1_PDF_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(this.getDefModSpatialOffFaultPDF(fm, DeformationModels.ZENG), "Zeng FM3.1 PDF", "test meta data", "Zeng3pt1_PDF_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(this.getDefModSpatialOffFaultPDF(fm, DeformationModels.ABM), "ABM FM3.1 PDF", "test meta data", "ABM_3pt1_PDF_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(this.getDefModSpatialOffFaultPDF(fm, DeformationModels.GEOLOGIC), "Geologic FM3.1 PDF", "test meta data", "Geol_3pt1_PDF_Map");
            fm = FaultModels.FM3_2;
            GMT_CA_Maps.plotSpatialPDF_Map(this.getDefModSpatialOffFaultPDF(fm, DeformationModels.NEOKINEMA), "NeoKinema FM3.2 PDF", "test meta data", "NeoKinema3pt2_PDF_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(this.getDefModSpatialOffFaultPDF(fm, DeformationModels.ZENG), "Zeng FM3.2 PDF", "test meta data", "Zeng3pt2_PDF_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(this.getDefModSpatialOffFaultPDF(fm, DeformationModels.ABM), "ABM FM3.2 PDF", "test meta data", "ABM_3pt2_PDF_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(this.getDefModSpatialOffFaultPDF(fm, DeformationModels.GEOLOGIC), "Geologic FM3.2 PDF", "test meta data", "Geol_3pt2_PDF_Map");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void plotAveDefModPDF_Map(boolean includeGeologic) {
        try {
            String info = includeGeologic ? "average of 4 deformation models (including Geologic)" : "average of 3 deformation models (excluding Geologic)";
            GMT_CA_Maps.plotSpatialPDF_Map(this.getAveDefModelPDF(FaultModels.FM3_1, includeGeologic), "Ave Def Mod PDF for  FM3.1", info, "AveDefModPDF_FM3_1_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(this.getAveDefModelPDF(FaultModels.FM3_2, includeGeologic), "Ave Def Mod PDF for  FM3.2", info, "AveDefModPDF_FM3_2_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(this.getAveDefModelPDF(includeGeologic), "Ave Def Mod PDF for both FM 3.1 and 3.2", info, "AveDefModPDF_Map");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ModMeanUCERF2 erf = new ModMeanUCERF2();
        erf.setParameter("Probability Model", "Poisson");
        erf.setParameter("Floater Type", "Only along strike ( rupture full DDW)");
        erf.setParameter(UCERF2.BACK_SEIS_NAME, UCERF2.BACK_SEIS_ONLY);
        erf.updateForecast();
        GriddedGeoDataSet ucerf2_OffFaultMoRate = ERF_Calculator.getMomentRatesInRegion(erf, RELM_RegionUtils.getGriddedRegionInstance());
        GriddedGeoDataSet ucerf2_OffFaultSeis = ERF_Calculator.getNucleationRatesInRegion(erf, RELM_RegionUtils.getGriddedRegionInstance(), 0.0, 10.0);
        try {
            GMT_CA_Maps.plotSpatialPDF_Map(DeformationModelOffFaultMoRateData.getNormalizdeData(ucerf2_OffFaultMoRate), "UCERF2 Off-Fault MoRate", "this includes the C zones", "UCERF2_OffFaultMoRatePDF_Map");
            GMT_CA_Maps.plotSpatialPDF_Map(DeformationModelOffFaultMoRateData.getNormalizdeData(ucerf2_OffFaultSeis), "UCERF2 Off-Fault Seis", "this includes the C zones", "UCERF2_OffFaultSeisPDF_Map");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public void listNumZeroValues() {
        System.out.println("neok_Fm3pt1_xyzData numZeros = " + DeformationModelOffFaultMoRateData.countZeroValues(this.neok_Fm3pt1_xyzData));
        System.out.println("zeng_orig_Fm3pt1_xyzData numZeros = " + DeformationModelOffFaultMoRateData.countZeroValues(this.zeng_orig_Fm3pt1_xyzData));
        System.out.println("zeng_b_bound_Fm3pt1_xyzData numZeros = " + DeformationModelOffFaultMoRateData.countZeroValues(this.zeng_b_bound_Fm3pt1_xyzData));
        System.out.println("abm_Fm3pt1_xyzData numZeros = " + DeformationModelOffFaultMoRateData.countZeroValues(this.abm_Fm3pt1_xyzData));
        System.out.println("neok_Fm3pt2_xyzData numZeros = " + DeformationModelOffFaultMoRateData.countZeroValues(this.neok_Fm3pt2_xyzData));
        System.out.println("zeng_orig_Fm3pt2_xyzData numZeros = " + DeformationModelOffFaultMoRateData.countZeroValues(this.zeng_orig_Fm3pt2_xyzData));
        System.out.println("zeng_b_bound_Fm3pt2_xyzData numZeros = " + DeformationModelOffFaultMoRateData.countZeroValues(this.zeng_b_bound_Fm3pt2_xyzData));
        System.out.println("abm_Fm3pt2_xyzData numZeros = " + DeformationModelOffFaultMoRateData.countZeroValues(this.abm_Fm3pt2_xyzData));
        System.out.println("(out of " + this.neok_Fm3pt2_xyzData.size() + " grid points)");
    }

    public void testAveMapDiffs() {
        GriddedGeoDataSet data1 = this.getAveDefModelPDF(FaultModels.FM3_1, false);
        GriddedGeoDataSet data2 = this.getAveDefModelPDF(FaultModels.FM3_2, false);
        double ave = 0.0;
        double min = Double.MAX_VALUE;
        double max = 0.0;
        for (int i = 0; i < data1.size(); ++i) {
            double ratio = data1.get(i) / data2.get(i);
            ave += ratio;
            if (min > ratio) {
                min = ratio;
            }
            if (!(max < ratio)) continue;
            max = ratio;
        }
        System.out.println("ave=" + (float)(ave /= (double)data1.size()) + "\tmin=" + (float)min + "\tmax=" + (float)max);
    }

    public static void main(String[] args) {
        DeformationModelOffFaultMoRateData test = DeformationModelOffFaultMoRateData.getInstance();
        test.plotAveDefModPDF_Map(false);
    }

    static {
        NEOK_ZERO_VALS = Math.pow(10.0, -1000.0) * 11.0 / 11.0;
        griddedRegion = new CaliforniaRegions.RELM_TESTING_GRIDDED();
    }
}

