/*
 * Decompiled with CFR 0.152.
 */
package scratch.UCERF3.utils;

import com.google.common.base.Preconditions;
import java.awt.Color;
import java.io.IOException;
import java.util.ArrayList;
import org.opensha.commons.data.function.EvenlyDiscretizedFunc;
import org.opensha.commons.exceptions.InvalidRangeException;
import org.opensha.commons.gui.plot.GraphWindow;
import org.opensha.commons.gui.plot.PlotCurveCharacterstics;
import org.opensha.commons.gui.plot.PlotLineType;
import org.opensha.commons.gui.plot.PlotSymbol;
import org.opensha.sha.magdist.GutenbergRichterMagFreqDist;

public class GardnerKnopoffAftershockFilter
extends EvenlyDiscretizedFunc {
    public static final double FRACT_MAINSH_GTM5 = 0.5559999999999999;
    private static GardnerKnopoffAftershockFilter instance = new GardnerKnopoffAftershockFilter(0.05, 9.95, 100);
    GutenbergRichterMagFreqDist allGR;
    GutenbergRichterMagFreqDist mainGR;

    public static double scaleForMagnitude(double m) {
        Preconditions.checkArgument((m > instance.getMinX() && m < instance.getMaxX() ? 1 : 0) != 0);
        return instance.getClosestYtoX(m);
    }

    public GardnerKnopoffAftershockFilter(double min, double max, int num) throws InvalidRangeException {
        super(min, max, num);
        this.allGR = new GutenbergRichterMagFreqDist(min, max, num);
        this.mainGR = new GutenbergRichterMagFreqDist(min, max, num);
        this.allGR.setAllButTotCumRate(this.allGR.getMinX(), this.allGR.getMaxX(), 1.0, 1.0);
        this.mainGR.setAllButTotCumRate(this.allGR.getMinX(), this.allGR.getMaxX(), 1.0, 0.8);
        int mag5index = this.allGR.getClosestXIndex(5.0 + this.allGR.getDelta() / 2.0);
        this.allGR.scaleToCumRate(mag5index, 1.0);
        this.mainGR.scaleToCumRate(mag5index, 0.5559999999999999);
        for (int i = 0; i < num; ++i) {
            double fract = this.mainGR.getY(i) / this.allGR.getY(i);
            if (fract <= 1.0) {
                this.set(i, fract);
                continue;
            }
            this.set(i, 1.0);
        }
    }

    public static EvenlyDiscretizedFunc getKarensFractions() {
        EvenlyDiscretizedFunc fracFunc = new EvenlyDiscretizedFunc(4.25, 7.25, 7);
        fracFunc.set(0, 0.35);
        fracFunc.set(1, 0.4);
        fracFunc.set(2, 0.53);
        fracFunc.set(3, 0.38);
        fracFunc.set(4, 0.8200000000000001);
        fracFunc.set(5, 0.83);
        fracFunc.set(6, 1.0);
        return fracFunc;
    }

    public void plotResults() {
        ArrayList<PlotCurveCharacterstics> plotChars = new ArrayList<PlotCurveCharacterstics>();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLACK));
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.BLUE));
        ArrayList<EvenlyDiscretizedFunc> mfds = new ArrayList<EvenlyDiscretizedFunc>();
        mfds.add(this.allGR.getCumRateDistWithOffset());
        mfds.add(this.mainGR.getCumRateDistWithOffset());
        GraphWindow graph = new GraphWindow(mfds, "Cumulative GR MFDs for Gardner-Knopoff filter", plotChars);
        graph.setX_AxisLabel("Magnitude");
        graph.setY_AxisLabel("Normalized Rate");
        graph.setAxisLabelFontSize(18);
        graph.setPlotLabelFontSize(20);
        graph.setTickLabelFontSize(16);
        graph.setX_AxisRange(5.0, 8.0);
        graph.setY_AxisRange(1.0E-4, 2.0);
        graph.setYLog(true);
        try {
            graph.saveAsPDF("mfdsForGardnerKnopoffFilter.pdf");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        ArrayList<GutenbergRichterMagFreqDist> incrMFDs = new ArrayList<GutenbergRichterMagFreqDist>();
        incrMFDs.add(this.allGR);
        incrMFDs.add(this.mainGR);
        GraphWindow graph2 = new GraphWindow(incrMFDs, "Incremental GR MFDs for Gardner-Knopoff filter", plotChars);
        graph2.setX_AxisLabel("Magnitude");
        graph2.setY_AxisLabel("Normalized Rate");
        graph2.setAxisLabelFontSize(18);
        graph2.setPlotLabelFontSize(20);
        graph2.setTickLabelFontSize(16);
        graph2.setX_AxisRange(5.0, 8.0);
        graph2.setY_AxisRange(0.001, 20.0);
        graph2.setYLog(true);
        try {
            graph2.saveAsPDF("incrMFDsForGardnerKnopoffFilter.pdf");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        plotChars = new ArrayList();
        plotChars.add(new PlotCurveCharacterstics(PlotLineType.SOLID, 2.0f, Color.RED));
        plotChars.add(new PlotCurveCharacterstics(PlotSymbol.FILLED_TRIANGLE, 5.0f, Color.BLACK));
        ArrayList<EvenlyDiscretizedFunc> filters = new ArrayList<EvenlyDiscretizedFunc>();
        filters.add(this);
        filters.add(GardnerKnopoffAftershockFilter.getKarensFractions());
        GraphWindow graph3 = new GraphWindow(filters, "Gardner-Knopoff filter", plotChars);
        graph3.setX_AxisLabel("Magnitude");
        graph3.setY_AxisLabel("Fraction Mainshocks (Incremental Distribution)");
        graph3.setAxisLabelFontSize(18);
        graph3.setPlotLabelFontSize(20);
        graph3.setTickLabelFontSize(16);
        graph3.setX_AxisRange(5.0, 8.0);
        graph3.setY_AxisRange(0.0, 1.2);
        try {
            graph3.saveAsPDF("GardnerKnopoffFilter.pdf");
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void main(String[] args) {
        GardnerKnopoffAftershockFilter test = new GardnerKnopoffAftershockFilter(0.05, 9.95, 100);
        test.plotResults();
    }
}

